CREATE TABLE `comm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `desc` text NOT NULL,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  `id_cat` int(11) NOT NULL DEFAULT '0',
  `visits` int(11) NOT NULL DEFAULT '0',
  `adult` enum('0','1') NOT NULL DEFAULT '0',
  `chat` enum('0','1') NOT NULL DEFAULT '0',
  `forum` enum('0','1') NOT NULL DEFAULT '1',
  `files` enum('0','1') NOT NULL DEFAULT '0',
  `join_rule` enum('1','2','3') NOT NULL DEFAULT '1',
  `read_rule` enum('1','2') NOT NULL DEFAULT '1',
  `write_rule` enum('1','2') NOT NULL DEFAULT '1',
  `chat_rule` enum('1','2') NOT NULL DEFAULT '1',
  `deviz` text NOT NULL,
  `interests` text NOT NULL,
  `rules` text NOT NULL,
  `mdi` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

CREATE TABLE `comm_blist` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_comm` int(11) DEFAULT NULL,
  `id_user` int(11) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

CREATE TABLE `comm_cat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `desc` text NOT NULL,
  `pos` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

CREATE TABLE `comm_readmin` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_comm` int(11) DEFAULT '0',
  `id_user` int(11) DEFAULT '0',
  `time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

CREATE TABLE `comm_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_comm` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `activate` enum('0','1') DEFAULT '1',
  `invite` enum('0','1') DEFAULT '0',
  `invite_user` int(11) DEFAULT NULL,
  `access` enum('creator','adm','mod','user') DEFAULT 'user',
  `time` int(11) NOT NULL,
  `last_time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

CREATE TABLE `comm_journal` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_comm` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `id_ank` int(11) NOT NULL,
  `type` enum('in_blist','out_blist','in_comm','out_comm','access') DEFAULT NULL,
  `access` enum('creator','adm','mod','user') DEFAULT 'user',
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

CREATE TABLE `comm_users_ban` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_comm` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `id_ank` int(11) NOT NULL,
  `type` enum('forum','chat') DEFAULT NULL,
  `reason` enum('1','2','3','4','5','6') DEFAULT NULL,
  `time_ban` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `msg` varchar(512),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

CREATE TABLE `comm_visits` (
  `time` int(11) NOT NULL,
  `id_comm` int(11) NOT NULL,
  `id_user` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `comm_forum` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_comm` int(11) NOT NULL DEFAULT '0',
  `name` text NOT NULL,
  `desc` text NOT NULL,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  `id_cat` int(11) NOT NULL DEFAULT '0',
  `type` enum('cat', 'topic') DEFAULT NULL,
  `msg` TEXT,
  `pos` int(11) NOT NULL DEFAULT '0',
  `locked` enum('0','1') NOT NULL DEFAULT '0',
  `locked_user` int(11) NOT NULL DEFAULT '0',
  `locked_time` int(11) NOT NULL DEFAULT '0',
  `last_user` int(11) NOT NULL DEFAULT '0',
  `last_time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

CREATE TABLE `comm_forum_komm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_comm` int(11) NOT NULL DEFAULT '0',
  `id_user` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  `id_topic` int(11) NOT NULL DEFAULT '0',
  `sk` enum('0','1') NOT NULL DEFAULT '0',
  `sk_user` int(11) NOT NULL DEFAULT '0',
  `id_reply` int(11) NOT NULL DEFAULT '0',
  `reply_msg` TEXT,
  `msg` TEXT,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

ALTER TABLE `user` ADD `time_comm_topic` int(11) NOT NULL;

CREATE TABLE `comm_chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_comm` int(11) NOT NULL,
  `id_user` int(11) DEFAULT NULL,
  `time` int(11) NOT NULL,
  `message` varchar(1024) DEFAULT NULL,
  `reply` int(11) DEFAULT NULL,
  `reply_msg` TEXT,
  `private` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id_comm` (`id_comm`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

CREATE TABLE `chat_comm_who` (
  `id_user` int(11) NOT NULL,
  `id_comm` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  KEY `id_user` (`id_user`,`id_comm`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `comm_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_comm` int(11) NOT NULL,
  `id_user` int(11) DEFAULT NULL,
  `id_dir` int(11) DEFAULT NULL,
  `time` int(11) NOT NULL,
  `name` varchar(40) DEFAULT NULL,
  `ras` varchar(512) DEFAULT NULL,
  `desc` text DEFAULT NULL,
  `type` enum('dir','file') DEFAULT NULL,
  `counter` text DEFAULT NULL,
  `rating` int(11) NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `id_comm` (`id_comm`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

CREATE TABLE `comm_files_komm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_comm` int(11) NOT NULL DEFAULT '0',
  `id_user` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  `id_file` int(11) NOT NULL DEFAULT '0',
  `sk` enum('0','1') NOT NULL DEFAULT '0',
  `sk_user` int(11) NOT NULL DEFAULT '0',
  `id_reply` int(11) NOT NULL DEFAULT '0',
  `reply_msg` TEXT,
  `msg` TEXT,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

CREATE TABLE `comm_files_rating` (
  `id_file` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `id_comm` int(11) NOT NULL,
  KEY `id_file` (`id_file`,`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;