<?
include_once '../../sys/inc/start.php';
include_once '../../sys/inc/compress.php';
include_once '../../sys/inc/sess.php';
include_once '../../sys/inc/home.php';
include_once '../../sys/inc/settings.php';
include_once '../../sys/inc/db_connect.php';
include_once '../../sys/inc/ipua.php';
include_once '../../sys/inc/fnc.php';
include_once '../../sys/inc/user.php';
$set['title']='Учебник JavaScript';
include_once '../../sys/inc/thead.php';
title();
err();
//aut();
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<TITLE>Дополнительные Статьи</TITLE>
<BODY>
<h5><a href="contents.php">Оглавление</a> | <a href="windows.php">Назад</a>
| <a href="sec.php">Вперёд</a> | <a href="bklast.php">Индекс</a></h5><HR>
<h1>Глава 13<BR><a name="996824"></a>Дополнительные Статьи</h1>
<p><A NAME="997436"></a>В этой главе рассматриваются некоторые специальные 
понятия и приложения, расширяющие мощь и гибкость JavaScript.</p>
<p><A NAME="1016959"></a>В главе имеются следующие разделы:</p><ul><LI><A NAME="1017018"></a>
<a href="#1004952">Использование JavaScript-URL</a></LI><LI><A NAME="1017022"></a>
<A HREF="#1006105">Использование клиентских карт изображений</a></LI><LI><A NAME="1017026"></a>
<a href="#1006224">Использование серверных карт изображений</a></LI><LI><A NAME="1014408"></a>
<a href="#1006028">Использование статусной строки</a></LI><LI><A NAME="1014413"></a>
<a href="#1017771">Использование кук</a></LI><LI><A NAME="1014423"></a>
<a href="#1012507">Определение установленных Plug-in'ов</LI></ul><H2><A NAME="Using JavaScript URLs">
<A NAME="1004952"></a>Использование JavaScript-URL</H2><hr><p><A NAME="1006101"></a>
Вам, возможно, уже знакомы стандартные типы URL: <CODE>http:</CODE>, <CODE>ftp:</CODE>, <CODE>file:</CODE> 
и так далее. В Navigator&#39;е Вы можете использовать 
также URL типа <CODE>javascript:</CODE> для выполнения операторов JavaScript 
вместо загрузки документа. Вы просто используете строку, начинающуюся с <CODE>javascript:</CODE>, 
в качестве значения атрибута <CODE>HREF</CODE> тэгов anchor. Например, Вы можете 
определить такую гиперссылку для перезагрузки текущей страницы:</p>
<PRE><A NAME="1006111"></a>&lt;A HREF="javascript:history.go(0)"&gt;Reload Now&lt;/A&gt;</PRE>
<p><A NAME="1006112"></a>В общем, Вы можете поместить любой оператор или вызов функции после префикса <CODE>javascript:</CODE> в URL.</p>
<p><A NAME="1006113"></a>Можно по-разному использовать JavaScript-URL для добавления функциональности в 
Ваши приложения. Например, можно выполнить инкремент счётчика <CODE>p1</CODE> в 
родительском фрэйме, если пользователь щёлкает по гиперссылке, с помощью такой функции:</p>
<PRE><A NAME="1006127"></a>function countJumps() {<br>&nbsp;&nbsp;&nbsp;parent.p1++<br>&nbsp;&nbsp;&nbsp;window.location=page1<br>}</PRE>
<p><A NAME="1007950"></a>Для вызова этой функции используйте JavaScript-URL в стандартной гиперссылке HTML:</p>
<PRE><A NAME="1007937"></a>&lt;A HREF="javascript:countJumps()"&gt;Page 1&lt;/A&gt;</PRE>
<p><A NAME="1006109"></a>Здесь предполагается, что <CODE>page1</CODE> это строка, представляющая URL.</p>
<p><A NAME="1013346"></a>Если значение выражения, идущего после URL-префикса <CODE>javascript:</CODE>, 
вычисляется в undefined, новый документ не загружается. Если значение 
вычисляется в определённый тип, значение конвертируется в строку, которая 
специфицирует источник загружаемого документа.</p><H2><A NAME="Using Client-Side Image Maps">
<A NAME="1006105"></a>Использование клиентских карт изображений</H2><hr><p><A NAME="1006034"></a>
Клиентская карта изображений определяется тэгом <CODE>MAP</CODE>. Вы можете 
определить области на изображении, которые являются гиперссылками на различные 
URL; области могут быть прямоугольными, круглыми и многоугольными.</p><p><A NAME="1006168"></a>
Вместо стандартных URL Вы можете использовать в клиентских картах JavaScript-URL, например:</p>
<PRE><A NAME="1006059"></a>&lt;MAP NAME="buttonbar"&gt;<br>&lt;AREA SHAPE="RECT" COORDS="0,0,16,14" <br>&nbsp;&nbsp;&nbsp;HREF ="javascript:top.close(); window.location = newnav.phpl"&gt;<br>&lt;AREA SHAPE="RECT" COORDS="0,0,85,46" <br>&nbsp;&nbsp;&nbsp;HREF="contents.phpl" target="javascript:alert(`Loading <br>&nbsp;&nbsp;&nbsp;Contents.'); top.location = contents.phpl"&gt;<br>&lt;/MAP&gt;</PRE>
<H2><A NAME="Using Server-Side Image Maps"><A NAME="1006224"></a>Использование серверных 
карт изображений</H2><hr>
<p><A NAME="1013514"></a>Клиентские карты предоставляют функциональность для выполнения большинства задач, 
но стандартные (иногда называемые серверными) карты изображений придают ещё 
большую гибкость. Вы специфицируете стандартную карту тэгом атрибутом <CODE>ISMAP</CODE> 
в тэге <CODE>IMG</CODE>, который является гиперссылкой. Например,</p>
<PRE><A NAME="1006271"></a>&lt;A HREF="img.phpl"&gt;&lt;IMG SRC="about:logo" BORDER=0 ISMAP&gt;&lt;/A&gt;</PRE>
<p><A NAME="1006246"></a>Если Вы щёлкаете по изображению с атрибутом <CODE>ISMAP</CODE>, Navigator запрашивает URL в такой форме:</p>
<PRE><A NAME="1006228"></a>URL?x,y</PRE><p><A NAME="1014987"></a>
где <CODE>URL</CODE> это документ, специфицированный значением атрибута <CODE>HREF</CODE>, 
а <CODE>x</CODE> и <CODE>y</CODE> это горизонтальная и вертикальная координаты 
указателя мыши (в пикселах от верхнего левого угла изображения) во время щелчка. (Изображение "about:logo" 
встроено в Navigator и отображает логотипом Netscape.)</p><p><A NAME="1008389"></a>
Запросы карт традиционно отправляются на сервер, где CGI-программа выполняет 
функцию просмотра базы данных. С помощью клиентского JavaScript, однако, Вы 
можете просматривать на стороне клиента. Можно использовать свойство <CODE>search</CODE> 
объекта <CODE>location</CODE> для разбора координат <CODE>x</CODE> и <CODE>y</CODE> 
и выполнения соответствующей акции. Например,  у Вас имеется файл <CODE>img.phpl</CODE> 
со следующим содержимым:</p>
<PRE><A NAME="1006279"></a>&lt;H1&gt;Click on the image&lt;/H1&gt;<br>&lt;P&gt;<br>&lt;A HREF="img.phpl"&gt;&lt;IMG SRC="about:logo" BORDER=0 ISMAP&gt;&lt;/A&gt;<br>&lt;SCRIPT&gt;<br>str = location.search<br>if (str == "") <br>&nbsp;&nbsp;&nbsp;document.write("&lt;P&gt;No coordinates specified.")<br>else {<br>&nbsp;&nbsp;&nbsp;commaloc = str.indexOf(",") // местонахождение запятой<br>&nbsp;&nbsp;&nbsp;document.write("&lt;P&gt;The x value is " + str.substring(1, commaloc))<br>&nbsp;&nbsp;&nbsp;document.write("&lt;P&gt;The y value is " + <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;str.substring(commaloc+1, str.length))<br>}<br>&lt;/SCRIPT&gt;</PRE>
<p><A NAME="1006748"></a>Если Вы щёлкаете по изображению, Navigator перезагружает страницу (поскольку 
атрибут <CODE>HREF</CODE> специфицирует тот же самый документ), добавляя в URL 
координаты <CODE>x</CODE> и <CODE>y</CODE> щелчка мыши. Операторы блока <CODE>else</CODE> 
отображают затем координаты <CODE>x</CODE> и <CODE>y</CODE>. На практике Вы 
можете перенаправлять на другую страницу (устанавливая location) или выполнять 
какое-нибудь другое действие на основе значений <CODE>x</CODE> и <CODE>y</CODE>.</p>
<H2><A NAME="Using the Status Bar"><A NAME="1006028"></a>Использование статусной 
строки</H2><hr><p><A NAME="1006029"></a>
Вы можете использовать два свойства объекта <CODE>window</CODE>, <CODE>status</CODE> 
и <CODE>defaultStatus</CODE>, для отображения сообщений в статусной строке Navigator&#39;а 
в нижней части окна. Navigator обычно использует status bar для вывода таких 
сообщений, как "Contacting Host..." и "Document: Done." Сообщение <CODE>defaultStatus</CODE> 
появляется, если в статусной строке больше ничего нет. Свойство <CODE>status</CODE> 
отображает временное сообщение, как, например, при проведении указателя мыши над гиперссылкой. </p>
<p><A NAME="1006353"></a>Можно настроить эти свойства для отображения специальных сообщений. Например, 
чтобы вывести специальное сообщение по окончании загрузки документа, просто 
установите <CODE>defaultStatus</CODE>. Например,</p>
<PRE><A NAME="1006402"></a>defaultStatus = "Some rise, some fall, some climb...to get to Terrapin"</PRE>
<H3><A NAME="Head2;"></a><A NAME="1006409"></a>Создание подсказок обработчиками onMouseOver и onMouseOut</H3>
<hr><p><A NAME="1006423"></a>По умолчанию, если Вы проводите указатель мыши над гиперссылкой, в статусной 
строке отображается URL назначения гиперссылки. Вы можете установить <CODE>status</CODE> 
в обработчиках <CODE>onMouseOut</CODE> и <CODE>onMouseOver</CODE> гиперссылки 
или области изображения для отображения подсказок в статусной строке. Обработчик 
события обязан возвращать true для установки значения <CODE>status</CODE>. Например,</p>
<PRE><A NAME="1006412"></a>&lt;A HREF="contents.phpl"<br>&nbsp;&nbsp;&nbsp;onMouseOver="window.status='Click to display contents';return true"&gt;<br>Contents<br>&lt;/A&gt;</PRE>
<p><A NAME="1017768"></a>В это примере подсказка "Click to display contents" выводится в статусной 
строке, когда указатель мыши проходит над гиперссылкой.</p><H2><A NAME="Using Cookies">
<a name="1017771"></a>Использование кук</H2><hr><p><A NAME="1017773"></a>
<i>Куки </i>Netscape это механизм хранения данных на клиенте в файле <CODE>cookies.txt</CODE>. 
Поскольку HyperText Transport Protocol (HTTP) это бесстатусный/stateless 
протокол, куки являются способом обслуживания информации в промежутках между клиентскими 
запросами. В этом разделе обсуждаются основы использования кук/cookies и дан 
простой пример. Полное описание кук см. в книге<a TARGET="_top" href="../clientref13/index.php"> <I>
Клиентский JavaScript. </I><a href="../clientref13/index.php"><i>Справочник</i></a>.</p>
<p><A NAME="1013108"></a>Кука это небольшой блок информации, иногда имеющий строк действия и добавляемый 
в cookie-файл в следующем формате:</p><PRE><A NAME="1013109"></a>name=value;expires=expDate;</PRE>
<p><A NAME="1013111"></a><CODE>name</CODE> это имя хранимых данных, а <CODE>value</CODE> это значение. 
Если <CODE>name</CODE> и <CODE>value</CODE> содержат одну запятую, точку с 
запятой или пробелы, Вы обязаны использовать функцию <CODE>escape</CODE> для их 
кодирования и функцию <CODE>unescape</CODE> - для декодирования.</p><p><A NAME="1013117"></a>
<CODE>expDate</CODE> это дата окончания срока действия в GMT-формате даты:</p>
<PRE><A NAME="1013118"></a>Wdy, DD-Mon-YY HH:MM:SS GMT</PRE><p><A NAME="1013119"></a>
Хотя он слегка отличается от формата строки даты, возвращаемой методом <CODE>toGMTString</CODE> 
объекта <CODE>Date</CODE>, метод <CODE>toGMTString</CODE> можно использовать для установки срока действия куки.</p>
<p><A NAME="1013122"></a>Дата-срок действия куки является параметром по выбору/optional, указывающим 
срок действия куки. Если <CODE>expDate</CODE> не специфицирован, кука перестаёт 
действовать после выхода пользователя из текущей сессии Navigator&#39;а. Navigator 
обслуживает и запрашивает куку, только если строк действия куки ещё не передан. </p><p><A NAME="1014850"></a>
О функциях <CODE>escape</CODE> и <CODE>unescape</CODE> см. книгу
<a TARGET="_top" href="../clientref13/index.php"> <I>Клиентский JavaScript. </I>
<a href="../clientref13/index.php"><i>Справочник</i></a>.</p><H3><A NAME="Head2;"></a><a name="1013124"></a>Ограничения</H3>
<hr><p><A NAME="1013125"></a>Куки имеют следующие ограничения:</p><ul><LI><A NAME="1013126"></a>
всего 300 кук в cookie-файле.</LI><LI><A NAME="1013127"></a>
4 Kb на одну куку как сумму имени и значения.<LI><A NAME="1013128"></a>
20 кук на сервер или домен (полностью специфицированные хосты и домены 
рассматриваются как отдельные объекты и имеют ограничение в 20 кук каждый, не суммируясь).</LI></ul>
<p><A NAME="1013129"></a>Куки могут ассоциироваться с одной или несколькими директориями. Если все Ваши 
файлы находятся в одной директории/каталоге, Вы не должны беспокоиться об этом. 
Если Ваши файлы находятся в разных каталогах, Вам может понадобится 
использовать дополнительный параметр пути для каждой куки. Дополнительно см. книгу
<a TARGET="_top" href="../clientref13/index.php"> <I>Клиентский JavaScript. </I>
<a href="../clientref13/index.php"><i>Справочник</i></a>.</p><H3><A NAME="Head2;"></a>
<A NAME="1013134"></a>Использование кук в JavaScript</H3><hr><p><A NAME="1013135"></a>
Свойство <CODE>document.cookie</CODE> это строка, содержащая имена и 
значения всех кук Navigator'а. Вы можете использовать это свойство для работы с куками в JavaScript.</p>
<p><A NAME="1013136"></a>Вот что Вы можете делать с куками:</p>
<ul><LI><A NAME="1013137"></a>
Устанавливать значение куки, специфицируя, по выбору, срок действия куки.</LI><LI><A NAME="1013138"></a>
Получить значение куки, задав её имя.</LI></ul><p><A NAME="1014868"></a>
Для выполнения этих задач удобно определить функцию. Вот, например, функция, 
устанавливающая значение и дату окончания действия куки:</p>
<PRE><A NAME="1013140"></a>// Установить значение куки. Дата окончания действия - не обязательна.<br>//<br>function setCookie(name, value, expire) {<br>&nbsp;&nbsp;&nbsp;document.cookie = name + "=" + escape(value)<br>&nbsp;&nbsp;&nbsp;+ ((expire == null) ? "" : ("; expires=" + expire.toGMTString()))<br>}</PRE>
<p><A NAME="1013142"></a>Обратите внимание на использование функции <CODE>escape</CODE> для кодирования 
специальных символов (точки с запятой, запятой, пробелов) в строке-значении. Эта 
функция принимает, что имена кук не содержат специальных символов.</p><p><A NAME="1013143"></a>
Следующая функция возвращает значение куки, задавая имя куки:</p>
<PRE><A NAME="1013144"></a>function getCookie(Name) {<br>&nbsp;&nbsp;&nbsp;var search = Name + "="<br>&nbsp;&nbsp;&nbsp;if (document.cookie.length &gt; 0) { // если есть какие-либо куки<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;offset = document.cookie.indexOf(search) <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;if (offset != -1) { // если кука существует <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;offset += search.length <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;// установить индекс начала значения<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;end = document.cookie.indexOf(";", offset) <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;// установить индекс конца значения куки<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;if (end == -1) <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;end = document.cookie.length<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;return unescape(document.cookie.substring(offset, end))<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} <br>&nbsp;&nbsp;&nbsp;}<br>}</PRE>
<p><A NAME="1013146"></a>Обратите внимание на использование функции <CODE>unescape</CODE> для 
декодирования специальных символов в значении куки.</p><H3><A NAME="Head2;"></a><A NAME="1013148"></a>Использование 
кук: пример</H3>
<hr><p><A NAME="1013149"></a>Используя cookie-функции, определённы в предыдущем разделе, Вы можете создать 
простую страницу, которую пользователи могут заполнить для "регистрации" при 
посещении Вашей страницы. Если они будут повторно посещать Вашу страницу в течение года, они будут получать персональное приветствие. </p>
<p><A NAME="1013150"></a>Вам необходимо определить дополнительно ещё одну функцию в HEAD/шапке документа. 
Эта функция, <CODE>register</CODE>, создаёт куку <CODE>TheCoolJavaScriptPage</CODE> 
и значение, передаваемое ей - в качестве аргумента.</p>
<PRE><A NAME="1013151"></a>function register(name) {<br>&nbsp;&nbsp;&nbsp;var today = new Date()<br>&nbsp;&nbsp;&nbsp;var expires = new Date()<br>&nbsp;&nbsp;&nbsp;expires.setTime(today.getTime() + 1000*60*60*24*365)<br>&nbsp;&nbsp;&nbsp;setCookie("TheCoolJavaScriptPage", name, expires)<br>}</PRE>
<p><A NAME="1013152"></a>BODY документа использует <CODE>getCookie</CODE> 
(определённую в предыдущем 
разделе) для проверки существования куки <CODE>TheCoolJavaScriptPage</CODE> и 
выводит приветствие, если кука имеется. Имеется также форма, которая вызывает <CODE>register</CODE> 
для добавления куки. Обработчик <CODE>onClick</CODE> вызывает также <CODE>history.go(0)</CODE> 
для перерисовки страницы.</p>
<PRE><A NAME="1013154"></a>&lt;BODY&gt;<br>&lt;H1&gt;Register Your Name with the Cookie-Meister&lt;/H1&gt;<br>&lt;P&gt;<br>&lt;SCRIPT&gt;<br>var yourname = getCookie("TheCoolJavaScriptPage") <br>if (yourname != null)<br>&nbsp;&nbsp;&nbsp;document.write("&lt;P&gt;Welcome Back, ", yourname)<br>else<br>&nbsp;&nbsp;&nbsp;document.write("&lt;P&gt;You haven't been here in the last year...")<br>&lt;/SCRIPT&gt;</PRE><PRE><A NAME="1013155"></a>&lt;P&gt; Enter your name. When you return to this page within a year,
you will be greeted with a personalized greeting. <br>&lt;BR&gt;<br>&lt;FORM onSubmit="return false"&gt;<br>Enter your name: &lt;INPUT TYPE="text" NAME="username" SIZE= 10&gt;&lt;BR&gt;<br>&lt;INPUT TYPE="button" value="Register"<br>&nbsp;&nbsp;&nbsp;onClick="register(this.form.username.value); history.go(0)"&gt;<br>&lt;/FORM&gt;</PRE>
<H2><A NAME="Determining Installed Plug-ins"><A NAME="1012507"></a>Определение установленных Plug-in'ов</H2><hr>
<p><A NAME="1012511"></a>Вы можете использовать JavaScript для того чтобы определить, имеется ли у 
пользователя определённый установленный plug-in; затем Вы можете отобразить 
данные внедрённого plug-in'а, если plug-in установлен, 
или вывести какую-нибудь другую информацию (например, рисунок или текст), если 
не установлен. Вы можете также определить, может ли клиент обрабатывать 
определённый MIME-тип (Multipart Internet Mail Extension). В этом разделе даны 
объекты и свойства, необходимые для обработки plug-in'ов 
и MIME-типов. Более детальную информацию об этих объектах и свойствах см. в книге
<a TARGET="_top" href="../clientref13/index.php"> <I>Клиентский JavaScript. </I>
<a href="../clientref13/index.php"><i>Справочник</i></a>.</p><p><A NAME="1008429"></a>
Объект <CODE>navigator</CODE> имеет два свойства для проверки установленных 
plug-in'ов: массив <CODE>mimeTypes</CODE> и массив <CODE>plugins</CODE>.</p><H3><A NAME="Head2;"></a>
<A NAME="1008555"></a>Массив mimeTypes</H3><hr><p><A NAME="1008430"></a>
<CODE>mimeTypes</CODE> это массив всех MIME-типов, поддерживаемых клиентом (внутренне 
- через вспомогательные приложения, или с помощью plug-in'ов). 
Каждый элемент массива является <CODE>MimeType</CODE>-объектом, который имеет 
свойства своего типа, описание, расширение файла и подключённые plug-in'ы.</p>
<p><A NAME="1008657"></a>Например, в следующей таблице даны значения для вывода JPEG-изображений.</p>
<A NAME="1016898"></a><h6 style="text-align: center"><B></B><A NAME="1008631"></a>
Таблица 13.1 Значения свойства <CODE>MimeType</CODE> для рисунков JPEG</h6><TABLE BORDER="2" CELLPADDING=5>
<TR><TH><A NAME="1008635"></a>Выражение<TH><A NAME="1008637"></a>
Значение<TR><TD><PRE><A NAME="1008639"></a>navigator.mimeTypes["image/jpeg"].type</PRE><TD><PRE><A NAME="1008641"></a>image/jpeg</PRE>
<TR><TD><PRE><A NAME="1008643"></a>navigator.mimeTypes["image/jpeg"].description</PRE><TD><PRE><A NAME="1008645"></a>JPEG Image</PRE>
<TR><TD><PRE><A NAME="1008647"></a>navigator.mimeTypes["image/jpeg"].suffixes</PRE><TD><PRE><A NAME="1008649"></a>jpeg, jpg, jpe, jfif, pjpeg, pjp</PRE>
<TR><TD><PRE><A NAME="1008651"></a>navigator.mimeTypes["image/jpeg"].enabledPlugin</PRE><TD><PRE><A NAME="1008653"></a>null</PRE></TABLE>
<p><A NAME="1008585"></a>Следующий скрипт проверяет, может ли клиент работать с клипами QuickTime:</p>
<PRE><A NAME="1008701"></a>var myMimetype = navigator.mimeTypes["video/quicktime"]<br>if (myMimetype)<br>&nbsp;&nbsp;&nbsp;document.writeln("Click &lt;A HREF='movie.qt'&gt;here&lt;/A&gt; to см. a " +<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;myMimetype.description)<br>else<br>&nbsp;&nbsp;&nbsp;document.writeln("Too bad, can't show you any movies.")</PRE>
<H3><A NAME="Head2;"></a><A NAME="1008559"></a>Массив plugins</H3><hr><p><A NAME="1008431"></a><CODE>plugins</CODE> это массив всех plug-in'ов, 
установленных в данный момент на клиенте. Каждый элемент массива является <CODE>Plugin</CODE>-объектом, 
имеющим свойства для своего имени, имени файла и описание, а также массив <CODE>MimeType</CODE>-объектов 
для MIME-тпов, поддерживаемых данным plug-in'ом. 
Пользователь может получить список установленных plug-in'ов, 
выбрав меню About Plug-ins из Help. Например, в следующей таблице резюмируются 
значения для plug-in'ов LiveAudio.</p><A NAME="1016924"></a><h6 style="text-align: center"><B></B><A NAME="1010596"></a>
Таблица 13.2 Значения свойств <CODE>Plugin</CODE> для plug-in'а LiveAudio</h6>
<TABLE BORDER="2" CELLPADDING=5 width="100%"><TR><TH width="336"></a><A NAME="1010600"></a>
Выражение<TH width="436"></a><A NAME="1010602"></a>
Значение<TR><TD width="336"></a><PRE><A NAME="1010604"></a>navigator.plugins['LiveAudio'].name</PRE>
<TD width="436"></a><PRE><A NAME="1010606"></a>LiveAudio</PRE>
<TR><TD width="336"></a><PRE><A NAME="1010608"></a>navigator.plugins['LiveAudio'].description</PRE>
<TD width="436"></a><PRE><A NAME="1010610"></a>LiveAudio - Netscape Navigator sound
<A NAME="1010610"></a>playing component</PRE>
<TR><TD width="336"></a><PRE><A NAME="1010612"></a>navigator.plugins['LiveAudio'].filename</PRE>
<TD width="436"></a><PRE><A NAME="1010645"></a>d:\nettools\netscape\nav30\<br>Program\plugins\NPAUDIO.DLL</PRE>
<TR><TD width="336"></a><PRE><A NAME="1010616"></a>navigator.plugins['LiveAudio'].length</PRE>
<TD width="436"></a><PRE><A NAME="1010618"></a>7</PRE></TABLE><p><A NAME="1010659"></a>
В <A HREF="#1010596">Таблице 13.2</a> значение свойства <CODE>length</CODE> 
указывает, что <CODE>navigator.plugins['LiveAudio']</CODE> имеет массив объектов <CODE>MimeType</CODE>, 
содержащий 7 элементов. Значения свойств второго элемента этого массива показаны в следующей таблице.</p>
<A NAME="1016942"></a><h6 style="text-align: center"><B></B><A NAME="1010667"></a>
Таблица 13.3 Значения <CODE>MimeType</CODE> для plug-in'а LiveAudio</h6>
<TABLE BORDER="2" CELLPADDING=5><TR><TH><A NAME="1010671"></a>Выражение<TH><A NAME="1010673"></a>
Значение<TR><TD><PRE><A NAME="1010675"></a>navigator.plugins['LiveAudio'][1].type</PRE><TD><PRE><A NAME="1010677"></a>audio/x-aiff</PRE>
<TR><TD><PRE><A NAME="1010679"></a>navigator.plugins['LiveAudio'][1].description</PRE><TD><PRE><A NAME="1010681"></a>AIFF</PRE>
<TR><TD><PRE><A NAME="1010683"></a>navigator.plugins['LiveAudio'][1].suffixes</PRE><TD><PRE><A NAME="1010685"></a>aif, aiff</PRE>
<TR><TD><PRE><A NAME="1010687"></a>navigator.plugins['LiveAudio'][1].enabledPlugin.name</PRE><TD><PRE><A NAME="1010689"></a>LiveAudio</PRE>
</TABLE><p><A NAME="1008571"></a>Следующий скрипт проверяет, установлен ли Shockwave plug-in, и отображает 
внедрённый Shockwave-клип, если это так:</p>
<PRE><A NAME="1008572"></a>var myPlugin = navigator.plugins["Shockwave"]<br>if (myPlugin)<br>&nbsp;&nbsp;&nbsp;document.writeln("&lt;EMBED SRC='Movie.dir' HEIGHT=100 WIDTH=100&gt;")<br>else<br>&nbsp;&nbsp;&nbsp;document.writeln("You don't have Shockwave installed!")</PRE>
<h5><a href="contents.php">Оглавление</a> | <a href="windows.php">Назад</a> | <a href="sec.php">Вперёд</a>
| <a href="bklast.php">Индекс</a></h5><hr>
</BODY></HTML>
<?
include_once '../../sys/inc/tfoot.php';
?>