<?
include_once '../../sys/inc/start.php';
include_once '../../sys/inc/compress.php';
include_once '../../sys/inc/sess.php';
include_once '../../sys/inc/home.php';
include_once '../../sys/inc/settings.php';
include_once '../../sys/inc/db_connect.php';
include_once '../../sys/inc/ipua.php';
include_once '../../sys/inc/fnc.php';
include_once '../../sys/inc/user.php';
$set['title']='Учебник JavaScript';
include_once '../../sys/inc/thead.php';
title();
err();
//aut();
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<phpl<TITLE>Обработка Событий</TITLE>
<BODY>
<h5><a href="contents.php">Оглавление</a> | <a href="embed.php">Назад</a>
| <a href="navobj.php">Вперёд</a> | <a href="bklast.php">Индекс</a></h5><HR>
<h1>Глава 10<BR><a name="1009710"></a>Обработка Событий</h1><p><A NAME="1009771"></a>
Приложения JavaScript в браузере Navigator широко используют механизм обработки событий. <I>
Events\События</I> это акции, которые обычно возникают как результат некоторых 
действий пользователя. Например, щелчок по кнопке является событием, также как и 
изменение текста или перемещение мыши над гиперссылкой. Чтобы Ваш скрипт 
реагировал на события, Вы определяете <I>event handlers\обработчики событий</I>, 
такие как onChange и onClick.</p><p><A NAME="1012854"></a>В главе имеются следующие разделы:</p>
<ul><LI><A NAME="1012855"></a><a href="#1009606">Определение обработчика события</a></LI><LI><A NAME="1012856"></a>
<A HREF="#1012525">Объект Event</a></LI><LI><A NAME="1013178"></a>
<a href="#1010131">Захват событий</a></LI><LI><A NAME="1013179"></a><a href="#1012961">Проверка 
  данных, введённых в форму</a></LI></ul>
<p><A NAME="1013641"></a>Об обработке событий см. дополнительно статью <EM><A HREF="http://developer.netscape.com/viewsource/goodman_events.phpl" TARGET="_top">Getting Ready for JavaScript 1.2 Events</a></EM> 
в онлайновом <A HREF="http://developer.netscape.com/viewsource/" TARGET="_top">View Source magazine</a>. 
Также <A HREF="http://developer.netscape.com/docs/technote/" TARGET="_top">JavaScript technical notes</a> 
содержат информацию о программировании событий.</p><p><A NAME="1010827"></a>В таблице дано резюме по событиям JavaScript. 
О том, 
какие события поддерживаются конкретной версией JavaScript, см. книгу <I>
<a TARGET="_top" href="../clientref13/index.php">Клиентский JavaScript. </a></I>
<a href="../clientref13/index.php"><i>Справочник</i></a>.</p><A NAME="1012776"></a>
<h6 style="text-align: center"><B></B><A NAME="1010636"></a>Таблица 10.1&nbsp; Обработчики Событий JavaScript</h6>
<TABLE BORDER="2" CELLPADDING=5><TR><TH><A NAME="1010644"></a>Событие<TH><A NAME="1010646"></a>
Применяется к<TH><A NAME="1010648"></a>Возникает, когда<TH><A NAME="1010650"></a>
Обработчик<TR><TD><PRE><A NAME="1010652"></a>Abort</PRE><TD><P><A NAME="1010654"></a>
изображениям</P><TD><P><A NAME="1010656"></a>пользователь прерывает загрузку изображения (например, щёлкну гиперссылку или 
кнопку Stop)</P><TD><PRE><A NAME="1010658"></a>onAbort</PRE><TR><TD><PRE><A NAME="1010660"></a>Blur</PRE><TD><P><A NAME="1010662"></a>
окнам и всем элементам формы</P><TD><P><A NAME="1010664"></a>
пользователь убирает фокус ввода с окна или элемента формы</P><TD><PRE><A NAME="1010666"></a>onBlur</PRE>
<TR><TD><PRE><A NAME="1010668"></a>Change</PRE><TD><P><A NAME="1010670"></a>
текстовым полям, спискам select</P><TD><P><A NAME="1010672"></a>
пользователь изменяет значение элемента</P><TD><PRE><A NAME="1010674"></a>onChange</PRE>
<TR><TD><PRE><A NAME="1010676"></a>Click</PRE><TD><P><A NAME="1010678"></a>
кнопкам, radio-кнопкам, переключателям/checkboxes, кнопкам submit и reset, 
гиперссылкам</P><TD><P><A NAME="1010680"></a>
пользователь щёлкает по элементу формы или кнопке</P><TD><PRE><A NAME="1010682"></a>onClick</PRE>
<TR><TD><PRE><A NAME="1010684"></a>DragDrop</PRE><TD><P><A NAME="1010686"></a>
окнам</P><TD><P><A NAME="1010688"></a>
пользователь &quot;отпускает&quot; мышью объект в окне браузера, как при перемещении 
файлов</P><TD><PRE><A NAME="1010690"></a>onDragDrop</PRE>
<TR><TD><PRE><A NAME="1010692"></a>Error</PRE><TD><P><A NAME="1010694"></a>
изображениям, окнам</P><TD><P><A NAME="1010696"></a>
загрузка документа или изображения вызвала ошибку</P><TD><PRE><A NAME="1010698"></a>onError</PRE>
<TR><TD><PRE><A NAME="1010700"></a>Focus</PRE><TD><P><A NAME="1010702"></a>
окнам и всем элементам формы</P><TD><P><A NAME="1010704"></a>
пользователь передаёт фокус окну или элементу формы</P><TD><PRE><A NAME="1010706"></a>onFocus</PRE>
<TR><TD><PRE><A NAME="1010708"></a>KeyDown</PRE><TD><P><A NAME="1010710"></a>
документам, изображениям, гиперссылкам, текстовым полям</P><TD><P><A NAME="1010712"></a>
пользователь нажал клавишу клавиатуры</P><TD><PRE><A NAME="1010714"></a>onKeyDown</PRE>
<TR><TD><PRE><A NAME="1010716"></a>KeyPress</PRE><TD><P><A NAME="1010718"></a>
документам, изображениям, гиперссылкам, текстовым полям</P><TD><P><A NAME="1010720"></a>
пользователь нажал или (?) удерживает нажатой клавишу клавиатуры</P><TD><PRE><A NAME="1010722"></a>onKeyPress</PRE>
<TR><TD><PRE><A NAME="1010724"></a>KeyUp</PRE><TD><P><A NAME="1010726"></a>
документам, изображениям, гиперссылкам, текстовым полям</P><TD><P><A NAME="1010728"></a>
пользователь отпустил клавишу клавиатуры</P><TD><PRE><A NAME="1010730"></a>onKeyUp</PRE>
<TR><TD><PRE><A NAME="1010732"></a>Load</PRE><TD><P><A NAME="1010734"></a>телу документа</P><TD><P><A NAME="1010736"></a>
пользователь загружает страницу в Navigator</P><TD><PRE><A NAME="1010738"></a>onLoad</PRE>
<TR><TD><PRE><A NAME="1010740"></a>MouseDown</PRE><TD><P><A NAME="1010742"></a>
документам, кнопкам, гиперссылкам</P><TD><P><A NAME="1010744"></a>
пользователь нажал клавишу мыши</P><TD><PRE><A NAME="1010746"></a>onMouseDown</PRE>
<TR><TD><PRE><A NAME="1010748"></a>MouseMove</PRE><TD><P><A NAME="1010750"></a>
по умолчанию - ни к чему</P><TD><P><A NAME="1010752"></a>
пользователь перемещает курсор</P><TD><PRE><A NAME="1010754"></a>onMouseMove</PRE>
<TR><TD><PRE><A NAME="1010756"></a>MouseOut</PRE><TD><P><A NAME="1010758"></a>
областям, гиперссылкам</P><TD><P><A NAME="1010760"></a>
пользователь перемещает курсор за пределы клиентской карты изображений или 
гиперссылки</P><TD><PRE><A NAME="1010762"></a>onMouseOut</PRE>
<TR><TD><PRE><A NAME="1010764"></a>MouseOver</PRE><TD><P><A NAME="1010766"></a>гиперссылкам</P><TD><P><A NAME="1010768"></a>
пользователь перемещает курсор над гиперссылкой</P><TD><PRE><A NAME="1010770"></a>onMouseOver</PRE>
<TR><TD><PRE><A NAME="1010772"></a>MouseUp</PRE><TD><P><A NAME="1010774"></a>
документам, кнопкам, гиперссылкам</P><TD><P><A NAME="1010776"></a>
пользователь отпускает клавишу мыши</P><TD><PRE><A NAME="1010778"></a>onMouseUp</PRE>
<TR><TD><PRE><A NAME="1010780"></a>Move</PRE><TD><P><A NAME="1010782"></a>окнам</P><TD><P><A NAME="1010784"></a>
пользователь или скрипт перемещает окно</P><TD><PRE><A NAME="1010786"></a>onMove</PRE>
<TR><TD><PRE><A NAME="1010788"></a>Reset</PRE><TD><P><A NAME="1010790"></a>формам</P><TD><P><A NAME="1010792"></a>
пользователь восстанавливает начальные значения формы (щёлкает кнопку Reset)</P><TD><PRE><A NAME="1010794"></a>onReset</PRE>
<TR><TD><PRE><A NAME="1010796"></a>Resize</PRE><TD><P><A NAME="1010798"></a>окнам</P><TD><P><A NAME="1010800"></a>
пользователь или скрипт изменяет размер окна</P><TD><PRE><A NAME="1010802"></a>onResize</PRE>
<TR><TD><PRE><A NAME="1010804"></a>Select</PRE><TD><P><A NAME="1010806"></a>текстовым полям</P><TD><P><A NAME="1010808"></a>
пользователь выделяет поле ввода элемента формы</P><TD><PRE><A NAME="1010810"></a>onSelect</PRE>
<TR><TD><PRE><A NAME="1010812"></a>Submit</PRE><TD><P><A NAME="1010814"></a>формам</P><TD><P><A NAME="1010816"></a>
пользователь отправляет форму</P><TD><PRE><A NAME="1010818"></a>onSubmit</PRE>
<TR><TD><PRE><A NAME="1010820"></a>Unload</PRE><TD><P><A NAME="1010822"></a>телу документа</P><TD><P><A NAME="1010824"></a>
пользователь покидает страницу</P><TD><PRE><A NAME="1010826"></a>onUnload</PRE></TABLE>
<H2><A NAME="Defining an Event Handler"><A NAME="1009606"></a>Определение обработчика 
события</H2><hr>
<p><A NAME="1009610"></a>Вы определяете обработчик события (функцию или серию операторов JavaScript) для 
обработки события. Если событие применяется к HTML-тэгу (то есть событие 
применяется к JavaScript-объекту, созданному из этого тэга), то Вы можете 
определить для него обработчик события. Имя обработчика это имя события с 
префиксом "on." Например, обработчик для события <CODE>focus</CODE> называется <CODE>onFocus</CODE>.</p>
<p><A NAME="1009611"></a>Для создания обработчика события для тэга HTML добавьте атрибут обработчика 
события в этот тэг. Поместите код JavaScript в кавычки как значение атрибута. Общий синтаксис таков:</p>
<PRE><A NAME="1009612"></a>&lt;TAG eventHandler="JavaScript Code"&gt;</PRE><p><A NAME="1009614"></a>
где <CODE>TAG</CODE> это тэг HTML, <CODE>eventHandler</CODE> это имя обработчика 
события, а <CODE>JavaScript Code</CODE> это последовательность операторов JavaScript.</p>
<p><A NAME="1009615"></a>Например, Вы создали JavaScript-функцию <CODE>compute</CODE>. Вы выполняете 
вызов Navigator'ом этой функции, когда пользователь 
щёлкает кнопку, назначив вызов функции обработчику <CODE>onClick</CODE> кнопки:</p>
<PRE><A NAME="1009616"></a>&lt;INPUT TYPE="button" VALUE="Calculate" onClick="compute(this.form)"&gt;</PRE>
<p><A NAME="1009617"></a>Вы можете указать любые операторы JavaScript в качестве значения атрибута <CODE>onClick</CODE>. 
Эти операторы выполняются, если пользователь щёлкает по кнопке. При включении 
нескольких операторов разделяйте их символом (;).</p><p><A NAME="1010301"></a>
В предыдущем примере <CODE>this.form</CODE> ссылается на текущую форму. Ключевое 
слово <CODE>this</CODE> ссылается на текущий объект, которым в данном случае 
является кнопка. Конструкция <CODE>this.form</CODE>, следовательно, ссылается на 
форму, содержащую кнопку. Обработчик <CODE>onClick</CODE> это вызов функции <CODE>compute</CODE> 
с текущей формой в качестве аргумента.</p><p><A NAME="1012654"></a>
Если Вы создаёте обработчик события, соответствующий объект JavaScript получает 
свойство с именем обработчика события. Это свойство даёт Вам доступ к 
обработчику события данного объекта. Например, в предыдущем примере JavaScript 
создаёт объект <CODE>Button</CODE> со свойством <CODE>onclick</CODE>, значением 
которого является <CODE>"compute(this.form)"</CODE>.</p><p><A NAME="1010278"></a>
Не забывайте чередовать двойные и одинарные кавычки. Поскольку обработчик 
события в HTML обязан быть заключён в кавычки, Вы обязаны использовать одинарные 
кавычки как ограничители строковых аргументов. Например:</p>
<PRE><A NAME="1010279"></a>&lt;INPUT TYPE="button" NAME="Button1" VALUE="Open Sesame!"<br>&nbsp;&nbsp;&nbsp;onClick="window.open('mydoc.phpl', 'newWin')"&gt;</PRE>
<p><A NAME="1009622"></a>Вообще хорошей практикой может стать определение функции для обработчика события 
вместо использования нескольких операторов JavaScript:</p><ul><LI><A NAME="1009623"></a>
это сделает Ваш код более модульным - Вы сможете использовать ту же самую 
функцию как обработчик события для различных элементов.</LI><LI><A NAME="1009624"></a>это сделает Ваш код более понятным.</LI>
</ul><H3><A NAME="Head2;"></a><A NAME="1009637"></a>Пример: использование обработчика 
события</H3><hr>
<p><A NAME="1009638"></a>В форме, показанной на следующем рисунке, Вы можете ввести выражение (например, 2+2) 
в первое текстовое поле, а затем щёлкнуть кнопку. Во втором поле будет выведено значение выражения (в данном случае, 4).</p>
<h6><A NAME="1010328"></a>Рисунок 10.1&nbsp;&nbsp;&nbsp;Форма с обработчиком события</h6>
<B><P>
<IMG SRC="graphics/gs2.gif" width="377" height="131"></a></B></P><p><A NAME="1010342"></a>Скрипт для этой формы таков:</p>
<PRE><A NAME="1009639"></a>&lt;HEAD&gt;<br>&lt;SCRIPT&gt;<br>&lt;!-- Скрываем от старых браузеров<br>function compute(f) {<br>&nbsp;&nbsp;&nbsp;if (confirm("Are уou sure?"))<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;f.result.value = eval(f.expr.value)<br>&nbsp;&nbsp;&nbsp;else<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;alert("Please come back again.")<br>}<br>// конец скрытия --&gt;<br>&lt;/SCRIPT&gt;<br>&lt;/HEAD&gt;</PRE><PRE><A NAME="1009640"></a>&lt;BODY&gt;<br>&lt;FORM&gt;<br>Enter an expression:<br>&lt;INPUT TYPE="text" NAME="expr" SIZE=15 &gt;<br>&lt;INPUT TYPE="button" VALUE="Calculate" onClick="compute(this.form)"&gt;<br>&lt;BR&gt;<br>Result:<br>&lt;INPUT TYPE="text" NAME="result" SIZE=15 &gt;<br>&lt;/FORM&gt;<br>&lt;/BODY&gt;</PRE>
<p><A NAME="1009645"></a>HEAD/шапка документа определяет функцию <CODE>compute</CODE>, принимающую один 
аргумент, <CODE>f</CODE>, который является <CODE>Form</CODE>-объектом. Эта 
функция использует метод <CODE>window.confirm</CODE> для отображения диалога Confirm с кнопками OK и Cancel.</p>
<p><A NAME="1009648"></a>Если пользователь щёлкает OK, <CODE>confirm</CODE> возвращает true, а значением 
текстового поля <CODE>result</CODE> становится значение <CODE>eval(f.expr.value)</CODE>. 
Функция JavaScript <CODE>eval</CODE> вычисляет свой аргумент, который может быть 
любой строкой, представляющей любые выражение или операторы JavaScript.</p><p><A NAME="1009651"></a>
Если пользователь нажал Cancel, <CODE>confirm</CODE> возвращает false, и метод <CODE>alert</CODE> 
выводит другое сообщение.</p><p><A NAME="1009653"></a>
На форме имеется кнопка с обработчиком <CODE>onClick</CODE>, в котором 
вызывается функция <CODE>compute</CODE>. Когда пользователь щёлкает кнопку, JavaScript 
вызывает <CODE>compute</CODE> с аргументом <CODE>this.form</CODE>, который 
означает текущий <CODE>Form</CODE>-объект. В <CODE>compute</CODE> на this.form 
делается ссылка как на аргумент <CODE>f</CODE>.</p><H3><A NAME="Head2;"></a><A NAME="1009658"></a>
Вызов обработчиков событий явным образом</H3><hr><p><A NAME="1009660"></a>
Руководствуйтесь следующими указаниями при вызове обработчиков событий.</p>
<ul><LI><A NAME="1014175"></a>Вы можете устанавливать обработчик, специфицированный в HTML, как показано здесь 
в примерах.</LI><PRE><A NAME="1009661"></a>&lt;SCRIPT LANGUAGE="JavaScript"&gt;<br>function fun1() {<br>&nbsp;&nbsp;&nbsp;...<br>}<br>function fun2() {<br>&nbsp;&nbsp;&nbsp;...<br>}<br>&lt;/SCRIPT&gt;</PRE><PRE><A NAME="1009662"></a>&lt;FORM NAME="myForm"&gt;<br>&lt;INPUT TYPE="button" NAME="myButton"<br>&nbsp;&nbsp;&nbsp;onClick="fun1()"&gt;<br>&lt;/FORM&gt;</PRE><PRE><A NAME="1009663"></a>&lt;SCRIPT&gt;<br>document.myForm.myButton.onclick=fun2<br>&lt;/SCRIPT&gt;</PRE><P><A NAME="1009664"></a>
<B>JavaScript&nbsp;1.0.</B> Вы не можете устанавливать обработчик события.</P>
<LI><A NAME="1014365"></a>Обработчики событий являются ссылками на функции, поэтому Вы обязаны присвоить <CODE>fun2</CODE> 
самой себе, а не <CODE>fun2()</CODE> (второй вариант вызывает <CODE>fun2</CODE> 
и содержит любые тип и значение, возвращаемые функцией <CODE>fun2</CODE>).</LI><LI><A NAME="1009665"></a>
Поскольку HTML-атрибуты обработчика события являются литеральными телами 
функций, Вы не можете использовать <CODE>&lt;INPUT onClick=fun1&gt;</CODE> в HTML, 
чтобы назначить <CODE>fun1</CODE> обработчику <CODE>onClick</CODE>. Вместо 
этого, Вы обязаны установить значение в JavaScript, как в предыдущем примере.</LI></ul><p><B><A NAME="HeadRunIn;"></a>
<A NAME="1014305"></a>JavaScript&nbsp;1.1 и предыдущие версии. </B><A NAME="1014306"></a>
Вы обязаны вводить имена обработчиков символами нижнего регистра, например, <CODE>myForm.onsubmit</CODE> 
или <CODE>myButton.onclick</CODE>.</p><H2><A NAME="The Event Object"><A NAME="1012525"></a>Объект Event</H2><hr>
<p><A NAME="1012526"></a>Каждое событие имеет ассоциированный объект <CODE>event</CODE>. Объект <CODE>event</CODE> 
предоставляет информацию о событии, такую как тип события и положение курсора в 
момент возникновения события. Когда событие возникает, и если обработчик был 
написан для обработки этого события, объект <CODE>event</CODE> отправляется обработчику как аргумент.</p>
<p><A NAME="1010125"></a>В случае с событием <CODE>MouseDown</CODE>, например, объект <CODE>event</CODE> 
содержит тип события (<CODE>"MouseDown"</CODE>), координаты x и y позиции 
курсора мыши в момент возникновения события, число - используемую кнопку мыши и 
поле, содержащее клавиши-модификаторы (Control, Alt, Meta или Shift), которые 
были нажаты в момент события. Свойства объекта <CODE>event</CODE> различаются 
для разных типов событий, как описано в книге <I>
<a TARGET="_top" href="../clientref13/index.php">Клиентский JavaScript. </a></I>
<a href="../clientref13/index.php"><i>Справочник</i></a>.</p><p><B><A NAME="HeadRunIn;"></a><A NAME="1014443"></a>
JavaScript&nbsp;1.1 и предыдущие версии. </B><A NAME="1014444"></a>
Объект <CODE>event</CODE> недоступен.</p><H2><A NAME="Event Capturing"><A NAME="1010131"></a>
Захват событий</H2><hr><p><A NAME="1010199"></a>Обычно событие обрабатывается объектом, в котором это событие возникает. Например, 
если пользователь щёлкает по кнопке, вызывается обработчик этого события. Иногда Вам 
может понадобиться, чтобы объект <CODE>window</CODE> или <CODE>document</CODE> 
обрабатывал определённые события. Например, Вам может понадобиться, чтобы объект <CODE>document</CODE> 
обрабатывал все события <CODE>MouseDown</CODE> вне зависимости от того, в каком 
месте документа они возникают.</p><p><A NAME="1010499"></a>Модель захвата событий
JavaScript даёт возможность определять методы, которые захватывают и 
обрабатывают события, до того как они достигнут своей предполагаемой цели. Для 
этого объекты <CODE>window</CODE>, <CODE>document</CODE> и <CODE>layer</CODE> используют следующие методы:</p>
<ul><LI><A NAME="1010133"></a><CODE>captureEvents </CODE>- захватывает события специфицированного типа.</LI><LI><A NAME="1013420"></a>
<CODE>releaseEvents </CODE>- игнорирует захват событий специфицированного типа.</LI><LI><A NAME="1013421"></a>
<CODE>routeEvent </CODE>- перенаправляет захваченное событие специфицированному объекту.</LI><LI><A NAME="1013422"></a>
<CODE>handleEvent </CODE>- обрабатывает захваченное событие (это не метод объекта <CODE>layer</CODE>).</LI></ul>
<p><B><A NAME="HeadRunIn;"></a><A NAME="1014468"></a>
JavaScript&nbsp;1.1 и предыдущие версии. </B><A NAME="1014469"></a>Захват событий невозможен.</p><p><A NAME="1010402"></a>
Как пример, предположим, Вы хотите захватить все события <CODE>Click</CODE>, 
возникающие в окне. В сжатом виде, шаги по захвату событий таковы:</p><OL><LI><A NAME="1014488"></a>
<a href="#1010535">Включить захват событий</a></LI><LI><A NAME="1010536"></a>
<a href="#1010420">Определить обработчик события</a></LI><LI><A NAME="1010542"></a>
<a href="#1010449">Зарегистрировать обработчик события</a></LI></OL><p><A NAME="1010531"></a>В последующих разделах эти шаги поясняются.</p>
<H3><A NAME="Head2;"></a><A NAME="1010535"></a>Включение захвата событий</H3><hr><p><A NAME="1010545"></a>
Для настройки захвата окном всех событий <CODE>Click</CODE> используйте примерно такой оператор:</p>
<PRE><A NAME="1010413"></a>window.captureEvents(Event.CLICK);</PRE><p><A NAME="1010481"></a>
Аргументом свойства <CODE>captureEvents</CODE> объекта <CODE>event</CODE> 
является тип захватываемого события. Для захвата нескольких типов событий, 
аргументом является список с разделением символом (<CODE>|</CODE>). Например, 
следующий оператор захватывает события <CODE>Click</CODE>, <CODE>MouseDown</CODE> 
и <CODE>MouseUp</CODE>: </p>
<PRE><A NAME="1010482"></a>window.captureEvents(Event.CLICK | Event.MOUSEDOWN | Event.MOUSEUP)</PRE><BLOCKQUOTE>
<p><B>ПРИМЕЧАНИЕ: </B><A NAME="1014535"></a>
Если окно с фрэймами должно захватывать события на страницах, загружаемых с 
различных серверов, Вам необходимо использовать <CODE>captureEvents</CODE> в маркированном скрипте и вызывать 
<CODE>enableExternalCapture</CODE>. О маркированных скриптах см. <A HREF="sec.php#1019081">Главу 14 
"Безопасность в JavaScript"</a>.</p></BLOCKQUOTE><H3><A NAME="Head2;"></a><A NAME="1010420"></a>
Определение Обработчика События</H3><hr><p><A NAME="1010554"></a>
Далее определяется функция, обрабатывающая событие. Аргумент <CODE>e</CODE> это <CODE>event</CODE>-объект события.</p>
<PRE><A NAME="1010421"></a>function clickHandler(e) {<br>
&nbsp;&nbsp;&nbsp;//Здесь идёт обработка события.<br>&nbsp;&nbsp;&nbsp;//Процесс описан ниже.<br>}</PRE>
<p><A NAME="1010422"></a>У Вас имеются следующие опции для обработки события:</p><ul><LI><A NAME="1010423"></a>
Возвращать <CODE>true</CODE>. В гиперссылке выполняется переход, и никакой 
обработчик не отмечается. Если событие не может быть отменено, это прекращает 
обработку данного события.<PRE><A NAME="1010424"></a>&nbsp;&nbsp;&nbsp;function clickHandler(e) {<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;return true;<br>&nbsp;&nbsp;&nbsp;}</PRE></P><A NAME="1010425"></a>
Это даёт возможность полностью обработать событие документом или окном. 
Событие не обрабатывается каким-либо иным объектом, таким как button в document 
или дочерний фрэйм в window.<LI><A NAME="1010565"></a>
Возвращать <CODE>false</CODE>. В гиперссылке - переход по ссылке не 
выполняется. Если событие не может быть отменено, это прекращает обработку 
данного события.<PRE><A NAME="1010426"></a>&nbsp;&nbsp;&nbsp;function clickHandler(e) {<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;return false;<br>&nbsp;&nbsp;&nbsp;}</PRE><A NAME="1010494"></a>
Это позволяет подавить обработку событий данного типа. Событие не 
обрабатывается каким-либо другим объектом, таким как кнопка в документе  
или дочерний фрэйм в окне. Вы может использовать это, например, для подавления 
событий от правой кнопки мыши в Вашем приложении.<LI><A NAME="1010589"></a>
Вызывать <CODE>routeEvent</CODE>. JavaScript ищет другие обработчики для 
данного события. Если другой объект пытается захватить событие (такой объект 
как document), JavaScript вызывает его обработчик события. Если другой объект 
не пытается захватить событие, JavaScript ищет изначальный целевой обработчик 
объекта (такого как объект button). Функция <CODE>routeEvent</CODE> возвращает 
значение, возвращаемое обработчиком события. Захватывающий объект может 
определить способ продолжения работы на основе возвращённого результата.<br>
<A NAME="1010438"></a>Если <CODE>routeEvent</CODE> вызывает обработчик события, этот обработчик 
активируется. Если <CODE>routeEvent</CODE> вызывает обработчик, функцией 
которого является отображение новой страницы, эта акция выполняется без 
возвращения к вызывающему объекту.<PRE><A NAME="1010442"></a>&nbsp;&nbsp;&nbsp;function clickHandler(e) {<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;var retval = routeEvent(e);<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;if (retval == false) return false;<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;else return true;<br>&nbsp;&nbsp;&nbsp;}</PRE><LI><A NAME="1010446"></a>
Вызвать метод <CODE>handleEvent</CODE> получателя события. Любой объект, 
который может регистрировать обработчики событий, является получателем 
события/event receiver. Это метод явным образом вызывает обработчик получателя 
события в обход иерархии захвата. Например, если Вы хотите, чтобы все события <CODE>Click</CODE> 
направлялись первой гиперссылке страницы, Вы можете записать:<PRE><A NAME="1010447"></a>&nbsp;&nbsp;&nbsp;function clickHandler(e) {<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; window.document.links[0].handleEvent(e);<br>&nbsp;&nbsp;&nbsp;}</PRE><A NAME="1010448"></a>
Пока ссылка имеет обработчик <CODE>onClick</CODE>, эта ссылка будет 
обрабатывать любые click-события, которые она получает.</ul><H3><A NAME="Head2;"></a><A NAME="1010449"></a>
Регистрация обработчика события</H3><hr><p><A NAME="1010555"></a>
Наконец, функция регистрируется как обработчик данного события в окне:</p>
<PRE><A NAME="1010450"></a>window.onClick = clickHandler;</PRE><H3><A NAME="Head2;"></a>
<A NAME="1010157"></a>Полный пример</H3><hr><p><A NAME="1010158"></a>
В этом примере window и document захватывают и освобождают события:</p>
<PRE><A NAME="1010159"></a>&lt;HTML&gt;<br>&lt;SCRIPT&gt;</PRE><PRE><A NAME="1010160"></a>function fun1(e) {<br>&nbsp;&nbsp;&nbsp;alert ("The window got an event of type: " + e.type + <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" and will call routeEvent.");<br>&nbsp;&nbsp;&nbsp;window.routeEvent(e);<br>&nbsp;&nbsp;&nbsp;alert ("The window returned from routeEvent.");<br>&nbsp;&nbsp;&nbsp;return true;<br>}</PRE><PRE><A NAME="1010161"></a>function fun2(e) {<br>&nbsp;&nbsp;&nbsp;alert ("The document got an event of type: " + e.type);<br>&nbsp;&nbsp;&nbsp;return false;<br>}</PRE><PRE><A NAME="1010162"></a>function setWindowCapture() {<br>&nbsp;&nbsp;&nbsp;window.captureEvents(Event.CLICK);<br>}</PRE><PRE><A NAME="1010163"></a>function releaseWindowCapture() {<br>&nbsp;&nbsp;&nbsp;window.releaseEvents(Event.CLICK);<br>}</PRE><PRE><A NAME="1010164"></a>function setDocCapture() {<br>&nbsp;&nbsp;&nbsp;document.captureEvents(Event.CLICK);<br>}</PRE><PRE><A NAME="1010165"></a>function releaseDocCapture() {<br>&nbsp;&nbsp;&nbsp;document.releaseEvents(Event.CLICK);<br>}</PRE><PRE><A NAME="1010166"></a>window.onclick=fun1;<br>document.onclick=fun2;</PRE><PRE><A NAME="1010167"></a>&lt;/SCRIPT&gt;<br>...<br>&lt;/HTML&gt;</PRE>
<H2><A NAME="Validating Form Input"><A NAME="1012961"></a>Проверка данных, введённых в 
форму</H2><hr>
<p><A NAME="1012962"></a>Важным является использование JavaScript для проверки введённых в форму данных, 
предназначенных для последующей обработки серверными программами, такими как 
приложения серверного JavaScript или CGI-программы. Эта проверка делается по следующими причинам:</p>
<ul><LI><A NAME="1012965"></a>Уменьшается нагрузка на сервер. "Плохие" данные фильтруются уже перед 
отправкой данных на сервер.</LI><LI><A NAME="1012966"></a>
Уменьшается задержка в случае ошибки пользователя. Иначе проверка выполняется 
на сервере, и данные обязаны путешествовать с клиента на сервер, для обработки, 
и обратно клиенту - для повторения ввода.</LI><LI><A NAME="1012967"></a>Упрощаются серверные программы.</LI></ul>
<p><A NAME="1012968"></a>В общем, Вам понадобится проверять ввод как минимум в двух случаях:</p><ul><LI><A NAME="1012970"></a>
  После ввода данных пользователем - обработчиком <CODE>onChange</CODE> в каждом 
элементе формы, который Вам нужно проверить.</LI><LI><A NAME="1012972"></a>
Если пользователь отправляет форму - обработчиком <CODE>onClick</CODE> submits-кнопки, отправляющей форму.</LI></ul>
<p><A NAME="1012975"></a>Страница <A HREF="http://developer.netscape.com/tech/javascript/index.phpl" TARGET="_top">JavaScript 
на сайте DevEdge</a> содержит ссылки на примеры кода. Одна из этих ссылок - это 
полный набор функций для проверки данных формы.<br>В следующем разделе даны некоторые простые примеры, но посмотрите также примеры 
на сайте DevEdge.</p><H3><A NAME="Head2;"></a><A NAME="1012977"></a>Пример проверяющих 
функций</H3><hr><p>
<A NAME="1012978"></a>Вот примеры простых проверяющих функций:</p>
<PRE><A NAME="1012979"></a>&lt;HEAD&gt;<br>&lt;SCRIPT LANGUAGE="JavaScript"&gt;<br>function isaPosNum(s) {<br>&nbsp;&nbsp;&nbsp;return (parseInt(s) &gt; 0)<br>}</PRE><PRE><A NAME="1012980"></a>function qty_check(item, min, max) {<br>&nbsp;&nbsp;&nbsp;var returnVal = false<br>&nbsp;&nbsp;&nbsp;if (!isaPosNum(item.value)) <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;alert("Please enter a positive number")<br>&nbsp;&nbsp;&nbsp;else if (parseInt(item.value) &lt; min) <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;alert("Please enter a " + item.name + " greater than " + min)<br>&nbsp;&nbsp;&nbsp;else if (parseInt(item.value) &gt; max) <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;alert("Please enter a " + item.name + " less than " + max)<br>&nbsp;&nbsp;&nbsp;else <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;returnVal = true<br>&nbsp;&nbsp;&nbsp;return returnVal<br>}</PRE><PRE><A NAME="1012981"></a>function validateAndSubmit(theform) {<br>&nbsp;&nbsp;&nbsp;if (qty_check(theform.quantity, 0, 999)) {<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;alert("Order has been Submitted")<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;return true<br>&nbsp;&nbsp;&nbsp;}<br>&nbsp;&nbsp;&nbsp;else {<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;alert("Sorry, Order Cannot Be Submitted!")<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;return false<br>&nbsp;&nbsp;&nbsp;}<br>}<br>&lt;/SCRIPT&gt;<br>&lt;/HEAD&gt;</PRE>
<p><A NAME="1012982"></a><CODE>isaPosNum</CODE> это простая функция, которая возвращает true, если её 
аргумент - положительное число, и false - в ином случае.</p><p><A NAME="1012983"></a>
<CODE>qty_check</CODE> принимает три аргумента: объект, соответствующий 
проверяемому элементу формы (<CODE>item</CODE>), и минимальное и максимальное 
допустимые значения для item (<CODE>min</CODE> и <CODE>max</CODE>). Она 
проверяет, является ли <CODE>item</CODE> числом в диапазоне от min до max, и 
выводит диалог alert, если это не так.</p><p><A NAME="1012984"></a>
<CODE>validateAndSubmit</CODE> принимает в качестве аргумента <CODE>Form</CODE>-объект; 
она использует <CODE>qty_check</CODE> для проверки значения элемента формы и 
отправляет форму, если ввод верен. В ином случае она выводит окно alert и не отправляет форму.</p>
<H3><A NAME="Head2;"></a><A NAME="1012986"></a>Использование проверяющих функций</H3><hr><p><A NAME="1012988"></a>
В следующем примере тэг BODY документа использует <CODE>qty_check</CODE> как 
обработчик <CODE>onChange</CODE> для текстового поля и <CODE>validateAndSubmit</CODE> 
- как обработчик <CODE>onClick</CODE> для кнопки.</p>
<PRE><A NAME="1012990"></a>&lt;BODY&gt;<br>&lt;FORM NAME="widget_order" ACTION="lwapp.phpl" METHOD="post"&gt;<br>How many widgets today? <br>&lt;INPUT TYPE="text" NAME="quantity" onChange="qty_check(this, 0, 999)"&gt;<br>&lt;BR&gt; <br>&lt;INPUT TYPE="button" VALUE="Enter Order" onClick="validateAndSubmit(this.form)"&gt;<br>&lt;/FORM&gt;<br>&lt;/BODY&gt;</PRE>
<p><A NAME="1012991"></a>Эта форма отправляет значения на страницу <CODE>lwapp.phpl</CODE> приложения 
серверного JavaScript. Можно также отправить форму CGI-программе. Форма показана на рисунке.</p>
<h6><A NAME="1012997"></a>
Рисунок 10.2&nbsp;&nbsp;Форма JavaScript</h6>
<B><P>
<IMG SRC="graphics/gs3.gif" width="367" height="131"></a></B></P><p><A NAME="1012998"></a>
Обработчик <CODE>onChange</CODE> включается, если Вы измените значение в 
текстовом поле и переместите фокус с этого поля, нажав клавишу Tab клавиатуры 
компьютера или щёлкнув мышью вне этого текстового поля. Обратите внимание, что 
оба обработчика используют ключевое слово <CODE>this</CODE> для представления 
текущего объекта: в текстовом поле оно используется для передачи объекта JavaScript, 
соответствующего текстовому полю, функции <CODE>qty_check</CODE>, а в кнопке - 
для передачи JavaScript-объекта <CODE>Form</CODE> функции <CODE>validateAndSubmit</CODE>.</p>
<p><A NAME="1013000"></a>Для отправки формы серверной программе в этом примере используется кнопка, 
которая вызывает <CODE>validateAndSubmit</CODE>, проверяющую форму, с 
использование метода <CODE>submit</CODE>, если данные верны. Вы можете также 
использовать submit-кнопку (определённую тэгом <CODE>&lt;INPUT TYPE="submit"&gt;</CODE>) 
и поместить на форму обработчик <CODE>onSubmit</CODE>, который возвращает false, 
если введены неправильные данные. Например,</p>
<PRE><A NAME="1013006"></a>&lt;FORM NAME="widget_order" ACTION="lwapp.phpl" METHOD="post" <br>&nbsp;&nbsp;&nbsp;onSubmit="return qty_check(theform.quantity, 0, 999)"&gt;<br>...<br>&lt;INPUT TYPE="submit"&gt;<br>...<br>&lt;/FORM&gt;</PRE>
<p><A NAME="1013007"></a>Если <CODE>qty_check</CODE> возвращает false (если данные неверны), обработчик <CODE>onSubmit</CODE> 
запретит отправку формы.</p>
<h5><a href="contents.php">Оглавление</a> | <a href="embed.php">Назад</a>
| <a href="navobj.php">Вперёд</a> | <a href="bklast.php">Индекс</a></h5><hr>
</BODY></HTML>
<?
include_once '../../sys/inc/tfoot.php';
?>