<?
include_once '../../sys/inc/start.php';
include_once '../../sys/inc/compress.php';
include_once '../../sys/inc/sess.php';
include_once '../../sys/inc/home.php';
include_once '../../sys/inc/settings.php';
include_once '../../sys/inc/db_connect.php';
include_once '../../sys/inc/ipua.php';
include_once '../../sys/inc/fnc.php';
include_once '../../sys/inc/user.php';
$set['title']='Учебник JavaScript';
include_once '../../sys/inc/thead.php';
title();
err();
//aut();
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<phpl<TITLE>Использование Объектов Navigator'a</TITLE>
<BODY>
<h5><a href="contents.php">Оглавление</a> | <a href="evnt.php">Назад</a>
| <a href="windows.php">Вперёд</a> | <a href="bklast.php">Индекс</a></h5><HR>
<h1>Глава 11<BR><A NAME="1005423"></a>Использование Объектов Navigator'а</h1><p><A NAME="1005424"></a>
В этой главе рассматриваются объекты JavaScript в Navigator'е 
и объясняется, как их использовать. Объекты клиентского JavaScript иногда 
называются <i>объектами Navigator'а</i>, чтобы отличить их от серверных или пользовательских объектов.</p>
<p><A NAME="1016526"></a>В главе имеются следующие разделы:</p><ul><LI><A NAME="1016527"></a>
<A HREF="#1006931">Иерархия объектов Navigator'а</a></LI><LI><A NAME="1016528"></a>
<A HREF="#1006066">Свойства документа: пример</a></LI><LI><A NAME="1017147"></a>
<A HREF="#1007007">Отражение JavaScript и вывод HTML</a></LI><LI><A NAME="1017152"></a>
<A HREF="#1009022">Ключевые объекты Navigator'а</a></LI><LI><A NAME="1017207"></a>
<A HREF="#1017919">Массивы объектов Navigator'а</a></LI><LI><A NAME="1018091"></a>
<A HREF="#1016546">Использование метода write</a></LI></ul><H2><A NAME="Navigator Object Hierarchy">
<A NAME="1006931"></a>Иерархия объектов Navigator'а</H2><hr><p><A NAME="1014686"></a>
Когда Вы загружаете документ в Navigator, он создаёт объекты JavaScript со 
значениями свойств, базируясь на HTML документа и другой сопутствующей 
информации. Эти объекты расположены иерархически, что отражает структуру самой HTML-страницы. 
На рисунке показана эта иерархия объектов.</p><h6><A NAME="1014691"></a>
Рисунок 11.1&nbsp;&nbsp; Иерархия объектов Navigator'а</h6>
<P><IMG SRC="graphics/nav_hier.gif" width="528" height="444"></a></P><p><A NAME="1014692"></a>
В данной иерархии "потомки" объектов являются их свойствами. Например, форма <CODE>form1</CODE> 
является объектом, а также свойством объекта <CODE>document</CODE>, и к ней 
обращаются <CODE>document.form1</CODE>.</p><p><A NAME="1016328"></a>
Список всех объектов, их свойств, методов и обработчиков событий см. в книге <I>
<a TARGET="_top" href="../clientref13/index.php">Клиентский JavaScript. </a></I>
<a href="../clientref13/index.php"><i>Справочник</i></a>.</p><p><A NAME="1007993"></a>
На каждой странице имеются следующие объекты:</p><ul><LI><A NAME="1007995"></a>
<CODE>navigator</CODE>: имеет свойства - имя и версию используемого Navigator&#39;а, MIME-типы, 
поддерживаемые клиентом и plug-in&#39;ы, установленные на клиенте.</LI><LI><A NAME="1007997"></a>
<CODE>window</CODE>: объект верхнего уровня/top-level; имеет свойства, которые 
применяются ко всему окну. Каждое "дочернее окно" в документе с фрэймами также 
является <CODE>window</CODE>-объектом.</LI><LI><A NAME="1007999"></a>
<CODE>document</CODE>: имеет свойства на основе содержимого документа, такого 
как заголовок, цвет фона, гиперссылки и формы.</LI><LI><A NAME="1008001"></a>
<CODE>location</CODE>: имеет свойства на основе текущего URL.</LI><LI><A NAME="1008003"></a>
<CODE>history</CODE>: имеет свойства, представляющие URL&#39;ы, которые клиент запрашивал ранее.</LI></ul><p><A NAME="1008004"></a>
В зависимости от содержимого, документ может содержать и другие объекты. 
Например, каждая форма (определённая тэгом <CODE>FORM</CODE>) в документе имеет 
соответствующий объект <CODE>Form</CODE>.</p><p><A NAME="1006964"></a>
Для обращения к конкретным свойствам Вы обязаны специфицировать имена объекта и 
всех его предков. Обычно объект получает имя в атрибуте <CODE>NAME</CODE> 
соответствующего HTML-тэга. Дополнительную информацию и пример см. в <A HREF="windows.php#996824">
Главе 12 "Использование Окон и Фрэймов&quot;</a>.</p><p><A NAME="1008045"></a>
Например, следующий код обращается к свойству <CODE>value</CODE> текстового поля <CODE>text1</CODE> 
на форме <CODE>myform</CODE> в текущем документе:</p>
<PRE><A NAME="1006965"></a>document.myform.text1.value</PRE><p><A NAME="1010227"></a>
Если объект находится на форме, Вы обязаны включать имя формы при обращении к 
этому объекту, даже если объект не обязан быть на форме. Например, изображения 
не обязаны находиться на форме. Следующий код обращается к изображению, находящемуся на форме:</p>
<PRE><A NAME="1010232"></a>document.imageForm.aircraft.src='f15e.gif'</PRE><p><A NAME="1010233"></a>
Следующий код обращается к изображению, которое <em>не</em> находится на форме:</p>
<PRE><A NAME="1010234"></a>document.aircraft.src='f15e.gif'</PRE><H2><A NAME="Document Properties: an Example">
<A NAME="1006066"></a> Свойства документа: пример</H2><hr><p><A NAME="1006536"></a>
Свойства объекта <CODE>document</CODE> зависят от содержимого. То есть они 
создаются на основе HTML документа. Например, <CODE>document</CODE> имеет 
свойства для каждой формы и каждого якоря /anchor документа.</p><p><A NAME="1004228"></a>
Предположим, Вы создаёте страницу <CODE>simple.phpl</CODE>, которая содержит следующий HTML:</p>
<PRE><A NAME="1004229"></a>&lt;HEAD&gt;&lt;TITLE&gt;A Simple Document&lt;/TITLE&gt;<br>&lt;SCRIPT&gt;<br>
function update(form) {<br>&nbsp;&nbsp;&nbsp;alert("Form being updated")<br>}<br>&lt;/SCRIPT&gt;<br>
&lt;/HEAD&gt;</PRE><PRE><A NAME="1013650"></a>&lt;BODY&gt;<br>&lt;FORM NAME="myform" ACTION="foo.cgi"
METHOD="get" &gt;Enter a value:<br>&lt;INPUT TYPE="text" NAME="text1" VALUE="blahblah" SIZE=20 &gt;<br>
Check if you want: <br>&lt;INPUT TYPE="checkbox" NAME="Check1" CHECKED &nbsp;&nbsp;&nbsp;<br>
&nbsp;&nbsp;&nbsp;onClick="update(this.form)"&gt; Option #1<br>&lt;P&gt;<br>
&lt;INPUT TYPE="button" NAME="button1" VALUE="Press Me"<br>&nbsp;&nbsp;&nbsp;onClick="update(this.form)"&gt;<br>
&lt;/FORM&gt;<br>&lt;/BODY&gt;</PRE><p><A NAME="1006054"></a>
На основе этого HTML базовые объекты могут иметь свойства вроде тех, которые показаны в таблице.</p>
<A NAME="1016413"></a><h6 style="text-align: center"><A NAME="1006006"></a>
Таблица 11.1&nbsp;Пример значений свойств объектов</h6><TABLE BORDER="2" CELLPADDING=5>
<TR><TH><A NAME="1006046"></a>Свойство<TH><A NAME="1006048"></a>
Значение<TR><TD><PRE><A NAME="1006038"></a>document.title</PRE><TD><PRE><A NAME="1006040"></a> "A Simple Document"</PRE>
<TR><TD><PRE><A NAME="1006018"></a>document.fgColor</PRE><TD><PRE><A NAME="1006020"></a> #000000</PRE>
<TR><TD><PRE><A NAME="1006022"></a>document.bgColor</PRE><TD><PRE><A NAME="1006024"></a> #ffffff</PRE>
<TR><TD><PRE><A NAME="1006462"></a>location.href</PRE><TD><PRE><A NAME="1006464"></a> "http://www.royalairways.com/samples/simple.phpl"</PRE>
<TR><TD><PRE><A NAME="1006026"></a>history.length</PRE><TD><PRE><A NAME="1006028"></a> 7</PRE></TABLE>
<p><A NAME="1017748"></a>Обратите внимание, что значение свойства <CODE>document.title</CODE> отражает 
значение, специфицированное тэгом <CODE>TITLE</CODE>. Значения свойств <CODE>document.fgColor</CODE> (цвет 
текста) и <CODE>document.bgColor</CODE> (цвет фона) не были установлены в HTML, 
поэтому они базируются на значениях по умолчанию, специфицированных в диалоговом 
окне Preferences (в меню Edit Navigator&#39;а).</p><p><A NAME="1006058"></a>
Поскольку в документе имеется форма, имеется также объект <CODE>Form</CODE> под 
названием <CODE>myform</CODE> (на основе атрибута <CODE>NAME</CODE> формы), 
который имеет дочерние объекты для checkbox и для button. Каждый из этих 
объектов имеет имя на основе атрибута <CODE>NAME</CODE> тэга HTML, определяющего этот объект:</p>
<ul><LI><A NAME="1004238"></a><CODE>document.myform</CODE> - форма</LI><LI><A NAME="1006083"></a>
<CODE>document.myform.Check1</CODE> - checkbox/переключатель</LI><LI><A NAME="1006084"></a>
<CODE>document.myform.button1</CODE> - button/кнопка</LI></ul><p><A NAME="1007050"></a>
<CODE>Form</CODE>-объект <CODE>myform</CODE> имеет другие свойства на основе 
атрибутов тэга <CODE>FORM</CODE>, например,</p><ul><LI><A NAME="1004242"></a>
<CODE>action</CODE> это <CODE>http://www.royalairways.com/samples/mycgi.cgi</CODE> 
- URL по которому форма отправляется.</LI><LI><A NAME="1006196"></a>
<CODE>method</CODE> это "get&quot; - на основе значения атрибута <CODE>METHOD</CODE>.</LI><LI><A NAME="1006237"></a>
<CODE>length</CODE> равен 3, поскольку на форме размещены три элемента.</LI></ul><p><A NAME="1006085"></a>
Объект <CODE>Form</CODE> имеет дочерние объекты <CODE>button1</CODE> и <CODE>text1</CODE>, 
соответствующие кнопке и текстовому полю на форме. Эти объекты имеют свои 
собственные свойства на основе значений своих HTML-атрибутов, например,</p><ul><LI><A NAME="1006365"></a>
<CODE>button1.value</CODE> имеет значение "Press Me"</LI><LI><A NAME="1006369"></a>
<CODE>button1.name</CODE> имеет значение "Button1"</LI><LI><A NAME="1006379"></a>
<CODE>text1.value</CODE> имеет значение "blahblah"</LI><LI><A NAME="1006380"></a>
<CODE>text1.name</CODE> имеет значение "text1"</LI></ul><p><A NAME="1004470"></a>
Вы обращаетесь к этим свойствам, используя из полное именование, например, <CODE>document.myform.button1.value</CODE>. 
Это полное имя, основанное на иерархии объектов Navigator&#39;а, 
начинается с <CODE>document</CODE>, затем идёт имя формы, <CODE>myform</CODE>, 
затем - имя элемента, <CODE>button1</CODE>, и, наконец, имя свойства.</p>
<H2><A NAME="JavaScript Reflection and HTML Layout"><A NAME="1007007"></a>Отражение JavaScript и вывод HTML</H2><hr>
<p><A NAME="1007008"></a>В JavaScript значения свойств объекта основаны на содержимом Вашего HTML-документа, 
что иногда называется <I>reflection/отражением</I>, поскольку значения свойств 
отражают HTML. Для понимания отражения JavaScript важно разобраться, как Navigator 
выполняет <I>layout\вывод </I>- процесс трансформации Navigator&#39;ом HTML-тэгов 
в графическое отображение на экране Вашего компьютера.</p><p><A NAME="1007009"></a>
Обычно отображение выполняется в Navigator&#39;е 
последовательно: Navigator стартует от верха HTML-файла и проходит до конца 
документа (вниз), отображая вывод на экране по мере прохождения документа. Из-за 
такого выполнения "сверху вниз", JavaScript отражает только HTML, который 
обнаружен. Например, Вы определяете форму и два элемента для ввода текста:</p>
<PRE><A NAME="1007011"></a>&lt;FORM NAME="statform"&gt;<br>&lt;INPUT TYPE = "text" name = "userName" size = 20&gt;<br>&lt;INPUT TYPE = "text" name = "Age" size = 3&gt;</PRE>
<p><A NAME="1007012"></a>Эти элементы формы отражаются как объекты JavaScript, которые могут 
использоваться Вами <i>после</i> определения формы: <CODE>document.statform.userName</CODE> 
и <CODE>document.statform.Age</CODE>. Например, Вы можете отобразить значения 
этих объектов в скрипте после определения формы:</p>
<PRE><A NAME="1007013"></a>&lt;SCRIPT&gt;<br>document.write(document.statform.userName.value)<br>document.write(document.statform.Age.value)<br>&lt;/SCRIPT&gt;</PRE>
<p><A NAME="1007014"></a>Однако, если Вы попытаетесь сделать это до того как форма определена, (выше 
определения формы на HTML-странице), Вы можете получить ошибку, поскольку объект 
пока ещё не существует в Navigator&#39;е.</p><p><A NAME="1007015"></a>
Аналогично, если вывод состоялся, установка значения свойства не влияет на 
значение или вид документа. Например, Вы определили заголовок документа:</p>
<PRE><A NAME="1007016"></a>&lt;TITLE&gt;My JavaScript Page&lt;/TITLE&gt;</PRE>
<p><A NAME="1008366"></a>Он отражается в JavaScript как значение свойства <CODE>document.title</CODE>. 
После того как Navigator отобразил этот заголовок в строке заголовка окна Navigator&#39;а, Вы 
не можете изменить это значение в JavaScript. Если у Вас имеется такой скрипт 
далее на странице, он не изменит значение <CODE>document.title</CODE>, не 
повлияет на вид страницы или вызовет генерацию ошибки.</p>
<PRE><A NAME="1007018"></a>document.title = "The New Improved JavaScript Page"</PRE>
<p><A NAME="1007020"></a>Из этого правила есть несколько важных исключений: Вы можете 
динамически обновлять значения 
элементов. Например, следующий скрипт определяет текстовое поле, 
которое первоначально выводит строку &quot;Starting Value." При каждом щелчке по 
кнопке Вы добавляете текст "...Updated!" к этому значению.</p>
<PRE><A NAME="1007021"></a>&lt;FORM NAME="demoForm"&gt;<br>&lt;INPUT TYPE="text" NAME="mytext" SIZE="40" VALUE="Starting Value"&gt;<br>&lt;P&gt;&lt;INPUT TYPE="button" VALUE="Click to Update Text Field"<br>&nbsp;&nbsp;&nbsp;onClick="document.demoForm.mytext.value += '...Updated!' "&gt;<br>&lt;/FORM&gt;</PRE>
<p><A NAME="1009017"></a>Это простой пример обновления элемента формы после завершения вывода документа.</p>
<p><A NAME="1009035"></a>Используя обработчики событий, Вы можете также изменять некоторые другие 
свойства после завершения вывода документа, такие как <CODE>document.bgColor</CODE>.</p>
<H2><A NAME="Key Navigator Objects"><A NAME="1009022"></a>Ключевые объекты Navigator&#39;а</H2><hr>
<p><A NAME="1009186"></a>В этом разделе рассмотрены некоторые наиболее используемые объекты Navigator&#39;а: <CODE>window</CODE>, <CODE>Frame</CODE>, <CODE>document</CODE>, <CODE>Form</CODE>, <CODE>location</CODE>, <CODE>history</CODE> 
и <CODE>navigator</CODE>. Дополнительно об этих объектах см. книгу <I>
<a TARGET="_top" href="../clientref13/index.php">Клиентский JavaScript. </a></I>
<a href="../clientref13/index.php"><i>Справочник</i></a>.</p><H3><A NAME="Head2;"></a>
<A NAME="1010392"></a>Объекты window и Frame</H3><hr><p><A NAME="1004280"></a>
Объект <CODE>window</CODE> является "родительским" объектом для всех объектов в Navigator&#39;е. Вы 
можете создать несколько окон в приложении JavaScript. Объект <CODE>Frame</CODE> 
определяется тэгом <CODE>FRAME</CODE> в документе <CODE>FRAMESET</CODE>. <CODE>Frame</CODE>-объекты 
имеют те же свойства и методы, что и объекты <CODE>window</CODE>, и отличаются 
только способом отображения.</p><p><A NAME="1004281"></a>
Объект <CODE>window</CODE> имеет несколько широко используемых методов, в том числе:</p><ul><LI><A NAME="1004282"></a>
<CODE>open</CODE> и <CODE>close</CODE>: открывают и закрывают окно браузера; Вы 
можете специфицировать размер окна, его содержимое и наличие панели кнопок/button bar, 
адресной строки/location field и других "chrome"-атрибутов.</LI><LI><A NAME="1004283"></a>
<CODE>alert</CODE> - Выводит диалоговое окно Alert с сообщением.</LI><LI><A NAME="1004284"></a>
<CODE>confirm</CODE> - Выводит диалоговое окно Confirm с кнопками OK и Cancel.</LI><LI><A NAME="1004285"></a>
<CODE>prompt</CODE> - Выводит диалоговое окно Prompt с текстовым полем для ввода 
значения.</LI><LI><A NAME="1010362"></a><CODE>blur</CODE> и <CODE>focus</CODE> - Убирают и передают фокус окну.</LI><LI><A NAME="1010373"></a>
<CODE>scrollTo</CODE> - Прокручивает окно на специфицированные координаты.</LI><LI><A NAME="1012025"></a>
<CODE>setInterval</CODE> - Вычисляет выражение или вызывает функцию многократно 
по истечении специфицированного периода времени.</LI><LI><A NAME="1004286"></a>
<CODE>setTimeout</CODE> - Вычисляет выражение или вызывает функцию однократно по истечении специфицированного периода времени.</LI></ul>
<p><A NAME="1013954"></a><CODE>window</CODE> имеет также несколько свойств, которые могут устанавливаются 
Вами, таких как <CODE>location</CODE> и <CODE>status</CODE>.</p><p><A NAME="1008408"></a>
Вы можете установить <CODE>location</CODE> для перехода клиента к другому URL. Например, 
следующий оператор перенаправляет клиент на домашнюю страницу Netscape, как если 
бы пользователь щёлкнул по гиперссылке или как-нибудь иначе загрузил URL:</p>
<PRE><A NAME="1008402"></a>location = "http://home.netscape.com"</PRE><p><A NAME="1004287"></a>
Свойство <CODE>status</CODE> можно использовать для показа сообщения в статусной 
строке/status bar внизу клиентского окна; дополнительно см. <A HREF="advtopic.php#1006028">"Использование 
Статусной Строки"</a>.</p><p><A NAME="1015199"></a>
Об окнах и фрэймах см. дополнительно <A HREF="windows.php#996824">Главу 12 "Использование 
Окон и Фрэймов&quot;</a>. В данной книге не рассматривается полный набор методов и 
свойств объекта <CODE>window</CODE>. Полный список см. в книге <I>
<a TARGET="_top" href="../clientref13/index.php">Клиентский JavaScript. </a></I>
<a href="../clientref13/index.php"><i>Справочник</i></a>.</p><H3><A NAME="Head2;"></a>
<A NAME="1015208"></a>Объект document</H3><hr><p><A NAME="1018064"></a>
Каждая страница имеет единственный объект <CODE>document</CODE>.</p><p><A NAME="1004290"></a>
Поскольку его методы <CODE>write</CODE> и <CODE>writeln</CODE> генерируют HTML, 
объект <CODE>document</CODE> является одним из наиболее используемых объектов Navigator&#39;а. 
О методах <CODE>write</CODE> и <CODE>writeln</CODE> см. раздел <A HREF="#1016546">"Использование Метода write"</a>.</p>
<p><A NAME="1008427"></a>Объект <CODE>document</CODE> имеет несколько свойств, отражающих цвет фона, 
текста и гиперссылок страницы: <CODE>bgColor</CODE>, <CODE>fgColor</CODE>, <CODE>linkColor</CODE>, <CODE>alinkColor</CODE> 
и <CODE>vlinkColor</CODE>. Часто используются <CODE>lastModified</CODE>, дата 
последнего изменения страницы, <CODE>referrer</CODE>, предыдущий URL, посещённый 
клиентом, и <CODE>URL</CODE>, URL документа. Свойство <CODE>cookie</CODE> даёт 
возможность устанавливать и получать значения кук; см. также <A HREF="advtopic.php#1017771">"Использование Кук"</a>.</p>
<p><A NAME="1010134"></a>Объект <CODE>document</CODE> является предком всех объектов <CODE>Anchor</CODE>, <CODE>Applet</CODE>, <CODE>Area</CODE>, <CODE>Form</CODE>, <CODE>Image</CODE>, <CODE>Layer</CODE>, <CODE>Link</CODE> 
и <CODE>Plugin</CODE> страницы.</p><p><A NAME="1010205"></a>
Пользователи могут печатать и сохранять сгенерированный HTML, используя команды 
меню File Navigator&#39;а (JavaScript&nbsp;1.1 и позднее).</p><H3><A NAME="Head2;"></a>
<A NAME="1010137"></a>Объект Form</H3><hr><p><A NAME="1004294"></a>
Каждая форма документа создаёт объект <CODE>Form</CODE>. Поскольку в документе 
может быть не одна форма, <CODE>Form</CODE>-объекты хранятся в массиве <CODE>forms</CODE>. 
Первая форма (самая верхняя на странице) это <CODE>forms[0]</CODE>, вторая - <CODE>forms[1]</CODE>, 
и так далее. Помимо обращения к форме по имени, Вы можете обратиться к первой (например) форме так:</p>
<PRE><A NAME="1004301"></a>document.forms[0]</PRE><p><A NAME="1004302"></a>
Другие элементы формы, такие как текстовые поля, радио-кнопки и т.д., хранятся в 
массиве <CODE>elements</CODE>. Вы можете обратиться к первому элементу (независимо 
от его вида) первой формы так:</p><PRE><A NAME="1006532"></a>document.forms[0].elements[0]</PRE>
<p><A NAME="1011487"></a>Каждый элемент формы имеет свойство <CODE>form</CODE>, которое является ссылкой 
на  родительскую форму элемента. Это свойство используется в основном в обработчиках событий, 
где может понадобиться обратиться к другому элементу на текущей форме. В 
следующем примере форма <CODE>myForm</CODE> содержит <CODE>Text</CODE>-объект и 
кнопку. Если пользователь щёлкает по кнопке, значением <CODE>Text</CODE>-объекта 
становится имя формы. Обработчик <CODE>onClick</CODE> кнопки использует <CODE>this.form</CODE> 
для обращения к родительской форме, <CODE>myForm</CODE>.</p>
<PRE><A NAME="1011510"></a>&lt;FORM NAME="myForm"&gt;<br>Form name:&lt;INPUT TYPE="text" NAME="text1" VALUE="Beluga"&gt;<br>&lt;P&gt;<br>&lt;INPUT NAME="button1" TYPE="button" VALUE="Show Form Name"<br>&nbsp;&nbsp;&nbsp;onClick="this.form.text1.value=this.form.name"&gt;<br>&lt;/FORM&gt;</PRE>
<H3><A NAME="Head2;"></a><A NAME="1004213"></a>Объект location</H3><hr><p><A NAME="1006560"></a>
Объект <CODE>location</CODE> имеет свойства на основе текущего URL. Например, 
свойство <CODE>hostname</CODE> это сервер и имя домена сервера - хоста текущего документа.</p><p>
<A NAME="1010450"></a>Объект <CODE>location</CODE> имеет два метода:</p><ul><LI><A NAME="1010455"></a>
<CODE>reload</CODE> - форсирует перезагрузку текущего документа окна.</LI><LI><A NAME="1010464"></a>
<CODE>replace</CODE> - загружает специфицированный URL поверх текущего вхождения списка history.</LI></ul>
<H3><A NAME="Head2;"></a><A NAME="1010406"></a>Объект history</H3><hr><p><A NAME="1006577"></a>
Объект <CODE>history</CODE> содержит список строк, представляющих URL&#39;ы, 
посещённые клиентом. Вы можете получить текущее, предыдущее и следующее 
вхождение из history через использование свойств <CODE>current</CODE>, <CODE>next</CODE> 
и <CODE>previous</CODE> объекта <CODE>history</CODE>. Вы получить доступ к 
другим значениям в history, используя массив <CODE>history</CODE>. Этот массив 
содержит вхождение для каждого вхождения history в порядке исходного кода; 
каждое вхождение массива это строка, содержащая URL.</p><p><A NAME="1011397"></a>
Можно также перенаправить клиент к любому вхождению списка history методом <CODE>go</CODE>. Например, следующий код 
загружает URL, находящийся на две позиции назад в списке history клиента.</p>
<PRE><A NAME="1006582"></a>history.go(-2)</PRE><p><A NAME="1006583"></a>
Следующий код перезагружает текущую страницу:</p><PRE><A NAME="1006584"></a>history.go(0)</PRE>
<p><A NAME="1006585"></a>Список history отображается в меню Go Navigator&#39;а.</p><H3><A NAME="Head2;"></a>
<A NAME="1011844"></a>Объект navigator</H3><hr><p><A NAME="1011845"></a>
Объект <CODE>navigator</CODE> содержит информацию о версии используемого Navigator&#39;а. Например, 
свойство <CODE>appName</CODE> специфицирует имя браузера, а свойство <CODE>appVersion</CODE> специфицирует 
версию Navigator&#39;а.</p><p><A NAME="1011846"></a>Объект <CODE>navigator</CODE> имеет три метода:</p>
<ul><LI><A NAME="1011847"></a><CODE>javaEnabled</CODE> специфицирует, включен ли Java</LI><LI><A NAME="1014002"></a>
<CODE>preference</CODE> позволяет использовать маркированный скрипт для 
получения различных пользовательских настроек (JavaScript&nbsp;1.2 и позднее)</LI><LI><A NAME="1017090"></a>
<CODE>taintEnabled</CODE> специфицирует, включено ли разрушение данных/tainting (только JavaScript&nbsp;1.1)</LI></ul>
<H2><A NAME="Navigator Object Arrays"><A NAME="1017919"></a>Массивы объектов Navigator&#39;а</H2><hr>
<p><A NAME="1017920"></a>Некоторые объекты Navigator&#39;а имеют свойства, значения 
которых являются массивами. Эти массивы используются для хранения информации, 
когда Вы заранее не знаете, сколько будет значений. В таблице показано, какие 
свойства каких объектов имеют массивы в качестве значений.</p><A NAME="1018013"></a>
<h6 style="text-align: center"><A NAME="1017924"></a>Таблица 11.2 Предопределённые массивы JavaScript</h6>
<TABLE BORDER="2" CELLPADDING=5><TR><TH><A NAME="1017930"></a>
Объект<TH><A NAME="1017932"></a>Свойство<TH><A NAME="1017934"></a>
Описание<TR><TD VALIGN=baseline ALIGN=left COLSPAN=1 ROWSPAN=7>
<PRE><A NAME="1017936"></a>document</PRE><TD><PRE><A NAME="1017938"></a>anchors</PRE><TD><P><A NAME="1017940"></a>
Отражает тэги <CODE>&lt;A&gt;</CODE> документа, содержащие атрибут <CODE>NAME</CODE>, в порядке
расположения в исходном коде.</P>
<TR><TD><PRE><A NAME="1017944"></a>applets</PRE><TD><P><A NAME="1017946"></a>
Отражает тэги <CODE>&lt;APPLET&gt;</CODE> в порядке расположения в исходном коде.</P>
<TR><TD><PRE><A NAME="1017950"></a>embeds</PRE><TD><P><A NAME="1017952"></a>
Отражает тэги <CODE>&lt;EMBED&gt;</CODE> в порядке расположения в исходном коде.</P>
<TR><TD><PRE><A NAME="1017956"></a>forms</PRE><TD><P><A NAME="1017958"></a>
Отражает тэги <CODE>&lt;FORM&gt;</CODE> в порядке расположения в исходном коде.</P>
<TR><TD><PRE><A NAME="1017962"></a>images</PRE><TD><P><A NAME="1017964"></a>
Отражает тэги <CODE>&lt;IMG&gt;</CODE> в порядке расположения в исходном коде (изображения, 
созданные конструктором <CODE>Image()</CODE>, не включаются в массив <CODE>images</CODE>).</P>
<TR><TD><PRE><A NAME="1018276"></a>layers</PRE><TD><P><A NAME="1018278"></a>
Отражает тэги <CODE>&lt;LAYER&gt;</CODE> и <CODE>&lt;ILAYER&gt;</CODE> в порядке расположения в исходном коде.</P>
<TR><TD><PRE><A NAME="1017968"></a>links</PRE><TD><P><A NAME="1017970"></a>
Отражает тэги <CODE>&lt;AREA&nbsp;HREF="..."&gt;</CODE>, <CODE>&lt;A&nbsp;HREF=""&gt;</CODE>, 
и объекты <CODE>Link</CODE>, созданные методом <CODE>link</CODE>, в порядке расположения в исходном коде.</P>
<TR><TD><PRE><A NAME="1017978"></a>Form</PRE><TD><PRE><A NAME="1017980"></a>elements</PRE><TD><P><A NAME="1017982"></a>
Отражает элементы формы (такие как объекты <CODE>Checkbox</CODE>, <CODE>Radio</CODE> и <CODE>Text</CODE>) в порядке расположения в исходном коде.</P>
<TR><TD><PRE><A NAME="1018305"></a>Function</PRE><TD><PRE><A NAME="1018307"></a>arguments</PRE><TD><P><A NAME="1018309"></a>
Отражает аргументы функции.</P><TR><TD VALIGN=baseline ALIGN=left COLSPAN=1 ROWSPAN=2><PRE><A NAME="1017984"></a>navigator</PRE><TD><PRE><A NAME="1017986"></a>mimeTypes</PRE><TD><P><A NAME="1017988"></a>
Отражает все MIME-типы, поддерживаемые клиентом (внутренне, через вспомогательные приложения или через plug-in'ы).</P>
<TR><TD><PRE><A NAME="1017992"></a>plugins</PRE><TD><P><A NAME="1017994"></a>
Отражает все plug-in'ы, установленные на клиенте, в порядке расположения в исходном коде.</P>
<TR><TD><PRE><A NAME="1017996"></a>select</PRE><TD><PRE><A NAME="1017998"></a>options</PRE><TD><P><A NAME="1018000"></a>
Отражает опции объекта <CODE>Select</CODE> (тэги <CODE>&lt;OPTION&gt;</CODE>) в порядке расположения в исходном коде.</P>
<TR><TD VALIGN=baseline ALIGN=left COLSPAN=1 ROWSPAN=2><PRE><A NAME="1018002"></a>window</PRE><TD><PRE><A NAME="1018004"></a>frames</PRE><TD><P><A NAME="1018006"></a>
Отражает все тэги <CODE>&lt;FRAME&gt;</CODE> в окне, содержащем тэг <CODE>&lt;FRAMESET&gt;</CODE>, в порядке расположения в исходном коде.</P>
<TR><TD><PRE><A NAME="1018010"></a>history</PRE><TD><P><A NAME="1018012"></a>
Отражает вхождения history окна.</P></TABLE><p><A NAME="1018015"></a>
Вы можете индексировать порядковыми числами или по именам (если определены). Например, 
если второй тэг <CODE>&lt;FORM&gt;</CODE> имеет в атрибуте <CODE>NAME</CODE> 
значение "myForm", Вы можете обратиться к форме <CODE>document.forms[1]</CODE>, 
или <CODE>document.forms["myForm"]</CODE> или <CODE>document.myForm</CODE>.</p><p><A NAME="1018018"></a>
Например, определён следующий элемент:</p><PRE><A NAME="1018019"></a>&lt;INPUT TYPE="text" NAME="Comments"&gt;</PRE>
<p><A NAME="1018322"></a>Если Вы хотите обратиться к этому элементу формы по имени, можно специфицировать <CODE>document.forms["Comments"]</CODE>.</p>
<p><A NAME="1018329"></a>Все предопределённые массивы JavaScript имеют свойство length, которое указывает 
количество элементов массива. Например, чтобы получить количество форм в 
документе, используйте свойство <CODE>length</CODE>: <CODE>document.forms.length</CODE>.</p><p><B><A NAME="HeadRunIn;"></a>
<A NAME="1018323"></a>JavaScript 1.0. </B><A NAME="1018324"></a>
Вы обязаны индексировать массивы порядковыми числами, например <CODE>document.forms[0]</CODE>.</p>
<H2><A NAME="Using the write Method"><A NAME="1016546"></a>Использование метода write</H2><hr>
<p><A NAME="1016617"></a>Метод <CODE>write</CODE> объекта <CODE>document</CODE> отображает вывод в Navigator&#39;е. "Зачем?&quot;, 
спросите Вы, "ведь это уже делает HTML&quot;. Но в скрипте можно сделать то, чего не 
может обычный HTML. Например, Вы можете вывести текст на основе выполнения 
условия или аргументов переменной. Поэтому <CODE>write</CODE> это один из наиболее часто используемых методов JavaScript.</p>
<p><A NAME="1016548"></a>Метод <CODE>write</CODE> принимает любое количество строковых аргументов, 
которые могут быть строковыми литералами или переменными. Вы можете также 
использовать операцию конкатенации строк (+) для создания одной строки из 
нескольких при помощи оператора <CODE>write</CODE>.</p><p><A NAME="1016549"></a>
Вот скрипт, генерирующий динамический HTML с помощью JavaScript:</p>
<PRE><A NAME="1016550"></a>&lt;HEAD&gt; <br>&lt;SCRIPT&gt;<br>&lt;!--- Скрываем скрипт от старых браузеров<br>
// Эта функция отображает горизонтальную линию специфицированной ширины<br>function bar(widthPct) {<br>&nbsp;&nbsp;&nbsp;document.write("&lt;HR ALIGN='left' WIDTH=" + widthPct + "%&gt;");<br>}</PRE><PRE><A NAME="1016551"></a>// Эта функция отображает заголовок текста специфицированного уровня и некоторый текст<br>function output(headLevel, headText, text) {<br>&nbsp;&nbsp;&nbsp;document.write("&lt;H", headLevel, "&gt;", headText, "&lt;/H",<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;headLevel, "&gt;&lt;P&gt;", text)<br>}<br>// конец скрытия скрипта --&gt;<br>&lt;/SCRIPT&gt;<br>&lt;/HEAD&gt;</PRE><PRE><A NAME="1016552"></a>&lt;BODY&gt;<br>&lt;SCRIPT&gt;<br>&lt;!--- Скрываем скрипт от старых браузеров<br>bar(25) <br>output(2, "JavaScript Rules!", "Using JavaScript is easy...")<br>// конец скрытия скрипта --&gt;<br>&lt;/SCRIPT&gt;<br>&lt;P&gt; This is some standard HTML, unlike the above that is generated.<br>&lt;/BODY&gt;</PRE>
<p><A NAME="1016553"></a>В HEAD этого документа определены две функции:</p><ul><LI><A NAME="1016554"></a>
<CODE>bar</CODE>, которая отображает горизонтальную линию HTML, имеющую ширину, 
специфицированную аргументом функции.</LI><LI><A NAME="1016555"></a>
<CODE>output</CODE>, которая отображает заголовок HTML того уровня, который 
специфицирован первым аргументом, и текст параграфа, специфицированный третьим аргументом.</LI></ul><p><A NAME="1016556"></a>
Затем в тэге <CODE>BODY</CODE> документа эти две функции вызываются и дают на выходе:</p><h6 align="center"><A NAME="1016564"></a>
Рисунок 11.2&nbsp;&nbsp;&nbsp;Вывод, созданный с использованием функций JavaScript</h6><P>
<IMG SRC="graphics/gs1.gif" width="462" height="206"></a>></P><p><A NAME="1016565"></a>
Следующая строка создаёт вывод функции <CODE>bar</CODE>:</p>
<PRE><A NAME="1016566"></a>document.write("&lt;HR ALIGN='left' WIDTH=", widthPct, "%&gt;")</PRE>
<p><A NAME="1016567"></a>Заметьте, что в определении <CODE>bar</CODE> использованы знаки одинарных 
кавычек вместо двойных. Вы обязаны делать так при обозначении закавыченной 
строки внутри строкового литерала. Затем вызов <CODE>bar</CODE> с аргументом 25 
производит вывод, эквивалентный следующему HTML:</p>
<PRE><A NAME="1016568"></a>&lt;HR ALIGN="left" WIDTH=25%&gt;</PRE><p><A NAME="1016570"></a>
<CODE>write</CODE> сопутствующий метод <CODE>writeln</CODE>, который добавляет 
последовательность символов &quot;новая строка&quot; (возврат каретки или возврат каретки 
+ прогон строки, в зависимости от платформы) в конец своего вывода. Поскольку HTML 
обычно игнорирует символы новой строки, разницы между <CODE>write</CODE> и <CODE>writeln</CODE> 
нет, за исключением положения внутри таких тэгов, как <CODE>PRE</CODE>.</p>
<H3><A NAME="Head2;"></a><A NAME="1016574"></a>Печать вывода</H3><hr><p><A NAME="1016575"></a>
Navigator версии 3.0 печатает вывод, созданный в JavaScript. Для распечатки 
вывода, пользователь выбирает Print из меню File Navigator'а. Navigator&nbsp;2.0 
<i>не</i> распечатывает вывод, создаваемый JavaScript.</p><p><A NAME="1016576"></a>
Если Вы распечатываете страницу, содержащую слои/layers (Navigator&nbsp;4.0 и 
позднее), каждый слой печатается отдельно на той же странице. Например, если три 
слоя перекрывают друг друга в браузере, распечатанная страница показывает каждый слой отдельно.</p>
<p><A NAME="1016577"></a>Если Вы выбрали Page Source из меню View Navigator'а 
или View Frame Source из контекстного меню (правой клавишей мыши), web-браузер 
отображает содержимое HTML-файла со сгенерированным HTML. Если Вы хотите 
просмотреть исходный HTML со скриптами генерирующими HTML (с методами <CODE>document.write</CODE> 
и <CODE>document.writeln</CODE>), не используйте меню Page Source и View Frame Source. 
Тогда используйте протокол <CODE>view-source:</CODE>. Например, предположим, 
файл <CODE>file://c|/test.phpl</CODE> содержит такой текст:</p>
<PRE><A NAME="1016578"></a>&lt;HTML&gt;<br>&lt;BODY&gt;<br>Hello, <br>&lt;SCRIPT&gt;document.write(" there.")&lt;/SCRIPT&gt;<br>&lt;/BODY&gt;<br>&lt;/HTML&gt;</PRE>
<p><A NAME="1016579"></a>При загрузке этого URL браузер выведет:</p><PRE><A NAME="1016580"></a>Hello, there.</PRE>
<p><A NAME="1016581"></a>Если выбрать Page Source из меню View, браузер выведет:</p>
<PRE><A NAME="1016582"></a>&lt;HTML&gt;<br>&lt;BODY&gt;<br>Hello, <br>&nbsp;there.<br>&lt;/BODY&gt;<br>&lt;/HTML&gt;</PRE>
<p><A NAME="1016583"></a>Если загрузить <CODE>view-source:file://c|/test.phpl</CODE>, браузер выведет:</p>
<PRE><A NAME="1016584"></a>&lt;HTML&gt;<br>&lt;BODY&gt;<br>Hello, <br>&lt;SCRIPT&gt;document.write(" there.")&lt;/SCRIPT&gt;<br>&lt;/BODY&gt;<br>&lt;/HTML&gt;</PRE>
<H3><A NAME="Head2;"></a><A NAME="1016870"></a>Отображение вывода</H3><hr><p><A NAME="1016871"></a>
JavaScript в Navigator'е генерирует результат, проходя 
по странице сверху вниз. После отображения текста Вы не можете изменять его без 
перезагрузки страницы. В общем случае, Вы не можете обновлять часть страницы без 
обновления всей страницы. Однако можно обновлять отдельно:</p><ul><LI><A NAME="1016872"></a>
Содержимое слоя.</LI><LI><A NAME="1016875"></a>
"Подокно" во фрэйме. См. <A HREF="windows.php#996824">Главу 12 "Использование 
Окон и Фрэймов &quot;</a>.</LI><LI><A NAME="1016879"></a>
Элементы формы; см. <A HREF="evnt.php#1009637">"Примеры: Использование Обработчика События"</a>.</LI></ul>
<h5><a href="contents.php">Оглавление</a> | <a href="evnt.php">Назад</a>
| <a href="windows.php">Вперёд</a> | <a href="bklast.php">Индекс</a></h5>
<hr>
</BODY></HTML>
<?
include_once '../../sys/inc/tfoot.php';
?>