<?include'h.php';?>
<html><head>
		<title>Учебник PHP, Глава 13</title>
		<meta http-equiv="Content-type" content="text/html; charset=Windows-1251">
		</head>
		
      <DIV class=infotxt>
      <LI><A href="#a">Глава 13. Cookie и 
      отслеживание сеанса</A> 
      <UL>
        <LI><A href="#b">Что такое Cookie?</A> 
        <UL>
          <LI><A href="#c">Компоненты Cookie</A> 
          <LI><A href="#d">Cookie и PHP</A> 
        </LI></UL>
        <LI><A href="#e">Уникальные 
        идентификаторы</A> 
        <LI><A href="#f">Отслеживание сеанса</A> 
        <UL>
          <LI><A href="#g">Назначение 
          пользовательских функций для хранения сеансовых данных</A> </LI></UL>
        <LI><A href="#h">Проект: журнал посещений 
        сайта</A> 
        <LI><A href="#i">Итоги</A> </LI></UL>
      <UL></UL>
      <P>&nbsp;</P>
      <P><A name=a></A>ГЛАВА 13</P>
      <P>Cookie и отслеживание сеанса</P>
      <P>Отслеживание пользователей и персональная настройка сайта относятся к 
      числу самых популярных и вместе с тем неоднозначно воспринимаемых 
      возможностей web-сайтов. Преимущества очевидны — вы можете предлагать 
      пользователям именно ту информацию, которая их интересует. С другой 
      стороны, возникает немало вопросов, связанных с конфиденциальностью, 
      поскольку появляется возможность «следить» за тем, как пользователь 
      перемещается от страницы к странице и даже от сайта к сайту.</P>
      <P>Если отвлечься от проблем конфиденциальности, отслеживание 
      пользовательских данных с применением cookie или других средств приносит 
      огромную пользу как пользователю, так и сайту, обеспечивающему эти 
      возможности. Пользователь выигрывает от того, что содержание сайта 
      настраивается в соответствии с его личными предпочтениями, а из сайта 
      исключается бесполезная или не представляющая интереса информация. Для 
      администратора сайта отслеживание пользовательских предпочтений открывает 
      совершенно новый уровень взаимодействия с пользователем, включая 
      возможности целевого маркетинга и анализа популярности материалов сайта. В 
      Web, где сейчас преобладает электронная коммерция, эти возможности стали 
      практически стандартными.</P>
      <P>Концепция «наблюдения» за пользователем в процессе перемещения по сайту 
      обычно называется «отслеживанием сеанса» (session tracking). Принимая во 
      внимание огромный объем полезной информации, получаемой в результате 
      отслеживания сеанса на сайте, можно сказать, что преимущества отслеживания 
      сеансов и персональной настройки содержания сайта значительно превышают 
      любые недостатки. Вряд ли эту книгу можно было бы считать полноценным 
      учебником по РНР, если бы я не посвятил в ней целую главу средствам 
      отслеживания сеанса в РНР. В этой главе мы рассмотрим некоторые концепции, 
      имеющие непосредственное отношение к отслеживанию сеансов, а именно — 
      cookie и их применение, а также уникальные идентификаторы сеансов. Глава 
      завершается сводкой стандартных функций РНР, предназначенных для 
      отслеживания сеансов.</P>
      <P><A href="http.html://doks.gorodok.net/0" name=b></A>Что такое cookie?</P>
      <P>Cookie представляет собой небольшой пакет информации, переданный 
      web-сервером и хранящийся на клиентском компьютере. В cookie можно 
      сохранить полезные данные, описывающие состояние пользовательского сеанса, 
      чтобы в будущем загрузить их и восстановить параметры сеансовой связи 
      между сервером и клиентом. Cookie используются на многих сайтах Интернета 
      для расширения возможностей пользователя и повышения эффективности сайта 
      за счет отслеживания действий и личных предпочтений пользователя. 
      Возможность хранения этих сведений играет ключевую роль на сайтах 
      электронной коммерции, поддерживающих персональную настройку и целевую 
      рекламу.</P>
      <P>Вследствие того, что cookie обычно связываются с конкретным 
      пользователем, в них часто сохраняется уникальный идентификатор 
      пользователя (UIN). Этот идентификатор заносится в базу данных на сервере 
      и используется в качестве ключа для выборки из базы всей информации, 
      связанной с этим идентификатором. Конечно, сохранение UIN в cookie не 
      является обязательным требованием; вы можете сохранить любую информацию 
      при условии, что ее общий объем не превосходит 4 Кбайт (4096 байт).</P>
      <P><A name=c></A>Компоненты cookie</P>
      <P>В cookie хранятся и другие компоненты, при помощи которых разработчик 
      может ограничивать использование cookie с позиций домена, пути, срока 
      действия и безопасности. Ниже приведены описания различных компонентов 
      cookie:</P>
      <UL>
        <LI>Имя — имя cookie является обязательным параметром, по которому 
        программа ссылается на cookie. Можно провести аналогию между именем 
        cookie и именем переменной. 
        <LI>Значение — фрагмент данных, связанный с именем cookie. В этих данных 
        может храниться любая информация — идентификатор пользователя, цвет 
        фона, текущая дата и т. д. 
        <LI>Срок действия — дата, определяющая продолжительность существования 
        cookie. Как только текущая дата и время превосходят заданный срок 
        действия, cookie становится недействительным и перестает использоваться. 
        В соответствии со спецификацией cookie устанавливать срок действия для 
        cookie необязательно. Тем не менее, средства РНР для работы с cookie 
        требуют, чтобы срок действия устанавливался. Согласно спецификации, если 
        срок действия не указан, cookie становится недействительным в конце 
        сеанса (то есть когда пользователь покидает сайт). 
        <LI>Домен — домен, который создал cookie и может читать его значение. 
        Если домен состоит из нескольких серверов и доступ к cookie должен быть 
        разрешен всем серверам, то имя домена можно задать в форме 
        .phprecipes.com. В этом случае все потенциальные домены третьего уровня, 
        принадлежащие сайту PHPrecipes (например, wap.phprecipes.com или 
        news.phprecipes.com), смогут работать с cookie. По соображениям 
        безопасности cookie могут устанавливаться только для домена сервера, 
        пытающегося создать cookie. Данный компонент необязателен; если он не 
        указан, по умолчанию используется имя домена, из которого было полу; 
        чено значение cookie. 
        <LI>Путь — URL, с которого предоставляется доступ к cookie. Любые 
        попытки получения доступа к cookie за пределами этого пути пресекаются. 
        Данный компонент необязателен; если он не задан, по умолчанию 
        используется путь к документу, создавшему cookie. 
        <LI>Безопасность — параметр, показывающий, допускается ли чтение cookie 
        в небезопасной среде. По умолчанию используется значение FALSE. </LI></UL>
      <P>Хотя при создании cookie используются одни и те же синтаксические 
      правила, формат хранения cookie зависит от браузера. Например, Netscape 
      Communicator хранит cookie в формате следующего вида:</P>
      <P>.phprecipes.com&nbsp; FALSE&nbsp; /&nbsp; FALSE&nbsp; 97728956&nbsp; 
      bgcolor&nbsp; blue</P>
      <P>В Internet Explorer то же самое cookie выглядело бы иначе:</P>
      <P>bgcolor</P>
      <P>blue</P>
      <P>localhost/php4/php.exe/book/13/</P>
      <P>0</P>
      <P>2154887040</P>
      <P>29374385</P>
      <P>522625408</P>
      <P>29374377</P>
      <P>*</P>
      <P>Чтобы просмотреть cookie, сохраненные браузером Internet Explorer, 
      достаточно открыть их в любом текстовом редакторе. Помните, что некоторые 
      редакторы не обрабатывают завершающие символы новой строки и на месте этих 
      символов в документе могут выводиться квадратики.</P>
      <P>Internet Explorer сохраняет свои cookie в папке с именем «Cookies», a 
      Netscape Communicator использует для этой цели один файл с именем 
      cookies.</P>
      <P><A name=d></A>Cookie и РНР</P>
      <P>Хватит теории. Конечно, вам не терпится поскорее узнать, как задать 
      значение cookie в РНР. Оказывается, очень просто — для этой цели 
      используется стандартная функция setcookie( ).</P>
      <P>Функция setcookie( ) сохраняет cookie на компьютере пользователя. 
      Синтаксис функции setcookie( ):</P>
      <P>int setcookie (string имя [string значение [, int дата [, string путь 
      [, string домен [, int безопасность]]]]])</P>
      <P>Если вы прочитали общие сведения о cookie, то смысл параметров 
      setcookie( ) вам уже известен. Если вы пропустили этот раздел и не знакомы 
      с компонентами cookie, я рекомендую вернуться к началу главы и перечитать 
      его, поскольку все параметры setcookie( ) были описаны выше.</P>
      <P>Прежде чем следовать дальше, я попрошу вас перечитать следующую фразу 
      не один и не два, а целых три раза. Значение cookie должно устанавливаться 
      до передачи в браузер любой другой информации, относящейся к странице. 
      Напишите эту фразу 500 раз в тетрадке, сделайте татуировку, научите своего 
      попугая произносить эти слова — короче, проявите фантазию. Другими 
      словами, значение cookie не может устанавливаться в произвольном месте 
      web-страницы. Оно должно быть задано до отправки любых данных в браузер; в 
      противном случае cookie не будет работать.</P>
      <P>Есть еще одно важное ограничение, о котором также необходимо помнить, — 
      вы не сможете создать cookie и использовать его на той же странице. Либо 
      пользователь должен вручную обновить страницу (хотя рассчитывать на это 
      нельзя), либо вам придется подождать следующего запроса этой страницы — и 
      только после этого можно будет использовать cookie.</P>
      <P>В следующем примере функция setcookie( ) используется для создания 
      cookie с идентификатором пользователя:</P>
      <P>$userid = "4139b31b7bab052";</P>
      <P>$cookie_set = setcookie ("uid", $value, time()+3600, "/", 
      ".phprecipes.com", 0);</P>
      <P>Последствия создания cookie:</P>
      <UL>
        <LI>После перезагрузки или перехода на другую страницу становится 
        доступной переменная $userid, содержащая идентификатор 4139b31b7bab052. 
        <LI>Срок действия cookie истекает ровно через один час (3600 секунд) 
        после отправки. После истечения этого срока cookie становится 
        недействительным. 
        <LI>Доступ к cookie разрешен только из домена phprecipes.com. 
        <LI>Разрешен доступ к cookie через небезопасный протокол. </LI></UL>
      <P>В следующем примере (листинг 13.1) cookie используется для хранения 
      параметров форматирования страницы (в данном случае — цвета фона). 
      Обратите внимание: значение cookie задается лишь в результате выполнения 
      действия, установленного для формы.</P>
      <P>Листинг 13.1. Сохранение цвета фона, выбранного пользователем</P>
      <P>&lt;?</P>
      <P>// Если переменная $bgcolor существует</P>
      <P>if (isset($bgcolor)) :</P>
      <P>setcookie("bgcolor", $bgcolor, time()+3600);</P>
      <P>?&gt;</P>
      <P>&lt;html&gt;</P>
      <P>&lt;body bgcolor="&lt;?=$bgcolor:?&gt;"&gt;</P>
      <P>&lt;?</P>
      <P>// Значение $bgcolor не задано, отобразить форму</P>
      <P>else :</P>
      <P>&lt;body bgcolor="white"&gt;</P>
      <P>&lt;form action="&lt;? print $PHP_SELF; ?&gt;</P>
      <P>method=="post"&gt;</P>
      <P>What's your favorite background color?</P>
      <P>&lt;select name="bgcolor"&gt;</P>
      <P>&lt;option value="red"&gt;red</P>
      <P>&lt;option value="blue"&gt;blue</P>
      <P>&lt;option value="green"&gt;green</P>
      <P>&lt;option value="b1ack"&gt;black</P>
      <P>&lt;/select&gt;</P>
      <P>&lt;input type="submit" value="Set background color"&gt;</P>
      <P>&lt;/form&gt;</P>
      <P>&lt;?</P>
      <P>endif;</P>
      <P>?&gt;</P>
      <P>&lt;/body&gt;</P>
      <P>&lt;/html&gt;</P>
      <P>При загрузке в браузер сценарий проверяет, было ли задано значение 
      переменной $bgcolor. Если переменная существует, для страницы выбирается 
      цвет фона, определяемый переменной $bgcolor. В противном случае в браузере 
      выводится форма HTML с предложением выбрать цвет фона. После выбора цвета 
      значение $bgcolor будет распознаваться при последующей перезагрузке той же 
      страницы или при переходе к другой странице.</P>
      <P>Кстати говоря, имена cookie могут выглядеть как элементы массива. Вы 
      можете использовать имена вида uid[1], uid[2], uid[3] и т. д., а затем 
      работать с ними, как с элементами обычного массива. Пример приведен в 
      листинге 13.2.</P>
      <P>Листинг 13.2.</P>
      <P>&lt;?</P>
      <P>setcookie("phprecipes[uid]", "4139b31b7bab052", time( )+3600); 
      setcookie("phprecipes[color]", "black", time( )+3600); 
      setcookie("phprecipes[preference]", "english", timeO+3600);</P>
      <P>if (isset($phprecipes)) :</P>
      <P>while (list ($name, $value) = each ($phprecipes)) :</P>
      <P>echo "$name = $value&lt;br&gt;\n";</P>
      <P>endwhile;</P>
      <P>endif:</P>
      <P>?&gt;</P>
      <P>В результате выполнения этого фрагмента будет выведен следующий 
      результат (а на клиентском компьютере будут созданы три cookie):</P>
      <P>uid = 4139b31b7bab052</P>
      <P>color = black</P>
      <P>preference = english</P>
      <P>Хотя массивы cookie очень удобны для хранения всевозможной информации, 
      следует помнить, что некоторые браузеры ограничивают количество 
      создаваемых cookie (например, Netscape Communicator разрешает создавать до 
      20 cookie на домен).</P>
      <P>Cookie чаще всего применяются для хранения числовых идентификаторов 
      (UIN), по которым в дальнейшем на сервере производится выборка 
      информации,</P>
      <P>относящейся к данному пользователю. Этот процесс продемонстрирован в 
      листинге 13.3, где UIN сохраняется в базе данных MySQL. Сохраненные данные 
      впоследствии используются для настройки параметров форматирования 
      страницы.</P>
      <P>Допустим, у нас имеется таблица userjnfo в базе данных с именем user. В 
      ней хранятся следующие атрибуты пользователя: идентификатор, имя и адрес 
      электронной почты пользователя. Определение таблицы выглядит так:</P>
      <P>mysql&gt;create table user_info (</P>
      <P>-&gt;user_id char (18),</P>
      <P>-&gt;fname char(15),</P>
      <P>-&gt;email char(35));</P>
      <P>По сравнению с полноценными сценариями регистрации пользователя, работа 
      листинга 13.3 начинается «на половине пути»: предполагается, что данные 
      пользователя (идентификатор, имя и адрес электронной почты) уже хранятся в 
      базе данных. Чтобы пользователю не приходилось вводить всю информацию 
      заново, идентификатор (в листинге 13.3 для простоты он равен 15) 
      загружается из cookie на клиентском компьютере.</P>
      <P>Листинг 13.3. Загрузка информации пользователя из базы данных</P>
      <P>&lt;?</P>
      <P>if (! isset($userid)) :</P>
      <P>$id = 15;</P>
      <P>setcookie ("userid", $id, time( )+3600);</P>
      <P>print "A cookie containing your userID has been set on your 
machine.</P>
      <P>Please refresh the page to retrieve your user information";</P>
      <P>else:</P>
      <P>@mysql_connect("localhost", "web", "4tf9zzzf") or die("Could not 
      connect to MySQL server!");</P>
      <P>@mysql_select_db("user") or die("Could not select user database!");</P>
      <P>// Объявить запрос</P>
      <P>$query = "SELECT * FROM users13 WHERE user_id = '$userid'";</P>
      <P>// Выполнить запрос</P>
      <P>$result = mysql_query($query)l;</P>
      <P>// Если совпадение будет найдено, вывести данные пользователя.</P>
      <P>if (mysql_num_rows($result) == 1) :</P>
      <P>$row = mysql_fetch_array($result);</P>
      <P>print "Hi ".$row["?name"].",&lt;br&gt;";</P>
      <P>print "Your email address is ".$row[ "email"];</P>
      <P>else:</P>
      <P>print "Invalid User ID!";</P>
      <P>endif;</P>
      <P>mysql_close();</P>
      <P>endif;</P>
      <P>?&gt;</P>
      <P>Листинг 13.3 показывает, как удобно использовать cookie для 
      идентификации пользователей. Этот прием может использоваться в 
      разнообразных ситуациях, от автоматической регистрации пользователя на 
      сайте до отслеживания пользовательских параметров настройки.</P>
      <P>В следующем разделе приведен сценарии полной регистрации пользователя и 
      последующего сохранения UIN в базе данных.</P>
      <P>Функции MySQL, встречающиеся в листинге 13.3, были описаны в главе 
      11.</P>
      <P><A name=e></A>Уникальные идентификаторы</P>
      <P>Вероятно, у вас уже возник вопрос: как сгенерировать UIN, который 
      действительно был бы уникальным? Отложите в сторону учебники — 
      замысловатые алгоритмы вам не понадобятся. В РНР предусмотрено простое 
      средство для создания уникальных UIN — встроенная функция uniqid( ).</P>
      <P>Функция uniqid( ) генерирует уникальный идентификатор.из 13 символов, 
      значение которого основано на текущем времени. Синтаксис функции uniqid( 
      ): int uniqid(string префикс [б boolean дополнение])</P>
      <P>В параметре префикс передается строка, с которой должен начинаться UIN. 
      Поскольку этот параметр является обязательным, при вызове необходимо 
      передать хотя бы пустую строку. Если необязательный параметр дополнение 
      равен TRUE, функция uniqid( ) генерирует UIN из 23 символов. Чтобы быстро 
      создать уникальный идентификатор, достаточно при вызове uniqid( ) передать 
      один параметр — пустую строку:</P>
      <P>$uniq_id = uniqid(" ");</P>
      <P>// Генерируется строка из 13 символов - например. '39b3209ce8ef2'</P>
      <P>В другом варианте сгенерированное значение присоединяется к строке, 
      определяемой параметром префикс:</P>
      <P>$uniq_id = uniqid("php", FALSE):</P>
      <P>// Генерируется строка из 16 символов - например. 
'php39b3209ce8ef2'</P>
      <P>Поскольку uniqid( ) генерирует UIN на основании текущего времени, 
      существует ничтожная вероятность того, что идентификатор удастся 
      подобрать. Чтобы значение идентификатора было действительно случайным, 
      можно предварительно сгенерировать префикс при помощи еще одной 
      стандартной функции РНР, rand( ). Эта возможность продемонстрирована в 
      следующем примере:</P>
      <P>srand((double) microtime( ) * 1000000);</P>
      <P>$uniq_id = uniqid(rand( ));</P>
      <P>Функция srand( ) инициализирует («раскручивает») генератор случайных 
      чисел. Если вы хотите, чтобы функция rand( ) генерировала действительно 
      случайные числа, необходимо предварительно вызвать srand( ). Передача 
      rand( ) в качестве параметра uniqid( ) приводит к тому, что функция 
      uniqid( ) вызывается с заранее сгенерированным случайным префиксом, что 
      усложняет подбор сгенерированного UIN.</P>
      <P>Владея методикой создания уникальных идентификаторов, мы теперь можем 
      реализовать вполне реальную схему регистрации пользователей. При первой 
      загрузке сценария в листинге 13.4 пользователю предлагается заполнить 
      короткую</P>
      <P>форму с именем и адресом электронной почты. Эта информация вместе со 
      сгенерированным уникальным идентификатором сохраняется в таблице 
      user_info, определение которой приведено перед листингом 13.3. Cookie с 
      этим идентификатором сохраняется на компьютере пользователя. При всех 
      последующих посещениях сценарий ищет в базе данных уникальный 
      идентификатор, взятый из cookie, и выводит в браузере найденную информацию 
      о пользователе.</P>
      <P>Листинг 13.4. Процесс регистрации пользователя</P>
      <P>&lt;?</P>
      <P>// Построить форму</P>
      <P>$form = "</P>
      <P>&lt;form action=\"Listingl3-4.php\" method=\"post\"&gt;</P>
      <P>&lt;input type=\"hidden\" name=\"seenform\" value=\"y\"&gt; \</P>
      <P>Your first name?:&lt;br&gt;</P>
      <P>&lt;input type=\"text\" name=\"fname\" size=\"20\" maxlength=\"20\" 
      value=\"\"&gt;&lt;br&gt;</P>
      <P>Your email?:&lt;br&gt;</P>
      <P>&lt;input type=\"text\" name=\"email\" size=\"20\" maxlength=\"35\" 
      value=\"\"&gt;&lt;br&gt;</P>
      <P>&lt;input type=\"submit\" value=\"Register!\"&gt;</P>
      <P>&lt;/form&gt;</P>
      <P>// Если форма еще не отображалась</P>
      <P>// и для данного пользователя еще не существует cookie...</P>
      <P>1f ((! isset (Sseenform)) &amp;&amp; (! isset ($userid))) :</P>
      <P>print $form;</P>
      <P>// Если форма отображалась.</P>
      <P>// но данные пользователя еще не были обработаны...</P>
      <P>elself (isset ($seenform) &amp;&amp; (! isset ($sserid))) :</P>
      <P>srand ((double) microtime( ) * 1000000);</P>
      <P>$uniq_id = uniqid(rand( ));</P>
      <P>// Подключиться к серверу MySQL и выбрать базу данных users</P>
      <P>@mysql_pconnect("localhost", "root", "") or die("Could not connect to 
      MySQL server!");</P>
      <P>@mysql_select_db("book") or die("Could not select user database!");</P>
      <P>// Объявить и выполнить запрос</P>
      <P>$query = "INSERT INTO users13 VALUES('$uniq_id', '$fname', 
      '$email')";</P>
      <P>$result = mysql_query($query) or die("Could not insert user 
      information!");</P>
      <P>// Создать cookie "userid" со сроком действия один месяц, setcookie 
      ("userid", $uniq_id, tirne( )+2592000);</P>
      <P>print "Congratulations $fname! You are now registered! Your user 
      information will be displayed uponon each subsequent visit to this 
      page.";</P>
      <P>// ... иначе, если cookie существует - использовать идентификатор</P>
      <P>// пользователя для выборки данных из базы данных users elseif 
      (isset($userid)) :</P>
      <P>// Подключиться к серверу MySQL и выбрать базу данных users</P>
      <P>@mysql_pconnect("localhost", "root", "") or die("Could not connect to 
      MySQL server!");</P>
      <P>@mysql_select_db("book") or die("Could not select user database!");</P>
      <P>// Объявить и выполнить запрос</P>
      <P>$query = "SELECT * FROM users,13 WHERE user_id = '$userid' ";</P>
      <P>$result = mysql_query($query) or die("Could not extract user 
      information!"</P>
      <P>$row = mysql_fetch_array($result); print "Hi 
      ".$row["fname"].",&lt;br&gt;";</P>
      <P>print "Your email address is ".$row["email"];</P>
      <P>endif;</P>
      <P>?&gt;</P>
      <P>Обилие команд i f позволяет организовать весь процесс регистрации и 
      последующую идентификацию пользователя в одном сценарии. Принципиально 
      возможны три ситуации:</P>
      <UL>
        <LI>Пользователь не заполнял форму и не имеет cookie. В этом случае он 
        должен заполнить форму. 
        <LI>Пользователь заполнил форму, но cookie еще не создано. В этом случае 
        информация пользователя сохраняется в базе данных и создается cookie со 
        сроком действия один месяц. 
        <LI>Пользователь возвращается после предыдущих посещений. Если срок 
        действия cookie еще не истек, сценарий читает идентификатор пользователя 
        и загружает соответствующую информацию из базы данных. </LI></UL>
      <P>Конечно, общий процесс, продемонстрированный в листинге 13.4, может 
      применяться при работе с любыми базами данных. Листинг всего лишь на очень 
      простом уровне показывает, как на крупных сайтах организуется сохранение 
      пользовательских данных, благодаря которому сайт «подстраивается» под 
      каждого посетителя.</P>
      <P>На этом завершается наше знакомство с применением cookie в РНР. Если вы 
      захотите побольше узнать о механизме cookie, обратитесь к ресурсам 
      Интернета, перечисленным в следующем разделе.</P>
      <P>Ссылки по теме</P>
      <P>Дополнительную информацию о cookie и их использовании можно найти в 
      специализированных web-pecypcax:</P>
      <UL>
        <LI><A 
        href="http.html://www.cookiecentral.com/">http://www.cookiecentral.com/</A>; 
        <LI><A 
        href="http.html://home.netscape.com/newsref/std/cookie_spec.html">http://home.netscape.com/newsref/std/cookie_spec.html</A>; 

        <LI><A 
        href="http.html://builder.com/Programming/Cookies/ss01.html">http://builder.com/Programming/Cookies/ss01.html</A>; 

        <LI><A 
        href="http.html://www.w3.org/Protocols/rfc2109/rfc2100">http://www.w3.org/Protocols/rfc2109/rfc2100</A>. 
        </LI></UL>
      <P>Как говорилось выше, в cookie очень удобно хранить параметры, 
      специфические для данного пользователя, автоматически загружаемые при 
      последующих посещениях сайта. Впрочем, на cookie нельзя полностью 
      положиться, потому что пользователи могут запретить их использование на 
      своем компьютере в настройках браузера. К счастью, в РНР для сохранения 
      подобной информации существует и другой способ. Эта методика называется 
      отслеживанием сеанса (session tracking) и рассматривается в следующем 
      разделе.</P>
      <P><A name=f></A>Отслеживание сеанса</P>
      <P>Сеансом (session) называется период времени, который начинается с 
      момента прихода пользователя на сайт и завершается, когда пользователь 
      покидает сайт. В течение сеанса часто возникает необходимость в сохранении 
      различных переменных, которые бы «сопровождали» пользователя при 
      перемещениях на сайте, чтобы вам не приходилось вручную кодировать 
      многочисленные скрытые поля или переменные, присоединяемые к URL.</P>
      <P>Рассмотрим следующую ситуацию. При входе на сайт пользователю 
      присваивается уникальный идентификатор сеанса (SID), который сохраняется 
      на компьютере пользователя в cookie с именем PHPSESSJD. Если использование 
      cookie запрещено или cookie вообще не поддерживаются, SID автоматически 
      присоединяется ко всем локальным URL на протяжении сеанса. В то же время 
      на сервере сохраняется файл, имя которого совпадает с SID. По мере того 
      как пользователь перемещается по сайту, значения некоторых параметров 
      должны сохраняться в виде сеансовых переменных. Эти переменные сохраняются 
      в файле пользователя. При последующем обращении к сеансовой переменной 
      сервер открывает сеансовый файл пользователя и ищет в нем нужную 
      переменную. В сущности, в этом и заключается суть отслеживания сеанса. 
      Конечно, информация с таким же успехом может храниться в базе данных или в 
      другом файле.</P>
      <P>Интересно? Еще бы. После всего сказанного вы, несомненно, лучше поймете 
      различные проблемы конфигурации, рассматриваемые ниже. Особенно важную 
      роль играют три флага. Первый флаг, --enable-trans-id, включается в 
      процесс конфигурации в том случае, если вы собираетесь использовать SID 
      (см. ниже). Два других флага, track_vars и register_globals, включаются и 
      отключаются по мере необходимости в файле php.ini. Последствия активизации 
      этих флагов рассматриваются ниже.</P>
      <P>--enable-trans-id</P>
      <P>Если РНР компилируется с этим флагом, ко всем относительным URL 
      автоматически присоединяется идентификатор сеанса (SID). Дополнение 
      записывается в формате имя_сеанса=идентификатор_сеанса, где имя_сеанса 
      определяется в файле php.ini (см. ниже). Если вы не захотите включать этот 
      флаг, в качестве SID можно использовать константу.</P>
      <P>track_vars</P>
      <P>Установка флага track_vars позволяет использовать массивы 
      $HTTP_*_VARS[], где * заменяется одним из значений EGPCS (Environment, 
      Get, Post, Cookie, Server). Данный флаг необходим для того, чтобы значения 
      SID передавались с одной страницы на другую. В РНР 4.03 этот флаг всегда 
      находится в установленном состоянии.</P>
      <P>register_globals</P>
      <P>В результате установки этого флага все переменные EGPCS становятся 
      доступными глобально. Если вы не хотите, чтобы массив глобальных 
      переменных заполнялся данными, которые вам, возможно, и не понадобятся, 
      флаг следует сбросить.</P>
      <P>Если флаг register_globals сброшен, а флаг track_vars установлен, ко 
      всем переменным GPC можно обращаться через массив $HTTP_*_VARS[]. 
      Например, если сбросить флаг register_globals, к стандартной переменной 
      $PHP_SELF придется обращаться в виде $HTTP_SERVER_VARS["PHP_SELF"].</P>
      <P>Существует целый ряд других аспектов конфигурации, о которых следует 
      позаботиться. Эти директивы перечислены в табл. 13.1 с указанием 
      стандартных значений, задаваемых по умолчанию в файле php.ini. 
      Перечисление производится в порядке появления директив в файле.</P>
      <P>Таблица 13.1. Сеансовые директивы в файле php.ini </P>
      <P>
      <TABLE height=323 cellSpacing=0 cellPadding=0 width="100%" border=1>
        <TBODY>
        <TR>
          <TD align=middle width=191 height=19>Директива </TD>
          <TD align=middle width=303 height=19>&nbsp;Описание </TD></TR>
        <TR>
          <TD width=224 height=48>session.save_handler = files</TD>
          <TD width=303 height=48>
            <P>Определяет способ хранения сеансовых данных на сервере. Возможны 
            три варианта: в файле (files), в общей памяти (mm) или с 
            использованием функций, определяемых пользователем (User). Последний 
            вариант позволяет легко сохранить информацию в любом формате — 
            например, в базе данных</P></TD></TR>
        <TR>
          <TD width=191 height=19>session.save_path =/tmp</TD>
          <TD width=303 height=19>
            <P>Определяет каталог для сеансовых файлов РНР. На платформе Linux 
            обычно используется значение по умолчанию ('/tmp'). На платформе 
            Windows следует указать путь к какому-нибудь каталогу, в противном 
            случае произойдет ошибка</P></TD></TR>
        <TR>
          <TD width=191 height=19>session_use_cookies =1</TD>
          <TD width=303 height=19>
            <P>При установке этого флага для сохранения идентификатора сеанса на 
            компьютере пользователя используются cookie</P></TD></TR>
        <TR>
          <TD width=195 height=19>session.name =PHPRESSID.</TD>
          <TD width=303 height=19>
            <P>Если флаг session.use_cookies установлен, то значение 
            session.name используется в качестве имени cookie. Имя может 
            состоять только из алфавитно-цифровых символов</P></TD></TR>
        <TR>
          <TD width=191 height=19>session.auto_start = 0</TD>
          <TD width=303 height=19>
            <P>При установке флага session.auto_start сеанс автоматически 
            инициируется при первоначальном запросе со стороны клиента</P></TD></TR>
        <TR>
          <TD width=191 height=19>&nbsp;session.cookie_lifetime = 0</TD>
          <TD width=303 height=19>
            <P>Если флаг session.use_cookies установлен, то значение 
            session.cookie_lifetime определяет срок действия отправляемых 
            cookie. Если параметр равен 0, то все cookie становятся 
            недействительными при завершении сеанса</P></TD></TR>
        <TR>
          <TD width=191 height=19>session.cookie_path = /</TD>
          <TD width=303 height=19>
            <P>Если флаг session.use_cookies установлен, то значение 
            session.cookie_path определяет каталог, для которого отправляемые 
            cookie считаются действительными</P></TD></TR>
        <TR>
          <TD width=191 height=19>&nbsp;session.cookie_domain =</TD>
          <TD width=303 height=19>
            <P>Если флаг session.use_cookies установлен, то значение 
            session.cookie_domain определяет домен, для которого отправляемые 
            cookie считаются действительными</P></TD></TR>
        <TR>
          <TD width=191 height=19>session.serialize_handler = php</TD>
          <TD width=303 height=19>
            <P>Имя обработчика, используемого в процессе сериализации данных. В 
            настоящее время определены два возможных значения: php и 
        WDDX</P></TD></TR>
        <TR>
          <TD width=191 height=19>session.gc_probability =1</TD>
          <TD width=303 height=19>Вероятность активизации сборщика мусора РНР 
            (в процентах)</TD></TR>
        <TR>
          <TD width=191 height=19>session.gc_maxlifetime=1440</TD>
          <TD width=303 height=19>
            <P>Промежуток времени (в секундах), по истечении которого данные 
            сеанса считаются недействительными и уничтожаются. Отсчет начинается 
            с момента последнего обращения пользователя в текущем 
        сеансе</P></TD></TR>
        <TR>
          <TD width=191 height=19>session.referer_check =&nbsp;</TD>
          <TD width=303 height=19>
            <P>Если этому параметру присвоено строковое значение, каждый запрос 
            к странице при включенном отслеживании сеанса начинается с проверки 
            того, что заданная строка присутствует в глобальной переменной 
            $HTTP_REFERER. Если строка не найдена, идентификаторы сеансов 
            игнорируются</P></TD></TR>
        <TR>
          <TD width=191 height=19>session.enthropy_fiie =</TD>
          <TD width=303 height=19>
            <P>Ссылка на внешний файл с дополнительной случайной информацией, 
            используемой при генерации идентификаторов сеансов. В системах UNIX 
            для этой цели обычно используются два устройства, /dev/random и 
            /dev/urandom. Устройство /dev/random получает случайные данные от 
            ядра, а устройство /dev/urandom генерирует случайную строку при 
            помощи хэш-алгоритма М05. Короче говоря, /dev/random работает 
            быстрее, a /dev/urandom генерирует «более случайные» 
строки</P></TD></TR>
        <TR>
          <TD width=190 height=19>session.enthropy_length = 0</TD>
          <TD width=303 height=19>Если флаг session.enthropy_file установлен, 
            то session.enthropyjength определяет количество байт, читаемых из 
            файла session.enthropy_file</TD></TR>
        <TR>
          <TD width=191 height=19>session.cache limiter = nocache</TD>
          <TD width=303 height=19>Способ управления кэшем для страниц сеанса. 
            В настоящее время определены три возможных значения: nocache, public 
            и private</TD></TR>
        <TR>
          <TD width=191 height=19>session.cache_expire =180</TD>
          <TD width=303 height=19>Продолжительность жизни кэшированных страниц 
            сеанса (в минутах)</TD></TR></TBODY></TABLE></P>
      <P>После внесения всех необходимых изменений в настройку сервера мы 
      переходим к непосредственной реализации отслеживания сеанса на вашем 
      сайте. Благодаря нескольким стандартным функциям РНР этот процесс не так 
      уж сложен. Первое, что необходимо знать, — сеанс инициируется функцией 
      session_start( ). Конечно, при включении директивы session.auto_start в 
      файл php.ini (см. выше) необходимость в вызове этой функции отпадает. Тем 
      не менее, в оставшейся части этого раздела я буду использовать эту 
      функцию, чтобы примеры выглядели более последовательно. Функция 
      session_start( ) имеет простой синтаксис, поскольку она не получает 
      параметров и возвращает логическую величину.</P>
      <P>Директива session.save_handler настолько важна, что я счел необходимым 
      посвятить ей отдельный раздел. Он находится в конце главы под заголовком 
      «Назначение пользовательских функций для хранения сеансовых данных».</P>
      <P>session_start( )</P>
      <P>Функция session_start( ) имеет двойное назначение. Сначала она 
      проверяет, начал ли пользователь новый сеанс, и если нет — начинает его. 
      Синтаксис функции</P>
      <P>session_start( ): boolean session_start()</P>
      <P>Если функция начинает новый сеанс, она выполняет три операции: 
      назначение пользователю SID, отправку cookie (если в файле php.ini 
      установлен флаг session_cookies) и создание файла сеанса на сервере. 
      Второе назначение функции заключается в том, что она информирует ядро РНР 
      о возможности использования в сценарии, в котором она была вызвана, 
      сеансовых переменных.</P>
      <P>Сеанс начинается простым вызовом session_start( ) следующего вида:</P>
      <P>session_start( ):</P>
      <P>Если сеанс можно создать, значит, его можно и уничтожить. Это делается 
      функцией session_destroy( ).</P>
      <P>Функция session_start( ) возвращает TRUE независимо от результата. 
      Следовательно, проверять ее в условиях if или в команде die( ) 
      бессмысленно.</P>
      <P>session_destroy()</P>
      <P>Функция session_destroy( ) уничтожает все хранимые данные, относящиеся 
      к сеансу текущего пользователя. Синтаксис функции session_destroy( ):</P>
      <P>boolean session_destroy( )</P>
      <P>Следует помнить, что эта функция не уничтожает cookie на браузере 
      пользователя. Впрочем, если вы не собираетесь использовать cookie после 
      конца сеанса, просто присвойте параметру session.cookie_lifetime в файле 
      php.ini значение ( ) (используемое по умолчанию). Пример использования 
      функции:</P>
      <P>&lt;?</P>
      <P>session_start( );</P>
      <P>// Выполнить некоторые действия для текущего сеанса</P>
      <P>session_destroy( ):</P>
      <P>?&gt;</P>
      <P>Теперь вы умеете уничтожать сеансы, и мы можем перейти к работе с 
      сеансовыми переменными. Возможно, самой важной сеансовой переменной 
      является SID (идентификатор сеанса). Его легко можно получить при помощи 
      функции session_id( ).</P>
      <P>session_id( )</P>
      <P>Функция session_id( ) возвращает SID для сеанса, созданного функцией 
      session_start( ). Синтаксис функции session_id( ):</P>
      <P>string session_id ([string sfd])</P>
      <P>Если в необязательном параметре передается идентификатор, то значение 
      SID текущего сеанса изменяется. Однако следует учитывать, что cookie при 
      этом заново не пересылаются. Пример:</P>
      <P>&lt;?</P>
      <P>session_start()</P>
      <P>print "Your session identification number is ".sessionjd( ):</P>
      <P>session_destroy( ):</P>
      <P>?&gt;</P>
      <P>Результат, выводимый в браузере, выглядит примерно так:</P>
      <P>Your session identification number is 
      067d992a949114ee9832flcllcafc640</P>
      <P>Как же создать свою сеансовую переменную? С помощью функции 
      session_register( ).</P>
      <P>session_register( )</P>
      <P>Функция session_register( ) регистрирует имена одной или нескольких 
      переменных для текущего сеанса. Синтаксис функции session_register( ):</P>
      <P>boolean session_register (mixed имя_переменной1 [, mixed 
      имя_переменной2... ])</P>
      <P>Следует помнить, что вы регистрируете не сами переменные, а их имена. 
      Если сеанс не существует, функция session_register( ) также неявно 
      вызывает session_start( ) для создания нового сеанса.</P>
      <P>Прежде чем приводить примеры использования session_register( ), я хочу 
      представить еще одну функцию, связанную с отслеживанием сеанса, — 
      session_is_registered( ). Эта функция проверяет, была ли зарегистрирована 
      переменная с заданным именем.</P>
      <P>session_is_registered( )</P>
      <P>Часто требуется определить, была ли ранее зарегистрирована переменная с 
      заданным именем. Задача решается при помощи функции session_is_registered( 
      ), имеющей следующий синтаксис:</P>
      <P>boolean session_is_registered (string имя_переменной)</P>
      <P>Применение функций session_register( ) и session_is_registered( ) будет 
      продемонстрировано на классическом примере использования сеансовых 
      переменных — счетчике посещений (листинг 13.5).</P>
      <P>Листинг 13.5. Счетчик посещений сайта пользователем</P>
      <P>&lt;?</P>
      <P>session_start( ):</P>
      <P>if (! sessionjs_registered('hits')) :</P>
      <P>session_register( 'hits' ) ;</P>
      <P>endif ;</P>
      <P>$hits++:</P>
      <P>print "You've seen this page $hits times.</P>
      <P>?&gt;</P>
      <P>Сеансовые переменные можно не только создавать, но и уничтожать. Для 
      этой цели применяется функция session_unregister( ).</P>
      <P>session_unregister( )</P>
      <P>Сеансовые переменные уничтожаются функцией session_unregister( ). 
      Синтаксис:</P>
      <P>boolean session_unregister (string имя_переменной')</P>
      <P>При вызове функции передается имя сеансовой переменной, которую вы 
      хотите уничтожить.</P>
      <P>&lt;?</P>
      <P>session_start()</P>
      <P>session_register('username');</P>
      <P>// Использовать переменную $username.</P>
      <P>// Когда переменная становится ненужной - уничтожить ее.</P>
      <P>session_unregister('username');</P>
      <P>session_destroy();</P>
      <P>?&gt;</P>
      <P>Как и в случае с функцией session_register, помните, что в параметре 
      указывается не сама переменная (то есть имя с префиксом $). Вместо этого 
      указывается имя переменной.</P>
      <P>session_encode( )</P>
      <P>Функция session_encode( ) обеспечивает чрезвычайно удобную возможность 
      форматирования сеансовых переменных для хранения (например, в базе 
      данных). Синтаксис функции session_encode( ):</P>
      <P>boolean session_encode( )</P>
      <P>В результате выполнения этой функции все сеансовые данные форматируются 
      в одну длинную строку, которую можно сохранить в базе данных.</P>
      <P>Пример использования session_encode( ) приведен в листинге 13.6. 
      Предположим, что на компьютере «зарегистрированного» пользователя имеется 
      cookie, в котором хранится уникальный идентификатор этого пользователя. 
      Когда пользователь запрашивает страницу, содержащую листинг 13.6, UID 
      читается из cookie и присваивается идентификатору сеанса. Мы создаем 
      несколько сеансовых переменных и присваиваем им значения, после чего 
      форматируем всю информацию функцией session_encode( ) и заносим в базу 
      данных MySQL.</P>
      <P>Листинг 13.6. Использование функции session_encode( ) для сохранения 
      данных в базе данных MySQL</P>
      <P>&lt;?</P>
      <P>// Инициировать сеанс и создать сеансовые переменные</P>
      <P>session_register('bgcolor');</P>
      <P>session_register('fontcolor');</P>
      <P>// Предполагается, что переменная $usr_id (с уникальным</P>
      <P>// идентификатором пользователя) хранится в cookie</P>
      <P>// на компьютере пользователя.</P>
      <P>// При помощи функции session_id( ) присвоить идентификатору</P>
      <P>// сеанса уникальный идентификатор пользователя (UID),</P>
      <P>// хранящийся в cookie. $id = session_id($usr_id);</P>
      <P>// Значения следующих переменных могут задаваться пользователем</P>
      <P>// на форме HTML $bgcolor = "white"; $fontcolor = "blue";</P>
      <P>// Преобразовать все сеансовые данные в одну строку</P>
      <P>$usr_data = session_encode( );</P>
      <P>// Подключиться к серверу MySQL и выбрать базу данных users</P>
      <P>@mysql_pconnect("localhost", "web", "4tf9zzzf")</P>
      <P>or die("Could not connect to MySQL server!");</P>
      <P>@mysql_select_db("users")</P>
      <P>or die("Could not select user database!");</P>
      <P>// Обновить пользовательские параметры страницы</P>
      <P>$query = "UPDATE user_info set page_data='$usr_data' WHERE user_id= 
      '$id'";</P>
      <P>$result - mysql_query($query) or die("Could not update user 
      information!");</P>
      <P>?&gt;</P>
      <P>Как видите, быстрое преобразование всех сеансовых переменных в одну 
      строку избавляет нас от необходимости создавать несколько полей для 
      хранения/загрузки данных, а также несколько уменьшает объем программы.</P>
      <P>session_decode( )</P>
      <P>Все сеансовые данные, ранее преобразованные в строку функцией sessi 
      on_encode( ), восстанавливаются функцией session_decode( ). Синтаксис:</P>
      <P>string session_decode (string сеансовые_данные)</P>
      <P>В параметре сеансовые_данные передается преобразованная строка 
      сеансовых переменных, возможно — прочитанная из файла или загруженная из 
      базы данных. Строка восстанавливается, и все сеансовые переменные в строке 
      преобразуются к исходному формату.</P>
      <P>В листинге 13.7 продемонстрировано восстановление закодированных 
      сеансовых переменных функцией session_decode( ). Предположим, таблица 
      MySQL с именем user_info состоит из двух полей: user_id и page_data. 
      Пользовательский UID, хранящийся в cookie на компьютере пользователя, 
      применяется для загрузки сеансовых данных, хранящихся в поле page_data. В 
      этом поле хранится закодированная строка переменных, одна из которых 
      ($bgcolor) содержит цвет фона, выбранный пользователем.</P>
      <P>Листинг 13.7. Восстановление сеансовых данных, хранящихся в базе данных 
      MySQL</P>
      <P>&lt;?</P>
      <P>// Предполагается, что переменная $usr_id (с уникальным</P>
      <P>// идентификатором пользователя) хранится в cookie</P>
      <P>// на компьютере пользователя.</P>
      <P>$id = session_id($usr_id);</P>
      <P>// Подключиться к серверу MySQL и выбрать базу данных users</P>
      <P>@mysq]_pconnect("localhost", "web", "4tf9zzzf")</P>
      <P>or die("Could not connect to MySQL server!");</P>
      <P>@mysql_select_db("users")</P>
      <P>or die("Could not select company database!");</P>
      <P>// Выбрать данные из таблицы MySQL</P>
      <P>$query = "SELECT page_data FROM user_info WHERE user_id= '$id'",</P>
      <P>Sresult = mysql_query($query);</P>
      <P>$user_data = mysql_result($result, 0. "page_data");</P>
      <P>// Восстановить данные session_decode($user_data):</P>
      <P>// Вывести одну из восстановленных сеансовых переменных</P>
      <P>print "BGCOLOR: $bgcolor";</P>
      <P>?&gt;</P>
      <P>Как видно из двух приведенных листингов, функции session_ encode( ) и 
      ses-sion_decode( ) обеспечивают очень удобные и эффективные сохранение и 
      загрузку сеансовых данных.</P>
      <P><A name=g></A>Назначение пользовательских функций для хранения 
      сеансовых данных</P>
      <P>Хранить сеансовые данные в файлах удобно, но вполне возможно, вы 
      захотите воспользоваться другими средствами — например, базами данных. А 
      может быть, вы хотите применить один и тот же сценарий на разных сайтах 
      для разных баз данных. Существует и другая распространенная проблема — 
      стандартная для РНР процедура хранения сеансовых данных в файлах 
      затрудняет совместное использование данных на разных серверах. К счастью, 
      все эти проблемы отслеживания сеансов в РНР решаются очень просто, 
      поскольку РНР дает пользователю возможность установить собственную 
      процедуру сохранения при помощи стандартной функции 
      session_set_save_handler( ).</P>
      <P>Функция session_set_save_handler( ) определяет процедуры сохранения и 
      загрузки сеансовых данных пользовательского уровня.</P>
      <P>Синтаксис функции session_set_save_handler():</P>
      <P>void session_set_save_handler (string open, string close, string read, 
      string write, string destroy, string go) </P>
      <P>Шесть параметров session_set_save_handler( ) соответствуют шести 
      функциям, вызываемым сеансовыми функциями РНР. Хотя имена этих функций 
      могут быть произвольными, каждая функция должна получать жестко заданный 
      набор параметров. Перед тем как переходить к рассмотрению примера, 
      просмотрите таблицу 13.2 — в ней описаны назначение всех шести функций и 
      их параметры.</P>
      <P>Чтобы использовать функцию session_set_save_handler( ), необходимо 
      присвоить па-раметру session.save_handler в файле php.ini значение 
      user.</P>
      <P>Таблица 13.2. Шесть параметров функции session_set_save_handler( )</P>
      <P>
      <TABLE cellSpacing=0 cellPadding=0 width="100%" border=1>
        <TBODY>
        <TR>
          <TD align=middle width=213>Параметр </TD>
          <TD align=middle width=333>Описание </TD></TR>
        <TR>
          <TD width=213>sess_close( )</TD>
          <TD width=350>Вызывается при завершении сценария, в котором 
            реализуются сеансовые функции. Не путайте эту функцию с функцией 
            sess_destroy( ), предназначенной для уничтожения сеансовых 
            переменных. Функция sess_close( ) вызывается без параметров</TD></TR>
        <TR>
          <TD width=213>sess_destroy($идент_ceaнca)</TD>
          <TD width=333>Удаляет все сеансовые данные. Параметр определяет 
            удаляемый сеанс</TD></TR>
        <TR>
          <TD width=213>sess_gc($срок_действия)</TD>
          <TD width=333>Удаляет все сеансы с завершенным сроком действия. Срок 
            определяется параметром $срок_действия, значение которого задается в 
            секундах. Параметр читается из файла php.ini и соответствует 
            значению session.gcjifetime</TD></TR>
        <TR>
          <TD width=213>sess_open($путь, $имя)</TD>
          <TD width=333>&nbsp; Вызывается при инициализации нового сеанса 
            функцией session_start( ) или session_register( ). Два параметра 
            читаются из файла php.ini и соответствуют значениям 
            session.save_path и session.name</TD></TR>
        <TR>
          <TD width=213>sess_read($ключ)</TD>
          <TD width=333>Используется для выборки значения сеансовой 
            переменной, определяемой заданным ключом</TD></TR>
        <TR>
          <TD width=213>sess_write($ключ, $значение)</TD>
          <TD width=333>Используется для сохранения сеансовых данных. Любые 
            данные, сохраненные функцией sess_write( ), позднее могут быть 
            прочитаны функцией sess_read( ). Параметр $ключ соответствует имени 
            сеансовой переменной, а параметр $значение — значению, связываемому 
            с заданным ключом</TD></TR></TBODY></TABLE></P>
      <P>Теперь, когда вы знаете все, что необходимо знать о параметрах 
      session_set_save_handler( ), мы рассмотрим пример реализации сеансовых 
      функций на базе MySQL (листинг 13.8).</P>
      <P>Листинг 13.8. Реализация сеансовых функций на базе MySQL</P>
      <P>&lt;?</P>
      <P>// Реализация сеансовых функций на базе MySQL</P>
      <P>// Хост, имя пользвателя и пароль</P>
      <P>$host = "localhost"; $user = "web"; $pswd = "4tf9zzzf";</P>
      <P>// Имена таблицы и базы данных</P>
      <P>$db = "users";</P>
      <P>$session table = "user session data";</P>
      <P>// Прочитать значение sess.gc_lifetime из файла php.ini</P>
      <P>$sess_life = get_cfg_var("sess.gc_lifetime");</P>
      <P>// Функция : mysql_sess_open()</P>
      <P>// Назначение: подключение к серверу MySQL</P>
      <P>// и выбор базы данных.</P>
      <P>function mysql_sess_open($save_path. $session_name) {</P>
      <P>GLOBAL $host. $user, $pswd, $db;</P>
      <P>@mysql_connect($host, $user, $pswd)</P>
      <P>or die("Can't connect to MySQL server!");</P>
      <P>@mysql_select_db($db)</P>
      <P>or die("Can't select session database!");</P>
      <P>}</P>
      <P>// Функция: mysql_sess_close()</P>
      <P>// Назначение: в реализации на базе MySQL эта функция не 
      используется.</P>
      <P>// Тем не менее, она Обязательно* должна быть определена.</P>
      <P>function diysql_sess_close() {</P>
      <P>return true:</P>
      <P>}</P>
      <P>// Функция: mysql_sess_read()</P>
      <P>// Назначение: загрузка информации из базы данных MySQL.</P>
      <P>function mysql_sess_read($key) {</P>
      <P>GLOBAL $session_table:</P>
      <P>$query = "SELECT value FROM $session_table WHERE sess_key = 
'$key'";</P>
      <P>$result = mysql_query( $query);</P>
      <P>if (list($value) = mysql_fetch_row($result)) :</P>
      <P>return $value;</P>
      <P>endlf;</P>
      <P>return false;</P>
      <P>}</P>
      <P>// Функция: mysql_sess_write( )</P>
      <P>// Назначение: запись информации в базу данных MySQL.</P>
      <P>function mysql_sess_write($key, $val) {</P>
      <P>GLOBAL $sess_life, $session_table;</P>
      <P>$expiratlon = time() + $sess_life;</P>
      <P>$query = "INSERT INTO Ssession_table VALUES('$key', '$expiration', 
      '$value')";</P>
      <P>$result = mysql_query($query);</P>
      <P>// Если запрос на вставку данных завершился неудачей // из-за 
      присутствия первичного ключа в поле sess_key, // выполнить обновление.</P>
      <P>if (! $result) :</P>
      <P>$query = "UPDATE $session_table</P>
      <P>SET sess_expiration = '$expiration', sess_value='Svalue'</P>
      <P>WHERE sess_key = '$key'"; $result = mysql_query($result);</P>
      <P>endif;</P>
      <P>}</P>
      <P>// Функция: mysql_sess_destroy()</P>
      <P>// Назначение: удаление из таблицы всех записей с ключом, равным 
      $sess_id</P>
      <P>function mysql_sess_destroy(Ssess_id) {</P>
      <P>GLOBAL $session_table:</P>
      <P>$query = "DELETE FROM $session_table WHERE sess_key = '$sess_id'";</P>
      <P>$result = mysql_result($query);</P>
      <P>return $result;</P>
      <P>}</P>
      <P>// Функция: mysql_sess_gc()</P>
      <P>// Назначение: удаление всех записей, у которых</P>
      <P>// срок жизни &lt; текущее время - session.gc_lifetime</P>
      <P>function mysql_sess_gc($max_lifetime) {</P>
      <P>GLOBAL $session_table:</P>
      <P>$query = "DELETE FROM $session_table WHERE sess_expiration &lt; 
      ".time();</P>
      <P>$result = mysql_query($query);</P>
      <P>return mysql_affected_rows();</P>
      <P>session_set_save_handler("mysql_sess_open", 
      "mysql_sess_close","mysql_sess_read", "mysql_sess_write", 
      "mysql_sess_destroy", "mysql_sess_gc");</P>
      <P>?&gt;</P>
      <P>После того как эти шесть функций будут зарегистрированы в программе, их 
      можно вызывать по абстрактным именам (sess_close( ), sess_destroy( ), 
      sess_gc( ), sess_open( ), sess_read( ) или sess_write( )). Такой подход 
      удобен тем, что вы можете создать сколько угодно реализаций и 
      переключаться между ними, вызывая ses-sion_set_save_handler( ) по мере 
      необходимости.</P>
      <P><A href="http.html://doks.gorodok.net/996" name=h></A>Проект: журнал 
      посещений сайта</P>
      <P>Статистические сведения о посетителях сайта приносят немалую пользу. 
      Как вы уже знаете, сохранение информации о посетителях широко практикуется 
      на сайтах рекламных web-агентств и порталов, а также на многих других 
      сайтах, желающих получить дополнительные сведения о своих посетителях. 
      Хотя системы учета бывают невероятно сложными, даже относительно простая 
      система ведения учета открывает немало интересных возможностей. Я покажу, 
      как реализовать простейший журнал посещений на базе РНР, MySQL и 
      cookie.</P>
      <P>В проекте использована методика идентификации браузера, описанная в 
      главе 8. Если вы пропустили главу 8 или описание проекта, я настоятельно 
      рекомендую вернуться и просмотреть код проекта.</P>
      <P>Как было сказано ранее, наша система будет относительно простой — 
      посещения будут отслеживаться только для индексной страницы сайта. При 
      появлении нового посетителя сценарий РНР проверяет, существует ли на 
      компьютере посетителя cookie. Если cookie находится, значит, пользователь 
      посещал сайт в течение определенного интервала времени (который задается 
      администратором сайта в инициализационном файле), и сценарий не учитывает 
      новое посещение. Если cookie отсутствует или интервал между посещениями 
      превысил заданную величину, информация сохраняется в таблице MySQL, а на 
      компьютер посетителя создается cookie.</P>
      <P>Как реализовать подобный сценарий на РНР? Прежде всего необходимо 
      создать таблицу MySQL для хранения информации:</P>
      <P>mysql&gt;create table visitors (</P>
      <P>-&gt;browser char(85) NOT NULL. -&gt;ip char(30) NOT NULL.</P>
      <P>-&gt;host char(85) NOT NULL.</P>
      <P>-&gt;timeOfVisit datetime NOT NULL</P>
      <P>-&gt;);</P>
      <P>В поле browser хранится информация, непосредственно относящаяся к 
      браузеру посетителя. Она берется из переменной РНР с именем 
      $HTTP_USER_AGENT. В поле ip хранится IP-адрес посетителя. В поле host 
      хранится информация о провайдере, от которого поступил IP-адрес. Наконец, 
      поле timeOfVisit содержит дату и время посещения сайта.</P>
      <P>Полноценное приложение для ведения журнала посещений имеется на сайте 
      ресурсов РНР phpinfo.net (http://www.phpinfo.net). Более того, вы сможете 
      непосредственно</P>
      <P>на сайте увидеть, как оно работает. К сожалению, перед посещением этого 
      сайта вам</P>
      <P>придется вспомнить школьный курс французского языка.</P>
      <P>Затем мы создаем инициализационный файл приложения init.inc (листинг 
      13.9), содержащий определения глобальных переменных и основных функций. 
      Обратите внимание: в функции viewStats( ) используется сценарий 
      sniffer.php из главы 8. Этот сценарий включается в файл init.inc по мере 
      необходимости. Рекомендую потратить немного времени на просмотр этого 
      сценария и комментариев к нему.</P>
      <P>Листинг 13.9. Инициализационный файл приложения (init.inc) &lt;?</P>
      <P>// Файл: init.inc</P>
      <P>// Назначение: инициализационный файл журнала посещений сайта</P>
      <P>// Параметры соединения с сервером MySQL $host = "localhost";</P>
      <P>$user = "root"; $pswd = "";</P>
      <P>// Имя базы данных Sdatabase = "myTracker";</P>
      <P>// Имя таблицы $visitors_table = "visitors":</P>
      <P>@mysql_pconnect($host, $user, $pswd) or die("Couldn't connect to MySQL 
      server!");</P>
      <P>// Выбрать базу данных</P>
      <P>@mysql_select_db($database) or die("Couldn't select $database 
      database!");</P>
      <P>// Максимальное количество посещений, отображаемое в таблице 
      $maxNumVisitors = "5";</P>
      <P>// Имя cookie</P>
      <P>$cookieName = "visitorlog";</P>
      <P>// Значение cookie $cookieValue="1";</P>
      <P>// Срок, который должен пройти с момента последнего посещения 
сайта,</P>
      <P>// чтобы информация о текущем посещении была сохранена в базе 
      данных.</P>
      <P>// Если переменная $timeLimit равна 0. сохраняются все посещения</P>
      <P>// независимо от их частоты.</P>
      <P>// Остальные целочисленные значения интерпретируются как интервал</P>
      <P>// времени в секундах.</P>
      <P>$timeLimit = 3600:</P>
      <P>// Формат отображения данных в браузере</P>
      <P>$header_color = "#cbda74";</P>
      <P>$table_color = "#000080";</P>
      <P>$row_color = "IcOcOcO";</P>
      <P>$font_color = "#000000":</P>
      <P>$font_face = "Arial. Times New Roman. Verdana";</P>
      <P>$font_size = "-1";</P>
      <P>function recordUser() {</P>
      <P>GLOBAL $visitors_table, $HTTP_USER_AGENT, $REMOTE_AODR, $REMOTE_HOST; 
      if ($REMOTE_HOST — "") :</P>
      <P>$REMOTE_HOST - "localhost"; endif;</P>
      <P>$timestamp - date("Y-m-d H:i:S");</P>
      <P>$query - "INSERT INTO $visitors_table VALUES('$HTTP_USER_AGENT', 
      '$REMOTE_ADDR', '$REMOTE_HOST', '$timestamp')";</P>
      <P>Sresult = @mysql_query($query); }</P>
      <P>// recordUser function viewStats() {</P>
      <P>GLOBAL $visitors_table, $maxNumVisitors, $table_color, 
      $header_color;</P>
      <P>GLOBAL $row color. $font color, $font face, $font size:</P>
      <P>$query = "SELECT browser, ip. host. TimeofVisit FROM $visitors_table 
      ORDER BY TimeofVisit desc LIMIT 0, $maxNumVisitors";</P>
      <P>$result = mysql_query($query);</P>
      <P>print "&lt;table cellpadding=\"2\" cellspacing=\"1\" width = \"700\" 
      border = \"0\" bgcolor=\ " $table_color\ "&gt;";</P>
      <P>print "&lt;tr bgcolor= 
      \"$header_color\"&gt;&lt;th&gt;Browser&lt;/th&gt;&lt;th&gt;IP&lt;/th&gt;&lt;th&gt;Host&lt;/ 
      th&gt;&lt;th&gt;TimeofVisit&lt;/th&gt;&lt;/tr&gt;";</P>
      <P>while($row = mysql_fetch_array($result));</P>
      <P>list ($browse_type, $browse_version) = browser_info ($row["browser"]); 
      $op_sys = opsys_info ($row["browser"]);</P>
      <P>print "&lt;tr bgcolor=\"$row_color\"&gt;";</P>
      <P>print "&lt;td&gt;&lt;font color=\"$font_color\" face=\"$font_face\" 
      size=\"$font_size\"&gt;$browse_type $browse_version = 
      $op_sys&lt;/font&gt;&lt;/td&gt;";</P>
      <P>print "&lt;td&gt;&lt;font color=\"$font_color\" face=\"$font_face\" si 
      ze=\"$font_size\"&gt;".$row["ip"]."&lt;/f ont&gt;&lt;/td&gt;";</P>
      <P>print "&lt;td&gt;&lt;font color=\"$font_color\" face=\"$font_face\" 
      size=\"$font_size\"&gt;".$row["host"]."&lt;/font&gt;&lt;/td&gt;";</P>
      <P>print "&lt;td&gt;&lt;font color=\"$font_color\" face=\"$font_face\" 
      size=\"$font_size\"&gt;";</P>
      <P>print $row["TimeofVisit"]."&lt;/font&gt;&lt;/td&gt;";</P>
      <P>print "&lt;/tr&gt;";</P>
      <P>endwhile;</P>
      <P>print "&lt;/table&gt;"; }</P>
      <P>// viewStats</P>
      <P>?&gt;</P>
      <P>Фрагмент кода, приведенный в листинге 13.10, проверяет существование 
      cookie и при необходимости вызывает функцию recordUser( ). Я привожу этот 
      фрагмент в составе очень простого индексного файла index.php.</P>
      <P>Листинг 13.10. Проверка существования cookie (index.php)</P>
      <P>&lt;?</P>
      <P>include("Listing13-9.php"); if (! isset($$cookieName)) :</P>
      <P>// Создать cookie</P>
      <P>setcookie($cookieName, $cookieValue, time()+$timeLimit);</P>
      <P>// Сохранить информацию о посетителе recordUser();</P>
      <P>endif:</P>
      <P>?&gt;</P>
      <P>&lt;html&gt;</P>
      <P>&lt;head&gt;</P>
      <P>&lt;title&gt;Wecome to My Site!&lt;/title&gt;</P>
      <P>&lt;/head&gt;</P>
      <P>&lt;body bgcolor="#c0c0c0" text="#000000" link="#808040" " 
      vlink="#808040" alink="#808040"&gt;</P>
      <P>Welcome to my site. &lt;a href = "visitors.php"&gt;Check out who else 
      has recently visited&lt;/a&gt;.</P>
      <P>&lt;/body&gt;</P>
      <P>&lt;/html&gt;</P>
      <P>Как организовать просмотр информации, хранящейся в базе данных MySQL, в 
      браузере? Задача решается простым вызовом функции viewStats( ) в отдельном 
      файле visitors.php:</P>
      <P>&lt;html&gt;</P>
      <P>&lt;?</P>
      <P>include("sniffer.inc"):</P>
      <P>include("init.inc");</P>
      <P>?&gt;</P>
      <P>&lt;head&gt;</P>
      <P>&lt;title&gt;Most recent &lt;?=$maxNumVisitors:?&gt; 
      visitors&lt;/title&gt;</P>
      <P>&lt;/head&gt;</P>
      <P>&lt;body bgcolor="#ffffff" text="#000000" link="#808040" 
      vlink="#808040" alink="#808040"&gt;</P>
      <P>viewStats( );</P>
      <P>?&gt;</P>
      <P>&lt;/body&gt;</P>
      <P>&lt;/html&gt;</P>
      <P>Возможно и другое решение — включить весь код HTML в функцию viewStats( 
      ), а затем просто включить sniffer.inc, init.inc и вызов viewStats( ) в 
      отдельный файл. Выбор зависит от того, до какой степени вы хотите 
      интегрировать форматирование таблицы с процессом выборки данных.</P>
      <P>На рис. 13.1 показан пример выходных данных viewStats( ) для атрибутов 
      форматирования, заданных в файле init.inc.</P>
      <P><IMG src="2_1_13.1Rus.jpg"></P>
      <P>Рис. 13.1. Пример результата, сгенерированного функцией viewStats( 
)</P>
      <P>Существует немало путей для расширения практических возможностей этого 
      приложения. Например, для отслеживания посещений со страницами сайта часто 
      связываются идентификаторы, по которым в дальнейшем можно следить за 
      перемещением пользователей между страницами. В рассмотренном проекте для 
      этого в таблицу MySQL следует включить дополнительное поле, в котором 
      хранится идентификатор страницы, а затем переопределить функцию 
      recordllser( ) с дополнительным параметром. Идентификатор страницы 
      сохраняется в cookie. При поступлении очередного запроса сценарий 
      проверяет существование cookie для конкретной страницы, информация о 
      которой регистрируется в журнале.</P>
      <P><A name=i></A>Итоги</P>
      <P>В этой главе был представлен один из самых замечательных аспектов языка 
      РНР — отслеживание сеанса. В частности, были рассмотрены следующие 
      темы:</P>
      <UL>
        <LI>общие сведения о cookie; 
        <LI>работа с cookie в РНР; 
        <LI>создание уникальных идентификаторов; 
        <LI>сценарии регистрации пользователей; 
        <LI>общие сведения о сеансах; 
        <LI>параметры сеансов в файле php.ini; 
        <LI>стандартные сеансовые функции в РНР; 
        <LI>функция session_set_save_handler( ); 
        <LI>учет посещений сайта. </LI></UL>
      <P>Концепция сеанса открывает очень широкие возможности перед 
      разработчиками web-сайтов, ориентированных на пользователя. Настоятельно 
      рекомендую поэкспериментировать с сеансовыми средствами РНР — думаю, вы 
      оцените ту пользу, которую они могут принести.</P>
      <P>На этом завершается вторая часть книги. Третья часть, «РНР для 
      профессионалов», открывается обзором интеграции РНР с XML. Не 
      расслабляйтесь, самое интересное 
впереди.</P></LI></DIV>
<center>
[ <a href="12.php">Назад</a> | <a href="index.php">Содержание</a> | <a href="14.php">Вперед</a> ]
</center><br>
<? include_once '../../sys/inc/tfoot.php'; ?>