<?include'h.php';?>
<html><head>
		<title>Учебник PHP, Глава 15</title>
		<meta http-equiv="Content-type" content="text/html; charset=Windows-1251">
		</head>
		
      <DIV class=infotxt>
      <LI><A href="http.html://doks.gorodok.net/?p=118#a">Глава 15. JavaScript и 
      COM</A> 
      <UL>
        <LI><A href="http.html://doks.gorodok.net/?p=118#b">JavaScript</A> 
        <UL>
          <LI><A href="http.html://doks.gorodok.net/?p=118#c">Проверка поддержки 
          JavaScript</A> 
          <LI><A href="http.html://doks.gorodok.net/?p=118#d">Динамическое создание 
          временных окон</A> </LI></UL>
        <LI><A href="http.html://doks.gorodok.net/?p=118#e">COM</A> 
        <UL>
          <LI><A href="http.html://doks.gorodok.net/?p=118#f">Поддержка COM в PHP</A> 

          <LI><A href="http.html://doks.gorodok.net/?p=118#g">Запись информации в 
          документ Microsoft Word</A> 
          <LI><A href="http.html://doks.gorodok.net/?p=118#h">Дополнительная 
          информация</A> </LI></UL>
        <LI><A href="http.html://doks.gorodok.net/?p=118#i">Итоги</A> </LI></UL>
      <UL></UL>
      <P>&nbsp;</P>
      <P><A name=a></A>ГЛАВА 15</P>
      <P>JavaScript и COM</P>
      <P>Как неоднократно упоминалось в книге, одной из самых замечательных 
      особенностей РНР является простота его интеграции с другими технологиями. 
      Примеры такой интеграции уже встречались при описании работы с базами 
      данных, ODBC и XML. В этой главе будет показано, как просто организуется 
      работа РНР в комбинации с JavaScript и приложениями на базе СОМ. Ниже 
      приводятся общие сведения о JavaScript и СОМ, подкрепленные примерами их 
      использования в РНР. К концу главы вы узнаете немало полезного об этих 
      замечательных технологиях и о том, как они применяются в РНР.</P>
      <P><A href="http.html://doks.gorodok.net/0" name=b></A>JavaScript</P>
      <P>Сценарный язык JavaScript обладает чрезвычайно богатыми возможностями 
      для разработки Интернет-приложений, работающих как на клиентской, так и на 
      серверной стороне. У этого языка есть немало интересных особенностей, и 
      одна из них — возможность обработки не только данных, но и событий. 
      Событие определяется как некоторое действие, выполненное в контексте 
      браузера, — например, щелчок мышью или загрузка страницы.</P>
      <P>Любой программист с опытом работы на РНР, Pascal или C++ освоит 
      JavaScript без особого труда. Если вы не программировали на этих языках, 
      не огорчайтесь — JavaScript изучается легко. Разработчики JavaScript (как, 
      впрочем, и разработчики РНР) в первую очередь ориентировались на решение 
      реальных, практических задач.</P>
      <P>Если вы хотите воспользоваться средствами обработки,событий JavaScript, 
      сохранив при этом многочисленные преимущества РНР, могу вас обрадовать — 
      РНР интегрируется с JavaScript так же легко, как и с HTML. В сущности, 
      JavaScript неплохо дополняет РНР — на нем удобно делать то, что неудобно 
      делать в РНР, и наоборот.</P>
      <P>Но прежде чем интегрировать РНР с JavaScript, следует учесть, что 
      некоторые пользователи отключают поддержку JavaScript в своих браузерах 
      или работают в браузерах, вообще не поддерживающих JavaScript 
      (представьте, такое тоже бывает!). В РНР предусмотрены простые средства 
      для распознавания таких ситуаций.</P>
      <P><A name=c></A>Проверка поддержки JavaScript</P>
      <P>Правильное определение возможностей браузера избавит пользователей от 
      неприятностей при посещении вашего сайта. Ничто так не действует на нервы, 
      как град раздражающих сообщений «JavaScript Error» или недоступность 
      каких-то средств сайта из-за того, что использованные вами технологии не 
      поддерживаются браузером. К счастью, в РНР предусмотрено простое средство 
      для проверки возможностей браузера — стандартная функция get_browser( 
      ).</P>
      <P>get_browser( )</P>
      <P>Функция get_browser( ) возвращает информацию о возможностях браузера в 
      виде объекта. Синтаксис: </P>
      <P>object get_browser([string агент])</P>
      <P>Необязательный параметр агент используется для получения характеристик 
      конкретного браузера. Как правило, функция get_browser( ) вызывается без 
      параметров, поскольку по умолчанию она использует глобальную переменную 
      РНР $HTTP_USER_AGENT.</P>
      <P>Стандартный список возможностей браузера хранится в файле browcap, путь 
      к которому определяется параметром browcap в файле php.ini. По умолчанию 
      эта строка выглядит следующим образом:</P>
      <P>;browcap = extra/browcap.ini</P>
      <P>Файл browser.ini был разработан компанией cyScape, Inc. Последняя 
      версия этого файла находится по адресу <A 
      href="http.html://www.cyscape.com/browcap">http://www.cyscape.com/browcap</A>. 
      Загрузите и распакуйте этот файл в каталог на сервере. Запомните имя 
      каталога, оно понадобится вам для обновления параметра browcap в файле 
      php.ini.</P>
      <P>В принципе, после загрузки browcap.ini и редактирования файла php.ini 
      вы можете включать в свои программы проверку возможностей браузера. 
      Впрочем, я рекомендую сначала открыть файл browser.ini и ознакомиться с 
      его структурой, а затем просмотреть листинги 15.1 и 15.2. В листинге 15.1 
      приведен очень простой пример отображения всех возможностей браузера в 
      самом браузере. Листинг 15.2 ограничивается лишь одной возможностью — 
      поддержкой JavaScript.</P>
      <P>Листинг 15.1. Отображение всех атрибутов браузера</P>
      <P>&lt;?</P>
      <P>// Получить информацию о браузере</P>
      <P>$browser = get_browser();</P>
      <P>// Преобразовать $browser в массив</P>
      <P>Sbrowser = (array) Sbrowser;</P>
      <P>while (list ($key, $value) = each ($browser)) :</P>
      <P>// Присвоить нули пустым элементам массива</P>
      <P>if ($value == "") : $value = 0;</P>
      <P>endif;</P>
      <P>print "$key : $value &lt;br&gt;";</P>
      <P>endwhile;</P>
      <P>?&gt;</P>
      <P>Для браузера Microsoft Internet Explorer 5.0 листинг 15.1 выводит 
      следующий результат:</P>
      <P>browser_name_pattern : Mozilla/4\.0 (compatible; MSIE 5\..*)</P>
      <P>parent IE 5.0</P>
      <P>browser : 5.0</P>
      <P>version : 15</P>
      <P>majorver : #5</P>
      <P>minorver : #5</P>
      <P>frames : 1</P>
      <P>tables : 1</P>
      <P>cookies : 1</P>
      <P>backgroundsounds : 1</P>
      <P>vbscript : 1</P>
      <P>javascript : 1</P>
      <P>javaapplets : 1</P>
      <P>activexcontrols : 1</P>
      <P>win16 : 0</P>
      <P>beta : 0</P>
      <P>ak : 0</P>
      <P>sk : 0</P>
      <P>aol : 0</P>
      <P>crawler : 0</P>
      <P>cdf : 1</P>
      <P>В листинге 15.2 приведен простой, но эффективный сценарий, который при 
      помощи файла browcap.ini определяет, включена ли поддержка JavaScript в 
      браузере.</P>
      <P>Листинг 15.2. Проверка поддержки JavaScript</P>
      <P>&lt;?</P>
      <P>$browser = get_browser( );</P>
      <P>// Преобразовать $browser в массив $browser = (array) $browser;</P>
      <P>if ($browser["javascript"] == 1) :</P>
      <P>print "Javascript enabled!";</P>
      <P>else :</P>
      <P>print "No javascript allowed!";</P>
      <P>endif;</P>
      <P>?&gt;</P>
      <P>Листинг 15.2 проверяет, присутствует ли ключ javascript для заданного 
      браузера. Если ключ присутствует и равен 1, в браузере выводится сообщение 
      о поддержке JavaScript. В противном случае выводится сообщение об ошибке. 
      Конечно, в реальной программе вместо выдачи сообщения следует выполнить 
      какие-нибудь полезные действия.</P>
      <P>Следующие два примера показывают, как легко РНР,интегрируется с 
      JavaScript. Листинг 15.3 определяет параметры экрана (разрешение и 
      цветовую глубину) средствами JavaScript и затем выводит их средствами РНР. 
      Листинг 15.4 (см. следующий раздел) показывает, как при помощи шаблона РНР 
      во временном (pop-up) окне, вызванном из кода JavaScript, выводится 
      информация о ссылке, на которой щелкнул пользователь.</P>
      <P>Листинг 15.3. Определение цветовой глубины и разрешения экрана</P>
      <P>&lt;html&gt;</P>
      <P>&lt;head&gt;</P>
      <P>&lt;title&gt;Browser Information&lt;/title&gt;</P>
      <P>&lt;/head&gt;</P>
      <P>&lt;body&gt;</P>
      <P>&lt;script language="Javascriptl.2"&gt;</P>
      <P>&lt;!--//</P>
      <P>document.write('&lt;form method=POST action ="&lt;? echo $PHP_SELF; 
      ?&gt;"&gt;');</P>
      <P>document.write('&lt;input type=hidden name=version value=' + 
      navigator.appVersion + '&gt;');</P>
      <P>document.write('&lt;input type=hidden name=type value=' + 
      navigator.appName + '&gt;');</P>
      <P>document.write('&lt;input type=hidden name-screenWidth value=' + 
      screen.width +'&gt;');</P>
      <P>document.write('&lt;input type=hidden name=screenHeight value=' + 
      screen.height + '&gt;'};</P>
      <P>document.write('&lt;input type=hidden name=browserHeight value=' + 
      window.innerWidth + '&gt;');</P>
      <P>document.write('&lt;input type=hidden name=browserWidth value=' + 
      window.innerHeight + '&gt;');</P>
      <P>//--&gt;</P>
      <P>&lt;/script&gt;</P>
      <P>&lt;input type="submit" value="Get browser 
information"&gt;&lt;p&gt;</P>
      <P>&lt;/form&gt;</P>
      <P>&lt;?</P>
      <P>echo "&lt;b&gt;Browser:&lt;/b&gt; $type Version: 
      $version&lt;br&gt;";</P>
      <P>echo "&lt;b&gt;Screen Resolution:&lt;/b&gt; $screenWidth x 
      $screenHeight pixels.&lt;br&gt;";</P>
      <P>if ($browserWidth != 0) :</P>
      <P>echo "&lt;b&gt;Browser resolution:&lt;/b&gt; $browserWidth x 
      $browserHeight pixels.";</P>
      <P>else :</P>
      <P>echo "No javascript browser resolution support for Internet 
      Explorer";</P>
      <P>endif;</P>
      <P>?&gt;</P>
      <P>&lt;/body&gt;</P>
      <P>&lt;/html&gt;</P>
      <P><A name=d></A>Динамическое создание временных окон</P>
      <P>В JavaScript предусмотрены простые и удобные средства для работы с 
      окнами браузера. В частности, JavaScript позволяет отображать временные 
      окна с вспомогательной информацией, не оправдывающей создания и загрузки 
      отдельной страницы. Напрашивается очевидная идея — построить универсальный 
      шаблон, который будет использоваться для всех временных окон. Все, что для 
      этого потребуется, — РНР. В листинге 15.4 показано, как файл РНР 
      window.php вызывается из JavaScript. В этом файле реализован очень простой 
      шаблон с директивой INCLUDE для включения файла, идентификатор которого 
      передается window.php при вызове из JavaScript.</P>
      <P>Для читателей, не имеющих опыта программирования на JavaScript, я 
      включил в программу подробные комментарии. Значение переменной winld, 
      передаваемой сценарию РНР window.php, задается внутри ссылки в основном 
      коде HTML. Когда пользователь щелкает на ссылке, вызывается функция 
      newWindow( ), определенная в JavaScript. Чтобы вы лучше поняли, как это 
      происходит, рассмотрим следующую ссылку:</P>
      <P>&lt;а href="#" onClick="newWindow(1):"&gt;Contact 
      us&lt;/a&gt;&lt;br&gt;</P>
      <P>Как видите, я просто включаю в href значение "#", поскольку ссылка 
      генерируется обработчиком события onClick в JavaScript. Установка 
      обработчика приводит к тому, что при щелчке на ссылке вызывается функция 
      newWindow( ). Обратите внимание на параметр, передаваемый при вызове этой 
      функции (в приведенном примере — 1). Содержащийся в нем идентификатор 
      используется сценарием РНР для выбора отображаемой информации. Вы можете 
      передать любое число — при условии, что оно соответствует имени файла, 
      отображаемого в сценарии РНР. Внимательно просмотрите листинг 15.4. Чтобы 
      вам было легче ориентироваться, я создал три простых файла *.inc, 
      соответствующих ссылкам в этом листинге.</P>
      <P>Листинг 15.4. Динамическое построение временных окон</P>
      <P>&lt;html&gt;</P>
      <P>&lt;head&gt;</P>
      <P>&lt;title&gt;Listing 15-4&lt;/title&gt;</P>
      <P>&lt;SCRIPT language="Javascript"&gt;</P>
      <P>// Объявить переменную Javascript</P>
      <P>var popWindow;</P>
      <P>// Объявить функцию newWindow</P>
      <P>function newWindow(winID)</P>
      <P>{</P>
      <P>// Объявить переменную winURL. Присвоить ей</P>
      <P>// имя файла РНР с последующими данными.</P>
      <P>var winURL = "Listingl5-5.php?winID=" + winID;</P>
      <P>// Если временное окно не существует или закрыто.</P>
      <P>// открыть его.</P>
      <P>if (! popWindow | popWindow.closed) {</P>
      <P>// Открыть новое окно шириной 200 пикселов и высотой</P>
      <P>// 300 пикселов, расположенное на расстоянии 150 пикселов</P>
      <P>// от левого края и 100 пикселов от верхнего края</P>
      <P>// основного окна.</P>
      <P>popWindow = window.open(winURL. 'popWindow',</P>
      <P>dependent.width=200.height=300.left=150 ,top=100');</P>
      <P>}</P>
      <P>// Если временное окно уже открыто.</P>
      <P>// активизировать его и обновить содержимое</P>
      <P>// в соответствии с winURL.</P>
      <P>else {</P>
      <P>popWindow.focus();</P>
      <P>popWindow.location = winURL;</P>
      <P>}</P>
      <P>}</P>
      <P>//--&gt;</P>
      <P>&lt;/SCRIPT&gt;</P>
      <P>&lt;/head&gt;</P>
      <P>&lt;body bgcolor="#ffffff" text="#000000" 
      link="#808040"'vlink="#808040" alink="#808040"&gt;</P>
      <P>&lt;a href="#" onClick="newWindow(1);"&gt;Contact 
      Us&lt;/a&gt;&lt;br&gt;</P>
      <P>&lt;a href="#" onClick="newWindow(2):"&gt;Driving 
      Directions&lt;/a&gt;&lt;br&gt;</P>
      <P>&lt;a href="#" onClick="newWindow(3);"&gt;Weather 
      Report&lt;/a&gt;&lt;br&gt;</P>
      <P>&lt;/body&gt;</P>
      <P>&lt;/html&gt;</P>
      <P>Когда пользователь щелкает на одной из ссылок в листинге 15.4, 
      программа создает временное окно и загружает в него содержимое, полученное 
      в результате вызова window.php. Сценарию window.php передается переменная 
      winID, по которой определяется файл, включаемый в сценарий РНР. Сценарий 
      window.php приведен в листинге 15.5.</P>
      <P>Листинг 15.5. Сценарий window.php</P>
      <P>&lt;html&gt;</P>
      <P>&lt;head&gt;</P>
      <P>&lt;title&gt;Popup Window Fun&lt;/title&gt;</P>
      <P>&lt;/head&gt;</P>
      <P>&lt;body bgcolor="#ffffff" text="#000000" link="black" vlink="gray" 
      alink="#808040"&gt;</P>
      <P>&lt;table width="100%" border="0" cellpadding="0" 
      cellspacing="0"&gt;</P>
      <P>&lt;tr&gt;</P>
      <P>&lt;td&gt;</P>
      <P>&lt;?</P>
      <P>// Включить файл, имя которого определяется</P>
      <P>// переданным параметром.</P>
      <P>INCLUDE("$winID.inc");</P>
      <P>?&gt;</P>
      <P>&lt;/td&gt;</P>
      <P>&lt;/tr&gt;</P>
      <P>&lt;tr&gt;</P>
      <P>&lt;td&gt;</P>
      <P>&lt;a href="#" onClick="parent.self.closet);</P>
      <P>"&gt;close window&lt;/a&gt;</P>
      <P>&lt;/td&gt;</P>
      <P>&lt;/tr&gt;</P>
      <P>&lt;/table&gt;</P>
      <P>&lt;/body&gt;</P>
      <P>&lt;/html&gt;</P>
      <P>Остается лишь создать файлы для ссылок в листинге 15.4. Поскольку в 
      ссылках передаются три уникальных идентификатора (1, 2 и 3), мы должны 
      создать три файла. Первый файл, содержащий контактную информацию, 
      сохраняется с именем Line:</P>
      <P>&lt;td&gt;</P>
      <P>&lt;h4&gt;Contact Us&lt;/h4&gt;</P>
      <P>&lt;table&gt; &lt;tr&gt;</P>
      <P>&lt;li&gt;email: &lt;a 
      href="mailto.html:wj@wjgilmore.com"&gt;wj@wjgilmore.com&lt;/a&gt; 
      &lt;li&gt;phone: (555) 867 5309 &lt;li&gt;mobile: (555) 555 5555 
      &lt;/ul&gt; &lt;/td&gt;</P>
      <P>&lt;/tr&gt; &lt;/table&gt;</P>
      <P>Следующий файл (местонахождение) сохраняется с именем 2.inс.</P>
      <P>&lt;table&gt;</P>
      <P>&lt;tr&gt;</P>
      <P>&lt;td&gt;</P>
      <P>&lt;h4&gt;Driving Directions&lt;/h4&gt;</P>
      <P>&lt;ol&gt;</P>
      <P>&lt;li&gt;Turn left on 1st avenue.</P>
      <P>&lt;li&gt;Enter the old Grant building.</P>
      <P>&lt;li&gt;Take elevator to 4th floor.</P>
      <P>&lt;li&gt;We're in room 444.</P>
      <P>&lt;/td&gt;</P>
      <P>&lt;/tr&gt;</P>
      <P>&lt;/table&gt;</P>
      <P>Последний файл (сводка погоды) сохраняется с именем 3.inc. Обратите 
      внимание на вызов функции РНР, возвращающей текущую дату, — этот пример 
      наглядно показывает, как легко РНР интегрируется с JavaScript: ,</P>
      <P>&lt;table&gt;</P>
      <P>&lt;tr&gt;</P>
      <P>&lt;td&gt;</P>
      <P>&lt;h4&gt;Weather Report &lt;?=date("m-d-Y");?&gt;&lt;/h4&gt;</P>
      <P>&lt;b&gt;Today:&lt;/b&gt; Birr... Brisk, with blowing and drifting 
      snow.&lt;br&gt;&lt;br&gt;</P>
      <P>&lt;b&gt;Tonight:&lt;/b&gt; Winter Weather Advisory. 7-10 inches snow 
      expected.</P>
      <P>&lt;/td&gt;</P>
      <P>&lt;/tr&gt;</P>
      <P>&lt;/table&gt;</P>
      <P>На рис. 15.1 показано, как выглядит временное окно, открываемое по 
      третьей ссылке.</P>
      <P>&nbsp;<IMG src="2_1_15.1Rus.jpg"></P>
      <P>Рис. 15.1. Сводка погоды во временном окне</P>
      <P>Наше короткое знакомство с интеграцией PHP/JavaScript подходит к концу. 
      Мы рассмотрели несколько простых, но вполне реальных примеров, которые при 
      желании легко адаптируются для более сложных целей. При объединении РНР с 
      JavaScript или любой другой технологией, ориентированной на работу на 
      стороне сервера, необходимо правильно определить возможности браузера, 
      чтобы предотвратить случайные ошибки. Всегда полезно поэкспериментировать 
      с другими технологиями, интегрируемыми с кодом РНР; только проследите за 
      тем, чтобы не отпугнуть пользователей от сайта недоступными возможностями 
      или содержанием, которое невозможно просмотреть.</P>
      <P>Следующий раздел посвящен СОМ — еще одной технологии, с которой легко 
      работать средствами РНР.</P>
      <P><A name=e></A>СОМ</P>
      <P>Технология СОМ (сокращение от «Component Object Model», то есть «модель 
      составного объекта») обеспечивает взаимодействие между приложениями, 
      работающими на разных языках и платформах. Такое взаимодействие в 
      значительной мере способствует идее построения многократно используемых, 
      легко сопровождаемых и адаптируемых программных компонентов (в последнее 
      время к этим трем принципам проявляется повышенное внимание в области 
      компьютерных технологий). Хотя СОМ обычно рассматривается как 
      спецификация, ориентированная в первую очередь на продукты Microsoft, 
      поддержка СОМ уже реализована во многих языках (например, в РНР, Java, C++ 
      и Delphi) и существует на многих платформах, включая Windows, Linux и 
      Macintosh.</P>
      <P>Что же вам даст объединение СОМ с РНР? Во-первых, средства СОМ 
      позволяют напрямую взаимодействовать со многими приложениями Microsoft. 
      Ниже рассмотрен интересный пример — форматирование и вывод в Microsoft 
      Word записей базы данных, полученных из Web. В следующем разделе вы 
      увидите, как легко решается эта задача.</P>
      <P>На нескольких страницах, посвященных технологии СОМ, эту огромную тему 
      нельзя осветить даже поверхностно. Ситуация осложняется тем, что 
      возможности использования СОМ в языке РНР почти не документируются. За 
      дополнительной информацией о механизме работы СОМ обращайтесь к ресурсам, 
      перечисленным в конце этой главы.</P>
      <P>РНР содержит несколько стандартных функций для работы с СОМ. Учтите, 
      эти функции поддерживаются только в версии РНР для Windows! Прежде чем 
      переходить к примерам, мы рассмотрим все эти функции.</P>
      <P><A name=f></A>Поддержка СОМ в РНР</P>
      <P>Стандартные функции РНР, предназначенные для работы с СОМ, создают 
      объекты СОМ и используют их свойства и методы. Пожалуйста, не забывайте о 
      том, что эта поддержка присутствует только в версии РНР для Windows. 
      Следующие примеры были протестированы для Microsoft Word 2000. За 
      информацией об объектах, методах и событиях, используемых в программе, 
      обращайтесь на web-сайт MSDN 
      (http://msdn.microsoft.com/library/officedev/off2000/ 
      wotocobjectmodelapplication.htm).</P>
      <P>Создание экземпляров объектов СОМ</P>
      <P>Экземпляры объектов СОМ создаются вызовом new, как при обычном 
      объектно-ориентированном программировании. Синтаксис:</P>
      <P>object new СОМ("обьекг.класс" [, string удаленный_адрес])</P>
      <P>Параметр объект.класс определяет модуль СОМ, присутствующий на сервере. 
      Необязательный параметр удаленный_адрес используется в том случае, если 
      объект СОМ создается на удаленном компьютере. Допустим, вы хотите создать 
      экземпляр объекта для приложения MS Word. При этом приложение Microsoft 
      Word запускается так, словно вы запустили его вручную (разумеется, для 
      этого MS Word должен быть установлен на компьютере). Команда имеет 
      следующий синтаксис:</P>
      <P>$word=new COM("word.application") or die("Couldn't start Word!");</P>
      <P>После того как экземпляр объекта СОМ будет создан, можно приступать к 
      работе с различными методами и свойствами этого объекта. Допустим, вы 
      захотели активизировать окно Word. Следующая команда изменяет атрибут 
      видимости объекта, в результате чего графический интерфейс приложения 
      отображается на экране:</P>
      <P>$word-&gt;visible = 1:</P>
      <P>He огорчайтесь, если эта команда выглядит непонятной. Вызов методов 
      объектов СОМ рассматривается в следующем разделе.</P>
      <P>Вызов методов объекта СОМ</P>
      <P>Методы объектов СОМ вызываются в типичном для ООП формате, с 
      использованием ссылки из объектной переменной. Синтаксис:</P>
      <P>объект-&gt;имя_метода([значение, ...]) </P>
      <P>Объект соответствует экземпляру объекта СОМ, созданному описанным выше 
      способом. Параметр имя_метода определяет имя метода, определенного в 
      классе объект. Необязательный параметр значение позволяет передавать 
      параметры при вызове методов, допускающих (или требующих) дополнительных 
      данных. Как и при вызове обычных функций, параметры разделяются запятыми. 
      Если после создания экземпляра объекта СОМ, представляющего MS Word, вы 
      захотите создать в приложении новый документ, просто вызовите 
      соответствующий метод. Задача решается методом add( ) субкласса Documents 
      экземпляра $word:</P>
      <P>$word-&gt;Documents-&gt;Add( );</P>
      <P>Обратите внимание: для вызова методов используется очень логичный 
      синтаксис в стиле ООП. В результате выполнения этой команды в окне 
      приложения MS Word открывается новый документ.</P>
      <P>com_get( )</P>
      <P>Функция com_get( ) возвращает значение свойства объектов СОМ. 
      Синтаксис:</P>
      <P>mixed com_get(resource объект, string свойство)</P>
      <P>Первый параметр определяет экземпляр объекта СОМ, а второй — атрибут 
      класса, к которому относится данный экземпляр.</P>
      <P>&lt;?</P>
      <P>// Создать экземпляр объекта для приложения MS Word</P>
      <P>$word=new COM("word.application") or die("Couldn't start Word!");</P>
      <P>// Режим CapsLock либо включен (свойство CapsLock = 0),</P>
      <P>// либо выключен (свойство CapsLock = 1).</P>
      <P>$flag = com_get(Sword-&gt;Application.CapsLock)</P>
      <P>// Преобразовать значение Sflag (0 или 1) в логическое значение</P>
      <P>if ($flag == 1) :</P>
      <P>$flag = "YES";</P>
      <P>else :</P>
      <P>$flag = "NO";</P>
      <P>endif;</P>
      <P>// Вывести сообщение</P>
      <P>print "CAPS Lock activated: $flag";</P>
      <P>$word-&gt;Quit();</P>
      <P>?&gt;</P>
      <P>Существует и другое решение — значение атрибута CapsLock можно получить 
      при помощи стандартного для ООП синтаксиса обращения к атрибутам. В 
      предыдущем примере для этого следует заменить строку</P>
      <P>$flag = com_get($word-&gt;Application,CapsLock)</P>
      <P>следующей строкой:</P>
      <P>$flag = $word-&gt;Application-&gt;CapsLock:</P>
      <P>Атрибуты объекта позволяют получать разнообразную информацию о 
      характеристиках приложения. Более того, многим атрибутам можно присваивать 
      новые значения. Это делается при помощи функции com_set( ).</P>
      <P>com_set( )</P>
      <P>Функция com_set( ) присваивает атрибуту объекта новое значение:</P>
      <P>void com_set(resource объект, string свойство, mixed значение)</P>
      <P>Первый параметр определяет экземпляр объекта СОМ, а второй — атрибут 
      класса, к которому относится данный экземпляр. Третий параметр определяет 
      новое значение свойства.</P>
      <P>Следующая программа (листинг 15.6) запускает Microsoft Word и 
      активизирует окно приложения. Затем она создает новый документ, добавляет 
      в него строку текста и выбирает режим сохранения документа (атрибут 
      DefaultSaveFormat) в текстовом формате. Результат виден при открытии окна 
      Сохранить как (Save As) — в списке Тип файла (Save As Type) автоматически 
      выбирается строка Только текст (Text Only). После сохранения документа 
      приложение Microsoft Word закрывается.</P>
      <P>Листинг 15.6. Выбор типа документа по умолчанию</P>
      <P>&lt;?</P>
      <P>// Создать экземпляр объекта для приложения MS Word</P>
      <P>$word-new COMC'word.application") or die("Couldn't start Word!");</P>
      <P>// Активизировать окно MS Word $word-&gt;visible = 1;</P>
      <P>// Создать новый документ $word-&gt;Documents-&gt;Add();</P>
      <P>// Вставить в документ фрагмент текста</P>
      <P>$word-&gt;Selection-&gt;Typetext("php's com functionality is 
      cool\n");</P>
      <P>// Выбрать текстовый режим сохранения</P>
      <P>$ok = com_set($word-&gt;Application, DefaultSaveFormat, "Text");</P>
      <P>// Запросить у пользователя имя и сохранить документ.</P>
      <P>// Обратите внимание: по умолчанию документ сохраняется</P>
      <P>// в текстовом формате! $word-&gt;Documents[l]-&gt;Save;</P>
      <P>// Выйти из MS Word</P>
      <P>$word-&gt;Quit();</P>
      <P>?&gt;</P>
      <P>Существует и другое решение — новое значение атрибута DefaultSaveFormat 
      можно присвоить непосредственно, как обычной переменной. В листинге 15.6 
      для этого следует заменить строку</P>
      <P>$ok = com_set($word-&gt;Application, DefaultSaveFormat, "Text");</P>
      <P>следующей строкой:</P>
      <P>$word-&gt;Application-&gt;DefaultSaveFormat = "Text";</P>
      <P>Итак, вы получили общее представление об управлении приложениями 
      Windows через поддержку СОМ в РНР. Мы переходим к занимательному примеру, 
      кото-</P>
      <P>рый наглядно показывает, каких полезных и впечатляющих результатов 
      можно добиться при помощи СОМ.</P>
      <P><A name=g></A>Запись информации в документ Microsoft Word</P>
      <P>Допустим, вам потребовалось отформатировать информацию, загруженную из 
      базы данных, в документе Word для построения отчета. Весь процесс 
      автоматизируется всего в нескольких строках кода РНР. Для демонстрационных 
      целей я воспользуюсь таблицей addressbook из проекта адресной книги, 
      приведенного в конце главы 12. Алгоритм работы сценария выглядит следующим 
      образом:</P>
      <OL>
        <LI>Подключиться к серверу MySQL и выбрать нужную базу данных. 
        <LI>Выбрать все данные из таблицы с сортировкой по фамилиям. 
        <LI>Открыть приложение Microsoft Word и создать новый документ. 
        <LI>Отформатировать и вывести все записи в документе. 
        <LI>Запросить у пользователя имя для сохранения документа. 
        <LI>Закрыть Microsoft Word. </LI></OL>
      <P>Программный код приведен в листинге 15.7.</P>
      <P>Листинг 15.7. Запись информации в документ Microsoft Word &lt;?</P>
      <P>&lt;?</P>
      <P>// Создать соединение с сервером MySQL</P>
      <P>$host = "localhost";</P>
      <P>$user = "root";</P>
      <P>$pswd = "";</P>
      <P>$db = "book";</P>
      <P>$address_table = "addressbook";</P>
      <P>mysql_connect($host. $user, $pswd)</P>
      <P>or die("Couldn't connect to MySQL server!");</P>
      <P>mysql_select_db($db) or die("Couldn't select database!");</P>
      <P>// Выбрать из базы данных все записи</P>
      <P>$query = "SELECT * FROM $address_table ORDER BY lastjiame";</P>
      <P>Sresult = mysql_query($query):</P>
      <P>// Создать новый объект COM для приложения MS Word</P>
      <P>$word=new COM("word.application") or die("Couldn't start Word!");</P>
      <P>// Активизировать окно MS Word $word-&gt;visible = 1;</P>
      <P>// Открыть пустой документ. $word-&gt;Documents-&gt;Add( );</P>
      <P>// Перебрать записи из таблицы адресов</P>
      <P>while($row = mysql_fetch_array($result));</P>
      <P>$last_name = $row["last_name"];</P>
      <P>$first_name = $row["first_name"];</P>
      <P>$tel = $row["tel"];</P>
      <P>$email = $row["email"];</P>
      <P>// Вывести данные таблицы в открытый документ Word.</P>
      <P>$word-&gt;Selection-&gt;Typetext("$last_name. $first_name\n"); 
      $word-&gt;Selection-&gt;Typetext("tel. $tel\n"): 
      $word-&gt;Selection-&gt;Typetext("email. $email:\n");</P>
      <P>endwhile;</P>
      <P>// Запросить у пользователя имя документа.</P>
      <P>$word-&gt;Documents[l]-&gt;Save;</P>
      <P>// Выйти из MS Word</P>
      <P>$word-&gt;Quit();</P>
      <P>?&gt;</P>
      <P>При всей простоте рассмотренный пример наглядно показывает, как писать 
      приложения РНР для пересылки содержимого базы данных в приложения Windows. 
      Можно написать и более сложное приложение, обеспечивающее синхронизацию 
      данных, полученных из Web, из Microsoft Outlook. Все, что для этого нужно 
      — получить ссылку на объекты, свойства и методы Outlook, после чего можно 
      переходить к экспериментам (обзор объектной модели всех приложений 
      семейства Office приведен по адресу <A 
      href="http.html://www.microsoft.com/officedev/articles/Opg/toc/PGTOC.htm">http://www.microsoft.com/officedev/articles/Opg/toc/PGTOC.htm</A>).</P>
      <P><A href="http.html://doks.gorodok.net/996" name=h></A>Дополнительная 
      информация</P>
      <P>Ниже перечислены ссылки на некоторые полезные ресурсы, посвященные СОМ 
      и найденные мной в Интернете:</P>
      <UL>
        <LI><A 
        href="http.html://msdn.microsoft.com/Library/techart/msdn_comppr.htm">http://msdn.microsoft.com/Library/techart/msdn_comppr.htm</A>; 

        <LI><A 
        href="http.html://www.microsoft.com/com/nets/drgui.asp">http://www.microsoft.com/com/nets/drgui.asp</A>; 

        <LI><A 
        href="http.html://www.microsoft.com/com/default.asp">http://www.microsoft.com/com/default.asp</A>; 

        <LI><A 
        href="http.html://www.comdeveloper.com/">http://www.comdeveloper.com/</A>. 
        </LI></UL>
      <P><A name=i></A>Итоги</P>
      <P>Эта глава в очередной раз показала, как легко РНР интегрируется с 
      внешними технологиями — а именно, JavaScript и COM (Component Object 
      Model). В частности, были рассмотрены следующие темы:</P>
      <UL>
        <LI>общие сведения о JavaScript; 
        <LI>проверка поддержки JavaScript в браузерах; 
        <LI>получение информации о возможностях браузера; 
        <LI>использование временных окон в сочетании с РНР; 
        <LI>общие сведения о технологии СОМ; 
        <LI>стандартные средства РНР для работы с СОМ; 
        <LI>использование поддержки СОМ в РНР для передачи информации из базы 
        данных в Microsoft Word. </LI></UL>
      <P>Интеграция этих технологий с РНР способна расширить функциональные 
      возможности ваших приложений по нескольким направлениям. JavaScript 
      позволяет выполнять на стороне клиента различные операции с окном и 
      браузером, а также производит проверку данных при заполнении форм. При 
      помощи СОМ можно создавать программы, напрямую работающие с многими 
      распространенными приложениями (например, из семейства Office), благодаря 
      чему ваши программы становятся более удобными и обретают новые 
      возможности. Последняя глава посвящена теме, постоянно занимающей умы 
      многих программистов и администраторов, — безопасности. В этой главе будут 
      представлены ключевые проблемы из области безопасности — защита сценариев, 
      шифрование и коммерческие средства проверки 
    данных.</P></LI></DIV>
<center>
[ <a href="14.php">Назад</a> | <a href="index.php">Содержание</a> ]
</center><br>
<? include_once '../../sys/inc/tfoot.php'; ?>