<? include 'head.php' ?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html><head>
<link rel="stylesheet" href="css.css" type="text/css">
<meta http-equiv="Content-Type" content="text/html; charset=windows-1251">
<meta http-equiv="Content-Language" content="ru">
<title>Глава 13.</title></head>
<body>
<blockquote>
<h1>Глава 13. Использование операторов<br>
ANY, ALL и SOME</h1>
<hr width="50%">
</blockquote>
<p>Теперь, когда вы овладели оператором EXISTS, вы узнаете о трёх специальных 
операторах, ориентируемых на подзапросы. (Фактически имеются только два, так как 
ANY и SOME - одно и то же.) Если вы поймёте работу этих операторов, вы будете 
понимать все типы подзапросов предиката, используемых в SQL. Кроме того, вам 
будут представлены различные способы того, как данный запрос может быть 
сформирован с использованием различных типов подзапросов предиката, и вы поймёте 
преимущества и недостатки каждого из этих подходов.</p>
<p>ANY, ALL и SOME напоминают EXISTS, принимая подзапросы как аргументы; однако 
они отличаются от EXISTS тем, что используются совместно с реляционными 
операциями. В этом отношении они напоминают оператор IN, когда тот используется 
с подзапросами: они берут все значения, выведенные подзапросом и обрабатывают их 
как модуль. Однако, в отличие от IN, они могут использоваться только с 
подзапросами.</p>
<h3><a name="13.1">С</a>ПЕЦИАЛЬНЫЕ ОПЕРАТОРЫ ANY ИЛИ SOME</h3>
<p>Операторы SOME и ANY взаимозаменяемы везде, и там, где мы используем ANY, 
SOME будет работать точно так же. Различие в терминологии состоит в том, чтобы 
позволить людям использовать тот термин, который является однозначным. Это может 
создать проблему, поскольку, как мы это увидим, наша интуиция может иногда 
вводить в заблуждение.</p>
<p>Вот новый способ нахождения продавцов с заказчиками, размещенными в их 
городах (вывод для этого запроса&nbsp;показан на Рисунке 13.1):</p>
<pre>            SELECT *
               FROM Salespeople
               WHERE city = ANY
                  (SELECT city
                     FROM Customers);</pre>
<p>Оператор ANY берёт все значения, выведенные подзапросом, (для этого случая 
это все значения city в таблице Заказчиков), и оценивает их как верные, если 
любое (ANY) из них равняется значению города текущей строки внешнего запроса.</p>
<pre>               ===============  SQL Execution Log ============
              | SELECT *                                      |
              | FROM  Salespeople                             |
              | WHERE city = ANY                              |
              | (SELECT  city                                 |
              | FROM Customers);                              |
              | ============================================= |
              |   cnum     cname     city         comm        |
              |  -----    --------   ----       --------      |
              |   1001    Peel       London         0.12      |
              |   1002    Serres     San Jose       0.13      |
              |   1004    Motika     London         0.11      |
                =============================================

		Рисунок 13.1 Использование оператора ANY</pre>
<p>Это означает, что подзапрос должен выбирать значения такого же типа, что и 
те, которые сравниваются в основном предикате. В этом его отличие от EXISTS, 
который просто определяет, производит ли подзапрос результаты или нет, и 
фактически не использует эти результаты.</p>
<h3><a name="13.2">И</a>СПОЛЬЗОВАНИЕ IN ИЛИ EXISTS ВМЕСТО ANY</h3>
<p>Мы можем также использовать оператор IN для создания запроса, аналогичного 
предыдущему:</p>
<pre>             SELECT *
                FROM Salespeople
                WHERE city IN
                    (SELECT city
                         FROM Customers);</pre>
<p>Этот запрос даст вывод, показанный на Рисунке 13.2.</p>
<p>Однако оператор ANY может использовать другие реляционные операторы, помимо 
равно (=), и, таким образом, делать сравнения, которые превосходят возможности 
IN. Например, мы могли бы найти всех продавцов с их заказчиками, которые следуют 
в алфавитном порядке (вывод показан на Рисунке 13.3).</p>
<pre>             SELECT *
                FROM Salespeople
                WHERE sname &lt; ANY
                   (SELECT cname
                       FROM Customers);


               ===============  SQL Execution Log ============
              | SELECT *                                      |
              | FROM  Salespeople                             |
              | WHERE city IN                                 |
              | (SELECT  city                                 |
              | FROM Customers);                              |
              | ============================================= |
              |   cnum     cname     city         comm        |
              |  -----    --------   ----       --------      |
              |   1001    Peel       London         0.12      |
              |   1002    Serres     San Jose       0.13      |
              |   1004    Motika     London         0.11      |
                =============================================

	Рисунок 13.2 Использование IN в качестве альтернативы ANY


               ===============  SQL Execution Log ============
              | SELECT *                                      |
              | FROM  Salespeople                             |
              | WHERE sname &lt; ANY                             |
              | (SELECT  cname                                |
              | FROM Customers);                              |
              | ============================================= |
              |   cnum     cname     city         comm        |
              |  -----    --------   ----       --------      |
              |   1001    Peel       London         0.12      |
              |   1004    Motika     London         0.11      |
              |   1003    Axelrod    New York       0.10      |
                =============================================

	Рисунок 13.3 Использование оператора ANY с операцией &quot;меньше&quot; (&lt;)</pre>
<p>продавцов для их заказчиков, которые упорядочены в алфавитном порядке (вывод 
показан на Рисунке 13.3).</p>
<pre>             SELECT *
                FROM Salespeople
                WHERE sname &lt; ANY
                   (SELECT cname
                       FROM Customers);</pre>
<p>Все строки были выбраны для Serres и Rifkin, потому что нет других 
заказчиков, чьи имена следовали бы за ними в алфавитном порядке. Обратите 
внимание, что это является основным эквивалентом следующему запросу с EXISTS, 
вывод которого показан на Рисунке 13.4:</p>
<pre>             SELECT *
                 FROM Salespeople outer
                 WHERE EXISTS
                     (SELECT *
                          FROM Customers inner
                          WHERE outer.sname &lt; inner.cname);

               ===============  SQL Execution Log ============
              | SELECT *                                      |
              | FROM  Salespeople outer                       |
              | WHERE EXISTS                                  |
              | (SELECT *                                     |
              | FROM Customers inner                          |
              | WHERE outer.sname &lt; inner.cname);             |
              | ============================================= |
              |   cnum     cname     city         comm        |
              |  -----    --------   ----       --------      |
              |   1001    Peel       London         0.12      |
              |   1004    Motika     London         0.11      |
              |   1003    Axelrod    New York       0.10      |
                =============================================

	Рисунок 13.4 Использование EXISTS как альтернативы оператору ANY</pre>
<p>Любой запрос, который может быть сформулирован с ANY (или, как мы увидим, с 
ALL),&nbsp; мог бы быть сформулирован также с EXISTS, хотя обратное будет неверно. 
Строго говоря, вариант с EXISTS не абсолютно идентичен вариантам с ANY или с ALL 
из-за различия в обработке пустых (NULL) значений (что будет обсуждаться позже в 
этой главе). Тем не менее, с технической точки зрения, вы могли бы делать это без ANY и ALL, если проявите находчивость в использовании EXISTS (и IS NULL).</p>
<p>Большинство пользователей, однако, находят ANY и ALL более удобными в 
использовании, чем EXISTS, который требует соотнесённых подзапросов. Кроме того, 
в зависимости от реализации, ANY и ALL могут, по крайней мере в теории, быть 
более эффективными, чем EXISTS. Подзапросы ANY или ALL могут выполняться один 
раз и иметь вывод, используемый, чтобы определять предикат для каждой строки 
основного запроса. EXISTS, с другой стороны, берёт соотнесенный подзапрос, 
который требует, чтобы весь подзапрос повторно выполнялся для каждой строки 
основного запроса. SQL пытается найти наиболее эффективный способ выполнения 
любой команды и может попробовать преобразовать менее эффективную формулу 
запроса в более эффективную (но вы не можете всегда рассчитывать на получение 
самой эффективной формулировки).</p>
<p>Основная причина для формулировки EXISTS как альтернативы ANY и ALL в том, 
что ANY и ALL могут быть несколько неоднозначны из-за способа использования 
этого термина в английском языке, как вы это скоро увидите. С приходом понимания 
различия способов формулирования данного запроса, вы сможете поработать над 
процедурами, которые сейчас кажутся вам трудными или неудобными.</p>
<h3><a name="13.3">К</a>АК ANY МОЖЕТ СТАТЬ НЕОДНОЗНАЧНЫМ?</h3>
<p>Как говорилось выше, ANY не полностью однозначен. Если мы создаём запрос, 
чтобы выбрать заказчиков, которые имеют больший рейтинг, чем любой заказчик в 
Риме, мы можем получить вывод, который несколько отличается от того, что мы 
ожидали (как показано в Рисунке 13.5):</p>
<pre>          SELECT *
              FROM Customers
              WHERE rating &gt; ANY
                  (SELECT rating
                      FROM Customers
                      WHERE city = Rome);</pre>
<p>В английском языке способ, которым мы обычно склонны интерпретировать оценку 
&quot;больше, чем любой (где city = Rome) &quot;, должен вам сообщить, что это значение 
оценки должно быть выше, чем значение оценки в каждом случае, где значение city 
= Rome. Однако это не так в случае с ANY, используемом в SQL. ANY оценивает как 
true, если подзапрос находит любое значение, которое делает условие верным.</p>
<pre>               ===============  SQL Execution Log ============
              |                                               |
              | SELECT *                                      |
              | FROM  Customers                               |
              | WHERE rating &gt; ANY                            |
              | (SELECT rating                                |
              | FROM Customers                                |
              | WHERE city = 'Rome');                         |
              | ============================================= |
              |   cnum     cname     city     rating   snum   |
              |  -----    --------   ----     ------  ------  |
              |   2002    Giovanni   Rome        200    1003  |
              |   2003    Liu        San Jose    200    1002  |
              |   2004    Grass      Berlin      300    1002  |
              |   2008    Cisneros   San Jose    300    1007  |
                =============================================

	Рисунок 13.5 Как операция &quot;больше&quot;(&gt;) интерпретируется ANY</pre>
<p>Если мы оценим ANY способом, использующим грамматику английского языка, то 
только заказчики с оценкой 300 будут превышать Giovanni, который находится в 
Риме и имеет оценку 200. Однако подзапрос ANY также находит Pereira в Риме с 
оценкой 100. Так как все заказчики с оценкой 200 были выше этой, они будут 
выбраны, даже если имелся другой заказчик из Рима (Giovanni), чья оценка не была 
выше (фактически то, что один из выбранных заказчиков также находится в Риме, 
несущественно). Так как подзапрос произвел по крайней мере одно значение, 
которое сделает предикат верным в отношении этих строк, строки были выбраны. 
Чтобы дать другой пример, предположим, что мы должны были выбирать все заказы на 
сумму, которая была больше, чем по крайней мере один из заказов на 6-е октября:</p>
<pre>               SELECT *
                   FROM Orders
                   WHERE amt &gt; ANY
                        (SELECT amt
                             FROM Orders
                             WHERE odate = 10/06/1990);</pre>
<p>Вывод для этого запроса показан на Рисунке 13.6.</p>
<p>Даже если самая высокая сумма приобретений в таблице (9891.88) имелась на 6-е 
октября, предыдущая строка имеет более высокое значение суммы, чем другая строка 
на 6-е октября, которая имела значение суммы = 1309.95. Имея реляционную 
операцию &quot;&gt;=&quot;&nbsp; вместо просто &quot; &gt; &quot;, эта строка будет также выбрана, потому что 
она равна самой себе.</p>
<p>Конечно, вы можете использовать ANY с другой SQL-техникой, например, с 
техникой объединения.</p>
<p>Этот запрос будет находить все заказы со значением суммы 
меньше, чем значение любой суммы для заказчика в San Jose (вывод показан на 
Рисунке 13.7):</p>
<pre>            SELECT *
               FROM Orders
               WHERE amt &lt; ANY
                   (SELECT amt
                        FROM Orders A, Customers b
                        WHERE a.cnum = b.cnum
                            AND b.city = &quot; San Jose');</pre>
<p>Даже если наименьший заказ в таблице был для заказчика из San Jose, то был 
второй наибольший; следовательно, почти все строки будут выбраны. Простой 
запомните, что &lt; ANY это значение, меньшее, чем наибольшее выбранное значение, 
а &gt; ANY - значение, большее, чем наименьшее выбранное значение.</p>
<pre>               ===============  SQL Execution Log ==============
              |                                                 |
              | SELECT *                                        |
              | FROM  Orders                                    |
              | WHERE amt &gt; ANY                                 |
              | (SELECT amt                                     |
              | FROM Orders                                     |
              | WHERE odate = 10/06/1990);                      |
              | =============================================== |
              |   onum       amt      odate      cnum     snum  |
              |  -----    --------  ----------  -----   ------  |
              |   3002     1900.10  10/03/1990   2007     1004  |
              |   3005     5160.45  10/03/1990   2003     1002  |
              |   3009     1713.23  10/04/1990   2002     1003  |
              |   3008     4723.00  10/05/1990   2006     1001  |
              |   3011     9891.88  10/06/1990   2006     1001  |
                ================================================

	Рисунок 13.6 Выбрано значение, большее чем любое (ANY) на 6-е октября

               ===============  SQL Execution Log ==============
              |                                                 |
              | WHERE amt &gt; ANY                                 |
              | (SELECT amt                                     |
              | FROM Orders a, Customers b                      |
              | WHERE a.cnum = b.cnum                           |
              | AND b.city = 'San Jose');                       |
              | =============================================== |
              |   onum       amt      odate      cnum     snum  |
              |  -----    --------  ----------  -----   ------  |
              |   3001       18.69  10/03/1990   2008     1007  |
              |   3003      767.10  10/03/1990   2001     1001  |
              |   3002     1900.10  10/03/1990   2007     1004  |
              |   3006     1098.10  10/03/1990   2008     1007  |
              |   3009     1713.23  10/04/1990   2002     1003  |
              |   3007       75.10  10/04/1990   2004     1002  |
              |   3008     4723.00  10/05/1990   2006     1001  |
              |   3010     1309.88  10/06/1990   2004     1002  |
                ================================================

		 Рисунок 13.7 Использование ANY с объединением</pre>
<p>Фактически вышеуказанные команды весьма похожи на следующие (вывод показан на 
Рисунке 13.8):</p>
<pre>             SELECT *
                 FROM Orders
                 WHERE amt &lt;
                    (SELECT MAX amt
                        FROM Orders A, Customers b
                        WHERE a.cnum = b.cnum
                             AND b.city = &quot; San Jose');


               ===============  SQL Execution Log ==============
              |                                                 |
              | WHERE amt &lt;                                     |
              | (SELECT MAX (amt)                               |
              | FROM Orders a, Customers b                      |
              | WHERE a.cnum = b.cnum                           |
              | AND b.city = 'San Jose');                       |
              | =============================================== |
              |   onum       amt      odate      cnum     snum  |
              |  -----    --------  ----------  -----   ------  |
              |   3002     1900.10  10/03/1990   2007     1004  |
              |   3005     5160.45  10/03/1990   2003     1002  |
              |   3009     1713.23  10/04/1990   2002     1003  |
              |   3008     4723.00  10/05/1990   2006     1001  |
              |   3011     9891.88  10/06/1990   2006     1001  |
                ================================================

	Рисунок 13.8 Использование агрегатной функции вместо ANY</pre>
<h3><a name="13.4">С</a>ПЕЦИАЛЬНЫЙ ОПЕРАТОР ALL</h3>
<p>С помощью ALL, предикат будет верным, если каждое значение, выбранное 
подзапросом, удовлетворяет условию в предикате внешнего запроса. Если мы хотим 
пересмотреть наш предыдущий пример, чтобы вывести только тех заказчиков, чьи 
оценки фактически выше, чем у каждого заказчика в Париже, мы можем ввести 
следующее, чтобы получить вывод, показанный в Рисунке 13.9:</p>
<pre>             SELECT *
                FROM Customers
                WHERE rating &gt; ALL
                    (SELECT rating
                        FROM Customers
                        WHERE city = Rome):


               ===============  SQL Execution Log ============
              |                                               |
              | SELECT *                                      |
              | FROM  Customers                               |
              | WHERE rating &gt; ALL                            |
              | (SELECT rating                                |
              | FROM Customers                                |
              | WHERE city = 'Rome');                         |
              | ============================================= |
              |   cnum     cname     city     rating   snum   |
              |  -----    --------   ----     ------  ------  |
              |   2004    Grass      Berlin      300    1002  |
              |   2008    Cisneros   San Jose    300    1007  |
                ============================================

		Рисунок 13.9 Использование оператора ALL</pre>
<p>Этот оператор проверяет значения рейтинга всех заказчиков в Риме. Затем он 
находит заказчиков с оценкой, большей, чем у любого из заказчиков в Риме. Самая 
высокая оценка в Риме - у Giovanni (200). Следовательно, выбираются только 
значения выше  200.</p>
<p>Как и в случае с ANY, мы можем использовать EXISTS для  создания 
альтернативной формулировки такого же запроса (вывод показан на Рисунке 13.10):</p>
<pre>          SELECT *
             FROM Customers outer
             WHERE NOT EXISTS
                (SELECT *
                   FROM Customers inner
                   WHERE outer.rating &lt; = inner.rating
                   AND inner.city = 'Rome');


               ===============  SQL Execution Log ============
              |                                               |
              | SELECT *                                      |
              | FROM  Customers outer                         |
              | WHERE NOT EXISTS                              |
              | (SELECT *                                     |
              | FROM Customers inner                          |
              | WHERE outer rating = inner.rating             |
              | AND inner.city = 'Rome');                     |
              | ============================================= |
              |   cnum     cname     city     rating   snum   |
              |  -----    --------   ----     ------  ------  |
              |   2004    Grass      Berlin      300    1002  |
              |   2008    Cisneros   San Jose    300    1007  |
                =============================================

	Рисунок 13.10 Использование EXISTS в качестве альтернативы ALL</pre>
<h3><a name="13.5">Р</a>АВЕНСТВА И НЕРАВЕНСТВА</h3>
<p>ALL чаще используется с неравенствами, нежели с равенствами, так как значение 
может быть &quot;равным для всех&quot; результатом подзапроса, только если все результаты 
фактически идентичны. Посмотрите на следующий запрос:</p>
<pre>              SELECT *
                 FROM Customers
                 WHERE rating = ALL
                    (SELECT rating
                        FROM Customers
                        WHERE city = &quot; San Jose');</pre>
<p>Эта команда допустима, но с этими данными мы не получим никакого вывода. 
Только в единственном случае вывод будет выдан этим запросом - если все значения 
оценки в San Jose окажутся идентичными. В этом случае можно сказать следующее:</p>
<pre>              SELECT *
                 FROM Customers
                 WHERE rating =
                      (SELECT DISTINCT rating
                         FROM Customers
                         WHERE city = &quot; San Jose');</pre>
<p>Основное различие в том, что эта последняя команда должна потерпеть неудачу, 
если подзапрос выведет много значений, в то время как вариант с ALL просто не 
даст никакого вывода. В общем, не самая удачная идея - использовать запросы, 
которые работают только в определённых ситуациях, подобно этой. Так как ваша БД 
будет постоянно меняться, это неудачный способ узнать о её содержании. Однако ALL может более эффективно использоваться с неравенствами, то есть с операцией 
&quot;&lt; &gt;&quot;. Но учтите, что сказанное в SQL о значении, которое не равняется всем 
результатам подзапроса, будет отличаться от того же, но сказанного с учётом 
грамматики английского языка. Очевидно, если подзапрос&nbsp; возвращает много 
различных значений, как это обычно бывает, ни одно отдельное значение не может 
быть равно им всем в обычном смысле. В SQL выражение &lt; &gt; ALL в действительности 
означает &quot;не равен любому&quot; результату подзапроса. Другими словами, предикат 
верен, если данное значение не найдено среди результатов подзапроса. 
Следовательно, наш предыдущий пример противоположен по смыслу этому примеру (с 
выводом, показанным на Рисунке 13.11):</p>
<pre>          SELECT *
             FROM Customers
             WHERE rating &lt; &gt; ALL
             (SELECT rating
                  FROM Customers
                  WHERE city = &quot; San Jose');


               ===============  SQL Execution Log ============
              |                                               |
              | SELECT *                                      |
              | FROM  Customers                               |
              | WHERE rating &lt; &gt; ALL                          |
              | (SELECT rating                                |
              | FROM Customers                                |
              | WHERE city = 'San Jose');                     |
              | ============================================= |
              |   cnum     cname     city     rating   snum   |
              |  -----    --------   ----     ------  ------  |
              |   2001    Hoffman    London      100    1001  |
              |   2006    Clemens    London      100    1001  |
              |   2007    Pereira    Rome        100    1004  |
                =============================================

		   Рисунок 13.11 Использование ALL с &lt; &gt;</pre>
<p>Вышеупомянутый подзапрос выбирает все оценки для города San Jose. Он выводит 
набор из двух значений: 200 (для Liu) и 300 (для Cisneros). Затем основной 
запрос выбирает все строки с оценкой, не совпадающей ни с одной из них, другими 
словами - все строки с оценкой 100. Вы можете сформулировать тот же самый запрос 
с помощью операторов NOT IN:</p>
<pre>                 SELECT*
                    FROM Customers
                    WHERE rating NOT IN
                        (SELECT rating
                            FROM Customers
                            WHERE city = &quot; San Jose');</pre>
<p>Вы могли бы также использовать оператор ANY:</p>
<pre>          SELECT *
             FROM Customers
             WHERE NOT rating = ANY
                  (SELECT rating
                       FROM Customers
                       WHERE city = &quot; San Jose');</pre>
<p>Вывод будет одинаков для всех трёх условий.</p>
<h3><a name="13.6">П</a>РАВИЛЬНОЕ ПОНИМАНИЕ ANY И ALL</h3>
<p>В SQL, сказать, что значение больше (или меньше), чем любое (ANY) из набора 
значений - то же самое, что сказать, что оно больше (или меньше), чем любое 
отдельное из этих значений. И наоборот, сказать, что значение не равно всему 
(ALL) набору значений, это то же, что сказать, что нет такого значения в наборе 
которому оно равно.</p>
<h3><a name="13.7">К</a>АК ANY, ALL И EXIST ПОСТУПАЮТ С ОТСУТСТВУЮЩИМИ И НЕИЗВЕСТНЫМИ ДАННЫМИ?</h3>
<p>Как было сказано, имеются некоторые различия между EXISTS и операторами, 
представленными в этой главе, в том, как они обрабатывают оператор NULL. ANY и 
ALL также отличаются друг от друга тем, как они реагируют, если подзапрос не 
произвел никаких значений, чтобы использовать их в сравнении. Эти различия могут 
привести к непредвиденным результатам в ваших запросах, если вы не будете их 
учитывать.</p>
<h3><a name="13.8">К</a>ОГДА ПОДЗАПРОС ВОЗВРАЩАЕТСЯ ПУСТЫМ?</h3>
<p>Одно существенное различие между ALL и ANY - способ действия в ситуации, 
когда подзапрос не возвращает никаких значений. В принципе всякий раз, когда 
допустимый подзапрос не в состоянии сделать вывод, ALL автоматически правилен, а 
ANY автоматически неправилен. Это означает, что следующий запрос</p>
<pre>            SELECT *
               FROM Customers
               WHERE rating &gt; ANY
                  (SELECT rating
                      FROM Customers
                      WHERE city = Boston);</pre>
<p>не произведет никакого вывода, в то время как запрос</p>
<pre>               SELECT
                  FROM Customers
                  WHERE rating &gt; ALL
                     (SELECT rating
                          FROM Customers
                          WHERE city = 'Boston');</pre>
<p>выведет всю таблицу Заказчиков. Когда нет никаких заказчиков в Boston, 
естественно, ни одно из этих сравнений не имеет значения.</p>
<h3><a name="13.9">A</a>NY И ALL ВМЕСТО EXISTS С NULL</h3>
<p>Значения NULL также имеют некоторые проблемы с операторами вроде этих. Когда 
SQL сравнивает два значения в предикате, одно из которых пустое (NULL), то 
результат неизвестен (смотрите <a href="ch5.php">Главу 5</a>). Неизвестный 
предикат подобен неверному и является причиной того, что строка не выбирается, 
но работать он будет иначе в некоторых похожих запросах, в зависимости от того, 
используют они ALL или ANY вместо EXISTS.</p>
<p>Рассмотрим наш предыдущий пример:</p>
<pre>             SELECT *
                FROM Customers
                WHERE rating &gt; ANY
                    (SELECT rating
                        FROM Customers
                        WHERE city = 'Rome');</pre>
<p>и ещё один пример:</p>
<pre>          SELECT *
              FROM Customers outer
              WHERE EXISTS
                 (SELECT *
                     FROM Customers inner
                     WHERE outer.rating &gt; inner.rating
                     AND inner.city = 'Rome');</pre>
<p>В общем, эти два запроса будут вести себя одинаково. Но предположим, что 
появилось пустое (NULL) значение в столбце rating таблицы Заказчиков:</p>
<pre>   CNUM        CNAME         CITY        RATING       SNUM

   2003         Liu          SanJose      NULL        1002</pre>
<p>В варианте с ANY, где оценка Liu выбрана основным запросом, значение NULL 
делает предикат неизвестным, а строка Liu не выбирается для вывода. Однако в 
варианте с NOT EXISTS, когда эта строка выбрана основным запросом, значение NULL 
используется в предикате подзапроса, делая его неизвестным в каждом случае. Это 
означает что подзапрос не будет производить никаких значений и EXISTS будет 
неправилен. Это, естественно, делает оператор NOT EXISTS верным. Следовательно, 
строка Liu будет выбрана для вывода. Это основное расхождение, в отличие от 
других типов предикатов, где значение EXISTS, независимо от того, верно оно или 
нет, всегда неизвестно. Всё это является аргументом в пользу варианта 
формулировки с ANY. Мы не считаем, что значение NULL является выше, чем 
допустимое значение. Более того, результат будет тот же, если мы будем проверять 
для более низкого значения.</p>
<h3><a name="13.10">И</a>СПОЛЬЗОВАНИЕ COUNT ВМЕСТО EXISTS</h3>
<p>Подчеркнём, что все формулировки с ANY и ALL могут быть в точности выполнены 
с EXISTS, в то время как обратное будет неверно. Хотя в этом случае также верно 
и то, что подзапросы EXISTS и NOT EXISTS могут проколоть при выполнении тех же 
самых подзапросов с COUNT(*) в предложении SELECT подзапроса. Если больше чем 
ноль строк в выводе будет подсчитано, это эквивалентно EXISTS; в противном случае 
это работает так же, как NOT EXISTS. Следующее является этому примером (вывод 
показан на Рисунке 13.12): </p>
<pre>              SELECT *
                 FROM Customers outer
                 WHERE NOT EXISTS
                     (SELECT *
                         FROM Customers inner
                         WHERE outer.rating &lt; = inner.rating
                           AND inner.city = 'Rome');


               ===============  SQL Execution Log ============
              |                                               |
              | SELECT *                                      |
              | FROM  Customers outer                         |
              | WHERE NOT EXISTS                              |
              | (SELECT *                                     |
              | FROM Customers inner                          |
              | WHERE outer.rating &lt;= inner.rating            |
              | AND inner.city = 'Rome');                     |
              | ============================================= |
              |   cnum     cname     city     rating   snum   |
              |  -----    --------   ----     ------  ------  |
              |   2004    Grass      Berlin      300    1002  |
              |   2008    Cisneros   San Jose    300    1007  |
                =============================================

	Рисунок 13.12 Использование EXISTS с соотнесённым подзапросом</pre>
<p>Это должно также быть выполнено как</p>
<pre>            SELECT *
               FROM Customers outer
               WHERE 1 &gt;
                   (SELECT COUNT (*)
                        FROM Customers inner
                        WHERE outer.rating &lt; = inner.rating
                           AND inner.city = 'Rome');</pre>
<p>Вывод к этому запросу показан на Рисунке 13.13. Теперь вы начинаете понимать, 
сколько способов имеется в SQL. Если это всё кажется несколько сложным на данном 
этапе, нет причин волноваться. Вы обучаетесь, чтобы использовать ту технику, 
которая больше отвечает вашим требованиям и наиболее понятна для вас. Начиная с 
этого места, мы хотим показать вам большое количество возможностей, чтобы вы 
могли найти ваш собственный стиль.</p>
<pre>               ===============  SQL Execution Log ============
              |                                               |
              | SELECT *                                      |
              | FROM  Customers outer                         |
              | WHERE 1 &gt;                                     |
              | (SELECT COUNT (*)                             |
              | FROM Customers inner                          |
              | WHERE outer.rating &lt;= inner.rating            |
              | AND inner.city = 'Rome');                     |
              | ============================================= |
              |   cnum     cname     city     rating   snum   |
              |  -----    --------   ----     ------  ------  |
              |   2004    Grass      Berlin      300    1002  |
              |   2008    Cisneros   San Jose    300    1007  |
                =============================================

		Рисунок 13.13 Использование COUNT вместо EXISTS</pre>
<h3><a name="13.11">Р</a>ЕЗЮМЕ</h3>
<p>Итак, вы узнали много нового в этой главе. Подзапросы - непростая тема, и мы 
потратили много времени, чтобы показать их варианты и неоднозначность. То, чему 
вы теперь научились, вещи достаточно глубокие. Вы знаете несколько технических 
решений одной проблемы, и поэтому  можете выбрать то, которое больше подходит 
для ваших целей. Кроме того, вы поняли, как различные формулировки будут 
обрабатывать пустые значения (NULL) и ошибки.</p>
<p>Теперь, когда вы полностью изучили запросы - наиболее важный, и, вероятно, 
наиболее сложный аспект SQL - другой материал будет относительно прост для 
понимания.</p>
<p>У нас есть ещё одна глава о запросах, которая покажет вам, как объединить 
вывод любого количества запросов в единое тело с помощью формирования 
объединения нескольких запросов, используя оператор UNION.</p>
<h3><a name="13.12">Р</a>АБОТА СО SQL</h3>
<pre>1. Напишите запрос, который выбирал бы всех заказчиков, чьи оценки
   равны или больше, чем любая (ANY) оценка заказчика Serres.

2. Что будет выведено вышеупомянутой командой?

3. Напишите запрос, использующий ANY или ALL, который находил бы всех
   продавцов, которые не имеют никаких заказчиков, живущих в их городе.

4. Напишите запрос, который выбирал бы все заказы с суммой, больше, чем 
   любая (в обычном смысле) для заказчиков в Лондоне.

5. Напишите предыдущий запрос с использованием MAX.

(См. ответы в <a href="a.php">Приложении A</a>.)</pre></body></html>
<? include 'foot.php' ?>