<?
include_once '../../sys/inc/start.php';
include_once '../../sys/inc/compress.php';
include_once '../../sys/inc/sess.php';
include_once '../../sys/inc/home.php';
include_once '../../sys/inc/settings.php';
include_once '../../sys/inc/db_connect.php';
include_once '../../sys/inc/ipua.php';
include_once '../../sys/inc/fnc.php';
include_once '../../sys/inc/user.php';
$set['title']='Учебник JavaScript';
include_once '../../sys/inc/thead.php';
title();
err();
//aut();
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<phpl<TITLE>Выражения и Операции</TITLE>
<BODY>
<h5><a href="contents.php">Оглавление</a> | <a href="ident.php">Назад</a>
| <a href="regexp.php">Вперёд</a> | <a href="bklast.php">Индекс</a></h5><HR>
<h1>Глава 3<BR><a name="1008302"></a>Выражения и Операции</h1><p><A NAME="1008304"></a>
В этой главе рассматриваются выражения и операции JavaScript, в том числе - 
операции присвоения, сравнения, арифметические,  битовые, логические, строковые и специальные.</p>
<p><A NAME="1010253"></a>В главе имеются следующие разделы:</p><ul><LI><A NAME="1010258"></a>
<a href="#1010338">Выражения</a></LI><LI><A NAME="1010265"></a><a href="#1008323">Операции</a></LI></ul>
<H2><A NAME="Expressions"><a name="1010338"></a>Выражения</H2><hr><p><A NAME="1008309"></a>
<i>Выражение\expression</i> это правильный набор литералов, переменных, операций 
и выражений, который вычисляется в единственное значение; значение может быть числом, строкой или логическим значением.</p>
<p><A NAME="1008310"></a>Концептуально имеются выражения двух типов: присваивающие значение переменной, и 
те, которые просто имеют значение. Например, выражение <CODE>x&nbsp;=&nbsp;7</CODE> 
присваивает переменной x значение 7. Это выражение вычисляется в 7. Такие 
выражения используют <I>операции присвоения.<br>
</I>Выражение <CODE>3&nbsp;+&nbsp;4</CODE> вычисляется в 7; оно выполняет 
операцию присвоения значения. Операции в таких выражениях называются просто <i>операции</i>.</p>
<p><A NAME="1008314"></a>В JavaScript имеются следующие типы выражений:</p>
<ul><LI><A NAME="1008315"></a>Арифметические: вычисляются в число, например, 3.14159</LI><LI><A NAME="1008316"></a>
Строковые: вычисляются в строку символов, например, "Fred" или "234"</LI><LI><A NAME="1008317"></a>
Логические: вычисляются в true или false</LI></ul><H2><A NAME="Operators"><a name="1008323"></a>Операции</H2><hr>
<p><A NAME="1010776"></a>В этом разделе рассматриваются операции и приоритет выполнения. В JavaScript имеются следующие типы операций:</p>
<ul><LI><A NAME="1011543"></a><a href="#1008336">Операции присвоения</a></LI><LI><A NAME="1011550"></a>
<a href="#1010037">Операции сравнения</a></LI><LI><A NAME="1011556"></a><a href="#1008458">Арифметические</a></LI><LI><A NAME="1011557"></a>
<a href="#1008505">Битовые</a></LI><LI><A NAME="1011558"></a><a href="#1008622">Логические</a></LI><LI><A NAME="1011598"></a>  <a href="#1008684">Строковые</a></LI><LI><A NAME="1011599"></a>
<a href="#1008688">Специальные</a></LI></ul><p><A NAME="1008325"></a>В JavaScript есть как <i>бинарные</i>, так и <i>унарные</i> операции. Бинарная 
операция работает с двумя операндами, один - до знака операции, другой - после:</p>
<PRE><A NAME="1008326"></a><I>операнд1</I> <i>операция</i> <i>операнд2</i></PRE><p><A NAME="1008327"></a>
Например, <CODE>3+4</CODE> или <CODE>x*y</CODE>.</p><p><A NAME="1008328"></a>
Для унарной операции нужен один операнд, до или после знака операции:</p>
<PRE><A NAME="1008329"></a><i>операция</i> <i>операнд</i></PRE><p><A NAME="1008330"></a>или</p>
<PRE><A NAME="1008331"></a>операнд операция</PRE><p><A NAME="1008332"></a>Например, <CODE>x++</CODE> или <CODE>++x</CODE>.</p>
<p><A NAME="1008333"></a>Кроме того, в JavaScript имеется тернарная  условная операция. 
Тернарная операция требует трёх операндов.</p><H3><A NAME="Head2;"></a><A NAME="1008336"></a>Операции 
присвоения</H3>
<hr><p><A NAME="1008337"></a>Операция присвоения присваивает левому операнду значение правого операнда. 
Базовой операцией присвоения является &quot;равно&quot; (=), которая присваивает левому 
операнду значение правого операнда. То есть, x = y присваивает значение у переменной х.</p><p><A NAME="1009977"></a>
Другие операции присвоения являются аббревиатурами стандартных операций, как видно из таблицы.</p><A NAME="1010046"></a>
<h6><A NAME="1009984"></a>Таблица 3.1 Операции присвоения</h6><TABLE BORDER="2" CELLPADDING=5>
<TR><TH><A NAME="1009988"></a>Аббревиатура<TH><A NAME="1009990"></a>
Значение<TR><TD><PRE><A NAME="1011831"></a>x += y</PRE><TD><PRE><A NAME="1009994"></a>x = x + y</PRE>
<TR><TD><PRE><A NAME="1011834"></a>x -= y</PRE><TD><PRE><A NAME="1009998"></a>x = x - y</PRE>
<TR><TD><PRE><A NAME="1011837"></a>x *= y</PRE><TD><PRE><A NAME="1010002"></a>x = x * y</PRE>
<TR><TD><PRE><A NAME="1011840"></a>x /= y</PRE><TD><PRE><A NAME="1010006"></a>x = x / y</PRE>
<TR><TD><PRE><A NAME="1011843"></a>x %= y</PRE><TD><PRE><A NAME="1010010"></a>x = x % y</PRE>
<TR><TD><PRE><A NAME="1011846"></a>x &lt;&lt;= y</PRE><TD><PRE><A NAME="1010014"></a>x = x &lt;&lt; y</PRE>
<TR><TD><PRE><A NAME="1011849"></a>x &gt;&gt;= y</PRE><TD><PRE><A NAME="1010018"></a>x = x &gt;&gt; y</PRE>
<TR><TD><PRE><A NAME="1011852"></a>x &gt;&gt;&gt;= y</PRE><TD><PRE><A NAME="1010022"></a>x = x &gt;&gt;&gt; y</PRE>
<TR><TD><PRE><A NAME="1011855"></a>x &amp;= y</PRE><TD><PRE><A NAME="1010026"></a>x = x &amp; y</PRE>
<TR><TD><PRE><A NAME="1011858"></a>x ^= y</PRE><TD><PRE><A NAME="1010030"></a>x = x ^ y</PRE>
<TR><TD><PRE><A NAME="1011861"></a>x |= y</PRE><TD><PRE><A NAME="1010034"></a>x = x | y</PRE></TABLE>
<H3><A NAME="Head2;"></a><A NAME="1010037"></a>Операции сравнения</H3><hr><p><A NAME="1008399"></a>
Операция сравнения сравнивает операнды и возвращает значение, основанное на true/верности 
сравнения. Операнды могут быть числами или строками. Строки сравниваются на 
основе стандартного лексикографического (словарного) порядка с использованием Unicode-значений. 
В таблице даны операции сравнения.</p><A NAME="1010078"></a>
<h6 align="center" style="text-align: center"><A NAME="1008406"></a>Таблица 3.2 Операции сравнения</h6>
<TABLE BORDER="2" CELLPADDING=5><TR><TH><A NAME="1008412"></a>Операция<TH><A NAME="1008414"></a>
Описание<TH><A NAME="1008419"></a>
Примеры, возвращающие true<A HREF="#1008418"><SUP>1</a></SUP><TR><TD><P><A NAME="1011887"></a>
Равно (<CODE>==</CODE>)</P><TD><P><A NAME="1009671"></a>
Возвращает true, если операнды равны. Если два операнда имеют разные типы, JavaScript 
пытается конвертировать операнды в значения, подходящие для сравнения.</P><TD><PRE><A NAME="1009673"></a>3 == var1<br>"3" == var1<br>3 == '3'</PRE>
<TR><TD><P><A NAME="1011890"></a>Не равно (<CODE>!=</CODE>)</P><TD><P><A NAME="1009677"></a>
Возвращает true, если операнды не равны. Если два операнда имеют разные 
типы, JavaScript пытается конвертировать операнды в значения, подходящие для 
сравнения.</P><TD><PRE><A NAME="1009679"></a>var1 != 4<br>var2 != "3"</PRE><TR><TD><P><A NAME="1011893"></a>
Строго равно (<CODE>===</CODE>)</P><TD><P><A NAME="1009683"></a>
Возвращает true, если операнды равны и одного типа.</P><TD><PRE><A NAME="1009685"></a>3 === var1</PRE>
<TR><TD><P><A NAME="1011896"></a>Строго не равно (<CODE>!==</CODE>)</P><TD><P><A NAME="1009689"></a>
Возвращает true, если операнды не равны и/или не одного типа.</P><TD><PRE><A NAME="1009691"></a>var1 !== "3"<br>3 !== '3'</PRE>
<TR><TD><P><A NAME="1011899"></a>Больше (<CODE>&gt;</CODE>)</P><TD><P><A NAME="1009695"></a>
Возвращает true, если левый операнд больше правого операнда.</P><TD><PRE><A NAME="1009697"></a>var2 &gt; var1</PRE>
<TR><TD><P><A NAME="1011901"></a>Больше или равно (<CODE>&gt;=</CODE>)</P><TD><P><A NAME="1009701"></a>
Возвращает true, если левый операнд больше правого операнда или равен ему.</P><TD><PRE><A NAME="1009703"></a>var2 &gt;= var1<br>var1 &gt;= 3</PRE>
<TR><TD><P><A NAME="1011905"></a>Меньше (<CODE>&lt;</CODE>)</P><TD><P><A NAME="1009707"></a>
Возвращает true, если левый операнд меньше правого операнда.</P><TD><PRE><A NAME="1009709"></a>var1 &lt; var2</PRE>
<TR><TD><P><A NAME="1011908"></a>Меньше или равно (<CODE>&lt;=</CODE>)</P><TD><P><A NAME="1009713"></a>
Возвращает true, если левый операнд меньше правого операнда или равен ему.</P><TD><PRE><A NAME="1009715"></a>var1 &lt;= var2<br>var2 &lt;= 5</PRE>
</TABLE><TABLE><TR><TD><p><SUP>1</SUP><A NAME="1008418"></a>В этих примерах принимается, что переменной <CODE>var1</CODE> присвоено 
значение 3, а переменной <CODE>var2</CODE> присвоено значение 4.</p></TABLE><H3><A NAME="Head2;"></a>
<A NAME="1008458"></a>Арифметические операции</H3><hr><p><A NAME="1008459"></a>
Арифметические операции принимают в качестве операндов числовые значения (литералы 
или переменные) и возвращают единственное значение-результат. Стандартными 
арифметическими операциями являются операции сложения (+), вычитания (-), 
умножения (*) и деления (/). Эти операции работают так же, как и в большинстве 
других языков программирования, только операция / в JavaScript возвращает 
частное с плавающей точкой, а не округлённое частное, как в C или Java. Например:</p>
<PRE><A NAME="1012547"></a>1/2 //возвращает 0.5 в JavaScript<br>1/2 //возвращает 0 в Java</PRE>
<p><A NAME="1008502"></a>Кроме того, JavaScript предоставляет арифметические операции, перечисленные в таблице.</p>
<A NAME="1010137"></a><h6 align="center" style="text-align: center"><A NAME="1008466"></a>
Таблица 3.3 Арифметические операции</h6><TABLE BORDER="2" CELLPADDING=5><TR><TH><A NAME="1008472"></a>
Операция<TH><A NAME="1008474"></a>Описание<TH><A NAME="1008476"></a>Пример<TR><TD><P><A NAME="1008478"></a>
<CODE>%<br></CODE>(Целочисленный остаток)</P><TD><P><A NAME="1008480"></a>
Бинарная операция. Возвращает целочисленный остаток от деления двух операндов.</P><TD><P><A NAME="1008482"></a>
2 % 5 возвращает 2.</P><TR><TD><P><A NAME="1008484"></a><CODE>++</CODE> <br>(Инкремент)</P><TD><P><A NAME="1008486"></a>
Унарная операция. Прибавляет 1 к операнду. Если используется как префикс (<CODE>++x</CODE>), 
возвращает значение операнда после прибавления 1; если используется как 
постфикс (<CODE>x++</CODE>), возвращает значение операнда до прибавления 1.</P><TD><P><A NAME="1008488"></a>
Если <CODE>x</CODE> равен 3, то <CODE>++x</CODE> устанавливает 4 в <CODE>x</CODE> 
и возвращает 4, а <CODE>x++</CODE> устанавливает 4 в <CODE>x</CODE> и возвращает 3.</P><TR><TD><P><A NAME="1008490"></a>
<CODE>--</CODE> <br>(Декремент)</P><TD><P><A NAME="1008492"></a>
Унарная операция. Вычитает 1 из операнда. Возвращаемые значения аналогичны 
оператору инкремента.</P><TD><P><A NAME="1008494"></a>
Если <CODE>x</CODE> равен 3, то <CODE>--x</CODE> устанавливает 2 в <CODE>x</CODE> 
и возвращает 2, а <CODE>x++</CODE> устанавливает 2 в <CODE>x</CODE> и возвращает 3.</P><TR><TD><P><A NAME="1008496"></a>
<CODE>-</CODE> <br>(Унарное отрицание)</P><TD><P><A NAME="1008498"></a>
Унарная операция. Возвращает отрицание операнда.</P><TD><P><A NAME="1008500"></a>
Если <CODE>x</CODE> равен 3, то <CODE>-x</CODE> возвращает -3.</P></TABLE><H3><A NAME="Head2;"></a>
<A NAME="1008505"></a>Битовые операции</H3><hr><p><A NAME="1008506"></a>Битовые операции рассматривают свои операнды как 32-битные целые значения (последовательность 
0 и 1), а не как 10-ричные, 16-ричные или 8-ричные числа. Например, десятеричное 
9 имеет бинарное представление 1001. Битовые операции выполняются над такими 
двоичными представлениями, но возвращают стандартные числовые значения JavaScript.</p>
<p><A NAME="1008566"></a>В таблице приведены  битовые операции JavaScript.</p><A NAME="1010164"></a>
<h6 align="center" style="text-align: center"><A NAME="1008509"></a>Таблица 3.4 
Битовые операции</h6>
<TABLE BORDER="2" CELLPADDING=5>
<TR><TH><A NAME="1008515"></a>Операция<TH><A NAME="1008517"></a>
Использование<TH><A NAME="1008519"></a>Описание<TR><TD><P><A NAME="1011933"></a>
И</P><TD><PRE><A NAME="1011953"></a><I>a</I> &amp; <I>b</I></PRE><TD><P><A NAME="1008526"></a>
Возвращает 1 в позиции каждого бита, где соответствующий бит обоих операндов равен 1.</P>
<TR><TD><P><A NAME="1011936"></a>
ИЛИ</P><TD><PRE><A NAME="1011955"></a><I>a</I> | <I>b</I></PRE><TD><P><A NAME="1008533"></a>
Возвращает 1 в позиции каждого бита, где соответствующий бит одного или обоих операндов равен 1.</P>
<TR><TD><P><A NAME="1011939"></a>
Исключающее ИЛИ/XOR</P><TD><PRE><A NAME="1011957"></a><I>a</I> ^ <I>b</I></PRE><TD><P><A NAME="1012591"></a>
Возвращает 1 в позиции каждого бита, где соответствующий бит одного, но не обоих, операндов равен 1.</P>
<TR><TD><P><A NAME="1011942"></a>НЕ</P><TD><PRE><A NAME="1011959"></a>~ <I>a</I></PRE><TD><P><A NAME="1008547"></a>
Инвертирует биты операнда.</P><TR><TD><P><A NAME="1011945"></a>
Сдвиг влево</P><TD><PRE><A NAME="1011961"></a><I>a</I> &lt;&lt; <I>b</I></PRE><TD><P><A NAME="1008553"></a>
Сдвигает операнд <CODE>a</CODE> в бинарном представлении на <CODE>b</CODE> битов влево, заполняя справа нулями .</P>
<TR><TD><P><A NAME="1011947"></a>
Сдвиг вправо с сохранением знака</P><TD><PRE><A NAME="1011963"></a><I>a</I> &gt;&gt; <I>b</I></PRE><TD><P><A NAME="1008559"></a>
Сдвигает операнд <CODE>a</CODE> в бинарном представлении на <CODE>b</CODE> битов вправо, отбрасывая смещённые биты.</P>
<TR><TD><P><A NAME="1011951"></a>
Сдвиг вправо с заполнением нулями</P><TD><PRE><A NAME="1011965"></a><I>a</I> &gt;&gt;&gt; <I>b</I></PRE><TD><P><A NAME="1008565"></a>
Сдвигает операнд <CODE>a</CODE> в бинарном представлении на <CODE>b</CODE> 
битов вправо, отбрасывая смещённые биты и заполняя слева нулями.</P></TABLE><H4><A NAME="Head3;"></a>
<A NAME="1008568"></a>Битовые логические операции</H4><hr><p><A NAME="1008569"></a>Концептуально  битовые логические операции работают так:</p>
<ul><LI><A NAME="1008570"></a>Операнды конвертируются в 32-битные целые и выражаются серией битов (нулей и 
единиц).</LI><LI><A NAME="1008571"></a>Каждый бит первого операнда образует пару с соответствующим битом второго 
операнда: первый бит с первым, второй со вторым и т.д.</LI><LI><A NAME="1008572"></a>
Операция применяется к каждой паре битов, и результат конструируется побитно.</LI></ul><p><A NAME="1008573"></a>
Например, цифра 9 имеет двоичное/бинарное представление 1001, а цифра 15 - 1111. 
Поэтому результаты применения  битовых операций к этим значениям будут такими:</p>
<ul><LI><A NAME="1008574"></a>
15 &amp; 9 даст 9 (1111 &amp; 1001 = 1001)</LI><LI><A NAME="1008575"></a>
15 | 9 даст 15 (1111 | 1001 = 1111)</LI><LI><A NAME="1008576"></a>
15 ^ 9 даст 6 (1111 ^ 1001 = 0110)</LI></ul><H4><A NAME="Head3;"></a><A NAME="1008578"></a>
Битовые операции сдвига</H4>
<hr><p><A NAME="1008579"></a>Операции  битового сдвига принимают два операнда: первый это сдвигаемое число, 
а второй специфицирует количество битовых позиций, на которое сдвигается первый 
операнд. Направление сдвига контролируется самой операцией.</p><p><A NAME="1008580"></a>
Операции сдвига конвертируют свои операнды в 32-битные целые числа и возвращают 
результат того же типа, что и у левого операнда.</p><p><A NAME="1008619"></a>Операции сдвига перечислены в следующей таблице.</p>
<A NAME="1010171"></a>
<h6 align="left" style="text-align: center"><A NAME="1008587"></a>
Таблица 3.5 Операции  битового сдвига</h6><TABLE BORDER="2" CELLPADDING=5><TR><TH><A NAME="1008593"></a>
Операция<TH><A NAME="1008595"></a>Описание<TH><A NAME="1008597"></a>Пример<TR><TD><P><A NAME="1008600"></a>
<CODE>&lt;&lt;</CODE><br>(Сдвиг влево)</P><TD><P><A NAME="1008602"></a>
Эта операция сдвигает влево первый операнд на специфицированное вторым 
операндом количество битов. Излишние биты, сдвинутые влево, отбрасываются. 
Справа идёт заполнение нулями.</P><TD><P><A NAME="1008604"></a>
<CODE>9&lt;&lt;2</CODE> даёт 36, поскольку 1001, сдвинутое на 2 бита влево, становится 100100, что равно 36.</P>
<TR><TD><P><A NAME="1008606"></a><CODE>&gt;&gt;</CODE><br>(Сдвиг вправо с сохранением знака)</P><TD><P><A NAME="1008609"></a>
Эта операция сдвигает вправо первый операнд на специфицированное вторым 
операндом количество битов. Излишние биты, сдвинутые вправо, отбрасываются. 
Копии левых битов вставляются слева.</P><TD><P><A NAME="1008611"></a>
9&gt;&gt;2 даёт 2, поскольку 1001, сдвинутое на 2 бита вправо, становится 10, 
что равно 2. Аналогично -9&gt;&gt;2 даёт -3, поскольку знак сохраняется.</P><TR><TD><P><A NAME="1008613"></a>
<CODE>&gt;&gt;&gt;</CODE><br>(Сдвиг вправо с заполнением нулями)</P><TD><P><A NAME="1008615"></a>
Эта операция сдвигает вправо первый операнд на специфицированное вторым 
операндом количество битов. Излишние биты, сдвинутые вправо, отбрасываются. 
Слева идёт заполнение нулями.</P><TD><P><A NAME="1008617"></a>
19&gt;&gt;&gt;2 даёт 4, поскольку 10011, сдвинутое на 2 бита вправо, становится 100, 
то есть 4. Для неотрицательных чисел сдвиг вправо с заполнением нулями и сдвиг 
вправо с сохранением знака дают одинаковые результаты.</P></TABLE><H3><A NAME="Head2;"></a>
<A NAME="1008622"></a>Логические операции</H3><hr><p><A NAME="1008623"></a>
Логические операции обычно используются с Булевыми (логическими) значения; эти 
операции возвращают Булево значение. Однако операции &amp;&amp; и || в 
действительности возвращают значение одного из специфицированных операндов, 
поэтому, если эти операции используются с не-Булевыми значениями, они могут 
вернуть не-Булево значение. Логические операции перечислены в таблице.</p>
<A NAME="1010198"></a><h6 align="left" style="text-align: center"><A NAME="1012818"></a>
Таблица 3.6 Логические операции</h6><TABLE BORDER="2" CELLPADDING=5><TR><TH><A NAME="1012824"></a>
Операция<TH><A NAME="1012826"></a>Использование<TH><B><A NAME="1012828"></a>
Описание<TR><TD><P><A NAME="1012831"></a>
&amp;&amp;</P><TD><PRE><A NAME="1012833"></a>expr1 &amp;&amp; expr2</PRE><TD><P><A NAME="1012877"></a>
(Логическое И) Возвращает <CODE>expr1</CODE>, если может быть конвертировано в false; 
иначе возвращает <CODE>expr2</CODE>. Таким образом, при использовании с Булевыми значениями &amp;&amp; 
возвращает true, если оба операнда true; иначе, возвращает false.</P>
<TR><TD><P><A NAME="1012840"></a>||</P><TD><PRE><A NAME="1012842"></a>expr1 || expr2</PRE><TD><P><A NAME="1012879"></a>
(Логическое ИЛИ) Возвращает <CODE>expr1</CODE>, если может быть конвертировано в false; 
иначе возвращает <CODE>expr2</CODE>. Таким образом, при использовании с Булевыми значениями || 
возвращает true, если любой из операндов true; если оба false, возвращает false.</P><TR><TD><P><A NAME="1012849"></a>
! </P><TD><PRE><A NAME="1012851"></a>!expr</PRE><TD><P><A NAME="1012881"></a>
(Логическое НЕ) Возвращает false, если её единственный операнд может быть конвертирован в true; иначе возвращает true.</P></TABLE>
<p><A NAME="1012872"></a>Примерами выражений, которые могут быть конвертированы в false, являются 
выражения, вычисляемые в null, 0, пустую строку (&quot;&quot;) или undefined.</p><p><A NAME="1012887"></a>
А это примеры операции &amp;&amp; (logical AND).</p>
<PRE><A NAME="1012888"></a>a1=true &amp;&amp; true &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;// t &amp;&amp; t возвращает true<br>a2=true &amp;&amp; false &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;// t &amp;&amp; f возвращает false<br>a3=false &amp;&amp; true &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;// f &amp;&amp; t возвращает false<br>a4=false &amp;&amp; (3 == 4) &nbsp;// f &amp;&amp; f возвращает false<br>a5="Cat" &amp;&amp; "Dog" &nbsp;&nbsp;&nbsp;&nbsp;// t &amp;&amp; t возвращает Dog<br>a6=false &amp;&amp; "Cat" &nbsp;&nbsp;&nbsp;&nbsp;// f &amp;&amp; t возвращает false<br>a7="Cat" &amp;&amp; false &nbsp;&nbsp;&nbsp;&nbsp;// t &amp;&amp; f возвращает false</PRE>
<p><A NAME="1012889"></a>Следующий код это примеры операции || (logical OR).</p>
<PRE><A NAME="1012890"></a>o1=true || true &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;// t || t возвращает true<br>o2=false || true &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;// f || t возвращает true<br>o3=true || false &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;// t || f возвращает true<br>o4=false || (3 == 4) &nbsp;// f || f возвращает false<br>o5="Cat" || "Dog" &nbsp;&nbsp;&nbsp;&nbsp;// t || t возвращает Cat<br>o6=false || "Cat" &nbsp;&nbsp;&nbsp;&nbsp;// f || t возвращает Cat<br>o7="Cat" || false &nbsp;&nbsp;&nbsp;&nbsp;// t || f возвращает Cat</PRE>
<p><A NAME="1012891"></a>Следующий код это примеры операции ! (logical NOT).</p>
<PRE><A NAME="1012892"></a>n1=!true &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;// !t возвращает false<br>n2=!false &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;// !f возвращает true<br>n3=!"Cat" &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;// !t возвращает false</PRE>
<H4><A NAME="Head3;"></a><A NAME="1008676"></a>Сокращённый цикл вычисления</H4><hr><p><A NAME="1008677"></a>
Поскольку логические выражения вычисляются слева направо, они проверяются на 
возможность "сокращённого/short-circuit" вычисления по следующим правилам:</p>
<ul><LI><A NAME="1008678"></a><CODE>false</CODE> &amp;&amp; <I>anything</I> ускоренно вычисляется в false.</LI><LI><A NAME="1008679"></a>
<CODE>true</CODE> || <I>anything</I> ускоренно вычисляется в true.</LI></ul><p><A NAME="1008680"></a>
Правила логики гарантируют, что эти вычисления всегда корректны. Обратите 
внимание, что часть <I>anything</I> вышеприведённых выражений не вычисляется, 
поэтому выполнение полного вычисления не даст никакого эффекта.</p><H3><A NAME="Head2;"></a>
<A NAME="1008684"></a>Строковые операции</H3><hr><p><A NAME="1008685"></a>
Помимо операций сравнения, которые могут использоваться со строковыми значениями, 
операция конкатенации (+) объединяет два строковых значения, возвращая строку, 
которая является результатом объединения двух&nbsp; строк-операндов. Например, <CODE>"my&nbsp;"&nbsp;+&nbsp;"string"</CODE> 
возвращает строку <CODE>"my&nbsp;string"</CODE>.</p><p><A NAME="1008686"></a>
Операция-аббревиатура присвоения += также может использоваться для конкатенации 
строк. Например, если переменная <CODE>mystring</CODE> имеет значение "alpha&quot;, 
то выражение <CODE>mystring&nbsp;+=&nbsp;"bet"</CODE> вычисляется в "alphabet" и 
это значение присваивается переменной <CODE>mystring</CODE>.</p><H3><A NAME="Head2;"></a>
<A NAME="1008688"></a>Специальные операции</H3><hr><p><A NAME="1012006"></a>В
JavaScript имеются следующие специальные операции:</p><ul><LI><A NAME="1012007"></a>
<a href="#1008690">условная операция</a></LI><LI><A NAME="1012015"></a><a href="#1008698">операция , (запятая)</a></LI><LI><A NAME="1012016"></a>
<A HREF="#1008702">delete</a></LI><LI><A NAME="1012155"></a><A HREF="#1010464">new</a></LI><LI><A NAME="1012034"></a>
<A HREF="#1010302">this</a></LI><LI><A NAME="1012051"></a><A HREF="#1008719">typeof</a></LI><LI><A NAME="1012052"></a>
<A HREF="#1012081">void</a></LI></ul><H4><A NAME="Head3;"></a><A NAME="1008690"></a>условная операция</H4>
<hr><p><A NAME="1008691"></a>Условная операция это единственная операция JavaScript, принимающая три операнда. 
Эта операция может иметь одно из двух значений на основе выполнения условия. Синтаксис таков:</p>
<PRE><A NAME="1008693"></a><I>condition</I> ? <I>val1</I> : <I>val2</I></PRE>
<p><A NAME="1008694"></a>Если <CODE>condition</CODE> true, операция выдаёт значение <CODE>val1</CODE>. 
Иначе она выдаёт значение <CODE>val2</CODE>. Вы можете использовать условную 
операцию там же, где используется стандартный оператор <span lang="en-us">if</span>.</p><p><A NAME="1008695"></a>
Например,</p><PRE><A NAME="1008696"></a>status = (age &gt;= 18) ? "adult" : "minor"</PRE><p><A NAME="1008697"></a>
Этот оператор присваивает значение "adult" переменной <CODE>status</CODE>, если <CODE>age</CODE> 
имеет значение 18 или более. Иначе переменной <CODE>status</CODE> присваивается значение "minor".</p>
<H4><A NAME="Head3;"></a><A NAME="1008698"></a>операция , (запятая)</H4><hr><p><A NAME="1008699"></a>
Операция &quot;запятая&quot; (<CODE>,</CODE>) просто вычисляет два операнда и 
возвращает значение второго операнда. Эта операция используется в основном в 
цикле <CODE>for</CODE>, позволяя обновлять несколько переменных при каждом проходе цикла.</p><p><A NAME="1008700"></a>
Например, если <CODE>a</CODE> это 2-мерный массив из 10 элементов по измерению, 
следующий код использует операцию ,&nbsp; для инкремента сразу двух переменных. Код 
печатает значения элементов по диагонали массива:</p>
<PRE><A NAME="1008701"></a>for (var i=0, j=9; i &lt;= 9; i++, j--)<br>&nbsp;&nbsp;&nbsp;document.writeln("a["+i+","+j+"]= " + a[i,j])</PRE>
<H4><A NAME="Head3;"></a><A NAME="1008702"></a>delete</H4><hr><p><A NAME="1008703"></a>Операция delete удаляет объект, свойство объекта или элемент по 
специфицированному индексу массива. Синтаксис таков:</p>
<PRE><A NAME="1012179"></a>delete <I>objectName<br></I>delete <I>objectName</I>.<I>property<br></I>delete <I>objectName</I>[<I>index</I>]<br>delete <I>property</I> // допустимо только в операторе with</PRE>
<p><A NAME="1010461"></a>где <CODE>objectName</CODE> это имя объекта, <CODE>property</CODE> это 
существующее свойство, а <CODE>index</CODE> это целое число - местонахождение элемента в массиве.</p>
<p><A NAME="1012192"></a>Четвёртая форма верна только в операторе <CODE>with</CODE> и удаляет свойство объекта.</p>
<p><A NAME="1012193"></a>Вы можете использовать операцию <CODE>delete</CODE> для удаления переменных, 
объявленных неявно, но не для удаления переменных, объявленных оператором <CODE>var</CODE>.</p><p><A NAME="1012221"></a>
Если операция <CODE>delete</CODE> прошла успешно, она устанавливает свойство или 
элемент в значение <CODE>undefined.  </CODE>Операция <CODE>delete</CODE> 
возвращает true, если операция возможна; она возвращает false, если операция невозможна.</p>
<PRE><A NAME="1012222"></a>x=42<br>var y= 43<br>myobj=new Number()<br>myobj.h=4 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;// создаёт свойство h<br>delete x &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;// возвращает true (можно удалить, если переменная х объявлена неявно)<br>delete y &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;// возвращает false (нельзя удалять, если объявлена с использованием var)<br>delete Math.PI // возвращает false (нельзя удалять предопределенные свойства)<br>delete myobj.h // возвращает true (можно удалять свойства, определённые пользователем)<br>delete myobj &nbsp;&nbsp;// возвращает true (можно удалять объект, определённый пользователем)</PRE>
<h6><A NAME="Head4;"></a><A NAME="1012230"></a>Удаление элементов массива</h6><p><A NAME="1012231"></a>
Если Вы удаляете элемент массива, размер массива не изменяется. Например, если Вы 
удаляете a[3], то a[4] продолжает оставаться a[4], а a[3] имеет значение undefined.</p>
<p><A NAME="1012232"></a>Если операция <CODE>delete</CODE> удаляет элемент массива, этот элемент больше 
не присутствует в массиве. В следующем примере trees[3] удаляется операцией <CODE>delete</CODE>.</p>
<PRE><A NAME="1012233"></a>trees=new Array("redwood","bay","cedar","oak","maple")<br>delete trees[3]<br>if (3 in trees) {<br>&nbsp;&nbsp;&nbsp;// здесь операторы не выполняются<br>}</PRE>
<p><A NAME="1012234"></a>Если Вы хотите, чтобы элемент массива существовал, но имел неопределённое/undefined 
значение, используйте ключевое слово <CODE>undefined</CODE> вместо операции <CODE>delete</CODE>. 
В следующем примере элементу trees[3] присваивается значение undefined, но элемент массива продолжает существовать:</p>
<PRE><A NAME="1012235"></a>trees=new Array("redwood","bay","cedar","oak","maple")<br>trees[3]=undefined<br>if (3 in trees) {<br>&nbsp;&nbsp;&nbsp;// здесь операторы будут выполняться<br>}</PRE>
<H4><A NAME="Head3;"></a><A NAME="1010464"></a>new</H4><hr><p><A NAME="1010465"></a>
Операция <CODE>new</CODE> используется для создания нового экземпляра объекта 
пользовательского типа или предопределённых типов <CODE>Array</CODE>, <CODE>Boolean</CODE>, <CODE>Date</CODE>, <CODE>Function</CODE>, <CODE>Image</CODE>, <CODE>Number</CODE>, <CODE>Object</CODE>, <CODE>Option</CODE>, <CODE>RegExp</CODE> 
или <CODE>String</CODE>. На сервере Вы можете также использовать эту операцию с 
объектами <CODE>DbPool</CODE>, <CODE>Lock</CODE>, <CODE>File</CODE> или <CODE>SendMail</CODE>.<br>
Используйте <CODE>new</CODE> так:</p>
<PRE><A NAME="1008710"></a><I>objectName</I> = new <I>objectType</I> ( <I>param1</I> [,<I>param2</I>] ...[,<I>paramN</I>] )</PRE>
<p><A NAME="1010290"></a>Вы можете также создавать объекты с использованием инициализаторов объектов, как 
описано в разделе <A HREF="obj.php#1008330">"Использование Инициализаторов Объектов"</a>.</p><p><A NAME="1009819"></a>
См. также <CODE>new</CODE> в книге <a href="../clientref13/index.php"><i>
Клиентский</i></a><I><a TARGET="_top" href="../clientref13/index.php"> JavaScript. 
Справочник</a></I>.</p><H4><A NAME="Head3;"></a><A NAME="1010302"></a>this</H4><hr><p><A NAME="1010303"></a>
Используйте ключевое слово <CODE>this</CODE> для обращения к текущему объекту. 
Вообще <CODE>this</CODE> ссылается на вызывающий объект в методе. Используйте <CODE>this</CODE> так:</p>
<PRE><A NAME="1010304"></a>this[.<I>propertyName</I>]</PRE><p><A NAME="1010305"></a>
<B>Пример 1.</B> Функция <CODE>validate</CODE> проверяет свойство <CODE>value</CODE> объекта, имея high и low-значения:</p>
<PRE><A NAME="1010306"></a>function validate(obj, lowval, hival) {<br>&nbsp;&nbsp;&nbsp;if ((obj.value &lt; lowval) || (obj.value &gt; hival))<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;alert("Invalid Value!")<br>}</PRE>
<p><A NAME="1010307"></a>Вы можете вызывать <CODE>validate</CODE> в обработчике <CODE>onChange</CODE> 
каждого элемента формы, используя <CODE>this</CODE> для передачи в функцию элемента формы, как в следующем примере:</p>
<PRE><A NAME="1010308"></a>&lt;B&gt;Enter a number between 18 and 99:&lt;/B&gt;<br>&lt;INPUT TYPE = "text" NAME = "age" SIZE = 3<br>&nbsp;&nbsp;&nbsp;onChange="validate(this, 18, 99)"&gt;</PRE>
<p><A NAME="1010309"></a><B>Пример 2.</B> В сочетании со свойством <CODE>form</CODE>, слово <CODE>this</CODE> 
может ссылаться на родительскую форму текущего объекта. В следующем примере 
форма <CODE>myForm</CODE> содержит <CODE>Text</CODE>-объект и кнопку. Если 
пользователь щёлкает по кнопке, в объект <CODE>Text</CODE> устанавливается имя 
формы. Обработчик <CODE>onClick</CODE> кнопки использует <CODE>this.form</CODE> 
для обращения к родительской форме <CODE>myForm</CODE>.</p>
<PRE><A NAME="1010310"></a>&lt;FORM NAME="myForm"&gt;<br>Form name:&lt;INPUT TYPE="text" NAME="text1" VALUE="Beluga"&gt;<br>&lt;P&gt;<br>&lt;INPUT NAME="button1" TYPE="button" VALUE="Show Form Name"<br>&nbsp;&nbsp;&nbsp;onClick="this.form.text1.value=this.form.name"&gt;<br>&lt;/FORM&gt;</PRE>
<H4><A NAME="Head3;"></a><A NAME="1008719"></a>typeof</H4><hr><p><A NAME="1008720"></a>
Операция <CODE>typeof</CODE> используется двумя способами:</p>
<PRE><A NAME="1008721"></a>1. typeof <I>operand<br></I>2. typeof (<I>operand</I>)</PRE>
<p><A NAME="1008722"></a>Операция <CODE>typeof</CODE> возвращает строку - тип невычисленного операнда.<br>
<CODE>operand</CODE> это строка, переменная, ключевое слово или объект, тип которого возвращается. Скобки не обязательны.</p>
<p><A NAME="1008723"></a>Предположим, Вы определяете следующие переменные:</p>
<PRE><A NAME="1008724"></a>var myFun = new Function("5+2")<br>var shape="round"<br>var size=1<br>var today=new Date()</PRE>
<p><A NAME="1008725"></a>Операция <CODE>typeof</CODE> возвращает для этих переменных следующие результаты:</p>
<PRE><A NAME="1008726"></a>typeof myFun is object<br>typeof shape is string<br>typeof size is number<br>typeof today is object<br>typeof dontExist is undefined</PRE>
<p><A NAME="1008727"></a>Для ключевых слов <CODE>true</CODE> и <CODE>null</CODE> операция <CODE>typeof</CODE> 
возвращает:</p><PRE><A NAME="1008728"></a>typeof true is boolean<br>typeof null is object</PRE>
<p><A NAME="1008729"></a>Для числа или строки операция <CODE>typeof</CODE> возвращает:</p>
<PRE><A NAME="1008730"></a>typeof 62 is number<br>typeof 'Hello world' is string</PRE>
<p><A NAME="1008731"></a>Для значений свойств операция <CODE>typeof</CODE> возвращает тип значения, содержащегося в свойстве:</p>
<PRE><A NAME="1008732"></a>typeof document.lastModified is string<br>typeof window.length is number<br>typeof Math.LN2 is number</PRE>
<p><A NAME="1008733"></a>Для методов и функций операция <CODE>typeof</CODE> возвращает такие результаты:</p>
<PRE><A NAME="1008734"></a>typeof blur is function<br>typeof eval is function<br>typeof parseInt is function<br>typeof shape.split is function</PRE>
<p><A NAME="1008735"></a>Для предопределённых объектов операция <CODE>typeof</CODE> возвращает:</p>
<PRE><A NAME="1012078"></a>typeof Date is function<br>typeof Function is function<br>typeof Math is function<br>typeof Option is function<br>typeof String is function</PRE>
<H4><A NAME="Head3;"></a><A NAME="1012081"></a>void</H4><hr><p><A NAME="1012082"></a>
Операция void используется одним из следующих способов:</p>
<PRE><A NAME="1008741"></a>1. void (<I>expression</I>)<br>2. void <I>expression</I></PRE>
<p><A NAME="1008742"></a>Операция void специфицирует выражение, вычисляемое без возвращения значения.<br>
<CODE>expression</CODE> это вычисляемое выражение JavaScript. Скобки вокруг expression 
не обязательны, но их использование является хорошим стилем.</p><p><A NAME="1008743"></a>
Вы можете использовать операцию <CODE>void</CODE> для специфицирования выражения 
как гиперссылки. Выражение вычисляется, но не загружается вместо текущего документа.</p><p><A NAME="1008744"></a>
Следующий код создаёт гиперссылку, которая не выполняет никаких действий, если 
пользователь щёлкнет по ней. Если пользователь щёлкает по этой ссылке, <CODE>void(0)</CODE> 
вычисляется в 0, но это не вызывает никаких действий в JavaScript.</p>
<PRE><A NAME="1008745"></a>&lt;A HREF="javascript:void(0)"&gt;Click here to do nothing&lt;/A&gt;</PRE>
<p><A NAME="1008746"></a>Следующий код создаёт гиперссылку, которая отправляет форму на сервер, если 
пользователь щёлкнул по этой ссылке.</p>
<PRE><A NAME="1008747"></a>&lt;A HREF="javascript:void(document.form.submit())"&gt;<br>Click here to submit&lt;/A&gt;</PRE>
<H3><A NAME="Head2;"></a><A NAME="1008750"></a>Приоритет операций</H3><hr><p><A NAME="1008751"></a>
<i>Приоритет</i> операций определяет порядок, в котором они выполняются при 
вычислении выражения. Вы можете переопределить приоритет операций путём использования скобок.</p><p><A NAME="1008825"></a>
В следующей таблице показан приоритет выполнения операций, от низшего к высшему.</p>
<A NAME="1010207"></a><h6><A NAME="1012364"></a>Таблица 3.7 Приоритет операций</h6><TABLE BORDER="2" CELLPADDING=5>
<TR><TH><A NAME="1012368"></a>Тип операции<TH><A NAME="1012370"></a>Операции<TR><TD><P><A NAME="1012465"></a>
запятая</P><TD><PRE><A NAME="1012467"></a>,</PRE><TR><TD><P><A NAME="1012372"></a>
присвоения</P><TD><PRE><A NAME="1012374"></a>= += -= *= /= %= &lt;&lt;= &gt;&gt;= &gt;&gt;&gt;= &amp;= ^= |=</PRE>
<TR><TD><P><A NAME="1012376"></a>условная</P><TD><PRE><A NAME="1012378"></a>?:</PRE>
<TR><TD><P><A NAME="1012380"></a>логическая<span lang="en-us"> </span>or</P><TD><PRE><A NAME="1012382"></a>||</PRE>
<TR><TD><P><A NAME="1012384"></a>логическая<span lang="en-us"> </span>and</P><TD><PRE><A NAME="1012386"></a>&amp;&amp;</PRE>
<TR><TD><P><A NAME="1012388"></a>битовая<span lang="en-us"> </span>or</P><TD><PRE><A NAME="1012390"></a>|</PRE>
<TR><TD><P><A NAME="1012392"></a>битовая xor</P><TD><PRE><A NAME="1012394"></a>^</PRE>
<TR><TD><P><A NAME="1012396"></a>битовая and</P><TD><PRE><A NAME="1012398"></a>&amp;</PRE>
<TR><TD><P><A NAME="1012400"></a>равенство</P><TD><PRE><A NAME="1012402"></a>== !=</PRE>
<TR><TD><P><A NAME="1012404"></a>сравнения</P><TD><PRE><A NAME="1012406"></a>&lt; &lt;= &gt; &gt;=</PRE>
<TR><TD><P><A NAME="1012408"></a>битовый сдвиг</P><TD><PRE><A NAME="1012410"></a>&lt;&lt; &gt;&gt; &gt;&gt;&gt;</PRE>
<TR><TD><P><A NAME="1012412"></a>сложение/вычитание</P><TD><PRE><A NAME="1012414"></a>+ -</PRE>
<TR><TD><P><A NAME="1012416"></a>умножение/деление</P><TD><PRE><A NAME="1012418"></a>* / %</PRE>
<TR><TD><P><A NAME="1012420"></a>отрицание/инкремент</P><TD><PRE><A NAME="1012422"></a>! ~ - + ++ -- typeof void delete</PRE>
<TR><TD><P><A NAME="1012471"></a>вызов</P><TD><PRE><A NAME="1012473"></a>()</PRE>
<TR><TD><P><A NAME="1012441"></a>создание экземпляра</P><TD><PRE><A NAME="1012443"></a>new</PRE>
<TR><TD><P><A NAME="1012424"></a>член</P><TD><PRE><A NAME="1012426"></a>. []</PRE></TABLE>
<h5><a href="contents.php">Оглавление</a> | <a href="ident.php">Назад</a>
| <a href="regexp.php">Вперёд</a> | <a href="bklast.php">Индекс</a></h5>
<hr></BODY></HTML>
<?
include_once '../../sys/inc/tfoot.php';
?>