<?
include_once '../../sys/inc/start.php';
include_once '../../sys/inc/compress.php';
include_once '../../sys/inc/sess.php';
include_once '../../sys/inc/home.php';
include_once '../../sys/inc/settings.php';
include_once '../../sys/inc/db_connect.php';
include_once '../../sys/inc/ipua.php';
include_once '../../sys/inc/fnc.php';
include_once '../../sys/inc/user.php';
$set['title']='Учебник JavaScript';
include_once '../../sys/inc/thead.php';
title();
err();
//aut();
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<phpl<TITLE>JavaScript. Обзор.</TITLE>
<BODY>
<h5><a href="contents.php">Оглавление</a> | <a href="preface.php">Назад</a>
| <a href="partcore.php">Вперёд</a> | <a href="bklast.php">Индекс</a></h5><HR>
<h1>Глава 1<BR><A NAME="1009367"></a>JavaScript. Обзор.</h1>
<p><A NAME="1009368"></a>Эта глава - введение в JavaScript. Здесь обсуждаются некоторые фундаментальные понятия.</p>
<p><A NAME="1014485"></a>В главе имеются следующие разделы:</p><ul><LI><A NAME="1014490"></a>
<A HREF="#1009369">Что такое JavaScript?</a></LI><LI><A NAME="1022257"></a>
<A HREF="#1022274">Ядро, клиентский и серверный JavaScript</a></LI><LI><A NAME="1016916"></a>
<A HREF="#1012569">JavaScript и Java</a></LI><LI><A NAME="1016878"></a>
<a href="#1009909">Отладка в JavaScript</a></LI><LI><A NAME="1016879"></a>
<A HREF="#1013886">Visual JavaScript</a></LI><LI><A NAME="1016880"></a><A HREF="#1013654">JavaScript и спецификация ECMA</a></LI></ul>
<H2><A NAME="What Is JavaScript?"><A NAME="1009369"></a>Что такое JavaScript?</H2><hr><p><A NAME="1022262"></a>
JavaScript это разработанный корпорацией Netscape межплатформенный 
объектно-ориентированный язык скриптинга (сценариев). Ядро JavaScript содержит 
набор основных объектов, таких как <CODE>Array</CODE>, <CODE>Date</CODE> и <CODE>Math</CODE>, 
и основной набор элементов языка, таких как операции, управляющие структуры и 
операторы. Ядро JavaScript может быть расширено путём предоставления дополнительных объектов; например:</p>
<ul><LI><A NAME="1016040"></a><i>Клиентский JavaScript</i> расширяет ядро языка за счёт объектов, 
управляющих браузером (Navigator или другой подобный web-браузер) и его Document Object Model (DOM). Например, 
клиентские расширения позволяют приложению размещать элементы на HTML-форме и 
отвечать на пользовательские события, такие как щелчок мышью, ввод данных в форму и навигация по страницам.<LI><A NAME="1016010"></a>
<i>Серверный JavaScript</i> расширяет ядро языка за счёт объектов, имеющих 
отношение к работе JavaScript на сервере. Например, серверные расширения 
позволяют подключиться к реляционной БД, поддерживать&nbsp; непрерывность 
информации между вызовами приложения или работать с файлами на сервере.</LI></ul><p><A NAME="1022267"></a>
JavaScript даёт Вам возможность создавать приложения, работающие в Internet. 
Клиентские приложения работают в браузере, таком как Netscape Navigator, а 
серверные приложения запускаются на сервере, таком как Netscape Enterprise Server. 
Используя JavaScript, Вы можете создавать динамические HTML-страницы, которые 
обрабатывают пользовательский ввод и работают с данными через использование специальных объектов, файлов и реляционных баз данных.</p>
<p><A NAME="1016777"></a>С помощью функциональности LiveConnect Вы можете дать возможность коду Java и JavaScript 
взаимодействовать. Из JavaScript Вы можете инстанциировать Java-объекты и 
получить доступ к их public-методам и полям. Из Java Вы можете иметь доступ к объекта, методам и свойствам JavaScript.</p>
<p><A NAME="1021034"></a>Netscape изобрела JavaScript, и JavaScript впервые был использован в браузерах Netscape.</p>
<H2><A NAME="Core, Client-Side, and Server-Side JavaScript"><A NAME="1022274"></a>Ядро, клиентский и серверный JavaScript</H2><hr>
<p><A NAME="1022275"></a>Компоненты JavaScript показаны на этом рисунке.</p>
<h6 style="text-align: center"><A NAME="1022280"></a>Рисунок 1.1&nbsp;&nbsp;Язык JavaScript</h6>
<P><IMG SRC="graphics/lang.gif" width="474" height="364"></a></P><p><A NAME="1022281"></a>
Следующие разделы являются введением в  JavaScript на клиенте и на сервере.</p><H3><A NAME="Head2;"></a>
<A NAME="1022283"></a>Ядро JavaScript</H3><hr><p><A NAME="1022284"></a>
Клиентский и серверный JavaScript имеют следующие общие элементы:</p><ul><LI><A NAME="1022285"></a>
Ключевые слова</LI><LI><A NAME="1022286"></a>
Синтаксис и грамматику операторов</LI><LI><A NAME="1022287"></a>
Требования к выражениям, переменным и литералам</LI><LI><A NAME="1022288"></a>
Объектную модель (хотя клиентский и серверный JavaScript имеют разные наборы 
предопределённых объектов)</LI><LI><A NAME="1022289"></a>
Предопределённые объекты и функции, такие как <CODE>Array</CODE>, <CODE>Date</CODE> и <CODE>Math</CODE></LI></ul>
<H3><A NAME="Head2;"></a><A NAME="1022293"></a>Клиентский JavaScript</H3><hr><p><A NAME="1022294"></a>
Web-браузеры, такие как Navigator (2.0 и более поздние версии), могут 
интерпретировать операторы клиентского JavaScript, внедрённые в HTML-страницу. 
Если браузер (или <i>клиент</i>) запрашивает такую страницу, сервер высылает 
полное содержимое документа, включая HTML и операторы JavaScript, клиенту по 
сети. Браузер читает страницу сверху вниз, отображая результирующий HTML и выполняя 
операторы JavaScript по мере из обнаружения. Этот процесс, показанный на 
следующем рисунке, выдает пользователю конечный результат.</p>
<h6 style="text-align: center"><A NAME="1022300"></a>
Рисунок 1.2&nbsp;&nbsp;Клиентский JavaScript</h6>
<P><IMG SRC="graphics/csrt.gif" width="379" height="457"></a></P><p><A NAME="1022301"></a>
Операторы клиентского JavaScript, внедрённые в HTML-страницу, могут реагировать 
на пользовательские события, такие как щелчок мыши, ввод данных в форму и 
навигация по странице. Например, Вы можете написать функцию JavaScript для 
проверки правильности введённой пользователем в форму информации - номера 
телефона или zip-кода. Без передачи по сети, JavaScript, внедрённый на HTML-страницу, 
может проверить введённые данные и вывести диалоговое окно, если пользователь ввёл неправильные данные.</p>
<p><A NAME="1016118"></a>Разные версии JavaScript работают с конкретными версиями Navigator<span lang="en-us">&#39;</span>а. Например, JavaScript 1.2 
предназначен для Navigator 4.0. Некоторые возможности JavaScript 1.2 
недоступны в JavaScript 1.1 и, следовательно, недоступны в Navigator&nbsp;3.0. О 
версиях JavaScript и Navigator см. <A HREF="preface.php#1009601">"Версии JavaScript"</a>.</p><H3><A NAME="Head2;"></a>
<A NAME="1022316"></a>Серверный JavaScript</H3><hr><p><A NAME="1022317"></a>
Серверный JavaScript также встраивается в HTML-страницы. Серверные операторы 
могут подключать к реляционным БД разных производителей, предоставлять 
информацию в совместное использование несколькими потребителями, давать доступ к 
файловой системе сервера или взаимодействовать с другими приложениями через LiveConnect 
и Java. HTML-страницы с серверным JavaScript могут также содержать клиентский JavaScript.</p>
<p><A NAME="1022318"></a>В отличие от страниц, написанных на чисто клиентском JavaScript, HTML-страницы с 
серверным JavaScript компилируются в байт-код исполняемых файлов. Эти 
исполняемые файлы запускаются web-сервером, имеющим машину выполнения JavaScript. 
Поэтому создание приложений JavaScript это процесс из двух этапов.</p>
<p><A NAME="1022324"></a>На первом этапе, показанном на <a href="#1022330">Рисунке 1.3</a>, Вы создаёте HTML-страницы (которые 
могут содержать операторы клиентского и серверного JavaScript) и JavaScript-файлы. 
Затем Вы компилируете все эти файлы в единый исполняемый файл.</p>
<h6 style="text-align: center"><A NAME="1022330"></a>
Рисунок 1.3&nbsp;&nbsp;Серверный JavaScript в процессе разработки</h6>
<P><IMG SRC="graphics/ssdev.gif" width="489" height="405"></a></P><p><A NAME="1022334"></a>
На втором этапе, показанном на <a href="#1022340">Рисунке 1.4</a>, страница 
приложения запрашивается клиентским браузером. Машина выполнения использует 
исполняемый файл приложения для поиска исходной страницы и динамически 
генерирует возвращаемую клиенту HTML-страницу. Машина запускает на выполнение 
операторы серверного JavaScript, найденные на странице. В результате этого на HTML-страницу 
могут быть добавлены новый HTML или операторы JavaScript. Машина выполнения 
высылает результирующую страницу по сети Navigator<span lang="en-us">&#39;</span>у-клиенту, 
который запускает на выполнение клиентский JavaScript и выводит результаты.</p>
<h6 style="text-align: center"><A NAME="1022340"></a>
Рисунок 1.4&nbsp;&nbsp;Серверный JavaScript на этапе прогона</h6>
<P><IMG SRC="graphics/ssrt.gif" width="480" height="459"></a></P><p><A NAME="1022341"></a>
В отличие от стандартных программ Common Gateway Interface (CGI), весь исходный JavaScript 
интегрируется непосредственно в HTML-страницы, ускоряя разработку и облегчая 
обслуживание. Служба Session Management Service серверного JavaScript содержит объекты, 
которые Вы можете использовать для обслуживания данных, существующих в 
промежутке между клиентскими запросами, нескольких клиентов и нескольких 
приложений. Служба LiveWire Database Service серверного JavaScript предоставляет 
объекты для доступа к БД, являясь интерфейсом для Structured Query Language (SQL)-серверов БД.</p>
<H2><A NAME="JavaScript and Java"><A NAME="1012569"></a>JavaScript и Java</H2><hr><p><A NAME="1019782"></a>
JavaScript и Java похожи, но имеют фундаментальные отличия. Язык JavaScript 
напоминает Java, но не имеет статической типизации и строгой проверки типов Java. JavaScript 
в основном поддерживает синтаксис выражений Java и базовые конструкции управления потоком.</p><p><A NAME="1020614"></a>
В отличие от системы времени компиляции классов Java, построенной на объявлениях, JavaScript 
поддерживает систему времени прогона, базирующуюся на небольшом количестве типов 
данных: числовых, Булевых и строковых значениях. JavaScript имеет объектную 
модель на основе прототипов, а не более распространённую модель на основе 
классов. Модель на прототипах предоставляет возможность динамического 
наследования; то есть то, что наследуется, может варьироваться для разных 
объектов. JavaScript также поддерживает функции без специальных требований к 
объявлению. Функции могут быть свойствами объектов, выполняясь как слабо типизированные методы.</p>
<p><A NAME="1020620"></a>JavaScript намного более свободен по форме по сравнению с Java. Вы не должны 
объявлять все переменные, классы и методы. Вы не должны учитывать, какие методы 
являются public, private или protected и Вы не должны реализовывать интерфейсы. 
Возвращаемые значения переменных, параметров и функций не являются явно типизированными.</p>
<p><A NAME="1009453"></a>Java это язык программирования на основе классов, созданный для быстрого 
выполнения и строгой проверки типов. Строгая проверка типов означает, к примеру, 
что Вы не можете привести/cast целое число Java к ссылке на объект или получить 
доступ к private-памяти, нарушив байт-коды Java. Модель классов Java означает, 
что программы состоят исключительно из классов и их методов. Наследование 
классов Java и строгая типизация обычно требуют плотно выстроенной иерархии 
объектов. Эти требования делают программирование на Java более сложным, чем авторизация в JavaScript.</p>
<p><A NAME="1009454"></a>JavaScript по духу происходит от небольших, динамически типизируемых языков, 
таких как HyperTalk и dBASE. Эти языки программирования являются утилитами 
программирования для широкой аудитории, так как имеют упрощённый синтаксис, 
специализированную встроенную функциональность и минимальные требования при создании объектов.</p>
<A NAME="1014431"></a><h6 style="text-align: center"><A NAME="1009457"></a>
Таблица 1.1&nbsp; JavaScript в сравнении с Java</h6><TABLE BORDER="2" CELLPADDING=5>
<TR><TH><A NAME="1009461"></a>JavaScript<TH><A NAME="1009463"></a>
Java<TR><TD><P><A NAME="1009465"></a>
Интерпретируется (не компилируется) клиентом.</P><TD><P><A NAME="1009467"></a>
Скомпилированные байт-коды загружаются с сервера, выполняются на клиенте.</P>
<TR><TD><P><A NAME="1009469"></a>Объектно-ориентированный. Нет отличий в типах объектов. Наследование идёт 
через механизм прототипов, а свойства и методы могут динамически добавляться к любому объекту.</P><TD><P><A NAME="1009471"></a>
На основе классов. Объекты делятся на классы и экземпляры с наследованием по 
всей цепи иерархии классов. Классы и экземпляры не могут иметь свойства или методы, добавляемые динамически.</P>
<TR><TD><P><A NAME="1009473"></a>Код, интегрированный с и внедрённый в HTML.</P><TD><P><A NAME="1009475"></a>
Аплеты отличаются от HTML (при доступе из HTML-страниц).</P><TR><TD><P><A NAME="1009477"></a>
Тип данных переменной не объявляется (динамическая типизация).</P><TD><P><A NAME="1009479"></a>
Тип данных переменной обязан быть объявлен (статическая типизация).</P><TR><TD><P><A NAME="1009485"></a>
Не может автоматически записывать на жёсткий диск.</P><TD><P><A NAME="1009487"></a>Не может автоматически записывать на жёсткий диск.</P></TABLE>
<p><A NAME="1020545"></a>Об отличиях JavaScript и Java см. также <A HREF="obj2.php#1013803">Главу 8 "Объектная 
Модель. Детали&quot;</a>.</p><H2><A NAME="Debugging JavaScript"><A NAME="1009909"></a>Отладка в JavaScript</H2><hr>
<p><A NAME="1024630"></a>JavaScript позволяет создавать сложные компьютерные программы. Как и в других 
языках, Вы можете ошибаться при написании скриптов. Отладчик Netscape JavaScript Debugger 
позволяет отлаживать Ваши скрипты. Об использовании Отладчика/Debugger см. следующие документы:</p>
<ul><LI><A NAME="1024636"></a><EM>
<A HREF="http://developer.netscape.com/software/jsdebug.phpl" TARGET="_top">Netscape JavaScript Debugger 1.1</a></EM> 
  - введение в Debugger.</LI><P><A NAME="1024637"></a>
Вы можете загрузить Debugger с указанного URL. Загружаемый файл это 
SmartUpdate .jar. Для установки Debugger загрузите этот .jar-файл в Navigator: 
используйте процедуру, описанную в вышеуказанном URL, или введите URL к .jar-файлу в поле location (адресную строку).</P>
<LI><A NAME="1023870"></a><EM><A HREF="http://developer.netscape.com/docs/manuals/jsdebug/index.php" TARGET="_top">Getting Started with Netscape JavaScript Debugger</a></EM> 
объясняет, как пользоваться Отладчиком.</LI></ul><H2><A NAME="Visual JavaScript"><A NAME="1013886"></a>Visual JavaScript</H2><hr>
<p><A NAME="1015526"></a>Netscape Visual JavaScript это утилита визуальной разработки на базе компонентов 
для платформы Netscape Open Network Environment (ONE). Она предназначена в 
основном для использования разработчиками, которые хотят создавать 
платформонезависимые web-приложения на основе стандартов из готовых к 
использованию компонентов с минимальными затратами на программирование. Эти 
приложения основаны на HTML, JavaScript и Java.</p><p><A NAME="1015907"></a>
О Visual JavaScript см. книгу <EM> <A HREF="http://developer.netscape.com/docs/manuals/visualjs/index.php" TARGET="_top">Visual JavaScript Developer's Guide</a></EM>.</p>
<H2><A NAME="JavaScript and the ECMA Specification"><A NAME="1013654"></a>JavaScript и спецификация ECMA</H2><hr>
<p><A NAME="1020727"></a>Корпорация Netscape изобрела JavaScript, и JavaScript впервые был использован в Netscape-браузерах. 
Одновременно Netscape работает совместно с <A HREF="http://www.ecma.ch" TARGET="_top">ECMA</a> (European Computer Manufacturers Association) 
над созданием стандартизованного международного языка программирования на основе 
ядра JavaScript. ECMA это международная ассоциация стандартов для информационных 
и коммуникационных систем. эта стандартизованная версия JavaScript, называемая ECMAScript, 
работает совершенно одинаково во всех приложениях, поддерживающих данный 
стандарт. Компании могут использовать этот открытый стандартный язык для 
разработки своих реализаций JavaScript. Первая версия стандарта ECMA документирована в спецификации ECMA-262.</p>
<p><A NAME="1013667"></a>Стандарт ECMA-262 одобрен также <A HREF="http://www.iso.ch" TARGET="_top">ISO</a> (International Organization for Standards) 
как ISO-16262. Вы можете найти <A HREF="http://developer.netscape.com/docs/javascript/e262-pdf.pdf" TARGET="_top">PDF-версию ECMA-262</a> 
на сайте Netscape DevEdge Online. Вы можете также найти <A HREF="http://www.ecma.ch/stand/ecma-262.php" TARGET="_top">
эту спецификацию на web-сайте ECMA</a>. Спецификация ECMA не описывает Document Object Model (DOM), 
которая стандартизована консорциумом <A HREF="http://www.w3.org" TARGET="_top">World Wide Web Consortium (W3C)</a>. DOM 
определяет способ, которым HTML-объекты документа экспонируются Вашему скрипту.</p>
<H3><A NAME="Head2;"></a><A NAME="1013678"></a>Соотношение версий JavaScript и ECMA</H3><hr><p><A NAME="1014160"></a>
Netscape тесно сотрудничает с ECMA для создания ECMA-спецификации. В таблице 
показано соотношение между версиями JavaScript и ECMA.</p><A NAME="1014445"></a>
<h6 style="text-align: center"><A NAME="1014163"></a>Таблица 1.2&nbsp; Версии JavaScript и ECMA</h6>
<TABLE BORDER="2" CELLPADDING=5 width="762"><TR><TH width="98"><A NAME="1014167"></a>Версия JavaScript<TH width="630"><A NAME="1014169"></a>
Сравнение с версией ECMA<TR><TD width="98"><P><A NAME="1014171"></a>
JavaScript 1.1</P><TD width="630"><P><A NAME="1014173"></a>ECMA-262 основан на JavaScript 1.1.</P>
<TR><TD width="98"><P><A NAME="1014175"></a>JavaScript 1.2</P><TD width="630"><P><A NAME="1014177"></a>Работа над
ECMA-262 не была завершена в момент выхода JavaScript 1.2.<br>
JavaScript 1.2 не полностью совместим с ECMA-262 по следующим причинам:</P><ul><LI><A NAME="1014178"></a>
Netscape разработал дополнения для JavaScript 1.2, которые не были учтены в ECMA-262.<LI><A NAME="1014179"></a>
ECMA-262 добавил интернационализацию с использованием Unicode и универсальное 
поведение на всех платформах. Серверные возможности JavaScript 1.2, 
такие как объект <CODE>Date</CODE>, были платформозависимыми и использовали 
поведение, специфическое для конкретных платформ.</ul><TR><TD width="98"><P><A NAME="1014181"></a>
JavaScript 1.3</P><TD width="630"><P><A NAME="1014183"></a>JavaScript 1.3 полностью совместим с ECMA-262.</P><P><A NAME="1014184"></a>
</P><P><A NAME="1014185"></a>В JavaScript 1.3 устранено несоответствие JavaScript 1.2 с ECMA-262 при 
сохранении всех дополнительных возможностей JavaScript 1.2, исключая == и !=, 
которые были изменены для обеспечения соответствия ECMA-262. Эти 
дополнительные возможности, включая некоторые новые из JavaScript 1.3, не 
являющиеся частью ECMA, рассматриваются при создании второй версии спецификации ECMA.</P><P><A NAME="1020816"></a>
</P><P><A NAME="1020817"></a>Например, JavaScript 1.2 и 1.3 поддерживают регулярные выражения, которые 
не вошли в ECMA-262. Вторая версия спецификации ECMA не была закончена, когда JavaScript 1.3 был опубликован.</P>
</TABLE><p><A NAME="1020924"></a>В книге<a href="http://developer.netscape.com/docs/manuals/js/client/jsref/index.php">
<i>Клиентский</i></a><I><A HREF="http://developer.netscape.com/docs/manuals/js/client/jsref/index.php" TARGET="_top"> JavaScript. 
Справочник.</a></I> указано, какие возможности языка совместимы с ECMA.</p><p><A NAME="1020935"></a>
JavaScript всегда будет иметь возможности, не являющиеся частью спецификации ECMA; JavaScript 
совместим с ECMA, предоставляя дополнительные возможности.</p><H3><A NAME="Head2;"></a>
<A NAME="1013717"></a>Документация JavaScript и спецификация ECMA</H3><hr><p><A NAME="1013719"></a>
Спецификация ECMA это набор требований по реализации ECMAScript; она может 
использоваться, если Вы хотите определить, поддерживается ли возможность JavaScript 
в ECMA. Если Вы планируете писать JavaScript-код, который использует только 
поддерживаемые ECMA возможности, Вам понадобится просмотреть спецификацию ECMA.</p><p><A NAME="1013720"></a>
Документ ECMA не предназначен для помощи программистам скриптов; о написании 
скриптов см. документацию JavaScript.</p><H3><A NAME="Head2;"></a><A NAME="1013722"></a>JavaScript и терминология ECMA</H3>
<hr><p><A NAME="1013723"></a>Спецификация ECMA использует терминологию и синтаксис, которые могут быть 
незнакомы программистам JavaScript. Хотя описание языка в ECMA может отличаться, 
сам язык остаётся тем же. JavaScript поддерживает всю функциональность спецификации ECMA.</p><p><A NAME="1013724"></a>
Документация&nbsp; JavaScript рассматривает аспекты языка, предназначенные для 
программиста JavaScript. Например:</p><ul><LI><A NAME="1013726"></a>
Объект global не обсуждается в документации JavaScript, поскольку Вы не 
используете его непосредственно. Методы и свойства объекта global, которые Вы 
используете, обсуждаются в документации JavaScript, но называются свойствами и 
методами верхнего уровня.</LI><LI><A NAME="1013727"></a>
Конструктор без параметров (zero-argument) с объектами <CODE>Number</CODE> и <CODE>String</CODE> 
не обсуждается в документации JavaScript, поскольку используется мало. 
Конструктор <CODE>Number</CODE> без аргумента возвращает +0, а конструктор <CODE>String</CODE> 
без аргумента возвращает "" (пустую строку).</LI></ul>
<h5><a href="contents.php">Оглавление</a> | <a href="preface.php">Назад</a>
| <a href="partcore.php">Вперёд</a> | <a href="bklast.php">Индекс</a></h5>
<hr></BODY></HTML>
<?
include_once '../../sys/inc/tfoot.php';
?>