<?
include_once '../../sys/inc/start.php';
include_once '../../sys/inc/compress.php';
include_once '../../sys/inc/sess.php';
include_once '../../sys/inc/home.php';
include_once '../../sys/inc/settings.php';
include_once '../../sys/inc/db_connect.php';
include_once '../../sys/inc/ipua.php';
include_once '../../sys/inc/fnc.php';
include_once '../../sys/inc/user.php';
$set['title']='Учебник JavaScript';
include_once '../../sys/inc/thead.php';
title();
err();
//aut();
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<phpl<TITLE>LiveConnect. Обзор.</TITLE>
<BODY>
<h5><a href="contents.php">Оглавление</a> | <a href="partlc.php">Назад</a>
| <a href="liveaud.php">Вперёд</a> | <a href="bklast.php">Индекс</a></h5><HR>
<h1>Глава 15<BR><A NAME="1008305"></a>LiveConnect. Обзор.</h1>
<p><A NAME="1021579"></a>В этой главе рассматривается использование технологии LiveConnect, позволяющей 
коду Java и коду JavaScript взаимодействовать. Предполагается, что Вы уже знакомы с программированием на Java.</p>
<p><A NAME="1015012"></a>В главе имеются следующие разделы:</p><ul><LI><A NAME="1043715"></a>
<A HREF="#1043729">Что такое LiveConnect?</a></LI><LI><A NAME="1043719"></a>
<a href="#1043773">Включение LiveConnect</a></LI><LI><A NAME="1043723"></a>
<A HREF="#1043780">Консоль Java</a></LI><LI><A NAME="1039521"></a>
<a href="#1013074">Работа с оболочками</a></LI><LI><A NAME="1015024"></a>
<A HREF="#1014290">Взаимодействие JavaScript с Java</a></LI><LI><A NAME="1015028"></a>
<A HREF="#1008480">Взаимодействие Java с JavaScript</a></LI><LI><A NAME="1037588"></a>
<a href="#1037078">Конвертация типов данных</a></LI></ul><p><A NAME="1021561"></a>
Дополнительно об использовании LiveConnect см. <A HREF="http://developer.netscape.com/docs/technote/index.phpl" TARGET="_top">JavaScript technical notes</a> 
на сайте DevEdge.</p><H2><A NAME="What Is LiveConnect?"><A NAME="1043729"></a>Что такое LiveConnect?</H2><hr>
<p><A NAME="1043731"></a>В браузере Navigator LiveConnect даёт возможность 
использовать:</p><ul><LI><A NAME="1043732"></a>
  JavaScript для прямого доступа к переменным, методам, классам и пакетам Java.</LI><LI><A NAME="1043733"></a>
  Управлять Java-аплетами и plug-in'ами с помощью JavaScript.</LI><LI><A NAME="1043734"></a>
  Код Java для доступа к методам и свойствам JavaScript.</LI></ul><H2><A NAME="Enabling LiveConnect">
<A NAME="1043773"></a>Включение LiveConnect</H2><hr><p><A NAME="1043774"></a>
Служба
LiveConnect по умолчанию включена в Navigator'е 1.1 и 
последующих версиях. Чтобы LiveConnect работала, должны быть включены Java и JavaScript. 
Для проверки этого выберите  Preferences в меню Edit и просмотрите раздел Advanced.</p>
<ul><LI><A NAME="1043775"></a>Убедитесь, что опция Enable Java отмечена.</LI><LI><A NAME="1043776"></a>
Убедитесь, что опция Enable JavaScript отмечена.</LI></ul><p><A NAME="1043777"></a>
Для отключения Java или JavaScript уберите галочки в переключателях; если Вы это сделали, LiveConnect работать не будет.</p>
<H2><A NAME="The Java Console"><A NAME="1043780"></a>Консоль Java</H2><hr><p><A NAME="1043781"></a>
Консоль Java это окно Navigator&#39;а отображающее 
сообщения Java. Если Вы используете переменные классов <CODE>out</CODE> или <CODE>err</CODE> 
в <CODE>java.lang.System</CODE> для вывода сообщения, сообщение появляется на 
консоли. Для показа Java-консоли, выберите Java Console в меню Communicator.</p><p><A NAME="1043785"></a><A NAME="1043782"></a>
Вы можете использовать Java-консоль для показа сообщений пользователю или для 
трассировки значений переменных в различных точках при выполнении программы. 
Учтите, что многие пользователи отключают показ консоли.</p><p><A NAME="1043783"></a>
Например, следующий код Java выводит сообщение "Hello, world!" в Java-консоль:</p>
<PRE><A NAME="1043784"></a>public void init() {<br>&nbsp;&nbsp;&nbsp;System.out.println("Hello, world!")<br>}</PRE>
<H2><A NAME="Working with Wrappers"><A NAME="1013074"></a>Работа с оболочками</H2><hr><p><A NAME="1036886"></a>
В JavaScript <i>оболочка\wrapper</i> это объект типа данных целевого языка, 
который содержит объект исходного языка. На стороне JavaScript  Вы можете 
использовать объект-оболочку для доступа в методам и полям Java-объекта; вызов 
метода или доступ к свойству в оболочке приводит к вызову Java-объекта. На 
стороне Java - JavaScript-объекты оборачиваются в экземпляры класса <CODE>netscape.javascript.JSObject</CODE> 
и передаются в Java.</p><p><A NAME="1036887"></a>Если JavaScript-объект пересылается в Java, машина выполнения создаёт Java-оболочку 
типа <CODE>JSObject</CODE>; когда <CODE>JSObject</CODE> высылается из Java в JavaScript, 
машина выполнения развёртывает его в оригинальный тип JavaScript-объекта. Класс <CODE>JSObject</CODE> 
предоставляет интерфейс для вызова методов JavaScript и проверки свойств JavaScript.</p>
<H2><A NAME="JavaScript to Java Communication"><A NAME="1014290"></a>Взаимодействие JavaScript с Java</H2><hr>
<p><A NAME="1028815"></a>Когда Вы обращаетесь к пакету или классу Java или работаете с массивом или 
объектом Java, Вы используете один из специальных объектов LiveConnect. Все 
запросы JavaScript к Java выполняются с помощью этих объектов, резюме по которым дано в таблице.</p>
<A NAME="1040657"></a><h6 style="text-align: center"><A NAME="1040692"></a>Таблица 15.1&nbsp; Объекты LiveConnect</h6>
<TABLE BORDER="2" CELLPADDING=5><TR><TH><A NAME="1040696"></a>
Объект<TH><A NAME="1040698"></a>Описание<TR><TD><P><A NAME="1040738"></a>
<CODE>JavaArray</CODE></P><TD><P><A NAME="1040740"></a>
Обёрнутый Java-массив, доступ к которому выполняется из кода JavaScript.</P><TR><TD><P><A NAME="1040743"></a>
<CODE>JavaClass</CODE></P><TD><P><A NAME="1040745"></a>Ссылка JavaScript на Java-класс.</P>
<TR><TD><P><A NAME="1040748"></a><CODE>JavaObject</CODE></P><TD><P><A NAME="1040750"></a>
Обёрнутый объект Java, доступ к которому выполняется из кода JavaScript.</P><TR><TD><P><A NAME="1040753"></a>
<CODE>JavaPackage</CODE></P><TD><P><A NAME="1040755"></a>Ссылка JavaScript на Java-пакет.</P></TABLE>
<BLOCKQUOTE><p><B>ПРИМЕЧАНИЕ: </B><A NAME="1037474"></a>
Поскольку Java является строго типизированным языком, а JavaScript типизирован слабо, машина выполнения 
JavaScript конвертирует значения аргументов в подходящие типы данных других 
языков, когда Вы используете LiveConnect. См. полную информацию в разделе <A HREF="#1037078">"Конвертация Типов Данных"</a>.</p>
</BLOCKQUOTE><p><A NAME="1037469"></a>Существование объектов LiveConnect в некотором смысле прозрачно, так как Вы 
взаимодействуете с Java в довольно интуитивной манере. Например, Вы можете 
создать Java-объект <CODE>String</CODE> и присвоить его JavaScript-переменной <CODE>myString</CODE> 
путём использования операции <CODE>new</CODE> с Java-конструктором:</p>
<PRE><A NAME="1028973"></a>var myString = new java.lang.String("Hello world")</PRE>
<p><A NAME="1028974"></a>В предыдущем примере переменная <CODE>myString</CODE> это <CODE>JavaObject</CODE>, 
потому что она содержит экземпляр Java-объекта <CODE>String</CODE>. Как <CODE>JavaObject</CODE>, <CODE>myString</CODE> 
имеет доступ к public-методам экземпляра <CODE>java.lang.String</CODE> и его 
суперкласса, <CODE>java.lang.Object</CODE>. Эти Java-методы доступны в JavaScript 
как методы из <CODE>JavaObject</CODE>, и Вы можете вызвать их так:</p>
<PRE><A NAME="1029015"></a>myString.length() // возвращает 11</PRE><H3><A NAME="Head2;"></a><A NAME="1029016"></a>
Объект Packages</H3><hr><p><A NAME="1029407"></a>Если Java-класс не является частью пакетов <CODE>java</CODE>, <CODE>sun</CODE> 
или <CODE>netscape</CODE>, Вы осуществляете доступ к нему через объект <CODE>Packages</CODE>. Например, 
корпорация Redwood использует Java-пакет <CODE>redwood </CODE>как контейнер для 
различных Java-классов. Для создания экземпляра класса <CODE>HelloWorld</CODE> 
пакета <CODE>redwood</CODE> Вы выполняете доступ к конструктору этого класса так:</p>
<PRE><A NAME="1029053"></a>var red = new Packages.redwood.HelloWorld()</PRE><p><A NAME="1029400"></a>
Вы можете получить доступ также к класса пакета по умолчанию (то есть к классам, 
которые не называют пакет явным образом). Например, если класс HelloWorld 
находится непосредственно в <CODE>CLASSPATH</CODE> и не в пакете, Вы можете выполнить к нему доступ так:</p>
<PRE><A NAME="1029401"></a>var red = new Packages.HelloWorld()</PRE><p><A NAME="1034409"></a>
LiveConnect-объекты <CODE>java</CODE>, <CODE>sun</CODE> и <CODE>netscape</CODE> 
являются аббревиатурами для известных Java-пакетов. Например, Вы может записать:</p>
<PRE><A NAME="1034421"></a>var myString = new java.lang.String("Hello world")</PRE>
<p><A NAME="1034419"></a>вместо более длинного варианта:</p>
<PRE><A NAME="1034430"></a>var myString = new Packages.java.lang.String("Hello world")</PRE>
<H3><A NAME="Head2;"></a><A NAME="1029099"></a>Работа с массивами Java</H3><hr><p><A NAME="1029044"></a>
Если какой-нибудь Java-метод создаёт массив и Вы обращаетесь к этому массиву в JavaScript, Вы 
работаете с <CODE>JavaArray</CODE>. Например, следующий код создаёт <CODE>JavaArray</CODE> <CODE>x</CODE> 
из 10 элементов типа int:</p><PRE><A NAME="1029457"></a>theInt = java.lang.Class.forName("java.lang.Integer")<br>x = java.lang.reflect.Array.newInstance(theInt, 10)</PRE>
<p><A NAME="1029463"></a>Подобно JavaScript-объекту <CODE>Array</CODE>, <CODE>JavaArray</CODE> имеет 
свойство <CODE>length</CODE>, которое возвращает количество элементов массива. В 
отличие от <CODE>Array.length</CODE>, <CODE>JavaArray.length</CODE> является 
свойством только для чтения, так как количество элементов в Java-массиве фиксируется в момент создания.</p>
<H3><A NAME="Head2;"></a><A NAME="1029045"></a>Ссылки на пакет и класс</H3><hr><p><A NAME="1029104"></a>
Простые ссылки из JavaScript на пакеты и классы Java создают объекты <CODE>JavaPackage</CODE> 
и <CODE>JavaClass</CODE>. Ранее в примере о компании Redwood, например, ссылка <CODE>Packages.redwood</CODE> 
это объект <CODE>JavaPackage</CODE>. Аналогично, ссылка <CODE>java.lang.String</CODE> 
это <CODE>JavaClass</CODE>-объект.</p><p><A NAME="1029184"></a>
В большинстве случаев Вам не нужно беспокоиться о создании объектов <CODE>JavaPackage</CODE> 
и <CODE>JavaClass</CODE> - Вы просто работаете с пакетами и классами Java, а LiveConnect прозрачно создаёт эти объекты.</p>
<p><A NAME="1034541"></a><CODE>JavaClass</CODE>-объекты не конвертируются автоматически в экземпляры <CODE>java.lang.Class</CODE>, 
когда Вы передаёте их как параметры Java-методам - Вы обязаны создавать оболочку 
для <CODE>java.lang.Class</CODE>-экземпляра. В следующем примере метод <CODE>forName</CODE> 
создаёт объект-оболочку <CODE>theClass</CODE>, который затем передаётся методу <CODE>newInstance</CODE> 
для создания массива.</p><PRE><A NAME="1029248"></a>theClass = java.lang.Class.forName("java.lang.String")<br>theArray = java.lang.reflect.Array.newInstance(theClass, 5)</PRE>
<H3><A NAME="Head2;"></a><A NAME="1029446"></a>Аргументы типа char</H3><hr><p><A NAME="1044261"></a>
Вы не можете передавать односимвольные строки в Java-метод, требующий аргумента 
типа <CODE>char</CODE>. Вы обязаны передавать в такие методы целое число, 
соответствующее Unicode-значению символа. Например, вот присвоение значения "H" переменной <CODE>c</CODE>:</p>
<PRE><A NAME="1044258"></a>c = new java.lang.Character(72)</PRE><H3><A NAME="Head2;"></a>
<A NAME="1043848"></a>Управления Java-аплетами</H3><hr><p><A NAME="1043849"></a>
Вы можете использовать JavaScript для управления поведением Java-аплета, не зная 
почти ничего о внутреннем строении аплета. Все public-переменные, методы и 
свойства аплета доступны для работы из JavaScript. Например, Вы можете 
использовать кнопки, расположенные на HTML-форме, для запуска и остановки Java-аплета, находящегося в любом месте документа.</p>
<H4><A NAME="Head3;"></a><A NAME="1043851"></a>Обращение к аплетам</H4><hr><p><A NAME="1043852"></a>
Каждый аплет документа отражается в JavaScript как <CODE>document.appletName</CODE>, 
где <CODE>appletName</CODE> это значение атрибута <CODE>NAME</CODE> тэга <CODE>&lt;APPLET&gt;</CODE>. 
Массив <CODE>applets</CODE> также содержит все аплеты страницы; Вы можете 
обратиться к элементам этого массива по имени аплета (как в ассоциативном 
массиве) или по порядковому номеру аплета на странице (начиная с 0).</p><p><A NAME="1043853"></a>
Например, рассмотрим аплет "Hello World" на языке Java:</p>
<PRE><A NAME="1043854"></a>import java.applet.Applet;<br>import java.awt.Graphics;</PRE><PRE><A NAME="1043855"></a>public class HelloWorld extends Applet {<br>&nbsp;&nbsp;&nbsp;public void paint(Graphics g) {<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;g.drawString("Hello world!", 50, 25);<br>&nbsp;&nbsp;&nbsp;}<br>}</PRE>
<p><A NAME="1043856"></a>Следующий HTML запускает и отображает аплет и именует его "HelloWorld&quot; (в 
атрибуте <CODE>NAME</CODE>):</p>
<PRE><A NAME="1043857"></a>&lt;APPLET CODE="HelloWorld.class" NAME="HelloWorld" WIDTH=150 HEIGHT=25&gt;<br>&lt;/APPLET&gt;</PRE>
<p><A NAME="1043858"></a>Если это первый аплет документа (самый верхний на странице), Вы можете 
обратиться к нему в JavaScript одним из следующих способов:</p>
<PRE><A NAME="1043859"></a>document.HelloWorld<br>document.applets["HelloWorld"]<br>document.applets[0]</PRE>
<p><A NAME="1043860"></a>Массив <CODE>applets</CODE> имеет свойство <CODE>length</CODE>, <CODE>document.applets.length</CODE>, 
указывающее количество аплетов в документе.</p><p><A NAME="1043861"></a>
Все public-переменные, объявленные в аплете и его классах и пакетах-предках, 
доступны в JavaScript. Static-методы и свойства, объявленные в аплете, доступны 
в JavaScript как методы и свойства объекта <CODE>Applet</CODE>. Вы можете 
получать и устанавливать значения свойств и вызывать методы, возвращающие строковые, числовые и Булевы значения.</p>
<H4><A NAME="Head3;"></a><A NAME="1043863"></a>Пример 1: Hello World</H4><hr><p><A NAME="1043864"></a>
Например, Вы можете изменить вышеприведённый аплет HelloWorld:</p><ul><LI><A NAME="1043865"></a>
переопределить его метод <CODE>init</CODE>, чтобы он объявлял и 
инициализировал строку <CODE>myString</CODE></LI><LI><A NAME="1043866"></a>
определить метод <CODE>setString</CODE>, принимающий строковой аргумент, 
присвоить этот аргумент объекту <CODE>myString</CODE> и вызвать метод <CODE>repaint</CODE>. (Методы <CODE>paint</CODE> 
и <CODE>repaint</CODE> наследуются из <CODE>java.awt.Component</CODE>).</LI></ul><p><A NAME="1043867"></a>
Исходный код Java выглядит теперь так:</p>
<PRE><A NAME="1043868"></a>import java.applet.Applet;<br>import java.awt.Graphics;</PRE><PRE><A NAME="1043869"></a>public class HelloWorld extends Applet {<br>&nbsp;&nbsp;&nbsp;String myString;</PRE><PRE><A NAME="1043870"></a>&nbsp;&nbsp;&nbsp;public void init() {<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;myString = new String("Hello, world!");<br>&nbsp;&nbsp;&nbsp;}<br>&nbsp;&nbsp;&nbsp;public void paint(Graphics g) {<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;g.drawString(myString, 25, 20);<br>&nbsp;&nbsp;&nbsp;}<br>&nbsp;&nbsp;&nbsp;public void setString(String aString) {<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;myString = aString;<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;repaint();<br>&nbsp;&nbsp;&nbsp;}<br>}</PRE>
<p><A NAME="1043871"></a>Сделав стоку сообщения переменной, Вы можете модифицировать её из JavaScript. 
Теперь изменим HTML-файл:</p><ul><LI><A NAME="1043872"></a>
добавим форму с текстовым полем и кнопкой и</LI><LI><A NAME="1043873"></a>
создадим для кнопки обработчик <CODE>onClick</CODE>, вызывающий метод <CODE>setString</CODE> 
из HelloWorld со строкой из текстового поля в качестве аргумента.</LI></ul><p><A NAME="1043874"></a>
Файл HTML выглядит так:</p><PRE><A NAME="1043875"></a>&lt;APPLET CODE="HelloWorld1.class" NAME="Hello" WIDTH=150 HEIGHT=25&gt;<br>&lt;/APPLET&gt;</PRE><PRE><A NAME="1043876"></a>&lt;FORM NAME="form1"&gt;<br>&lt;INPUT TYPE="button" VALUE="Set String"<br>&nbsp;&nbsp;&nbsp;onClick="document.HelloWorld.setString(document.form1.str.value)"&gt;<br>&lt;BR&gt;<br>&lt;INPUT TYPE="text" SIZE="20" NAME="str"&gt;<br>&lt;/FORM&gt;</PRE>
<p><A NAME="1043877"></a>Когда Вы компилируете аплет HelloWorld и загружаете HTML-страницу в Navigator, Вы 
сначала увидите "Hello, World!", выведенное на серой панели аплета. Однако Вы 
можете теперь изменить текст, введя новый в текстовом поле и щёлкнув кнопку. Это 
демонстрирует управление аплетом из JavaScript.</p><H4><A NAME="Head3;"></a><A NAME="1043879"></a>Пример 2: аплет Flashing Color Text</H4>
<hr><p><A NAME="1043880"></a>Более сложный пример - аплет, отображающий &quot;вспыхивающий&quot; текст разными цветами. 
Текстовое поле и кнопка позволяют ввести новый текст. Этот аплет показан на Рисунке 15.1.</p>
<h6><A NAME="1043888"></a>Рисунок 15.1&nbsp;&nbsp;&nbsp;Аплет Flashing text</h6>
<B><P><IMG SRC="graphics/flash.gif" width="422" height="281"></a></B></P><p><A NAME="1043889"></a>Вот исходный HTML:</p>
<PRE><A NAME="1043890"></a>&lt;APPLET CODE="colors.class" WIDTH=500 HEIGHT=60 NAME="colorApp"&gt;<br>&lt;/APPLET&gt;</PRE><PRE><A NAME="1043891"></a>&lt;FORM NAME=colorText&gt;<br>&lt;P&gt;Enter new text for the flashing display:</PRE><PRE><A NAME="1043892"></a>&lt;INPUT TYPE="text"<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; NAME="textBox"<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; LENGTH=50&gt;</PRE><PRE><A NAME="1043893"></a>&lt;P&gt;Click the button to change the display:<br>&lt;INPUT TYPE="button"<br>&nbsp;&nbsp;&nbsp;VALUE="Change Text"<br>&nbsp;&nbsp;&nbsp;onClick="document.colorApp.setString(document.colorText.textBox.value)"&gt;</PRE><PRE><A NAME="1043894"></a>&lt;/FORM&gt;</PRE>
<p><A NAME="1043895"></a>Этот аплет использует public-метод <CODE>setString</CODE> для специфицирования 
вспыхивающего текста. В HTML-форме обработчик <CODE>onClick</CODE> кнопки 
позволяет менять строку "Hello, world!" через вызов метода <CODE>setString</CODE>.</p><p><A NAME="1043896"></a>
Здесь <CODE>colorText</CODE> это имя HTML-формы и <CODE>textBox</CODE> - имя 
текстового поля. Обработчик события передаёт значение, которое пользователь ввёл 
в текстовое поле, методу <CODE>setString</CODE> Java-аплета.</p><H3><A NAME="Head2;"></a>
<A NAME="1043898"></a>Управление Java Plug-in&#39;ами</H3><hr><p><A NAME="1043899"></a>
Каждый plug-in документа отражается в JavaScript как элемент массива <CODE>embeds</CODE>. Например, 
следующий HTML-код включает AVI plug-in в документ:</p>
<PRE><A NAME="1043900"></a>&lt;EMBED SRC=myavi.avi NAME="myEmbed" WIDTH=320 HEIGHT=200&gt;</PRE>
<p><A NAME="1043901"></a>Если это первый plug-in в документе, Вы может получить к нему доступ одним из 
следующих способов:</p><PRE><A NAME="1043902"></a>document.embeds[0]<br>document.embeds["myEmbed"]<br>document.myEmbed</PRE>
<p><A NAME="1043903"></a>Если plug-in ассоциирован с Java-классом <CODE>netscape.plugin.Plugin</CODE>, Вы 
можете получить доступ к его static-переменным и методам тем способом, которым Вы получаете доступ к переменным и методам.</p>
<p><A NAME="1043904"></a>Массив <CODE>embeds</CODE> имеет свойство <CODE>length</CODE>, <CODE>document.embeds.length</CODE>, 
указывающего количество plug-in&#39;ов, встроенных в документ.</p><p><A NAME="1043910"></a>
Книга <I> <A HREF="http://developer.netscape.com/docs/manuals/communicator/plugin/index.php" TARGET="_top">Plug-in Guide</a></I> 
содержит информацию о:</p><ul><LI><A NAME="1043911"></a>
вызове Java-методов из plug-in&#39;ов</LI><LI><A NAME="1043912"></a>вызове методов plug-in&#39;а из Java</LI>
</ul><H2><A NAME="Java to JavaScript Communication"><A NAME="1008480"></a>Взаимодействие Java и JavaScript</H2><hr>
<p><A NAME="1030429"></a>Если Вы хотите использовать объекты JavaScript в Java, Вы обязаны 
импортировать пакет <CODE>netscape.javascript</CODE> в Ваш Java-файл. Этот пакет 
определяет следующие классы:</p><ul><LI><A NAME="1030342"></a>
<CODE>netscape.javascript.JSObject</CODE> даёт коду Java доступ к методам и 
свойствам JavaScript.</LI><LI><A NAME="1030343"></a>
<CODE>netscape.javascript.JSException</CODE> позволяет Java-коду обрабатывать 
ошибки JavaScript.</LI><LI><A NAME="1043918"></a>
<CODE>netscape.plugin.Plugin</CODE> даёт клиентскому JavaScript и аплетам возможность работать с plug-in&#39;ом.</LI>
</ul><p><A NAME="1030345"></a>Начиная с JavaScript 1.2, эти классы поставляются в .jar-файле; в предыдущих 
версиях JavaScript эти классы находились в .zip-файле. См. также книгу <I>
<a TARGET="_top" href="../clientref13/index.php">Клиентский JavaScript. Справочник</a></I>.</p><p><A NAME="1030361"></a>
Для доступа к классам LiveConnect поместите файл .jar или .zip в <CODE>CLASSPATH</CODE> 
компилятора JDK одним из следующих способов:</p><ul><LI><A NAME="1030362"></a>
создайте переменную окружения <CODE>CLASSPATH</CODE> для специфицирования пути 
и имени .jar или .zip-файла.</LI><LI><A NAME="1030363"></a>
специфицируйте размещение .jar или .zip-файла при компиляции путём 
использования команды <CODE>-classpath</CODE> в командной строке.</LI></ul><p><A NAME="1030364"></a>
Например, в Navigator 4. 0 для Windows NT классы поставляются в файле <CODE>java40.jar</CODE> 
в директории <CODE>Program\Java\Classes</CODE> ниже директории Navigator&#39;а. Вы 
можете специфицировать переменную окружения в  Windows NT, открыв System из Control Panel 
и создав пользовательскую переменную окружения <CODE>CLASSPATH</CODE> со значением типа такого:</p>
<PRE><A NAME="1030365"></a>D:\Navigator\Program\Java\Classes\java40.jar</PRE>
<p><A NAME="1030366"></a>См. в документации к Sun JDK информацию о <CODE>CLASSPATH</CODE>.</p>
<BLOCKQUOTE><p><B>ПРИМЕЧАНИЕ: </B><A NAME="1037486"></a>
Поскольку Java является строго типизированным языком, а JavaScript типизирован слабо, машина выполнения 
JavaScript конвертирует значения аргументов в подходящие типы данных других 
языков, когда Вы используете LiveConnect. См. полную информацию в разделе <A HREF="#1037078">"Конвертация Типов Данных"</a>.</p>
</BLOCKQUOTE><H3><A NAME="Head2;"></a><A NAME="1030717"></a>Использование классов LiveConnect</H3><hr><p>
<A NAME="1030718"></a>Все JavaScript-объекты появляются в коде Java как экземпляры <CODE>netscape.javascript.JSObject</CODE>. 
Когда Вы вызываете метод в Вашем Java-коде, Вы можете передать ему JavaScript-объект 
в качестве одного из аргументов. Для этого Вы обязаны определить соответствующий 
формальный параметр метода как имеющего тип <CODE>JSObject</CODE>.</p><p><A NAME="1032274"></a>
Также всегда при использовании JavaScript-объектов в Вашем Java-коде, Вы должны 
помещать вызов JavaScript-оъекта внутри блока операторов <CODE>try...catch</CODE>, 
который обрабатывает ошибки типа <CODE>netscape.javascript.JSException</CODE>. 
Это даёт Java-коду возможность обрабатывать ошибки выполнения кода JavaScript, 
которые появляются в Java как исключения типа <CODE>JSException</CODE>.</p><H4><A NAME="Head3;"></a>
<A NAME="1032291"></a>Доступ к JavaScript с помощью JSObject</H4><hr><p><A NAME="1031091"></a>
Например, Вы работаете с Java-классом <CODE>JavaDog</CODE>. Как показано в 
следующем коде, конструктор <CODE>JavaDog</CODE> принимает в качестве параметра JavaScript-объект <CODE>jsDog</CODE>, 
который определён как имеющий тип <CODE>JSObject</CODE>:</p>
<PRE><A NAME="1031092"></a>import netscape.javascript.*;<br><br>public class JavaDog<br>{<br>&nbsp;&nbsp;&nbsp;&nbsp;public String dogBreed;<br>&nbsp;&nbsp;&nbsp;&nbsp;public String dogColor;<br>&nbsp;&nbsp;&nbsp;&nbsp;public String dogSex;<br><br>&nbsp;&nbsp;&nbsp;&nbsp;// определяется конструктор класса<br>&nbsp;&nbsp;&nbsp;&nbsp;public JavaDog(JSObject jsDog)<br>&nbsp;&nbsp;&nbsp;&nbsp;{<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;// здесь используйте try...catch для обработки JSException<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;this.dogBreed = (String)jsDog.getMember("breed");<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;this.dogColor = (String)jsDog.getMember("color");<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;this.dogSex = (String)jsDog.getMember("sex");<br>&nbsp;&nbsp;&nbsp;&nbsp;}<br>}</PRE>
<p><A NAME="1031093"></a>Обратите внимание, что метод <CODE>getMember</CODE> из <CODE>JSObject</CODE> 
используется для доступа к свойствам JavaScript-объекта. Предыдущий пример 
использует <CODE>getMember</CODE> для присвоения значения JavaScript-свойства <CODE>jsDog.breed</CODE> Java-члену 
данных <CODE>JavaDog.dogBreed</CODE>.</p><BLOCKQUOTE><p><B>ПРИМЕЧАНИЕ: </B><A NAME="1034585"></a>
Лучше было бы поместить вызов <CODE>getMember</CODE> в блоке 
<CODE>try...catch</CODE> для отлова ошибок типа <CODE>JSException</CODE>. См. 
<A HREF="#1032268">"Обработка Исключений JavaScript в Java"</a>.</p></BLOCKQUOTE><p><A NAME="1030728"></a>
Чтобы лучше представить работу <CODE>getMember</CODE>, посмотрим на определение специального JavaScript-объекта <CODE>Dog</CODE>:</p>
<PRE><A NAME="1030740"></a>function Dog(breed,color,sex) {<br>&nbsp;&nbsp;&nbsp;this.breed = breed<br>&nbsp;&nbsp;&nbsp;this.color = color<br>&nbsp;&nbsp;&nbsp;this.sex = sex<br>}</PRE>
<p><A NAME="1030731"></a>Вы можете создать в JavaScript <CODE>Dog</CODE>-экземпляр <CODE>gabby</CODE>:</p>
<PRE><A NAME="1030787"></a>gabby = new Dog("lab","chocolate","female")</PRE>
<p><A NAME="1030729"></a>При вычислении <CODE>gabby.color</CODE> Вы увидите, что оно имеет значение "chocolate". 
Теперь, предположим, Вы создаёте <CODE>JavaDog</CODE>-экземпляр в Вашем JavaScript-коде, 
передавая объект <CODE>gabby</CODE> конструктору:</p><PRE><A NAME="1031134"></a>javaDog = new Packages.JavaDog(gabby)</PRE>
<p><A NAME="1030809"></a>Если Вы вычисляете <CODE>javaDog.dogColor</CODE>, Вы увидите, что оно также 
имеет значение "chocolate", поскольку метод <CODE>getMember</CODE> Java-конструктора 
присваивает свойству <CODE>dogColor</CODE> значение <CODE>gabby.color</CODE>.</p>
<H4><A NAME="Head3;"></a><A NAME="1032268"></a>Обработка исключений JavaScript в Java</H4><hr><p><A NAME="1035833"></a>
Если код JavaScript, вызванный из Java, терпит неудачу на этапе прогона, он 
вызывает исключение. Если Вы вызываете JavaScript-код из Java, Вы можете 
отловить это исключение в блоке операторов <CODE>try...catch</CODE>. Исключение JavaScript 
доступно Вашему Java-коду как экземпляр <CODE>netscape.javascript</CODE>.<CODE>JSException.<br>
JSException</CODE> это Java-оболочка вокруг исключения любого типа, вызванного JavaScript, 
аналогично тому, как <CODE>JSObject</CODE>-экземпляры являются оболочками для JavaScript-объектов.</p>
<p><A NAME="1044400"></a>Используйте <CODE>JSException</CODE> при вычислении JavaScript-кода в Java. Если JavaScript-код 
не вычисляется из-за ошибки компиляции JavaScript или какой-нибудь другой 
ошибки времени выполнения, интерпретатор JavaScript генерирует сообщение об 
ошибке, которое конвертируется в <CODE>JSException</CODE>-экземпляр.</p></P><p><A NAME="1037664"></a>
Например, Вы можете использовать <CODE>try...catch</CODE> для обработки исключений LiveConnect:</p>
<PRE><A NAME="1037674"></a>try {<br>&nbsp;&nbsp;&nbsp;global.eval("foo.bar = 999;");<br>} catch (Exception e) {<br>&nbsp;&nbsp;&nbsp;if (e instanceof JSException) {<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;jsCodeFailed()";<br>&nbsp;&nbsp;&nbsp;} else {<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;otherCodeFailed();<br>&nbsp;&nbsp;&nbsp;}<br>}</PRE>
<p><A NAME="1037731"></a>Здесь оператор <CODE>eval</CODE> терпит неудачу, если <CODE>foo</CODE> не 
определено. Блок <CODE>catch</CODE> выполняет метод <CODE>jsCodeFailed</CODE>, 
если оператор <CODE>eval</CODE> в блоке <CODE>try</CODE> вызывает <CODE>JSException</CODE>; 
метод <CODE>otherCodeFailed</CODE> выполняется, если блок <CODE>try</CODE> 
вызывает какую-нибудь другую ошибку.</p>
<H3><A NAME="Head2;"></a><A NAME="1043938"></a>Доступ к клиентскому JavaScript</H3><hr><p><A NAME="1043939"></a>
Давайте теперь отдельно рассмотрим использование Java для доступа к клиентскому JavaScript. 
Автор HTML-страницы обязан разрешить аплету доступ к JavaScript, специфицировав 
атрибут <CODE>MAYSCRIPT</CODE> тэга <CODE>&lt;APPLET&gt;</CODE>. Это 
предотвращает доступ аплета к JavaScript на странице без ведома автора страницы. 
Попытка получить доступ к JavaScript из аплета, не имеющего атрибут <CODE>MAYSCRIPT</CODE>, 
генерирует исключение. Тэг <CODE>MAYSCRIPT</CODE> нужен только для доступа Java 
к JavaScript; он не требуется для доступа JavaScript к Java.</p><H4><A NAME="Head3;"></a>
<A NAME="1043941"></a>Получение дескриптора для окна JavaScript</H4><hr><p><A NAME="1043942"></a>
Прежде чем Вы получите доступ к JavaScript в Navigator&#39;е, Вы 
обязаны получить дескриптор/handle для окна Navigator&#39;а. 
Используйте метод <CODE>getWindow</CODE> класса <CODE>netscape.javascript.JSObject</CODE> 
для получения дескриптора окна, передавая его объекту <CODE>Applet</CODE>.</p><p><A NAME="1043943"></a>
Например, если <CODE>win</CODE> это ранее объявленная переменная типа <CODE>JSObject</CODE>, 
следующий Java-код присваивает дескриптор окна переменной <CODE>win</CODE>:</p>
<PRE><A NAME="1043944"></a>public class myApplet extends Applet {<br>&nbsp;&nbsp;&nbsp;public void init() {<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;JSObject win = JSObject.getWindow(this);<br>&nbsp;&nbsp;&nbsp;}<br>}</PRE>
<H4><A NAME="Head3;"></a><A NAME="1043946"></a>Доступ к объектам и свойствам JavaScript</H4><hr><p><A NAME="1043947"></a>
Метод <CODE>getMember</CODE> класса <CODE>netscape.javascript.JSObject</CODE> 
даёт доступ к объектам и свойствам JavaScript. Вызывайте <CODE>getWindow</CODE> 
для получения дескриптора окна JavaScript, затем вызывайте <CODE>getMember</CODE> 
для доступа к каждому JavaScript-объекту. Заметьте, что JavaScript-объекты 
появляются в Java как экземпляры класса <CODE>netscape.javascript.JSObject</CODE>.</p>
<p><A NAME="1043948"></a>Например, следующий код Java даёт доступ к JavaScript-объекту <CODE>document.testForm</CODE> 
через переменную <CODE>myForm</CODE>:</p>
<PRE><A NAME="1043949"></a>public void init() {<br>&nbsp;&nbsp;&nbsp;win = JSObject.getWindow(this);<br>&nbsp;&nbsp;&nbsp;myForm=win.eval("document.testForm")<br>}</PRE>
<p><A NAME="1043950"></a>Вы могли бы использовать следующие строки вместо <CODE>myForm=win.eval("document.testForm")</CODE>:</p>
<PRE><A NAME="1043951"></a>JSObject doc = (JSObject) win.getMember("document");<br>JSObject myForm = (JSObject) doc.getMember("testForm");</PRE>
<p><A NAME="1043952"></a>Если JavaScript-объект <CODE>document.testForm.jazz</CODE> это переключатель/checkbox, 
следующий код Java даёт доступ к его свойству <CODE>checked</CODE>:</p>
<PRE><A NAME="1043953"></a>public void init() {<br>&nbsp;&nbsp;&nbsp;win = JSObject.getWindow(this);<br>&nbsp;&nbsp;&nbsp;JSObject doc = (JSObject) win.getMember("document");<br>&nbsp;&nbsp;&nbsp;JSObject myForm = (JSObject) doc.getMember("testForm");<br>&nbsp;&nbsp;&nbsp;JSObject check = (JSObject) myForm.getMember("jazz");<br>&nbsp;&nbsp;&nbsp;Boolean isChecked = (Boolean) check.getMember("checked");<br>}</PRE>
<H4><A NAME="Head3;"></a><A NAME="1043955"></a>Вызов методов JavaScript</H4><hr><p><A NAME="1043956"></a>
Метод <CODE>eval</CODE> класса <CODE>netscape.javascript.JSObject</CODE> 
позволяет вычислять произвольные выражения JavaScript. Используйте метод <CODE>getWindow</CODE> 
для получения дескриптора окна JavaScript, затем используйте <CODE>eval</CODE> для доступа к JavaScript-методу.</p>
<p><A NAME="1043957"></a>Вот синтаксис вызова методов JavaScript:</p>
<PRE><A NAME="1043958"></a>JSObject.getWindow().eval("expression")</PRE><p><A NAME="1043959"></a>
<CODE>expression</CODE> это JavaScript-выражение, которое вычисляется в вызов JavaScript-метода.</p>
<p><A NAME="1043960"></a>Например, следующий код Java использует <CODE>eval</CODE> для вызова JavaScript-метода <CODE>alert</CODE>, 
если возникает событие <CODE>MouseUp</CODE>:</p>
<PRE><A NAME="1043961"></a>public void init() {<br>&nbsp;&nbsp;&nbsp;JSObject win = JSObject.getWindow(this);<br>}</PRE><PRE><A NAME="1043962"></a>public boolean mouseUp(Event e, int x, int y) {<br>&nbsp;&nbsp;&nbsp;win.eval("alert(\"Hello world!\");");<br>&nbsp;&nbsp;&nbsp;return true;<br>}</PRE>
<p><A NAME="1043963"></a>По-другому можно вызвать JavaScript-методы <CODE>JSObject</CODE>-методом <CODE>call</CODE>. 
Используйте следующий вызов JavaScript-метода из Java, кода Вы хотите передать Java-объекты 
в качестве аргументов:</p><PRE><A NAME="1043964"></a>JSObject.call(methodName, argArray)</PRE>
<p><A NAME="1043965"></a>где <CODE>argArray</CODE> это массив Java-объектов, используемый для передачи 
аргументов JavaScript-методу.</p><p><A NAME="1043966"></a>Если Вы хотите передать примитивные значения JavaScript-методу, Вы обязаны 
использовать Java-оболочки объектов (такие как <CODE>Integer</CODE>, <CODE>Float</CODE> 
и <CODE>Boolean</CODE>), а затем наполнить <CODE>Array</CODE> такими объектами.</p>
<h6><A NAME="Head4;"></a><A NAME="1043968"></a>Пример: Hello World</h6><p><A NAME="1043969"></a>
Вернёмся к примеру HelloWorld, изменим метод <CODE>paint</CODE> в коде Java 
таким образом, чтобы он вызывал JavaScript-метод <CODE>alert</CODE> (с 
сообщением "Painting!"):</p><PRE><A NAME="1043970"></a>public void paint(Graphics g) {<br>&nbsp;&nbsp;&nbsp;g.drawString(myString, 25, 20);<br>&nbsp;&nbsp;&nbsp;JSObject win = JSObject.getWindow(this);<br>&nbsp;&nbsp;&nbsp;String args[] = {"Painting!"};<br>&nbsp;&nbsp;&nbsp;win.call("alert", args);<br>}</PRE>
<p><A NAME="1043971"></a>Затем добавим атрибут <CODE>MAYSCRIPT</CODE> в тэг <CODE>&lt;APPLET&gt;</CODE> 
на HTML-странице, рекомпилируем аплет и запустим его. При каждой прорисовке 
аплета (когда он инициализируется, когда Вы вводите новое текстовое значение и 
когда страница перезагружается) выводится JavaScript-бокс alert. Это простая иллюстрация вызова JavaScript из Java.</p>
<p><A NAME="1043972"></a>Можно добиться того же эффекта таким образом:</p>
<PRE><A NAME="1043973"></a>public void paint(Graphics g) {<br>&nbsp;&nbsp;&nbsp;g.drawString(myString, 25, 20);<br>&nbsp;&nbsp;&nbsp;JSObject win = JSObject.getWindow(this);<br>&nbsp;&nbsp;&nbsp;win.eval("alert('Painting')");<br>}</PRE><BLOCKQUOTE>
<p><B>ПРИМЕЧАНИЕ: </B><A NAME="1043975"></a>
Может понадобиться перезагрузка HTML-страницы путём выбора Open Page в меню File 
вместо щелчка по кнопке Reload, чтобы гарантировать реинициализацию аплета.</p></BLOCKQUOTE>
<h6><A NAME="Head4;"></a><A NAME="1043977"></a>Вызов пользовательский функций</h6><p><A NAME="1043978"></a>
Вы можете также вызвать определённые пользователем функции из Java-аплета. Например, 
добавьте следующую функцию в <CODE>&lt;HEAD&gt;</CODE> HTML-страницы с аплетом HelloWorld:</p>
<PRE><A NAME="1043979"></a>&lt;SCRIPT&gt;<br>function test() {<br>&nbsp;&nbsp;&nbsp;alert("You are using " + navigator.appName + " " + <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;navigator.appVersion)<br>}<br>&lt;/SCRIPT&gt;</PRE>
<p><A NAME="1043980"></a>Эта простая функция выведет диалог alert, содержащий имя и версию используемого 
клиентского программного обеспечения. Затем измените метод <CODE>init</CODE> в 
Вашем Java-коде аналогично тому, как Вы изменили <CODE>paint</CODE>:</p>
<PRE><A NAME="1043981"></a>public void init() {<br>&nbsp;&nbsp;&nbsp;myString = new String("Hello, world!")<br>&nbsp;&nbsp;&nbsp;JSObject win = JSObject.getWindow(this)<br>&nbsp;&nbsp;&nbsp;String args2[] = {""}<br>&nbsp;&nbsp;&nbsp;win.call("test", args2)<br>}</PRE>
<p><A NAME="1043982"></a>Заметьте, что <CODE>args2</CODE> объявлен как массив без элементов, хотя этот 
метод не принимает аргументов. Когда Вы рекомпилируете аплет и перезагрузите HTML-страницу (и 
реинициализируете аплет), JavaScript-диалог alert выведет версию Navigator&#39;а, 
который запущен у Вас. Это простая иллюстрация вызова пользовательской функции из Java.</p>
<H2><A NAME="Data Type Conversions"><A NAME="1037078"></a>Конвертация типов данных</H2><hr>
<p><A NAME="1037079"></a>Поскольку Java является строго типизированным языком, а JavaScript типизирован 
слабо, машина выполнения JavaScript конвертирует значения аргументов в подходящие типы данных других 
языков, когда Вы используете LiveConnect. Эта конвертация рассматривается в следующих разделах:</p>
<ul><LI><A NAME="1037083"></a><A HREF="#1037090">Конвертация JavaScript в Java</a></LI><LI><A NAME="1037087"></a>
<A HREF="#1037422">Конвертация Java в JavaScript</a></LI></ul><H3><A NAME="Head2;"></a>
<A NAME="1037090"></a>Конвертация JavaScript в Java</H3><hr><p><A NAME="1037091"></a>
Если Вы вызываете Java-метод и передаёте ему параметры из JavaScript, тип 
передаваемых параметров конвертируется в соответствии с правилами, описанными в следующих разделах:</p>
<ul><LI><A NAME="1037095"></a><a href="#1037125">Числа</a></LI><LI><A NAME="1037099"></a>
<a href="#1037169">Булевы</a></LI><LI><A NAME="1037103"></a><a href="#1037205">Строки</a></LI><LI><A NAME="1037107"></a>
<A HREF="#1037248">Undefined-значения</a></LI><LI><A NAME="1037111"></a><A HREF="#1037281">Null-значения</a></LI><LI><A NAME="1037115"></a>
<A HREF="#1037309">Объекты JavaArray и JavaObject</a></LI><LI><A NAME="1037119"></a><A HREF="#1037349">JavaClass-объекты</a></LI><LI><A NAME="1037123"></a>
<A HREF="#1037380">Другие объекты JavaScript</a></LI></ul><p><A NAME="1037595"></a>Return-значения методов <CODE>netscape.javascript.JSObject</CODE> 
всегда конвертируются в экземпляры <CODE>java.lang.Object</CODE>. Правила конвертации этих return-значений также описаны в этих разделах.</p>
<p><A NAME="1037627"></a>Например, если <CODE>JSObject.eval</CODE> возвращает JavaScript-число, Вы можете 
найти правило конвертации этого числа в экземпляр <CODE>java.lang.Object</CODE> в разделе <A HREF="#1037125">&quot;Числа"</a>.</p>
<H4><A NAME="Head3;"></a><A NAME="1037125"></a>Числа</H4><hr><p><A NAME="1037126"></a>
Если Вы передаёте числовые типы JavaScript в качестве параметров Java-методам, Java конвертирует значения таким образом:</p>
<A NAME="1037166"></a><TABLE BORDER="2" CELLPADDING=5><TR><TH><A NAME="1037129"></a>
Тип Java-парамера<TH><A NAME="1037131"></a>Правила конвертации<TR><TD><P><A NAME="1037133"></a>double</P><TD><P><A NAME="1037135"></a>
Точное значение переносится в Java без округления и потери точности или знака.</P><TR><TD><P><A NAME="1037137"></a>
<CODE>lava.lang.Double<br>java.lang.Object</CODE></P><TD><P><A NAME="1037140"></a>
Создаётся новый <CODE>java.lang.Double</CODE> -экземпляр, точное значение 
переносится в Java без округления и потери точности или знака.</P><TR><TD><P><A NAME="1037142"></a>float</P><TD><ul><LI><A NAME="1037144"></a>
Значения округляются до float-точности.<LI><A NAME="1037145"></a>
Значения, которые слишком велики или малы, округляются до +infinity или -infinity.</ul><TR><TD><P><A NAME="1037147"></a>
byte<br>char<br>int<br>long<br>short</P><TD><ul><LI><A NAME="1037153"></a>
Значения округляются с использованием режима round-to-negative-infinity.<LI><A NAME="1037154"></a>
Значения, которые слишком велики или малы, дают ошибку времени выполнения.<LI><A NAME="1037155"></a>
<CODE>NaN</CODE>-значения конвертируются в 0.</ul><TR><TD><P><A NAME="1037157"></a>
<CODE>java.lang.String</CODE></P><TD><P><A NAME="1037159"></a>
Значения конвертируются в строки. Например,</P><ul><LI><A NAME="1037160"></a>237 становится "237"</ul>
<TR><TD><P><A NAME="1037162"></a>boolean</P><TD><ul></P><LI><A NAME="1037164"></a>
Значения 0 и <CODE>NaN</CODE> конвертируются в false.<LI><A NAME="1037165"></a>Другие значения конвертируются в true.</ul></TABLE>
<p><A NAME="1037167"></a>Если JavaScript-число передаётся как параметр в Java-метод, ожидающий экземпляр <CODE>java.lang.String</CODE>, 
число конвертируется в строку. Используйте операцию == для сравнения результата конвертации с другими строковыми значениями.</p>
<H4><A NAME="Head3;"></a><A NAME="1037169"></a>Булевы</H4><hr><p><A NAME="1037170"></a>
Если Вы передаёте Булев тип JavaScript в качестве параметра Java-методам, Java конвертирует значения таким образом:</p>
<A NAME="1037202"></a><TABLE BORDER="2" CELLPADDING=5>
<TR><TH><A NAME="1037173"></a>Тип Java-параметра<TH><A NAME="1037175"></a>
Правила конвертации<TR><TD><P><A NAME="1037177"></a>boolean</P><TD><P><A NAME="1037179"></a>
Все значения конвертируются напрямую в Java-эквиваленты.</P><TR><TD><P><A NAME="1037181"></a>
<CODE>lava.lang.Boolean<br>java.lang.Object</CODE></P><TD><P><A NAME="1037184"></a>
Создаётся новый экземпляр <CODE>java.lang.Boolean</CODE>. Каждый параметр 
создаёт новый экземпляр, а не один экземпляр, того же примитивного типа.</P><TR><TD><P><A NAME="1037525"></a>
<CODE>java.lang.String</CODE></P><TD><P><A NAME="1037527"></a>Значения конвертируются в строки. Например:</P><ul></P><LI><A NAME="1037528"></a>
true становится "true"<LI><A NAME="1037529"></a>false становится "false"</ul><TR><TD><P><A NAME="1037186"></a>
byte<br>char<br>double<br>float<br>int<br>long<br>short</P><TD><ul></P><LI><A NAME="1037194"></a>
true становится 1</P><LI><A NAME="1037195"></a>false становится 0</ul></TABLE><p><A NAME="1037203"></a>
Если JavaScript Boolean передаётся в качестве параметра Java-методу, который ожидает экземпляр <CODE>java.lang.String</CODE>,  Boolean 
конвертируется в строку. Используйте операцию == для сравнения результата конвертации с другими строковыми значениями.</p>
<H4><A NAME="Head3;"></a><A NAME="1037205"></a>Строковые</H4><hr><p><A NAME="1037206"></a>
Если Вы передаёте строковые значения JavaScript в качестве параметров Java-методам, Java конвертирует значения так:</p>
<A NAME="1037246"></a><TABLE BORDER="2" CELLPADDING=5><TR><TH><A NAME="1037209"></a>
<B>Тип Java-параметра</B><TH><A NAME="1037211"></a><B>Правила конвертации><TR><TD><P><A NAME="1037534"></a>
<CODE>lava.lang.String<br>java.lang.Object</CODE></P><TD><P><A NAME="1037540"></a>
Строка JavaScript конвертируется в экземпляр <CODE>java.lang.String</CODE> с ASCII-значением.</P><TR><TD><P><A NAME="1037546"></a>
byte<br>double<br>float<br>int<br>long<br>short</P><TD><P><A NAME="1037553"></a>
Все значения конвертируются в числа, как описано в спецификации <A HREF="http://developer.netscape.com/docs/javascript/e262-pdf.pdf" TARGET="_top">ECMA-262</a>.</P>
<TR><TD><P><A NAME="1037559"></a>char</P><TD><P><A NAME="1037565"></a>Все значения конвертируются в числа.</P>
<TR><TD><P><A NAME="1037213"></a>boolean</P><TD><ul><LI><A NAME="1037215"></a>
Пустая строка становится false.<LI><A NAME="1037216"></a>Все другие значения становятся true.</ul></TABLE>
<H4><A NAME="Head3;"></a><A NAME="1037248"></a>Undefined-значения</H4><hr><p><A NAME="1037249"></a>
Если Вы передаёте undefined-значения JavaScript в качестве параметров Java-методам, Java конвертирует значения так:</p>
<A NAME="1037277"></a><TABLE BORDER="2" CELLPADDING=5><TR><TH><A NAME="1037252"></a>Тип Java-параметра
<TH><A NAME="1037254"></a>Правила конвертации<TR><TD><P><A NAME="1037507"></a>
<CODE>lava.lang.String<br>java.lang.Object</CODE></P><TD><P><A NAME="1037510"></a>
Значение конвертируется в экземпляр java.lang.String, значением которого становится строка "undefined".</P>
<TR><TD><P><A NAME="1037256"></a>boolean</P><TD><P><A NAME="1037258"></a>Значение становится false.</P>
<TR><TD><P><A NAME="1037516"></a>double<br>float</P><TD><P><A NAME="1037519"></a>
Значение становится <CODE>NaN</CODE>.</P><TR><TD><P><A NAME="1037265"></a>
byte<br>char<br>int<br>long<br>short</P><TD><P><A NAME="1037271"></a>Значение становится 0.</P></TABLE>
<p><A NAME="1037278"></a>Конвертация undefined-значений возможна только в JavaScript 1.3. Предыдущие 
версии JavaScript не поддерживают значение undefined.</p><p><A NAME="1037279"></a>
Если JavaScript-значение undefined  передаётся в качестве параметра Java-методу, который ожидает экземпляр <CODE>java.lang.String</CODE>, 
значение undefined конвертируется в строку. Используйте операцию == для 
сравнения результата конвертации с другими строковыми значениями.</p><H4><A NAME="Head3;"></a>
<A NAME="1037281"></a>Null-значения</H4><hr><p><A NAME="1037282"></a>
Если Вы передаёте null-значения JavaScript в качестве параметров Java-методам, Java конвертирует значения так:</p>
<A NAME="1037307"></a><TABLE BORDER="2" CELLPADDING=5><TR><TH><A NAME="1037285"></a>
Тип Java-параметра<TH><B><A NAME="1037287"></a>Правила конвертации<TR><TD><P><A NAME="1037568"></a>
    Любой класс<br>Интерфейс любого типа</P><TD><P><A NAME="1037571"></a>Значение становится null.</P>
<TR><TD><P><A NAME="1042434"></a>byte<br>char<br>double<br>float<br>int<br>long<br>short</P><TD><P><A NAME="1037581"></a>
Значение становится 0.</P><TR><TD><P><A NAME="1037289"></a>boolean</P><TD><P><A NAME="1037291"></a>
Значение становится false.</P></TABLE><H4><A NAME="Head3;"></a><A NAME="1037309"></a>Объекты JavaArray и JavaObject</H4>
<hr><p><A NAME="1037310"></a>В большинстве случаев, если Вы передаёте JavaScript <CODE>JavaArray</CODE> или <CODE>JavaObject</CODE> 
в качестве параметров Java-методу, Java просто снимает оболочку с объекта; 
иногда объект приводится к другому типу данных в соответствии с правила из таблицы:</p><A NAME="1037345"></a>
<TABLE BORDER="2" CELLPADDING=5><TR><TH><A NAME="1037313"></a>Тип Java-параметра<TH><A NAME="1037315"></a>
Правила конвертации<TR><TD><P><A NAME="1037317"></a>Любой интерфейс или класс, который совместим при присвоении с развёрнутым 
объектом.</P><TD><P><A NAME="1037319"></a>Оболочка с объекта снимается.</P><TR><TD><P><A NAME="1037321"></a>
<CODE>java.lang.String</CODE></P><TD><P><A NAME="1037323"></a>
Оболочка с объекта снимается, вызывается метод <CODE>toString</CODE> 
развёрнутого Java-объекта, результат возвращается как новый экземпляр <CODE>java.lang.String</CODE>.</P>
<TR><TD><P><A NAME="1037325"></a>byte<br>char<br>double<br>float<br>int<br>long<br>short</P><TD><P><A NAME="1037333"></a>
Оболочка с объекта снимается, и возникает одна из следующих ситуаций:</P><ul><LI><A NAME="1037334"></a>
Если развёрнутый Java-объект имеет метод <CODE>doubleValue</CODE>, <CODE>JavaArray</CODE> 
или <CODE>JavaObject</CODE> конвертируется в значение, возвращаемое этим методом.<LI><A NAME="1037335"></a>
Если развёрнутый Java-объект не имеет метода <CODE>doubleValue</CODE>, возникает ошибка.</ul>
<TR><TD><P><A NAME="1037337"></a>boolean</P><TD><P><A NAME="1037339"></a>
Оболочка с объекта снимается, и возникает одна из следующих ситуаций:</P><ul><LI><A NAME="1037340"></a>
Если объект null, он конвертируется в false.<LI><A NAME="1037341"></a>
Если объект имеет любое другое значение, он конвертируется в true.</ul><P><A NAME="1037342"></a>
</P><P><A NAME="1040810"></a>В JavaScript 1.2 и ранее - оболочка с объекта снимается, и возникает одна из 
следующих ситуаций:</P><ul><LI><A NAME="1037343"></a>
Если развёрнутый объект имеет метод booleanValue, исходный объект конвертируется в return-значение.<LI><A NAME="1037344"></a>
Если развёрнутый объект не имеет метода booleanValue, конвертация терпит неудачу.</ul></TABLE>
<p><A NAME="1037346"></a>Интерфейс или класс совместимы при присвоении, если развёрнутый объект является 
экземпляром типа Java-параметра. То есть следующий оператор обязан возвратить true:</p>
<PRE><A NAME="1037347"></a><I>unwrappedObject</I> instanceof <I>parameterType</I></PRE>
<H4><A NAME="Head3;"></a><A NAME="1037349"></a>JavaClass-объекты</H4><hr><p><A NAME="1037350"></a>
Если Вы передаёте JavaScript <CODE>JavaClass</CODE>-объект как параметр Java-методу, Java 
конвертирует этот объект в соответствии со следующими правилами:</p><A NAME="1037378"></a>
<TABLE BORDER="2" CELLPADDING=5><TR><TH><A NAME="1037353"></a>Тип Java-параметра
<TH><A NAME="1037355"></a>Правила конвертации<TR><TD><P><A NAME="1037357"></a><CODE>java.lang.Class</CODE></P><TD><P><A NAME="1037359"></a>
Оболочка с объекта снимается.</P><TR><TD><P><A NAME="1037361"></a>
<CODE>java.lang.JSObject<br>java.lang.Object</CODE></P><TD><P><A NAME="1037364"></a>
Объект <CODE>JavaClass</CODE> оборачивается в новый экземпляр <CODE>java.lang.JSObject</CODE>.</P>
<TR><TD><P><A NAME="1037366"></a><CODE>java.lang.String</CODE></P><TD><P><A NAME="1037368"></a>
Оболочка с объекта снимается, вызывается метод <CODE>toString</CODE> 
развёрнутого Java-объекта, результат возвращается как новый экземпляр <CODE>java.lang.String</CODE>.</P>
<TR><TD><P><A NAME="1037370"></a>boolean</P><TD><P><A NAME="1037372"></a>
Оболочка с объекта снимается и возникает одна из следующих ситуаций:</P><ul><LI><A NAME="1037373"></a>
Если объект null, он конвертируется в false.<LI><A NAME="1037374"></a>
Если объект имеет какое-нибудь другое значение, он конвертируется в true.</ul><P><A NAME="1037375"></a>
</P><P><A NAME="1040812"></a>В JavaScript 1.2 и ранее - оболочка с объекта снимается, и возникает одна из 
следующих ситуаций:</P><ul><LI><A NAME="1037376"></a>Если развёрнутый объект имеет метод booleanValue, исходный объект 
конвертируется в return-значение.<LI>Если развёрнутый объект не имеет метода booleanValue, конвертация терпит неудачу.</ul></TABLE>
<H4><A NAME="Head3;"></a><A NAME="1037380"></a>Другие объекты JavaScript</H4><hr><p><A NAME="1037381"></a>
Если Вы передаёте любой другой объект JavaScript в качестве параметра Java-методу, Java 
конвертирует этот объект в соответствии со следующими правилами:</p><A NAME="1037419"></a>
<TABLE BORDER="2" CELLPADDING=5><TR><TH><A NAME="1037384"></a>Тип Java-параметра
<TH><B><A NAME="1037386"></a>Правила конвертации<TR><TD><P><A NAME="1037388"></a>
<CODE>java.lang.JSObject<br>java.lang.Object</CODE></P><TD><P><A NAME="1037391"></a>
Объект оборачивается в новый экземпляр<CODE> java.lang.JSObject</CODE>.</P><TR><TD><P><A NAME="1037393"></a>
<CODE>java.lang.String</CODE></P><TD><P><A NAME="1037395"></a>
Оболочка с объекта снимается, вызывается метод <CODE>toString</CODE> 
развёрнутого Java-объекта, результат возвращается как новый экземпляр <CODE>java.lang.String</CODE>.</P>
<TR><TD><P><A NAME="1037397"></a>byte<br>char<br>double<br>float<br>int<br>long<br>short</P><TD><P><A NAME="1037405"></a>
Объект конвертируется в значение с использованием логики оператора <CODE>ToPrimitive</CODE>, 
описанного в <A HREF="http://developer.netscape.com/docs/javascript/e262-pdf.pdf" TARGET="_top">ECMA-262</a>. 
Подсказка <I>PreferredType</I>, используемая с этим оператором, это Number.</P>
<TR><TD><P><A NAME="1037411"></a>boolean</P><TD><P><A NAME="1037413"></a>
Оболочка с объекта снимается и возникает одна из следующих ситуаций:</P><ul><LI><A NAME="1037414"></a>
Если объект null, он конвертируется в false.<LI><A NAME="1037415"></a>
Если объект имеет какое-нибудь другое значение, он конвертируется в true.</ul><P><A NAME="1037416"></a></P><P><A NAME="1040814"></a>
В JavaScript 1.2 и ранее - оболочка с объекта снимается, и возникает одна из 
следующих ситуаций:</P><ul><LI><A NAME="1037417"></a>
Если развёрнутый&nbsp; объект имеет метод booleanValue, исходный объект конвертируется в return-значение.<LI><A NAME="1037418"></a>
Если развёрнутый&nbsp; объект не имеет метода booleanValue, конвертация терпит неудачу.</ul></TABLE>
<H3><A NAME="Head2;"></a><A NAME="1037422"></a>Конвертация из Java а JavaScript</H3><hr><p><A NAME="1037423"></a>
Передаваемые из Java в JavaScript значения конвертируются так:</p><ul><LI><A NAME="1037424"></a>
Java byte, char, short, int, long, float и double конвертируются в числа JavaScript.</LI><LI><A NAME="1037425"></a>
Java boolean конвертируется в JavaScript boolean.</LI><LI><A NAME="1037426"></a>
Объект класса <CODE>netscape.javascript.JSObject</CODE> конвертируется в 
оригинальный JavaScript-объект.</LI><LI><A NAME="1037427"></a>
Массивы Java конвертируются в JavaScript псевдо-Array-объект; этот объект ведёт себя так 
же, как и JavaScript-объект <CODE>Array</CODE>: Вы может получить доступ к 
нему с синтаксисом <CODE>arrayName[index]</CODE> (где <CODE>index</CODE> это 
целое число) и определить его размер с помощью <CODE>arrayName.length</CODE>.</LI><LI><A NAME="1037428"></a>
Java-объект любого другого класса конвертируется в JavaScript-объект-оболочку, 
который может использоваться для доступа к методам и полям Java-объекта:</LI><ul>
<LI><A NAME="1037430"></a>Конвертация этой оболочки в строку вызывает метод <CODE>toString</CODE> 
объекта-оригинала.</LI><LI><A NAME="1037432"></a>
<CODE></CODE>Конвертация в число вызывает метод <CODE>doubleValue</CODE>, если 
возможно, иначе терпит неудачу.</LI><LI><A NAME="1037460"></a>
Конвертация в boolean в JavaScript 1.3 возвращает false, если объект null, иначе 
- true.</LI><LI><A NAME="1037434"></a>
Конвертация в boolean в JavaScript 1.2 и в более ранних версиях вызывает метод <CODE>booleanValue</CODE>, 
если возможно, иначе терпит неудачу.</LI><P><A NAME="1037436"></a>
Заметьте, что экземпляры java.lang.Double и java.lang.Integer конвертируются в JavaScript-объекты, 
а не в числа JavaScript. Аналогично, экземпляры 
java.lang.String также конвертируются в объекты JavaScript, а не в строки JavaScript.</P></ul></ul><p><A NAME="1037437"></a>
Java <CODE>String</CODE>-объекты также соответствуют JavaScript-оболочкам. Если Вы 
вызываете JavaScript-метод, который требует JavaScript-строку и передаёт её 
оболочке, Вы получите ошибку. Вместо этого конвертируйте оболочку в JavaScript-строку, 
присоединяя к ней пустую строку, как показано здесь:</p>
<PRE><A NAME="1037438"></a>var JavaString = JavaObj.methodThatReturnsAString();<br>var JavaScriptString = JavaString + "";</PRE>
<h5><a href="contents.php">Оглавление</a> | <a href="partlc.php">Назад</a>
| <a href="liveaud.php">Вперёд</a> | <a href="bklast.php">Индекс</a></h5>
<hr></BODY></HTML>
<?
include_once '../../sys/inc/tfoot.php';
?>