<?
include_once '../../sys/inc/start.php';
include_once '../../sys/inc/compress.php';
include_once '../../sys/inc/sess.php';
include_once '../../sys/inc/home.php';
include_once '../../sys/inc/settings.php';
include_once '../../sys/inc/db_connect.php';
include_once '../../sys/inc/ipua.php';
include_once '../../sys/inc/fnc.php';
include_once '../../sys/inc/user.php';
$set['title']='Учебник JavaScript';
include_once '../../sys/inc/thead.php';
title();
err();
//aut();
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<phpl<TITLE>Mail-Фильтры</TITLE>
<BODY>
<h5><a href="contents.php">Оглавление</a> | <a href="partapp.php">Назад</a>
| <a href="console.php">Вперёд</a> | <a href="bklast.php">Индекс</a></h5><HR>
<h1>Приложение A<BR><a name="1039624"></a>Почтовые Фильтры</h1><p><A NAME="1039890"></a>
В этом приложении показано, как применять JavaScript для фильтрации входящей почты и новостей при использовании Netscape Messenger.</p>
<p><A NAME="1043139"></a>Процесс фильтрации состоит из двух этапов:</p><OL><LI><A NAME="1042799"></a>
  Написать функцию JavaScript для работы в качестве фильтра и поместить её в файл 
фильтров. Эта функция принимает один аргумент, объект сообщения, и может 
изменять это сообщение.<LI><A NAME="1042887"></a>
  Добавить вхождения этой JavaScript-функции в файл правил/mail rules file. Ваш rules-файл 
может содержать несколько фильтров. Messenger применяет каждый фильтр к 
сообщению, пока один из них не сработает.</LI></OL><p><A NAME="1044807"></a>В приложении имеются следующие разделы:</p>
<ul><LI><A NAME="1044811"></a><A HREF="#1040050">Создание фильтра и добавление его в rules-файл</a></LI><LI><A NAME="1044858"></a>
<a href="#1040117">Фильтры новостей</a></LI><LI><A NAME="1044873"></a>
<a href="#1040124">Обращение к объекту сообщения</a></LI><LI><A NAME="1044888"></a>
<a href="#1040178">Отладка фильтров</a></LI><LI><A NAME="1044973"></a>
<a href="#1040193">Более сложный пример</a></LI></ul><H2><A NAME="Creating the Filter and Adding to Your Rules File">
<A NAME="1040050"></a>Создание фильтра и добавление его в rules-файл</H2><hr><p><A NAME="1042457"></a>
Сначала нужно написать файл <CODE>filters.js</CODE>. Он содержит функции JavaScript, 
которые выполняют фильтрацию почты. Эти функции могут использовать все 
возможности клиентского JavaScript. Размещение этого файла зависит от платформы, как показано в следующей таблице.</p><A NAME="1044304"></a>
<TABLE BORDER="2" CELLPADDING=5><TR><TH><A NAME="1042025"></a>Платформа<TH><A NAME="1042027"></a>
Размещение файла<TR><TD><P><A NAME="1042015"></a>Unix</P><TD><P><A NAME="1042004"></a>
<CODE>$(HOME)/.netscape/filters.js</CODE></P><P><A NAME="1042422"></a>
где <CODE>$(HOME)</CODE> это директория, в которой установлен Navigator.</P><TR><TD><P><A NAME="1042048"></a>
Windows</P><TD><P><A NAME="1042050"></a>\Program Files\Communicator\Users\<I>&lt;username&gt;</I>\Mail\filters.js</P>
<TR><TD><P><A NAME="1042081"></a>Macintosh</P><TD><P><A NAME="1042083"></a>filters.js в корневой директории каталога Вашего профиля.</P></TABLE>
<p><A NAME="1040335"></a>Вот пример простого файла фильтра. Он сохраняет все сообщения от my_mom в папке "FromMom" 
и помечает их как имеющие приоритет high. Он также высылает все сообщения из my_sister в папку trash.</p>
<PRE><A NAME="1040059"></a>// файл filters.js
<br>function MomFilter(message) {<br>&nbsp;&nbsp;&nbsp;if (message.from.indexOf("my_mom@mothers.net") != -1) {<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;message.priority = "High";<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;message.folder = "mailbox:FromMom";<br>&nbsp;&nbsp;&nbsp;}<br>&nbsp;&nbsp;&nbsp;else if (message.subject.indexOf("my_sister@sisters.net") != -1) {<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;message.trash();<br>&nbsp;&nbsp;&nbsp;}<br>}</PRE><BLOCKQUOTE>
<p><B>ПРИМЕЧАНИЕ: </B><A NAME="1042765"></a>Нет способа специфицировать папку IMAP через использование синтаксиса <CODE>mailbox:</CODE>. 
Поэтому, если Вы перераспределяете что-либо с использованием IMAP, всё это будет происходить на Вашей локальной машине.</p></BLOCKQUOTE>
<p><A NAME="1042488"></a>После того как функция фильтра JavaScript написана, Вы добавляете ссылку на этот 
фильтр в  Ваш файл почтовых правил/mail rules file. Размещение rules-файла 
также зависит от платформы, как показано в следующей таблице.</p><A NAME="1044338"></a>
<TABLE BORDER="2" CELLPADDING=5><TR><TH><A NAME="1042392"></a>
Платформа<TH><A NAME="1042394"></a>Размещение файла<TR><TD><P><A NAME="1042396"></a>
Unix</P><TD><PRE><A NAME="1042398"></a>$(HOME)/.netscape/mailrule
<A NAME="1042423"></a>где <CODE>$(HOME)</CODE> это директория, в которой установлен Navigator.</PRE>
<TR><TD><P><A NAME="1042400"></a>Windows</P><TD><P><A NAME="1042402"></a>
<CODE>\Program Files\Communicator\Users\</CODE><I><CODE>&lt;username&gt;</CODE></I><CODE>\Mail\rules.dat</CODE> </P>
<TR><TD><P><A NAME="1042404"></a>Macintosh</P><TD><P><A NAME="1042406"></a><CODE>Filter Rules</CODE> в корневой директории каталога Вашего профиля.</P></TABLE>
<p><A NAME="1040085"></a>Как  правило этот файл записывается системой фильтрации Netscape Messenger'а. 
Если у Вас уже есть файл фильтров, добавьте в него следующие строки:</p>
<PRE><A NAME="1040089"></a>name="<I>filterName</I>"<br>enabled="yes"<br>type="2"<br>scriptName="<I>scriptName</I>"</PRE>
<p><A NAME="1040094"></a>где</p><A NAME="1044347"></a>
<TABLE border="1" frame="hsides" rules="rows" style="border-collapse: collapse" bordercolor="#111111" width="80%">
<TR><TD><PRE><A NAME="1042895"></a>name="<I>filterName</I>"</PRE><TD><P><A NAME="1042897"></a>
Описательное имя фильтра.</P><TR><TD><PRE><A NAME="1042899"></a>enabled="yes"</PRE><TD><P><A NAME="1042901"></a>
Использовать этот фильтр. Для отключения фильтра запишите <CODE>enabled="no"</CODE>.</P>
<TR><TD><PRE><A NAME="1042903"></a>type="2"</PRE><TD><P><A NAME="1042905"></a>
Пометить этот фильтр как фильтр JavaScript. </P>
<TR><TD><PRE><A NAME="1042907"></a>scriptName="<I>scriptName</I>"</PRE><TD><P><A NAME="1042909"></a>Выполняемая функция JavaScript. </P></TABLE>
<p><A NAME="1042570"></a>Реальный ввод может быть таким:</p>
<PRE><A NAME="1040098"></a>name="Filter for Mom"<br>enabled="yes"<br>type="2"<br>scriptName="MomFilter"</PRE>
<p><A NAME="1040106"></a>Вы можете добавлять несколько таких групп строк в Ваш rules-файл, добавляя таким 
образом несколько фильтров. Они выполняются в указанном в файле порядке, пока 
один из ник не выполнит действия над сообщением (установит свойство или вызовет метод).</p><p><A NAME="1040111"></a>
Если у Вас ещё нет rule-файла почты, Вы должны будете добавить две строки вверху 
файла (до любых ссылок на фильтры):</p><PRE><A NAME="1040114"></a>version="6"<br>logging="no"</PRE>
<H2><A NAME="News Filters"><A NAME="1040117"></a>Фильтры новостей</H2><hr><p><A NAME="1040119"></a>
Всё сказанное выше rule-файла относится и к фильтрам новостей. Единственное&nbsp; 
отличие - в строке <CODE>type</CODE>. Для фильтров почты Вы используете <CODE>type="2"</CODE>. 
Для фильтров новостей Вы используете <CODE>type="8"</CODE>.</p><H2><A NAME="Message Object Reference">
<A NAME="1040124"></a>Обращение к объекту сообщения</H2><hr><p><A NAME="1040126"></a>
Функции фильтра принимают один аргумент, объект сообщения. Для фильтров новостей 
это объект News Message, а для фильтров почты - объект Mail Message.</p><H3><A NAME="Head2;"></a>
<A NAME="1040130"></a>Почтовые сообщения</H3><hr><p><A NAME="1040132"></a>Объект почтового сообщения имеет следующие методы:</p>
<A NAME="1044380"></a><TABLE BORDER="2" CELLPADDING=5><TR><TH><A NAME="1040959"></a>Метод<TH><A NAME="1040961"></a>
Описание<TR><TD><PRE><A NAME="1040963"></a>killThread()</PRE><TD><P><A NAME="1040965"></a>
Помечает поток как игнорируемый.</P><TR><TD><PRE><A NAME="1040967"></a>watchThread()</PRE><TD><P><A NAME="1040969"></a>
Помечает поток как наблюдаемый.</P><TR><TD><PRE><A NAME="1040971"></a>trash()</PRE><TD><P><A NAME="1040973"></a>
Помечает сообщение как прочитанное и перемещает его в папку trash/мусор.</P></TABLE>
<p><A NAME="1040138"></a>Объект почтового сообщения имеет следующие свойства:</p><A NAME="1044402"></a>
<TABLE BORDER="2" CELLPADDING=5><TR><TH><A NAME="1041041"></a>Свойство<TH><A NAME="1041043"></a>
Описание<TR><TD><PRE><A NAME="1041045"></a>folder</PRE><TD><P><A NAME="1041047"></a>Папка, содержащая данное сообщение.</P>
<TR><TD><PRE><A NAME="1041049"></a>read</PRE><TD><P><A NAME="1041051"></a>Прочитано сообщение или нет.</P>
<TR><TD><PRE><A NAME="1041053"></a>priority</PRE><TD><P><A NAME="1041055"></a>Приоритет сообщения.</P></TABLE>
<p><A NAME="1040144"></a>Для перемещения почтового сообщения Вы устанавливаете свойство <CODE>folder</CODE> 
объекта сообщения. Можно использовать полный путь или синтаксис <CODE>mailbox:</CODE> 
в URL для специфицирования папки назначения.</p>
<p><A NAME="1040148"></a>Свойство priority можно устанавливать, используя целые числа или строки. Возможные значения:</p>
<ul><LI><A NAME="1040150"></a>None</LI><LI><A NAME="1041115"></a>Lowest</LI><LI><A NAME="1041124"></a>
Low</LI><LI><A NAME="1041133"></a>Normal</LI><LI><A NAME="1041142"></a>High</LI><LI><A NAME="1041151"></a>
Highest</LI></ul><H4><A NAME="Head3;"></a><A NAME="1040157"></a>Шапки/Headers сообщений</H4><hr><p><A NAME="1040158"></a>
Помимо свойств, приведённых выше, объект почтового сообщения предоставляет все 
шапки /headers сообщения как свойства только для чтения. Так, тема сообщения 
может быть получена как <CODE>message.subject</CODE>, а список CC как <CODE>message.cc</CODE>. 
Шапки с дефисами в именах (как <CODE>Resent-from</CODE>) не могут быть получены 
с dot-синтаксисом. Запрашивайте их с использованием 
синтаксиса массива для значения свойства (как <CODE>message["Resent-from"]</CODE>).</p>
<H3><A NAME="Head2;"></a><A NAME="1040164"></a>Сообщение новостей</H3><hr><p><A NAME="1040166"></a>
Объект сообщения новостей/News Message имеет следующие методы:</p><A NAME="1044413"></a><TABLE BORDER="2" CELLPADDING=5>
<TR><TH><A NAME="1041203"></a>Метод<TH><A NAME="1041205"></a>
Описание<TR><TD><PRE><A NAME="1041207"></a>killThread()</PRE><TD><P><A NAME="1041209"></a>Помечает поток как игнорируемый.</P>
<TR><TD><PRE><A NAME="1041211"></a>watchThread()</PRE><TD><P><A NAME="1041213"></a>Помечает поток как наблюдаемый.</P></TABLE>
<p><A NAME="1040171"></a>Объект сообщения новостей имеет следующие свойства:</p><A NAME="1044433"></a>
<TABLE BORDER="2" CELLPADDING=5><TR><TH><A NAME="1041277"></a>Свойство<TH><B><A NAME="1041279"></a>
Описание<TR><TD><PRE><A NAME="1041281"></a>group</PRE><TD><P><A NAME="1042951"></a>
(Только для чтения) Группа новостей, содержащая данное сообщение.</P>
<TR><TD><PRE><A NAME="1041285"></a>read</PRE><TD><P><A NAME="1042697"></a>Прочитано сообщение или нет.</P>
<TR><TD><PRE><A NAME="1041289"></a>sender</PRE><TD><P><A NAME="1041291"></a>(Только для чтения) Отправитель сообщения.</P>
<TR><TD><PRE><A NAME="1041293"></a>subject</PRE><TD><P><A NAME="1041295"></a>(Только для чтения) Тема сообщения.</P></TABLE>
<H2><A NAME="Debugging Your Filters"><A NAME="1040178"></a>Отладка фильтров</H2><hr><p><A NAME="1040180"></a>
Если с фильтрами имеются какие-нибудь проблемы, Вы можете получить стандартное 
предупреждение JavaScript о природе ошибки. При наличии проблем, фильтры не 
используются для фильтрации сообщений. Соответственно, если проблемы имеются, 
вся почта в папке Inbox остаётся без изменений.</p><H2><A NAME="A More Complex Example"><A NAME="1040193"></a>
Более сложный пример</H2><hr><p><A NAME="1043000"></a>Этот файл фильтра даёт Вам возможность легко выполнять различные изменения 
сообщения. Сначала используются инициализаторы объектов для создания массива 
объектов. Каждый их этих объектов представляет набор сообщений и действия 
функции с сообщениями этого набора. Эти объекты могут иметь следующие свойства:</p><A NAME="1044455"></a>
<TABLE BORDER="2" CELLPADDING=5><TR><TD><PRE><A NAME="1043046"></a>field</PRE><TD><P><A NAME="1043048"></a>
Поле, относительно которого выполняется подстановка (такое как From или Resent-From).</P>
<TR><TD><PRE><A NAME="1043053"></a>probe</PRE><TD><P><A NAME="1043055"></a>Значение совпадающего поля.</P>
<TR><TD><PRE><A NAME="1043064"></a>folder</PRE><TD><P><A NAME="1043066"></a>Почтовая папка, в которую поместить сообщение.</P>
<TR><TD><PRE><A NAME="1043074"></a>trash</PRE><TD><P><A NAME="1043076"></a>True, если сообщение нужно поместить в папку Trash.</P>
<TR><TD><PRE><A NAME="1043081"></a>priority</PRE><TD><P><A NAME="1043083"></a>Новый приоритет сообщения.</P></TABLE>
<p><A NAME="1043088"></a>После получения массива фильтров, код создаёт из этих фильтров регулярные 
выражения для использования при подстановках к конкретным сообщениям. Если Messenger 
вызывает <CODE>ApplyFilters</CODE> для сообщения, производится поиск совпадений 
в массиве <CODE>MyFilters</CODE>. Если совпадение найдено, функция помещает 
сообщение в trash, перемещает сообщение в новую папку или изменяет приоритет сообщения.</p>
<PRE><A NAME="1042782"></a>var MyFilters = [<br>&nbsp;&nbsp;&nbsp;{field:"From",&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;probe:"cltbld@netscape.com",&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;folder:"mailbox:Client Build"},<br>&nbsp;&nbsp;&nbsp;{field:"From",&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;probe:"scopus@netscape.com",&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;folder:"mailbox:Scopus"},<br>&nbsp;&nbsp;&nbsp;{field:"Resent-From",&nbsp;probe:"bonsai-hook@warp.mcom.com",&nbsp;trash:true"},<br>&nbsp;&nbsp;&nbsp;{field:"Resent-From",&nbsp;probe:"xheads@netscape.com",&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;folder:"mailbox:X Heads"},<br>&nbsp;&nbsp;&nbsp;{field:"Resent-From",&nbsp;probe:"layers@netscape.com",&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;priority:"High"}<br>];</PRE><PRE><A NAME="1041510"></a>// Инициализация путём компиляции регулярного выражения для каждого фильтра<br>
for (var i = 0; i &lt; MyFilters.length; i++) {<br>&nbsp;&nbsp;&nbsp;var f = MyFilters[i];<br>&nbsp;&nbsp;&nbsp;f.regexp = new RegExp("^" + f.field + " *:.*" + f.probe, "i");<br>}</PRE><PRE><A NAME="1041758"></a>function ApplyFilters(message)<br>{<br>&nbsp;&nbsp;&nbsp;trace("Applying mail filters");</PRE><PRE><A NAME="1041635"></a>&nbsp;&nbsp;&nbsp;for (var i = 0; i &lt; MyFilters.length; i++) {<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;var f = MyFilters[i];<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;if (f.regexp.test()) {<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;if (f.trash) {<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;message.trash();<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} else if (f.folder) {<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;message.folder = f.folder;<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} else {<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;message.priority = f.priority;<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;continue;<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;break;<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}<br>&nbsp;&nbsp;&nbsp;}<br>}</PRE>
<h5><a href="contents.php">Оглавление</a> | <a href="partapp.php">Назад</a>
| <a href="console.php">Вперёд</a> | <a href="bklast.php">Индекс</a></h5><hr>
</BODY></HTML>
<?
include_once '../../sys/inc/tfoot.php';
?>