<?include'h.php';?>
<html><head>
		<title>Учебник PHP, Глава 9</title>
		<meta http-equiv="Content-type" content="text/html; charset=Windows-1251">
		</head>
		
      <DIV class=infotxt>
      <LI><A href="#a">Глава 9. PHP и динамическое 
      создание страниц</A> 
      <UL>
        <LI><A href="#b">Простые ссылки</A> 
        <LI><A href="#c">Файловые 
        компоненты(шаблоны)</A> 
        <UL>
          <LI><A href="#d">include( ) и require( 
          )</A> 
          <LI><A href="#e">Функции</A> 
          <LI><A href="#f">Построение 
          компонентов</A> 
          <LI><A href="#g">Заголовок</A> 
          <LI><A href="#h">Колонтитул</A> 
          <LI><A href="#i">Основная часть</A> 
          <LI><A href="#j">Все вместе: заголовок, 
          колонтитул и основная часть</A> 
          <LI><A href="#k">Оптимизация 
          шаблонов</A> </LI></UL>
        <LI><A href="#l">Проект: генератор 
        страниц</A> 
        <LI><A href="#m">Итоги</A> </LI></UL>
      <UL></UL><A name=a></A>
      <P>&nbsp;</P>
      <P>ГЛАВА 9</P>
      <P>РНР и динамическое создание страниц</P>
      <P>Многие читатели в любой книге о компьютерах пролистывают все, что не 
      представляет непосредственного интереса, и переходят к тому, что они 
      действительно хотят знать. Лично я поступаю именно так. Впрочем, в этом 
      нет ничего страшного — редко встречаются технические книги, которые 
      необходимо читать от корки до корки. А может, вы именно так и поступили — 
      пропустили восемь начальных глав и взялись за эту главу, потому что у нее 
      было самое интересное название? Да и кому захочется тратить время на 
      подробности, когда на работе «горит» очередной проект?</P>
      <P>К счастью, подобная торопливость не помешает вам нормально усвоить 
      материал второй части книги, посвященной использованию РНР для построения 
      сайтов и взаимодействия с Web. В этой главе вы научитесь легко 
      модифицировать содержимое web-страниц и осуществлять навигацию в Web при 
      помощи ссылок и различных стандартных функций. Следующая глава дополнит 
      изложенный материал - в ней подробно рассматриваются средства 
      взаимодействия с пользователем в формах HTML В главе 11 описана 
      организация интерфейса с базами данных. В остальных главах второй части 
      рассматриваются нетривиальные аспекты web-программирования на РНР.</P>
      <P>Однако следует помнить о том, что материал части 1 абсолютно необходим 
      для нормального владения РНР. Предполагается, что вы все же прочитали 
      первую часть, поэтому в примерах будут использоваться многие из описанных 
      ранее концепций. Итак, если вы пролистали часть книги, вам придется время 
      от времени возвращаться к предыдущим главам и наверстывать упущенное.</P>
      <P><A name=b></A>Простые ссылки</P>
      <P>По ссылкам пользователь может переходить как на обычные страницы HTML, 
      так и на страницы, содержащие код РНР:</P>
      <P>&lt;а href = "date.php"&gt;&lt;View today's date&lt;/a&gt;</P>
      <P>Если щелкнуть на ссылке, в браузере будет загружена страница с именем 
      date.php. Просто, не правда ли? Развивая приведенный пример, можно 
      воспользоваться переменной для построения динамической ссылки:</P>
      <P>&lt;?</P>
      <P>$link = "date.php";</P>
      <P>print "&lt;а href = \"$link\"&gt;View today's date&lt;/a&gt; 
      &lt;br&gt;\n"</P>
      <P>?&gt;</P>
      <P>Вероятно, у вас возник вопрос — почему в коде ссылки перед кавычками 
      (") ставится обратная косая черта (\)? Дело в том, что кавычки в РНР 
      являются специальными символами и используются в качестве ограничителей 
      строк. Следовательно, кавычки-литералы в строках должны 
экранироваться.</P>
      <P>Если 
      необходимость экранировать кавычки вас раздражает, просто включите режим 
      magic_quotes_gpc в файле php.ini. В результате все апострофы, кавычки, 
      обратные косые черты и нуль-символы. в тексте автоматически 
      экранируются!</P>
      <P>Разовьем приведенный пример. Для быстрого вывода списка ссылок в 
      браузере можно воспользоваться массивом:</P>
      <P>&lt;?</P>
      <P>// Создать массив разделов</P>
      <P>$contents - array("tutorials", "articles", "scripts", "contact");</P>
      <P>// Перебрать и последовательно вывести каждый элемент массива</P>
      <P>for ($i = 0; $i &lt; sizeof($contents; $i++)</P>
      <P>print " &amp;#149; &lt;a href = 
      \"".$contents[$i].".php\"&gt;".$contents[$i]."&lt;/a&gt;&lt;br&gt;\n";</P>
      <P>// &amp;#149; - специальное обозначение точки-маркера endfor;</P>
      <P>?&gt;</P>
      <P><A name=c></A>Файловые компоненты (шаблоны)</P>
      <P>Мы подошли к одной из моих любимых возможностей РНР. Шаблоном 
      (применительно к web-программированию) называется часть web-документа, 
      которую вы собираетесь использовать в нескольких страницах. Шаблоны, как и 
      функции РНР, избавляют вас от лишнего копирования/вставки фрагментов 
      содержания страницы и программного кода. С увеличением масштабов сайта 
      значение шаблонов возрастает, поскольку они позволяют легко и быстро 
      проводить модификации на уровне целого сайта. В этом разделе будут описаны 
      некоторые возможности, которые открываются при использовании простейших 
      шаблонов.</P>
      <P>Как правило, общие фрагменты содержания/кода (то есть шаблоны) 
      сохраняются в отдельных файлах. При построении web-документа вы просто 
      «включаете» эти файлы в соответствующие места страницы. В РНР для этого 
      существуют две функции: include( ) и require( ).</P>
      <P><A name=d></A>include( ) и require( )</P>
      <P>Одним из самых выдающихся аспектов РНР является возможность построения 
      шаблонов и программных библиотек и их последующей вставки в новые 
      сценарии. Применение библиотек экономит время и усилия по использованию 
      общих функциональных возможностей на разных web-сайтах. Читатели, 
      обладающие</P>
      <P>опытом программирования на других языках (например, С, C++ или Java), 
      хорошо знакомы с концепцией библиотек функций и их использованием в 
      программах для расширения функциональных возможностей.</P>
      <P>Включение одного или нескольких файлов в сценарий осуществляется 
      стандартными функциями РНР require( ) и include( ). Как будет показано в 
      следующем разделе, каждая из этих функций применяется в определенной 
      ситуации.</P>
      <P><A name=e></A>Функции</P>
      <P>В РНР существуют четыре функции для включения файлов в сценарии 
РНР:</P>
      <UL>
        <LI>include( ); 
        <LI>include_once( ); 
        <LI>require( ); 
        <LI>require_once( ). </LI></UL>
      <P>Несмотря на сходство имен, эти функции решают разные задачи.</P>
      <P>include( )</P>
      <P>Функция include( ) включает содержимое файла в сценарий. Синтаксис 
      функции include( ):</P>
      <P>include (file файл]</P>
      <P>У функции include( ) есть одна интересная особенность — ее можно 
      выполнять условно. Например, если вызов функции включен в блок команды if. 
      то файл включается в программу лишь в том случае, если условие i f 
      истинно. Если функция includeO используется в условной команде, то она 
      должна быть заключена в фигурные скобки или в альтернативные ограничители. 
      Сравните различия в синтаксисе листингов 9.1 и 9.2.</P>
      <P>Листинг 9.1. Неправильное использование include( )</P>
      <P>if (some_conditional)</P>
      <P>include ('text91a.txt'); else</P>
      <P>include ('text91b.txt');</P>
      <P>Листинг 9.2. Правильное использование include( )</P>
      <P>if (some_conditional) :</P>
      <P>include ('text91a.txt');</P>
      <P>else :</P>
      <P>include ('text91b.txt');</P>
      <P>endif;</P>
      <P>Весь код РНР во включаемом файле обязательно заключается в теги РНР. Не 
      стоит полагать, что простое сохранение команды РНР в файле обеспечит ее 
      правильную обработку:</P>
      <P>print "this is an invalid include file";</P>
      <P>Вместо этого необходимо заключить команду в соответствующие теги, как 
      показывает следующий пример:</P>
      <P>&lt;?</P>
      <P>print "this is an invalid include file";</P>
      <P>?&gt;</P>
      <P>include_once( )</P>
      <P>Функция include_once( ) делает то же, что и include( ), за одним 
      исключением: прежде чем включать файл в программу, она проверяет, не был 
      ли он включен ранее. Если файл уже был включен, вызов include_once( ) 
      игнорируется, а если нет — происходит стандартное включение файла. Во всем 
      остальном include_once( ) ничем не отличается от include( ). Синтаксис 
      функции include_once( ):</P>
      <P>include_once (file файл)</P>
      <P>require ( )</P>
      <P>В целом функция require( ) похожа на include( ) — она тоже включает 
      шаблон в тот файл, в котором находится вызов require( ). Синтаксис функции 
      require( ):</P>
      <P>require (file файл)</P>
      <P>Тем не менее, между функциями require( ) и include( ) существует одно 
      важное различие. Файл, определяемый параметром require( ), включается в 
      сценарий независимо от местонахождения require( ) в сценарии. Например, 
      при вызове requi ге( ) в блоке if при ложном условии файл все равно будет 
      включен в сценарий!</P>
      <P>Во многих ситуациях бывает удобно создать файл с переменными и другой 
      информацией, которая используется в масштабах сайта, и затем подключать 
      его по мере необходимости. Хотя имя этого файла выбирается произвольно, я 
      обычно называю его init.tpl (сокращение от «initializaion.template»). В 
      листинге 9.3 показано, как выглядит очень простой файл init.tpl. В 
      листинге 9.4 содержимое init.tpl включается в сценарий командой require( 
      ).</P>
      <P>Листинг 9.3. Пример инициализационного файла &lt;?</P>
      <P>&lt;?</P>
      <P>$site_title = "РНР Recipes";</P>
      <P>$contact_email = "wjgilmore@hotmail.com";</P>
      <P>$contact_name = "WJ Gilmore";</P>
      <P>?&gt;</P>
      <P>Листинг 9.4. Использование файла init.tpl</P>
      <P>&lt;? require ('init.tpl ');?&gt;</P>
      <P>&lt;html&gt;</P>
      <P>&lt;head&gt;</P>
      <P>&lt;title&gt;&lt;? print $site_title; ?&gt;&lt;/title&gt;</P>
      <P>&lt;/head&gt;</P>
      <P>&lt;body&gt;</P>
      <P>&lt;? print "Welcome to $site_title. For questions, contact &lt;a href 
      =</P>
      <P>\"mai1 to:$contact_email\"&gt;$contact_name&lt;/a&gt;."; ?&gt;</P>
      <P>&lt;/body&gt;</P>
      <P>&lt;/html&gt;</P>
      <P>Передача 
      URL при вызове require( ) допускается лишь при включенном режиме «URL 
      fopen wrappers» (этот режим включен по умолчанию).</P>
      <P>С увеличением размеров сайта может оказаться, что некоторые файлы 
      включаются в сценарий по несколько раз. Иногда это не вызывает проблем, но 
      в некоторых случаях повторное включение файла приводит к сбросу значений 
      изменившихся переменных. Если во включаемом файле определяются функции, 
      могут возникнуть конфликты имен. Учитывая сказанное, мы приходим к 
      следующей функции — require_once( ).</P>
      <P>require_once( )</P>
      <P>Функция require_once( ) гарантирует, что файл будет включаться в 
      сценарий всего один раз. После вызова requi rе_оnсе( ) все дальнейшие 
      попытки включения того же файла игнорируются. Синтаксис функции 
      requiге_оnсе( ): </P>
      <P>require_once(file файл)</P>
      <P>Если не считать дополнительной проверки, в остальном эта функция 
      аналогична</P>
      <P>require( ).</P>
      <P>Вероятно, вы станете чаще использовать функции включения файлов по мере 
      того, как ваши web-приложения начнут увеличиваться в размерах. Эти функции 
      часто встречаются в примерах данной книги, чтобы сократить избыточность 
      программного кода. Первые примеры рассматриваются в следующем разделе, 
      посвященном принципам построения базовых шаблонов.</P>
      <P><A name=f></A>Построение компонентов</P>
      <P>При определении структуры типичной web-страницы я обычно разбиваю ее на 
      три части: заголовок, основную часть и колонтитул. Как правило, в 
      большинстве правильно организованных web-сайтов присутствует заголовок, 
      который практически не изменяется; в основной части выводится 
      запрашиваемое содержание сайта, поэтому она часто изменяется; наконец, 
      колонтитул содержит информацию об авторских правах и навигационные ссылки. 
      Колонтитул, как и заголовок, обычно остается неизменным. Не поймите меня 
      превратно — я вовсе не пытаюсь подавлять ваши творческие устремления. Мне 
      встречалось немало великолепных сайтов, не следовавших этим принципам. Я 
      всего лишь пытаюсь выработать общую структуру, которая может послужить 
      отправной точкой для дальнейшей работы.</P>
      <P><A name=g></A>Заголовок</P>
      <P>Заголовочный файл (вроде приведенного в листинге 9.5) присутствует 
      практически в каждом из моих web-сайтов с поддержкой РНР. В этом файле 
      содержится</P>
      <P>информация, действующая на уровне всего сайта, — например, заголовок, 
      контактные данные и некоторые компоненты кода HTML-страницы.</P>
      <P>Листинг 9.5. Пример файла заголовка </P>
      <P>&lt;?</P>
      <P>// Файл: header.tpl</P>
      <P>// Назначение: заголовочный файл для сайта PhpRecipes .</P>
      <P>// Дата: 22 августа 2000 г.</P>
      <P>$site_name = "PHPRecipes";</P>
      <P>$site_email= "wjgnmore@hotrnail.com";</P>
      <P>$site_path = "http://localhost/phprecipes";</P>
      <P>?&gt;</P>
      <P>&lt;html&gt;</P>
      <P>&lt;head&gt;</P>
      <P>&lt;title&gt; &lt;? print $site_name; ?&gt; &lt;/title&gt;</P>
      <P>&lt;/head&gt;</P>
      <P>&lt;body bgcolor="#7b8079" text="#ffffff" link="fe7d387" 
      alink="#e7d387" vlink="#e7f0e4"&gt;</P>
      <P>&lt;table width="95%" cellpadding="0" cellspacing="0" 
border="1"&gt;</P>
      <P>&lt;tr&gt;</P>
      <P>&lt;td valign = "top"&gt;</P>
      <P>PHPRecipes</P>
      <P>&lt;/td&gt;</P>
      <P>&lt;td valign = "top" align="right"&gt;</P>
      <P>&lt;?</P>
      <P>// Вывести текущую дату и время</P>
      <P>print date ("F d, h:i a");</P>
      <P>?&gt;</P>
      <P>&lt;/td&gt;</P>
      <P>&lt;/tr&gt;</P>
      <P>&lt;/table&gt;</P>
      <P>Довольно часто доступ к включаемым файлам со стороны посетителей 
      ограничивается, особенно если эти файлы содержат конфиденциальную 
      информацию (например, пароли). В Apache можно запретить просмотр некоторых 
      файлов редактированием файлов http.conf или htaccess. Следующий пример 
      показывает, как запретить просмотр всех файлов с расширением .tpl:</P>
      <P>&lt;Files "*.tpl"&gt;</P>
      <P>Order allow,deny</P>
      <P>Allow from 127.0.0.1</P>
      <P>Deny from all</P>
      <P>&lt;/Files&gt;</P>
      <P>РНР 
      и проблемы безопасности сайтов подробно описаны в главе 16.</P>
      <P><A name=h></A>Колонтитул</P>
      <P>Колонтитулом (footer) обычно называется информация, расположенная в 
      нижней части страниц сайта, — контактные данные, ссылки и информация об 
      авторских правах. Эту информацию можно разместить в отдельном файле и 
      включать в качестве шаблона так же, как это делается с заголовком. 
      Допустим, c наступлением нового года вам потребовалось изменить информацию 
      об авторских правах и привести ее к виду «Copyright © 2000-2001». Есть два 
      пути: потратить канун Рождества на лихорадочное редактирование сотен 
      статических страниц или воспользоваться шаблоном наподобие приведенного в 
      листинге 9.6. Одно простое изменение — и вы можете возвращаться к 
      праздничным хлопотам.</P>
      <P>Листинг 9.6. Пример файла колонтитула (footer.tpl)</P>
      <P>&lt;table width="95%" cellspacing="0" cellpadding="0" 
border="1"&gt;</P>
      <P>&lt;tr&gt;&lt;td valign="top" align="middle"&gt;</P>
      <P>Copyright &amp;copy; 2000 PHPRecipes. All rights 
reserved.&lt;br&gt;</P>
      <P>&lt;a href = "mailto:&lt;?=$site_email;?&gt;"&gt;contact&lt;/a&gt; 
      |&nbsp;</P>
      <P>&lt;a href = "&lt;?=$site_path:?&gt;/</P>
      <P>privacy.php"&gt;your privacy&lt;/a&gt;</P>
      <P>&lt;/td&gt;&lt;/tr&gt;</P>
      <P>&lt;/table&gt;</P>
      <P>&lt;/body&gt;</P>
      <P>&lt;/html&gt;</P>
      <P>Обратите внимание на использование глобальной переменной $site_email в 
      файле колонтитула. Значение этой переменной действует в масштабах всей 
      страницы, а мы предполагаем, что файлы header.tpl и footer.tpl будут 
      включены в одну итоговую страницу. Также обратите внимание на присутствие 
      пути $site_path в ссылке Privacy (Конфиденциальность). Я всегда включаю в 
      шаблоны полные пути ко всем ссылкам — если бы URL ссылки состоял из одного 
      имени privacy.php, то файл колонтитула был бы жестко привязан к 
      конкретному каталогу.</P>
      <P><A name=i></A>Основная часть</P>
      <P>В основной части страницы подключается содержимое заголовка и 
      колонтитула. В сущности, именно основная часть содержит информацию, 
      интересующую посетителей сайта. Заголовок эффектно выглядит, колонтитул 
      содержит полезные сведения, но именно ради основной части страницы 
      пользователи снова и снова возвращаются на сайт. Хотя я не смогу 
      предоставить каких-либо рекомендаций по поводу конкретной структуры 
      страниц, шаблоны, подобные приведенному в листинге 9.7, основательно 
      упрощают администрирование страниц.</P>
      <P>Листинг 9.7. Пример основной части страницы (index_body.tpl)</P>
      <P>&lt;table width="95%" cellspacing="0" cellpadding="0" 
border="1"&gt;</P>
      <P>&lt;tr&gt;</P>
      <P>&lt;td valign="top" width="25%&gt;</P>
      <P>&lt;a href = 
      "&lt;?=$site_path;?&gt;/tutorials.php"&gt;tutorials&lt;/a&gt;&nbsp;</P>
      <P>&lt;br&gt;</P>
      <P>&lt;a href = 
      "&lt;?=$site_path:?&gt;/articles.php"&gt;articles&lt;/a&gt;&nbsp;</P>
      <P>&lt;br&gt;</P>
      <P>&lt;a href = 
      "&lt;?=$site_path;?&gt;/scripts.php"&gt;scripts&lt;/a&gt;&nbsp;</P>
      <P>&lt;br&gt;</P>
      <P>&lt;a href = 
      "&lt;?=$site_path;?&gt;/contact.php"&gt;contact&lt;/a&gt;&nbsp;</P>
      <P>&lt;br&gt;</P>
      <P>&lt;/td&gt;</P>
      <P>&lt;td valign="top" width="75%"&gt;</P>
      <P>Welcome to PHPRecipes. the starting place for PHP scripts, 
      tutorials,&nbsp;</P>
      <P>and information about gourmet cooking!</P>
      <P>&lt;/td&gt;</P>
      <P>&lt;/tr&gt;</P>
      <P>&lt;/table&gt;</P>
      <P><A name=j></A>Все вместе: заголовок, колонтитул и основная часть</P>
      <P>Вероятно, мое настроение лучше всего выражается фразой полковника 
      «Ганнибала» Смита (Джордж Пеппард) из знаменитого сериала «Команда А»: 
      «Люблю, когда все становится на свои места». Я испытываю нечто подобное, 
      когда разрозненные шаблоны объединяются и образуют полный web-документ. 
      Комбинируя три секции документа: header.tpl, index_body.tpl и footer.tpl, 
      — можно быстро построить простейшую страницу вроде той, что приведена в 
      листинге 9.8.</P>
      <P>Листинг 9.8. Построение страницы index.php включением нескольких 
      файлов</P>
      <P>&lt;?</P>
      <P>// Файл: index.php</P>
      <P>// Назначение: домашняя страница PHPRecipes</P>
      <P>// Дата: 23 августа 2000 г.</P>
      <P>// Вывести заголовок</P>
      <P>include ("header.tpl");</P>
      <P>// Вывести основную часть</P>
      <P>include ("index_body.tpl");</P>
      <P>// Вывести колонтитул</P>
      <P>include ("footer.tpl");</P>
      <P>?&gt;</P>
      <P>Ну как? Три простые команды — и перед вами готовая страница. Текст 
      итоговой страницы приведен в листинге 9.9.</P>
      <P>Листинг 9.9. Страница HTML, построенная в листинге 9.8 (index.php)</P>
      <P>&lt;html&gt;</P>
      <P>&lt;head&gt;</P>
      <P>&lt;title&gt; PHPRecipes &lt;/title&gt;</P>
      <P>&lt;/head&gt;</P>
      <P>&lt;body bgcolor="#7b8079" text="#ffffff" link="#e7d387" 
      alink="#e7d387" vlink="#e7f0e4"&gt;</P>
      <P>&lt;table width = "95%" cellpadding="0" cellspacing="0" 
      border="1"&gt;</P>
      <P>&lt;tr&gt;</P>
      <P>&lt;td valign = "top"&gt;</P>
      <P>PHP Recipes</P>
      <P>&lt;/td&gt;</P>
      <P>&lt;td valign = "top" align="right"&gt;</P>
      <P>August 23, 03:17 pm</P>
      <P>&lt;/td&gt;</P>
      <P>&lt;/tr&gt;</P>
      <P>&lt;/table&gt;&lt;table width="95%" cellspacing="0" cellpadd1ng="0" 
      border="1"&gt;</P>
      <P>&lt;tr&gt;</P>
      <P>&lt;td valign="top" width="25%"&gt;</P>
      <P>&lt;a href = 
      "htfp://localriost/phprecipes/tutorials.php"&gt;tutorials</P>
      <P>&lt;/a&gt; &lt;br&gt;</P>
      <P>&lt;a href = "http://localhost/phprecipes/articles.php"&gt;articles</P>
      <P>&lt;/a&gt; &lt;br&gt;</P>
      <P>&lt;a href = 
      "http://localhost/phprecipes/scripts.php"&gt;scripts&lt;/a&gt;</P>
      <P>&lt;br&gt;</P>
      <P>&lt;a href = 
      "http://localhost/phprecipes/contact.php"&gt;contact&lt;/a&gt;</P>
      <P>&lt;br&gt;</P>
      <P>&lt;/td&gt;</P>
      <P>&lt;td valign="top" width="75%"&gt;</P>
      <P>Welcome to PHPRecipes, the starting place for PHP scripts, 
      tutorials,&nbsp;</P>
      <P>and gourmet cooking tips and recipes!</P>
      <P>&lt;/td&gt;</P>
      <P>&lt;/tr&gt;</P>
      <P>&lt;/table&gt;&lt;table width="95%" cellspacing="0" cellpadding="0" 
      border="1"&gt;</P>
      <P>&lt;tr&gt;&lt;td valign="top" align="middle"&gt;</P>
      <P>Copyright &amp;copy; 2000 PHPRecipes. All rights 
reserved.&lt;br&gt;</P>
      <P>&lt;a href = "mailto:wj@hotmail .com"&gt;contact&lt;/a&gt; |&nbsp;</P>
      <P>&lt;a href = "http://localhost/phprecipes/privacy.php"&gt;your 
      privacy&lt;/a&gt;</P>
      <P>&lt;/td&gt;&lt;/tr&gt;</P>
      <P>&lt;/table&gt;</P>
      <P>&lt;/body&gt;</P>
      <P>&lt;/html&gt;</P>
      <P>На рис. 9.1 показано, как полученная страница выглядит в браузере. Хотя 
      я обычно не пользуюсь рамками таблиц, на этот раз я их вывел, чтобы на 
      рисунке более наглядно выделялись три части страницы.</P>
      <P><IMG src="2_1_9.1Rus.jpg"></P>
      <P>Рис. 9.1. Внешний вид страницы, построенной в листинге 9.8</P>
      <P><A name=k></A>Оптимизация шаблонов</P>
      <P>Во втором (на мой взгляд, более предпочтительном) варианте шаблоны 
      оформляются в виде функций, находящихся в отдельном файле. Тем самым 
      обеспечивается дополнительное структурирование ваших шаблонов. Я называю 
      этот файл инициализационным файлом и храню в нем другую полезную 
      информацию. Поскольку мы уже рассмотрели относительно длинные примеры 
      заголовка и колонтитула, содержимое листингов 9.10 и 9.11 было слегка 
      сокращено для наглядной демонстрации новой идеи.</P>
      <P>Листинг 9.10. Оптимизированный шаблон сайта (site_init.tpl)</P>
      <P>&lt;?</P>
      <P>// Файл: site_init.tpl</P>
      <P>// Назначение: инициализационный файл PhpRecipes</P>
      <P>// Дата: 22 августа 2000 г.</P>
      <P>$site_name = "PHPRecipes";</P>
      <P>$site_email = "wjgilmore@hotmail.com";</P>
      <P>$site_path = "http://localhost/phprecipes/";</P>
      <P>function show_header($site_name) {</P>
      <P>&lt;html&gt;</P>
      <P>&lt;head&gt;</P>
      <P>&lt;title&gt; &lt;? print $site_name: ?&gt; &lt;/title&gt;</P>
      <P>&lt;/tiead&gt;</P>
      <P>&lt;body bgcolor="#7b8079" text="#ffffff" link»"#e7d387" 
      alink="#e7d387" vlink="#e7f0e4"&gt;</P>
      <P>This is the header</P>
      <P>&lt;hr&gt;</P>
      <P>function show footer ()</P>
      <P>?&gt;</P>
      <P>&lt;hr&gt;</P>
      <P>This Is the footer</P>
      <P>&lt;/body&gt;</P>
      <P>&lt;/html&gt;</P>
      <P>&lt;?</P>
      <P>}</P>
      <P>?&gt;</P>
      <P>Листинг 9.11. Применение инициализационного файла</P>
      <P>&lt;?</P>
      <P>// Включить инициализационный файл</P>
      <P>include("site_init.tpl");</P>
      <P>// Вывести заголовок</P>
      <P>show header ($site_name);</P>
      <P>?&gt;</P>
      <P>// Содержимое основной части This is some body information</P>
      <P>&lt;?</P>
      <P>// Вывести колонтитул Show_footer( );</P>
      <P>?&gt;</P>
      <P><A name=l></A>Проект: генератор страниц</P>
      <P>Хотя в большинстве созданных мною web-сайтов основное содержимое 
      страниц формировалось на основании информации, прочитанной из базы данных, 
      всегда найдется несколько страниц, которые практически не изменяются. В 
      частности, на них могут выводиться сведения о команде разработчиков, 
      контактные данные, реклама и т. д. Я обычно храню эту «статическую» 
      информацию в отдельной папке и использую сценарий РНР для ее загрузки при 
      поступлении запроса. Конечно, у вас возникает вопрос — если это 
      статическая информация, для чего нужен сценарий РНР? Почему бы не 
      загружать обычные страницы HTML? Преимущество РНР заключается в том, что 
      вы можете использовать шаблоны и вставлять статические фрагменты по мере 
      необходимости.</P>
      <P>Ссылки для загрузки различных статических файлов строятся динамически. 
      В обобщенной форме ссылка выглядит так:</P>
      <P>&lt;а href = 
      "&lt;?=$site_path:?&gt;/static.php?content=$content"&gt;Static Page 
      Name&lt;/a&gt;</P>
      <P>Начнем с создания статических страниц. Для простоты я ограничусь тремя 
      страницами, содержащими информацию о сайте (листинг 9.12), рекламу 
      (листинг 9.13) и контактные данные (листинг 9.14).</P>
      <P>Листинг 9.12. Информация о сайте (about.html)</P>
      <P>&lt;h3&gt;About PHPRecipes&lt;/h3&gt;</P>
      <P>What programmer doesn't mix all night programming with gourmet cookies. 
      Here at PHPRecipes. hardly a night goes by without one of our coders 
      mixing a little bit of HTML with a tasty plate of Portobello Mushrooms or 
      even Fondue. So we decided to bring you the best of what we love most: PHP 
      and food!</P>
      <P>&lt;p&gt;</P>
      <P>That's right, readers. Tutorials, scripts, souffles and more. 
      &lt;i&gt;0nly&lt;/i&gt; at PHPRecipes.</P>
      <P>Листинг 9.13. Рекламная информация (advert_info.html)</P>
      <P>&lt;h3&gt;Advertising Information&lt;/h3&gt;</P>
      <P>Regardless of whether they come to learn the latest PHP techniques or 
      for brushing up on how</P>
      <P>to bake chicken, you can bet our readers are decision makers. They are 
      the Industry</P>
      <P>professionals who make decisions about what their company 
purchases.</P>
      <P>For advertising information, contact &lt;a href - 
      "mailto:ads@phprecipes.com</P>
      <P>"&gt;ads@phprecipes.com&lt;/a&gt;.</P>
      <P>Листинг 9.14. Контактные данные (contact.html)</P>
      <P>&lt;h3&gt;Contact Us&lt;/h3&gt;</P>
      <P>Have a coding tip? &lt;br&gt;</P>
      <P>Know the perfect topping for candied yams?&lt;br&gt;</P>
      <P>Let us know! Contact the team at &lt;a href= 
      "mailto:theteam@phprecipes.com"&gt;team@phprecipes.com&lt;/a&gt;.</P>
      <P>Переходим к построению страницы static.php, которая выводит 
      запрашиваемую статическую информацию. В этот файл (см. листинг 9.15) 
      включаются компоненты страниц нашего сайта и инициализационный файл 
      site_init.tpl.</P>
      <P>Листинг 9.15. Общий вывод статических страниц (static.php)</P>
      <P>&lt;?</P>
      <P>// Файл: static.php</P>
      <P>// Назначение: отображение запрашиваемых статических страниц.</P>
      <P>// ВНИМАНИЕ: предполагается, что файл "site_init.tpl" и все</P>
      <P>// статические файлы находятся в том же каталоге.</P>
      <P>// Загрузить функции и переменные include("site_init.tpl"):</P>
      <P>// Вывести заголовок show_header($site_name);</P>
      <P>// Вывести запрашиваемое содержание include("$content.html"):</P>
      <P>// Вывести колонтитул show footer( );</P>
      <P>?&gt;</P>
      <P>Теперь все готово к построению основного сценария. Просто включите в 
      страницу</P>
      <P>следующие ссылки:</P>
      <P>&lt;а href = "static.php?content=about"&gt;Static Page 
      Name&lt;/a&gt;&lt;/br&gt;</P>
      <P>&lt;a href = "static.php?content=advert_info"&gt;Advertising 
      Information&lt;/a&gt;&lt;/br&gt;</P>
      <P>&lt;a href = "static.php?content=about"&gt;Contact 
      Us&lt;/a&gt;&lt;/br&gt;</P>
      <P>Если щелкнуть на любой из этих ссылок, в браузере загружается 
      соответствующая статическая страница, внедренная в static.php!</P>
      <P><A name=m></A>Итоги</P>
      <P>В этой главе вы познакомились с первоочередной задачей, для решения 
      которой и создавался РНР, — динамическим построением web-страниц. Были 
      рассмотрены следующие вопросы:</P>
      <UL>
        <LI>обработка URL; 
        <LI>построение динамического содержания; 
        <LI>включение и построение базовых шаблонов. </LI></UL>
      <P>Глава завершается генератором страниц — программой, которая загружает 
      статические страницы в шаблон и позволяет легко организовать поддержку 
      большого количества статических страниц HTML.</P>
      <P>Следующая глава посвящена использованию РНР в сочетании с формами HTML, 
      заметно повышающими степень интерактивности вашего сайта. А потом — 
      взаимодействие с базами данных! Вам предстоит узнать много 
      интересного.</P></LI></DIV>
<center>
[ <a href="08.php">Назад</a> | <a href="index.php">Содержание</a> | <a href="10.php">Вперед</a> ]
</center><br>
<? include_once '../../sys/inc/tfoot.php'; ?>