<?include'h.php';?>
<html><head>
		<title>Учебник PHP, Глава 11</title>
		<meta http-equiv="Content-type" content="text/html; charset=Windows-1251">
		</head>
		
      <DIV class=infotxt>
      <LI><A href="#a">Глава 11. Базы данных</A> 
      <UL>
        <LI><A href="#b">Что такое SQL?</A> 
        <LI><A href="#c">Поддержка баз данных в 
        PHP</A> 
        <LI><A href="#d">MySQL</A> 
        <UL>
          <LI><A href="#e">Установка</A> 
          <LI><A href="#f">Настройка MySQL</A> 
          </LI></UL>
        <LI><A href="#g">Стандартные функции PHP 
        для работы с MySQL</A> 
        <UL>
          <LI><A href="#h">Простейшая поисковая 
          система</A> 
          <LI><A href="#i">Сортировка таблиц</A> 
          </LI></UL>
        <LI><A href="#j">ODBC</A> 
        <UL>
          <LI><A href="#k">Поддержка ODBC в 
          PHP</A> 
          <LI><A href="#l">Microsoft Access и 
          PHP</A> </LI></UL>
        <LI><A href="#m">Проект: каталок 
        ссылок</A> 
        <LI><A href="#n">Итоги</A> </LI></UL>
      <UL></UL>
      <P>&nbsp;</P>
      <P><A name=a></A>ГЛАВА 11</P>
      <P>Базы данных</P>
      <P>Средства эффективного хранения и выборки больших объемов информации 
      внесли огромный вклад в успешное развитие Интернета. Обычно для хранения 
      информации используются базы данных. Работа таких известных сайтов, как 
      Yahoo, Amazon и Ebay, в значительной степени зависит от надежности баз 
      данных, хранящих громадные объемы информации. Конечно, поддержка баз 
      данных ориентирована не только на интересы гигантских корпораций — в 
      распоряжении web-программистов имеется несколько мощных реализаций баз 
      данных, распространяемых по относительно низкой цене (а то и 
      бесплатно).</P>
      <P>Правильная организация базы данных обеспечивает более быстрые и гибкие 
      возможности выборки данных. Она существенно упрощает реализацию средств 
      поиска и сортировки, а проблемы прав доступа к информации решаются при 
      помощи средств контроля за привилегиями, присутствующими во многих 
      системах управления базами данных (СУБД). Кроме того, упрощаются процессы 
      репликации и архивации данных.</P>
      <P>Глава начинается с подробного описания выборки и обновления данных в 
      MySQL — вероятно, самой популярной СУБД, используемой в PHP (<A 
      href="http.html://www.mysql.com/">http://www.mysql.com/</A>). На примере MySQL 
      будет показано, как в РНР происходят загрузка и обновление данных в базе; 
      мы рассмотрим базовые средства поиска и сортировки, используемые во многих 
      web-приложениях. Затем мы перейдем к реализованной в РНР поддержке ODBC 
      (Open Data Base Connectivity) — обобщенного интерфейса, который может 
      использоваться для одновременного соединения с разными СУБД. Поддержка 
      ODBC в РНР будет продемонстрирована на примере соединения и выборки данных 
      из базы данных Microsoft Access. Глава завершается проектом, в котором РНР 
      и СУБД MySQL используются для создания иерархического каталога с 
      информацией об избранных сайтах. При включении в каталог новых сайтов 
      пользователь относит их к одной из стандартных категорий, определяемых 
      администратором сайта.</P>
      <P>Прежде чем переходить к обсуждению MySQL, я хочу сказать несколько слов 
      об SQL — самом распространенном языке для работы с базами данных. Язык SQL 
      заложен в основу практически всех существующих СУБД. Чтобы перейти к 
      рассмотрению примеров работы с базами данных, необходимо хотя бы в общих 
      чертах представлять, как работает SQL.</P>
      <P><A href="http.html://doks.gorodok.net/0" name=b></A>Что такое SQL?</P>
      <P>SQL обычно описывается как стандартный язык, используемый для 
      взаимодействия с реляционными базами данных (см. ниже). Однако SQL не 
      является языком программирования, как С, C++ или РНР. Скорее, это 
      интерфейсное средство для выполнения различных операций с базами данных, 
      предоставляющее в распоряжение пользователя стандартный набор команд. 
      Возможности SQL не ограничиваются выборкой данных из базы. В SQL 
      поддерживаются разнообразные возможности для взаимодействия с базой 
      данных, в том числе:</P>
      <UL>
        <LI>определение структуры данных — определение конструкций, используемых 
        при хранении данных; 
        <LI>выборка данных — загрузка данных из базы и их представление в 
        формате, удобном для вывода; 
        <LI>обработка данных — вставка, обновление и удаление информации; 
        <LI>контроль доступа — возможность разрешения/запрета выборки, вставки, 
        обновления и удаления данных на уровне отдельных пользователей; 
        <LI>контроль целостности данных — сохранение структуры данных при 
        возникновении таких проблем, как параллельные обновления или системные 
        сбои. </LI></UL>
      <P>Обратите внимание: в определении SQL было сказано, что этот язык 
      предназначен для работы с реляционными базами данных. В реляционных СУБД 
      данные организуются в виде набора взаимосвязанных таблиц. Связи между 
      таблицами реализуются в виде ссылок на данные других таблиц. Таблицу можно 
      представить себе как двухмерный массив, в котором расположение каждого 
      элемента характеризуется определенными значениями строки и столбца. Пример 
      реляционной базы данных изображен на рис. 11.1.</P>
      <P><IMG src="2_1_11.1Rus.jpg"></P>
      <P>Рис. 11.1. Пример реляционной базы данных</P>
      <P>Как видно из рис. 11.1, каждая таблица состоит из строк (записей) и 
      столбцов (полей). Каждому полю присваивается уникальное (в рамках данной 
      таблицы) имя. Обратите внимание на связь между таблицами customer и 
      orders, обозначенную стрелкой. В информацию о заказе включается короткий 
      идентификатор клиента, что позволяет избежать избыточного хранения имени и 
      прочих реквизитов клиента. В изображенной базе данных существует еще одна 
      связь — между таблицами orders и products. Эта связь устанавливается по 
      полю prod_id, в котором хранится идентификатор товара, заказанного данным 
      клиентом (определяемого полем custjd). Наличие этих связей позволяет легко 
      ссылаться на полные данные клиента и товара по простым идентификаторам. 
      Правильно организованная база данных превращается в мощное средство 
      организации и эффективного хранения данных с минимальной избыточностью. 
      Запомните эту базу данных, я буду часто ссылаться на нее в дальнейших 
      примерах.</P>
      <P>Итак, как же выполняются операции с реляционными базами данных? Для 
      этого в SQL существует специальный набор общих команд — таких, как SELECT, 
      INSERT, UPDATE и DELETE. Например, если вам потребуется получить адрес 
      электронной почты клиента с идентификатором 2001cu (см. рис. 11.1), 
      достаточно выполнить следующую команду SQL:</P>
      <P>SELECT cust_email FROM customers WHERE custjd = '2001cu'</P>
      <P>Все вполне логично, не правда ли? В обобщенном виде команда выглядит 
      так:</P>
      <P>SELECT имя_поля FROM имя_таблицы [ WHERE условие ]</P>
      <P>Квадратные скобки означают, что завершающая часть команды является 
      необязательной. Например, для получения адресов электронной почты всех 
      клиентов из таблицы customers достаточно выполнить следующий запрос:</P>
      <P>SELECT cust_email FROM customers</P>
      <P>Предположим, вы хотите включить в таблицу products новую запись. 
      Простейшая команда вставки выглядит так:</P>
      <P>INSERT into products VALUES ('1009pr', 'Red Tomatoes', '1.43');</P>
      <P>Если позднее эти данные потребуется удалить, воспользуйтесь следующей 
      командой:</P>
      <P>DELETE FROM products WHERE prod_id = 1009r';</P>
      <P>Существует много разновидностей команд SQL, и полное их описание 
      выходит за рамки этой книги. На эту тему вполне можно написать отдельную 
      книгу! Я постарался сделать так, чтобы команды SQL, используемые в 
      примерах, были относительно простыми, но достаточно реальными. В Web 
      существует много учебной информации и ресурсов, посвященных SQL. Некоторые 
      ссылки приведены в конце этого раздела.</P>
      <P>Записывать команды SQL символами верхнего регистра необязательно. 
      Впрочем, я предпочитаю именно такую запись, поскольку она помогает 
      различать компоненты запроса.</P>
      <P>Раз вы читаете эту книгу, вероятно, вас интересует вопрос, как же 
      организуется работа с базами данных в среде Web? Как правило, сначала при 
      помощи какого-</P>
      <P>либо интерфейсного языка (РНР, Java или Perl) создается соединение с 
      базой данных, после чего программа обращается к базе с запросами, 
      используя стандартный набор средств. Интерфейсный язык можно рассматривать 
      как своего рода «клей», связывающий базу данных с Web. Я перехожу к своему 
      любимому интерфейсному языку — РНР.</P>
      <P>Дополнительные ресурсы</P>
      <P>Ниже перечислены некоторые ресурсы Интернета, посвященные SQL. Они 
      пригодятся как новичкам, так и опытным программистам.</P>
      <UL>
        <LI>Учебники по SQL: <A 
        href="http.html://perl.about.com/compute/perl/cs/beginningsql/index.htm">http://perl.about.com/compute/perl/cs/beginningsql/index.htm</A>. 

        <LI>SQLCourse.com (с примером базы данных): <A 
        href="http.html://www.sqlcourse.com/">http://www.sqlcourse.com/</A>. 
        <LI>SQL для вундеркиндов Web: <A 
        href="http.html://www.arsdigita.com/books/sql">http://www.arsdigita.com/books/sql</A>. 

        <LI>Введение в SQL (применительно к MySQL): <A 
        href="http.html://www.devshed.com/Server_side/MySQL/Intro">http://www.devshed.com/Server_side/MySQL/Intro</A>. 
        </LI></UL>
      <P><A name=c></A>Поддержка баз данных в РНР</P>
      <P>Если бы мне предложили назвать самый важный аспект РНР, вероятно, я бы 
      остановился на поддержке баз данных. В РНР реализована обширная поддержка 
      практически всех существующих серверов баз данных, в том числе:</P>
      <P>
      <TABLE height=145 cellSpacing=0 cellPadding=0 width="100%" border=0>
        <TBODY>
        <TR>
          <TD vAlign=top width=130 height=20>
            <P>Adabas D</P></TD>
          <TD vAlign=top width=158 height=20>
            <P>Informix</P></TD>
          <TD width=104 height=20>PostgreSQL</TD></TR>
        <TR>
          <TD vAlign=top width=130 height=20>
            <P>Dbase</P></TD>
          <TD vAlign=top width=158 height=20>
            <P>Ingres</P></TD>
          <TD width=104 height=20>Solid</TD></TR>
        <TR>
          <TD vAlign=top width=130 height=20>
            <P>Direct MS-SQL</P></TD>
          <TD vAlign=top width=158 height=20>
            <P>InterBase</P></TD>
          <TD width=104 height=20>Sybase</TD></TR>
        <TR>
          <TD vAlign=top width=145 height=20>
            <P>Empress</P></TD>
          <TD vAlign=top width=155 height=20>
            <P>mSQL</P></TD>
          <TD width=100 height=20>UNIX dbm</TD></TR>
        <TR>
          <TD vAlign=top width=130 height=20>
            <P>File-Pro (read-only)</P></TD>
          <TD vAlign=top width=158 height=20>
            <P>MySQL</P></TD>
          <TD width=104 height=20>Velods</TD></TR>
        <TR>
          <TD vAlign=top width=130 height=20>
            <P>FrontBase</P></TD>
          <TD vAlign=top width=158 height=20>
            <P>ODBC</P></TD>
          <TD width=104 height=20></TD></TR>
        <TR>
          <TD vAlign=top width=130 height=20>
            <P>IBM DB2</P></TD>
          <TD vAlign=top width=158 height=20>
            <P>Oracle (OCI7 и OC18)</P></TD>
          <TD width=104 height=20></TD></TR></TBODY></TABLE></P>
      <P>Как показывает этот список, поддержка баз данных в РНР простирается от 
      совместимости с базами данных, известных всем (например, Oracle), до тех, 
      о которых многие даже не слышали. Мораль — если вы собираетесь 
      использовать серьезную СУБД для хранения информации, распространяемой 
      через Web, скорее всего, эта база данных поддерживается в РНР. Поддержка 
      базы данных в РНР представлена набором стандартных функций для соединения 
      с базой, обработки запросов и разрыва связи.</P>
      <P>Подробное описание всех поддерживаемых баз данных явно выходит за рамки 
      книги. Впрочем, сервер MySQL дает неплохое представление об общих 
      возможностях поддержки баз данных в РНР. По этой причине в примерах 
      оставшейся части этой и всех остальных глав книги будет использоваться 
      синтаксис MySQL. Независимо от того, с каким сервером баз данных вы будете 
      работать, адаптация примеров не вызовет особых сложностей.</P>
      <P><A name=d></A>MySQL</P>
      <P>MySQL (<A href="http.html://www.mysql.com/">http://www.mysql.com/</A>) — 
      надежная СУБД на базе SQL, разработанная и сопровождаемая фирмой Т.с.Х 
      DataKonsultAB (Стокгольм, Швеция). Начиная с 1995 года, MySQL стала одной 
      из самых распространенных СУБД в мире, что отчасти обусловлено ее 
      скоростью, надежностью и гибкой лицензионной политикой (см. ниже).</P>
      <P>Благодаря хорошим характеристикам и обширному набору стандартных 
      интерфейсных функций, очень простых в использовании, MySQL стала самым 
      популярным средством для работы с базами данных в РНР.</P>
      <P>MySQL распространяется на условиях общей лицензии GNU (GPL, GNU Public 
      License). Полное описание текущей лицензионной политики MySQL приведено на 
      сайте MySQL (<A 
      href="http.html://www.mysql.com/">http://www.mysql.com/</A>).</P>
      <P><A name=e></A>Установка</P>
      <P>Одна из причин популярности MySQL среди пользователей РНР заключается в 
      том, что поддержка этого сервера автоматически включается в поставку РНР. 
      Таким образом, вам остается лишь проследить за правильной установкой 
      пакета MySQL СУБД MySQL совместима практически с любой серьезной 
      операционной системой, включая FreeBSD, Solaris, UNIX, Linux и различные 
      верии Windows. Хотя лицензионная политика MySQL отличается большей 
      гибкостью в сравнении с другими серверами баз данных, я настоятельно 
      рекомендую ознакомиться с лицензионной информацией, размещенной на сайте 
      MySQL (<A href="http.html://www.mysql.com/">http://www.mysql.com/</A>).</P>
      <P>Последнюю версию MySQL можно принять с любого зеркального сайта. Полный 
      список зеркальных сайтов приведен по адресу 
      http://www.mysql.com/downloads/ mirrors.html. На момент написания книги 
      последняя стабильная версия MySQL имела номер 3.22.32, а версия 3.32 
      находилась на стадии бета-тестирования. Конечно, всегда следует 
      устанавливать последнюю стабильную версию, это в ваших интересах. Посетите 
      ближайший «зеркальный» сайт и загрузите версию, соответствующую вашей 
      операционной системе. В верхней части страницы расположены ссылки на новые 
      версии для различных платформ. Обязательно прочитайте всю страницу, 
      поскольку она завершается ссылками для некоторых специфических ОС.</P>
      <P>Группа разработчиков MySQL подготовила подробную документацию с 
      описанием процесса установки. Я советую внимательно изучить все общие 
      аспекты установки, не ограничиваясь информацией, относящейся 
      непосредственно к вашей операционной системе.</P>
      <P><A name=f></A>Настройка MySQL</P>
      <P>После успешной установки сервер MySQL необходимо настроить. Процесс 
      настройки в основном состоит из создания новых баз данных и редактирования 
      таблиц привилегий MySQL. Таблицы привилегий управляют доступом к базам 
      данных MySQL. Правильная настройка таблиц играет чрезвычайно важную роль в 
      безопасности ваших баз данных, поэтому перед запуском сайта в рабочем 
      режиме необходимо полностью освоить систему привилегий.</P>
      <P>На первый взгляд, таблицы привилегий MySQL выглядят устрашающе, но если 
      в них как следует разобраться, дальнейшее сопровождение становится очень 
      простой задачей. Полное описание таблиц привилегий выходит за рамки этой 
      книги. Впрочем, в Web существует немало ресурсов, предназначенных для 
      помощи начинающим пользователям MySQL. За дополнительной информацией 
      обращайтесь на сайт MySQL (<A 
      href="http.html://www.mysql.com/">http://www.mysql.com/</A>).</P>
      <P>После успешной установки и настройки пакета MySQL можно начинать 
      эксперименты с базами данных в среде Web! Именно этой теме и посвящен 
      следующий раздел. Начнем с изучения поддержки MySQL в РНР.</P>
      <P><A name=g></A>Стандартные функции РНР для работы с MySQL</P>
      <P>Итак, вы успешно создали и протестировали все необходимые разрешения; 
      все готово для работы с сервером MySQL. В этом разделе я представлю 
      стандартные функции РНР, при помощи которых вы сможете легко организовать 
      взаимодействие сценариев РНР с сервером MySQL. Общая последовательность 
      действий при взаимодействии с сервером MySQL выглядит так:</P>
      <OL>
        <LI>Установить соединение с сервером MySQL. Если попытка завершается 
        неудачей, вывести соответствующее сообщение и завершить процесс. 
        <LI>Выбрать базу данных сервера MySQL. Если попытка выбора завершается 
        неудачей, вывести соответствующее сообщение и завершить процесс. 
        Допускается одновременное открытие нескольких баз данных для обработки 
        запросов. 
        <LI>Обработать запросы к выбранной базе (или базам). 
        <LI>После завершения обработки запросов закрыть соединение с сервером 
        баз данных. </LI></OL>
      <P>В примерах этого раздела используются таблицы products, customers и 
      orders (см. рис. 11.1). Если вы захотите самостоятельно проверить все 
      примеры, создайте эти таблицы или скопируйте страницу с описанием 
      структуры, чтобы вам не приходилось постоянно листать книгу.</P>
      <P>Итак, начнем с самого начала — то есть с подключения к серверу 
      MySQL.</P>
      <P>mysql_connect()</P>
      <P>Функция mysql_connect( ) устанавливает связь с сервером MySQL После 
      успешного подключения к MySQL можно переходить к выбору баз данных, 
      обслуживаемых этим сервером. Синтаксис функции mysql_connect( ):</P>
      <P>int mysql_connect ([string хост [:порт] [:/путь//к/сокету] [, string 
      имя пользователя] [, string пароль])</P>
      <P>В параметре хост передается имя хостового компьютера, указанное в 
      таблицах привилегий сервера MySQL. Конечно, оно же используется для 
      перенаправления запросов на web-сервер, на котором работает MySQL, 
      поскольку к серверу MySQL можно подключаться в удаленном режиме. Наряду с 
      именем хоста могут указываться необязательные параметры — номер порта, а 
      также путь к сокету (для локального хоста). Параметры имя_пользователя и 
      пароль должны соответствовать имени пользователя и паролю, заданным в 
      таблицах привилегий MySQL. Обратите внимание: все параметры являются 
      необязательными, поскольку таблицы привилегий можно настроить таким 
      образом, чтобы они допускали соединение без проверки. Если параметр хост 
      не задан, mysql_connect( ) пытается установить связь с локальным 
      хостом.</P>
      <P>Пример открытия соединения с MySQL:</P>
      <P>@mysql_connect(" local host", "web", "4tf9zzzf") or die("Could not 
      connect to MySQL server!");</P>
      <P>В данном примере localhost — имя компьютера, web— имя пользователя, а 
      4tf9zzzf — пароль. Знак @ перед вызовом функции mysql_connect( ) подавляет 
      все сообщения об ошибках, выдаваемые при неудачной попытке подключения, — 
      они заменяются сообщением, указанным при вызове die( ). Обратите внимание: 
      значение, возвращаемое при вызове rnysql_connect( ), в данном примере не 
      используется. Если в программе используется всего одно соединение с 
      сервером MySQL, это вполне нормально. Но если программа устанавливает 
      соединения с несколькими серверами MySQL на разных хостах, следует 
      сохранить идентификатор соединения, возвращаемый при вызове mysql_connect( 
      ), чтобы адресовать последующие команды нужному серверу MySQL. Пример:</P>
      <P>&lt;?</P>
      <P>$link1 = @mysql_connect("www.somehost.com", "web", "abcde") or 
      die("Could not connect to</P>
      <P>MySQL server!");</P>
      <P>$linkl = @mysql_connect("www.someotherhost.com", "usr", "secret") or 
      die("Could not connect</P>
      <P>to MySQL server!");</P>
      <P>?&gt;</P>
      <P>Идентификаторы $link1 и $link2 передаются при последующих обращениях к 
      базам данных с запросами. Вскоре вы узнаете, как именно адресовать запрос 
      нужному серверу при помощи идентификатора соединения.</P>
      <P>Функция mysql_pconnect( ) обеспечивает поддержку восстанавливаемых 
      (persistent) соединений. В многопользовательских средах рекомендуется 
      использовать mysql_pconnect( ) вместо mysql_connect( ) для экономии 
      системных ресурсов. По типам параметров и возвращаемого значения функция 
      mysql_pconnect( ) в точности совпадает c mysql_connect( ).</P>
      <P>mysql_select_db( )</P>
      <P>После успешного соединения с MySQL необходимо выбрать базу данных, 
      находящуюся на сервере. Для этого используется функция mysql_select_db( ). 
      Синтаксис функции mysql_select_db( ):</P>
      <P>int mysql_select_db (string имя_базы_данных [, int 
      идентификатор_соединения])</P>
      <P>Параметр имя_базы_данных определяет выбираемую базу данных, 
      идентификатор</P>
      <P>которой возвращается функцией mysql_select_db( ). Обратите внимание: 
      параметр</P>
      <P>идентификатор_соединения необязателен лишь при одном открытом 
      соединении с</P>
      <P>сервером MySQL. При наличии нескольких открытых соединений этот 
      параметр</P>
      <P>должен указываться. Пример выбора базы данных функцией mysql_select_db( 
      ):</P>
      <P>&lt;?</P>
      <P>@mysql_connect("localhost", "web". "4tf9zzzf")</P>
      <P>or die("Could not connect to MySQL server!");</P>
      <P>@mysql_select_db("company") or die("Could not select company 
      database!");</P>
      <P>?&gt;</P>
      <P>Если в программе выбирается только одна база данных, сохранять ее 
      идентификатор не обязательно. Однако при выборе нескольких баз данных 
      возвращаемые идентификаторы сохраняются, чтобы вы могли сослаться на 
      нужную базу при обработке запроса. Если идентификатор не указан, 
      используется последняя выбранная база данных.</P>
      <P>mysql_close( )</P>
      <P>После завершения работы с сервером MySQL соединение необходимо закрыть. 
      Функция mysql_close( ) закрывает соединение, определяемое необязательным 
      параметром. Если параметр не задан, функция mysql_close( ) закрывает 
      последнее открытое соединение. Синтаксис функции mysql_close( ):</P>
      <P>int mysql_close ([int идентификатор_соединения])</P>
      <P>Пример использования mysql_close( ):</P>
      <P>&lt;?</P>
      <P>@mysql_connect("localhost", "web", "4tf9zzzf")</P>
      <P>or die("Could not connect to MySQL server!");</P>
      <P>@mysql_select_db("company") or die("Could not select company 
      database!"); print "You're connected to a MySQL database!";</P>
      <P>?&gt;</P>
      <P>В этом примере указывать идентификатор соединения не нужно, поскольку 
      на момент вызова mysql_close( ) существует лишь одно открытое соединение с 
      сервером.</P>
      <P>Соединения, открытые функцией mysql_pconnect( ), закрывать не 
      обязательно.</P>
      <P>mysql_query( )</P>
      <P>Функция mysql_query( ) обеспечивает интерфейс для обращения с запросами 
      к базам</P>
      <P>данных. Синтаксис функции mysql_query( ):</P>
      <P>int mysql_query (string запрос [, int идентификатор_соединения])</P>
      <P>Параметр запрос содержит текст запроса на языке SQL. Запрос передается 
      либо соединению, определяемому необязательным параметром 
      идентификатор_соедине-ния, либо, при отсутствии параметра, последнему 
      открытому соединению.</P>
      <P>Неопытные программисты часто ошибочно думают, что функция mysql_query( 
      ) возвращает результаты обработки запроса. Это не так — в зависимости от 
      типа запроса вызов mysql_query( ) может приводить к разным последствиям. 
      При успешном выполнении команды SQL SELECT возвращается идентификатор 
      результата, который впоследствии передается функции mysql_result( ) для 
      последующего форматирования и отображения результатов запроса. Если 
      обработка запроса завершилась неудачей, функция возвращает FALSE. Функция 
      mysql_result( ) описана в одном из следующих разделов. Количество записей, 
      участвующих в запросе, определяется при помощи функции mysql_num_rows( ). 
      Эта функция также описана далее.</P>
      <P>Учитывая сказанное, я приведу примеры использования mysql_query( ) лишь 
      после описания функций mysql_result( ) и mysql_affected_rows( ).</P>
      <P>Если вас беспокоит то, что при обработке запросов расходуется слишком 
      много памя-ти, вызовите стандартную функцию РНР mysql_free_result. При 
      вызове ей передается идентификатор результата, возвращаемый mysql_query( 
      ). Функция mysql_free_result( ) освобождает всю память, связанную с данным 
      запросом.</P>
      <P>mysqLaff ected_rows ( )</P>
      <P>Во многих ситуациях требуется узнать количество записей, участвующих в 
      запросе SQL с командами INSERT, UPDATE, REPLACE или DELETE. Задача 
      решается функцией mysql_affected_rows( ). Синтаксис функции:</P>
      <P>int mysql_affected_rows ([int идентификатор_соединения])</P>
      <P>Обратите внимание: параметр идентификатор_соединения не является 
      обязательным. Если он не указывается, mysql_affected_rqws( ) пытается 
      использовать последнее открытое соединение. Пример:</P>
      <P>&lt;?</P>
      <P>// Подключиться к серверу и выбрать базу данных</P>
      <P>@mysql_connect("localhost", "web". "4tf9zzzf")</P>
      <P>or die("Could not connect to MySQL server!");</P>
      <P>@mysql_select_db("company") or die("Could not select company 
      database!");</P>
      <P>// Создать запрос</P>
      <P>$query = "UPDATE products SET prod_name = \"cantaloupe\"</P>
      <P>WHERE prod_id = \'10001pr\";</P>
      <P>// Выполнить запрос $result = mysql_query($query);</P>
      <P>// Определить количество обновленных записей</P>
      <P>print "Total row updated; ".mysql_affected_rows( );</P>
      <P>mysql_close( );</P>
      <P>?&gt;</P>
      <P>При выполнении этого фрагмента будет выведен следующий результат:</P>
      <P>Total row updated: 1</P>
      <P>Функция mysql_affected_rows( ) не работает с запросами, основанными на 
      команде SELECT. Для определения количества записей, возвращенных при 
      вызове SELECT, используется функция mysql_num_rows( ), описанная в 
      следующем разделе.</P>
      <P>&nbsp;В одной специфической ситуации функция mysql_affected_rows( ) 
      работает с ошибкой. При выполнении команды DELETE без секции 
      WHEREmysql_affected_rows( ) всегда возвращает 0.</P>
      <P>mysql_num_rows( )</P>
      <P>Функция mysql_num_rows( ) определяет количество записей, возвращаемых 
      командой SELECT. Синтаксис функции mysql_num_rows( ):</P>
      <P>int mysql_num_rows(int результат)</P>
      <P>Пример использования mysql_num_rows( ):&nbsp;</P>
      <P>&lt;?</P>
      <P>// Подключиться к серверу и выбрать базу данных 
      @mysql_connect("localhost", "web", "4tf9zzzf")</P>
      <P>or die("Could not connect to MySQL server!");</P>
      <P>@mysql_select_db("company") or die("Could not select company 
      database!");</P>
      <P>// Выбрать все товары, названия которых начинаются с 'р'</P>
      <P>$query = "SELECT prod_name FROM products WHERE prod_name LIKE 
      \"p*\"";</P>
      <P>// Выполнить запрос $result = mysql_query($query);</P>
      <P>print "Total rows selected: ".mysql_num_rows($result);</P>
      <P>mysql_close( );</P>
      <P>?&gt;</P>
      <P>Поскольку таблица содержит лишь один товар, название которого 
      начинается с буквы р (pears), возвращается только одна запись. 
      Результат:</P>
      <P>Total rows selected: 1</P>
      <P>mysql_result( )</P>
      <P>Функция mysql_result() используется в сочетании с mysql_query( ) (при 
      выполнении запроса с командой SELECT) для получения набора данных. 
      Синтаксис функции mysql_resu1t():</P>
      <P>int mysql_result (int идентификатор_результата, int запись [. mixed 
      поле"]')</P>
      <P>В параметре идентификатор_результата передается значение, возвращенное 
      функцией mysql_query( ). Параметр запись ссылается на определенную запись 
      набора данных, определяемого параметром идентификатор_результата. Наконец, 
      в необязательном параметре поле могут передаваться:</P>
      <UL>
        <LI>смещение поля в таблице; 
        <LI>имя поля; 
        <LI>имя поля в формате имя_поля_имя_тдблицы. </LI></UL>
      <P>В листинге 11.1 используется база данных, изображенная на рис. 
11.1.</P>
      <P>Листинг 11.1. Выборка и форматирование данных в базе данных MySQL</P>
      <P>&lt;?</P>
      <P>@mysql_connect("localhost", "web", "ffttss")</P>
      <P>or die("Could not connect to MySQL server!");</P>
      <P>@mysql_select_db("company")</P>
      <P>or die("Could not select products database!");</P>
      <P>// Выбрать все записи из таблицы products</P>
      <P>$query = "SELECT * FROM products"; $result = mysql_query($query);</P>
      <P>$x = 0;</P>
      <P>print "&lt;table&gt;\n";</P>
      <P>print "&lt;tr&gt;\n&lt;th&gt;Product ID&lt;/th&gt;&lt;th&gt;Product 
      Name&lt;/th&gt;&lt;th&gt;Product Price&lt;/th&gt;\n&lt;/tr&gt;\n";</P>
      <P>while ($x &lt; mysql_numrows($result)) :</P>
      <P>$id = mysql_result($result. $x. 'prod_id');</P>
      <P>$name = mysql_result($result, $x, 'prod_name');</P>
      <P>$price = mysql_result($result. $x, 'prod_price');</P>
      <P>print "&lt;tr&gt;\n";</P>
      <P>print 
      "&lt;td&gt;$id&lt;/td&gt;\n&lt;td&gt;$name&lt;/td&gt;\n&lt;td&gt;$price&lt;/td&gt;\n";</P>
      <P>print "&lt;/tr&gt;\n";</P>
      <P>$x++;</P>
      <P>endwhile;</P>
      <P>print "&lt;/table&gt;";</P>
      <P>mysql_close();</P>
      <P>?&gt;</P>
      <P>В результате выполнения этого примера с данными, изображенными на рис. 
      11.1, будет получен следующий результат:</P>
      <P>Листинг 11.2. Результат выполнения листинга 11.1</P>
      <P>&lt;table&gt;</P>
      <P>&lt;tr&gt;</P>
      <P>&lt;th&gt;Product ID&lt;/th&gt;&lt;th&gt;Product 
      Name&lt;/th&gt;&lt;th&gt;Product Price&lt;/th&gt;</P>
      <P>&lt;/tr&gt;</P>
      <P>&lt;tr&gt;</P>
      <P>&lt;td&gt;1000pr&lt;/td&gt;</P>
      <P>&lt;td&gt;apples&lt;/td&gt;</P>
      <P>&lt;td&gt;1.23&lt;/td&gt;</P>
      <P>&lt;/tr&gt;</P>
      <P>&lt;tr&gt;</P>
      <P>&lt;td&gt;1001pr&lt;/td&gt;</P>
      <P>&lt;td&gt;oranges&lt;/td&gt;</P>
      <P>&lt;td&gt;2.34&lt;/td&gt;</P>
      <P>&lt;/tr&gt;</P>
      <P>&lt;tr&gt;</P>
      <P>&lt;td&gt;1002pr&lt;/td&gt;</P>
      <P>&lt;td&gt;bananas&lt;/td&gt;</P>
      <P>&lt;td&gt;3.45&lt;/td&gt;</P>
      <P>&lt;/tr&gt;</P>
      <P>&lt;tr&gt;</P>
      <P>&lt;td&gt;1003pr&lt;/td&gt;</P>
      <P>&lt;td&gt;pears&lt;/td&gt;</P>
      <P>&lt;td&gt;4.45&lt;/td&gt;</P>
      <P>&lt;/tr&gt;</P>
      <P>&lt;/table&gt;</P>
      <P>Функция mysql_result( ) удобна для работы с относительно небольшими 
      наборами данных, однако существуют и другие функции, работающие намного 
      эффективнее, — а именно, функции mysql_fetch_row( ) и mysql_fetch_array( 
      ). Эти функции описаны в следующих разделах.</P>
      <P>mysql_fetch_row()</P>
      <P>Обычно гораздо удобнее сразу присвоить значения всех полей записи 
      элементам индексируемого массива (начиная с индекса 0), нежели многократно 
      вызывать mysql_result( ) для получения отдельных полей. Задача решается 
      функцией mysql_fetch_row( ), имеющей следующий синтаксис:</P>
      <P>array mysql_fetch_row (int результат)</P>
      <P>Использование функции list( ) в сочетании с mysql_fetch_row( ) 
      позволяет сэкономить несколько команд, необходимых при использовании 
      mysql_result( ). В листинге 11.3 приведен код листинга 11.1, переписанный 
      с использованием list( ) и mysql_fetch_row( ).</P>
      <P>Листинг 11.3. Выборка данных функцией mysql_fetch_row( ) &lt;?</P>
      <P>@mysql_connect( "localhost", "web", "ffttss") or die("Could not connect 
      to MySQL server!");</P>
      <P>@mysql_select_db("company") or die("Could not select products 
      database!");</P>
      <P>$query = "SELECT * FROM products";&nbsp;</P>
      <P>$result = mysql_query($query);</P>
      <P>print "&lt;table&gt;\n";</P>
      <P>print "&lt;tr&gt;\n&lt;th&gt;Product ID&lt;/th&gt;&lt;th&gt;Product 
      Name&lt;/th&gt;&lt;th&gt;</P>
      <P>Product Price&lt;/th&gt;\n&lt;/tr&gt;\n";</P>
      <P>while ($row = mysql_fetch_array($result)) :</P>
      <P>print "&lt;tr&gt;\n":</P>
      <P>print 
      "&lt;td&gt;".$row["prod_id"]."&lt;/td&gt;\n&lt;td&gt;".$row["prod_name"]."</P>
      <P>&lt;/td&gt;\n&lt;td&gt;" .$row["prod_price"]. "&lt;/td&gt;\n";</P>
      <P>print "&lt;/tr&gt;\n";&nbsp;</P>
      <P>endwhile;&nbsp;</P>
      <P>print "&lt;/table&gt;";&nbsp;</P>
      <P>mysql_close();</P>
      <P>?&gt;</P>
      <P>Листинг 11.3 выдает тот же результат, что и листинг 11.1, но использует 
      при этом меньшее количество команд.</P>
      <P>my sq l_f etch_array ( )</P>
      <P>Функция mysql_fetch_array( ) аналогична mysql_fetch_row( ), однако по 
      умолчанию значения полей записи сохраняются в ассоциативном массиве. 
      Впрочем, вы можете выбрать тип индексации (ассоциативная, числовая или 
      комбинированная). Синтаксис функции mysql_fetch_array( ):</P>
      <P>array mysql_fetch_array (int идентификатор результата [, 
      тип_индексации])</P>
      <P>В параметре идентификатор_результата передается значение, возвращенное 
      функцией mysql_query( ). Необязательный параметр тип_индексации принимает 
      одно из следующих значений:</P>
      <UL>
        <LI>MYSQL_ASSOC — функция mysql_fetch_array( ) возвращает ассоциативный 
        массив. Если параметр не указан, это значение используется по умолчанию; 

        <LI>MYSQL_NUM — функция mysql_fetch_array( ) возвращает массив с 
        числовой индексацией; 
        <LI>MYSQL_BOTH — к полям возвращаемой записи можно обращаться как по 
        числовым, так и по ассоциативным индексам. </LI></UL>
      <P>Листинг 11.4 содержит очередной вариант кода листингов 11.1 и 11.3. На 
      этот раз используется функция mysql_fetch_array( ), возвращающая 
      ассоциативный массив полей.</P>
      <P>Листинг 11.4. Выборка данных функцией mysql_fetch_array( )</P>
      <P>&lt;?</P>
      <P>@mysql_connect( "local host", "web", "ffttss")</P>
      <P>or die("Could not connect to MySQL server!");</P>
      <P>@mysql_select_db( "company" )</P>
      <P>or die("Could not select products database!");</P>
      <P>$query = "SELECT * FROM products";</P>
      <P>$result = mysql_query($query);</P>
      <P>"&lt;table&gt;\n";</P>
      <P>print "&lt;tr&gt;\n&lt;th&gt;Product ID&lt;/th&gt;&lt;th&gt;Product 
      Name&lt;/th&gt; &lt;th&gt;Product Price&lt;/th&gt;\n&lt;/tr&gt;\n";</P>
      <P>while ($row = mysql_fetch_array($result)) ;</P>
      <P>print "&lt;tr&gt;\n";</P>
      <P>print "&lt;td&gt;".$row["prod_id"]."&lt;/td&gt;\n 
      &lt;td&gt;".$row["prod_name"]."&lt;/td&gt;\n &lt;td&gt;" . 
      $row["prod_price"] . "&lt;/td&gt;\n" ;</P>
      <P>print "&lt;/tr&gt;\n";</P>
      <P>endwhile;</P>
      <P>print "&lt;/table&gt;";</P>
      <P>mysql_close();</P>
      <P>?&gt;</P>
      <P>Листинг 11.4 выдает тот же результат, что и листинги 11.1 и 11.3.</P>
      <P>Того, что сейчас вы знаете о функциональных возможностях MySQL в РНР, 
      вполне достаточно, чтобы заняться созданием довольно интересных 
      приложений. Первое приложение, которое мы рассмотрим, представляет собой 
      простейшую поисковую систему. Этот пример демонстрирует применение форм 
      HTML (см. предыдущую главу) для получения данных, которые в дальнейшем 
      используются для выборки информации из базы.</P>
      <P><A href="http.html://doks.gorodok.net/996" name=h></A>Простейшая поисковая 
      система</P>
      <P>Всем нам неоднократно приходилось пользоваться поисковыми системами в 
      Web, но как устроены такие системы? Простейшая поисковая система принимает 
      по крайней мере одно ключевое слово. Это слово включается в запрос SQL, 
      который затем используется для выборки информации из базы данных. 
      Результат поиска форматируется поисковой системой по тому или иному 
      критерию (скажем, по категории или степени соответствия).</P>
      <P>Поисковая система, приведенная в листинге 11.5, предназначена для 
      поиска информации о клиентах. В форме пользователь вводит ключевое слово и 
      выбирает категорию (имя, идентификатор или адрес электронной почты 
      клиента), в которой будет производиться поиск. Если введенное 
      пользователем имя, идентификатор или адрес существует, поисковая система 
      извлекает из базы данных остальные атрибуты. Затем по идентификатору 
      покупателя из таблицы orders выбирается</P>
      <P>история заказов. Все заказы, оформленные этим клиентом, отображаются по 
      убыванию объема. Если заданное ключевое слово не встречается в категории, 
      указанной пользователем, поиск прекращается, программа выводит 
      соответствующее сообщение и снова отображает форму.</P>
      <P>Листинг 11.5. Простейшая поисковая система (searchengine.php)</P>
      <P>&lt;?</P>
      <P>$form =</P>
      <P>"&lt;form action=\"Listing11-5.php\" method=\"post\"&gt;</P>
      <P>&lt;input type=\"hidden\" name=\"seenform\" value=\"y\"&gt;</P>
      <P>Keyword:&lt;br&gt;</P>
      <P>&lt;input type=\"text\" name=\"keyword\" size=\"20\" maxlength=\"20\" 
      value=\"\"&gt;&lt;br&gt;</P>
      <P>Search Focus:&lt;br&gt;</P>
      <P>&lt;select name=\"category\"&gt;</P>
      <P>&lt;option value=\"\"&gt;Choose a category:</P>
      <P>&lt;option value-\"cust_id\"&gt;Customer ID</P>
      <P>&lt;option value=\"cust_name\"&gt;Customer Name</P>
      <P>&lt;option value=\"cust_eman\"&gt;Customer Email</P>
      <P>&lt;/select&gt;&lt;br&gt;</P>
      <P>&lt;input type-\"submit\" value=\"search\"&gt; ,</P>
      <P>&lt;/form&gt;</P>
      <P>// Если форма еще не отображалась - отобразить ее</P>
      <P>if (Sseenform != "у") :</P>
      <P>print $form; else :</P>
      <P>// Подключиться к серверу MySQL и выбрать базу данных</P>
      <P>@mysql_connect("localhost", "web", "ffttss")</P>
      <P>or die("Could not connect to MySQL server!");</P>
      <P>@mysql_select_db("company")</P>
      <P>or die("Could not select company database!");</P>
      <P>// Построить и выполнить запрос</P>
      <P>$query = "SELECT cust_id. cust_name, cust_email</P>
      <P>FROM customers WHERE $category = '$keyword'";</P>
      <P>$result = mysql_query($query);</P>
      <P>// Если совпадения не найдены, вывести сообщение</P>
      <P>// и заново отобразить форму</P>
      <P>if (mysql_num_rows($result) == 0) :</P>
      <P>print "Sorry, but no matches were found. Please try your search 
      again:";</P>
      <P>print $form;</P>
      <P>// Найдены совпадения. Отформатировать и вывести результаты, else :</P>
      <P>// Отформатировать и вывести значения полей.</P>
      <P>list($id, $name, $email) = mysql_fetch_row($result);</P>
      <P>print "&lt;h3&gt;Customer Information:&lt;/h3&gt;";</P>
      <P>print "&lt;b&gt;Name:&lt;/b&gt; $name &lt;br&gt;";</P>
      <P>print "&lt;b&gt;Identification #:&lt;/b&gt; $id &lt;br&gt;";</P>
      <P>print "&lt;b&gt;Email:&lt;/b&gt; &lt;a 
      href-\"mailto:$email\"&gt;$email&lt;/a&gt; &lt;br&gt;";</P>
      <P>print "&lt;h3&gt;Order History:&lt;/h3&gt;";</P>
      <P>// Построить и выполнить запрос к таблице 'orders'</P>
      <P>$query = "SELECT order_id, prod_id, quantity</P>
      <P>FROM orders WHERE cust_id = '$id'</P>
      <P>ORDER BY quantity DESC";</P>
      <P>$result = mysql_query($query):</P>
      <P>print "&lt;table border = 1&gt;";</P>
      <P>print "&lt;tr&gt;&lt;th&gt;0rder ID&lt;/th&gt;&lt;th&gt;Product 
      ID&lt;/th&gt;&lt;th&gt;Quantity&lt;/th&gt;&lt;/tr&gt;";</P>
      <P>// Отформатировать и вывести найденные записи.</P>
      <P>while (list($order_id, $prod_id, $quantity) = 
      mysql_fetch_row($result));</P>
      <P>print "&lt;tr&gt;";</P>
      <P>print 
      "&lt;td&gt;$order_id&lt;/td&gt;&lt;td&gt;$prod_id&lt;/td&gt;&lt;td&gt;$quantity&lt;/td&gt;";</P>
      <P>print "&lt;/tr&gt;";</P>
      <P>endwhile;</P>
      <P>print "&lt;/table&gt;";</P>
      <P>endif;</P>
      <P>endif;</P>
      <P>?&gt;</P>
      <P>Если ввести ключевое слово Mi 1 апо и выбрать в раскрывающемся списке 
      категорию Customer Name (Имя клиента), программа выводит следующую 
      информацию:</P>
      <P>Customer information:</P>
      <P>Name:Milano</P>
      <P>Identification#:2000cu</P>
      <P>Email:felix@milano.com</P>
      <P>Order History:</P>
      <P>
      <TABLE cellSpacing=0 cellPadding=0 width="100%" border=0>
        <TBODY>
        <TR>
          <TD width=97>Order Id</TD>
          <TD width=105>Product Id</TD>
          <TD width=92>Quantity</TD></TR>
        <TR>
          <TD width=97>100003</TD>
          <TD width=105>1000pr</TD>
          <TD width=92>12</TD></TR>
        <TR>
          <TD width=97>100005</TD>
          <TD width=105>1002pr</TD>
          <TD width=92>11</TD></TR></TBODY></TABLE></P>
      <P>Конечно, мы рассмотрели простейшую реализацию поисковой системы. 
      Существует немало дополнительных возможностей — поиск по нескольким 
      ключевым словам, поиск по неполным ключевым словам или автоматическая 
      выборка записей с похожими ключевыми словами. Попробуйте применить свою 
      творческую фантазию и реализовать их самостоятельно.</P>
      <P><A name=i></A>Сортировка таблиц</P>
      <P>При выводе данных из базы необходимо предусмотреть возможность их 
      сортировки по различным критериям. В качестве примера рассмотрим 
      результаты, выведенные нашей поисковой системой, — обратим особое внимание 
      на следующие после заголовка Order History: (История заказов). Допустим, 
      список получился очень длинным, и вы хотите отсортировать данные по 
      идентификатору товара (или идентификатору заказа). Чтобы вы лучше поняли, 
      о чем идет речь, рекомендую посетить один из моих любимых сайтов, 
      http://download.cnet.com. Если в процессе просмотра программ конкретной 
      категории щелкнуть на заголовке столбца (название, дата размещения, 
      количество загрузок или размер файла), то список автоматически 
      упорядочивается по содержимому указанного столбца. Далее показано, как 
      реализовать подобную возможность.</P>
      <P>В листинге 11.6 мы производим выборку данных из таблицы orders. По 
      умолчанию данные сортируются по убыванию объема заказа (поле quantity). 
      Однако щелчок на любом заголовке таблицы приводит к тому, что страница 
      загружается заново с упорядочением таблицы по указанному столбцу.</P>
      <P>Листинг 11.6. Сортировка таблиц (tablesorter.php)</P>
      <P>&lt;?</P>
      <P>// Подключиться к серверу MySQL и выбрать базу данных</P>
      <P>@mysql_connect("localhost". "web", "ffttss")</P>
      <P>or die("Could not connect to MySQL server!");</P>
      <P>@mysql_select_db( "company")</P>
      <P>or die("Could not select company database!");</P>
      <P>// Если значение переменной $key не задано, по умолчанию</P>
      <P>// используется значение 'quantity' if (! isset($key)) :</P>
      <P>$key = "quantity"; endif;</P>
      <P>// Создать и выполнить запрос.</P>
      <P>// Выбранные данные сортируются по убыванию столбца $key</P>
      <P>$query = "SELECT order_id, cust_id, prod_id, quantity FROM orders ORDER 
      BY $key DESC" $result = mysql_query($query);</P>
      <P>// Создать заголовок таблицы</P>
      <P>print "&lt;table border = 1&gt;";</P>
      <P>print "&lt;tr&gt;</P>
      <P>&lt;th&gt;&lt;a href=\"Listing11-6.php?key=order_id\"&gt;Order 
      ID&lt;/a&gt;&lt;/th&gt;</P>
      <P>&lt;th&gt;&lt;a href=\"Listing11-6.php?key=cust_id\"&gt;Customer 
      ID&lt;/a&gt;&lt;/th&gt;</P>
      <P>&lt;th&gt;&lt;a href=\"Listing11-6.php?key=prod_id\"&gt;Product 
      ID&lt;/a&gt;&lt;/th&gt;</P>
      <P>&lt;th&gt;&lt;a 
      href=\"Listing11-6.php?key=quantity\"&gt;Quantity&lt;/a&gt;</P>
      <P>&lt;/th&gt;&lt;/tr&gt;";</P>
      <P>// Отформатировать и вывести каждую строку таблицы</P>
      <P>while (list($order_id,$cust_id,$prod_id, $quantity)</P>
      <P>= mysql_fetch_row($result)) :</P>
      <P>print "&lt;tr&gt;";</P>
      <P>print 
      "&lt;td&gt;$order_id&lt;/td&gt;&lt;td&gt;$cust_id&lt;/td&gt;&lt;td&gt;$prod_id&lt;/td&gt;&lt;td&gt;</P>
      <P>$quantity&lt;/td&gt;";</P>
      <P>print "&lt;/tr&gt;";</P>
      <P>endwhile;</P>
      <P>// Завершить таблицу</P>
      <P>print "&lt;/table&gt;";</P>
      <P>Для базы данных company, изображенной на рис. 11.1, стандартные 
      выходные данные листинга 11.6 выглядят следующим образом:</P>
      <P>
      <TABLE cellSpacing=0 cellPadding=0 width="100%" border=0>
        <TBODY>
        <TR>
          <TD width="25%">Order ID</TD>
          <TD width="25%">Customer ID</TD>
          <TD width="25%">Product ID</TD>
          <TD width="25%">Quantity</TD></TR>
        <TR>
          <TD vAlign=top width="22%" height=14>
            <P>100003</P></TD>
          <TD width="25%">2000cu</TD>
          <TD width="25%">1000pr</TD>
          <TD width="25%">12</TD></TR>
        <TR>
          <TD vAlign=top width="22%" height=12>
            <P>100005</P></TD>
          <TD width="25%">2000cu</TD>
          <TD width="25%">1002pr</TD>
          <TD width="25%">11</TD></TR>
        <TR>
          <TD vAlign=top width="22%" height=13>
            <P>100004</P></TD>
          <TD width="25%">2000cu</TD>
          <TD width="25%">1000pr</TD>
          <TD width="25%">9</TD></TR>
        <TR>
          <TD vAlign=top width="22%" height=12>
            <P>100002</P></TD>
          <TD width="25%">2000cu</TD>
          <TD width="25%">1001pr</TD>
          <TD width="25%">5</TD></TR>
        <TR>
          <TD vAlign=top width="22%" height=13>
            <P>100001</P></TD>
          <TD width="25%">2000cu</TD>
          <TD width="25%">1002pr</TD>
          <TD width="25%">3</TD></TR></TBODY></TABLE></P>
      <P>Обратите внимание: заголовки таблицы представляют собой гиперссылки. 
      Поскольку по умолчанию сортировка осуществляется по полю quantity, записи 
      отсортированы по убыванию последнего столбца. Если щелкнуть на ссылке 
      Order_ID, страница загружается заново, но на этот раз записи сортируются 
      по убыванию идентификатора заказа. Таблица будет выглядеть так:</P>
      <P>
      <TABLE cellSpacing=0 cellPadding=0 width="100%" border=0>
        <TBODY>
        <TR>
          <TD width="25%">Order ID</TD>
          <TD width="25%">Customer ID</TD>
          <TD width="25%">Product ID</TD>
          <TD width="25%">Quantity</TD></TR>
        <TR>
          <TD vAlign=top width="22%" height=14>
            <P>100005</P></TD>
          <TD width="25%">2000cu</TD>
          <TD width="25%">1002pr</TD>
          <TD width="25%">11</TD></TR>
        <TR>
          <TD vAlign=top width="22%" height=12>
            <P>100004</P></TD>
          <TD width="25%">2000cu</TD>
          <TD width="25%">1000pr</TD>
          <TD width="25%">9</TD></TR>
        <TR>
          <TD vAlign=top width="22%" height=13>
            <P>100003</P></TD>
          <TD width="25%">2000cu</TD>
          <TD width="25%">1000pr</TD>
          <TD width="25%">12</TD></TR>
        <TR>
          <TD vAlign=top width="22%" height=12>
            <P>100002</P></TD>
          <TD width="25%">2000cu</TD>
          <TD width="25%">1001pr</TD>
          <TD width="25%">5</TD></TR>
        <TR>
          <TD vAlign=top width="22%" height=13>
            <P>100001</P></TD>
          <TD width="25%">2000cu</TD>
          <TD width="25%">1002pr</TD>
          <TD width="25%">3</TD></TR></TBODY></TABLE></P>
      <P>&nbsp;</P>
      <P>Сортировка выходных данных приносит огромную пользу при форматировании 
      баз данных. Простая модификация запроса SELECT позволяет упорядочить 
      данные по любому критерию — по возрастанию, по убыванию или с группировкой 
      записей.</P>
      <P>На этом наше знакомство с MySQL подходит к концу. Учтите, что материал 
      этой главы отнюдь не исчерпывает всего, что необходимо знать о MySQL. 
      Полный список команд MySQL в РНР приведен в документации (<A 
      href="http.html://www.php.net/manuat">http://www.php.net/manuat</A>).</P>
      <P><A name=j></A>ODBC</P>
      <P>Специализированные функции хорошо подходят для работы с одним 
      конкретным типом СУБД. Но что делать, если вам приходится подключаться к 
      MySQL, Microsoft SQL Server и IBM DB2, притом в одном приложении? 
      Аналогичная проблема возникает при разработке приложений, которые не 
      должны зависеть от СУБД; такие приложения работают «над» существующей 
      инфраструктурой клиентской базы данных. ODBC (сокращение от «Open Database 
      Connectivity», то есть «открытая архитектура баз данных») представляет 
      собой интерфейс прикладных программ (API), позволяющий использовать общий 
      набор абстрактных функций для работы с разными типами баз данных. 
      Преимущества подобного подхода очевидны — вам не придется многократно 
      переписывать один и тот же фрагмент кода только для того, чтобы выполнять 
      одинаковые операции с разнотипными базами данных.</P>
      <P>Работа с сервером баз данных через ODBC возможна лишь в том случае, 
      если этот сервер является ODBC-совместимым. Другими словами, для него 
      должны существовать драйверы ODBC. За дополнительной информацией о 
      драйверах ODBC обращайтесь к документации СУБД. Возможно, вам придется 
      дополнительно загрузить их из Интернета и установить на своем компьютере. 
      Хотя стандарт ODBC, разработанный компанией Microsoft, стал открытым 
      стандартом, он в основном используется для работы с СУБД на платформе 
      Windows; впрочем, драйверы ODBC также существуют и на платформе Linux. 
      Ниже приведены ссылки на драйверы для некоторых популярных СУБД.</P>
      <UL>
        <LI>Драйверы баз данных для Windows 95/98/NT: <A 
        href="http.html://www.microsoft.com/data/odbc">http://www.microsoft.com/data/odbc</A> 

        <LI>Automation Technologies: <A 
        href="http.html://www.odbcsdk.com/">http://www.odbcsdk.com/</A> 
        <LI>Easysoft: <A 
        href="http.html://www.easysoft.com/products/oob/main.phtml">http://www.easysoft.com/products/oob/main.phtml</A> 

        <LI>Драйверы ODBC для MySQL (MyODBC): <A 
        href="http.html://www.mysql.com/">http://www.mysql.com/</A> 
        <LI>OpenLinkSoftware: <A 
        href="http.html://www.openlinksw.com/">http://www.openlinksw.com/</A> 
</LI></UL>
      <P>Драйверы ODBC различаются по целям, платформе и назначению. За 
      информацией о различных аспектах работы с этими драйверами обращайтесь к 
      документации по конкретным пакетам. Впрочем, невзирая на все различия, 
      использование этих драйверов в РНР обходится без проблем.</P>
      <P>Когда вы определите, какой комплект драйверов ODBC лучше подходит для 
      ваших целей, загрузите его и выполните все инструкции по установке и 
      настройке. После этого можно переходить к следующему разделу — «Поддержка 
      ODBC в РНР».</P>
      <P><A name=k></A>Поддержка ODBC в РНР</P>
      <P>Функции ODBC в РНР, обычно называемые общими функциями ODBC, не только 
      обеспечивают типовую поддержку ODBC, но и позволяют работать с некоторыми 
      СУБД, обладающими собственным API, через стандартный ODBC API. К числу 
      последних относятся следующие СУБД:</P>
      <UL>
        <LI>Adabas D; 
        <LI>IODBC; 
        <LI>IBM DB2; 
        <LI>Solid; 
        <LI>Sybase SQL Anywhere. </LI></UL>
      <P>Обратите внимание: при работе с перечисленными СУБД стандартный 
      механизм ODBC на самом деле не используется. Просто поддерживаемые в РНР 
      общие функции ODBC применяются для взаимодействия с базами данных. Это 
      удобно, поскольку при переходе на другую ODBC-совместимую СУБД (или СУБД 
      из приведенного выше списка) все ваши сценарии будут нормально 
      работать.</P>
      <P>Поддержка ODBC встроена в комплект поставки РНР, поэтому вам за редкими 
      исключе-ниями практически не придется заниматься специальной 
      настройкой.</P>
      <P>В настоящее время существует около 40 общих функций ODBC. Впрочем, для 
      выборки информации из ODBC-совместимой базы данных вполне достаточно 
      нескольких функций, описанных ниже. Полный список общих функций ODBC в РНР 
      приведен в документации (http://www.php.net/manual).</P>
      <P>odbc_connect( )</P>
      <P>Перед тем как обращаться к ODBC-совместимой базе данных с запросами, 
      необходимо сначала установить с ней связь. Соединение создается функцией 
      ocbc_connect( ). Синтаксис функции odbc_connect( ):</P>
      <P>int odbc_connect (string источник_данных, string имя_пользователя, 
      string пароль [, int тип_курсора])</P>
      <P>Параметр источник_данных определяет ODBC-совместимую базу данных, с 
      которой вы пытаетесь установить связь. В параметрах имя_пользователя и 
      пароль, как нетрудно догадаться, передаются имя пользователя и пароль, 
      необходимые для подключения к источнику данных. Необязательный параметр 
      тип_курсора предназначе'н для устранения проблем, возникающих при работе с 
      некоторыми драйверами ODBC. Он может принимать одно из четырех возможных 
      значений:</P>
      <UL>
        <LI>SQL_CUR_USE_IF_NEEDED; 
        <LI>SQL_CURSOR_USE_ODBC; 
        <LI>SQL_CUR_USE_DRIVER; 
        <LI>SQL CUR DEFAULT. </LI></UL>
      <P>Возможно, вам не придется использовать этот параметр, но все же о нем 
      следует помнить на случай, если ваш пакет ODBC не справится с обработкой 
      того или иного запроса.</P>
      <P>Использовать odbc_connect( ) в программе несложно. Пример:</P>
      <P>&lt;?</P>
      <P>obdc_connect("myAccessDB", "user", "secret")</P>
      <P>or die( "Could not connect to ODBC database");</P>
      <P>?&gt;</P>
      <P>Функция используется для открытия восстанавливаемых (persistent) 
      соединений с базами данных. Она экономит системные ресурсы, поскольку 
      odbc_pconnect( ) проверяет, не было ли данное соединение открыто ранее, и 
      если было, использует предыдущее соединение.</P>
      <P>odbc_close( )</P>
      <P>После завершения работы с ODBC-совместимой базой данных соединение 
      необходимо закрыть, чтобы освободить все ресурсы, используемые открытым 
      соединением. Соединение закрывается функцией odbc_close( ):</P>
      <P>void odbc_close ([int идентификатор_соединения])</P>
      <P>В параметре идентификатор_соединения передается идентификатор открытого 
      соединения. Рассмотрим небольшой пример:</P>
      <P>&lt;?</P>
      <P>obdc_connect("myAccessDB", "user", "secret")</P>
      <P>or die("Could not connect to ODBC database");</P>
      <P>print "Currently connected to ODBC database!"; 
odbc_close($connect);</P>
      <P>?&gt;</P>
      <P>odbc_prepare( )</P>
      <P>Перед непосредственной обработкой запрос необходимо «подготовить». 
      Задача решается функцией odbc_prepare( ):</P>
      <P>int odbc_prepare (int идентификатор_соединения , string запрос)</P>
      <P>В параметре идентификатор_соединения передается идентификатор 
      соединения, возвращаемый функцией odbc_connect( ). В параметре запрос 
      передается текст запроса, который должен быть выполнен сервером. Если 
      запрос не может быть выполнен, функция возвращает FALSE; в противном 
      случае возвращается идентификатор результата, в дальнейшем используемый 
      при вызове функции odbc_execute( ) (см. ниже).</P>
      <P>odbc_execute( )</P>
      <P>Запрос, подготовленный функцией odbc_prepare( ), выполняется функцией 
      odbc_execute( ). Синтаксис функции odbc_execute( ):</P>
      <P>int odbc_execute (int идентификатор результата [, array параметры])</P>
      <P>В параметре идентификатор_результата передается идентификатор 
      результата, возвращаемый при успешном вызове odbc_prepare( ). 
      Необязательный параметр передается лишь в том случае, если при вызове 
      функции передаются дополнительные данные.</P>
      <P>Рассмотрим следующий пример:</P>
      <P>&lt;?</P>
      <P>$connect = @obdc_connect("myAccessDB", "user", "secret")</P>
      <P>or die("Could not connect to ODBC database");</P>
      <P>$query = "UPDATE customers SET cust_id = \"Milano, Inc.\"</P>
      <P>WHERE cust_id \"2000cu\"";</P>
      <P>$result = odbc_prepare($connect, $query) or die("Couldn't prepare 
      query!");</P>
      <P>$result = odbc_execute($result) or die("Couldn't execute query!");</P>
      <P>odbc_close($connect);</P>
      <P>?&gt;</P>
      <P>В приведенном примере продемонстрирована транзакция ODBC, при которой 
      данные запроса не отображаются в браузере (как это обычно делается при 
      использовании команды SELECT). Транзакция ODBC с использованием запроса 
      QUERY описана ниже, в разделе «odbc_result_all( )».</P>
      <P>odbc_exec( )</P>
      <P>Функция odbc_exec( ) объединяет odbc_prepare( ) и odbc_execute( ). 
      Синтаксис функции odbc_exec( ):</P>
      <P>int odbc_exec (int идентификатор_соединения , string запрос)</P>
      <P>В параметре идентификатор_соединения передается идентификатор 
      соединения, возвращаемый функцией odbc_connect( ). В параметре запрос 
      передается текст запроса, который должен быть выполнен сервером. Если 
      запрос не может быть выполнен, функция возвращает FALSE; в противном 
      случае возвращается идентификатор результата, используемый при последующих 
      вызовах функций:</P>
      <P>&lt;?</P>
      <P>obdc_connect("myAccessDB", "user", "secret")</P>
      <P>or die("Could not connect to ODBC database");</P>
      <P>$query = "SELECT * FROM customers";</P>
      <P>$result = odbc_exec($connect, $query) or die("Couldn't execute 
      query!");</P>
      <P>odbc_close($connect) ;</P>
      <P>?&gt;</P>
      <P>В этом примере функция odbc_exec( ) пытается выполнить запрос, текст 
      которого содержится в переменной $query. При успешном выполнении 
      переменной $result присваивается идентификатор результата; в случае 
      неудачи ей присваивается значение FALSE и выводится сообщение, 
      передаваемое при вызове die( ).</P>
      <P>odbc_result_all( )</P>
      <P>Очень удобная функция odbc_result_all( ) форматирует и отображает все 
      записи для идентификатора результата, полученного при вызове odbc_exec( ) 
      или odbc_execute( ). Синтаксис функции odbc_result_all( ):</P>
      <P>int odbc_result_all (int идентификатор_результата [, string 
      формат_таблицы])</P>
      <P>В параметре идентификатор_результата передается идентификатор 
      результата, возвращаемый при успешном вызове odbc_exec( ) или 
      odbc_execute( ). В необязательном параметре формат_таблицы передаются 
      характеристики таблицы HTML. Рассмотрим следующий пример:</P>
      <P>&lt;?</P>
      <P>obdc_connect("myAccessDB", "user", "secret")</P>
      <P>or die("Could not connect to ODBC database");</P>
      <P>$query = "SELECT * FROM customers";</P>
      <P>$result = odbc_exec($connect, $query) or die("Couldn't execute 
      query!");</P>
      <P>odbc_result_all($result, "BGCOLOR='#c0c0c0' border='1' ");</P>
      <P>odbc_close($connect);</P>
      <P>?&gt;</P>
      <P>В результате выполнения этого примера содержимое таблицы customers 
      будет выведено в таблице на светло-сером фоне с рамкой толщиной 1. Внешний 
      вид таблицы для данных, приведенных на рис. 11.1, изображен на рис. 
      11.2.</P>
      <P><IMG src="2_1_11.2Rus.jpg"></P>
      <P>Рис. 11.2. Данные ODBC в браузере</P>
      <P>odbc_free_result ( )</P>
      <P>Хороший стиль программирования требует освобождения всех ресурсов, 
      связанных с завершенными операциями. При работе с запросами ODBC эта 
      задача решается функцией odbc_free_result( ). Синтаксис функции 
      odbc_free_result( ):</P>
      <P>int odbc_free_result (int идентификатор_результата)</P>
      <P>В параметре функции передается идентификатор результата, который больше 
      не будет использоваться в программе. Следует помнить, что все ресурсы 
      памяти автоматически освобождаются по завершении сценария; таким образом, 
      вызов функции odbc_free_result( ) необходим лишь для очень больших 
      запросов, расходующих очень большие объемы памяти. Ниже приведен пример, 
      демонстрирующий применение odbc_free_result( ). Помните, что без этой 
      функции обычно можно обойтись, если только вы не собираетесь выполнять 
      несколько запросов в одном сценарии, поскольку с завершением сценария вся 
      память будет автоматически освобождена.</P>
      <P>&lt;?</P>
      <P>obdc_connect("myAccessDB", "user", "secret")</P>
      <P>or die("Could not connect to ODBC database");</P>
      <P>$query = "SELECT * FROM customers":</P>
      <P>$result = odbc_exec($connect, $query) or die("Couldn't execute 
      query!");</P>
      <P>odbc_result_all($result, "BGCOLOR='#c0c0c0' border='1' "');</P>
      <P>odbc_free_result($result);</P>
      <P>odbc_close($connect);</P>
      <P>?&gt;</P>
      <P>После того как функция odbc_result_all( ) завершила использование 
      идентификатора результата, память возвращается в систему при помощи 
      odbc_free_result( ).</P>
      <P>На этом завершается наше знакомство с функциями ODBC в РНР, 
      незаменимыми при создании простых интерфейсов на базе ODBC для доступа 
      через Web. В следующем разделе многие из этих функций будут использованы 
      для демонстрации того, как легко на базе РНР организуется взаимодействие с 
      одной из самых популярных СУБД — Microsoft Access.</P>
      <P><A name=l></A>Microsoft Access и РНР</P>
      <P>Популярность СУБД Microsoft Access (<A 
      href="http.html://www.microsoft.com/office/access">http://www.microsoft.com/office/access</A>) 
      отчасти объясняется ее удобным графическим интерфейсом. Помимо 
      использования Access в качестве самостоятельной СУБД, вы можете 
      использовать ее графический интерфейс для организации работы с другими 
      базами данных — например, MySQL или Microsoft SQL Server.</P>
      <P>Чтобы продемонстрировать поддержку ODBC в РНР, я опишу процесс 
      подключения к базам данных Microsoft Access на РНР. Делается это на 
      удивление просто, но благодаря популярности Microsoft Access это станет 
      полезным дополнением в вашем творческом арсенале. Я опишу этот процесс шаг 
      за шагом:</P>
      <OL>
        <LI>Создайте базу данных Access. Предполагается, что вы уже умеете это 
        делать, а если не умеете, но все равно хотите проследить за выполнением 
        этого примера, — воспользуйтесь услугами программы-мастера. Я создал 
        стандартную базу данных для хранения контактных данных при помощи 
        мастера. Обязательно создайте в таблице несколько записей и запомните 
        имя таблицы, оно нам вскоре понадобится! 
        <LI>Сохраните базу данных на своем компьютере. 
        <LI>На следующем шаге мы организуем доступ к базе Access средствами 
        ODBC. Выполните команду Пуск &gt; Настройка &gt; Панельуправления (Start 
        &gt; Settings &gt; Control Panel). Найдите на панели управления значок 
        Источники данных ODBC (32) (ODBC Data Sources (32 bit)). При помощи 
        этого значка запускается Администратор ODBC, предназначенный для 
        настройки различных драйверов и источников данных в вашей системе. 
        Запустите программу, дважды щелкнув на этом значке. Окно Администратора 
        по умолчанию открывается на вкладке Пользовательский DSN (User DSN). На 
        этой вкладке перечисляются источники данных-, которые относятся к 
        конкретному пользователю и могут использоваться только на этом 
        компьютере. В данном примере будет использоваться именно такой источник 
        данных. 
        <LI>Нажмите кнопку Добавить... (Add...) в правой части окна. Открывается 
        новое окно для выбора драйвера, предназначенного для работы с новым 
        источником. Выберите строку Microsoft Access Driver (*.mdb) и нажмите 
        кнопку Finish (Готово). 
        <LI>На экране появляется новое окно Установка драйвера ODBC для 
        Microsoft Access (ODBC Microsoft Access Setup). Найдите в форме 
        текстовое поле Имя источника данных (Data Source Name) и введите в нем 
        имя созданной вами базы данных Access. При желании можете ввести 
        описание в текстовом поле, расположенном непосредственно под полем Имя 
        источника данных. 
        <LI>Нажмите кнопку Выбрать... (Select...) — появляется окно в стиле 
        Проводника Windows. В нем вам предлагается найти базу данных, доступ к 
        которой будет осуществляться средствами ODBC. 
        <LI>Найдите в дереве каталогов свою базу данных и дважды щелкните на 
        ней. Вы снова возвращаетесь к окну Установка драйвера ODBC для Microsoft 
        Access. Путь к выбранной базе данных отображается над кнопкой 
        Выбрать.... Нажмите кнопку ОК. 
        <LI>Готово! Теперь вы можете работать с базой данных Access средствами 
        ODBC. </LI></OL>
      <P>Все, что вам остается сделать — создать сценарий, в котором вы будете 
      работать с базой данных через ODBC. В приведенном ниже сценарии общие 
      функции ODBC (см. выше) будут использоваться для вывода всей информации из 
      таблицы контактов, созданной при помощи мастера Access. Однако перед 
      рассмотрением сценария желательно знать, как таблица Contacts выглядит в 
      Access (рис. 11.3).</P>
      <P><IMG src="2_1_11.3Rus.jpg"></P>
      <P>Рис. 11.3. Таблица Contacts в MS Access</P>
      <P>Теперь вы знаете, какая информация будет извлекаться из базы данных, и 
      мы можем перейти к сценарию. Если вы забыли, что делает та или иная 
      функция, обращайтесь к описанию в начале этой главы. Результаты работы 
      листинга 11.7 представлены на рис. 11.4.</P>
      <P>Листинг 11.7. Применение функций ODBC для работы с MS Access</P>
      <P>&lt;?php</P>
      <P>// Подключиться к источнику данных ODBC 'ContactDB' ;connect = 
      odbc_connect("ContactDB", "","")</P>
      <P>or die("Couldn't connect to datasource.");</P>
      <P>// Создать текст запроса</P>
      <P>$query = "SELECT First_Name, Last_Name, Cell_Phone, Email FROM 
      Contacts";</P>
      <P>// Подготовить запрос</P>
      <P>$result = odbc_prepare($connect,$query);</P>
      <P>// Выполнить запрос и вывести результаты</P>
      <P>odbc_execute($result);</P>
      <P>odbc_result_all($result, "BGCOLOR='#c0c0c0' border=1");</P>
      <P>// Обработка результатов закончена, освободить память 
      odbc_free_result($result);</P>
      <P>// Закрыть соединение odbc_close($connect);</P>
      <P>?&gt;</P>
      <P>Не правда ли, все просто? А самое замечательное — то, что этот сценарий 
      полностью совместим с любой другой СУБД с поддержкой ODBC. Для тренировки 
      попробуйте повторить все описанные действия для другой СУБД, запустите 
      сценарий — и вы получите те же результаты, которые изображены на рис. 
      11.4.</P>
      <P><IMG src="2_1_11.4Rus.jpg"></P>
      <P>Рис. 11.4. Содержимое таблицы Contacts в web-браузере</P>
      <P><A name=m></A>Проект: каталог ссылок</P>
      <P>Самый простой способ наполнить ваш сайт реальным содержанием — дать 
      пользователю возможность сделать это за вас. Конечно, для ввода данных 
      удобнее всего воспользоваться формой HTML.</P>
      <P>Введенную пользователем информацию необходимо обработать и сохранить. В 
      проекте предыдущей главы было показано, как легко эта задача решается при 
      помощи РНР и текстового файла. Бесспорно, текстовые файлы хорошо подходят 
      для хранения относительно маленьких и простых фрагментов данных, но в 
      полноценных web-приложениях информация обычно хранится в базах данных. В 
      настоящем примере база данных MySQL используется для хранения информации о 
      web-сайтах. Для упрощения навигации сайты разделены на несколько 
      категорий. Пользователь может ввести информацию о сайте в форме HTML и 
      отнести его к одной из стандартных категорий, определенных администратором 
      сайта. Кроме того, пользователь может загрузить индексную страницу и 
      просмотреть список всех сайтов той или иной категории, щелкнув на ее 
      названии.</P>
      <P>Прежде всего вы должны решить, какие сведения о сайтах будут храниться 
      в базе данных SQL. Для простоты я ограничусь следующим набором атрибутов: 
      название, URL, категория, дата включения и описание. Таким образом, 
      определение таблицы в MySQL выглядит примерно так:</P>
      <P>mysql&gt;create table bookmarks ( category INT, site_name char(35), url 
      char(50),</P>
      <P>date_added date, description char(254) );</P>
      <P>В определении таблицы bookmarks имеется пара моментов, заслуживающих 
      внимания. Во-первых, информация о категории сайта почему-то хранится в 
      виде целого числа — но разве не правильнее было бы сделать названия 
      категорий более содержательными и понятными для пользователя? Не 
      беспокойтесь, в ини-циализационном файле будет создан массив, связывающий 
      целочисленные индексы с названиями категорий. В будущем администратор 
      может изменять и даже удалять отдельные категории. Хранение информации о 
      категориях заметно упрощает эту задачу. Кроме того, целочисленное поле 
      обеспечивает экономию места на диске, поскольку название категории 
      многократно сохраняется в таблице. Другое обстоятельство, относящееся к 
      структуре таблицы, — ограничение длины описания 254 символами. В 
      зависимости от этого объема описаний вместо типа char( ) можно 
      воспользоваться типом medium или text. За дополнительной информацией о 
      типах полей обращайтесь к документации MySQL.</P>
      <P>Следующим шагом в работе над этим приложением будет создание 
      инициализа-ционного файла. Помимо глобальных переменных, в 
      инициализационном файле определяются две функции: add_bookmark( ) и 
      view_bookmark( ). Функция add_bookmark( ) получает пользовательский ввод 
      из формы и включает его в базу. Функция view_bookmark( ) получает индекс 
      категории, читает из базы данных все записи, относящиеся к указанной 
      категории, и отображает их в браузере. Инициализацион-ный файл приложения 
      init.inc с комментариями приведен в листинге 11.8.</P>
      <P>Листинг 11.8. Инициализационный файл каталога ссылок (init.inc)</P>
      <P>&lt;?</P>
      <P>// Файл: init.inc</P>
      <P>// Назначение: глобальные переменные и функции.</P>
      <P>// используемые в проекте</P>
      <P>// Стандартный заголовок страницы $title = "My Bookmark 
Repository":</P>
      <P>// Цвет фона $bg_color = "white";</P>
      <P>// Дата</P>
      <P>$post_date = date("Ymd");</P>
      <P>// Категории $categories = array(</P>
      <P>"computers",</P>
      <P>"entertainment",</P>
      <P>"dining",</P>
      <P>"lifestyle",</P>
      <P>"government",</P>
      <P>"travel");</P>
      <P>// Данные сервера MySQL $host = "localhost"; $user = "root"; $pswd = 
      "";</P>
      <P>// Имя базы данных $database = "book";</P>
      <P>// Имя таблицы $bookmark_table = "bookmarks";</P>
      <P>// Цвет ячеек таблицы $cell_color = "#c0c0c0";</P>
      <P>// Установить соединение с сервером MySQL</P>
      <P>@mysql_pconnect($host, $user, $pswd) or die("Couldn't connect to MySQL 
      server!");</P>
      <P>// Выбрать базу данных</P>
      <P>@mysql_select_db($database) or die("Couldn't select Sdatabase 
      database!");</P>
      <P>// Функция: add_bookmark( )</P>
      <P>// Назначение: включение новой ссылки в таблицу bookmark.</P>
      <P>function add_bookmark (Scategory, Ssitejname. $url, $description) {</P>
      <P>GLOBAL $bookmark_table, $post_date;</P>
      <P>$query = "INSERT INTO $bookmark_table</P>
      <P>VALUES(\"$category\", \"$site_name\", \"$url\", \"$post_date\", 
      \"$description\")";</P>
      <P>$result = @mysql_query($query) or die("Couldn't insert bookmark 
      information!");</P>
      <P>} // add_bookmark &lt;</P>
      <P>// Функция: view_bookmark( )</P>
      <P>// Назначение: выборка из таблицы bookmark всех ссылок,</P>
      <P>// относящихся к категории $category.</P>
      <P>function view_bookmark ($category) {</P>
      <P>GLOBAL $bookmark_table, $cell_color, $categories;</P>
      <P>$query = "SELECT site_name, url, DATE_FORMAT(date_added,'%m-%d-%Y') AS 
      date_added, description</P>
      <P>FROM $bookmark table WHERE category = $category ORDER BY datejdded 
      DESC";</P>
      <P>$result = @mysql_query($query);</P>
      <P>print "&lt;div align=\"center\"&gt;&lt;table cellpadding=\"2\" 
      cellspacing=\"1\" border = \"0\" width = \"600\"&gt;";</P>
      <P>print "&lt;tr&gt;&lt;td bgcolor-\"$cell_color\"&gt;&lt;b&gt;Category: 
      $categories[$category]&lt;/b&gt;&lt;/td&gt;&lt;/tr&gt;";</P>
      <P>if (mysql_numrows($result) &gt; 0) ;</P>
      <P>while ($row = mysql_fetch_array($result)) ;</P>
      <P>Posted: ".$row["date added"]."&lt;br&gt;"</P>
      <P>else</P>
      <P>print "&lt;tr&gt;&lt;td&gt;";</P>
      <P>print "&lt;b&gt;".$row["site_name"]."&lt;/b&gt;</P>
      <P>print "&lt;/td&gt;&lt;/tr&gt;";</P>
      <P>print "&lt;tr&gt;&lt;td&gt;";</P>
      <P>print "&lt;a href = \"http://".$row["url"]."\"&gt;http://".</P>
      <P>$row["url"]."&lt;/a&gt;&lt;br&gt;";</P>
      <P>print "&lt;/td&gt;&lt;/tr&gt;";</P>
      <P>print "&lt;tr&gt;&lt;td valign=\"top\"&gt;";</P>
      <P>print $row["description"]."&lt;br&gt;";</P>
      <P>print "&lt;/td&gt;&lt;/tr&gt;";</P>
      <P>print "&lt;tr&gt;&lt;td&gt;&lt;hr&gt;&lt;/td&gt;&lt;/tr&gt;";</P>
      <P>endwhile;</P>
      <P>print "&lt;tr&gt;&lt;td&gt;There are currently no bookmarks falling 
      under this category. Why don't you &lt;a href=\"add_bookmark.php\"&gt;add 
      one&lt;/a&gt;?&lt;/td&gt;&lt;/tr&gt;";</P>
      <P>endif:</P>
      <P>print "&lt;/table&gt;&lt;a href=\"Listing11-11.php\"&gt;Return to 
      index&lt;/a&gt;</P>
      <P>print "&lt;a href=\"add_bookmark.php\"&gt;Add a 
      bookmark&lt;/a&gt;&lt;/div&gt;";</P>
      <P>// view bookmark</P>
      <P>?&gt;</P>
      <P>Следующая страница, add_bookmark.php (листинг 11.9), предназначена для 
      ввода информации о новой ссылке, включаемой в базу данных. Для обработки 
      пользовательских данных вызывается функция add_bookmark( ).</P>
      <P>Листинг 11.9. Программа add_bookmark.php</P>
      <P>&lt;html&gt;</P>
      <P>&lt;?</P>
      <P>INCLUDE("init.inc");</P>
      <P>?&gt;</P>
      <P>&lt;head&gt;</P>
      <P>&lt;title&gt;&lt;?=$title:?&gt;&lt;/title&gt; &lt;/head&gt;</P>
      <P>&lt;body bgcolor="#ffffff" text="#000000" link="#808040" 
      vlink="#808040" alink="#808040"&gt; if (! $seenform) :</P>
      <P>&lt;form action="add_bookmark.php" method="post"&gt; &lt;1nput 
      type="hidden" name="seenform" value="y"&gt;</P>
      <P>Category:&lt;br&gt;</P>
      <P>&lt;select name="category"&gt;</P>
      <P>&lt;option value=""&gt;Choose a category:</P>
      <P>while (list($key, $value) = each($categories)) :</P>
      <P>print "&lt;option value=\"$key\"&gt;$value"; endwhile:</P>
      <P>&lt;/select&gt;&lt;br&gt;</P>
      <P>Site Name:&lt;br&gt;</P>
      <P>&lt;input type="text" name="site_name" size="15" maxlength="30" 
      value=""&gt;&lt;br&gt;</P>
      <P>URL: (do &lt;i&gt;not&lt;/1&gt; include "http://"!)&lt;br&gt;</P>
      <P>&lt;input type="text" name="url" size="35" maxlength="50" 
      value=""&gt;&lt;br&gt;</P>
      <P>Description:&lt;br&gt;</P>
      <P>&lt;textarea name="description" rows="4" 
      cols="30"&gt;&lt;/textarea&gt;&lt;br&gt;</P>
      <P>&lt;input type="submit" value="submit"&gt;</P>
      <P>&lt;/form&gt;</P>
      <P>else :</P>
      <P>add_bookmark($category, $site_name, $url, $description);</P>
      <P>print "&lt;h4&gt;Your bookmark has been added to the repository.</P>
      <P>&lt;a href=\"Listing11-11.php\"&gt;Click here&lt;/a&gt; to return to 
      the index.&lt;/h4&gt;";</P>
      <P>endif;</P>
      <P>?&gt;</P>
      <P>При исходной загрузке страницы в браузере отображается форма (рис. 
      11.5).</P>
      <P>После сохранения ссылки в базе программа выдает соответствующее 
      сообщение и создает ссылку для перехода к домашней странице приложения 
      index.php (листинг 11.11).</P>
      <P><IMG src="2_1_11.5Rus.jpg"></P>
      <P>Рис. 11.5. Форма, отображаемая страницей add_bookmark.php</P>
      <P>Следующая страница, view_bookmark.php, просто вызывает функцию 
      view_bookmark( ). Код этой страницы приведен в листинге 11.10.</P>
      <P>Листинг 11.10. Программа view_bookmark.php</P>
      <P>&lt;html&gt;</P>
      <P>&lt;?</P>
      <P>INCLUDE("Listing11-8.php"); ?&gt;</P>
      <P>&lt;head&gt;</P>
      <P>&lt;title&gt;&lt;?=$title:?&gt;&lt;/title&gt;</P>
      <P>&lt;/head&gt;</P>
      <P>&lt;body bgcolor="&lt;?=$bg_color;?&gt;" text="#000000" link="#808040" 
      vlink="#808040" alink="#808040"&gt;</P>
      <P>view_bookmark($category) :</P>
      <P>?&gt;</P>
      <P>Если занести в категорию dining информацию о нескольких сайтах, 
      страница view_bookmark.php будет выглядеть примерно так, как показано на 
      рис. 11.6.</P>
      <P><IMG src="2_1_11.6Rus.jpg"></P>
      <P>Рис. 11.6. Выполнение страницы view_bookmark.php для категории 
      dining</P>
      <P>Остается лишь создать страницу, на которой пользователь выбирает ссылки 
      из списка. Я назвал этот файл index.php (листинг 11.11).</P>
      <P>Листинг 11.11. Программа index.php</P>
      <P>&lt;html&gt;</P>
      <P>&lt;?</P>
      <P>INCLUDE("init.inc");</P>
      <P>?&gt;</P>
      <P>&lt;head&gt;</P>
      <P>&lt;titlex?-$title:?&gt;&lt;/title&gt;</P>
      <P>&lt;/head&gt;</P>
      <P>&lt;body bgcolor="&lt;?=$bg_color;?&gt;" text="#000000" link="#808040" 
      vlink="#808040"</P>
      <P>alink="#808040"&gt;</P>
      <P>&lt;h4&gt;Choose bookmark category to view:&lt;/h4&gt;</P>
      <P>&lt;?</P>
      <P>// Перебрать категории и создать соответствующие ссылки</P>
      <P>while (list($key, Svalue) = each(Scategories)) :</P>
      <P>print "&lt;a href = 
      \"view_bookmark.php?category=$key\"&gt;$value&lt;/a&gt;&lt;br&gt;";</P>
      <P>endwhile;</P>
      <P>?&gt;</P>
      <P>&lt;p&gt;</P>
      <P>&lt;b&gt;&lt;a href="add_bookmark.html.php"&gt;Add a new 
      bookmark&lt;/a&gt;&lt;/b&gt;</P>
      <P>&lt;/body&gt;</P>
      <P>&lt;/html&gt;</P>
      <P>Если оставить в массиве $categories значения, сохраненные в файле 
      init.inc, в результате выполнения листинга 11.11 в браузер будет отправлен 
      код HTML, приведенный в листинге 11.12.</P>
      <P>Листинг 11.12. Выходные данные, сгенерированные при выполнении 
      index.php</P>
      <P>&lt;html&gt;</P>
      <P>&lt;head&gt;</P>
      <P>&lt;title&gt;&lt;/title&gt;</P>
      <P>&lt;/head&gt;</P>
      <P>&lt;body bgcolor="white" text="#000000" link="#808040" vlink="#808040" 
      alink="#808040"&gt;</P>
      <P>&lt;h4&gt;Choose bookmark category to view:&lt;/h4&gt;</P>
      <P>&lt;a href = 
      "view_bookmark.php?category=0"&gt;computers&lt;/a&gt;&lt;br&gt;</P>
      <P>&lt;a href = 
      "view_bookmark.php?category=1"&gt;entertainment&lt;/a&gt;&lt;br&gt;</P>
      <P>&lt;a href = "view_bookmark.php?category=2"&gt;dining&lt;/axbr&gt;</P>
      <P>&lt;a href - 
      "view_bookmark.php?category=3"&gt;lifestyle&lt;/a&gt;&lt;br&gt;</P>
      <P>&lt;a href = 
      "view_bookmark.,php?category=4"&gt;government&lt;/a&gt;&lt;br&gt;</P>
      <P>&lt;a href = 
      "view_bookmark.php?category=5"&gt;travel&lt;/a&gt;&lt;br&gt;</P>
      <P>&lt;p&gt;</P>
      <P>&lt;b&gt;&lt;a href=add_bookmark.php"&gt;Add a new 
      bookmark&lt;/a&gt;&lt;/b&gt;</P>
      <P>&lt;/body&gt;</P>
      <P>&lt;/html&gt;</P>
      <P>Если щелкнуть на любой ссылке из приведенного выше,фрагмента HTML, в 
      браузере загружается файл view_bookmark.php, который вызывает функцию 
      view_bookmark( ) и передает ей значение переменной $category.</P>
      <P><A name=n></A>Итоги</P>
      <P>Эта глава получилась довольно большой, причем для некоторых читателей 
      она может оказаться самой важной во всей книге. Бесспорно, работа с базами 
      данных</P>
      <P>относится к числу самых заметных возможностей языка РНР, поскольку базы 
      данных заметно расширяют функциональные возможности web-сайтов. В 
      частности, мы рассмотрели следующие темы:</P>
      <UL>
        <LI>общие сведения о SQL; 
        <LI>стандартную поддержку баз данных в РНР; 
        <LI>вводную информацию о сервере MySQL; 
        <LI>стандартные функции РНР для работы с MySQL; 
        <LI>реализацию простейшей поисковой системы; 
        <LI>сортировку таблиц; 
        <LI>общие сведения об ODBC; 
        <LI>стандартные функции РНР для работы с ODBC; 
        <LI>взаимодействие с Microsoft Access в РНР; 
        <LI>хранение пользовательских данных на web-сайте. </LI></UL>
      <P>Читателю, занимающемуся разработкой больших, подлинно динамических 
      web-сайтов на РНР, предстоит снова и снова возвращаться к теме баз данных. 
      Я рекомендую тщательно изучить не только документацию РНР, но и другие 
      ресурсы, посвященные технологиям баз данных. В этой области, как и во 
      многих современных технологиях, даже эксперты не всегда успевают следить 
      за всеми новшествами.</P>
      <P>Следующая глава посвящена шаблонам — одной из нетривиальных тем 
      web-программирования. Применение шаблонов при программировании на РНР 
      обеспечивает заметную экономию времени и усилий при работе над 
      крупномасштабными web-сайтами.</P></LI></DIV>
<center>
[ <a href="10.php">Назад</a> | <a href="index.php">Содержание</a> | <a href="12.php">Вперед</a> ]
</center><br>
<? include_once '../../sys/inc/tfoot.php'; ?>