<? include 'head.php' ?>
<!DOCTYPE php PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html><head>
<link rel="stylesheet" href="css.css" type="text/css">
<meta http-equiv="Content-Type" content="text/html; charset=windows-1251">
<meta http-equiv="Content-Language" content="ru">
<title>Приложение C.</title></head>
<body>
<h1>Приложение C</h1>
<hr width="50%">
<h1>Некоторые общие нестандартные средства SQL</h1>
<p>Имеется ряд особенностей языка SQL, которые пока не определены как часть 
стандарта ANSI или стандарта ISO (Международная Организация По Стандартизации), 
и являются общими для многочисленных реализаций, так как они были получены для 
практического использования. Конечно, эти особенности меняются от программы к 
программе, и их обсуждение предназначено только для того, чтобы показать 
некоторые общие подходы к ним.</p>
<h3>ТИПЫ ДАННЫХ</h3>
<p>Типы данных, поддерживаемые стандартом SQL, собраны в <a href="b.php">Приложении B</a>. Это 
CHARACTER и разнообразные числовые типы. Реализация их может оказаться 
значительно сложнее, чем показано в терминах типов, которые они фактически могут 
использовать. Мы будем здесь обсуждать ряд таких нестандартных типов данных.</p>
<h4>ТИПЫ DATE И TIME</h4>
<p>Как упомянуто в<a href="ch2.php"> Главе 2</a>, тип DATE широко 
поддерживается, хотя он не является частью стандарта. Мы использовали ранее в 
нашей таблице Заказов этот тип в формате mm/dd/yyyy. Это стандартный формат IBM 
в США. Разумеется, возможны и другие форматы, и программные реализации часто 
поддерживают несколько форматов, позволяя вам выбирать наиболее подходящий.</p>
<p>Реализация, которая предлагает эту особенность, должна быть способна 
преобразовывать дату одного формата в другой автоматически.</p>
<p>Имеются несколько основных форматов даты с которыми вы можете столкнуться:</p>
<table>
<tr><th>Стандарт</th><th>Формат</th><th>Пример</th></tr>
<tr><td>Международная Организация По Стандартизации (ISO)</td><td>yyyy-mm-dd</td><td>1990-10-31</td></tr>
<tr><td>Японский Индустриальный Стандарт (JIS)</td><td>yyyy-mm-dd</td><td>1990-10-31</td></tr>
<tr><td>IBM Европейский Стандарт (EUR)</td><td>dd.mm.yyyy</td><td>10.31.1990</td></tr></table>
<p>Наличие специального типа даты даёт возможность выполнять арифметические 
операции с датами. Например, вы можете добавлять число дней к дате и получать 
другую дату в программе, самостоятельно следящей за числом дней в месяцах, 
високосными годами и т.д.</p>
<p>Даты могут также сравниваться; например фраза, 
дата A &lt; дата B , означает, что дата A предшествует дате B по времени. Помимо 
даты, большое количество программ определяют специальный тип для времени, 
который может также быть представлен в ряде форматов, включая следующие:</p>
<table>
<tr><th>Стандарт</th><th>Формат</th><th>Пример</th></tr><tr><td>МЕЖДУНАРОДНАЯ ОРГАНИЗАЦИЯ ПО СТАНДАРТИЗАЦИИ (ISO)</td>
<td>hh-mm-ss</td><td>21.04.37</td></tr>
<tr><td>Японский Индустриальный Стандарт (JIS )</td><td>hh-mm-ss</td><td>21.04.37</td></tr>
<tr><td>IBM Европейский Стандарт</td><td>hh-mm-ss</td><td>21.04.37</td></tr>
<tr><td>IBM USA Стандарт (USA)</td><td>hh.mm AM/PM</td><td>9.04 PM</td></tr></table>
<p>Время может добавляться или сравниваться точно так же, как дата, с 
автоматической коррекцией числа секунд в минутах или часах. Кроме того, 
специально встроенные константы, указывающие текущую дату или время (CURDATE или 
CURTIME), являются общими. Они похожи на константу USER (Пользователь) в которой 
их значение будет непрерывно меняться.</p>
<p>Можете ли вы включать время и дату в одно 
поле? Некоторые реализации определяют тип DATE достаточно точно, чтобы включать 
туда ещё и TIME. В качестве альтернативы третий обобщающий тип, TIMESTAMP, может 
быть определен как комбинация этих двух.</p>
<hr width="70%">
<h3>ТИПЫ ТЕКСТОВОЙ СТРОКИ</h3>
<p>ANSI поддерживает только один тип для представления текста. Это тип CHAR. 
Любое поле такого типа должно иметь определённую длину. Если строка, вставленная 
в поле, меньше длины поля, она дополняется пробелами; строка не может быть длиннее поля.</p>
<p>Хотя и достаточно удобное, это определение всё же имеет некоторые ограничения 
для пользователя. Например, символьные поля должны иметь одинаковую длину, чтобы 
можно было выполнить команду UNION. Большинство реализаций поддерживают строки 
переменной длины для типов данных VARCHAR и LONG VARCHAR (или просто LONG). В то 
время как поле типа CHAR всегда может распределить память для максимального числа 
символов, которое может сохраняться в поле, поле VARCHAR при любом количестве 
символов может распределить только определённое количество памяти, чтобы 
сохранить фактическое содержание поля, хотя SQL может установить извне некоторое 
дополнительное пространство памяти, чтобы следить за текущей длиной поля.<br>
Поле VARCHAR может быть любой длины, включая реализационно определяемый максимум. 
Этот максимум может меняться от 254 до 2048 символов для VARCHAR и до 16000 
символов для LONG. LONG обычно используется для текста пояснительного характера 
или для данных, которые не могут легко сжиматься в простые значения полей; 
VARCHAR может использоваться для любой текстовой строки, чья длина может 
меняться. Между прочим, не всегда хорошо использовать VARCHAR вместо CHAR. 
Извлечение и модифицирование полей VARCHAR - более сложный и, следовательно, 
более медленный процесс, чем извлечение и модифицирование полей CHAR. Кроме 
того, некоторое количество памяти VARCHAR остается всегда неиспользованной (в 
резерве) для гарантии вмещения всей строки. Вы должны просчитывать, насколько 
значения полей могут меняться по длине, а также - способны ли они к объединению 
с другими полями, перед тем как решить, использовать CHAR или VARCHAR. Часто тип 
LONG используется для сохранения двоичных данных. Естественно, что использование 
размера такого &quot;неуклюжего&quot; поля будет ограничивать оперативность SQL. 
Проконсультируйтесь с вашим руководством.</p>
<hr width="70%">
<h3>КОМАНДА FORMAT</h3>
<p>Как мы подчеркивали в Главе 7, процесс вывода выполняемого в стандарте SQL, 
имеет ограничения. Хотя большинство реализаций включают SQL в пакеты, имеющие 
другие средства для управления этой функцией, некоторые реализации также 
используют команду типа FORMAT внутри SQL чтобы навязывать выводу запроса 
определённые формы структуры или ограничения.</p>
<p>Среди возможных функций команды FORMAT существуют такие:</p>
<ul>
<li>определение ширины столбцов (при печати)</li>
<li>определение представления NULL-значений</li>
<li>обеспечение (новых) заголовков для столбцов</li>
<li>обеспечение заголовков внизу или вверху страниц, выводимых на печать</li>
<li>навязывает присвоение или изменение форматам полей, содержащих значения даты, времени или денежной суммы</li>
<li>вычисляет общие и промежуточные суммы, не исключая возможности обобщения поля, как это делает, например, SUM<br>
<font size="2">(Альтернативным подходом к этой проблеме в некоторых программах 
является предложение COMPUTE.)</font></li></ul>
<p>Команда FORMAT может вводиться сразу перед или сразу после запроса, к 
которому она применяется, в зависимости от реализации. Одна команда FORMAT 
обычно может применяться только к одному запросу, хотя любое число команд FORMAT 
может применяться к одному и тому же запросу.</p>
<p>Вот некоторые примеры команды FORMAT:</p>
<pre>       FORMAT NULL '_ _ _ _ _ _ _';
       FORMAT BTITLE 'Orders Grouped by Salesperson';
       FORMAT EXCLUDE (2, 3);</pre>
<p>Первая команда<b> NULL</b> представляется в виде<b> ' _ _ _ _ _ _ _ '</b> при 
выводе на печать; вторая вставляет заголовок<b> 'Orders Grouped by Salesperson'</b> 
в нижнюю часть каждой страницы; третья исключает второй и третий столбцы из 
вывода предыдущего запроса. Вы могли бы использовать последнюю, если выбираете 
конкретные столбцы, чтобы использовать их в предложении <b>ORDER BY</b> в вашем 
выводе. Так как указанные функции команды FORMAT могут выполняться по разному, 
все варианты их использования не могут быть здесь показаны.</p>
<p>Имеются другие команды, которые могут использоваться для выполнения тех же 
функций. Команда SET подобна команде FORMAT; она является вариантом или 
дополнением к команде, которая применяется во всех запросах текущего сеанса 
пользователя, а не просто в одиночном запросе. В следующей реализации, команда 
FORMAT начинается ключевым словом COLUMN следующим образом:<br>
<br>
<b>COLUMN odate FORMAT dd-mon-yy;</b><br>
<br>
что форсирует формат типа 10-Oct-90 в поле даты, использующемся в выводе 
запроса на печать. Предложение COMPUTE, упомянутое ранее, вставляется в запрос, 
следующим образом:</p>
<pre>        SELECT odate, amt
           FROM Orders
           WHERE snum = 1001
           COMPUTE SUM (amt);</pre>
<p>Оно выводит все заказы продавца Peel с датой и суммой приобретения по каждой 
дате, а в конце - общую сумму приобретений. Другая реализация выводит 
промежуточные суммы приобретений, используя COMPUTE в качестве команды. Сначала, 
она определяет разбивку</p>
<pre>            BREAK ON odate;</pre>
<p>вывода вышеупомянутого запроса на страницы, сгруппировав по датам, поэтому 
все значения odate в каждой группе - одинаковые. Затем вы можете ввести 
следующее предложение:</p>
<pre>           COMPUTE SUM OF amt ON odate;</pre>
<p>Столбец в предложении ON предварительно должен быть использован в команде BREAK.</p>
<hr width="70%">
<h3>ФУНКЦИИ</h3>
<p>Для SQL в стандарте ANSI вы можете применять агрегатные функции для столбцов 
или использовать их значения в скалярных выражениях, таких, например, как comm * 
100. Имеется много других полезных функций, которые вы, вероятно, встречали на 
практике.</p>
<p>Имеется список некоторых общих функций SQL, отличающихся от стандартных 
агрегатов. Они могут использоваться в предложениях SELECT-запросов точно так 
же, как агрегатные функции, но эти функции выполняются для одиночных значений, а 
не для групповых. В следующем списке они классифицированы согласно типам данных, 
с которыми они работают. Если нет примечаний, то переменные в этом списке 
стандартизированы для любого выражения значений соответствующего типа, которые могут быть использованы в предложении SELECT.</p>
<h4>МАТЕМАТИЧЕСКИЕ ФУНКЦИИ</h4>
<p>Эти функции применяются для работы с числами.</p>
<table>
<tr><th>ФУНКЦИЯ</th><th>ЗНАЧЕНИЕ</th></tr>
<tr><td>ABX(X)</td><td>Абсолютное значение X (преобразование отрицательного или положительного значения в положительное).</td></tr>
<tr><td>CEIL (X)</td><td>X является десятичным значением, которое будет округляться сверху.</td></tr>
<tr><td>FLOOR (X)</td><td>X является десятичным значением, которое будет округляться снизу.</td></tr>
<tr><td>GREATEST(X,Y)</td><td>Возвращает большее из двух значений.</td></tr>
<tr><td>LEAST(X,Y)</td><td>Возвращает меньшее из двух значений.</td></tr>
<tr><td>MOD(X,Y)</td><td>Возвращает остаток от деления X на Y.</td></tr>
<tr><td>POWER(X,Y)</td><td>Возвращает значение X в степени Y.</td></tr>
<tr><td>ROUND(X,Y)</td><td>Цикл от X до десятичного Y. Если Y отсутствует, цикл до целого числа.</td></tr>
<tr><td>SING(X)</td><td>Возвращает минус если X &lt; 0, или плюс если X &gt; 0.</td></tr>
<tr><td>SQRT (X)</td><td>Возвращает квадратный корень из X.</td></tr></table>
<h4>СИМВОЛЬНЫЕ ФУНКЦИИ</h4>
<p>Эти функции могут быть применены для строк текста из столбцов текстовых типов 
данных, либо из строк литерных текстов, или же из комбинации этих двух.</p>
<table>
<tr><th>ФУНКЦИЯ</th><th>ЗНАЧЕНИЕ</th></tr>
<tr><td>LEFT(&lt;string&gt;,X)</td><td>Возвращает крайние левые (старшие) символы X из строки.</td></tr>
<tr><td>RICHT(&lt;string&gt;,X)</td><td>Возвращает символы X младшего разряда из строки </td></tr>
<tr><td>ASCII(&lt;string&gt;)</td><td>Возвращает код ASCII, которым строка представляется в памяти компьютера.</td></tr>
<tr><td>CHR(&lt;asciicode&gt;)</td><td>Возвращает принтерные символы кода ASCII.</td></tr>
<tr><td>VALUE(&lt;string&gt;)</td><td>Возвращает математическое значение для строки. Считается, что строка 
имеет тип CHAR или VARCHAR, но состоит из чисел. VALUE('3') произведёт число 3 типа INTEGER.</td></tr>
<tr><td>UPPER(&lt;string&gt;)</td><td>Преобразует все символы строки в символы верхнего регистра.</td></tr>
<tr><td>LOWER(&lt;string&gt;)</td><td>Преобразует все символы строки в символы нижнего регистра.</td></tr>
<tr><td>INlTCAP(&lt;string&gt;)</td><td>Преобразует начальные символы строки в заглавные буквы. В некоторых реализациях может иметь название PROPER.</td></tr>
<tr><td>LENGTH(&lt;string&gt;)</td><td>Возвращает число символов в строке.</td></tr>
<tr><td>&lt;string&gt;||</td>
<td>Объединяет две строки в выводе, так чтобы после первой немедленно следовала вторая. (значок || называется оператором сцепления).</td></tr>
<tr><td>LPAD(&lt;string&gt;,X,'*' )</td>
<td>Дополняет строку слева звездочками '*' или любым другим указанным символом в количестве, определяемом X.</td></tr>
<tr><td>RPAD(&lt;string&gt;,X, &quot;)</td>
<td>То же самое что и LPAD, за исключением того, что дополнение делается справа.</td></tr>
<tr><td>SUBSTR(&lt;string&gt;,X,Y)</td><td>Извлекает Y символов из строки, начиная с позиции X.</td></tr></table>
<h4>ФУНКЦИИ ДАТЫ И ВРЕМЕНИ</h4>
<p>Эти функции выполняются только для допустимых значений даты или времени.</p>
<table>
<tr><th>ФУНКЦИЯ</th><th>ЗНАЧЕНИЕ</th></tr><tr><td>DAY(<date>)</date></td>
<td>Извлекает день месяца из даты. Подобные же функции существуют для MONTH 
(МЕСЯЦ), YEAR (ГОД), HOUR (ЧАС), SECOND (СЕКУНДА) и так далее.</td></tr>
<tr><td>WEEKDAY(<date>)</date></td><td>Извлекает день недели из даты.</td></tr></table>
<h4>ДРУГИЕ ФУНКЦИИ</h4>
<p>Эта функция может быть применена к любому типу данных.</p>
<table>
<tr><th>ФУНКЦИЯ</th><th>ЗНАЧЕНИЕ</th></tr>
<tr>
<td>NVL(&lt;column&gt;,&lt;value&gt;)</td>
<td>NVL (NULL-значение) будет менять на
&lt;value&gt; каждое NULL значение, найденное в столбце &lt;column&gt;. Если полученное значение
&lt;column&gt; не = NULL, NVL ничего не делает.</td></tr></table>
<hr>
<h3>INTERSECT И MINUS</h3>
<p>Команда UNION, как вы уже видели в Главе 14, может объединить два запроса, 
объединив их вывод в один. Два других, обычно имеющихся способа объединения 
отдельных запросов, - это INTERSECT (Плюс) и MINUS (Минус). INTERSECT выводит 
только строки, произведённые обоими перекрестными запросами, в то время как MINUS выводит строки, которые производятся одним запросом, но не другим.</p>
<p>Следовательно, следующие два запроса</p>
<pre>      SELECT *
         FROM Salespeople
         WHERE city = 'London'

         INTERSECT

      SELECT *
         FROM Salespeople
         WHERE 'London' IN
            (SELECT city
                FROM Customers
                WHERE Customers.snum =
                 Salespeople.snum);</pre>
<p>выведут строки, произведённые обоими запросами, выдающими всех продавцов в 
Лондоне, которые имели по крайней мере одного заказчика, размещённого там также. 
С другой стороны, запрос</p>
<pre>      SELECT *
         FROM Salespeople
         WHERE city = 'London'

         MINUS

      SELECT *
         FROM Salespeople
         WHERE 'London' IN
            (SELECT sity
                FROM Customers
                WHERE Customers.snum =
                 Salespeople.snum);</pre>
<p>удалит строки, выбранные вторым запросом, из вывода первого, и, таким 
образом, будут выведены все продавцы в Лондоне, которые не имели там заказчиков.</p>
<p>MINUS иногда ещё называют DIFFERENCE (ОТЛИЧИЕ).</p>
<hr>
<h3>АВТОМАТИЧЕСКИЕ ВНЕШНИЕ ОБЪЕДИНЕНИЯ</h3>
<p>В<a href="ch14.php"> Главе 14</a> мы обсуждали внешнее объединение и 
показывали вам, как выполнять его, используя команду UNION. Некоторые программы 
баз данных имеют более непосредственный способ выполнения внешних объединений. 
В некоторых реализациях вводимый знак &quot; + &quot; после предиката может выводить 
строки, которые удовлетворяют условию, так же как и строки, которые ему не 
удовлетворяют. В условии предиката может содержаться поле, совпадающее для обеих 
таблиц, и NULL-значения будут вставлены там, где такого совпадения не будет 
найдено.</p>
<p>Например, предположим, вы хотите видеть ваших продавцов и 
соответствующих им заказчиков, не исключая тех продавцов, которым не назначено 
ни одного заказчика (хотя такого нет в наших типовых таблицах, но в 
действительности это возможно):</p>
<pre>        SELECT a.snum, sname, cname
           FROM Salespeople a, Customers b
           WHEREa.snum = b.snum(+);</pre>
<p>Это является эквивалентом следующего объединения (UNION):</p>
<pre>        SELECT a.snum, sname, cname
           FROM Salespeople a, Customers b
           WHERE a.snum = b.snum

           UNION

        SELECT snum, sname, '_ _ _ _ _ _ _ _ _ _'
           FROM Salespeople
           WHERE snum NOT IN
              (SELECT snum
                  FROM Customers);
</pre>
<p>Предполагается, что подчёркивания будут отображены NULL-значениями (см. 
команду FORMAT ранее в этом приложении, где описывалось отображение NULL-значениями).</p>
<hr width="50%">
<h3>ОТСЛЕЖИВАНИЕ ДЕЙСТВИЙ</h3>
<p>Ваша SQL-реализация достаточна хороша, если она доступна многим 
пользователям, чтобы обеспечивать им некий способ слежения за действиями, 
выполняемыми в базе данных.</p>
<p>Имеются две основные формы, чтобы реализовать это: Journaling (Протоколирование) и&nbsp; Auditing (Ревизия).</p>
<p>Эти формы отличаются по назначению.</p>
<p>Journaling применяется с целью защиты ваших данных при разрушении вашей 
системы. Сначала вы используете реализационно зависимую процедуру, чтобы архивировать текущее содержание вашей базы данных, 
поэтому копия её содержания где-нибудь будет сохранена. Затем вы просматриваете 
протокол изменений, сделанных в базе данных. Он сохраняется в некоторой области 
памяти, но не в главной памяти базы данных, а желательно на отдельном 
устройстве, и содержит список всех команд, которые произвели изменения в 
структуре или в содержании базы данных.<br>
Если у вас вдруг появились проблемы и 
текущее содержание вашей базы данных оказалось нарушенным, вы можете повторно 
выполнить все изменения, зарегистрированные в протоколе на резервной копии вашей 
базы данных, и снова привести вашу базу данных в состояние, которое было до 
момента последней записи в протокол. Типичной командой для начала 
протоколирования будет следующая:</p>
<pre>             SET JOURNAL ON;</pre>
<p>Auditing используется с целью защиты. Она следит за тем, кто и какие действия 
выполнял в базе данных, и сохраняет эту информацию в таблице, доступной только 
очень немногим привилегированным пользователям. Конечно, вы редко будете 
прибегать к процедуре ревизии, потому что очень скоро она займет много памяти и 
вам будет сложно работать в вашей БД. Но вы можете устанавливать ревизию для 
определённых пользователей, определённых действий или определённых объектов 
данных. Имеется такая форма команды AUDIT:</p>
<pre>        AUDIT INSERT ON Salespeople BY Diane;</pre>
<p>Или предложение ON, или предложение BY могут быть исключены, устанавливая 
ревизию либо всех объектов, либо всех пользователей, соответственно. Применение AUDIT ALL вместо AUDIT INSERT приведет к отслеживанию всех действий Diane в 
таблице Продавцов.</p></body></html>
<? include 'foot.php' ?>