<?
include_once '../../sys/inc/start.php';
include_once '../../sys/inc/compress.php';
include_once '../../sys/inc/sess.php';
include_once '../../sys/inc/home.php';
include_once '../../sys/inc/settings.php';
include_once '../../sys/inc/db_connect.php';
include_once '../../sys/inc/ipua.php';
include_once '../../sys/inc/fnc.php';
include_once '../../sys/inc/user.php';
$set['title']='Учебник XML';
include_once '../../sys/inc/thead.php';
title();
err();
//aut();
?>
<h3 align=center>Язык XML - практическое введение</h3>
<p align=justify>Зa неполный год своего официального существования язык XML привлек к себе уже достаточно много внимания со стороны разработчиков и пользователей Интернет. Сегодня количество приверженцев этой новой технологии возрастает также стремительно, как и число сообщений об очередных взятых ею преградах на пути к всеобщему признанию. Несмотря на то, что XML очень молод (международная организация W3C утвердила спецификацию "Extensible Markup Language(XML) 1.0" чуть меньше года назад - в начале февраля 1998 г) и отдельные компоненты этого языка находятся еще в стадии доработки, уже сегодня появляются новые языки, созданные на основе XML, возникают многочисленные Web-сервера, использующие эту технологию для организации хранящейся на них информации. Мир Интернет вокруг нас в очередной раз преображается, и мы можем стать участниками этого процесса уже сегодня
</p>
<p align=justify>Целью данной статьи является попытка на конкретных примерах показать некоторые из возможностей XML, ответить на ряд часто возникающих при знакомстве с новым языком вопросов. Что же такое XML? В чем заключаются его преимущества перед  привычным уже нам языком phpL? Можно ли использовать XML на своих Web-страничках уже сегодня? А если можно, то как?
</p>
<p align=justify>В конце статьи приведены ссылки на другие ресурсы Интернет, с помощью которых Вы сможете также получить более полную информацию по конкретным интересующим Вас вопросам, связанным с применением XML и незатронутых нами в этой статье. Полные спецификации XML и связанных с ним языков доступны на официальной странице W3C - <a href="http://www.w3.org">www.w3.org</a>
</p>
<a name="p1">
<h3>Для чего нужен новый язык разметки?</h3>
<p align=justify></i>Когда осенью 1991 года Интернет впервые услышал позывные новой технологии, название которой легко уместилось в три буквы, почти никто не мог представить себе, что завоевания ее окажутся настолько глобальными. Сегодня для многих неискушенных пользователей слово Интернет прочно ассоциируется с WWW и с уст специалистов не сходит  тема будущего информационных систем и влияния на это будущее всемирной сетевой паутины. 
</p>
<p align=justify>Популярность World Wide Web и неотъемлемой ее части, phpL, безусловно, стала причиной повышенного внимания к системам гипертекстовой разметки документов. Хотя понятие гипертекста было введено В.Бушем еще в 1945 году и, начиная с 60-х годов стали появляться первые приложения, использующие гипертекстовые данные, всплеск активности вокруг этой технологии начался лишь тогда, когда возникла реальная необходимость в механизме объединения множества информационных ресурсов, обеспечения возможности создания, просмотра нелинейного текста. И примером реализации этого механизма послужила паутина WWW.
</p>
<p align=justify>Язык разметки документов - это набор специальных инструкций, называемых тэгами, предназначенных для формирования в документах какой-либо структуры и определения отношений между различными элементами этой структуры. Тэги языка, или, как их иногда называют, управляющие дескрипторы, в таких документах каким-то образом кодируются, выделяются относительно основного содержимого документа и служат в качестве инструкций для программы, производящей показ содержимого документа на стороне клиента. В самых первых системах для обозначения этих команд использовались символы   “&lt;” и “&gt;”, внутри которых помещались названия инструкций и их параметры. Сейчас такой способ обозначения тэгов является стандартным.
</p>
<p align=justify>Использование гипертекстовой разбивки текстового документа в современных информационных системах  во многом связано  с тем, что гипертекст позволяет создавать механизм  нелинейного просмотра информации. В таких системах данные представляются не в виде непрерывного потока текстовой информации, а набором взаимосвязанных компонентов, переход по которым осуществляется при помощи гиперссылок. 
</p>
<p align=justify>Самый популярный на сегодняшний день язык гипертекстовой разметки – phpL, был создан специально для организации информации, распределенной в сети Интернет, и является одной из ключевых составляющих технологии WWW. С использованием гипертекстовой модели документа способ представления  разнообразных информационных ресурсов в сети стал более  упорядочен, а пользователи получили удобный механизм поиска и просмотра нужной информации.
</p>
<p align=justify>phpL [<a href="LINKS.php#8">8</a>]является упрощенной версией стандартного общего языка разметки - SGML (Standart Generalised Markup Language[<a href="LINKS.php#10">10</a>]), который был утвержден ISO в качестве стандарта еще в 80-х годах. Этот язык предназначен для создания других языков разметки, он определяет допустимый набор тэгов, их атрибуты и  внутреннюю структуру документа. Контроль за правильностью использования дескрипторов осуществляется при помощи специального набора правил, называемых DTD- описаниями(более подробно о DTD мы поговорим чуть позже), которые используются программой клиента при разборе документа. Для каждого класса документов определяется свой набор правил, описывающих грамматику соответствующего языка разметки. С помощью SGML можно описывать структурированные данные, организовывать информацию, содержащуюся в документах, представлять эту информацию в некотором стандартизованном формате. Но в виду некоторой своей сложности, SGML использовался, в основном, для описания синтаксиса других языков(наиболее известным из которых является phpL), и немногие приложения работали с SGML- документами напрямую.
</p>
<p align=justify>Гораздо более простой и удобный, чем SGML, язык phpL позволяет определять оформление элементов документа и имеет некий ограниченный набор инструкций - тэгов, при помощи которых осуществляется процесс разметки. Инструкции phpL, в первую очередь, предназначены для управления процессом вывода содержимого документа на экране программы-клиента и определяют этим самым способ представления документа, но не его структуру. В качестве элемента гипертекстовой базы данных, описываемой phpL,  используется текстовый файл, который может легко передаваться по сети с использованием протокола HTTP. Эта особенность, а также то, что phpL является открытым стандартом и огромное количество пользователей имеет возможность применять возможности этого языка для оформления своих документов, безусловно, повлияли на рост популярности phpL и сделали его сегодня главным механизмом представления информации в Web 
</p>
<p align=justify>Однако современные приложения нуждаются не только в языке представления данных на экране клиента, но и в механизме, позволяющем определять структуру документа, описывать содержащиеся в нем элементы. phpL обладает несложным набором команд и вполне успешно справляется с задачей описания текстовой информации и отображением ее на экране программы просмотра- броузера. Однако сами отображаемые данные никак не связаны с теми тэгами, которые используются для форматирования, поэтому у программ-анализаторов нет возможности использовать тэги phpL для поиска нужных нам фрагментов документа. Т.е. встретив, например, такое описание 
</p>
<pre>
&lt;font color="red"&gt;rose&lt;/font&gt;,
</pre>
<p align=justify>программа просмотра будет знать, каким цветом отобразить текст, содержащийся внутри тэгов &lt;font&gt;&lt;/font&gt; и, вероятно, отобразит его правильно, но ей абсолютно безразлично, в каком месте документа встретился этот тэг, в какие другие тэги заключен текущий фрагмент, существуют ли вложенные в него фрагменты, правильно ли построены отношения между объектами. Такое "безразличие" к структуре документа приводит к тому, что поиск или анализ информации внутри него ничем не будет отличаться от работы со сплошным, не разбитым на элементы текстовым файлом. А это, как известно, не самый эффективный способ работы с информацией. 
</p>
<p align=justify>Другим существенным недостатком phpL можно назвать ограниченность набора его тэгов. DTD- правила для phpL определяют фиксированный набор дескрипторов и поэтому у разработчика нет возможности вводить собственные, специальные тэги. Хотя время от времени появляются новые расширения языка(на сегодняшний день последней версией phpL является phpL 4.0), но долгий путь их стандартизации, сопровождаемый постоянными разногласиями между основными производителями броузеров делают практически невозможной быструю адаптацию языка, его использование для отображения специализированной информации(например, мультимедийной, математических, химических формул и т.д.). 
</p>
<p align=justify>Подводя итог всему сказанному, можно утверждать, что phpL уже сегодня не удовлетворяет в полной мере требованиям, предъявляемым современными разработчиками к языкам подобного рода. И ему на смену был предложен новый язык гипертекстовой разметки, мощный, гибкий, и, одновременно с этим, удобный язык XML. В чем же заключается его достоинства?
</p>
<p align=justify>XML (<i>Extensible Markup Language</i>[<a href="LINKS.php#1">1</a>]) </i>- это язык разметки, описывающий целый класс  объектов данных, называемых XML- документами. Этот язык используется в качестве средства для описания грамматики других  языков и контроля за правильностью составления документов. Т.е. сам по себе XML не содержит никаких тэгов, предназначенных для разметки, он просто определяет порядок их создания. Таким образом, если, например, мы считаем, что для обозначения элемента <i>rose </i>в документе необходимо использовать тэг <i>&lt;flower&gt</i>;, </i>то XML позволяет свободно использовать определяемый нами тэг и мы можем включать в документ фрагменты, подобные следующему:
</p>
<pre>
&lt;flower&gt;rose&lt;/flower&gt;
</pre>
<p align=justify></i>Набор тэгов может быть легко расширен. Если, предположим, мы хотим также указать, что описание цветка должно по смыслу идти внутри описания оранжереи, в которой он цветет, то просто задаем новые тэги и выбираем порядок их следования:
</p>
<pre>&lt;conservatory&gt;
&lt;flower&gt;rose&lt;/flower&gt;
&lt;/conservatory&gt;
</pre>
<p align=justify></i>Если мы хотим посадить туда еще несколько цветочков, то должны внести следующие изменения:
</p>
<pre>
&lt;conservatory&gt;
&lt;flower&gt;rose&lt;/flower&gt;
&lt;flower&gt;tulip&lt;/flower&gt;
&lt;flower&gt;cactus&lt;/flower&gt;
&lt;/conservatory&gt;
</pre>
<p align=justify></i>Как видно, сам процесс создания XML документа очень прост и требует от нас лишь базовых знаний phpL и понимания тех задач, которые мы хотим выполнить, используя XML в качестве языка разметки. Таким образом, у разработчиков появляется уникальная возможность определять собственные команды, позволяющие им наиболее эффективно определять данные, содержащиеся в документе. Автор документа создает его структуру, строит необходимые связи между элементами, используя те команды, которые удовлетворяют его требованиям и добивается такого типа разметки, которое необходимо ему для выполнения операций просмотра, поиска, анализа документа.
</p>
<p align=justify>Еще одним из очевидных достоинств XML является возможность использования его в качестве универсального языка запросов к хранилищам информации. Сегодня в глубинах W3C находится на рассмотрении рабочий вариант стандарта XML-QL(или XQL), который, возможно, в будущем составит серьезную конкуренцию SQL. Кроме того,  XML-документы могут выступать в качестве уникального способа хранения данных, который включает в себя одновременно средства для разбора информации и представления ее на стороне клиента. В этой области одним из перспективных направлений является интеграция Java и XML - технологий, позволяющая использовать мощь обеих технологий при построении машинно-независимых приложений, использующих, кроме того, универсальный формат данных при обмене информации.
</p>
<p align=justify>XML позволяет также осуществлять контроль за корректностью данных, хранящихся в документах, производить проверки иерархических соотношений внутри документа и устанавливать единый стандарт на структуру документов, содержимым которых могут быть самые различные данные. Это означает, что его можно использовать при построении сложных информационных систем, в которых очень важным является вопрос обмена информацией между различными приложениями, работающими в одной системе. Создавая структуру механизма обмена информации в самом начале работы над проектом, менеджер может избавить себя в будущем от многих проблем, связанных с несовместимостью используемых различными компонентами системы форматов данных.  
</p>
<p align=justify>Также одним из достоинств XML является то, что программы-обработчики XML- документов не сложны и уже сегодня появились и свободно распространяются всевозможные программные продукты, предназначенные для работы с XML-документами. XML поддерживается сегодня в Microsoft Internet Explorer 4/0 и в бэта-версиях IE5. Было заявлено о его поддержке в последующих версиях Netscape Communicator, СУБД Oracle, DB-2, в приложениях MS-Office .   Все это дает основания предполагать, что, скорее всего, в ближайшем будущем XML станет основным языком обмена информации для информационных систем, заменив собой, тем самым, phpL. На основе XML уже сегодня созданы такие известные специализированные языки разметки, как SMIL, CDF, MathML, XSL, и список рабочих проектов новых языков, находящихся на рассмотрении W3C, постоянно пополняется.
</p>
<a name="p2">
<h3>Как выглядит XML-документ?</h3>
<p align=justify>Если Вы знакомы с phpL, изучение XML не потребует от вас особых усилий. Хотя  XML, безусловно, сильно отличается по своим возможностям и  предназначению от языка гипертекстовой разметки, оба эти языка являются подмножествами SGML, и, следовательно, наследуют его базовые принципы. 
</p>
<a name="p3">
<p align=justify>Структура документа</p>
<p align=justify>Простейший XML- документ может выглядеть так, как это показано в Примере 1
</p>
<pre>
&lt;?xml version="1.0"?&gt;
&lt;list_of_items&gt;
&lt;item id="1"&gt;&lt;first/&gt;Первый&lt;/item&gt;
&lt;item id="2"&gt;Второй &lt;sub_item&gt;подпункт 1&lt;/sub_item&gt;&lt;/item&gt;
&lt;item id="3"&gt;Третий&lt;/item&gt;
&lt;item id="4"&gt;&lt;last/&gt;Последний&lt;/item&gt;
&lt;/list_of_items&gt;
</pre>
<p align=justify>Обратите внимание на то, что этот документ очень похож на обычную phpL-страницу. Также, как и в phpL, инструкции, заключенные в угловые скобки называются тэгами и служат для разметки основного текста документа. В XML существуют открывающие, закрывающие и пустые тэги (в phpL понятие пустого тэга тоже существует, но специального его обозначения не требуется). 
</p>
<p align=justify>Тело документа XML состоит из элементов разметки (markup) и непосредственно содержимого документа - данных (content). XML - тэги предназначены для определения элементов документа, их атрибутов и других конструкций языка. Более подробно о типах применяемой в документах разметки мы поговорим чуть позже. 
</p>
<p align=justify>Любой XML- документ должен всегда начинаться с инструкции &lt;?xml?&gt;, внутри которой также можно задавать номер версии языка, номер кодовой страницы и другие параметры, необходимые программе-анализатору в процессе разбора документа
</p>
<a name="p4">
<h3>Правила создания XML- документа</h3>
<p align=justify>В общем случае XML- документы должны удовлетворять следующим требованиям:
</p>
<UL>
<LI>В заголовке документа помещается объявление XML, в котором указывается язык разметки документа, номер его версии и дополнительная информация<LI>Каждый открывающий тэг, определяющий некоторую область данных в документе обязательно должен иметь своего закрывающего "напарника", т.е., в отличие от phpL, нельзя опускать закрывающие тэги<LI>В XML учитывается регистр символов <LI>Все значения атрибутов, используемых в определении тэгов, должны быть заключены в кавычки<LI>Вложенность тэгов в XML строго контролируется, поэтому необходимо следить за порядком следования открывающих и закрывающих тэгов<LI>Вся информация, располагающаяся между начальным и конечными тэгами, рассматривается в XML как данные и поэтому учитываются все символы форматирования ( т.е. пробелы, переводы строк, табуляции не игнорируются, как в phpL)</UL>
<p align=justify>Если XML- документ не нарушает приведенные правила, то он называется <i>формально-правильным </i>и все анализаторы, предназначенные для разбора XML- документов, смогут работать с ним корректно.
</p>
<p align=justify>Однако кроме проверки на формальное соответствие грамматике языка, в документе могут присутствовать средства контроля над содержанием документа, за соблюдением правил, определяющих необходимые соотношений между элементами и формирующих структуру документа. Например, следующий текст, являясь вполне правильным XML- документом, будет абсолютно бессмысленным:
</p>
<pre>
&lt;country&gt;&lt;title&gt;Russia&lt;/title&gt;&lt;city&gt;&lt;title&gt;Novosibirsk&lt;/country&gt;&lt;/title&gt;&lt;/city&gt;
</pre>
<p align=justify></b>Для того, чтобы обеспечить проверку корректности XML- документов, необходимо использовать анализаторы, производящие такую проверку и называемые верифицирующими.
</p>
<p align=justify>На сегодняшний день существует два способа  контроля правильности XML- документа: DTD - определения(Document Type Definition) и схемы данных(Semantic Schema). Более подробно об использовании DTD и схемах мы поговорим в следующих разделах. В отличии от SGML, определение DTD- правил в XML не является необходимостью, и это обстоятельство позволяет нам создавать любые XML- документы,  не ломая пока голову над весьма непростым синтаксисом DTD. 
</p>
<a name="5">
<h3>Конструкции языка</h3>
<p align=justify>Содержимое XML- документа представляет собой набор элементов, секций CDATA, директив анализатора, комментариев, спецсимволов, текстовых данных. Рассмотрим каждый из них подробней.
</p>
<h4>Элементы данных</h4>
<p align=justify>Элемент - это структурная единица XML- документа. Заключая слово rose в в тэги &lt;flower&gt; &lt;/flower&gt; , мы определяем непустой элемент, называемый &lt;flower&gt;, содержимым которого является <i>rose</i>. В общем случае в качестве содержимого элементов могут выступать как просто какой-то текст, так и другие, вложенные, элементы документа, секции CDATA, инструкции по обработке, комментарии, - т.е. практически любые части XML- документа. 
</p>
<p align=justify>Любой непустой элемент должен состоять из начального, конечного тэгов и данных, между ними заключенных. Например, следующие фрагменты будут являться элементами:
</p>
<pre>
&lt;flower&gt;rose&lt;/flower&gt;
&lt;city&gt;Novosibirsk&lt;/city&gt;
</pre>
,а эти - нет:
<pre>
&lt;rose&gt;
&lt;flower&gt;
rose
</pre>
<p align=justify></i>Набором всех элементов, содержащихся в документе, задается его структура и определяются все иерархическое соотношения. Плоская модель данных превращается с использованием элементов в сложную иерархическую систему со множеством возможных связей между элементами. Например, в следующем примере мы описываем месторасположение Новосибирских университетов (указываем, что Новосибирский Университет расположен в городе Новосибирске, который, в свою очередь, находится в России), используя для этого вложенность элементов XML :
</p>
<pre>
&lt;country id="Russia"&gt;
 &lt;cities-list&gt;
&lt;city&gt;
&lt;title&gt;Новосибирск&lt;/title&gt;
&lt;state&gt;Siberia&lt;/state&gt;
&lt;universities-list&gt;
&lt;university id="2"&gt;
&lt;title&gt;Новосибирский Государственный Технический Университет&lt;/title&gt;
&lt;noprivate/&gt;
&lt;address URL="www.nstu.ru"/&gt;
&lt;description&gt;очень хороший институт&lt;/description&gt; 
&lt;/university&gt;  
&lt;university id="2"&gt;
&lt;title&gt;Новосибирский Государственный Университет&lt;/title&gt;
&lt;noprivate/&gt;
&lt;address URL="www.nsu.ru"/&gt;
&lt;description&gt;тоже не плохой&lt;/description&gt; 
&lt;/university&gt;  
&lt;/universities-list&gt;
&lt;/city&gt;
&lt;/cities-list&gt;
&lt;/country&gt;
</pre>
<p align=justify>Производя в последствии поиск в этом документе, программа клиента будет опираться на информацию, заложенную в его структуру - используя элементы документа. Т.е. если, например, требуется найти нужный университет в нужном городе, используя приведенный фрагмент документа, то необходимо будет просмотреть содержимое конкретного элемента &lt;university&gt;, находящегося внутри конкретного элемента &lt;city&gt;. Поиск при этом, естественно, будет гораздо более эффективен, чем нахождение нужной последовательности по всему документу.
</p>
<p align=justify>В XML документе, как правило, определяется хотя бы один элемент, называемый корневым и с него программы-анализаторы начинают просмотр документа. В приведенном примере этим элементом является &lt;country&gt;
</p>
<p align=justify>В некоторых случаях тэги могут  изменять и уточнять семантику тех или иных фрагментов документа, по разному определяя одну и ту же информацию и тем самым предоставляя приложению-анализатору этого документа сведения о контексте использования описываемых данных. Например, прочитав фрагмент <b>&lt;city&gt;</b>Holliwood<b>&lt;/city&gt; </b>мы можем догадаться, что речь в этой части документа идет о городе, а вот во фрагменте  <b>&lt;restaurant&gt;</b>Holliwood<b>&lt;/restaurant&gt;  </b>- о забегаловке.
</p>
<p align=justify>В случае, если элемент не имеет содержимого, т.е. нет данных, которые он должен определять, он называется пустым. Примером пустых элементов в phpL могут служить такие тэги phpL, как <b>&lt;br&gt;, &lt;hr&gt;, &lt;img&gt</b>;.  </b>Необходимо только помнить, что начальный и конечные тэги пустого элемента как бы объединяется в один, и надо обязательно ставить косую черту перед закрывающей угловой скобкой (например,  <b>&lt;empty/&gt</b>;)</b>
</p>
<h4>Комментарии</h4>
<p align=justify>Комментариями является любая область данных, заключенная между последовательностями символов &lt;!-- и --&gt; Комментарии пропускаются анализатором и поэтому при разборе структуры документа в качестве значащей информации не рассматриваются.
</p>
<h4>Атрибуты</h4>
<p align=justify>Если при определении элементов необходимо задать какие-либо параметры, уточняющие его характеристики, то имеется возможность использовать атрибуты эдлемента. Атрибут - это пара "название" = "значение", которую надо задавать при определении элемента в начальном тэге. Пример:
</p>
<pre>
&lt;color <b>RGB</b>="true"&gt;#ff08ff&lt;/color&gt;
&lt;color <b>RGB</b>="false"&gt;white&lt;/color&gt;
</pre>
или
<pre>
&lt;author id=0&gt;Ivan Petrov&lt;/author&gt;
</pre>
<p align=justify></i>Примером использования атрибутов в phpL является описание элемента &lt;font&gt;:
</p>
<pre>
&lt;font color=”white” name=”Arial”&gt;Black&lt;/font&gt;
</pre>
<h4>Cпециальные символы</h4>
<p align=justify></i>Для того, чтобы включить в документ символ, используемый для определения каких-либо конструкций языка (например, символ угловой скобки) и не вызвать при этом ошибок в процессе разбора такого документа, нужно использовать его специальный символьный либо числовой идентификатор. Например, &amplt; , &ampgt; &ampquot; или &amp#036;(десятичная форма записи), &amp#x1a (шестнадцатеричная)  и т.д. Строковые обозначения спецсиволов могут определяться в XML документе при помощи компонентов (entity), о чем мы еще поговорим немного позже.
</p>
<h4>Директивы  анализатора</h4>
<p align=justify>Инструкции, предназначенные для анализаторов языка, описываются в  XML документе при помощи специальных тэгов - <i>&lt;? </i>и <i>?&gt</i>;. </i>Программа клиента использует эти инструкции для управления процессом разбора документа. Наиболее часто инструкции используются при определении типа документа (например, &lt;? Xml version=”1.0”?&gt;) или создании пространства имен[11]. 
</p>
<h4>CDATA </h4>
<p align=justify>Чтобы задать область документа, которую при разборе анализатор будет рассматривать как простой текст, игнорируя любые инструкции и специальные символы, но, в отличии от комментариев, иметь возможность использовать их  в приложении, необходимо использовать тэги &lt;![CDATA] и ]]&gt;. Внутри этого блока можно помещать любую информацию, которая может понадобится программе- клиенту для выполнения каких-либо действий (в область CDATA, можно помещать, например, инструкции JavaScript). Естественно, надо следить за тем, чтобы в области, ограниченной этими тэгами не было последовательности символов ]]. 
</p>
<h4>Что дальше</h4>
<p align=justify>Мы рассмотрели в общих чертах основные структурные части XML- документа, правила описания элементов XML и теперь можем создать синтаксически правильный XML- документ, содержащий каким-то образом структурированные данные( более подробный  пример приведен в <a href="APP1.php">Приложении 1</a>.) Однако при этом почти не коснулись вопросов практического  применения XML. Как отображать содержимое XML- документов на Web- страницах, осуществлять контроль над правильностью их составления; существуют ли уже сегодня какие-либо удобные средства для создания, анализа и просмотра таких документов? В следующих разделах мы попробуем  ответить на эти вопросы.
</p>
<p><center><p>
<font size=-1>
<a href="index.php">Содержание</a> | <a href="PART2.php">Вперед</a></font></center></p>
</body></html>
<?
include_once '../../sys/inc/tfoot.php';
?>