<?php

namespace App\Http\Controllers\Admin;

use App\Pages;
use App\Http\Requests;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class PagesController extends MainAdminController
{
    public function __construct()
    {
        parent::__construct();

        $this->middleware('DemoAdmin', ['only' => ['delete', 'addnew']]);
    }

    public function index()
    {
        $pages = Pages::all();

        return view('_admin.pages.pages', compact('pages'));
    }

    public function add()
    {
        return view('_admin.pages.pagesadd');
    }

    public function edit($id)
    {
        $page = Pages::findOrFail($id);

        return view('_admin.pages.pagesadd', compact('page'));
    }

    public function delete($id)
    {
        $pages = Pages::findOrFail($id);
        $pages->delete();

        Session::flash('success.message', trans("admin.Deleted"));
        return redirect('admin/pages');
    }


    public function addnew(Request $request)
    {

        $input = $request->all();
        $v = Validator::make($input, [
            'text' => 'required',
            'slug' => 'required|unique:pages,slug,' . $input['id'],
            'title' => 'required|unique:pages,title,' . $input['id'],
            'description' => 'required',
        ]);

        if ($v->fails()) {
            Session::flash('error.message', $v->errors()->first());
            return redirect()->back()->withInput($input);
        }

        if (!empty($input['id'])) {
            $pages = Pages::findOrFail($input['id']);

            $pages->title = $input['title'];
            $pages->slug = $input['slug'];
            $pages->description = $input['description'];
            $pages->text = $input['text'];
            $pages->footer = $input['footer'];
            $pages->save();

            \Session::flash('success.message', trans("admin.ChangesSaved"));

            return redirect('admin/pages')->withInput($input);
        }

        Pages::create($input);

        \Session::flash('success.message', trans("admin.SuccesfulyCreateted"));

        return redirect('admin/pages')->withInput($input);
    }
}
