<?php
    $aData = HTML::escape($aData, 'html', array('title', 'place', 'place_address', 'place_phone', 'name', 'phone', 'email'));
?>

<? if( ! User::id()) { ?>
<div class="h1-wrap">
    <h1><?= _t('afisha', 'Новое событие'); ?></h1>
    <p class="send-comment-att ml0 mt20"><?= _t('afisha', '[reg:start]Зарегистрируйтесь[reg:stop] или [login:start]войдите[login:stop], чтобы добавить информацию о новом событии.', array(
            'reg:start' => '<a href="'.Users::url('register').'" onclick="app.popup(\'reg\').show(event);">',
            'reg:stop'  => '</a>',
            'login:start' => '<a href="'.Users::url('login').'" onclick="app.popup(\'login\').show(event);">',
            'login:stop' => '</a>',
        )); ?> <i class="say"></i></p>
</div>
<?  return; } ?>

<div class="h1-wrap">
    <h1><?= _t('afisha', 'Новое событие'); ?></h1>
    <ul class="mt20 mb30">
        <li><?= _t('', 'Поля, отмеченные звездочкой[span], обязательны к заполнению.', array(
                'span' => '<span class="z-att">*</span>',
            )); ?> <i></i></li>
     </ul>
     <div class="form-box object-add">
        <form method="post" enctype="multipart/form-data" id="j-afisha-add-form">
        <input type="hidden" name="hash" value="<?= $hash ?>" />
        <div class="error mb20"<? if($this->errors->no()){ ?> style="display:none;"<? } ?>><?= join('<br />', $this->errors->get(true)); ?></div>              
        <table width="100%"> 
        <tr><td colspan="2"><h3><?= _t('', 'Общая информация'); ?></h3></td></tr>
        <tr>
            <td class="td1"><?= _t('afisha', 'Тип события'); ?><span class="z-att">*</span></td>
            <td>
                <div class="form-ch-sp2">
                    <? foreach ($types as $v){ ?>
                        <p><label><input type="radio" name="type" value="<?= $v['id'] ?>" <? if($v['id'] == $type){ ?>checked="checked"<? } ?> /> <?= $v['title'] ?></label></p>
                    <? } ?>
                </div>
            </td>
        </tr>                   
        <tr>
            <td class="td1"><?= _t('', 'Заголовок'); ?><span class="z-att">*</span></td>
            <td><div class="inp inp-w1"><input type="text" name="title" value="<?= $title ?>" maxlength="200" tabindex="1" /><i></i></div></td>
        </tr>                                 
        <tr>
            <td class="td1"><?= _t('', 'Описание'); ?><br /><span class="f11 grey"><?= _t('', 'Не более 500 символов.'); ?></span></td>
            <td>
                <div class="textarea"><textarea cols="25" rows="7" tabindex="2" name="content"><?= $content ?></textarea><i></i></div>
            </td>
        </tr>    
        <tr>
            <td class="td1"><?= _t('afisha', 'Постер'); ?></td>
            <td>
                <input type="file" name="img" size="25" tabindex="3" /> 
                <input type="hidden" name="MAX_FILE_SIZE" value="5242880" />
            </td>
        </tr>                 
        <tr>
            <td colspan="2"><br /><div class="separatornobr"></div></td>
        </tr>                            
        <tr><td colspan="2"><br /><h3><?= _t('afisha', 'Где проходит'); ?></h3></td></tr>
        <tr>
            <td class="td1"><?= _t('afisha', 'Место'); ?></td>
            <td><div class="inp inp-w1"><input type="text" name="place" value="<?= $place ?>" tabindex="4" tabindex="150" /><i></i></div></td>
        </tr>
        <tr>
            <td class="td1"><?= _t('', 'Город'); ?><span class="z-att">*</span></td>
            <td>
                <?= Geo::cityOptionsSelect($place_city, true, 'place_city', array('class'=>'inp-w2 req')); ?>
            </td>
        </tr>
        <tr>
            <td class="td1"><?= _t('', 'Адрес'); ?></td>
            <td><div class="inp inp-w1"><input type="text" name="place_address" value="<?= $place_address ?>" tabindex="5" maxlength="150" /><i></i></div></td>
        </tr>
        <tr>
            <td class="td1"><?= _t('', 'Телефон'); ?></td>
            <td><div class="inp inp-w3 left mr10"><input type="text" name="place_phone" value="<?= $place_phone ?>" tabindex="6" maxlength="40" /><i></i></div></td>
        </tr>                  
        <tr>
            <td colspan="2"><br /><div class="separatornobr"></div></td>
        </tr>
        <tr><td colspan="2"><br /><h3><?= _t('', 'О себе'); ?></h3></td></tr>
        <tr>
            <td class="td1"><?= _t('afisha', 'Кто вы?'); ?></td>
            <td>
                <label><input type="radio" name="user_type" tabindex="7" value="<?= Afisha::USERTYPE_ORGANIZER ?>" <? if( ! $user_type || $user_type == Afisha::USERTYPE_ORGANIZER){ ?>checked="checked"<? } ?> onclick="$('#afisha_add_contacts').show();" /> <?= _t('afisha', 'Организатор'); ?></label>&nbsp;&nbsp;&nbsp;
                <label><input type="radio" name="user_type" value="<?= Afisha::USERTYPE_MEMBER ?>" <? if($user_type == Afisha::USERTYPE_MEMBER){ ?>checked="checked"<? } ?> onclick="$('#afisha_add_contacts').hide();" /> <?= _t('afisha', 'Пользователь'); ?></label>
            </td>
        </tr>
        <tbody id="afisha_add_contacts" <? if($user_type == Afisha::USERTYPE_MEMBER){?> style="display: none;"<?} ?>>
            <tr>
                <td class="td1"><?= _t('', 'Ваше имя'); ?><span class="z-att">*</span></td>
                <td><div class="inp inp-w3"><input type="text" name="name" value="<?= $name ?>" maxlength="80" tabindex="8" /><i></i></div></td>
            </tr>                
            <tr>
                <td class="td1"><?= _t('', 'Контактный телефон'); ?><span class="z-att">*</span></td>
                <td><div class="inp inp-w3"><input type="tel" name="phone" value="<?= $phone ?>" maxlength="90" tabindex="9" /><i></i></div></td>
            </tr>                
            <tr>
                <td class="td1"><?= _t('', 'Email'); ?></td>
                <td><div class="inp inp-w3"><input type="text" name="email" value="<?= $email ?>" maxlength="80" tabindex="10" /><i></i></div></td>
            </tr>      
        </tbody>              
        <tr>
            <td></td>
            <td colspan="2">
                <div class="btn mr10 left"><input type="submit" value="<?= _t('afisha', 'добавить событие'); ?>" tabindex="11" /><i></i></div>
            </td>
        </tr>       
        </table>
        <div class="separator"></div>       
        </form>  
     </div>
</div>
<script type="text/javascript">
<? js::start(); ?>
    var jAfishaAdd = function(){
        var $f, f, $err;

        $(function(){
            $err = $('div.error:first');
            $f = $('#j-afisha-add-form');
            f = app.form($f, false, {noEnterSubmit: true});
            bff.iframeSubmit($f, function(resp, errors){
                if(resp && resp.success) {
                    if(resp.redirect){
                        bff.redirect( $('<div/>').html(resp.redirect).text() );
                    }
                } else {
                    app.showError($err, errors, false, true);
                }
            });
        });

        return{

        }
    }();
<? js::stop(); ?>
</script>