<?php
    /**
     * @var $this Afisha
     */
    $lng = array(
        Afisha::TYPE_MOVIE      => array(_t('afisha','Кино'), _t('afisha','Все фильмы')),
        Afisha::TYPE_THEATER    => array(_t('afisha','Спектакли'), _t('afisha','Все спектакли')),
        Afisha::TYPE_EXHIBITION => array(_t('afisha','Выставки'), _t('afisha','Все выставки')),
        Afisha::TYPE_CONCERT    => array(_t('afisha','Концерты'), _t('afisha','Все концерты')),
        Afisha::TYPE_ACTIVITY   => array(_t('afisha','Мероприятия'), _t('afisha','Все мероприятия')),
        Afisha::TYPE_SPORT      => array(_t('afisha','Спорт'), _t('afisha','Все мероприятия')),
        Afisha::TYPE_PARTY      => array(_t('afisha','Вечеринки'), _t('afisha','Все вечеринки')),
        Afisha::TYPE_CIRCUS     => array(_t('afisha','Представления'), _t('afisha','Все представления')),
   );
    
?>
<div class="afisha-index mt20" id="j-index-afisha-block">
    <div class="left">
        <h2 class="mb20 left"><a href="<?= $url_index ?>"><?= _t('afisha', 'Афиша'); ?></a></h2>
        <span class="arrs j-arrows" style="margin-right: 18px;"><a href="#"><i class="arrowLeft j-prev disabled">&nbsp;</i></a> <a href="#" class="j-next" title=""><i class="arrowRight">&nbsp;</i></a></span>
        <div class="clear"></div>
        <table class="iafisha" width="725">
            <tbody>
            <tr>
                <td width="155">
                    <ul class="iafisha-menu">
                        <? foreach($today as $typeID=>&$v) { ?>
                            <li<?= ($v['active'] ? ' class="active"':'') ?>><a href="<?= $v['url_list'] ?>" data-id="<?= $typeID ?>" class="j-type"><?= $lng[$typeID][0] ?></a></li>
                        <? } unset($v); ?>
                    </ul>
                    <a href="<?= $url_index ?>" class="f12 grey"><?= _t('afisha', 'Все события'); ?></a> <span class="grey">&rarr;</span>
                </td>
                <td class="relative">
                    <? foreach($today as $typeID=>&$v) { ?>
                        <div class="owl-carousel j-type-items j-type-items-<?= $typeID.( ! $v['active'] ? ' displaynone':'') ?>" data-id="<?= $typeID ?>" style="width: 584px;">
                            <? foreach($v['e'] as $e) { ?>
                                <div class="j-item"><a href="<?= $e['url'] ?>"><img src="<?= $e['img'] ?>" alt="<?= $e['title_alt'] ?>" width="125" height="170" /><span><?= tpl::truncate($e['title'], 35) ?></span></a></div>
                            <? } ?>
                            <? if($v['cnt'] > 4 || $v['cnt'] == 3){ ?><div class="j-item iafisha-other"><a href="<?= $v['url_list'] ?>"><?= $lng[$typeID][1] ?></a></div><? } ?>
                        </div>
                    <? } unset($v); ?>
                    <div class="clear"></div>
                    <div class="iafisha-corner">&nbsp;</div>
                </td>
            </tr>
            </tbody>
        </table>
        <script type="text/javascript">
            <? js::start(); ?>
            $(function(){
                var itemsVisible = 4;
                var $block = $('#j-index-afisha-block'), $types = $block.find('.j-type');
                var $items = $block.find('.j-type-items'), $item;
                var $arrows = $block.find('.j-arrows');
                var $prev = $arrows.find('.j-prev'), $next = $arrows.find('.j-next');

                $types.click(function(e){ nothing(e);
                    var id = $(this).data('id');
                    $types.parent().removeClass('active');
                    $(this).parent().addClass('active');
                    $items.hide();
                    itemShow(id);
                });
                $arrows.on('click', '.j-prev, .j-next', function(e){ nothing(e);
                    var $arr = $(this); if($arr.is('.disabled')) return;
                    $item.trigger('owl.'+($arr.is('.j-next') ? 'next' : 'prev'));
                });
                function itemShow(id)
                {
                    $item = $items.filter('.j-type-items-'+id);
                    if (!$item.hasClass('j-inited')) {
                        $item.addClass('j-inited').owlCarousel({
                            items: itemsVisible, scrollPerPage: true, pagination: false, responsive: false, slideSpeed: 500,
                            afterInit: function(){ updateArrows(this); },
                            afterMove: function(){ updateArrows(this); }
                        });
                    } else {
                        updateArrows($item.data('owlCarousel'));
                    }
                    $item.show();
                }
                function updateArrows(owl)
                {
                    if (owl.itemsAmount <= itemsVisible) {
                        $prev.add($next).addClass('disabled'); $arrows.hide(); return;
                    }
                    $prev.add($next).removeClass('disabled');
                    if (owl.currentItem == 0) {
                        $prev.addClass('disabled');
                    } else if(owl.currentItem == owl.maximumItem) {
                        $next.addClass('disabled');
                    }
                    $arrows.show();
                }
                itemShow($items.first().data('id'));
            });
            <? js::stop(); ?>
        </script>
    </div>

    <div class="right ml10" style="margin-left: 20px">
        <h2 class="mb20"><a href="<?= $catalog['main_url'] ?>"><?= _t('items', 'Каталог заведений'); ?></a></h2>
        <div class="w275">
            <ul class="listpad">
                <? foreach($catalog['cats'] as $v) { ?>
                    <li><a href="<?= $v['url'] ?>"><?= $v['t']; ?></a></li>
                <? } ?>
            </ul>
            <div class="clear mb10"></div>
            <a href="<?= $catalog['main_url'] ?>" class="f12 grey"><?= _t('items', 'Все заведения'); ?></a> <span class="grey">&rarr;</span>
        </div>
    </div>
    <div class="clear"></div>
</div>