<?php

use bff\img\Thumbnail;
use bff\db\ImagesField;
use bff\utils\Files;

class AutoImages extends ImagesField
{
    protected $path = '';
    private $url  = '';
    private $saveOriginal = false;

    const szSmall     = 's';
    const szThumbnail = 't';
    const szView      = '';
    const szList      = 'l';
    const szOriginal  = 'o';

    function __construct()
    {
        $this->setParams(TABLE_AUTO_ITEMS, 'id', 'img', 'imgfav', 'imgcnt');
        $this->init();
        $this->path = bff::path('auto', 'images');
        $this->url  = bff::url('auto', 'images');
        $this->saveOriginal = true;
    }

    /** 
     * Сохранение файла изображения
     * @param integer $nID ID объявления
     * @param array $aUploadData данные о загрузке
     */
    function saveImageFileCustom($nID, $aUploadData)
    {
        $sFilename = func::generator(12).'.'.$aUploadData['ext'];
        
        $oThumb = new Thumbnail($aUploadData['tmp_name'], false);

        # настройки водяного знака
        $watermark = Site::i()->watermarkSettings();
        $watermarkSettings = array();
        if (!empty($watermark['file']['path'])) {
            $watermarkSettings = array(
                'watermark'       => true,
                'watermark_src'   => $watermark['file']['path'],
                'watermark_pos_x' => $watermark['pos_x'],
                'watermark_pos_y' => $watermark['pos_y'],
            );
        }

        $aSave = array();
        $aSave[] = array( 'filename'=>$this->path.$nID.self::szSmall.$sFilename,
                          'width'=>72,
                          'height'=>49 );

        $aSave[] = array( 'filename'=>$this->path.$nID.self::szList.$sFilename,
                          'width'=>100,
                          'height'=>70 );

        $aSave[] = array( 'filename'=>$this->path.$nID.self::szThumbnail.$sFilename,
                          'width'=>218,
                          'height'=>137 );

        $aSave[] = array( 'filename'=>$this->path.$nID.self::szView.$sFilename,
                          'width' => 860,
                          'height'=> 548,
                          'autofit_nocrop' => true ) + $watermarkSettings;

        if ( $this->saveOriginal ) {
            copy($aUploadData['tmp_name'], $this->path.$nID.self::szOriginal.$sFilename);
        }

        if ( ! $oThumb->save($aSave)) {
            return false;
        }
          
        if ( ! empty($sFilename) && $nID>0)
        {
            $aData = $this->db->one_array('SELECT '.$this->fImages.', '.$this->fCount.' FROM '.$this->table.' WHERE '.$this->fID.' = '.$nID);
            if ( ! empty($aData)) {
                $aData[$this->fImages] .= ( ! empty($aData[$this->fImages]) ? ',' : '').$sFilename;
                $this->db->exec('UPDATE '.$this->table.' SET '.$this->fCount.' = '.$this->fCount.' + 1, '.$this->fImages.' = '.$this->db->str2sql($aData[$this->fImages]).'
                                    WHERE '.$this->fID.' = '.$nID);
            }
        }
          
        return $sFilename;
    }
    
    /** 
    * Переименовывание файла изображения
    * @param integer $nID ID объявления
    * @param string $aFilename имя файла
    */
    function renameImageFileCustom($nID, $aFilename)
    {
        if ( ! is_array($aFilename)) $aFilename = array($aFilename);
        if (empty($aFilename)) return 0;
        
        $nRenamed = 0;
        foreach ($aFilename as $file)
        {
            if (file_exists($this->path.'0'.$file))  {
                @rename($this->path.'0'.self::szSmall.$file, $this->path.$nID.self::szSmall.$file);
                @rename($this->path.'0'.self::szThumbnail.$file, $this->path.$nID.self::szThumbnail.$file);
                @rename($this->path.'0'.$file, $this->path.$nID.self::szView.$file);
                @rename($this->path.'0'.self::szList.$file, $this->path.$nID.self::szList.$file);
                if ( $this->saveOriginal ) {
                    @rename($this->path.'0'.self::szOriginal.$file, $this->path.$nID.self::szOriginal.$file);
                }
                $nRenamed++;
            }
        }
    } 
       
    /** 
     * Удаление файла изображения
     * @param integer $nID ID объявления
     * @param string $sFilename имя файла
     */
    function deleteImageFileCustom($nID, $sFilename)
    {
        $res = true;
        if ($nID > 0) {
            $res = $this->deleteImage($nID, $sFilename);
        }
        $sizes = array(
            self::szSmall,
            self::szThumbnail,
            self::szView,
            self::szList,
        );
        
        if ($res) {
            if (file_exists($this->path.$nID.$sFilename)) {
                foreach ($sizes as $sz) {
                    if (file_exists($this->path.$nID.$sz.$sFilename)) {
                            @unlink($this->path.$nID.$sz.$sFilename);
                    }
                }
                if ($this->saveOriginal) {
                    @unlink($this->path.$nID.self::szOriginal.$sFilename);
                }
            }
        }
    }
    
    function deleteImagesFiles($nID, $aFilenames)
    {
        $sizes = array(
            self::szSmall,
            self::szThumbnail,
            self::szView,
            self::szList,
        );

        foreach ($aFilenames as $file)
        {
            if (file_exists($this->path.$nID.$file))  {
                foreach ($sizes as $sz) {
                    if (file_exists($this->path.$nID.$sz.$file)) {
                        @unlink($this->path.$nID.$sz.$file);
                    }
                }
                if ($this->saveOriginal) {
                    @unlink($this->path.$nID.self::szOriginal.$file);
                }
            }
        }
    }

    function processImagesView($sSize)
    {
        $nItemID = $this->input->post('item_id', TYPE_UINT);
        if ( ! $nItemID){ $this->errors->impossible(); return; }
        
        $aData = $this->db->one_array("SELECT $this->fImages, $this->fCount, created FROM $this->table WHERE $this->fID=$nItemID");

        $aImages = array();
        $img = explode(',', $aData[$this->fImages]);
        $total = $aData[$this->fCount];
        $created = _t('', '[year] г.', array('year'=>tpl::date_format2($aData['created'])));
                
        if ($total>0 && !empty($img))
        {
            $i = 1;
            foreach ($img as $filename)
            {
                $aImages[] = array(
                    'id' => $i, 'i'=>$i-1,
                    'comment' => '',
                    'created' => $created,
                    'src'     => static::url($nItemID, $filename, $sSize),
                );
                $i++;
            }
        }
        
        return array(
            'offset' => 0,
            'total'  => $total,
            'photos' => $aImages,
        );

    }
    
    function getUrl($nID = false, $sFilename = '', $sSize = 's')
    {
        if ($nID === false)
            return $this->url;
        
        return $this->url . ( ! empty($sFilename) ? $nID.$sSize.$sFilename : 'default_'.$sSize.'.gif');
    }

    public static function url($id = 0, $filename = '', $size = 's')
    {
        return bff::url('auto', 'images') .
            ( ! empty($filename) ? $id.$size.$filename : 'default_'.$size.'.gif');
    }

    public function prepareView($itemID, $imagesCount, $imagesData = '')
    {
        $images = array();
        $imagesData = explode(',', strval($imagesData));
        if ($imagesCount > 0 && ! empty($imagesData)) {
            foreach ($imagesData as $fileName) {
                $image = array();
                foreach (array('small'=>self::szSmall, 'th'=>self::szThumbnail, 'view'=>self::szView, 'list'=>self::szList, 'o'=>self::szOriginal) as $k=>$sz) {
                    $image[$k] = $this->getUrl($itemID, $fileName, $sz);
                }
                $images[] = $image;
            }
        }
        return $images;
    }

    public function uploadFromFile($sFieName, $itemID)
    {
        if( ! file_exists($sFieName)) return false;
        $sExtension = Files::getExtension($sFieName);
        $aImageSize = getimagesize($sFieName);
        if ($aImageSize === false
            || !in_array($sExtension, array('gif', 'png', 'jpg'))
            || !in_array($aImageSize[2], array(IMAGETYPE_GIF, IMAGETYPE_JPEG, IMAGETYPE_PNG))
        ) {
            return false;
        }

        $aResult = $this->saveImageFileCustom($itemID, array(
            'ext'      => $sExtension,
            'tmp_name' => $sFieName,
            'width'    => $aImageSize[0],
            'height'   => $aImageSize[1],
        ));

        return $aResult;
    }

}