<?php
/**
 * @var $this Auto
 */
 tpl::includeJS('tablednd', true);
?>
<?= tplAdmin::blockStart('Авто / Категории / Добавить категорию', false, array('id'=>'autoCatFormBlock', 'style'=>'display:none;')); ?>
    <form action="" method="post" name="autoCatFormNew"><?= $form ?></form>
<?= tplAdmin::blockStop(); ?>

<?= tplAdmin::blockStart('Авто / Категории', true, array(), array(
    'title' => '+ добавить категорию', 'class'=>'ajax', 'onclick'=>'return autoCategories.toggle(\'add\');',
), array(
    array('title'=>'валидация treeNestedSets', 'onclick'=>"return bff.confirm('sure', {r:'".$this->adminLink(bff::$event.'&act=dev-ns-valid')."'})", 'icon'=>'icon-check'),
)); ?>
<table class="table table-condensed table-hover admtbl tblhover" id="auto-cats-table">
<thead>
    <tr class="header nodrag nodrop">
        <? if(FORDEV) { ?><th width="50">ID</th><? } ?>
        <th class="left">Название</th>
        <th width="100">Объявлений</th>
        <th width="105">Действие</th>
    </tr>
</thead>
<? foreach($cats as $k=>$v) { $id = $v['id']; ?>
<tr class="row<?= $k%2 ?>" id="dnd-<?= $id ?>" data-pid="<?= $v['pid'] ?>" data-numlevel="<?= $v['lvl'] ?>">
    <? if(FORDEV) { ?><td><?= $id ?></td><? } ?>
    <td class="left"<? if($v['lvl']==2) { ?> style="padding-left: 30px;"<? } ?>><?= $v['title'] ?></td>
    <td><a href="<?= $this->adminLink('listing&cat='.$id) ?>"><?= $v['items'] ?></a></td>
    <td>
        <a class="but <? if($v['enabled']){ ?>un<? } ?>block cat-toggle" href="#" rel="<?= $id ?>"></a>
        <a class="but sett" title="Дин. свойства" href="<?= $dynprops_link.'&owner='.$id ?>"></a>
        <a class="but edit cat-edit" href="#" rel="<?= $id ?>"></a>
        <? if($v['node']==1 && !$v['items']) {?><a class="but del cat-del" href="#" rel="<?= $id ?>"></a><? } else { ?><a href="#" class="but del disabled" onclick="return false;"></a><? } ?>
    </td>
</tr>
<? } if (empty($cats)) { ?>
<tr class="norecords">
    <td colspan="<?= (FORDEV ? 4 : 3) ?>">нет категорий (<a href="#" class="ajax" onclick="return autoCategories.toggle('add');">добавить категорию</a>)</td>
</tr>
<? } ?>
</table>
<div>
    <div class="left"></div>
    <div class="right desc" style="width:60px; text-align:right;">
        <div class="progress" id="progress-auto-cats" style="display:none;"></div>
        &darr; &uarr;
    </div>
    <br />
</div>
<?= tplAdmin::blockStop(); ?>

<script type="text/javascript">
var autoCategories = (function(){
    var $progress, $block, $blockCaption, form, formClean, $list, fChecker;
    var ajax_url = '<?= $this->adminLink('categories&act=') ?>';
    
    $(function(){
        form = document.forms.autoCatFormNew;
        
        fChecker = new bff.formChecker(form);
        formClean = $(form).html();
        
        $progress = $('#progress-auto-cats');
        $block = $('#autoCatFormBlock');
        $blockCaption = $block.find('span.caption'); 
        $list = $('#auto-cats-table');
        
        $list.on('click', 'a.cat-edit', function(){
            var id = intval($(this).attr('rel'));
            if(id>0) edit( id );
            return false;
        });
        $list.on('click', 'a.cat-toggle', function(){
            var id = intval($(this).attr('rel'));
            if(id>0) {
                bff.ajaxToggle(id, ajax_url+'toggle', {progress: $progress, link: this});
            }
            return false;
        });        
        $list.on('click', 'a.cat-del', function(){
            var id = intval($(this).attr('rel'));
            if(id>0) del( id, this );
            return false;
        });
        
        bff.rotateTable('#auto-cats-table', ajax_url+'rotate', $progress);

        $(form).on('click', '.j-tab-toggler', function(e){ nothing(e);
            var key = $(this).data('key');
            $(form).find('.j-tab').addClass('hidden');
            $(form).find('.j-tab-'+key).removeClass('hidden');
            $(this).parent().addClass('tab-active').siblings().removeClass('tab-active');
        });
    });

    function toggle(type, editData)
    {                                           
        switch(type) {
            case 'add': {
                if($block.is(':hidden')) {
                    $block.show();
                    $(form).html(formClean);
                    $blockCaption.html('Авто / Категории / Добавить категорию');
                    $.scrollTo( $blockCaption, { duration:500, offset:-300 } );
                } else {
                    $block.hide();   
                }
            } break; 
            case 'cancel': {
                $block.hide();
            } break;
            case 'edit': {                           
                $blockCaption.html(editData.caption);
                $(form).html(editData.form);
                $block.show();
                $.scrollTo( $blockCaption, { duration:500, offset:-300 } );
                form.elements['act'].value = 'edit-finish';
            } break;
        }
        fChecker.check(true, true);
        return false;
    }
    
    function del(id, link)
    {
        bff.ajaxDelete('Удалить категорию?', id, 
            ajax_url+'delete&cat_id='+id, 
            link, {progress: $progress, repaint: false});
        return false;
    }
    
    function edit(id)
    {                          
        bff.ajax(ajax_url+'edit&cat_id='+id,{},function(data){
            if(data) {
                toggle('edit', $.extend({caption: 'Авто / Категории / Редактирование категории'}, data) );
            }                  
        }, $progress);
        return false;
    }
    
    return {toggle: toggle};
}());
</script>