<?php
/**
 * Кабинет пользователя: список объявлений
 * @var $items array
 */
?>

<div class="realty">
    <div class="realty-list">
        <table width="100%">
        <? foreach($items as $v){
            $isBlocked = ($v['status'] == Auto::STATUS_BLOCKED);
            ?>
        <tr class="item<? if($v['marked']) { ?> svc-item-marked<? } elseif($v['fixed']) { ?> fixed<? } ?>">
            <td class="image<?= ($isBlocked ? ' disabled': '') ?>">
                <a href="<?= $v['url'] ?>"><img alt="" src="<?= $v['img'] ?>"></a>
            </td>
            <td>
                <a href="<?= $v['url'] ?>"><b><?= $v['title'] ?></b></a>
                <div class="f12 mt5"><? if($isBlocked){ ?><?= _t('', 'ОТКЛОНЕНО:'); ?><br/><?= nl2br($v['blocked_reason']); } else { echo $v['descshort'];} ?></div>
            </td>
            <td class="price<?= ($isBlocked ? ' disabled': '') ?>">
                <div class="green"><b><?= tpl::formatPrice($v['price'], $v['price_curr']) ?></b></div>
                <? foreach($this->getPriceParams() as $ppKey=>$ppTitle) {
                    if($v['pricep'] & $ppKey){ ?><span class="grey f12"><?= $ppTitle ?></span><? }
                } ?>
            </td>
            <td class="manage">
                <? if($v['status'] == Auto::STATUS_PUBLICATED_OUT ){ ?><a href="#" onclick="AutoUserItems.publicate2(<?= $v['id'] ?>, $(this), event); return false;"><i class="iconlink fa fa-refresh f14 green"></i><?= _t('', 'Продлить'); ?></a><br /><? } ?>
                <? if(bff::servicesEnabled() && $v['status'] == Realty::STATUS_PUBLICATED){ ?><a href="#" onclick="jAutoItemsPromote.promote(<?= $v['id'] ?>, $(this).closest('tr').find('td:first').html(), event); return false;" class="green"><i class="iconlink fa fa-arrow-up f14 green"></i><?= _t('', 'Продвинуть'); ?></a><br /><? } ?>
                <? if($isBlocked && !$v['moderated']){ ?><i class="iconlink fa fa-lock f14 grey"></i><span class="grey"><?= _t('', 'Ожидает проверки'); ?></span><? } else { ?><a href="<?= Auto::url('edit', array('id'=>$v['id'])) ?>"><i class="iconlink fa fa-edit f14 grey"></i><?= _t('', 'Редактировать'); ?></a><? } ?><br />
                <a href="#" onclick="AutoUserItems.del(<?= $v['id'] ?>, $(this)); return false;" class="red"><i class="iconlink fa fa-times f14 red"></i><?= _t('', 'Удалить'); ?></a>
                <? if($v['status'] == Realty::STATUS_PUBLICATED){ ?><br /><span class="grey"><?= _t('', 'до'); ?> <?= tpl::date_format2($v['publicated_to'], true); ?></span><? } ?>
            </td>
        </tr>
        <? } ?>
    </table>
    </div>
</div>

<?= $pgn; ?>

<script type="text/javascript">
<? js::start(); ?>
var AutoUserItems = (function(){

    // auto publicate2
    $(function(){
        app.popup('auto-publicate2', '#popup-auto-publicate2', false, { onInit: function($popup) 
        {                    
            var processing = false;                    
            var $err = $('div.error', $popup), $progress = $('.progress', $popup), $btn = $('input.submit', $popup);
            $('form:first', $popup).submit(function(){
                if(processing) return false;
                processing = true;
                var $form = $(this);
                $btn.prop('disabled', true).val('<?= _t('', 'подождите...'); ?>');
                bff.ajax('<?= bff::urlAjax('auto','item-publicate2') ?>', $form.serialize(), function(data, errors){
                    if(data) {
                        app.showError($err, '<?= _t('', 'Объявление успешно опубликовано'); ?>', true);
                        $form.prev().removeClass('displaynone'); // success message
                        setTimeout(function(){ location.reload(); }, 1500);
                    } else {
                        app.showError($err, errors);
                        $btn.prop('disabled', false).val('<?= _t('', 'продлить'); ?>');
                    }
                    processing = false;
                }, $progress);
                return false;
            });
        } } );
    });
    
    return {
        del: function(id, $link)
        {
            if(!confirm('<?= _t('', 'Вы действительно хотите удалить объявление?'); ?>')) return;
            bff.ajax('<?= bff::urlAjax('auto','item-del') ?>', {'id':id, hash:'<?= $this->security->getToken() ?>'}, function(data){
                if(data) {
                    $link.parent().parent().slideUp(function(){
                        $(this).remove();
                    });
                }
            });
        },
        publicate2: function(id, $link, e)
        {
            var p = app.popup('auto-publicate2');
            var $popup = p.getPopup();
            $popup.find('[name="id"]').val(id);
            $popup.find('#auto-publicate2-itempreview').html( $link.closest('tr').find('td:first').html() );
            p.show(e);
        }
    };
}());
<?  $periods = $this->getPublicatePeriods();  ?>                        
var autoPublicatePeriods = <?= func::php2js( $periods['dates'] );  ?>;
<? js::stop(); ?>
</script>

<div class="popup displaynone" id="popup-auto-publicate2" style="width: 600px; margin-left: -270px;">  
    <div class="popup-title"><?= _t('', 'Продлить публикацию'); ?></div>
    <div class="error" style="display: none;"></div>
    <div class="close"><span>x</span> <a href="#" class="close"><?= _t('', 'закрыть'); ?></a></div>

    <div id="auto-publicate2-itempreview" class="estate-other" style="margin: 10px 0 0 25px;"></div>

    <div class="content-popup">
        <form method="get">
        <input type="hidden" name="id" value="0" />
        <input type="hidden" name="hash" value="<?= $this->security->getToken(); ?>" />
        <table class="t-popup" style="margin-left: 35px;">
            <tr>
                <td><?= _t('', 'Период публикации'); ?> <span class="z-att">*</span>:</td>
                <td><select name="period" style="margin-right: 12px; width: 185px;" tabindex="1" onchange="$('#auto-publicate2-till').html( autoPublicatePeriods[this.value] );"><?= $periods['options']; ?></select><div class="progress" style="display: none;"></div></td>
            </tr>                    
            <tr>
                <td><?= _t('', 'Срок публикации:'); ?> </td>
                <td><?= _t('', 'с'); ?> <?= date('d.m.Y'); ?> <?= _t('', 'по'); ?> <span><b id="auto-publicate2-till"><?= $periods['dates'][1]; ?></b></span></td>
            </tr>            
            <tr>
                <td></td>
                <td>
                    <div class="btn mr10 left"><input type="submit" value="<?= _t('', 'продлить'); ?>" tabindex="2" /><i></i></div>
                    <div class="left"><a href="#" class="close"><?= _t('', 'отмена'); ?></a></div>
                </td>
            </tr>
        </table>
        </form>
    </div>
</div>

<?
    $aDataPromote = array();
    echo $this->viewPHP($aDataPromote, 'promote.popup');
?>