<?php
/**
 * @var $this Business
 */
 tpl::includeJS('tablednd', true);
?>
<?= tplAdmin::blockStart('Бизнес / Банки / Добавить банк', false, array('id'=>'banksFormBlock', 'style'=>'display:none;')); ?>
    <form action="" method="post" name="banksFormNew">
        <?= $form ?>
    </form>
<?= tplAdmin::blockStop(); ?>

<?= tplAdmin::blockStart('Бизнес / Банки', true, array(), array(
    'title'=>'+ добавить банк', 'class'=>'ajax', 'onclick'=>'return jBanks.toggle(\'add\');'
)) ?>
<table class="table table-condensed table-hover admtbl tblhover" id="banks-table">
<thead>
    <tr class="header nodrag nodrop">
        <th width="50">ID</th>
        <th class="left">Название</th>
        <th width="140">Отделений</th>
        <th width="140">Банкоматов</th>
        <th width="125">Действие</th>
    </tr>
</thead>
<? foreach($banks as $k => $v){ $id = $v['id']; ?>
<tr class="row<?= $k%2 ?>" id="dnd-<?= $id ?>">
    <td><?= $id ?></td>
    <td class="left"><?= $v['title'] ?></td>
    <td><?= $v['deps_cnt'] ?></td>
    <td><?= $v['mats_cnt'] ?></td>
    <td>
        <a class="but <? if($v['enabled']){?>un<? } ?>block banks-toggle" title="Вкл/Выкл" href="#" rel="<?= $id ?>"></a>
        <a class="but edit banks-edit" title="Редактировать" href="#" rel="<?= $id ?>"></a>
        <? if(FORDEV) { ?><a class="but del banks-del" title="Удалить" href="#" rel="<?= $id ?>"></a><? } ?>
    </td>
</tr>
<? } if (empty($banks)) { ?>
<tr class="norecords">
    <td colspan="5"><a href="#" class="ajax" onclick="return jBanks.toggle('add');">добавить банк</a></td>
</tr>
<? } ?>
</table>
<div>
    <div class="left">    
        
    </div>
    <div class="right desc" style="width:60px; text-align:right;">
        <div class="progress" id="progress-banks" style="display:none;"></div>
        &darr; &uarr;
    </div>
    <br />
</div>
<?= tplAdmin::blockStop(); ?>

<script type="text/javascript">
bff.extend(bff.formChecker, {
afterCheck: function()
{
    bff.formSelects.SelectAll('banks_deps_sel'); 
    bff.formSelects.SelectAll('banks_mats_sel');
}
});

var jBanks = (function(){
    var $progress, $block, $blockCaption, form, formClean, $list, fChecker;
    var ajax_url = '<?= $this->adminLink('banks&act='); ?>';
    
    $(function(){
        form = document.forms.banksFormNew;
        
        fChecker = new bff.formChecker(form);
        formClean = $(form).html();
        
        $progress = $('#progress-banks');
        $block = $('#banksFormBlock');
        $blockCaption = $block.find('span.caption'); 
        $list = $('#banks-table');
        
        $list.on('click', 'a.banks-edit', function(){
            var id = intval($(this).attr('rel'));
            if(id>0) edit( id );
            return false;
        });

        $list.on('click', 'a.banks-del', function(){
            var id = intval($(this).attr('rel'));
            if(id>0) del( id, this );
            return false;
        });
        
        $list.on('click', 'a.banks-toggle', function(){
            var id = intval($(this).attr('rel'));
            if(id>0) {
                bff.ajaxToggle(id, ajax_url+'toggle', {progress: $progress, link: this});
            }
            return false;
        });
        
        bff.rotateTable($list, ajax_url+'rotate', $progress);
    });

    function toggle(type, editData)
    {                                           
        switch(type) {
            case 'add': {
                if($block.is(':hidden')) {
                    $block.show();
                    $(form).html(formClean);
                    $blockCaption.html('Бизнес / Банки / Добавить банк');
                    $.scrollTo( $blockCaption, { duration:500, offset:-300 } );
                } else {
                    $block.hide();   
                }
            } break; 
            case 'cancel': {
                $block.hide();
            } break;
            case 'edit': {                           
                $blockCaption.html(editData.caption);
                $(form).html(editData.form);
                $block.show();
                $.scrollTo( $blockCaption, { duration:500, offset:-300 } );
                form.elements['act'].value = 'edit-finish';
            } break;
        }
        fChecker.check(true, true);
        return false;
    }

    function del(id, link)
    {
        bff.ajaxDelete('Удалить банк?', id, 
            ajax_url+'delete&id='+id, 
            link, {progress: $progress, repaint: false});
        return false;
    }
    
    function edit(id)
    {                          
        bff.ajax(ajax_url+'edit&id='+id,{},function(data){
            if(data) {
                toggle('edit', $.extend({caption: 'Бизнес / Банки / Редактирование банка'}, data) );
            }                  
        }, $progress);
        return false;
    }
    
    return {
        toggle: toggle,
        setMainDep: function(sel)
        {
            var $id = $('#bank_dep_main_id');
            var $title = $('#bank_dep_main_title');
            if(intval(sel.val())>0) {
                $id.val ( sel.val() );
                sel = sel.get(0);
                $title.html ( sel.options[sel.selectedIndex].text );
            } else {
                $id.val(0);
                $title.html ('Не указано');
            }  
        }
    };
}());
</script>