<?php

class ItemsModel extends Model
{
    var $langItems = array(
        'title'        => TYPE_NOTAGS,
        'descshort'    => TYPE_STR, // краткое описание
        'descfull'     => TYPE_STR, // подробное описание
        'mtitle'       => TYPE_NOHTML,
        'mkeywords'    => TYPE_NOTAGS,
        'mdescription' => TYPE_NOTAGS,
        'share_title'    => TYPE_NOTAGS, // meta-site-title
        'share_description' => TYPE_NOTAGS, // meta-share-description
        'share_sitename'    => TYPE_NOTAGS, // meta-share-sitename
    );

    var $langCategories = array(
        'title'        => TYPE_NOTAGS,
        'titleh1'      => TYPE_NOTAGS,
        'mtitle'       => TYPE_NOTAGS,
        'mkeywords'    => TYPE_NOTAGS,
        'mdescription' => TYPE_NOTAGS,
        'seotext'      => TYPE_STR,
    );

    var $langItemsAddr = array(
        'description'  => TYPE_STR,
    );

    var $langItemsImages = array(
        'title' =>  TYPE_NOTAGS,
    );

    public function isCategoryKeywordUnique($sKeyword = '', $nParentID = 0, $nExceptID)
    {
        if ( ! $sKeyword) return false;
        $aBind = array(
            ':keyword' => $sKeyword,
            ':pid'     => $nParentID,
        );
        if ($nExceptID > 0) {
            $aBind[':id'] = $nExceptID;
        }
        $nCnt = $this->db->one_data('SELECT COUNT(*)
            FROM '.TABLE_ITEMS_CATEGORIES.'
            WHERE keyword_edit = :keyword AND pid = :pid'.
            ($nExceptID > 0 ? ' AND id != :id' : ''), $aBind);
        return ! $nCnt;
    }

    /**
     * Получение данных объекта
     * @param integer $nItemID ID категории
     * @param array $aFields необходимые поля
     * @param boolean $bAddress получать настройки адреса
     * @return array
     */
    public function itemData($nItemID, array $aFields = array(), $bAddress = false)
    {
        if (empty($nItemID)) {
            return array();
        }

        if (empty($aFields)) {
            $aParams = array('I.*','L.*');
        } else {
            $aParams = array();
            foreach ($aFields as $v) {
                if (empty($v)) continue;
                $aParams[] = ( isset($this->langItems[$v]) ? 'L' : 'I' ).'.'.$v;
            }
        }
        if (empty($aParams) && ! $bAddress) {
            return array();
        }
        if ($bAddress) {
            foreach (array('lat','lng','city_id','address','description_'.LNG.' as addr_description','phones','emails','site','sites') as $v) {
                $aParams[] = 'A.'.$v;
            }
        }

        $aData = $this->db->one_array('SELECT '.join(',', $aParams).'
                FROM '.TABLE_ITEMS.' I,
                     '.TABLE_ITEMS_LANG.' L
                     '.($bAddress ? ', '.TABLE_ITEMS_ADDR.' A' : '').'
                WHERE I.id = :id '.$this->db->langAnd(true, 'I', 'L').
                       ($bAddress ? ' AND I.id = A.item_id' : ''),
            array(':id' => $nItemID));
        return ( ! empty($aData) ? $aData : array() );
    }

    /**
     * Получение данных о компании для страниц просмотра данных связанных с компанией
     * @param integer $companyID ID компании
     * @return array
     */
    public function companyData($companyID)
    {
        static $cache;
        if (isset($cache[$companyID])) {
            return $cache[$companyID];
        }
        $data = $this->itemData($companyID, array('id','title','link','agent_id'), true);
        if (empty($data)) {
            $cache[$companyID] = array();
        } else {
            $data['url'] = Items::url('view', array('link'=>$data['link']));
            $cityData = Geo::regionData($data['city_id']);
            $data['country_id'] = ( ! empty($cityData['country']) ? $cityData['country'] : 0);
            $cache[$companyID] = $data;
        }
        return $cache[$companyID];
    }

    /**
     * Перестраивание ссылок во всех записях
     */
    public function itemsLinksRebuild()
    {
        $model = $this;
        $this->db->select_rows_chunked(TABLE_ITEMS, array('id','keyword','city_id'),
                                       array(),'id',array(), function ($items) use ($model) {
            foreach ($items as $v) {
                $model->db->update(TABLE_ITEMS, array(
                    'link' => Items::urlView($v['id'], $v['keyword'], $v['city_id']),
                    'link_short' => Items::urlView($v['id'], $v['keyword'], $v['city_id'], false)
                ), array('id'=>$v['id']));
            }
        }, 100);
    }

    public function claimsListing(array $aFilter = array(), $bCount = false, $sqlLimit = '')
    {
        $aFilter[':item'] = 'CL.item_id = I.id';
        $aFilter = $this->prepareFilter($aFilter, 'CL');
        if ($bCount) {
            return $this->db->one_data('SELECT COUNT(CL.id)
                FROM '.TABLE_ITEMS_CLAIMS.' CL, '.TABLE_ITEMS.' I
                '.$aFilter['where'], $aFilter['bind']);
        }

        return $this->db->select('SELECT CL.*, 0 as other, I.link
                    FROM '.TABLE_ITEMS_CLAIMS.' CL, '.TABLE_ITEMS.' I
                    '.$aFilter['where']
                    .' ORDER BY CL.created DESC'
                    .' '.$sqlLimit, $aFilter['bind']);
    }

    /**
     * Получение данных категории
     * @param integer $nCategoryID ID категории
     * @param array $aFields необходимые поля
     * @param boolean $bEdit при редактировании
     * @return array
     */
    function categoryData($nCategoryID, $aFields = array('С.*', 'CL.*'), $bEdit = false)
    {
        $aData = $this->db->one_array('SELECT '.join(',', $aFields).'
                FROM '.TABLE_ITEMS_CATEGORIES.' C
                   , '.TABLE_ITEMS_CATEGORIES_LANG.' CL
                WHERE C.id = :id '.$this->db->langAnd(true, 'C', 'CL'),
            array(':id'=>$nCategoryID));
        return $aData;
    }

    public function categoriesLinks($nParentID, $aExcludeID = array())
    {
        $aData = $this->db->select('SELECT C.id, C.keyword, CL.title
                FROM '.TABLE_ITEMS_CATEGORIES.' C
                   , '.TABLE_ITEMS_CATEGORIES_LANG.' CL
                WHERE C.pid = :pid AND '.$this->db->prepareIN('C.id', $aExcludeID, true).'
                    '.$this->db->langAnd(true, 'C', 'CL').'
                ORDER BY C.num',
            array(':pid'=>$nParentID));
        if (empty($aData)) $aData = array();
        return $aData;
    }

    public function getLocaleTables()
    {
        return array(
            TABLE_ITEMS         => array('type' => 'table',  'fields' => $this->langItems),
            TABLE_ITEMS_CATEGORIES   => array('type' => 'table',  'fields' => $this->langCategories),
            TABLE_ITEMS_ADDR    => array('type' => 'fields', 'fields' => $this->langItemsAddr),
            TABLE_ITEMS_IMAGES  => array('type' => 'fields', 'fields' => $this->langItemsImages),
        );
    }

}