<?php

class M_Items
{
    public static function declareAdminMenu(CMenu $menu, Security $security)
    {
        $sMenuTitle = 'Справочная';

        # Объекты
        if ($security->haveAccessToModuleToMethod('items','items-listing')) {
            $menu->assign($sMenuTitle, 'Объекты', 'items', 'items_listing', true, 1,
                array( 'rlink' => array('event'=>'items_add'), 'counter'=>'items_mod'));
            $menu->assign($sMenuTitle, 'Добавить объект', 'items', 'items_add', false, 3);
            $menu->assign($sMenuTitle, 'Ред. объекта', 'items', 'items_edit', false, 4);
            $menu->assign($sMenuTitle, 'Фото объекта', 'items', 'items_images', false, 5);
        }

        # Представители
        if ($security->haveAccessToModuleToMethod('items','agents')) {
            $menu->assign($sMenuTitle, 'Представители', 'items', 'agents', true, 10, array( 'counter' => 'items_agents' ));
            $menu->assign($sMenuTitle, 'Заявки', 'items', 'agents_requests', false, 11);
        }
        
        # Отзывы
        if ($security->haveAccessToModuleToMethod('items','opinions')) {
            $menu->assign($sMenuTitle, 'Отзывы', 'items', 'opinions_mod', true, 15, array( 'counter' => 'items_opinions' ));
            $menu->assign($sMenuTitle, 'Отзывы об объекте', 'items', 'opinions', false, 16);
        }
        
        # Жалобы
        if ($security->haveAccessToModuleToMethod('items','claims')) {
            $menu->assign($sMenuTitle, 'Жалобы', 'items', 'claims', true, 20, array( 'counter' => 'items_claims' ));
        }
        
        if ($security->haveAccessToModuleToMethod('items','settings')) {
            # Категории
            $menu->assign($sMenuTitle, 'Категории', 'items', 'categories_listing', true, 25,
                        array( 'rlink' => array('event'=>'categories_add') )
                );
            $menu->assign($sMenuTitle, 'Добавить категорию', 'items', 'categories_add', false, 30);
            $menu->assign($sMenuTitle, 'Ред. категории', 'items', 'categories_edit', false, 31);
            $menu->assign($sMenuTitle, 'Удаление категории', 'items', 'categories_delete', false, 32);
            
            # Дин. свойства
            $menu->assign($sMenuTitle, 'Дин. св-ва категории', 'items', 'dynprops_listing', false, 33);
            $menu->assign($sMenuTitle, 'Дин. св-ва категории', 'items', 'dynprops_action', false, 34);
        }

        # Услуги
        if ($security->haveAccessToModuleToMethod('items','services')) {
            $menu->assign($sMenuTitle, 'Услуги', 'items', 'svc_services', true, 40);
        }

        # SEO
        if ($security->haveAccessToModuleToMethod('items', 'seo')) {
            $menu->assign('SEO', $sMenuTitle, 'items', 'seo_templates_edit', true, 3);
        }
    }

}