<?php
/**
 * @var $this Items
 */
tpl::includeJS(array('tablednd'), true);
tpl::includeJS('autocomplete', true);
?>
<script type="text/javascript">
    var orders = <?= Func::php2js($order) ?>;
    var orderby = '<?= $order_by ?>';
    var orderdir_src = '/img/admin/order-';
    var ifilter = null;

    function jItemsFilter(options){ this.initialize( options ); }
    jItemsFilter.prototype = {
        list_updating: false, progress: null, catID: 0,
        initialize: function(){
            this.eItemsTable = $('#items-tbl');
            this.eItemsTableBody = $('#items-tbl-body', this.eItemsTable);
            this.eTabs = $('#items-mod-tabs');
            this.form = document.forms.filters;
            this.eProgressItems = $('#progress-items');
            <? if($bRotate) { ?>bff.rotateTable(this.eItemsTable, '<?= $this->adminLink(bff::$event.'&act='); ?>rotate', this.eProgressItems, false, {category: <?= $filter['category'] ?>, city:<?= $filter['city'] ?>});<? } ?>

        },
        onCategory: function(sel) {
            this.catID = sel.val();
            this.updateList(false, true);
        },
        doPage: function(page)
        {
            if(this.list_updating) return;

            this.form['page'].value = page;
            this.updateList(false);
        },
        cancelUser: function(lnk)
        {
            if(this.list_updating) return;

            this.form['uid'].value = 0;
            this.updateList(false);
            $(lnk).hide();
        },
        cancelAgent: function(lnk)
        {
            if(this.list_updating) return;

            this.form['agent'].value = 0;
            this.updateList(false);
            $(lnk).hide();
            $('#items-listing-agent-title').val('');
        },
        doOrder: function(by, update)
        {
            if(this.list_updating || !orders[by])
                return;

            orders[by] = (orders[by] == 'asc' ? 'desc' : 'asc');
            //hide prev order direction
            $('#order_'+orderby).hide();
            //show current order direction
            orderby = by;
            $('#order_'+orderby).attr('src', orderdir_src + orders[by] + '.gif').show();

            this.form['order'].value = orderby+'-'+orders[by];

            if(update!==false)
                this.updateList(false);
        },
        updateList: function(resetpage, reload)
        {
            if(this.list_updating)
                return;

            if(resetpage!==false) {
                this.form['page'].value = 1;
            }

            this.doUpdateList(reload);
        },

        doUpdateList: function(reload)
        {
            var self = this;
            if(reload){
                $(self.form).submit();
                return;
            }

            self.list_updating = true;

            self.eItemsTable.animate({opacity: 0.5}, 300);
            bff.ajax('<?= $this->adminLink('items_listing&act=list') ?>', $(self.form).serializeArray(), function(data){
                self.list_updating = false;
                if(data!=0){
                    self.eItemsTableBody.html(data.list);
                    self.eItemsTable.show();
                    $('#pagenation').replaceWith(data.pages);
                }
                self.eItemsTable.animate({opacity: 1}, 100);
            }, self.eProgressItems);
        },
        editItem: function(itemID){
            var hash = document.location.hash.replace(/\?.*$/, '').replace(/^#/, '');
            document.location = '<?= $this->adminLink('items_edit&item_id=') ?>'+itemID+(hash?'#'+hash:'');
        },
        toggleItem: function(itemID, link){
            bff.ajaxToggle(itemID, '<?= $this->adminLink('ajax&action=item-toggle') ?>', {link: link});
        },
        deleteItem: function(itemID, link){
            bff.ajaxDelete('sure', itemID, '<?= $this->adminLink('ajax&action=item-delete') ?>', link);
        },
        onMod: function(state, link)
        {
            if(this.list_updating) return false;
            this.form['mod'].value = state;
            this.updateList(false, true);
            bff.onTab(link);
            return false;
        }
    };

    $(function(){
        var urlAjax = '<?= $this->adminLink('ajax').'&action='; ?>';
        ifilter = new jItemsFilter();
        $('#items-listing-agent-title').autocomplete( urlAjax+'item-users-autocomplete',
            {valueInput: '#items-listing-agent-id', minChars: 2, width:250,
                onSelect: function(val, text){
                    ifilter.updateList();
                    if(val){
                        $('#agent-filter-link').show();
                    }else{
                        $('#agent-filter-link').hide();
                    }
                }});

    });
</script>

<?
    $fordevActions = array(
        array('title'=>'обновление ссылок всех записей', 'onclick'=>"return bff.confirm('sure', {r:'".$this->adminLink(bff::$event.'&act=items-links-rebuild')."'})", 'icon'=>'icon-check'),
        array('title'=>'резайз изображений всех записей', 'onclick'=>"return bff.confirm('sure', {r:'".$this->adminLink(bff::$event.'&act=items-images-recrop')."'})", 'icon'=>'icon-resize-full'),
    );
    if (BFF_LOCALHOST) {
        $fordevActions[] = array('title'=>'удаление всех записей', 'onclick'=>"return bff.confirm('sure', {r:'".$this->adminLink(bff::$event.'&act=items-delete-all')."'})", 'icon'=>'icon-remove');
    }
?>
<?= tplAdmin::blockStart('Справочная / Список объектов', true, array(), array(
        'title' => '+ добавить', 'href'=> $this->adminLink('items_add')
    ), $fordevActions); ?>
    <div class="tabsBar" id="items-mod-tabs">
        <div class="left">
            <span class="tab<?= ! $filter['mod'] ? ' tab-active': ''?> mod0"><a href="#" onclick="return ifilter.onMod(0, this);">Опубликованные</a></span>
            <span class="tab<?= $filter['mod'] ? ' tab-active': ''?> mod1"><a href="#" onclick="return ifilter.onMod(1, this);">На модерацию</a></span>
        </div>
        <div class="progress right" style="display:none;" id="progress-items"></div>
    </div>

    <div class="actionBar">

        <form action="<?= $this->adminLink(NULL) ?>" method="get" name="filters">
            <input type="hidden" name="s" value="<?= bff::$class ?>" />
            <input type="hidden" name="ev" value="<?= bff::$event ?>" />
            <input type="hidden" name="order" value="<?= $order_by ?>-<?= $order_dir ?>" />
            <input type="hidden" name="page" value="1" />
            <input type="hidden" name="uid" value="<?= $filter['uid'] ?>" />
            <input type="hidden" name="mod" value="<?= $filter['mod'] ?>" />

            <? if($this->regionsFilterEnabled() && !  Geo::cityIsOne()): ?>
                <select name="city" onchange="ifilter.updateList(false, true);" class="left" style="margin-right: 5px; width: 150px;"><?= Geo::cityOptions($filter['city'], 'Все города') ?></select>
            <? endif; ?>
            <select name="category" onchange="ifilter.onCategory($(this));" class="left" style="width:200px; margin-right:5px;">
                <?= $categories_options ?>
            </select>
            <div class="left" style="margin-right:5px;">
                <input style="width:175px;" type="text" maxlength="150" name="title" placeholder="ID / Название объекта"  value="<?= $filter['title'] ?>" />
            </div>
            <div class="left relative" style="margin-right: 8px;">
                <input type="hidden" name="agent" id="items-listing-agent-id" value="<?= $filter['agent'] ?>" />
                <input type="text" class="autocomplete" id="items-listing-agent-title" style="width: 200px;" placeholder="<?= _t('pub', 'ID / login / email представителя') ?>" value="<?= ($filter['agent']>0 ? $agent_title : '') ?>" />
            </div>

            <input type="button" value="найти" class="button btn btn-small submit left" onclick="ifilter.updateList();" />
            <div class="clear"></div>

        </form>
    </div>

    <table class="admtbl tblhover table table-condensed table-hover" id="items-tbl">
        <thead>
        <tr class="header nodrag nodrop">
            <th width="70">
                <? if($bRotate):?>ID<? else: ?>
                <a href="javascript: ifilter.doOrder('id');">
                    ID<img style="<?= $order_by!='id' ? 'display:none;' : '' ?>" id="order_id" src="/img/admin/order-<?= $order_dir ?>.gif" alt="" /></a>
                <? endif; ?>
            </th>
            <th style="text-align:left;">
                <? if($bRotate):?>Название<? else: ?>
                <a href="javascript: ifilter.doOrder('title');">
                    Название<img style="<?= $order_by!='title' ? 'display:none;' : '' ?>" id="order_title" src="/img/admin/order-<?= $order_dir ?>.gif" alt="" /></a>
                <a href="#" style="margin-right:15px; <?= ! $filter['uid'] ? 'display:none;' : '' ?>" id="user-filter-link" onclick="ifilter.cancelUser(this); return false;" class="bold clr-error right">отменить фильтр пользователя</a>
                <a href="#" style="margin-right:15px; <?= ! $filter['agent'] ? 'display:none;' : '' ?>" id="agent-filter-link" onclick="ifilter.cancelAgent(this); return false;" class="bold clr-error right">отменить фильтр представителя</a>
                <? endif; ?>
            </th>
            <th width="137">
                <? if($bRotate):?>Изменен<? else: ?>
                <a href="javascript: ifilter.doOrder('modified');">
                    Изменен <img style="<?= $order_by!='modified' ? 'display:none;' : '' ?>" id="order_modified" src="/img/admin/order-<?= $order_dir ?>.gif" alt="" /></a>
                <? endif; ?>
            </th>
            <th width="130">Действие</th>
        </tr>
        </thead>
        <tbody id="items-tbl-body">
        <?= $list ?>
        </tbody>
    </table>
    <div style="margin-top:7px;" id="pagenation"><?= $pages ?></div>
    <div class="separator5"></div>

    <? if($bRotate): ?>
    <div>
        <div class="right desc" style="width:60px; text-align:right;">
            &darr;&uarr;
        </div>
    </div>
    <? endif; ?>
