<?php

class JobModel extends Model
{
    var $langCategories = array(
        'title'        => TYPE_NOTAGS,  // название
        # meta для резюме
        'resume_titleh1'      => TYPE_NOTAGS,  // meta-title-h1
        'resume_mtitle'       => TYPE_NOTAGS,  // meta-title
        'resume_mkeywords'    => TYPE_NOTAGS,  // meta-keywords
        'resume_mdescription' => TYPE_NOTAGS,  // meta-description
        # meta для вакансий
        'vacancy_titleh1'      => TYPE_NOTAGS,  // meta-title-h1
        'vacancy_mtitle'       => TYPE_NOTAGS,  // meta-title
        'vacancy_mkeywords'    => TYPE_NOTAGS,  // meta-keywords
        'vacancy_mdescription' => TYPE_NOTAGS,  // meta-description
    );

    function getLocaleTables()
    {
        return array(
            TABLE_JOB_CATEGORIES => array('type'=>'table','fields'=>$this->langCategories),
        );
    }

    function categoryByKeyword($sKeyword, $aFields = array('*'))
    {
        return $this->db->one_array('SELECT '.join(',', $aFields).' FROM '.TABLE_JOB_CATEGORIES.' WHERE keyword = :keyword LIMIT 1', array(':keyword' => $sKeyword));
    }

    function categoryData($nCategoryID, $nTypeID)
    {
        if ($nTypeID == Job::TYPE_VACANCY) {
            return $this->db->one_array('SELECT I.*, L.title,
                    L.vacancy_titleh1 as titleh1,
                    L.vacancy_mtitle as mtitle,
                    L.vacancy_mkeywords as mkeywords,
                    L.vacancy_mdescription as mdescription,
                    I.vacancy_mtemplate as mtemplate
                FROM '.TABLE_JOB_CATEGORIES.' I,
                     '.TABLE_JOB_CATEGORIES_LANG.' L
                WHERE I.id = :id'.$this->db->langAnd(true, 'I', 'L'), array(':id' => $nCategoryID));
        } else {
            return $this->db->one_array('SELECT I.*, L.title,
                    L.resume_titleh1 as titleh1,
                    L.resume_mtitle as mtitle,
                    L.resume_mkeywords as mkeywords,
                    L.resume_mdescription as mdescription,
                    I.resume_mtemplate as mtemplate
                FROM '.TABLE_JOB_CATEGORIES.' I,
                     '.TABLE_JOB_CATEGORIES_LANG.' L
                WHERE I.id = :id'.$this->db->langAnd(true, 'I', 'L'), array(':id' => $nCategoryID));
        }
    }

    /**
     * Получение данных объявления
     * @param integer $nTypeID тип объявления
     * @param integer $nItemID ID резюме
     * @param array|string $aFields требуемые поля объявления
     * @param array|string $aUserFields требуемые данные о пользователе (авторе объявления)
     * @return array
     */
    function itemData($nTypeID, $nItemID, $aFields = '*', $aUserFields = array())
    {
        if( empty($nItemID) ) return array();

        $sTable = TABLE_JOB_RESUME;
        if($nTypeID == Job::TYPE_VACANCY){
            $sTable = TABLE_JOB_VACANCY;
        }

        $aParams = array();
        // item params
        if (empty($aFields)) $aFields = '*';
        if(!is_array($aFields)) $aFields = array($aFields);
        foreach($aFields as $v) {
            $aParams[] = 'I.'.$v;
        }
        // user params
        $bJoinUsers = false;
        if( ! empty($aUserFields) ) {
            if( is_string($aUserFields) ) $aUserFields = array($aUserFields);
            foreach($aUserFields as $v) {
                $aParams[] = 'U.'.$v;
            }
            $bJoinUsers = true;
        }

        return $this->db->one_array('SELECT '.join(',', $aParams).'
                                  FROM '.$sTable.' I
                                       '.($bJoinUsers ? ', '.TABLE_USERS.' U' : '').'
                                  WHERE I.id = :id '.($bJoinUsers ? 'AND I.user_id = U.user_id' : ''),
            array(':id'=>$nItemID));
    }

    /**
     * Сохранение объявления
     * @param integer $nTypeID тип объявления
     * @param integer $nItemID ID объявления
     * @param array $aData данные объявления
     * @param mixed $sDynpropsDataKey ключ данных дин. свойств, например 'd' или FALSE
     * @return boolean|integer
     */
    function itemSave($nTypeID, $nItemID, array $aData)
    {
        if (empty($aData)) return false;
        $sTable = TABLE_JOB_RESUME;
        if($nTypeID == Job::TYPE_VACANCY){
            $sTable = TABLE_JOB_VACANCY;
        }

        $aData['modified'] = $this->db->now();

        if( isset($aData['title']) ) {
            $aData['title_alt'] = HTML::escape(strip_tags($aData['title']));
            $aData['keyword'] = mb_strtolower(func::translit($aData['title_alt']));
        }
        if($nItemID > 0)
        {
            return $this->db->update($sTable, $aData, array('id'=>$nItemID));
        } else {
            $aData['created'] = $this->db->now();
            return $this->db->insert($sTable, $aData);
        }
    }

    /**
     * Подсчет кол-ва записей на модерации
     * @param integer $nTypeID тип объявления
     * @return mixed
     */
    public function itemsModerationCounter($nTypeID)
    {
        return $this->db->select_rows_count(
            ($nTypeID == Job::TYPE_VACANCY ? TABLE_JOB_VACANCY : TABLE_JOB_RESUME),
            array('moderated'=>0)
        );
    }

    /**
     * Перестраивание ссылок во всех записях
     */
    public function itemsLinksRebuild()
    {
        $model = $this;
        $this->db->select_rows_chunked(TABLE_JOB_VACANCY, array('id','keyword','city_id'),
                                       array(),'id',array(), function ($items) use ($model) {
            foreach ($items as $v) {
                $model->db->update(TABLE_JOB_VACANCY, array(
                    'link' => Job::urlViewVacancy($v['id'], $v['keyword'], $v['city_id'])
                ), array('id'=>$v['id']));
            }
        }, 100);
        $this->db->select_rows_chunked(TABLE_JOB_RESUME, array('id','keyword','city_id'),
                                       array(),'id',array(), function ($items) use ($model) {
            foreach ($items as $v) {
                $model->db->update(TABLE_JOB_RESUME, array(
                    'link' => Job::urlViewResume($v['id'], $v['keyword'], $v['city_id'])
                ), array('id'=>$v['id']));
            }
        }, 100);
    }

    /**
     * Список вакнсий кампании (фронтенд)
     * @param integer $nCompanyID ID кампании
     * @param bool $bCount только подсчет кол-ва объявлений
     * @param string $sqlLimit
     * @return array
     */
    function companyVacancy($nCompanyID, $bCount = false, $sqlLimit = '')
    {
        $sqlFilter = array(
            'I.status = :status',
            'I.company_id = :company',
        );

        if(Job::premoderation()){
            $aFilter[':moderated'] = 'I.moderated > 0';
        }

        $aBind = array(
            ':status'  => Job::STATUS_PUBLICATED,
            ':company' => $nCompanyID,
        );

        if($bCount) {
            return $this->db->one_data('SELECT COUNT(I.id) FROM '.TABLE_JOB_VACANCY.' I WHERE '.join(' AND ', $sqlFilter), $aBind );
        }

        $nUserID = User::id();
        return $this->db->select('
            SELECT I.id, I.title, I.link, I.created, I.status, I.moderated, I.publicated_to,
                   I.price, (I.price * CURR.rate) as price_cross, I.price_curr, I.price_torg,
                   I.svc, (I.svc & '.Job::SERVICE_VACANCY_FIX.') as fixed, (I.svc & '.Job::SERVICE_VACANCY_MARK.') as marked,
                   CL.title as cat_title, R.title_'.LNG.' as city_title
                   '.($nUserID ? ', (F.item_id)' : ',0').' as fav
            FROM '.TABLE_JOB_VACANCY.' I
                '.($nUserID ? ' LEFT JOIN '.TABLE_JOB_FAV.' F ON I.id = F.item_id AND F.user_id = '.$nUserID.' AND F.type_id = '.Job::TYPE_VACANCY : '').',
                 '.TABLE_CURRENCIES.' CURR,
                 '.TABLE_JOB_CATEGORIES.' C,
                 '.TABLE_JOB_CATEGORIES_LANG.' CL,
                 '.TABLE_REGIONS.' R
            WHERE I.price_curr = CURR.id
              AND I.cat_id = C.id
              AND I.city_id = R.id
              AND '.join(' AND ', $sqlFilter).
              $this->db->langAnd(true, 'C', 'CL').'
            ORDER BY I.created DESC '.$sqlLimit, $aBind);
    }




}