<?php
/**
 * @var $this Job
 */
?>
<? switch ($f['type']) {
    case Job::TYPE_RESUME:  { ?><h3 class="mt20"><?= _t('job', 'Поиск резюме'); ?></h3><? } break;
    case Job::TYPE_VACANCY: { ?><h3 class="mt20"><?= _t('job', 'Поиск вакансий'); ?></h3><? } break;
    default:                { ?><h3 class="mt20"><?= _t('', 'Поиск'); ?></h3><? } break;
} ?>
<div class="param">
    <form id="job-search" method="get" action="<?= Job::url('index') ?>" class="relative">
        <? if($f['type'] == 0){ ?>
        <div class="b-param">
            <p class="param-name"><?= _t('', 'Предложения'); ?></p>
            <ul>
                <li><label class="radio"><input type="radio" name="type" value="<?= Job::TYPE_VACANCY ?>" data-k="vacancy" <? if($f['type'] == Job::TYPE_VACANCY){ ?>checked="checked"<? } ?> class="radio" /> <?= _t('job', 'Вакансии'); ?></label></li>
                <li><label class="radio"><input type="radio" name="type" value="<?= Job::TYPE_RESUME ?>" data-k="resume" <? if($f['type'] == Job::TYPE_RESUME){ ?>checked="checked"<? } ?> class="radio" /> <?= _t('', 'Резюме'); ?></label></li>
            </ul>
        </div>
        <? } ?>
        <div class="b-param">
            <p class="param-name"><?= _t('', 'Ключевые слова'); ?></p>
            <div class="num-area-inp"><div class="inp"><input type="text" name="q" value="<?= HTML::escape($f['q']) ?>" placeholder="<?= _t('job', 'название компании или должность'); ?>" /><i></i></div></div>
        </div>
        <? if( ! Geo::cityIsOne() ) { ?>
        <div class="b-param">
            <p class="param-name"><?= _t('', 'Город'); ?></p>
            <select name="rc"><?= Geo::cityOptions($f['rc'], array(-1, _t('', 'Все города'))) ?></select>
        </div>
        <? } ?>
        <div class="b-param">
            <p class="param-name"><?= _t('job', 'Профессиональная сфера'); ?></p>
            <select name="cat"><?= $cats ?></select>
        </div>
        <div class="b-param">
            <p class="param-name"><?= _t('job', 'График'); ?></p>
            <ul><?= $schedule ?></ul>
        </div>            
        <div class="b-param">
            <p class="param-name"><?= _t('job', 'Зарплата'); ?>, <?= Site::currencyDefault() ?></p>
            <div class="num-area"><?= _t('', 'от'); ?> <input type="text" name="pf" value="<?= $f['pf'] ?>" pattern="[0-9]*" /> <?= _t('', 'до'); ?> <input type="text" name="pt" value="<?= $f['pt'] ?>" pattern="[0-9]*" /></div>
        </div>
        <div class="param-btn"><div class="btn"><input type="button" value="<?= _t('', 'Найти'); ?>" onclick="jobSearch.submit();" /><i></i></div></div>
    </form>
</div>
<script type="text/javascript">
<? js::start(); ?>
var jobSearch = (function(){
    var $form;
    
    $(function(){ 
        $form = $('#job-search');
    });

    function submit(){
        var act = $form.prop('action');
        var t = $form.find('[name="type"]:checked').data('k');
        if(t){ act += t + '/'; }else{ act += '<?= $f['type_key'] ?>/'; }
        act += 'search/';
        var c = $form.find('[name="cat"]').find(':selected').data('k');
        if(c){ act += c + '/'; }
        $form.prop('action', act);
        $form.submit();
        return false;
    }
    
    return {
        submit: submit
    };
}());
<? js::stop(); ?>
</script>