<?php 
    /**
     * @var $this Publications
     */
    $bCategories = $type->categoriesEnabled();
    $bModeration = $type->moderationEnabled();
    tpl::includeJS('datepicker', true);
?>
<?= tplAdmin::blockStart($type->title.' / Список', true, array(), array(
    'title' => '+ добавить', 'href'=> $this->adminLink($type->keyword.':add')
)) ?>

<? if($bModeration) { ?>
    <div class="tabsBar" id="pub-mod-tabs">
        <span class="tab <? if(!$f['mod']) { ?>tab-active<? } ?>"><a href="#" onclick="return pubItems.onMod(0, this);">Опубликованные</a></span>
        <span class="tab <? if($f['mod']) { ?>tab-active<? } ?>"><a href="#" onclick="return pubItems.onMod(1, this);">На модерацию</a></span>
    </div>
<? } ?>

<form action="" method="get" name="filters" id="pub-items-filters" onsubmit="return false;">
<input type="hidden" name="page" value="<?= $f['page'] ?>" />
<input type="hidden" name="order" value="<?= $f['order'] ?>" />
<input type="hidden" name="mod" value="<?= $f['mod'] ?>" />
<div class="actionBar">
    <div class="left">
        <div class="left" style="margin-right: 8px;">
            <input type="text" style="width:100px;" maxlength="150" name="title" placeholder="<?= _t('pub', 'ID / Заголовок') ?>" value="<?= HTML::escape($f['title']) ?>" />
        </div>
        <? if( ! Geo::cityIsOne()) { ?>
             <div class="left">
                <select name="city" onchange="pubItems.submit(true);" style="width: 140px; margin-right: 5px;"><?= Geo::cityOptions($f['city'], 'Все города') ?></select>
             </div>
        <? } ?>
        <? if($bCategories){ ?><select name="category" style="width:170px; margin-right:5px;" class="left" onchange="pubItems.onCategory(this.value);"><?= $this->categoriesGet($type, false, array('sel'=>$f['category'], 'empty'=>'Все разделы')); ?></select><? } ?>
        <? if($type->tagsEnabled()) { ?>
             <div class="left relative" style="margin-right: 8px;">
                <input type="hidden" name="tag" id="pub-items-tag-id" value="<?= $f['tag'] ?>" />
                <input type="text" class="autocomplete" id="pub-items-tag-title" style="width: 100px;" placeholder="тег" value="<?= ($f['tag']>0 ? $tag['tag'] : '') ?>" class="tag_title" />
             </div>
        <? } ?>
        <span class="left bold">Период:&nbsp;
            <input type="text" name="p_from" value="<?= $f['p_from'] ?>" placeholder="от" style="width: 70px;" id="pub-items-period-from" />&nbsp;<input type="text" name="p_to" value="<?= $f['p_to'] ?>" placeholder="до" style="width: 70px;" id="pub-items-period-to" />
        </span>
        <input type="button" class="btn btn-small button" style="margin-left: 5px;" onclick="pubItems.submit(true);" value="найти" />
        <div class="clear"></div>
    </div>
    <div class="right">
    </div>
    <div class="clear"></div>
</div>
</form>

<table class="table table-condensed table-hover admtbl tblhover">
<thead>
    <tr class="header">
        <th width="40">
            <a href="javascript: pubItems.onOrder('id');" class="ajax">ID</a>
            <div class="order-<?= $f['order_dir'] ?>" <? if($f['order_by']!='id') { ?>style="display:none;"<? } ?> id="pub-order-id"></div>
        </th>
        <th class="left">Заголовок <div class="progress" style="display:none; top: 0; left: 7px;" id="progress-pub-items"></div></th>
        <th width="105">Создано</th>
        <th width="110">Действие</th>
    </tr>
</thead>
<tbody id="pub-items-list">
<?= $list ?>
</tbody>
</table>
<div id="pub-items-pgn"><?= $pgn; ?></div>
<?= tplAdmin::blockStop(); ?>

<script type="text/javascript">
var pubItems = (function(){
    var $progress, $list, $listPgn, filters;
    var url = '<?= $this->adminLink($type->keyword.':listing'); ?>';
    var orders = <?= func::php2js($orders) ?>;
    var orderby = '<?= $f['order_by'] ?>';
    var is_mod = <?= ($f['mod']?1:0) ?>;
    var _processing = false; 
    
    $(function(){
        $progress = $('#progress-pub-items');
        $list     = $('#pub-items-list');
        $listPgn  = $('#pub-items-pgn');
        filters   = $('#pub-items-filters').get(0);

        $list.on('click', 'a.item-del', function(){
            var id = intval($(this).attr('rel'));
            if(id>0) del( id, this );
            return false;
        });  
        
        <? if($type->tagsEnabled()) {
             tpl::includeJS('autocomplete', true);
             ?>
                $('#pub-items-tag-title').autocomplete( url+'&act=tags-autocomplete', 
                    {valueInput: '#pub-items-tag-id', width: 144, placeholder: 'Тег', minChars: 2,
                     onSelect: function(val, text){ setPage(1); updateList(); }});
             <?       
        } ?>
        
        bff.datepicker('#pub-items-period-from', {yearRange: '-3:+3'});
        bff.datepicker('#pub-items-period-to', {yearRange: '-3:+3'});
              
    });
    
    function isProcessing()
    {
        return _processing;
    }
    
    function del(id, link)
    {
        bff.ajaxDelete('Удалить?', id, url+'&act=delete&item_id='+id,
            link, {progress: $progress, repaint: false});
        return false;
    } 

    function updateList()
    {
        if(isProcessing()) return;
        _processing = true;
        $list.addClass('disabled');
        bff.ajax(url, $(filters).serializeArray(), function(data){
            if(data) {
                $list.html( data.list );
                $listPgn.html( data.pgn );
                
                var f = $(filters).serialize();
                if(bff.h) {
                    window.history.pushState({}, document.title, url + '&' + f);
                }
            }
            $list.removeClass('disabled');
            _processing = false;
        }, $progress);
    }
    
    function setPage(id)
    {
        filters.page.value = intval(id);
    }

    return {
        submit: function(resetPage)
        {
            if(isProcessing()) return false;
            if(resetPage === true) {
                setPage(1);
            }
            updateList();
        },
        page: function (id)
        {
            if(isProcessing()) return false;
            setPage(id);
            updateList();
        }, 
        onCategory: function(id)
        {
            if(isProcessing()) return false;
            filters.category.value = id;
            setPage(1);
            updateList();
            return false;
        }, 
        onOrder: function(by)
        {
            if(isProcessing() || !orders[by])
                return;
                
            orders[by] = (orders[by] == 'asc' ? 'desc' : 'asc');
            //hide prev order direction
            $('#pub-order-'+orderby).hide();
            //show current order direction
            orderby = by;
            $('#pub-order-'+orderby).removeClass('order-asc order-desc').addClass('order-'+orders[by]).show();
                
            filters.order.value = orderby+'-'+orders[by];
            setPage(1);
            
            updateList();
        }, 
        onMod: function(state, link) 
        {
            if(isProcessing() || is_mod == state) return false;
            is_mod = state;
            setPage(1);
            filters.mod.value = state;
            updateList();
            bff.onTab(link);
            return false;
        }, 
        toggle: function(id, $link)
        {
            bff.ajaxToggle(id, url+'&act=toggle&item_id='+id, {progress: $progress, link:$link});
            return false;
        }
    };
}());
</script>