<?php
/**
 * @var $this Realty
 */
 tpl::includeJS('tablednd', true);
?>
<?= tplAdmin::blockStart('Недвижимость / Типы / Добавить тип', false, array('id'=>'realtyTypeFormBlock', 'style'=>'display:none;')); ?>
    <form action="" method="post" name="realtyTypeFormNew">
        <?= $aData['form'] ?>
    </form>
<?= tplAdmin::blockStop(); ?>

<?= tplAdmin::blockStart('Недвижимость / Типы', true, array(), ( FORDEV ? array(
    'title' => '+ добавить тип', 'class'=>'ajax', 'onclick'=>'return realtyTypes.toggle(\'add\');',
) : array())); ?>
<table class="table table-condensed table-hover admtbl tblhover" id="realty-types-table">
    <thead>
    <tr class="header nodrag nodrop">
        <th width="50">ID</th>
        <th class="left">Название</th>
        <th width="85">Действие</th>
    </tr>
    </thead>
    <? if( ! empty($aData['types'])):
        $k = 0;
        foreach($aData['types'] as $v): ?>
    <tr class="row<?= $k % 2 ?>" id="dnd-<?= $v['id'] ?>">
        <td><?= $v['id'] ?></td>
        <td class="left"><?= $v['title'] ?></td>
        <td>
            <? if(FORDEV): ?><a class="but <?= $v['enabled'] ? 'un' : '' ?>block type-toggle" title="Вкл/Выкл" href="#" rel="<?= $v['id'] ?>"></a><? endif; ?>
            <a class="but edit type-edit" title="Редактировать" href="#" rel="<?= $v['id'] ?>"></a>
            <? if(FORDEV): ?><a class="but del type-del" title="Удалить" href="#" rel="<?= $v['id'] ?>"></a><? endif; ?>
        </td>
    </tr>
    <?  $k++; endforeach;
       else: ?>
    <tr class="norecords">
        <td colspan="3">нет типов (<a href="#" class="ajax" onclick="return realtyTypes.toggle('add');">добавить</a>)</td>
    </tr>
    <? endif; ?>
</table>
<div>
    <div class="left">

    </div>
    <div class="right desc" style="width:60px; text-align:right;">
        <div class="progress" id="progress-realty-types" style="display:none;"></div>
        &darr; &uarr;
    </div>
    <br />
</div>
<?= tplAdmin::blockStop(); ?>

<script type="text/javascript">
var realtyTypes = (function(){
    var $progress, $block, $blockCaption, form, formClean, $list, fChecker;
    var ajax_url = '<?= $this->adminLink('types&act=') ?>';

    $(function(){
        form = document.forms.realtyTypeFormNew;

        fChecker = new bff.formChecker(form);
        formClean = $(form).html();

        $progress = $('#progress-realty-types');
        $block = $('#realtyTypeFormBlock');
        $blockCaption = $block.find('span.caption');
        $list = $('#realty-types-table');

        $list.on('click', 'a.type-edit', function(){
            var id = intval($(this).attr('rel'));
            if(id>0) edit( id );
            return false;
        });
        $list.on('click', 'a.type-toggle', function(){
            var id = intval($(this).attr('rel'));
            if(id>0) {
                bff.ajaxToggle(id, ajax_url+'toggle', {progress: $progress, link: this});
            }
            return false;
        });
        $list.on('click', 'a.type-del', function(){
            var id = intval($(this).attr('rel'));
            if(id>0) del( id, this );
            return false;
        });

        bff.rotateTable('#realty-types-table', ajax_url+'rotate', $progress);
    });

    function toggle(type, editData)
    {
        switch(type) {
            case 'add': {
                if($block.is(':hidden')) {
                    $block.show();
                    $(form).html(formClean);
                    $blockCaption.html('Недвижимость / Типы / Добавить тип');
                    $.scrollTo( $blockCaption, { duration:500, offset:-300 } );
                } else {
                    $block.hide();
                }
            } break;
            case 'cancel': {
                $block.hide();
            } break;
            case 'edit': {
                $blockCaption.html(editData.caption);
                $(form).html(editData.form);
                $block.show();
                $.scrollTo( $blockCaption, { duration:500, offset:-300 } );
                form.elements['act'].value = 'edit-finish';
            } break;
        }
        fChecker.check(true, true);
        return false;
    }

    function del(id, link)
    {
        bff.ajaxDelete('Удалить тип?', id,
            ajax_url+'delete&type_id='+id,
            link, {progress: $progress, repaint: false});
        return false;
    }

    function edit(id)
    {
        bff.ajax(ajax_url+'edit&type_id='+id,{},function(data){
            if(data) {
                toggle('edit', $.extend({caption: 'Недвижимость / Типы / Редактирование типа'}, data) );
            }
        }, $progress);
        return false;
    }

    return {toggle: toggle};
}());
</script>