<?php
/**
 * @var $this Realty
 */
?>
<div class="object realty-view" style="margin-left: 0;">
    <div class="relative">
        <span class="cat f12 grey" style="position:absolute;"><?= _t('realty', 'Недвижимость') ?></span>
        <h1><?= $view_title ?></h1>
    </div>
    <div class="left w430">
        <p class="estate-sum"><?= tpl::formatPrice($price, $price_curr) ?></p>
        <? if($price_params > 0) { ?>
            <? $i = 0; foreach($this->getPriceParams() as $ppKey=>$ppTitle) { ?><? if($price_params & $ppKey) { ?><span class="grey"><? if($i){ ?>, <? } ?><?= $ppTitle ?></span><? $i++; } ?><? } ?>
        <? } ?>
        <div class="mt10 f12"><i class="iconlink fa fa-map-marker f14 grey"></i><?= $address_full ?></div>
        <table class="infoTable mt20">
            <?= $descfull ?>
        </table>
        <div class="separator"></div>
        <div class="info">
            <?= nl2br($info) ?>
        </div>
        <? if($cat_address == 2 && $lat > 0)
        {
            Geo::mapsAPI();
            ?>
            <div class="mt20">
                <div class="object-map" id="realty-view-map" style="width: 466px; height: 300px;"></div>
                <script type="text/javascript">
                    <? js::start(); ?>
                    $(function(){
                        app.map('realty-view-map', '<?= HTML::escape($lat.','.$lng, 'js') ?>', false, {marker:true});
                    });
                    <? js::stop(); ?>
                </script>
            </div>
        <? } ?>
    </div>
    <div class="right w290 mt20">
        <? if($imgcnt > 0) { ?>
            <div class="mb30"><img alt="<?= $title_alt ?>" src="<?= $this->initImages()->getUrl($id, $imgfav, RealtyImages::szThumbnail); ?>" /></div>
        <? } ?>
        <div class="contacts-realty">
            <?= _t('', 'Контакты') ?>
            <table class="infoTable">
                <? if($company_id > 0 && $company_data) { ?>
                    <tr><td width="85"><span class="grey"><?= _t('', 'Компания') ?>:</span></td><td><a href="<?= $company_data['url'] ?>"><?= $company_data['title'] ?></a></td></tr>
                <? } else { ?>
                    <tr><td width="85"><span class="grey"><?= _t('', 'Автор') ?>:</span></td><td><?= ($user_type == Realty::USERTYPE_AGENT ? _t('', 'Агент') : _t('', 'Владелец')) ?></td></tr>
                <? } ?>
                <tr><td width="85"><span class="grey"><?= _t('', 'Имя') ?>:</span></td><td><?= $user_name ?></td></tr>
                <tr><td><span class="grey"><?= _t('', 'Телефон') ?>:</span></td><td><?= $user_phone ?></td></tr>
            </table>
        </div>
    </div>
    <div class="clear"></div>
    <div class="mt20 btn left printButton"><input type="button" onclick="window.print();" value="<?= _t('', 'распечатать'); ?>"><i></i></div>
</div>
