<?php

/**
 * Права доступа группы:
 *  - sendmail: Работа с почтой
 *      - massend: Массовая рассылка
 */

class Sendmail extends SendmailBase
{
    //---------------------------------------------------------------
    // рассылка писем

    function massend()
    {
        if( ! $this->haveAccessTo('massend') )
            return $this->showAccessDenied();

        $aData = array();
        $aData['noreply'] = config::sys('mail.noreply');

        return $this->viewTPL($aData, 'admin.massend.tpl');
    }

    function massend_listing()
    {
        if( ! $this->haveAccessTo('massend') )
            return $this->showAccessDenied();

        $aData = $this->db->select('SELECT * FROM '.TABLE_MASSEND.' ORDER BY id DESC');

        return $this->viewTPL($aData, 'admin.massend.listing.tpl');
    }

    function ajax()
    {
        if( ! $this->haveAccessTo('massend') )
            $this->ajaxResponse(Errors::ACCESSDENIED);
        
        if( Request::isAJAX(NULL) )
        {
            switch ($this->input->getpost('act', TYPE_STR))
            {
                case 'massend-delete':
                {
                    $nMassendID = $this->input->post('rec', TYPE_UINT);
                    if(!$nMassendID) break;

                    $this->db->exec('DELETE FROM '.TABLE_MASSEND.' WHERE id = '.$nMassendID);
                    $this->db->exec('DELETE FROM '.TABLE_MASSEND_RECEIVERS.' WHERE massend_id = '.$nMassendID);
                    
                    $this->ajaxResponse(Errors::SUCCESS);
                    
                } break;
                case 'massend-info':
                {
                    $nMassendID = $this->input->get('rec', TYPE_UINT);
                    if(!$nMassendID) break;
                    
                    $aData = $this->db->one_array('SELECT * FROM '.TABLE_MASSEND.' WHERE id = '.$nMassendID);
                    if (empty($aData)) break;
                    
                    $aSettings = unserialize($aData['settings']);
                    $aData['from']       = $aSettings['from'];
                    $aData['subject']    = $aSettings['subject'];
                    $aData['body']       = $aSettings['body'];
                    $aData['time_total'] = $aSettings['time_total'];
                    $aData['time_avg']   = $aSettings['time_avg'];

                    echo $this->viewTPL($aData, 'admin.massend.info.tpl');
                    bff::shutdown();
                } break;
                case 'massend':
                {

                    $this->input->postm(array(
                        'test'    => TYPE_BOOL,
                        'from'    => TYPE_STR,
                        'subject' => TYPE_STR,
                        'body'    => TYPE_STR,
                    ), $p); extract($p, EXTR_REFS);

                    $body = nl2br($body); 
                    $body = preg_replace ("@<script[^>]*?>.*?</script>@si", '', $body);

                    // set_time_limit(0); 
                    ignore_user_abort(true);

                    if( !( !empty($from) && !empty($subject) && !empty($body) ) )
                            $this->ajaxResponse(Errors::IMPOSSIBLE);
                    
                    if($test) 
                    {
                        $aReceiversTest = $this->input->post('receivers_test', TYPE_STR);
                        $aReceiversTest = explode(',', $aReceiversTest);
                        if(!empty($aReceiversTest)) {
                            $aReceivers = array_map('trim', $aReceiversTest);
                        }
                        
                        $nSendSuccess = 0;
                        $time_start = microtime(true);
                        $nReceiversTotal = sizeof($aReceivers);
                        $aReceiversSended = array();
                        
                        # формируем текст письма на основе шаблона "massend"
                        $aTemplate = $this->getMailTemplate('massend', array('msg'=>$body));
                        $body = $aTemplate['body'];
                        
                        $mailer = new CMail();
                        $mailer->From = $from;
                        $mailer->Subject = $subject;
                        $mailer->MsgHTML( $body ); 
                        
                        for($i=0; $i<$nReceiversTotal; $i++) 
                        {
                            $mailer->AddAddress($aReceivers[$i]);
                            if($mailer->Send()) 
                                $nSendSuccess++;
                         
                           $mailer->ClearAddresses();
                           usleep(150000); // sleep for 0.15 second
                        }
                        
                        $time_total = (microtime(true) - $time_start); //останавливаем секундомер
                        
                        $this->ajaxResponse( array(
                                    'total'=>$nReceiversTotal,
                                    'success'=>$nSendSuccess, 
                                    'failed'=>($nReceiversTotal-$nSendSuccess), 
                                    'sended'=>$aReceiversSended,
                                    'time_total'=>sprintf('%0.2f', $time_total),
                                    'time_avg'=>sprintf('%0.2f', ( ! empty($nReceiversTotal)?($time_total/$nReceiversTotal):0)  ),
                                    'res'=>$this->errors->no()
                                    ) );
                    } 
                    else 
                    {
                        // формируем список получателей, исключая заблокированных/неактивированных/не подписавшихся на рассылку
                        $aReceivers = $this->db->select_one_column('SELECT user_id FROM '.TABLE_USERS.' 
                                    WHERE enotify > 0 AND blocked = 0 AND activated = 1 AND (enotify & '.USERS_ENOTIFY_NEWS.')
                                    ORDER BY user_id ASC');
                        $nReceiversTotal = sizeof($aReceivers);
                        
                        $this->db->exec('INSERT INTO '.TABLE_MASSEND.' (total, started, settings)
                            VALUES('.$nReceiversTotal.', :started, :sett)', 
                                array(':started'=>$this->db->now(),
                                      ':sett'=>serialize(array('from'=>$from, 'subject'=>$subject, 'body'=>$body, 'time_total'=>0, 'time_avg'=>0)))
                                 );
                        $nMassendID = $this->db->insert_id(TABLE_MASSEND, 'id');
                        if (empty($nMassendID)) {
                            $this->errors->set( _t('sendmail', 'Ошибка инициализации рассылки') );
                            $this->ajaxResponse( null );
                        }
                        
                        //сохраняем id пользователей(получатетей) в базу
                        $aSqlInsert = array();
                        foreach($aReceivers as $userID) {
                            $aSqlInsert[] = "($nMassendID, $userID)";
                        }

                        $res = $this->db->exec('INSERT INTO '.TABLE_MASSEND_RECEIVERS.' (massend_id, user_id)
                            VALUES '.join(',', $aSqlInsert));
                        
                        $this->ajaxResponse(Errors::SUCCESS);
                    }
                    
                } break;
            }
        }
        
        $this->ajaxResponse(Errors::IMPOSSIBLE);
    }


}