<?php

abstract class ServicesTv
{
    abstract function init($aSettings);

    /**
     * Инициализация TV класса
     * @param array $aSettings дополнительные настройки
     * @return ServicesTv объект
     */
    public static function &i($aSettings = array())
    {
        static $instances = array();

        $type = config::sys('services.tv.type');
        $typeClass = 'ServicesTv'.$type;
        if( empty($type) || ! class_exists($typeClass) ) {
            throw new \Exception('Указанный тип TV-сервиса ('.$type.') некорректный');
        }
        if (empty($instances[$type])) {
            $instances[$type] = new $typeClass();
            $instances[$type]->init($aSettings);
        }
        return $instances[$type];
    }

    protected function getKey()
    {
        return config::sys('services.tv.key');
    }
}

class ServicesTvVida extends ServicesTv
{
    function init($aSettings)
    {
        //
    }
}