<?php

$cityList = Geo::cityList();
$cityID = Geo::cityID(true);
$now = $aData['today'][0];
$wImg = SITEURL_STATIC.'/img/weather/';
$wURL = Services::url('weather');
$weekDays = array(_t('','вс'),_t('','пн'),_t('','вт'),_t('','ср'),_t('','чт'),_t('','пт'),_t('','сб'));
$weekDaysFull = array(_t('','Воскресенье'),_t('','Понедельник'),_t('','Вторник'),_t('','Среда'),_t('','Четверг'),_t('','Пятница'),_t('','Суббота'));
$months = bff::locale()->getLanguageSettings(LNG, 'month');
$nDay = time();
$wday = date('w', $nDay);  
$bPrint = $aData['print'];
$b10 = $aData['10'];

?>
<div class="weather mt20">
    <div class="weather-town">
        <div class="city left" id="popup-city-weather-current"><?= $cityList[$cityID]['title']; ?></div>
        <? if(!$bPrint && ! Geo::cityIsOne()) { ?>
        <div class="other left">
            <a href="#" id="popup-city-weather-link"><?= _t('', 'другой город'); ?></a>
            <div class="popup-town displaynone" id="popup-city-weather">
                <ul><? foreach($cityList as $k=>$v) { ?><li><a href="<?= Geo::urlBase(LNG, false, array('city'=>$k)) ?>/weather" data-id="<?= $k ?>"<? if($cityID == $k){ ?> class="active"<? } ?>><?= $v['title'] ?></a></li><? } ?></ul>
            </div>
        </div>
        <? } ?>
        <div class="clear"></div>
    </div>
    <? if (empty($now)) { ?><br/><br/><? } else { ?>
    <div class="today">
        <table>
            <tr>
                <td><img alt="<?= $now['txt'] ?>" src="<?= $wImg.'b/'.$now['ns'].$now['w'].'.gif' ?>" width="100" title="<?= $now['txt'] ?>" /></td>
                <td>
                    <div class="temp"><?= $now['avg'] ?>°C</div>
                </td>
                <td>
                    <div class="addition">
                        <span class="grey"><?= _t('services', 'Ветер'); ?>:</span> <?= $now['wdt'] ?>,  <?= $now['ws'] ?> <?= _t('services', 'м/с'); ?><br />
                        <span class="grey"><?= _t('services', 'Давление'); ?>:</span> <?= $now['p'] ?>  <?= _t('services', 'мм рт. ст.'); ?><br />
                        <span class="grey"><?= _t('services', 'Влажность'); ?>:</span> <?= $now['hum'] ?>%
                    </div>
                </td>
                <? unset($aData['today'][0]);
                foreach($aData['today'] as $v){ ?>
                    <td align="center" class="part"><?= $v['time'] ?><br /><span class="f14"><?= $v['avg'] ?></span><br /><img alt="<?= $v['time'] ?>" width="20" src="<?= $wImg.'s/'.$v['ns'].$v['w'].'.gif' ?>" title="<?= $v['txt'] ?>" /></td>
                <? } ?>
            </tr>
        </table>
    </div>
    <? } ?> 
</div> 
<div class="forecast">
    <? if(!$bPrint){ ?>
    <div class="separatornobr"></div>
    <div class="w-menu">
        <div class="left"><b><?= _t('services', 'Прогноз'); ?>:</b> <? if($b10){ ?><span><a href="<?= $wURL ?>"><?= _t('services', 'на 3 дня'); ?></a></span><? } else { ?><span><?= _t('services', 'на 3 дня'); ?></span><? } ?>&nbsp;|&nbsp;<? if($b10){ ?><span><?= _t('services', 'на 10 дней'); ?></span><? } else { ?><span><a href="<?= $wURL.'?d10=1' ?>"><?= _t('services', 'на 10 дней'); ?></a></span><? } ?></div>
        <div class="print-vertion right"><a href="<?= $wURL.($b10 ? '?d10=1&print=1':'?print=1') ?>" class="f11"><?= _t('', 'Версия для печати'); ?></a></div>
        <div class="clear"></div>
    </div>
    <? } ?>
    <? if($b10)
    { 
        if (empty($aData['days'])) {
            ?><div align="center"><span class="grey"><?= _t('services', 'За указанный период информации о погоде не найдено'); ?></span></div><?
        } else {
            $nDaysTotal = sizeof($aData['days']);
        ?>
        <table>
            <tbody>
                <tr>
                    <td>&nbsp;</td>
                    <? $i = $nDaysTotal; while($i--){ ?>
                    <td class="nw_day_s<?= ( $wday ==0 || $wday == 6 ? ' weekends' : '') ?>"><?= date('d.m',$nDay) ?><br /><span class="f11"><?= $weekDays[$wday] ?></span></td>
                    <? 
                        $wday++; if($wday > 6){ $wday = 0; }
                        $nDay += 86400; // + сутки
                    } ?>
                </tr>                
                <tr class="nw_td_e_s_day">
                    <td class="nw_td_day_s">
                        <?= _t('services', 'День'); ?>
                    </td>
                    <? foreach($aData['days'] as $d) { $v = $d['params']['d']; ?>
                    <td class="nw_td_e_s"><span><?= ($v['t']>0 ? '+' : '').$v['t'] ?></span><br /><img width="20" title="<?= $v['txt'] ?>" src="<?= $wImg.'s/'.$v['w'].'.gif' ?>" /></td>
                    <? } ?>
                </tr>
                <tr class="nw_td_e_s_night">
                    <td class="nw_td_day_s">
                        <?= _t('services', 'Ночь'); ?>
                    </td>
                    <? foreach($aData['days'] as $d) { $v = $d['params']['n']; ?>
                    <td class="nw_td_e_s"><span><?= ($v['t']>0 ? '+' : '').$v['t'] ?></span><br /><img width="20" title="<?= $v['txt'] ?>" src="<?= $wImg.'s/n'.$v['w'].'.gif' ?>" /></td>
                    <? } ?>                    
                </tr>                    
            </tbody>
        </table>
    <? } } else {
    
      if (empty($aData['days'])) {
          ?><div align="center"><span class="grey"><?= _t('services', 'За указанный период информации о погоде не найдено'); ?></span></div><?
      } else {
     ?>
    <table>
        <tbody>
            <tr>
                <td>&nbsp;</td>
                <td class="nw_day_w"><?= _t('services', 'Ночь'); ?></td>
                <td class="nw_day_w"><?= _t('services', 'Утро'); ?></td>
                <td class="nw_day_w"><?= _t('services', 'День'); ?></td>
                <td class="nw_day_w"><?= _t('services', 'Вечер'); ?></td>
            </tr>
            <? 
            $i = 0;
            foreach($aData['days'] as $d) { ?>
            <tr>
                <td class="nw_td_day"><?= (!$i ? _t('services','Сегодня') : ($i==1 ? _t('services','Завтра') : $weekDaysFull[$wday])) ?><br /><span class="f12 <?= ( $wday ==0 || $wday == 6 ? 'red' : 'grey') ?>"><?= date('d',$nDay) ?> <?= $months[ intval(date('m',$nDay)) ] ?>, <?= $weekDays[$wday] ?></span></td>
                <? foreach($d['params'] as $time=>$v){ ?>
                <td class="nw_td_day_e">
                    <table>
                        <tbody>
                        <tr><td class="nw_td_e_lt"><img title="<?= $v['txt'] ?>" src="<?= $wImg.$v['ns'].$v['w'].'.gif' ?>" width="32" /></td><td class="nw_td_e_rt"><span><?= $v['avg'] ?></span><br><?= $v['txt'] ?></td></tr>
                        <tr><td></td><td class="nw_td_e_r f11"><?= $v['wdt'] ?>,&nbsp;<?= $v['ws'] ?> <?= _t('services', 'м/с'); ?><br><?= $v['hum'] ?>%,&nbsp;<?= $v['p'] ?> <?= _t('services', 'мм рт. ст.'); ?></td></tr>
                        </tbody>
                    </table>
                </td>
                <? } ?>
            </tr>
            <tr><td colspan="5" class="spacers"></td></tr>
            <?
                $i++;
                $wday++; if($wday > 6){ $wday = 0; }
                $nDay += 86400; // + сутки
            } ?>
        </tbody>
    </table>
    <? } } ?>
</div>

<? if(!$bPrint){ ?>
<script type="text/javascript">
<? js::start(); ?>
$(function(){
    // city select popup (weather page)
    app.popupDropdown('city-weather', '#popup-city-weather', '#popup-city-weather-link', {onInit: function($popup)
    {
        $popup.find('a').click(function(e){
            var cityID = intval($(this).data('id'));
            bff.cookie(app.cookiePrefix+'geo', cityID, {expires: 500, domain:'.'+app.host, path:'/'});
        });
    }});
});
<? js::stop(); ?>
</script>
<? } else {
    ?><div class="btn printButton" style="margin-left: <?= $b10 ? 50 : 90 ?>px; margin-top: 10px;"><input type="button" onclick="window.print();" value="<?= _t('', 'распечатать'); ?>"><i></i></div><?
}