<?php

abstract class SiteBase extends SiteModule
{
    /** @var SiteModel */
    public $model = null;

    /** @var string Путь к изображениям */
    protected $watermarkPath = '';
    /** @var string URL к изображениям */
    protected $watermarkUrl = '';

    function __construct()
    {
        $this->watermarkPath =  bff::path('images');
        $this->watermarkUrl =  bff::url('images');
    }


    /**
     * Формируем список доступных валют, помечаем текущую
     * @param integer $nSelectedID @ref текущая валюта
     * @param bool|mixed $bSelectOptions true - формировать select::options, false - возвращать в форме массива
     * @param mixed $mSelectEmpty значение по-умолчанию для select::options
     * @return array
     */
    public static function currencyOptions(&$nSelectedID = false, $bSelectOptions = true, $mSelectEmpty = false)
    {
        $aCurr = static::model()->currencyData(false);
        if ($nSelectedID !== false) {
            if ( ! isset($aCurr[$nSelectedID]) ) {
                $nSelectedID = key($aCurr);
            }
        }
        if ($bSelectOptions) {
            return HTML::selectOptions($aCurr, $nSelectedID, $mSelectEmpty, 'id', 'title_short');
        } else {
            $aCurr[$nSelectedID]['a'] = 1;
            return $aCurr;
        }
    }

    /**
     * Формирование URL
     * @param string $key ключ
     * @param mixed $opts параметры
     * @param boolean $dynamic динамическая ссылка
     * @return string
     */
    public static function url($key = '', $opts = array(), $dynamic = false)
    {
        $base = static::urlBase(LNG, $dynamic);
        switch ($key)
        {
            # статическая страница
            case 'page':
                return $base . '/' . $opts['filename'] . static::$pagesExtension;
                break;
            # Поиск по сайту
            case 'search':
                return $base.'/search'.static::urlQuery($opts);
                break;
        }
        return $base;
    }

    /**
     * Описание seo шаблонов страниц
     * @return array
     */
    public function seoTemplates()
    {
        $aTemplates = array(
            'groups' => array(
                'def' => array('t' => 'Общие'),
                'services' => array('t' => 'Сервисы'),
            ),
            'pages' => array(
                'index' => array(
                    't'      => 'Главная страница',
                    'macros' => array(),
                    'fields' => array(
                        //...
                    ),
                ),
                'index-region' => array(
                    't'      => 'Главная страница (регион)',
                    'macros' => array(
                        'region' => array('t' => 'Регион поиска'),
                    ),
                    'fields' => array(
                        //...
                    ),
                ),
                'index-mobile' => array(
                    't'      => 'Главная страница (mobile)',
                    'macros' => array(),
                    'fields' => array(
                        //...
                    ),
                ),
                'page-view' => array(
                    't'       => 'Статические страницы',
                    'inherit' => true,
                    'macros'  => array(
                        'title' => array('t' => 'Заголовок страницы'),
                    ),
                ),
                'search' => array(
                    't'      => 'Поиск по сайту',
                    'macros' => array(),
                    'fields' => array(
                        // ...
                    ),
                ),
                'sitemap' => array(
                    't'      => 'Карта сайта',
                    'group'  => 'services',
                    'macros' => array(),
                    'fields' => array(
                        'titleh1' => array(
                            't'      => 'Заголовок H1',
                            'type'   => 'text',
                        ),
                    ),
                ),
                'news' => array(
                    't'      => 'Подписка на новости',
                    'group'  => 'services',
                    'macros' => array(),
                    'fields' => array(
                        'titleh1' => array(
                            't'      => 'Заголовок H1',
                            'type'   => 'text',
                        ),
                    ),
                ),
                'voting' => array(
                    't'      => 'Опросы',
                    'group'  => 'services',
                    'macros' => array(),
                    'fields' => array(
                        'titleh1' => array(
                            't'      => 'Заголовок H1',
                            'type'   => 'text',
                        ),
                    ),
                ),
            ),
        );

        return $aTemplates;
    }

    /**
     * Получение данных о текущих настройках водяного знака
     * @param mixed $settings array - сохраняем настройки, false - получаем текущие
     * @param array
     */
    public function watermarkSettings($settings = false)
    {
        $configKey = 'images_watermark';
        if ($settings === false) {
            $settings = config::get($configKey);
            $settings = (!empty($settings) && strpos($settings, 'a:') === 0 ? unserialize($settings) : array());
            $settings = $this->input->clean_array($settings, array(
                    'file'  => TYPE_ARRAY,
                    'pos_x' => TYPE_STR,
                    'pos_y' => TYPE_STR,
                )
            );

            return $settings;
        } else {
            $settings = array_merge($this->watermarkSettings(), (array)$settings);
            config::save($configKey, serialize($settings));
        }
    }

    /**
     * Сохранение настроек водяного знака
     * @param string $fileUpload ключ для загрузки файла
     * @param boolean $fileDelete выполнить удаление файла (ранее загруженного)
     * @param string $positionX ключ позиции знака по-вертикали
     * @param string $positionY ключ позиции знака по-горизонтали
     */
    public function watermarkSave($fileUpload, $fileDelete, $positionX, $positionY)
    {
        $settings = array();

        if (!in_array($positionX, array('left', 'center', 'right'))) {
            $positionX = 'right';
        }
        $settings['pos_x'] = $positionX;

        if (!in_array($positionY, array('top', 'center', 'bottom'))) {
            $positionY = 'bottom';
        }
        $settings['pos_y'] = $positionY;

        if ($fileDelete) {
            $current = $this->watermarkSettings();
            if (!empty($current['file']['path']) && file_exists($current['file']['path'])) {
                unlink($current['file']['path']);
            }
            $settings['file'] = array();
        }

        if (!empty($_FILES[$fileUpload]) && $_FILES[$fileUpload]['error'] != UPLOAD_ERR_NO_FILE) {
            $uploader = new \bff\files\Attachment($this->watermarkPath, 5242880); # до 5мб.
            $uploader->setFiledataAsString(false);
            $uploader->setAllowedExtensions(array('jpg', 'jpeg', 'png', 'gif'));
            $file = $uploader->uploadFILES($fileUpload);
            if (!empty($file)) {
                $file['path'] = $this->watermarkPath . $file['filename'];
                $file['url'] = $this->watermarkUrl . $file['filename'];
                $settings['file'] = $file;
            }
        }

        $this->watermarkSettings($settings);
    }

    /**
     * Формирование списка директорий/файлов требующих проверки на наличие прав записи
     * @return array
     */
    public function writableCheck()
    {
        return array_merge(parent::writableCheck(), array(
            config::file('instructions', true) => 'file', # инструкции
        ));
    }

}