<?php

class UsersAvatar extends CImageUploader
{
    const szSmall  = 's'; # small - в шапке, второй уровень комментариев
    const szNormal = 'n'; # normal - в блоке слева

    function initSettings()
    {
        $this->path    = bff::path('avatars', 'images');
        $this->pathTmp = bff::path('tmp', 'images');

        $this->url     = bff::url('avatars', 'images');
        $this->urlTmp  = bff::url('tmp', 'images');

        $this->table = TABLE_USERS;
        $this->fieldID = 'user_id';
        $this->fieldImage = 'avatar';
        $this->filenameLetters = 6;
        $this->folderByID = true;
        $this->maxSize = 3145728; // 3мб
        $this->minWidth  = 50;
        $this->minHeight = 50;
        $this->maxWidth  = 1000;
        $this->maxHeight = 1000;
        $this->sizes = array (
            self::szSmall  => array('width'=>40,'height'=>40),
            self::szNormal => array('width'=>60,'height'=>60),
        );
    }

    static function url($nUserID, $sFilename, $sSizePrefix = '', $nSex = 0, $bTmp = false)
    {
        static $i;
        if( ! isset($i)) $i = new self();
        $i->setRecordID($nUserID);

        if (empty($sSizePrefix)) {
            $sSizePrefix = self::szNormal;
        }

        if (empty($sFilename)) {
            return $i->url . 'default-'.$sSizePrefix.'.gif';
        }

        return $i->getURL($sFilename, $sSizePrefix, $bTmp);
    }

    static function urlDefault($sSizePrefix, $nSex = 0)
    {
        return self::url(0,0,$sSizePrefix,$nSex);
    }

    public function uploadFromFile($sFieName)
    {
        if( ! file_exists($sFieName)) return false;
        $sExtension = bff\utils\Files::getExtension($sFieName);
        $aImageSize = getimagesize($sFieName);
        if ($aImageSize === false
            || !in_array($sExtension, array('gif', 'png', 'jpg'))
            || !in_array($aImageSize[2], array(IMAGETYPE_GIF, IMAGETYPE_JPEG, IMAGETYPE_PNG))
        ) {
            return false;
        }

        $aResult = $this->save(array(
            'ext'     => $sExtension,
            'tmpfile' => $sFieName,
        ));

        return $aResult;
    }

    public function getSizeWidth($nSizePrefix)
    {
        return ( isset($this->sizes[$nSizePrefix]['width']) ? $this->sizes[$nSizePrefix]['width'] : 0 );
    }

    /**
     * Загрузка аватара из соц. сети
     * @param integer $nSocialProviderID ID провайдера
     * @param string $sProviderAvatarURL URL аватара в соц. сети
     * @param boolean $bNewUserAccount true - вновь созданный аккаунт пользователя
     */
    public function uploadSocial($nSocialProviderID, $sProviderAvatarURL, $bNewUserAccount = true)
    {
        if ($nSocialProviderID == UsersSocial::PROVIDER_ODNOKLASSNIKI && stripos($sProviderAvatarURL, 'stub_') !== false) {
            # Ссылка на аватар у Одноклассников.ру
            # пустой - http://usd12.odnoklassniki.ru/res/stub_128x96.gif
            # загруженный - http://usd5.odnoklassniki.ru/getImage?photoId=000000000000&photoType=2
        } else {
            # сбрасываем ограничение по ширине/высоте
            $this->setDimensions(0, 0, 0, 0);
            # загружаем
            $mResult = $this->uploadURL($sProviderAvatarURL, !$bNewUserAccount, true);
            if ($mResult !== false) {
                # обновляем аватар в сессии
                if (!$bNewUserAccount) {
                    $this->security->updateUserInfo(array('avatar' => $mResult['filename']));
                }
            }
        }
    }

}