bff.extend(app,
{
    m: false, popups: {}, _usett: 0, csrf_nonce: 0,
    init: function()
    {
        $('body').click(function(e) { app.popupsHide(false); });
        this._usett = intval( bff.cookie(app.cookiePrefix+'usett') || 0 );
        this.csrf_nonce = $('head > meta[name="csrf_nonce"]').attr('content');
        bff.map.setType(app.mapType);
    },
    usett: function(key, save)
    {
        if('undefined' != typeof save) {
            if(save === true)  {
                if(!(this._usett & key))
                    bff.cookie(app.cookiePrefix+'usett', (this._usett |= key), {expires: 500});                    
            } else {
                bff.cookie(app.cookiePrefix+'usett', (this._usett -= key), {expires: 500});
            }
        } else {
            return (this._usett & key);
        }
    },
    popup: function( id, popupSelector, linkSelector, o)
    {
        if(id && this.popups[id]) { return this.popups[id]; }
        var $popup = $(popupSelector); if(!$popup.length) return false;
        o = $.extend({bl:true,scroll:true}, o || {});

        var visible = false, focused = false, inited = false;
        var self = {
            o:o,
            init: function() {
                if(inited) return; inited = true;
                if(o.onInit) o.onInit.call(self, $popup);
                $('a.close', $popup).click( function(e){ if(o.bl) app.busylayer(true); self.hide(); nothing(e); } );
            },
            show: function(event){ 
                self.init();
                if(event) nothing(event);
                if(visible) return false;
                $popup.removeClass('displaynone');
                focused = false; visible = true;
                if(o.onShow) o.onShow.call(self, $popup);
                if(o.scroll) $.scrollTo($popup, {offset: -100, duration:500});
                app.popupsHide( id ); //hide popups, except this one ($popup)
                if(o.bl) {
                    app.busylayer().unbind().bind('click touchstart', function(e){ self.hide(); nothing(e); });
                }
                return true;
            },
            hide: function(bl){
                if( !visible ) return false;
                $popup.addClass('displaynone');
                focused = visible = false;
                if(o.onHide) o.onHide.call(self, $popup);
                if(bl!==false && o.bl) app.busylayer(true);
                return true;
            },
            toggle: function() {
                return ( visible ? self.hide(true) : self.show() );
            },
            isFocused: function() { return focused; },
            isInited: function() { return inited; },
            getPopup: function() { return $popup; },
            setOptions: function(opt) { o = opt || {}; }
        };

        $popup.on('mouseleave mouseenter', function(e){ focused = !( e.type == 'mouseleave' ); });
        
        if (linkSelector) {
            $(linkSelector).click(function(e){
                self.toggle();
                nothing(e); return false;
            });
        }
        $popup.data('popup-id', id);
        return ( this.popups[id] = self );
    },
    popupDropdown: function(id, popupSelector, linkSelector, o)
    {
        o = o || {};
        o.bl = false;
        o.scroll = false;
        return app.popup(id, popupSelector, linkSelector, o);
    },
    popupsHide: function( exceptID )
    {
        var blHidden = false;
        $.each(this.popups, function(id,p){
            if(exceptID!==false) { 
                if(id === exceptID) return;
                p.hide(false);
            } else if(!p.isFocused()) {
                if( p.hide(false) && !blHidden && p.o.bl ) {
                    blHidden = true;
                    app.busylayer(true);
                }
            }
        });
    },
    busylayer: function(toggle, callback)
    {
        callback = callback || new Function();
        toggle = toggle || false;

        var docHeight = $(document).height() - 10;

        var bl = $('#busyLayer');
        if(!bl.length) //if not exists
        {
            var body = document.getElementsByTagName('body')[0];

            bl = document.createElement('div');
            bl.id = 'busyLayer';
            bl.className = 'busyLayer';
            bl.style.display = 'none';
            bl.style.textAlign = 'center';
            body.appendChild(bl);

            $(bl).css({'filter':'Alpha(Opacity=50)', 'opacity':'0.5'});
        }
        bl = $(bl);

        if(bl.is(':visible')) {
            if(toggle){
                bl.fadeOut('fast', function() { bl.hide(); });
            }
            return bl;
        }

        bl.css('height', docHeight + 'px').fadeIn('fast',callback);
        return bl;
    },
    alert: (function()
    {
        var timer = false, o_def = {title:false, hide:5000},
            $block, $wrap, $title, $message, type_prev;

        $(function(){
            $block = $('#j-alert-global'); if( ! $block.length) return;
            $wrap = $block.find('.j-wrap');
            $title = $block.find('.j-title');
            $message = $block.find('.j-message');
            $block.on('click touchstart', '.close', function(e){ nothing(e); _hide(); } );
        });

        function _show(type, msg, o)
        {
            if(timer) clearTimeout(timer);
            do {
                if(!msg) break;
                if($.isArray(msg)) { if(!msg.length) break; msg = msg.join(', '); } // array
                else if ($.isPlainObject(msg) ) { // object
                    var res = []; for(var i in msg) res.push(msg[i]);
                        msg = res.join(', ');
                } else { } // string

                o = $.extend({}, o_def, o||{});
                $wrap.removeClass('alert-'+type_prev).addClass('alert-'+type); type_prev = type;
                if(o.title) $title.html(o.title).removeClass('hide');
                else $title.html('').addClass('hide');
                $message.html(msg);
                $block.fadeIn(300, function(){
                    $.scrollTo($block, {offset: -150, duration:500});
                });
                if(o.hide!==false && o.hide >=0 ) { timer = setTimeout(function(){ _hide(); }, o.hide); }
                return;
            } while(false);
            _hide();
        }

        function _hide()
        {
            $block.fadeOut(1000);
        }

        return {
            error: function(msg, o)   { _show('danger', msg, o); },
            info: function(msg, o)    { _show('info', msg, o); },
            success: function(msg, o) { _show('success', msg, o); },
            show: _show,
            hide: _hide,
            noHide: function() { if (timer) clearTimeout(timer); }
        };
    }()),
    form: function(formSelector, onSubmit, o)
    {
        o = $.extend({btn_loading:app.lang.form_btn_loading, onInit: $.noop, noEnterSubmit:false}, o||{});
        var $form, form, $btn, btnVal, inited = false, process = false;
        var classes = {input_error: 'input-error'};
        var self = {
            init: function(){
                if( inited ) return; inited = true;
                $form = $(formSelector);
                if( $form.length ) {
                    if(app.m) $form.append('<input type="hidden" name="hash" value="'+app.csrf_nonce+'" />');
                    form = $form.get(0);
                    $btn = $form.find('button.j-submit:last');
                    if(o.onInit) o.onInit.call(self, $form);
                    if(onSubmit && onSubmit!==false) {
                        $form.submit(function(e){
                            nothing(e);
                            if(self.isProcessing()) return;
                            onSubmit.call(self, $form);
                        });
                    }
                    // prevent enter submit
                    if (o.noEnterSubmit) {
                        $form.bind('keyup keypress', function(e) {
                            if ((e.keyCode || e.which) == 13 && ! $(e.target).is('textarea')) {
                                e.preventDefault();
                                return false;
                            }
                        });
                    }
                }
            },
            getForm: function(){ return $form; },
            processed: function(yes){ process = yes;
                if($btn && $btn.length) {
                    if(yes) { btnVal = $btn.val(); $btn.prop({disabled:true}).val(o.btn_loading);
                    } else { $btn.removeProp('disabled').val(btnVal); }
                }
            },
            isProcessing: function(){ return process; },
            field: function(name){ return form.elements[name]; },
            $field: function(name){ return $(form.elements[name]); },
            fieldStr: function(name){ return ( form.elements.hasOwnProperty(name) ? $.trim(form.elements[name].value) : '' ); },
            fieldError: function(fieldName, message, opts){
                opts = opts||{};
                if( ! opts.hasOwnProperty('title')) opts.title = app.lang.form_alert_errors;
                self.fieldsError([fieldName], [message], opts);
            },
            fieldsError: function(fieldsNames, message, opts){
                opts = $.extend({title:false,focus:true,scroll:false}, opts||{});
                self.fieldsResetError();
                var fields = [];
                for(var i in fieldsNames) {
                    if(form.elements.hasOwnProperty(fieldsNames[i])) {
                        fields.push(form.elements[fieldsNames[i]]);
                    }
                }
                var fieldFirst;
                if(fields.length > 0) { // mark fields
                    fieldFirst = fields[0];
                    app.fieldError(fields, true, false);
                }
                if(message) app.alert.error(message, {title:opts.title});
                if(fieldFirst) { // focus & scroll to first field
                    if(opts.scroll) $.scrollTo(fieldFirst, {offset: -150, duration: 500});
                    if(opts.focus) fieldFirst.focus();
                }
            },
            fieldsResetError: function(){ app.fieldError(form.elements, false); },
            checkRequired: function(opts){
                self.fieldsResetError();
                var fields = [];
                $('.j-required:visible,.j-required[type="hidden"]', form).each(function(){
                    var $this = $(this), empty;
                    if( ! $this.is(':input') ) $this = $this.find(':input:visible:first');
                    if( $this.is(':checkbox') ) empty = ! $this.is(':checked');
                    else if( $this.is(':radio') ) {
                        empty = ( ! $form.find('input:radio[name="'+$this.attr('name')+'"]:checked').length );
                    } else {
                        empty = ( $this.val() == 0 || ! $.trim($this.val()).length );
                    }
                    if(empty) { fields.push( $this.attr('name') ); }
                });
                if( fields.length > 0 ) {
                    self.fieldsError(fields, app.lang.form_alert_required, $.extend({
                        focus: false,
                        title: app.lang.form_alert_errors
                    }, opts||{}));
                }
                return ( ! fields.length );
            },
            alertError: function(message, opts){
                app.alert.error(message, opts);
            },
            alertSuccess: function(message, o){
                o = $.extend({reset:false}, o||{});
                self.fieldsResetError();
                if(o.reset) self.reset();
                app.alert.success(message, o);
            },
            reset: function(){
                form.reset();
            },
            ajax: function(url, params, callback, $progress, opts){
                if(self.isProcessing()) return;
                bff.ajax(url, $form.serialize()+'&'+ $.param(params||{}), callback, function(p){
                    self.processed(p);
                    if($progress && $progress.length) $progress.toggle();
                }, opts);
            }
        };
        self.init();
        return self;
    },
    pay: function(form) { 
        $('#bffcity-pay').html( form ).find('form:first').submit();
    },
    showError: function($err, msg, success, scroll)
    {
        if(msg) {
            if($.isArray(msg)) {
                msg = msg.join('<br/>');
            } else if($.isPlainObject(msg)) {
                var res = []; for(var i in msg) res.push(msg[i]);
                msg = res.join('<br/>');
            }
            if(success) {
                $err.removeClass('error').addClass('success');
            } else {
                if($err.hasClass('success')) {
                    $err.removeClass('success').addClass('error');
                }
            }
            $err.html(msg).show();
        } else {
            $err.hide().html('').removeClass('success').addClass('error');
        }
        
        if(scroll === true) {
            $.scrollTo($err, {offset: -60, duration: 400});
        }        
    },
    fieldError: function(field, show, _focus)
    {
        if($.isArray(field))
        {
            $.each(field, function(i,v){
                app.fieldError(v, show, _focus);
            });
            return false;
        }        
        var $field = $(field);
        if($field.length) {
            var $group = $field.closest('.control-group');
            if(show!==false) {
                if(_focus!==false) $field.focus();
                if( $group.length ) $group.addClass('error');
                else if( $field.is(':not(textarea)') )
                    $field.parent().addClass('inp-error');
            } else {
                if( $group.length ) $group.removeClass('error');
                else $field.parent().removeClass('inp-error');
            }
        }
        return false;
    },
    fieldErrorForm: function(fields, form)
    {
        var eFields = new Array();
        for(var i in fields) {
            if(form.elements[fields[i]]) {
                eFields.push(form.elements[fields[i]]);
            }
        }
        if(eFields.length>0) {
            app.fieldError(eFields, true, false);
        }
    },
    fav: function(module, link, block)
    {
        link = $(link); if( ! link.length) return false;
        var id = intval( link.data('id') ); if(id<=0) return false;
        var counter = $('#hm-'+module+'-fav'); // header menu counter
        bff.ajax('/index.php?bff=ajax&s='+module+'&act=fav', {id:id,type:link.data('type'),hash:app.csrf_nonce}, function(data){
            if(data) {
                if(data.added) link.text('').removeClass('intofav').addClass('infav');
                else {
                    link.text('').removeClass('infav').addClass('intofav');
                    if(block && block.length) block.remove();
                }
                counter.text(data.n);
            }
        });
        return false;
    },
    map: function(container, center, callback, o)
    {
        return bff.map.init(container, center, callback, o);
    },
    socialAuthButtons: function($block, authURL, returnURL)
    {
        $block = $($block); if(!$block.length) return;
        var popup;

        function socialPopup(o)
        {
            o = $.extend({w: 450, h: 380}, o || {});
            if(popup !== undefined) popup.close();
            var centerWidth = ($(window).width() - o.w) / 2;
            var centerHeight = ($(window).height() - o.h) / 2;
            popup = window.open(authURL+ o.provider+'?ret='+encodeURIComponent(returnURL), "u_login_social_popup", "width=" + o.w + ",height=" + o.h + ",left=" + centerWidth + ",top=" + centerHeight + ",resizable=yes,scrollbars=no,toolbar=no,menubar=no,location=no,directories=no,status=yes");
            popup.focus();
            return false;
        }
        $('.j-u-login-social-btn', $block).on('click', function(e){ nothing(e);
            var meta = $(this).metadata();
            if( meta && meta.hasOwnProperty('provider') ) {
                socialPopup(meta);
            }
        });
    }
});

$(function(){
    
    app.init();

    // init main menu
//    var $menu = $('#header-main-menu');
//    var $menuSub = $('.nav-sub ul', $menu);
//    $('>ul.nav-top a', $menu).click(function(){
//        if($(this).hasClass('nosub')) return;
//        var li = $(this).parent();
//        li.siblings('.active').removeClass('active');
//        li.addClass('active');
//        $menuSub.hide().parent().show();
//        $menuSub.filter('.hm-'+$(this).attr('rel')).show();
//        return false;
//    });

    // double password
    function initDoublePassword(block, pass, open) {
        var fields = $([$(pass, block).get(0), $(open, block).get(0)]), block_changes = false, pass_vis = false;
        fields.bind('change focus blur keyup', function(e) { if (!block_changes) { block_changes = true; fields.not(e.target).val( $(e.target).val() ); block_changes = false; } }).filter(':visible').change();
        $('a.eye', block).click(function(e) { nothing(e); $(this).toggleClass('eye-active'); fields.toggle(); pass_vis = !pass_vis; });
        fields.each(function(){ if ($(this).val()) { $(this).trigger('change'); return false; } });
    }

    // login
    app.popup('login', '#popup-login', '#popup-login-link', { onInit: function($popup) 
    {
        //app.social.init($popup);
        initDoublePassword( $popup, 'input.type-password', 'input.type-password-mirror' );
        var $err = $('div.error', $popup), $progress = $('.progress', $popup), h = '';
        $('form:first', $popup).submit(function(){
            var f = this, lgn = $.trim(f.login.value), data = $(f).serialize();
            if(data == h) return false;
            app.fieldError([f.login, f.pass], false);
            if(lgn=='') { return app.fieldError(f.login); }
            if(lgn.indexOf('@')!==-1 && !bff.isEmail(lgn)) {
                app.showError($err, 'Email указан некорректно');
                return app.fieldError(f.login);
            }
            if(f.pass.value=='') {
                return app.fieldError( ( $(f.pass).is(':hidden') ? $(f).find('.j-ilovebots') : f.pass ) );
            }
            bff.ajax('/index.php?bff=ajax&s=users&act=login', (h=data), function(data, errors){
                if(data.res) {
                    data.status = intval(data.status);
                    if(data.status == 2) {
                        location.reload();
                    }
                    if(data.status == 1) {
                        f.reset(); h = '';
                        var p = app.popup('reg-confirm');
                        if(!p.isInited()) { p.getPopup().html(data.confirm_popup); }
                        p.show();
                    }
                } else {
                    app.showError($err, errors);
                    if(data.fields) app.fieldErrorForm(data.fields, f);
                }
            }, $progress);
            return false;
        });
    }, onShow: function($popup){
        $('[name="login"]', $popup).focus();
    } } );

    // register 
    app.popup('reg', '#popup-reg', '#popup-reg-link', { onInit: function($popup) {
        //app.social.init($popup);
        initDoublePassword( $popup, 'input.type-password', 'input.type-password-mirror' );
        var $err = $('div.error', $popup), $progress = $('.progress', $popup), h = '';
        var $captcha = $('div.captcha-img', $popup).html('<img src="'+app.root+'/captcha2.php?bg=ffffff" onclick="$(this).attr(\'src\', \''+app.root+'/captcha2.php?bg=ffffff&r=\'+Math.random(1))" alt="" title="обновить" />').find('img');
        $('form:first', $popup).submit(function(){
            var form = this, inputs = ['email', 'pass', 'captcha'], data = $(form).serialize();
            if(data == h) return false;
            app.fieldError([form.email, form.pass, form.captcha], false);
            var notall = false;
            for(var i in inputs)
            {
                var key = inputs[i];
                if( ! form.elements[key]) continue;
                var f = form.elements[key];
                if(key == 'pass' && $(f).is(':hidden')) f = $(form).find('.j-ilovebots');
                if($.trim(f.value)=='') {
                    if(!notall) {
                        app.showError($err, 'Все поля обязательны для заполнения');
                        notall = true;
                    }
                    app.fieldError(f, true, false);
                }
            }
            if(notall) return false;
            else if(!bff.isEmail($.trim(form.email.value))) {
                app.showError($err, 'Email указан некорректно');
                return app.fieldError(form.email);
            }
            if(form.agree && ! form.agree.checked) { form.agree.focus();
                app.showError($err, 'Ознакомтесь с пользовательским соглашением');
                return false;
            }
            bff.ajax('/index.php?bff=ajax&s=users&act=register', (h=data), function(data,errors){
                if(data.success) {
                    if(data.success) bff.redirect(app.url.register+'?success=1');
                    if(data.logined) bff.redirect('/');
                } else {
                    app.showError($err, errors);
                    if(data.fields) app.fieldErrorForm(data.fields, form);
                    if(data.captcha) $captcha.trigger('click');
                }
            }, $progress);
            return false;
        });
    }, onShow: function($popup) {
        $('[name="name"]', $popup).focus();
    } } );
    
    // register confirm
    app.popup('reg-confirm', '#popup-reg-confirm', false, { onInit: function($popup) 
    {                                        
        var $err = $('div.error', $popup), $progress = $('.progress', $popup), h = '', $b = $('input.submit', $popup), t = this;
        $('form:first', $popup).submit(function(){
            var f = this, email = $.trim(f.email.value), data = email;
            if(data == h) return false;
            app.fieldError(f.email, false);
            if(!bff.isEmail(email)) {
                app.showError($err, 'Email указан некорректно');
                return app.fieldError(f.email);
            }
            $b.prop('disabled', true).val('подождите...');
            bff.ajax('/index.php?bff=ajax&s=users&act=register-confirm', $(f).serialize(), function(data, errors){
                if(data.res) {
                    app.showError($err, false);
                    $(f).hide().prev().removeClass('displaynone'); // show success message
                    setTimeout(function(){ t.hide(); if(data.redirect) bff.redirect('/'); }, 1500);
                } else {
                    app.showError($err, errors);
                    if(data.fields) app.fieldErrorForm(data.fields, f);
                    $b.prop('disabled', false).val('отправить');
                }
            }, $progress);
            return false;
        });
    }, onShow: function($popup){
        $('[name="email"]', $popup).focus();
    } } );
    
    // city select popup (header)
    app.popupDropdown('city-header', '#popup-city-header', '#popup-city-header-link', { onInit: function($popup) 
    {
        $popup.find('a').click(function(e){
            var cityID = intval($(this).data('id'));
            bff.cookie(app.cookiePrefix+'geo', cityID, {expires: 500, domain:'.'+app.host, path:'/'});
            return true;
        });
    } } );
        
});