<?php
/**
 * Системные настройки
 */

$config = array(
    'site.host'   => 'example.com',
    'site.mobile.host' => 'm.example.com',
    'site.static' => 'http://example.com',
    'site.title'  => 'Example.com',
    /**
     * Доступ к базе данных
     */
    'db.type' => 'mysql', // варианты: pgsql, mysql
    'db.host' => 'localhost', // варианты: localhost, ...
    'db.port' => '3306', // варианты: pgsql - 5432, mysql - 3306
    'db.name' => 'name',
    'db.user' => 'user',
    'db.pass' => 'pass',
    'db.charset' => 'UTF8',
    'db.prefix' => 'bff_',
    /**
     * Настройки форума
     */
    'forum.type' => '', // тип форума, доступно: 'phpbb3', 'xenforo'
    'forum.xenforo.path' => '', // путь к директории форума xenforo
    'forum.db.type' => 'mysql', // варианты: pgsql, mysql
    'forum.db.host' => 'localhost', // варианты: localhost, ...
    'forum.db.port' => '3306', // варианты: pgsql - 5432, mysql - 3306
    'forum.db.name' => 'phpbb3',
    'forum.db.user' => 'user',
    'forum.db.pass' => 'pass',
    'forum.db.charset' => 'UTF8',
    'forum.db.prefix' => 'phpbb_',
    'forum.baseurl'   => '', // URL форума, например: http://example.com/forum/
    /**
     * Mail
     */
    'mail.support'  => 'support@example.com',
    'mail.noreply'  => 'noreply@example.com',
    'mail.admin'    => 'admin@example.com',
    'mail.fromname' => 'Example.com',
    'mail.method'   => 'mail', // варианты: mail, sendmail, smtp
    'mail.smtp' => array(
        'host'=>'localhost',
        'port'=>25,
        'user'=>'',
        'pass'=>'',
    ),
    /**
     * Локализация
     */
     'locale.available' => array( // список языков (используемых на сайте)
        // ключ языка => название языка
        'ru' => 'Русский',
        //'uk' => 'Украинский',
     ),
     'locale.default' => 'ru', // язык по-умолчанию
    /**
     * Настройки систем оплаты (bills)
     * Полный список доступных настроек указан в BillsModuleBase::init методе
     */
     'services.enabled' => true, # Платные услуги (true - включены, false - выключены)
     'bills.robox.test' => true,
     'bills.robox.login' => 'example.com',
     'bills.robox.pass1' => '',
     'bills.robox.pass2' => '',
     'bills.privat24.merchantid' => '',
     'bills.privat24.password' => '',
     # Geo
     'geo.regions.filter'  => false, // Доступна ли фильтрация контента в зависимости от указаного региона(города) в шапке
     'geo.default.country' => 1,     // ID страны по-умолчанию: Россия
     'geo.default.city'    => 3,     // ID города по-умолчанию: Курск
     'geo.maps.type'       => 'yandex', // Тип карт: yandex, google
     'geo.maps.googleKey'  => 'AIzaSyAmSmZmvRKxtpNGskKWizPWLNzwPIuQfQc', // API ключ для Google Карт
     'geo.maps.default.coords' => '55.7481,37.6206', // Центральная точка на карте по-умолчанию, http://dimik.github.io/ymaps/examples/location-tool/
     # Погода
     'services.weather.type' => 'hmn', // сервис предоставляющий данные, доступны: 'hmn'
     'services.weather.key' => '', // ключ доступа к сервису
     # ТВ-Программа
     'services.tv.type' => 'xmltv', // сервис предоставляющий данные, доступны: 'xmltv'
     'services.tv.key' => '',  // ключ доступа к сервису
     # Курсы валют
     'services.business.curr.type' => 'cbr', // сервис предоставляющий данные, доступны: 'cbr'
     # Поиск по сайту "Yandex"
     'search.yandex.id' => 0, // ID сайта можно получить после добавления его на http://site.yandex.ru/
     # Премодерация объявлений
     'bbs.premoderation'    => true,
     'realty.premoderation' => true,
     'auto.premoderation'   => true,
     'job.premoderation'    => true,
     # Пользователи
     'users.register.captcha'   => true, // Captcha в форме регистрации (true - отображать, false - скрывать)
     'users.register.agreement' => true, // "Пользовательское соглашение" в форме регистрации (true - отображать, false - скрывать)
     'users.register.agreement.url' => '#', // Ссылка на страницу "Пользовательское соглашение"
     'users.profile.birthdate'  => true, // "Дата рождения" в профиле пользователя (true - отображать, false - скрывать)
     'users.notactive.delete.timeout' => 100, // Срок в днях, после которого выполняется удаление неактивированных аккаунтов
     # Debug
     'php.errors.reporting' => (E_ALL | E_STRICT), // | E_STRICT & ~E_NOTICE & ~E_WARNING);
     'php.errors.display'   => 0, // отображать ошибки (варианты: 1|0)
     'localhost' => false, // localhost (варианты: true|false)
     'debug' => true, // варинаты:true|false  - включить debug-режим, а также разрешать fordev-режим
    /**
     * Дополнительные настройки
     * ! Настоятельно не рекомендуется изменять после запуска проекта
     */
     'date.timezone' => 'Europe/Kiev', // часовой пояс, другие варианты: http://php.net/manual/en/timezones.php
     'cookie.prefix' => 'bff_', // cookie префикс
     'currency.default' => 1, // ID основной валюты
     'thumbnail.method' => 'gd', // Библиотека обработки изображений
     # Sphinx (если используется)
     'sphinx.enabled' => false, // варианты: true, false
     'sphinx.host'    => 'localhost',
     'sphinx.port'    => 9312,
     # Сессия
     'session.start.always' => false, // Стартовать ли сессию всегда(true), либо только после успешной авторизации(false)
     'users.activity.timeout' => 600, // Кол-во секунд, в течении которых пользователь считается "online"
);

# Переопределение настроек для Dev-версии:
if( ! empty($_SERVER['HTTP_HOST']) && strpos($_SERVER['HTTP_HOST'], 'example.dev') !== FALSE )
{
    $config = array_merge($config, array(
        'site.host' => 'example.dev',
        'site.mobile.host' => 'm.example.dev',
        'site.static' => 'http://example.dev',
        # db
        'db.host' => 'localhost',
        'db.port' => '3306',
        'db.name' => 'name',
        'db.user' => 'user',
        'db.pass' => 'pass',
        # forum
        'forum.type' => 'phpbb3',
        'forum.db.type' => 'mysql', // варианты: pgsql, mysql
        'forum.db.host' => 'localhost', // варианты: localhost, ...
        'forum.db.port' => '3306', // варианты: pgsql - 5432, mysql - 3306
        'forum.db.name' => 'phpbb3',
        'forum.db.user' => 'user',
        'forum.db.pass' => 'pass',
        'forum.db.charset' => 'UTF8',
        'forum.db.prefix' => 'phpbb_',
        'forum.baseurl'   => '', // URL форума, например: http://example.com/forum/
        # debug
        'php.errors.reporting' => -1, //all
        'php.errors.display' => 1,
        'debug' => true,
        # geo
        'geo.maps.type'      => 'yandex', // Тип карт
        'geo.maps.googleKey' => 'AIzaSyAmSmZmvRKxtpNGskKWizPWLNzwPIuQfQc', // API ключ для Google Карт
    ));
}


return $config;