<?php
# Формируем URL доступа к сервису xmltv.ru
$key = config::sys('services.tv.key');
if( empty($key) ) return;
$url = 'http://xmltv.ru/export/'.$key.'/index.xml';
$pathChannelsLogo = PATH_PUBLIC.'files/images/tv/channels/';
$pathEventsImages = PATH_PUBLIC.'files/images/tv/events/';

set_time_limit(0);
ignore_user_abort(true);

if (!isset($oDb)) {
    $oDb = bff::database();
}

if(bff::input()->get('start', TYPE_UINT)) {
    $oDb->exec('TRUNCATE '.TABLE_TV_EVENTS);
    $oDb->exec('TRUNCATE '.TABLE_TV_CHANNELS);
    $oDb->exec('TRUNCATE '.TABLE_TV_EVENTS_TYPES);
    foreach (glob($pathChannelsLogo.'*') as $filename) {
        if(is_file($filename)) {
            unlink($filename);
        }
    }
    foreach (glob($pathEventsImages.'*') as $filename) {
        if(is_file($filename)) {
            unlink($filename);
        }
        if(is_dir($filename)){
            array_map('unlink', glob($filename.DS.'*'));
            rmdir($filename);
        }
    }
}

function getXML($url)
{
    $ch = curl_init();
    if( !$ch ) return '';
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER,true);
    $sContent = curl_exec($ch);
    curl_close($ch);
    $sContent = str_replace('&', '&amp;', $sContent);

    return new \SimpleXMLElement($sContent);
}

$getLogo = function(& $aChanel, $url) use ($oDb, $pathChannelsLogo)
{
    $fileContent = file_get_contents($url);
    if ($fileContent === false) return;

    $aImg = getimagesizefromstring($fileContent);
    if ($aImg === false) return;

    $sExt = image_type_to_extension($aImg[2]);
    if ($sExt == '.jpeg'){
        $sExt = '.jpg';
    }
    do {
        $sLogoFilename = func::generator(5) . $sExt;
    } while (file_exists($pathChannelsLogo.$sLogoFilename));
    if (file_put_contents($pathChannelsLogo.$sLogoFilename, $fileContent, LOCK_EX)) {
        $oDb->update(TABLE_TV_CHANNELS, array(
            'logo' => $sLogoFilename,
        ), array('id' => $aChanel['id']));
        $aChanel['logo'] = $sLogoFilename;
    }
};

$getImage = function($sPath, $url)
{
    $fileContent = file_get_contents($url);
    if ($fileContent === false) {
        return false;
    }

    $aImg = getimagesizefromstring($fileContent);
    if ($aImg === false) return false;

    $sExt = image_type_to_extension($aImg[2]);
    if ($sExt == '.jpeg') {
        $sExt = '.jpg';
    }
    do {
        $sFilename = func::generator(16) . $sExt;
    } while (file_exists($sPath . $sFilename));
    if (file_put_contents($sPath . $sFilename, $fileContent, LOCK_EX)) {
        return $sFilename;
    }
};

$getCategory = function($sTitle) use ($oDb)
{
    static $aCategories = false;
    if (!$aCategories) {
        $aCategories = $oDb->select_key('SELECT * FROM '.TABLE_TV_EVENTS_TYPES, 'id');
    }
    foreach ($aCategories as $v) {
        if ($v['title'] == $sTitle) {
            return $v['id'];
        }
    }
    $aInsert = array(
        'title' => $sTitle,
        'num'   => (int)$oDb->one_data('SELECT MAX(num) FROM '.TABLE_TV_EVENTS_TYPES) + 1,
    );
    $nCatID = $oDb->insert(TABLE_TV_EVENTS_TYPES, $aInsert, 'id');

    $aInsert['id'] = $nCatID;
    $aCategories[$nCatID] = $aInsert;
    return $nCatID;
};

$aTypes = $oDb->select_key('SELECT * FROM '.TABLE_TV_EVENTS_TYPES, 'title');

$getChannel = function ($aXMLFile, & $aChanel) use ($oDb, $getLogo, $aTypes, $pathEventsImages, $getImage, $getCategory)
{
    $xmlProgram = getXML($aXMLFile->Name);
    if (empty($aChanel['logo'])) {
        if ( isset($xmlProgram->channel->icon) && ! empty($xmlProgram->channel->icon->attributes()->src)) {
            $getLogo($aChanel, strval($xmlProgram->channel->icon->attributes()->src));
        }
    }
    $sPathEventsImages = $pathEventsImages.$aChanel['id'];
    if ( ! file_exists($sPathEventsImages)) {
        \bff\utils\Files::makeDir($sPathEventsImages);
    }
    $sPathEventsImages .= DS;
    foreach ($xmlProgram->programme as $p)
    {
        $aInsert = array();
        $aInsert['channel_id'] = $aChanel['id'];
        $aInsert['title'] = strval($p->title);
        $aInsert['type_title'] = '';
        $aInsert['description'] = strval($p->desc);
        $aInsert['event_date'] = strval($p->date);
        $t = substr(strval($p->attributes()->start), 8, 4);
        $aInsert['time_from'] = substr($t, 0, 2).':'.substr($t, 2, 2);
        $t = substr(strval($p->attributes()->stop), 8, 4);
        $aInsert['time_to'] = substr($t, 0, 2).':'.substr($t, 2, 2);
        $aInsert['playing'] = date('Y-m-d H:i:s', strtotime(substr(strval($p->attributes()->start), 0, 14)));
        $aHumans = array();
        if (isset($p->credits)) {
            foreach ($p->credits->children() as $v) {
                $aHumans[strval($v->getName())][] = strval($v);
            }
        }
        $aInsert['humans'] = serialize($aHumans);
        $aImages = array();
        $aImgUrls = array();
        foreach ($p->icon as $i)
        {
            $url = strval($i->attributes()->src);
            $aImgUrls[] = $url;
            $sFileName = $getImage($sPathEventsImages, $url);
            if ($sFileName) {
                $aImages[] = $sFileName;
            }
        }
        if ( ! empty($aImages)) {
            $aInsert['images'] = join(',', $aImages);
        }
        if ( ! empty($aImgUrls)) {
            $aInsert['img_url'] = serialize($aImgUrls);
        }
        $aCategories = array();
        foreach ($p->category as $c)
        {
            $t = strval($c);
            $aCategories[] = $getCategory($t);
            if ( ! empty($aInsert['type_title'])) {
                $aInsert['type_title'] .= ', ';
            }
            $aInsert['type_title'] .= $t;
        }
        $aInsert['types'] = join(',', $aCategories);
        $aInsert['type_id'] = $aCategories[0];
        $oDb->insert(TABLE_TV_EVENTS, $aInsert);
    }

    unset($xmlProgram);
    $aChanel['lastday_date'] = strval($aXMLFile->EfirWeek);
    $oDb->update(TABLE_TV_CHANNELS, array('lastday_date' => $aChanel['lastday_date']), array('id' => $aChanel['id']));
};

$xmlBase = getXML($url);

$aChannels = $oDb->select_key('SELECT * FROM '.TABLE_TV_CHANNELS, 'channelid');
$nChannelsNum = (int)$oDb->one_data('SELECT MAX(num) FROM '.TABLE_TV_CHANNELS) + 1;

foreach ($xmlBase->File as $f) {
    $sChanelID = strval($f->ChannelID);
    if ( ! isset($aChannels[$sChanelID])) {
        $aChannels[$sChanelID] = array(
            'channelid'    => $sChanelID,
            'title'        => strval($f->Channel),
            'num'          => $nChannelsNum++,
            'lastday_date' => '0000-00-00 00:00:00',
            'main'         => 1,
        );
        $aChannels[$sChanelID]['id'] = $oDb->insert(TABLE_TV_CHANNELS, $aChannels[$sChanelID]);
    }
    if (strtotime(strval($f->EfirWeek)) > strtotime($aChannels[$sChanelID]['lastday_date'])) {
        $getChannel($f, $aChannels[$sChanelID]);
    }
}

# удалим старые события

    $aFilter = array(':date' => array('event_date < :date', ':date' => date('Y-m-d', strtotime('-2weeks'))));
    $aFilter = Model::filter($aFilter);
    $nCount = (int)$oDb->one_data('SELECT COUNT(*) FROM ' . TABLE_TV_EVENTS . $aFilter['where'], $aFilter['bind']);
    if ($nCount) {
        $step = 100;
        for ($i = 0; $i <= $nCount; $i += $step) {
            $aData = $oDb->select('
            SELECT id, channel_id, images
            FROM ' . TABLE_TV_EVENTS .
                $aFilter['where'] . '
            ORDER BY id ' . $oDb->prepareLimit($i, $step),
                $aFilter['bind']);

            foreach ($aData as $k => $v) {
                $aImages = explode(',', $v['images']);
                $sPath = $pathEventsImages . $v['channel_id'] . DS;
                foreach ($aImages as $vv) {
                    if(empty($vv)) continue;
                    if (file_exists($sPath . $vv)) {
                        @unlink($sPath . $vv);
                    }
                }
            }
        }
        $aFilter['bind'][':empty'] = '';
        $oDb->exec('UPDATE '.TABLE_TV_EVENTS.' SET images = :empty'. $aFilter['where'], $aFilter['bind']);
    }
