<?php

class BBSItemImages extends CImagesUploaderTable
{
    /**
     * Константы размеров
     */
    const szMini     = 'm'; // mini  - preview в форме добавления/редактирования, список, блок похожих,
                            //         главная, кабинет пользователя, избранные, объявления компании
                            //         просмотр open graph, маленькое preview при просмотре
    const szSmall    = 's'; // small - VIP блок, большое preview при просмотре и печати
    const szView     = 'v'; // view  - просмотр фотографии (при просмотре и печати)
    const szOriginal = 'o'; // original - оригинальное (исходное) изображение

    function initSettings()
    {
        $this->path    = bff::path('board', 'images');
        $this->pathTmp = bff::path('tmp', 'images');
        $this->url     = bff::url('board', 'images');
        $this->urlTmp  = bff::url('tmp', 'images');

        $this->tableRecords = TABLE_BBS_ITEMS;
        $this->tableImages  = TABLE_BBS_ITEMS_IMAGES;

        $this->folderByID = true; // раскладываем файлы изображений по папкам (id(5)=>0, id(1005)=>1, ...)
        $this->filenameLetters = 8; // кол-во символов в названии файла
        $this->limit = 8; // лимит фотографий у объявления
        $this->maxSize = 2097152; // 2мб

        $this->minWidth  = 200;
        $this->minHeight = 200;
        $this->maxWidth  = 5000;
        $this->maxHeight = 5000;

        # настройки водяного знака
        $watermark = Site::i()->watermarkSettings();
        $watermarkSettings = array();
        if (!empty($watermark['file']['path'])) {
            $watermarkSettings = array(
                'watermark'       => true,
                'watermark_src'   => $watermark['file']['path'],
                'watermark_pos_x' => $watermark['pos_x'],
                'watermark_pos_y' => $watermark['pos_y'],
            );
        }

        # размеры изображений
        $this->sizes = array(
            self::szMini     => array('width'=>100, 'height'=>70),
            self::szSmall    => array('width'=>290, 'height'=>200),
            self::szView     => array('width'=>860, 'height'=>548, 'autofit_nocrop' => true) + $watermarkSettings,
            self::szOriginal => array('o'=>true), # оригинал
        );

        # размеры изображений, полный URL которых необходимо кешировать
        $this->sizesFav = array(
            # ключ размера => поле в базе
            self::szMini => 'img_'.self::szMini,
        );
    }

    function urlDefault($sSizePrefix)
    {
        return $this->url.'default-'.$sSizePrefix.'.gif';
    }

    /**
     * Получаем данные об изображениях указанных ID объявлений
     * @param array $aItemsID ID объявлений
     * @return array массив параметров изображений сформированных: array(itemID=>data, ...)
     */
    public function getItemsImagesData($aItemsID)
    {
        if (empty($aItemsID)) {
            return array();
        }
        if( ! is_array($aItemsID)) {
            $aItemsID = array($aItemsID);
        }
        $aData = $this->db->select('SELECT * FROM '.$this->tableImages.'
                    WHERE '.$this->fRecordID.' IN ('.join(',', $aItemsID).')
                    ORDER BY num');
        if( ! empty( $aData ) ) {
            $aData = func::array_transparent( $aData, $this->fRecordID, false );
        }
        return $aData;
    }

    public function processImagesView($nItemID)
    {
        if( ! $nItemID){ $this->errors->impossible(); return array(); }

        $aData = $this->getData();
        $aImages = array();

        $i = 1;
        foreach($aData as $v)
        {
            $aImages[] = array(
                'id' => $i,
                'i'  => $i-1,
                'comment' => '',
                'created' => tpl::date_format2($v['created']).'г.',
                'src'     => $this->getURL($v, self::szView, false),
            );
            $i++;
        }

        return array(
            'offset' => 0,
            'total'  => sizeof($aData),
            'photos' => $aImages,
        );
    }

}