<?php
    // status, moderated, publicated, publicated_to, publicated_order
    // svc, marked_to, premium_to,
    // blocked_reason
    $blocked = ($status == BBS::STATUS_BLOCKED);
?>

<script type="text/javascript">
var jItemStatus = (function(){
    var $form, $block, $progress, url = '<?= $this->adminLink('ajax&act=', 'bbs'); ?>';
    var $blocked_reason;
    var data = {id: <?= $id ?>, blocked: <?= ($blocked ? 1 : 0) ?>};
    $(function(){
        $block = $('#i_status_block');
        $progress = $block.find('#i_status_progress');
        $blocked_reason = $block.find('#i_blocked_reason');
    });

    return {
        approve: function(){
            bff.ajax(url+'item-approve', data, function(data){
                if(data && data.success) {
                   location.reload();
                }
            }, $progress);
        },
        unpublicate: function(){
            if( ! bff.confirm('sure')) return;
            bff.ajax(url+'item-unpublicate', data, function(data){
                if(data && data.success) {
                    location.reload();
                }
            }, $progress);
        },
        publicate2: function(step){
            var $block2 = $block.find('#i_publicate2');
            if(step==0) { // показываем форму продления
                if($block2.is(':visible')) {
                    // форма уже показана => публикуем
                    return jItemStatus.publicate2(1);
                } else {
                    $block2.show();
                }
            }
            else if(step==1) { //сохранить
                data['period'] = $block2.find('#i_publicate2_period').val();
                bff.ajax(url+'item-publicate2', data, function(data){
                    if(data && data.success) {
                       location.reload();
                    }
                }, $progress);
            }
            else if(step==2) { //отмена
                $block2.hide();
            }
            return false;
        },
        changeBlocked: function(step, block)
        {
            if(step==1){ //заблокировать / изменить блокировку
                $block.find('#i_blocked').hide();
                $block.find('#i_blocked_error, #i_blocking').show(0, function(){
                    $blocked_reason.focus();
                });
            } else if(step==2) { //отменить
                if(data.blocked == 1){
                    $block.find('#i_blocking').hide();
                    $block.find('#i_blocked').show();
                } else {
                    $block.find('#i_blocked_error').hide();
                }
            } else if(step==3) { //сохранить
                data.blocked_reason = $blocked_reason.val();
                bff.ajax(url+'item-block', data, function(res){
                    if(res && res.success)
                    {
                        data.blocked = res.blocked;
                        if( ! block) {
                            $block.find('#i_blocked_error').hide();
                        } else {
                            data.blocked_reason = res.reason;
                            $blocked_reason.val( res.reason );
                            $block.find('#i_blocked_text').html( res.reason );
                            $block.find('#i_blocked_error').show();
                            jItemStatus.changeBlocked(2);
                        }
                    }
                }, $progress);
            }
            return false;
        }
    };
}());
</script>

<div class="warnblock" id="i_status_block" style="padding:5px 0;">
    <div class="warnblock-content" style="padding: 10px;">
        <table class="admtbl tbledit">
            <tr class="row1">
                <td class="field-title" style="width:100px;">Статус:</td>
                <td><b><?
                    switch ($status) {
                        case BBS::STATUS_NOTACTIVATED: { echo 'Неактивировано'; } break;
                        case BBS::STATUS_PUBLICATED: { echo 'Публикуется'; } break;
                        case BBS::STATUS_PUBLICATED_OUT: { echo 'Период публикации завершился'; } break;
                        case BBS::STATUS_BLOCKED: { echo ($moderated == 0?'Ожидает проверки (было заблокировано)':'Заблокировано'); } break;
                    }
                ?></b> <div class="progress" style="margin: 8px 8px 0; display: none;" id="i_status_progress"></div></td>
            </tr>
            <? if($status != BBS::STATUS_NOTACTIVATED) { ?>
            <tr class="row1">
                <td class="field-title">Период публикации:</td>
                <td<? if($status == BBS::STATUS_PUBLICATED_OUT){ ?> class="desc" <? } ?>><b><?= tpl::date_format3($publicated, 'd.m.Y').' - '.tpl::date_format3($publicated_to, 'd.m.Y'); ?></b></td>
            </tr>
            <tr>
                <td class="row1" colspan="2">
                    <div class="warnblock <?= (!$blocked ? 'hidden':'') ?>" id="i_blocked_error">
                        <div class="warnblock-content error">
                            <div>Причина блокировки: <div class="right desc" id="i_blocked_reason_warn" style="display:none;"></div></div>
                            <div class="clear"></div>
                            <div id="i_blocked">
                                <span id="i_blocked_text"><?= (!empty($blocked_reason) ? $blocked_reason :'?') ?></span> - <a href="#" onclick="jItemStatus.changeBlocked(1,0); return false;" class="ajax desc">изменить</a>
                            </div>
                            <div id="i_blocking" style="display: none;">
                                <textarea name="blocked_reason" id="i_blocked_reason" class="autogrow" style="height:60px; min-height:60px;"><?= $blocked_reason; ?></textarea>
                                <a onclick="return jItemStatus.changeBlocked(3, 1);" class="ajax" href="#"><?= (!$blocked ? 'продолжить':'изменить причину') ?></a>&nbsp;&nbsp;<a onclick="return jItemStatus.changeBlocked(2);" class="ajax cancel" href="#">отмена</a>
                            </div>
                        </div>
                    </div>
                    <div class="hidden" id="i_publicate2" style="padding:10px; border: 1px solid #ccc; background-color: #FCF7F6;">
                        <table class="admtbl tbledit">
                            <tr class="row1">
                                <td>
                                    Выполнить продление публикации объявления до:<br /> <b>
                                        <?
                                        $nRefreshPeriod = $this->getItemRefreshPeriod(
                                            ( $status === BBS::STATUS_PUBLICATED ? $publicated_to : BFF_NOW )
                                        );
                                        echo tpl::date_format2($nRefreshPeriod, true);
                                        ?></b>
                                </td>
                            </tr>
                            <tr class="row1">
                                <td colspan="2">
                                    <a onclick="return jItemStatus.publicate2(2);" class="ajax cancel" href="#">отменить публикацию</a>
                                </td>
                            </tr>
                        </table>
                    </div>
                </td>
            </tr>
            <? if( $deleted ) { ?>
            <tr>
                <td></td>
                <td class="row1">
                   <span class="clr-error bold">Удалено пользователем</span>
                </td>
            </tr>
            <? } elseif( ! ($moderated && $blocked) ) { ?>
            <tr>
                <td class="row1" colspan="2">
                   <?
                   if($moderated == 0) { ?>
                        <input class="btn btn-small btn-success success button" type="button" onclick="jItemStatus.approve();" value="<?= ($blocked ? 'проверено, все впорядке' : 'проверено') ?>" />
                   <? } else {
                       if($status == BBS::STATUS_PUBLICATED_OUT) {
                            ?><input class="btn btn-small submit button" type="button" onclick="jItemStatus.publicate2(0);" value="опубликовать" /><?
                       } else if($status == BBS::STATUS_PUBLICATED) {
                            ?><input class="btn btn-small submit button" type="button" onclick="jItemStatus.unpublicate();" value="снять с публикации" /><?
                       }
                   }
                   if(!$blocked) { ?>
                       <input class="btn btn-small clr-error delete button" onclick="jItemStatus.changeBlocked(1); return false;" id="i_block_lnk" type="button" value="заблокировать" />
                   <? } ?>
                </td>
            </tr>
            <? } } ?>
        </table>
    </div>
</div>