<?php

$curr = Site::currencyDefault(false);
$aTypes = array(Bills::TYPE_IN_PAY      => _t('bills','пополнение счета'),
                Bills::TYPE_IN_GIFT     => _t('bills','подарок'),
                Bills::TYPE_OUT_SERVICE => _t('bills','оплата услуги'));

foreach($bills as $k=>$v)
{
    $bIn = ($v['type'] == Bills::TYPE_IN_PAY || $v['type'] == Bills::TYPE_IN_GIFT);
    $dateFull = tpl::date_format2($v['created']);
    $amountFull = ($bIn?'+':'-').tpl::declension($v['amount'], $curr['title_decl']);
?>
<div class="bh-row">
    <div class="bh-col bh_col1<?= ( $bIn ? ' green' : '') ?>"><?= $aTypes[$v['type']] ?></div>
    <div class="bh-col bh_col2"><?= tpl::date_format2($v['created']) ?></div>
    <? if( ! $v['amount'] && $v['svc_id'] == BBS::SERVICE_UP && ! $bIn) { ?>
        <div class="bh-col bh_col3">&mdash;</div>
    <? } else { ?>
        <div class="bh-col bh_col3"><?= $amountFull ?></div>
    <? } ?>
    <div class="bh-col bh_col4"><?= $v['description'] ?></div>
    <div class="clear"></div>
</div>
<?
}
if (empty($bills))
{ ?>
<div>
    <br /><?= _t('bills', 'Список операций по счету пустой') ?>
</div>
<? }