<?php

define('TABLE_BUSINESS_BANKS',       DB_PREFIX.'business_banks');
define('TABLE_BUSINESS_BANKS_DEPS',  DB_PREFIX.'business_banks_deps'); 
define('TABLE_BUSINESS_BANKS_MATS',  DB_PREFIX.'business_banks_mats');

abstract class BusinessBase extends Module
{
    /** @var BusinessModel */
    public $model = null;
    protected $securityKey = 'afa43906bfbbca89c9a2373d1debd1bb';

    function init()
    {
        parent::init();

        $this->module_title = 'Бизнес';
    }

    /**
     * Shortcut
     * @return Business
     */
    public static function i()
    {
        return bff::module('business');
    }

    /**
     * Shortcut
     * @return BusinessModel
     */
    public static function model()
    {
        return bff::model('business');
    }

    /**
     * Формирование URL
     * @param string $key ключ
     * @param mixed $opts доп. параметры
     * @param boolean $dynamic динамическая ссылка
     * @return string
     */
    public static function url($key, array $opts = array(), $dynamic = false)
    {
        $base = static::urlBase(LNG, $dynamic);
        switch ($key) {
            # Банки
            case 'banks':
                return $base . '/banks' . static::urlQuery($opts);
                break;
            # Курсы валют
            case 'rates':
                return $base . '/rates' . static::urlQuery($opts);
                break;
        }
    }

    /**
     * Описание seo шаблонов страниц
     * @return array
     */
    public function seoTemplates()
    {
        $aTemplates = array(
            'pages' => array(
                'banks' => array( // banks
                    't'      => 'Банки',
                    'macros' => array(
                        'region' => array('t' => 'Регион'),
                    ),
                    'fields' => array(
                        'titleh1' => array(
                            't'      => 'Заголовок H1',
                            'type'   => 'text',
                        ),
                    ),
                ),
                'rates' => array( // rates
                    't'      => 'Курсы валют',
                    'macros' => array(
                        'region' => array('t' => 'Регион'),
                    ),
                    'fields' => array(
                        'titleh1' => array(
                            't'      => 'Заголовок H1',
                            'type'   => 'text',
                        ),
                    ),
                ),
            ),
        );

        return $aTemplates;
    }

    public function getRates()
    {
        return func::unserialize(config::get('business_curr', ''));
    }

    public function getRatesHeader()
    {
        $aResult = array(
            'USD' => array('icon'=>'&#36;', 'rate'=>0, 'diff'=>0),
            'EUR' => array('icon'=>'&#8364;', 'rate'=>0, 'diff'=>0),
        );
        do {
            $sServiceType = config::sys('services.business.curr.type');
            if( empty($sServiceType) )
                break;

            $aData = $this->getRates();
            if( empty($aData) || empty($aData['rates']) )
                break;

            switch ($sServiceType)
            {
                case 'cbr': {
                    foreach($aResult as $k=>$v) {
                        if( ! isset($aData['rates'][$k]) ) continue;
                        $curr = $aData['rates'][$k];
                        $aResult[$k]['rate'] = $curr['value'];
                        $aResult[$k]['diff'] = $curr['diff'];
                    }
                } break;
                case 'financeua': {
                    foreach($aResult as $k=>$v) {
                        if( ! isset($aData['rates'][$k]) ) continue;
                        $curr = $aData['rates'][$k];
                        $aResult[$k]['buy'] = $curr['buy'];
                        $aResult[$k]['sell'] = $curr['sell'];
                    }
                } break;
                default: {
                    break 1;
                }
            }

            return $aResult;
        } while(false);
        return array();
    }
    
}