<?php

class Business extends BusinessBase
{
    /**
     * Банки
     * URL: /business/banks
     */
    public function banks()
    {
        if (Request::isAJAX())
        {
            $aResponse = array();
            switch ($this->input->post('act'))
            {
                case 'bank-markers':
                {
                    $nBankID = $this->input->post('id', TYPE_UINT);
                    if ( ! $nBankID) {
                        $this->errors->impossible(); break;
                    }
                    # данные о банке
                    $aResponse['b'] = $this->db->one_array('SELECT item_id as main FROM '.TABLE_BUSINESS_BANKS.' WHERE id = :bankId', array(':bankId'=>$nBankID));
                    # данные об отделениях
                    $aResponse['d'] = $this->db->select('
                        SELECT I.id, I.link, IL.title as t, I.vip, A.address as a, A.phonesq as p, A.lat, A.lng, A.city_id as c, A.site as s
                        FROM '.TABLE_BUSINESS_BANKS_DEPS.' D,
                             '.TABLE_ITEMS.' I,
                             '.TABLE_ITEMS_LANG.' IL,
                             '.TABLE_ITEMS_ADDR.' A
                        WHERE D.bank_id = :bankId
                          AND D.item_id = I.id
                          AND D.item_id = A.item_id'.
                          $this->db->langAnd(true, 'I', 'IL'),
                        array(':bankId'=>$nBankID));
                    if ( ! empty($aResponse['d'])) {
                        foreach ($aResponse['d'] as &$v) {
                            $v['c'] = Geo::regionTitle($v['c']);
                            $v['url'] = Items::url('view', $v['link']);
                            $v['sl'] = bff::urlAway($v['s']);
                        } unset($v);
                    }
                    # данные о банкоматах
                    $aResponse['m'] = $this->db->select('
                        SELECT I.id, I.link, IL.title as t, I.vip, A.address as a, A.phonesq as p, A.lat, A.lng, A.city_id as c, A.site as s
                        FROM '.TABLE_BUSINESS_BANKS_MATS.' M,
                             '.TABLE_ITEMS.' I,
                             '.TABLE_ITEMS_LANG.' IL,
                             '.TABLE_ITEMS_ADDR.' A
                        WHERE M.bank_id = :bankId
                          AND M.item_id = I.id
                          AND M.item_id = A.item_id'.
                          $this->db->langAnd(true, 'I', 'IL'),
                        array(':bankId'=>$nBankID));
                    if ( ! empty($aResponse['m'])) {
                        foreach ($aResponse['m'] as &$v) {
                            $v['c'] = Geo::regionTitle($v['c']);
                            $v['url'] = Items::url('view', $v['link']);
                            $v['sl'] = bff::urlAway($v['s']);
                        } unset($v);
                    }
                }
            }
            $this->ajaxResponseForm($aResponse);
        }

        $aData['banks'] = $this->db->select('
            SELECT I.vip, I.link, B.item_id as iid, B.id, B.title_'.LNG.' AS title, B.deps_cnt, B.mats_cnt,
                A.address as adr, A.lat, A.lng, A.city_id as c, A.phonesq as ph, A.site
            FROM '.TABLE_BUSINESS_BANKS.' B,
                 '.TABLE_ITEMS.' I,
                 '.TABLE_ITEMS_ADDR.' A
            WHERE B.enabled = 1 AND B.item_id = I.id
              AND I.id = A.item_id
              '.( $this->regionsFilterEnabled() ? ' AND A.city_id = '.Geo::cityID() : '' ).'
            ORDER BY B.num
        ');

        if ( ! empty($aData['banks'])) {
            foreach ($aData['banks'] as &$v) {
                $v['c'] = Geo::regionTitle($v['c']);
                $v['url'] = Items::url('view', $v['link']);
                $v['site_link'] = bff::urlAway($v['site']);
            } unset($v);
        } else {
            $aData['banks'] = array();
        }

        # SEO: Банки
        $this->urlCorrection(static::url('banks'));
        $this->seo()->canonicalUrl(static::url('banks', array(), true));
        $this->setMeta('banks', array('region' => Geo::filter('title')), $aData);

        bff::showRightblockBanner(false);
        bff::setActiveMenu('//business/banks');
        return $this->viewPHP($aData, 'banks');
    }

    /**
     * Курсы валют
     * URL: /business/rates
     */
    public function rates()
    {
        $aData = $this->getRates();

        # SEO: Курсы валют
        $this->urlCorrection(static::url('rates'));
        $this->seo()->canonicalUrl(static::url('rates', array(), true));
        $this->setMeta('rates', array('region' => Geo::filter('title')), $aData);

        bff::setActiveMenu('//business/rates');
        return $this->viewPHP($aData, 'rates');
    }

}