<?php
    Geo::mapsAPI();
    if (Geo::mapsType() == Geo::MAPS_TYPE_GOOGLE){
        tpl::includeJS('markerclusterer/markerclusterer', false);
    }
?>
<div class="h1-wrap">
    <h1><?= ( ! empty($titleh1) ? $titleh1 : _t('business', 'Банки города') ); ?></h1>
    <div class="relative mt20">
        <div class="bank-swich">
            <span class="displaynone red f12 left mt5" id="business-markers-nobank">&larr; <?= _t('business', 'Выберите банк'); ?></span>
            <div class="u-menu">
                <ul id="business-markers-togglers">
                    <li class="first active"><a href="#" onclick="return businessBanks.switchMarkersType('d',this);"><?= _t('business', 'Отделения'); ?></a></li>
                    <li><a href="#" onclick="return businessBanks.switchMarkersType('m',this);"><?= _t('business', 'Банкоматы'); ?></a></li>
                </ul>   
                <div class="clear"></div>
            </div>
        </div>
    </div>
    <div class="information">
            <div class="inform-nav" style="width: 330px;">
            <div class="map-items bank-items" id="business-banks-items">
               <? $n = 1;
                if(sizeof($banks)>0) {
                foreach($banks as $v) { ?>
                 <div class="item" rel="<?= $v['id'] ?>">
                    <div class="num"><?= $n ?></div> 
                    <div class="info">
                        <a href="<?= $v['url'] ?>" onclick="return businessBanks.showBankMarkers(<?= $v['id'] ?>,event);" class="title"><?= $v['title'] ?></a>
                        <br /><span class="address"><?= $v['c'].', '.$v['adr'] ?></span>
                        <? if(!empty($v['ph'])){ ?><br /><span class="address"><?= _t('', 'т.'); ?> <?= str_replace(', ', '<br />&nbsp;&nbsp;&nbsp;', $v['ph']) ?></span><? } ?>
                        <br /><span class="cat"><?= tpl::declension($v['deps_cnt'], explode(';', _t('business','отделение;отделения;отделений'))) ?></span>
                        <br /><span class="cat"><?= tpl::declension($v['mats_cnt'], explode(';', _t('business','банкомат;банкомата;банкоматов'))) ?></span>
                        <? if(!empty($v['site'])){ echo '<br /><a href="'.bff::urlAway($v['site']).'" target="_blank" rel="nofollow">'.$v['site'].'</a>'; } ?>
                    </div>
                    <div class="clear"></div>
                 </div>
                 <? $n++; }
                } else { ?>
                   <span><?= _t('business', 'Банков не найдено'); ?></span>
                <? } ?>
            </div>
        </div>
        <div class="inform-map relative">
            <div style="width: 695px; height:601px;" id="business-banks-map"></div>
        </div>
        <div class="clear"></div>
    </div>
</div>
<script type="text/javascript">
<? js::start(); ?>
var businessBanks = (function(){
    var $markersTogglers, mType = 'd', curBankID = 0, $items, $nobank;
    var $map, map, banksData = {}, mapClusterer = null, mapMarkers, mapInfoWindow;
    
    $(function(){
        $markersTogglers = $('#business-markers-togglers');
        $map = $('#business-banks-map');
        $items = $('#business-banks-items > .item');
        $nobank = $('#business-markers-nobank');

        map = app.map($map.get(0), '<?= HTML::escape(Geo::mapsDefaultCoords(), 'js'); ?>', function(_map)
        {
            // show banks main deps
            var items = <?= func::php2js($banks); ?>;
            var itemsToCluster = [];
            mapMarkers = {};
            if (this.isYandex())
            {
                mapClusterer = new ymaps.Clusterer({
                    preset: 'islands#blueClusterIcons',
                    clusterBalloonContentLayoutWidth: 400,
                    clusterBalloonContentLayoutHeight: 150,
                    clusterBalloonLeftColumnWidth:50,
                    clusterDisableClickZoom: false,
                    clusterBalloonItemContentLayout: ymaps.templateLayoutFactory.createClass('<div class="ballon-body">{{ properties.balloonContentBody|raw }}</div>'),
                    zoomMargin: 15
                });

                mapClusterer.removeAll();
                _map.geoObjects.remove(mapClusterer);

                for(var i in items){
                    var v = items[i];
                    var n = (intval(i)+1);
                    var balloonHtml='<div style="text-align: left !important;">\
                                     <a href="'+v.url+'"><b>'+v.title+'</b></a><br />\
                                     <div>'+v.c+', '+v.adr+'</div>\
                                     '+(v.site ? '<div><a href="'+v.site_link+'" target="_blank" rel="nofollow">'+v.site+'</a></div>' : '')+'\
                                     <div>'+v.ph+'</div>\
                                     <span class="grey"><a class="grey" href="'+v.url+'"><?= _t('', 'Подробнее'); ?></a> &rarr;</span>\
                                   </div>';

                    itemsToCluster[i] = new ymaps.Placemark([parseFloat(v.lat),parseFloat(v.lng)], {
                        iconContent: n,
                        clusterCaption: n,
                        balloonContentBody: balloonHtml
                    }, {preset: (v.vip==1 ? 'islands#redIcon' : 'islands#blueIcon')});
                }
                if(itemsToCluster.length){
                    mapClusterer.add(itemsToCluster);
                    _map.geoObjects.add(mapClusterer);
                    if(itemsToCluster.length > 1) {
                        var pos = ymaps.util.bounds.getCenterAndZoom(
                            mapClusterer.getBounds(), _map.container.getSize(), _map.options.get('projection')
                        );
                        _map.setCenter(pos.center, pos.zoom);
                    } else {
                        if (itemsToCluster.length) {
                            _map.setCenter(itemsToCluster[0].geometry.getCoordinates());
                        }
                    }
                }
                _map.container.fitToViewport();
                mapClusterer.events.once('objectsaddtomap', function(){
                    _map.setBounds(mapClusterer.getBounds(), {checkZoomRange: true});
                });
            } else if (this.isGoogle()) {
                if (mapClusterer) {
                    mapClusterer.clearMarkers();
                }
                mapInfoWindow = new google.maps.InfoWindow({maxWidth:300});

                for(var i in items) {
                    var v = items[i];
                    var id = intval(v.id);
                    var marker = new google.maps.Marker({
                        position: new google.maps.LatLng(parseFloat(v.lat),parseFloat(v.lng))
                    });
                    marker.itemID = id;
                    mapMarkers[id] = {
                        position: marker.getPosition(),
                        balloon: '<div style="text-align: left !important;">'+
                            '<a href="'+v.url+'">'+v.title+'</a><br />'+
                            '<div>'+v.c+', '+v.adr+'</div>'+
                            (v.site ? '<div><a href="'+v.site_link+'" target="_blank" rel="nofollow">'+v.site+'</a></div>' : '') +
                            '<div>'+v.ph+'</div>'+
                            '<span class="grey"><a class="grey" href="'+v.url+'"><?= _t('', 'Подробнее'); ?></a> &rarr;</span>'+
                        '</div>'
                    };
                    itemsToCluster.push(marker);
                    google.maps.event.addListener(marker, 'click', function() {
                        businessBanks.popupMarker(this.itemID, true);
                    });
                }

                mapClusterer = new MarkerClusterer(_map, itemsToCluster, {
                    imagePath: '<?= SITEURL_STATIC ?>/js/markerclusterer/images/m'
                });
                if (itemsToCluster.length > 1) {
                    mapClusterer.fitMapToMarkers();
                } else if (itemsToCluster.length == 1 && mapMarkers.hasOwnProperty(id)) {
                    _map.setCenter(mapMarkers[id].position);
                }
                mapClusterer.fitMapToMarkers();
            }

            $items.click(function(e){
                var t = $(e.target);
                if(t.length && !t.is('a')) {
                    businessBanks.showBankMarkers( intval($(this).attr('rel')), e);
                    return false;
                }
            });

        }, {controls:'search', zoom:13});
    });

    function mapBalloonOpenY(point)
    {
        var state = mapClusterer.getObjectState(point),
            cluster = state.isClustered && state.cluster;
        if(cluster) {
            cluster.state.set('activeObject', point);
            mapClusterer.balloon.open(state.cluster);
        } else {
            if( ! point.balloon.isOpen() ) point.balloon.open();
        }
    }

    function showMarkers(bankID, focusMain)
    {
        $nobank.hide();
        $items.removeClass('item-active').filter('[rel="'+bankID+'"]').addClass('item-active');
        var _map = map.getMap();

        if ( ! banksData.hasOwnProperty(bankID) || ! banksData[bankID].hasOwnProperty(mType)) {
            return;
        }
        var items = banksData[bankID][mType];
        var itemsToCluster = [];
        mapMarkers = {};

        if (map.isYandex())
        {
            mapClusterer.removeAll();
            _map.geoObjects.remove(mapClusterer);

            for(var i in items) {
                var v = items[i];
                var n = (intval(i)+1);
                var balloonHtml = '<div style="text-align: left !important;">\
                                     <a href="'+v.url+'"><b>'+v.t+'</b></a><br />\
                                     <div>'+v.c+', '+v.a+'</div>\
                                     '+(v.s ? '<div><a href="'+v.sl+'" target="_blank" rel="nofollow">'+v.s+'</a></div>' : '')+'\
                                     <div>'+v.p+'</div>\
                                     <span class="grey"><a class="grey" href="'+v.url+'"><?= _t('', 'Подробнее'); ?></a> &rarr;</span>\
                                    </div>';

                mapMarkers[intval(v.id)] = itemsToCluster[i] = new ymaps.Placemark([parseFloat(v.lat),parseFloat(v.lng)], {
                    clusterCaption: n,
                    balloonContentBody: balloonHtml
                }, {preset: (v.vip==1 ? 'islands#redIcon' : 'islands#blueIcon')});
            }

            if (itemsToCluster.length) {
                mapClusterer.add(itemsToCluster);
                _map.geoObjects.add(mapClusterer);
                if(itemsToCluster.length > 1) {
                    var pos = ymaps.util.bounds.getCenterAndZoom(
                        mapClusterer.getBounds(), _map.container.getSize(), _map.options.get('projection')
                    );
                    _map.setCenter(pos.center, pos.zoom);
                } else {
                    _map.setCenter(itemsToCluster[0].geometry.getCoordinates());
                }
                mapClusterer.events.once('objectsaddtomap', function () {
                    _map.setBounds(mapClusterer.getBounds(), {checkZoomRange: true});
                });
            }

            if (focusMain && mType == 'd') {
                var main = intval(banksData[bankID].b.main);
                if (mapMarkers.hasOwnProperty(main)) {
                    setTimeout(function(){
                        var itemPoint = mapMarkers[main];
                        var state = mapClusterer.getObjectState(itemPoint), cluster = state.cluster;
                        if((itemPoint.getMap() || (cluster && cluster.getMap()))) {
                            mapBalloonOpenY(itemPoint);
                        } else {
                            map.panTo(itemPoint.geometry.getCoordinates(), {duration:400, delay:0, callback:function(){
                                mapClusterer.events.once('objectsaddtomap', function(){
                                    mapBalloonOpenY(itemPoint);
                                });
                            }});
                        }
                    }, 200);
                }
            }
        }
        else if (map.isGoogle())
        {
            if (mapClusterer) {
                mapClusterer.clearMarkers();
            }
            mapInfoWindow.close();

            for(var i in items) {
                var v = items[i];
                var id = intval(v.id);
                var marker = new google.maps.Marker({
                    position: new google.maps.LatLng(parseFloat(v.lat),parseFloat(v.lng))
                });
                marker.itemID = id;
                mapMarkers[id] = {
                    position: marker.getPosition(),
                    balloon: '<div style="text-align: left !important;">'+
                         '<a href="'+v.url+'"><b>'+v.t+'</b></a><br />'+
                         '<div>'+v.c+', '+v.a+'</div>'+
                         (v.s ? '<div><a href="'+v.sl+'" target="_blank" rel="nofollow">'+v.s+'</a></div>' : '')+
                         '<div>'+v.p+'</div>'+
                         '<span class="grey"><a class="grey" href="'+v.url+'"><?= _t('', 'Подробнее'); ?></a> &rarr;</span>'+
                        '</div>'
                };
                itemsToCluster.push(marker);
                google.maps.event.addListener(marker, 'click', function() {
                    businessBanks.popupMarker(this.itemID, true);
                });
            }

            mapClusterer = new MarkerClusterer(_map, itemsToCluster, {
                imagePath: '<?= SITEURL_STATIC ?>/js/markerclusterer/images/m'
            });
            if (itemsToCluster.length > 1) {
                mapClusterer.fitMapToMarkers();
            } else if (itemsToCluster.length == 1 && mapMarkers.hasOwnProperty(id)) {
                _map.setCenter(mapMarkers[id].position);
            }
            if (focusMain && mType == 'd') {
                var main = intval(banksData[bankID].b.main);
                if (mapMarkers.hasOwnProperty(main)) {
                    businessBanks.popupMarker(main, false);
                }
            }
        }
    }
    
    return {
        showBankMarkers: function(bankID, event)
        {
            nothing(event);
            if(bankID == curBankID) return false;
            curBankID = bankID;
            
            if (banksData.hasOwnProperty(bankID)) {
                showMarkers(bankID, true);
            } else {
                bff.ajax('<?= Business::url('banks') ?>', {act: 'bank-markers', id: bankID}, function(data){
                    if(data && data.success) {
                        banksData[bankID] = data;
                        showMarkers(bankID, true);
                    }
                });
            }
            return false;
        },
        switchMarkersType: function(type,link)
        {
            if(curBankID == 0) {
                $nobank.show();
                return false;
            }
            if(mType!=type) {
                mType = type;
                $(link).parent().addClass('active').siblings().removeClass('active');
                showMarkers(curBankID, false);
            }
            
            return false;
        },
        popupMarker: function(itemID, markerClick)
        {
            if (map.isGoogle()) {
                if (mapMarkers.hasOwnProperty(itemID)) {
                    var m = mapMarkers[itemID];
                    if (markerClick!==true) {
                        map.getMap().panTo(m.position);
                    }
                    mapInfoWindow.close();
                    mapInfoWindow.setPosition(m.position);
                    mapInfoWindow.setContent(m.balloon);
                    mapInfoWindow.open(map.getMap());
                }
            }
            return false;
        }
    }
}());
<? js::stop(); ?>
</script>