<?php

/**
 * Права доступа группы:
 *  - items: Справочник
 *      - items-listing: Просмотр списка объектов
 *      - items-edit: Добавление/Редактирование/Модерация объектов
 *      - items-delete: Удаление объектов
 *      - agents: Представители
 *      - opinions: Отзывы
 *      - claims: Жалобы
 *      - settings: Настройки (категории)
 *      - svc: Услуги
 */
class Items extends ItemsBase
{
    function main()
    {
        return $this->items_listing();
    }

    # ------------------------------------------------------------------------------------------
    # объекты

    function items_listing()
    {
        if (!$this->haveAccessTo('items-listing')) {
            return $this->showAccessDenied();
        }



        $aData = array('filter' => array(), 'items' => array());
        $aFilter = & $aData['filter'];

        $this->input->postgetm(array(
                'category' => TYPE_UINT,
                'uid'      => TYPE_UINT,
                'city'     => TYPE_UINT,
                'title'    => TYPE_STR,
                'status'   => TYPE_UINT,
                'mod'      => TYPE_BOOL,
                'agent'    => TYPE_UINT,
            ), $aFilter
        );

        # prepare order
        $aData['order'] = array('id' => 'asc', 'title' => 'asc', 'modified' => 'desc');
        $aData = array_merge($aData, $this->prepareOrder($orderBy, $orderDirection, 'modified-desc', $aData['order']));

        $sqlSelect = array();
        $sqlWhere = $sqlJoin = '';
        $sqlGroupByID = false;
        $bRotate = false;

        if ($aFilter['category'] > 0) {
            $aSubcatsID = $this->db->select_one_column('SELECT id FROM ' . TABLE_ITEMS_CATEGORIES . ' WHERE pid = ' . $aFilter['category']);
            if (!empty($aSubcatsID)) {
                $sqlJoin .= ' INNER JOIN ' . TABLE_ITEMS_IN_CATEGORIES . ' IC ON IC.item_id = I.id AND ' . $this->db->prepareIN('IC.category_id', $aSubcatsID);
                $sqlGroupByID = true;
            } else {
                $sqlJoin .= ' INNER JOIN ' . TABLE_ITEMS_IN_CATEGORIES . ' IC ON IC.item_id = I.id AND IC.category_id = ' . $aFilter['category'];
                $bRotate = true;
            }
        }
        if ($aFilter['city'] > 0) {
            $sqlJoin .= ' INNER JOIN ' . TABLE_ITEMS_ADDR . ' IA ON IA.item_id = I.id AND IA.city_id = ' . $aFilter['city'];
        } else {
            if ($this->regionsFilterEnabled()) {
                $bRotate = false;
            }
        }
        if ($aFilter['mod']) {
            $bRotate = false;
        }

        $act = $this->input->postget('act', TYPE_STR);
        if (Request::isAJAX() || !empty($act)) {
            switch ($act) {
                case 'rotate': {
                    if ($bRotate) {
                        $sTable = TABLE_ITEMS_IN_CATEGORIES . ' I ';
                        $sAddQuery = ' AND I.category_id = ' . $aFilter['category'];
                        if ($this->regionsFilterEnabled()) {
                            $sTable .= ' INNER JOIN ' . TABLE_ITEMS_ADDR . ' IA ON IA.item_id = I.item_id AND IA.city_id = ' . $aFilter['city'];
                        }
                        if ($this->db->rotateTablednd($sTable, $sAddQuery, 'I.item_id', 'num_order')) {
                            $this->ajaxResponse(Errors::SUCCESS);
                        }
                    }
                    $this->ajaxResponse(Errors::IMPOSSIBLE);
                } break;
                case 'items-links-rebuild':
                {
                    $this->model->itemsLinksRebuild();

                    $this->adminRedirect(Errors::SUCCESS, bff::$event);
                } break;
                case 'items-images-recrop':
                {
                    if (FORDEV) {
                        set_time_limit(0);
                        $this->db->select_rows_chunked(TABLE_ITEMS, array('id'), array(), 'id', array(), function($items){
                            $images = Items::i()->initImages(0);
                            foreach ($items as $v) {
                                $images->setRecordID($v['id']);
                                $images->recropImages(ItemsImages::szOriginal);
                            }
                        });
                        if ( ! $this->errors->no()) {
                            echo '<pre>', print_r($this->errors->get(1,0), true), '</pre>'; exit;
                        }
                    }

                    $this->adminRedirect(Errors::SUCCESS, bff::$event);
                } break;
                case 'items-delete-all':
                {
                    if (FORDEV) {
                        set_time_limit(0);
                        $this->db->select_rows_chunked(TABLE_ITEMS, array('id'), array(), 'id', array(), function($items){
                            foreach ($items as $v) {
                                Items::i()->itemDelete($v['id']);
                            }
                        });
                        if ( ! $this->errors->no()) {
                            echo '<pre>', print_r($this->errors->get(1,0), true), '</pre>'; exit;
                        } else {
                            config::save('items_agents', 0, true);
                            $this->db->update(TABLE_USERS_STAT, array('items'=>0,'items_requests'=>0));
                        }
                    }

                    $this->adminRedirect(Errors::SUCCESS, bff::$event);
                } break;
            }
        }


        if ($aFilter['uid'] > 0) {
            $sqlWhere .= ' AND I.user_id = ' . $aFilter['uid'];
        } else {
            if ($aFilter['agent'] > 0) {
                $sqlWhere .= ' AND I.agent_id = ' . $aFilter['agent'];
            }
        }

        $sqlWhere .= ' AND I.moderated ' . ($aFilter['mod'] > 0 ? '!=1' : '=1');

        if (!empty($aFilter['title'])) {
            if (intval($aFilter['title']) > 0) {
                $sqlWhere .= ' AND I.id = ' . intval($aFilter['title']);
            } else {
                $sqlWhere .= ' AND IL.title LIKE ' . $this->db->str2sql('%' . $aFilter['title'] . '%');
            }
        }
        $sqlJoin .= ', ' . TABLE_ITEMS_LANG . ' IL ';
        $sqlWhere .= $this->db->langAnd(true, 'I', 'IL');

        # generate pagenation
        $nLimit = 20;
        if ($sqlGroupByID) {
            $nCount = sizeof($this->db->select_one_column('SELECT COUNT(I.id)
                            FROM ' . TABLE_ITEMS . ' I ' . $sqlJoin . '
                            WHERE 1' . $sqlWhere . ' GROUP BY I.id '
                )
            );
        } else {
            $nCount = (integer)$this->db->one_data('SELECT COUNT(I.id)
                            FROM ' . TABLE_ITEMS . ' I ' . $sqlJoin . '
                            WHERE 1' . $sqlWhere
            );
        }
        if ($bRotate || $nCount < 50) {
            $nLimit = $nCount;
        }

        $aData['pages'] = $this->generatePagenation($nCount, $nLimit, 'ifilter.doPage({pageId})',
            $sqlLimit, 'pagenation.items.ajax.tpl', 'page', true
        );


        if ($bRotate) {
            $orderBy = 'IC.num_order';
            $orderDirection = 'ASC';
        }
        # получаем объекты
        $aData['items'] = ($nCount > 0 ? $this->db->select('
                   SELECT I.id, I.link, IL.title, I.modified, I.moderated, I.opinions, I.enabled, I.imgcnt ' . (!empty($sqlSelect) ? ',' . join(',', $sqlSelect) : '') . '
                   FROM ' . TABLE_ITEMS . ' I ' . $sqlJoin . '
                   WHERE 1 ' . $sqlWhere .
            ($sqlGroupByID ? ' GROUP BY I.id ' : '') . "
                   ORDER BY $orderBy $orderDirection" . $sqlLimit
        ) : array());

        if (Request::isAJAX()) {
            $this->ajaxResponse(array(
                    'q'     => $aFilter,
                    'list'  => $this->viewPHP($aData, 'admin.items.listing.ajax'),
                    'pages' => $aData['pages'],
                )
            );
        }

        $aData['categories_options'] = $this->categoryOptions($aFilter['category'], true, 'Все категории', 0);
        $aFilter = HTML::escape($aFilter, 'html', array('title'));
        $aData['event'] = __FUNCTION__;
        $aData['bRotate'] = $bRotate;

        $aData['list'] = $this->viewPHP($aData, 'admin.items.listing.ajax');

        if($aFilter['agent']){
            $aAgent = Users::model()->userData($aFilter['agent'], array('login', 'email'));
            $aData['agent_title'] = '#'.$aFilter['agent'].' '.$aAgent['login'].' ('.$aAgent['email'].')';
        }

        return $this->viewPHP($aData, 'admin.items.listing');
    }

    function items_add()
    {
        if (!$this->haveAccessTo('items-edit')) {
            return $this->showAccessDenied();
        }

        $aData = array(
            'no_map'               => 0,
            'keyword'              => '',
            'id'                   => 0,
            'icategories_selected' => '',
            'icategories_parents'  => array()
        );
        foreach ($this->model->langItems as $k => $v) {
            foreach ($this->locale->getLanguages(true) as $lng) {
                $aData[$k][$lng] = '';
            }
        }

        if (Request::isPOST()) {
            $this->input->postm(array(
                    'no_map'       => TYPE_BOOL,
                    'addr'         => TYPE_ARRAY,
                    'schedule'     => TYPE_ARRAY,
                    'schedule_off' => TYPE_ARRAY,
                    'keyword'      => TYPE_NOTAGS,
                    'category'     => TYPE_ARRAY_UINT,
                    'redirect'     => TYPE_BOOL,
                    'mtemplate'    => TYPE_BOOL,
                ), $aData
            );
            $this->input->postm_lang($this->model->langItems, $aData);

            if ($this->errors->no()) {

                $nCategoryID = 0; # основная категория
                $aCats = $aData['category'];
                if (!empty($aCats)) {
                    foreach ($aCats as $v) {
                        if ($v > 0) {
                            $nCategoryID = $v;
                            break;
                        }
                    }
                }

                $nItemID = $this->db->insert(TABLE_ITEMS, array(
                        'user_id'   => User::id(),
                        'cat_id'    => $nCategoryID,
                        'city_id'   => (!empty($aData['addr']['city_id']) ? $aData['addr']['city_id'] : 0),
                        'keyword'   => $aData['keyword'],
                        'no_map'    => $aData['no_map'],
                        'created'   => $this->db->now(),
                        'modified'  => $this->db->now(),
                        'moderated' => 1,
                    ), 'id'
                );

                if ($nItemID) {
                    $this->db->update(TABLE_ITEMS, array(
                        'link' => static::urlView($nItemID, $aData['keyword'], $aData['addr']['city_id']),
                        'link_short' => static::urlView($nItemID, $aData['keyword'], $aData['addr']['city_id'], false)
                    ), array('id' => $nItemID));

                    $this->db->langInsert($nItemID, $aData, $this->model->langItems, TABLE_ITEMS_LANG);

                    # добавляем адреса
                    $aAddr = $this->saveItemAddr($nItemID, $aData['addr'], true);

                    # добавляем отмеченные категории
                    if (!empty($aCats)) {
                        $aCats = array_unique($aCats);
                        if (self::categoriesLimit() > 0) {
                            $aCats = array_slice($aCats, 0, self::categoriesLimit());
                        }

                        $sJoin = '';
                        if ($this->regionsFilterEnabled()) {
                            if (!empty($aAddr)) {
                                $aAddr = reset($aAddr);
                                if (!empty($aAddr['city_id'])) {
                                    $sJoin = ' INNER JOIN ' . TABLE_ITEMS_ADDR . ' A ON A.item_id = C.item_id AND A.city_id = ' . $aAddr['city_id'];
                                }
                            }
                        }

                        $aMaxNum = $this->db->select_key('
                            SELECT C.category_id, MAX(C.num_order) AS max
                            FROM ' . TABLE_ITEMS_IN_CATEGORIES . ' C ' . $sJoin . '
                            WHERE C.category_id IN(' . join(',', $aCats) . ')
                            GROUP BY C.category_id', 'category_id'
                        );

                        $aInsertData = array();
                        $i = 1;
                        foreach ($aCats as $v) {
                            if ($v > 0) {
                                $aInsertData[] = array(
                                    'item_id'     => $nItemID,
                                    'category_id' => $v,
                                    'num'         => ($i++),
                                    'num_order'   => !empty($aMaxNum[$v]['max']) ? $aMaxNum[$v]['max'] + 1 : 1,
                                );
                            }
                        }
                        $this->db->multiInsert(TABLE_ITEMS_IN_CATEGORIES, $aInsertData);

                        if (!empty($aCats) && $nCategoryID > 0) {
                            //сохраняем, для удобства, категорию добавленного объекта
                            $nLastCategoryID = $this->security->getSESSION('items-add-lastcat');
                            if ($nLastCategoryID != $nCategoryID) {
                                $this->security->setSESSION('items-add-lastcat', $nCategoryID);
                            }
                        }
                    }

                    # добавляем расписание
                    $this->saveItemSchedule($nItemID, $aData['schedule'], $aData['schedule_off']);
                }

                $this->adminRedirect(Errors::SUCCESS, ($aData['redirect'] || !$nItemID ? 'items_listing' : 'items_edit&item_id=' . $nItemID));
            }
        }

        $aData['categories_options'] = $this->categoryOptions(0, true, 'не указана', 1);

        $aData['schedule'] = array();
        $aData['addr'] = array();
        $aData['edit'] = false;
        return $this->viewPHP($aData, 'admin.items.form');
    }

    function items_edit()
    {
        if (!$this->haveAccessTo('items-edit')) {
            return $this->showAccessDenied();
        }

        $nRecordID = $this->input->get('item_id', TYPE_UINT);
        if (!$nRecordID) {
            $this->adminRedirect(Errors::UNKNOWNRECORD, 'items_listing');
        }

        $aData = $this->db->one_array('SELECT I.*, 
                        U.login as user_login, U.blocked as user_blocked, 
                        A.email as agent_email, A.blocked as agent_blocked
                   FROM ' . TABLE_ITEMS . ' I
                        LEFT JOIN ' . TABLE_USERS . ' U ON U.user_id = I.user_id
                        LEFT JOIN ' . TABLE_USERS . ' A ON A.user_id = I.agent_id
                   WHERE I.id=' . $nRecordID
        );
        if (!$aData) {
            $this->adminRedirect(Errors::UNKNOWNRECORD, 'items_listing');
        }
        $this->db->langSelect($nRecordID, $aData, $this->model->langItems, TABLE_ITEMS_LANG);

        $bShowModeration = ($aData['moderated'] != 1);

        if (Request::isPOST()) {

            $this->input->postm(array(
                    'no_map'               => TYPE_BOOL,
                    'addr'                 => TYPE_ARRAY, // адреса
                    'schedule_edit'        => TYPE_BOOL, //редактируем ли расписание работы?
                    'keyword'              => TYPE_NOTAGS,
                    'category'             => TYPE_ARRAY_UINT, // id категорий, в которые входит объект
                    'category_change'      => TYPE_BOOL, // bool, менялся ли состав категорий, в которые входит объект
                    'category_last'        => TYPE_STR, // id категорий, до начала редактирования
                    'category_parents'     => TYPE_STR, // id основных категорий, до начала редактирования
                    'category_parents_new' => TYPE_STR, // id основных категорий, после редактирования
                    'redirect'             => TYPE_BOOL,
                    'mtemplate'            => TYPE_BOOL,
                ), $aData
            );
            $this->input->postm_lang($this->model->langItems, $aData);

            # сохраняем адреса
            $aAddr = $this->saveItemAddr($nRecordID, $aData['addr']);

            # сохраняем расписание
            if ($aData['schedule_edit']) {
                $this->saveItemSchedule($nRecordID,
                    $this->input->post('schedule', TYPE_ARRAY),
                    $this->input->post('schedule_off', TYPE_ARRAY)
                );
            }

            $nCategoryID = 0; //основная категория

            # категории меняются (добавляем/удаляем)
            $aCatsLast = (!empty($aData['category_last']) ? explode(',', $aData['category_last']) : array());
            if (!empty($aData['category'])) {
                foreach ($aData['category'] as $k => $v) { //удаляем пустые категории
                    if (!$v) {
                        unset($aData['category'][$k]);
                    }
                }

                if (!empty($aData['category'])) {
                    $nCategoryID = reset($aData['category']);
                }
            }

            if ($aData['category_change'] && (
                    count(array_diff($aData['category'], $aCatsLast)) > 0 ||
                    count(array_diff($aCatsLast, $aData['category'])) > 0)
            ) {
                $aData['category'] = array_unique($aData['category']);
                if (self::categoriesLimit() > 0) {
                    $aData['category'] = array_slice($aData['category'], 0, self::categoriesLimit());
                }

                $aCatsDelete = $aCatsAdd = array();
                if (empty($aData['category'])) {
                    # удаляем все категории объекта
                    $aCatsDelete = $aCatsLast;
                } else {
                    # добавляем новые
                    $aCatsAdd = array_diff($aData['category'], $aCatsLast);
                    # удаляем отсутствующие
                    $aCatsDelete = array_diff($aCatsLast, $aData['category']);
                }

                if (!empty($aCatsAdd)) {
                    # добавляем категории
                    $sJoin = '';
                    if ($this->regionsFilterEnabled()) {
                        if (!empty($aAddr)) {
                            $aAddr = reset($aAddr);
                            if (!empty($aAddr['city_id'])) {
                                $sJoin = ' INNER JOIN ' . TABLE_ITEMS_ADDR . ' A ON A.item_id = C.item_id AND A.city_id = ' . $aAddr['city_id'];
                            }
                        }
                    }

                    $aMaxNum = $this->db->select_key('
                            SELECT C.category_id, MAX(C.num_order) AS max
                            FROM ' . TABLE_ITEMS_IN_CATEGORIES . ' C ' . $sJoin . '
                            WHERE C.category_id IN(' . join(',', $aCatsAdd) . ')
                            GROUP BY C.category_id', 'category_id'
                    );

                    $aInsertData = array();
                    foreach ($aCatsAdd as $v) {
                        $aInsertData[] = array(
                            'item_id'     => $nRecordID,
                            'category_id' => $v,
                            'num_order'   => !empty($aMaxNum[$v]['max']) ? $aMaxNum[$v]['max'] + 1 : 1,
                        );
                    }
                    $this->db->multiInsert(TABLE_ITEMS_IN_CATEGORIES, $aInsertData);
                }

                if (!empty($aCatsDelete)) {
                    # удаляем связь с категориями
                    $this->db->delete(TABLE_ITEMS_IN_CATEGORIES, array(
                        'item_id' => $nRecordID,
                        'category_id' => $aCatsDelete,
                    ));
                }

                $this->renumItemCategory($nRecordID, $aData['category']);
            } else {
                if ($aCatsLast != $aData['category']) {
                    # категории передвигались, но их состав не менялся
                    $this->renumItemCategory($nRecordID, $aData['category']);
                }
            }

            $aData['keyword'] = $this->getKeyword($aData['keyword'], $aData['title'][LNG]);

            $bModerated = ($bShowModeration && $this->input->post('moderated', TYPE_BOOL));

            if ($this->errors->no()) {
                $aUpdate = array(
                    'cat_id'   => $nCategoryID,
                    'city_id'  => $aAddr['city_id'],
                    'keyword'  => $aData['keyword'],
                    'link'     => static::urlView($nRecordID, $aData['keyword'], $aAddr['city_id']),
                    'link_short' => static::urlView($nRecordID, $aData['keyword'], $aAddr['city_id'], false),
                    'no_map'   => $aData['no_map'],
                    'mtemplate'=> $aData['mtemplate'],
                    'modified' => $this->db->now(),
                );
                if ($bModerated) {
                    $aUpdate['moderated'] = 1;
                    $aUpdate['moderated_uid'] = User::id();
                }
                $this->db->update(TABLE_ITEMS, $aUpdate, array('id' => $nRecordID));
                $this->db->langUpdate($nRecordID, $aData, $this->model->langItems, TABLE_ITEMS_LANG);

                if ($this->errors->no()) {
                    if ($bModerated) {
                        $this->itemsModerationCounter(-1);
                    }

                    $sUrlHash = $this->input->post('urlhash', TYPE_STR);
                    $this->adminRedirect((!empty($sUrlHash) ? '&urlhash=1#' . stripslashes($sUrlHash) : Errors::SUCCESS),
                        ($aData['redirect'] ? 'items_listing' : 'items_edit&item_id=' . $nRecordID)
                    );
                }
            }
        }

        # получаем подкатегории
        {
            $aData['icategories_data'] = $this->db->select('
                                            SELECT C.id, C.pid, CL.title, CPL.title as parent_title, IC.*
                                            FROM ' . TABLE_ITEMS_IN_CATEGORIES . ' IC, ' . TABLE_ITEMS_CATEGORIES . ' C
                                                LEFT JOIN ' . TABLE_ITEMS_CATEGORIES . ' CP ON CP.id = C.pid
                                                LEFT JOIN ' . TABLE_ITEMS_CATEGORIES_LANG . ' CPL ON ' . $this->db->langAnd(false, 'CP', 'CPL') . '
                                                , ' . TABLE_ITEMS_CATEGORIES_LANG . ' CL
                                            WHERE IC.item_id = ' . $nRecordID . ' AND IC.category_id = C.id ' . $this->db->langAnd(true, 'C', 'CL') . '
                                            ORDER BY IC.num'
            );

            $aData['icategories_parents'] = array();
            $categoriesParents = & $aData['icategories_parents'];

            if (!empty($aData['icategories_data'])) {
                $aData['icategories_data'] = func::array_transparent($aData['icategories_data'], 'id', true);
                # оставляем только id подкатегорий
                $aData['icategories'] = array();
                $aCategoriesID = array();
                foreach ($aData['icategories_data'] as $k => $v) {
                    if ($v['id'] != 0) {
                        if ($v['pid'] > 0) {
                            $aData['icategories'][$v['id']] = $v['title'] . (!empty($v['parent_title']) ? ' (' . $v['parent_title'] . ')' : '');
                            $aCategoriesID[] = $v['id'];
                            if (!isset($categoriesParents[$v['pid']])) {
                                $categoriesParents[$v['pid']] = array($v['id']);
                            } else {
                                $categoriesParents[$v['pid']][] = $v['id'];
                            }
                        }
                    }
                }

            } else {
                $aData['icategories'] = array();
                $aCategoriesID = array();
            }

            $aData['icategories_selected'] = join(',', $aCategoriesID);
        }

        # получаем адреса объекта
        $aData['addr'] = $this->db->one_array('SELECT A.*
                                FROM ' . TABLE_ITEMS_ADDR . ' A
                                WHERE A.item_id = ' . $nRecordID . '
                                LIMIT 1'
        );
        $this->db->langFieldsSelect($aData['addr'], $this->model->langItemsAddr);

        $aData['categories_options'] = $this->categoryOptions(0, true, false, 1);

        $aData['edit'] = true;
        return $this->viewPHP($aData, 'admin.items.form');
    }

    function items_images() # фотографии объекта
    {
        if (!$this->haveAccessTo('items-edit')) {
            return $this->showAccessDenied();
        }

        $sAct = $this->input->postget('act');

        if (Request::isAJAX() || $sAct == 'upload') {
            $aResponse = array();

            $nItemID = $this->input->postget('item_id', TYPE_UINT);
            if (!$nItemID) {
                $this->errors->impossible();
            }

            $oImages = $this->initImages($nItemID);

            switch ($sAct) {
                case 'upload':
                {

                    $res = $oImages->uploadQQ();
                    if ($res !== false) {
                        $aResponse = $res;
                        $aURL = $oImages->getURL($res, array(
                                ItemsImages::szSmall,
                                ItemsImages::szNormal
                            ), empty($nItemID)
                        );
                        $aResponse = array_merge($aResponse, $aURL);
                        $aResponse['success'] = $this->errors->no();
                    }

                }
                break;
                case 'rotate':
                {
                    $oImages->rotate();
                }
                break;
                case 'title':
                {

                    $p = $this->input->postm(array(
                            'image_id' => TYPE_UINT,
                            'title'    => TYPE_STR,
                            'lng'      => TYPE_STR,
                        )
                    );
                    $p['title'] = $this->input->cleanTextPlain($p['title']);

                    if (!$p['image_id']) {
                        $this->errors->impossible();
                        break;
                    }
                    if (!in_array($p['lng'], $this->locale->getLanguages())) {
                        $this->errors->impossible();
                        break;
                    }
                    $aUpdate = array();
                    $aUpdate['title_' . $p['lng']] = $p['title'];
                    $oImages->updateTitle($p['image_id'], $aUpdate);
                    $aResponse['title'] = $p['title'];

                }
                break;
                case 'delete':
                {

                    $bDeleteALL = ($this->input->postget('all') ? 1 : 0);
                    if ($bDeleteALL) {
                        $oImages->deleteAllImages(true);
                    } else {
                        $p = $this->input->postm(array(
                                'image_id' => TYPE_UINT,
                            )
                        );

                        if (!$p['image_id']) {
                            $this->errors->impossible();
                            break;
                        }
                        $oImages->deleteImage($p['image_id']);
                    }
                }
                break;
                default:
                    $this->errors->impossible();
            }

            $aResponse['res'] = ($this->errors->no() ? 1 : 0);
            $this->ajaxResponse($aResponse);
        }

        $nItemID = $this->input->postget('item_id', TYPE_UINT);
        if (!$nItemID) {
            $this->adminRedirect(Errors::UNKNOWNRECORD, 'items_listing');
        }
        $aData = $this->model->itemData($nItemID, array('id', 'link'));

        $aData['oImages'] = $this->initImages($nItemID);
        $aData['img'] = $aData['oImages']->getData();
        $aData['imgcnt'] = sizeof($aData['img']);
        foreach ($aData['img'] as $k => $v) {
            $this->db->langFieldsSelect($aData['img'][$k], $this->model->langItemsImages);
        }

        $aData['edit'] = true;
        return $this->viewPHP($aData, 'admin.items.form.images');
    }

    //--------------------------------------------------------------------
    // отзывы

    function opinions()
    {
        if (!$this->haveAccessTo('opinions')) {
            return $this->showAccessDenied();
        }

        if (Request::isAJAX()) {
            $nOpinionID = $this->input->postget('opinion_id', TYPE_UINT);
            if (!$nOpinionID) {
                return $this->showImpossible();
            }

            switch ($this->input->get('act')) {
                case 'edit':
                {

                    $aResponse = array();
                    $sMessage = $this->input->post('message', TYPE_NOTAGS);
                    $sMessage = $this->input->cleanTextPlain($sMessage);
                    if (empty($sMessage)) {
                        $this->errors->set(_t('items', 'Текст отзыва не может быть пустым'));
                    } else {
                        $this->db->exec('UPDATE ' . TABLE_ITEMS_OPINIONS . '
                            SET message = :message, modified = :modified, modified_uid = ' . User::id() . '
                            WHERE id = ' . $nOpinionID,
                            array(':message' => $sMessage, ':modified' => $this->db->now())
                        );
                        $aResponse['message'] = nl2br($sMessage);
                    }
                    $this->ajaxResponse($aResponse);
                }
                break;
                case 'delete':
                {

                    $aData = $this->db->one_array('SELECT id, item_id, moderated FROM ' . TABLE_ITEMS_OPINIONS . ' WHERE id = ' . $nOpinionID);
                    if (empty($aData)) {
                        $this->showImpossible();
                    }
                    $res = $this->db->exec('DELETE FROM ' . TABLE_ITEMS_OPINIONS . ' WHERE id = ' . $nOpinionID);
                    if (!empty($res)) {
                        if (!$aData['moderated']) {
                            $this->itemsOpinionsModerationCounter(false); // откручиваем счетчик непромодерированных отзывов
                        }
                        $this->itemOpinionsCacheUpdate($aData['item_id']);
                        $this->ajaxResponse(Errors::SUCCESS);
                    }
                }
                break;
                case 'moderate':
                {
                    $aData = $this->db->one_array('SELECT id, item_id, moderated FROM ' . TABLE_ITEMS_OPINIONS . ' WHERE id = ' . $nOpinionID);
                    if (empty($aData)) {
                        $this->showImpossible();
                    }

                    if ($aData['moderated']) {
                        $this->errors->set(_t('items', 'Отзыв уже был промодерирован ранее'));
                        break;
                    }
                    $res = $this->db->exec('UPDATE ' . TABLE_ITEMS_OPINIONS . ' SET moderated = 1 WHERE id = ' . $nOpinionID);
                    if (!empty($res)) {
                        $this->itemsOpinionsModerationCounter(false); // откручиваем счетчик непромодерированных отзывов
                        $this->itemOpinionsCacheUpdate($aData['item_id']);
                        $this->ajaxResponse(Errors::SUCCESS);
                    }
                }
                break;
            }

            $this->showImpossible();
        }

        $nItemID = $this->input->getpost('item_id', TYPE_UINT);
        if (!$nItemID) {
            return $this->showImpossible();
        }

        $aData = $this->db->one_array('SELECT I.id, I.link, IL.title, A.address
            FROM ' . TABLE_ITEMS . ' I,
                 ' . TABLE_ITEMS_ADDR . ' A,
                 ' . TABLE_ITEMS_LANG . ' IL
            WHERE I.id = ' . $nItemID . ' AND I.id = A.item_id ' . $this->db->langAnd(true, 'I', 'IL')
        );
        if (empty($aData)) {
            $this->showImpossible();
        }

        $aData['cats'] = $this->db->select('SELECT C.id, CL.title, C.keyword
                    FROM ' . TABLE_ITEMS_IN_CATEGORIES . ' IC, ' . TABLE_ITEMS_CATEGORIES . ' C, ' . TABLE_ITEMS_CATEGORIES_LANG . ' CL
                    WHERE IC.item_id = ' . $nItemID . ' AND IC.category_id = C.id AND C.enabled = 1 ' . $this->db->langAnd(true, 'C', 'CL') . '
                    ORDER BY IC.num
                    '
        );

        $aData['opinions'] = $this->db->select('SELECT O.*, U.login, U.blocked as ublocked, U.deleted as udeleted, 
                    U2.login as m_login, U2.blocked as m_blocked, U2.deleted as m_deleted
                FROM ' . TABLE_ITEMS_OPINIONS . ' O
                    LEFT JOIN ' . TABLE_USERS . ' U2 ON O.modified_uid = U2.user_id,
                    ' . TABLE_USERS . ' U
                WHERE O.item_id = ' . $nItemID . ' AND O.user_id = U.user_id
            '
        );

        $aData['edit_allowed'] = $this->haveAccessTo('opinions');
        tpl::includeJS(array('comments'), true);

        return $this->viewPHP($aData, 'admin.opinions');
    }

    function opinions_mod()
    {
        if (!$this->haveAccessTo('opinions')) {
            return $this->showAccessDenied();
        }

        $f = $this->input->postgetm(array(
            'id'       => TYPE_UINT,
            'author'   => TYPE_UINT,
        ));

        $aFilter = array();
        $aFilter['moderated'] = 0;
        $aFilter[':ju'] = 'O.user_id = U.user_id';
        if ($f['id']) {
            $aFilter['item_id'] = $f['id'];
        }
        if ($f['author']) {
            $aFilter['user_id'] = $f['author'];
        }
        $aFilter = $this->model->prepareFilter($aFilter, 'O');

        $aData['opinions'] = $this->db->select('SELECT O.*, U.login, U.blocked as ublocked, U.deleted as udeleted,
                U2.login as m_login, U2.blocked as m_blocked, U2.deleted as m_deleted
            FROM ' . TABLE_ITEMS_OPINIONS . ' O
                LEFT JOIN ' . TABLE_USERS . ' U2 ON O.modified_uid = U2.user_id,
                ' . TABLE_USERS . ' U '.$aFilter['where'], $aFilter['bind']);

        if($f['author']){
            $aAuthor = Users::model()->userData($f['author'], array('login', 'email'));
            $aData['author_title'] = '#'.$f['author'].' '.$aAuthor['login'].' ('.$aAuthor['email'].')';
        }
        $aData['f'] = $f;

        $aData['edit_allowed'] = $this->haveAccessTo('opinions');
        tpl::includeJS(array('comments'), true);
        tpl::includeJS(array('autocomplete'), true);


        return $this->viewPHP($aData, 'admin.opinions.mod');
    }

    # ------------------------------------------------------------------------------------------
    # представители

    function agents()
    {
        if (!$this->haveAccessTo('agents')) {
            return $this->showAccessDenied();
        }

        if (Request::isAJAX()) {
            $nOpinionID = $this->input->postget('opinion_id', TYPE_UINT);
            if (!$nOpinionID) {
                return $this->showImpossible();
            }

            switch ($this->input->get('act')) {
                case 'edit':
                {

                    $aResponse = array();
                    $sMessage = $this->input->post('message', TYPE_NOTAGS);
                    $sMessage = $this->input->cleanTextPlain($sMessage);
                    if (empty($sMessage)) {
                        $this->errors->set(_t('items', 'Текст отзыва не может быть пустым'));
                    } else {
                        $this->db->exec('UPDATE ' . TABLE_ITEMS_OPINIONS . '
                            SET message = :message, modified = :modified, modified_uid = ' . User::id() . '
                            WHERE id = ' . $nOpinionID,
                            array(':message' => $sMessage, ':modified' => $this->db->now())
                        );
                        $aResponse['message'] = nl2br($sMessage);
                    }
                    $this->ajaxResponse($aResponse);
                }
                break;
                case 'delete':
                {

                    $aData = $this->db->one_array('SELECT id, item_id, moderated FROM ' . TABLE_ITEMS_OPINIONS . ' WHERE id = ' . $nOpinionID);
                    if (empty($aData)) {
                        $this->showImpossible();
                    }
                    $res = $this->db->exec('DELETE FROM ' . TABLE_ITEMS_OPINIONS . ' WHERE id = ' . $nOpinionID);
                    if (!empty($res)) {
                        if (!$aData['moderated']) {
                            $this->itemsOpinionsModerationCounter(false); // откручиваем счетчик непромодерированных отзывов
                        }
                        $this->itemOpinionsCacheUpdate($aData['item_id']);
                        $this->ajaxResponse(Errors::SUCCESS);
                    }
                }
                break;
                case 'moderate':
                {
                    $aData = $this->db->one_array('SELECT id, item_id, moderated FROM ' . TABLE_ITEMS_OPINIONS . ' WHERE id = ' . $nOpinionID);
                    if (empty($aData)) {
                        $this->showImpossible();
                    }

                    if ($aData['moderated']) {
                        $this->errors->set(_t('items', 'Отзыв уже был промодерирован ранее'));
                        break;
                    }
                    $res = $this->db->exec('UPDATE ' . TABLE_ITEMS_OPINIONS . ' SET moderated = 1 WHERE id = ' . $nOpinionID);
                    if (!empty($res)) {
                        $this->itemsOpinionsModerationCounter(false); // откручиваем счетчик непромодерированных отзывов
                        $this->itemOpinionsCacheUpdate($aData['item_id']);
                        $this->ajaxResponse(Errors::SUCCESS);
                    }
                }
                break;
            }

            $this->showImpossible();
        }

        $f = $this->input->getm(array(
                'item'    => TYPE_UINT,
                'user'    => TYPE_UINT,
            )
        );

        $aFilter = array();
        $aFilter[':ju'] = 'U.user_id = S.user_id AND S.items > 0';
        $sJoin = '';
        if ($f['item']) {
            $sJoin = ', '.TABLE_ITEMS.' I ';
            $aFilter[':ji'] = 'I.agent_id = U.user_id';
            $aFilter[':i'] = array('I.id = :itemid', 'itemid' => $f['item']);
        }
        if ($f['user']) {
            $aFilter['user_id'] = $f['user'];
        }
        $aFilter = $this->model->prepareFilter($aFilter, 'U');


        $nTotal = $this->db->one_data('SELECT COUNT(U.user_id) 
            FROM ' . TABLE_USERS . ' U, ' . TABLE_USERS_STAT . ' S
            '.$sJoin.$aFilter['where'], $aFilter['bind']);

        $aData['pgn'] = $this->generatePagenation($nTotal, 20, $this->adminLink("agents&{pageId}"), $sqlLimit);

        $aData['agents'] = $this->db->select('SELECT U.user_id as id, U.admin, U.login, U.name, U.surname, U.email, U.activated, U.blocked, S.items
            FROM ' . TABLE_USERS . ' U, ' . TABLE_USERS_STAT . ' S
            '.$sJoin.$aFilter['where'].$sqlLimit, $aFilter['bind']);

        if($f['user']){
            $aUser = Users::model()->userData($f['user'], array('login', 'email'));
            $aData['user_title'] = '#'.$f['user'].' '.$aUser['login'].' ('.$aUser['email'].')';
        }
        $aData['f'] = $f;

        return $this->viewPHP($aData, 'admin.agents');
    }

    function agents_requests()
    {
        if (!$this->haveAccessTo('agents')) {
            return $this->showAccessDenied();
        }

        if (Request::isAJAX()) {
            $sAction = $this->input->get('act');

            if ($sAction != 'agent-autocomplete') {
                $nRequestID = $this->input->postget('id', TYPE_UINT);
                if (!$nRequestID) {
                    return $this->showImpossible();
                }
            }

            switch ($sAction) {
                case 'edit_start':
                {
                    # инициируем рассмотрение заявки
                    $aResponse = array();
                    $aData = $this->db->one_array('SELECT R.*,
                            U.email as user_email, U.activated, U.blocked, IL.title AS item_title, I.link AS item_link
                        FROM ' . TABLE_ITEMS_AGENTS_REQUESTS . ' R
                             LEFT JOIN ' . TABLE_USERS . ' U ON R.user_id = U.user_id,
                             ' . TABLE_ITEMS . ' I, ' . TABLE_ITEMS_LANG . ' IL
                        WHERE I.id = R.item_id AND R.id = ' . $nRequestID . $this->db->langAnd(true, 'I', 'IL')
                    );
                    if (empty($aData)) {
                        $this->showImpossible();
                    }

                    $aResponse['form'] = $this->viewPHP($aData, 'admin.agents.requests.edit');
                    $this->ajaxResponse($aResponse);
                }
                break;
                case 'edit_finish':
                {
                    $p = $this->input->postm(array(
                            'item_id' => TYPE_UINT,
                            'user_id' => TYPE_UINT,
                            'name'    => TYPE_NOTAGS,
                            'phone'   => TYPE_NOTAGS,
                            'email'   => TYPE_NOTAGS,
                        )
                    );

                    if (!$p['item_id']) {
                        return $this->showImpossible();
                    } else {
                        $aItemData = $this->db->one_array('SELECT id, agent_id FROM ' . TABLE_ITEMS . ' WHERE id = ' . $p['item_id']);
                        if (empty($aItemData)) {
                            return $this->showImpossible();
                        } else {
                            if ($aItemData['agent_id'] > 0) {
                                $this->errors->set(_t('items', 'Данный объект уже связан с представителем'));
                            } else {
                                if (!$p['user_id']) {
                                    $this->errors->set(_t('items', 'Укажите пользователя'));
                                }
                            }
                        }
                    }

                    if ($this->errors->no()) {
                        $aRequestData = $this->db->one_array('SELECT id, item_id, user_id FROM ' . TABLE_ITEMS_AGENTS_REQUESTS . ' WHERE id = ' . $nRequestID);

                        # закрепляем объект за пользователем
                        $res = $this->db->update(TABLE_ITEMS,
                            array(
                                'agent_id'   => $p['user_id'],
                                'agent_info' => serialize(array(
                                        'name'  => $p['name'],
                                        'phone' => $p['phone'],
                                        'email' => $p['email']
                                    )
                                ),
                            ),
                            array('id'=>$p['item_id'])
                        );
                        if (!empty($res)) {
                            # накручиваем счетчик объектов пользователя (которые он представляет)
                            $this->security->userCounter('items', 1, $p['user_id']);

                            # удаляем заявку
                            $res = $this->db->exec('DELETE FROM ' . TABLE_ITEMS_AGENTS_REQUESTS . ' WHERE id = ' . $nRequestID);
                            if (!empty($res)) {
                                if ($aRequestData['user_id']) {
                                    # откручиваем счетчик заявок "на представительство" пользователя
                                    $this->security->userCounter('items_requests', -1, $aRequestData['user_id']);
                                }
                            }
                            config::saveCount('items_agents', -1, true);
                        }
                    }

                    $aResponse = array('res' => $this->errors->no());
                    $this->ajaxResponse($aResponse);
                }
                break;
                case 'agent-autocomplete': # autocomplete
                {
                    $sQ = $this->input->post('q', TYPE_NOTAGS);
                    $sQ = $this->db->str2sql("$sQ%");
                    //получаем список подходящих по логину пользователей, исключая:
                    // - заблокированных
                    // - неактивированных  
                    $aResult = $this->db->select('SELECT U.user_id as id, U.email FROM ' . TABLE_USERS . ' U
                                  WHERE U.email LIKE (' . $sQ . ')
                                    AND U.blocked = 0
                                    AND U.activated = 1
                                  ORDER BY U.email'
                    );

                    $aUsers = array();
                    foreach ($aResult as $u) {
                        $aUsers[$u['id']] = $u['email'];
                    }
                    unset($aResult);

                    $this->ajaxResponse($aUsers);
                }
                break;
                case 'delete':
                {

                    # удаляем заявку
                    $aData = $this->db->one_array('SELECT id, item_id, user_id FROM ' . TABLE_ITEMS_AGENTS_REQUESTS . ' WHERE id = ' . $nRequestID);
                    if (empty($aData)) {
                        $this->showImpossible();
                    }
                    $res = $this->db->delete(TABLE_ITEMS_AGENTS_REQUESTS, array('id'=>$nRequestID));
                    if (!empty($res)) {
                        # откручиваем счетчик заявок "на представительство" пользователя
                        if ($aData['user_id'] > 0) {
                            $this->security->userCounter('items_requests', -1, $aData['user_id']);
                        }
                        config::saveCount('items_agents', -1, true);
                        $this->ajaxResponse(Errors::SUCCESS);
                    }
                }
                break;
            }

            $this->showImpossible();
        }

        $f = $this->input->getm(array(
                'item'    => TYPE_UINT,
                'user'    => TYPE_UINT,
            )
        );

        $aFilter = array();
        $aFilter[':ji'] = 'I.id = R.item_id';
        if ($f['item']) {
            $aFilter['item_id'] = $f['item'];
        }
        if ($f['user']) {
            $aFilter['user_id'] = $f['user'];
        }
        $aFilter = $this->model->prepareFilter($aFilter, 'R');


        $nTotal = $this->db->one_data('SELECT COUNT(R.id) FROM ' . TABLE_ITEMS_AGENTS_REQUESTS.' R, ' . TABLE_ITEMS . ' I '.$aFilter['where'], $aFilter['bind']);

        # pagenation
        $this->generatePagenation($nTotal, 20, $this->adminLink("agents_requests&{pageId}"), $sqlLimit);

        $aData['requests'] = $this->db->select('
            SELECT R.*, U.login, U.email as uemail, U.activated, U.blocked, IL.title AS item_title, I.link AS item_link
            FROM ' . TABLE_ITEMS_AGENTS_REQUESTS . ' R
                 LEFT JOIN ' . TABLE_USERS . ' U ON R.user_id = U.user_id,
                 ' . TABLE_ITEMS . ' I, ' . TABLE_ITEMS_LANG . ' IL
            ' .$aFilter['where'].$this->db->langAnd(true, 'I', 'IL') . '
            ORDER BY R.created ASC ' . $sqlLimit, $aFilter['bind']
        );

        if($f['user']){
            $aUser = Users::model()->userData($f['user'], array('login', 'email'));
            $aData['user_title'] = '#'.$f['user'].' '.$aUser['login'].' ('.$aUser['email'].')';
        }
        $aData['f'] = $f;

        tpl::includeJS(array('autocomplete', 'comments'), true);

        return $this->viewPHP($aData, 'admin.agents.requests');
    }

    # ------------------------------------------------------------------------------------------
    # жалобы

    function claims()
    {
        if (!$this->haveAccessTo('claims')) {
            return $this->showAccessDenied();
        }

        if (Request::isAJAX()) {
            switch ($this->input->get('act')) {
                case 'delete':
                {

                    $nClaimID = $this->input->post('id', TYPE_UINT);
                    if ($nClaimID) {
                        $aData = $this->db->one_array('SELECT id, viewed FROM ' . TABLE_ITEMS_CLAIMS . ' WHERE id = :id', array(':id' => $nClaimID));
                        if (empty($aData)) {
                            $this->ajaxResponse(Errors::IMPOSSIBLE);
                        }

                        $aResponse = array('counter_update' => false);
                        $res = $this->db->delete(TABLE_ITEMS_CLAIMS, array('id' => $nClaimID));
                        if ($res && !$aData['viewed']) {
                            $this->itemsClaimsCounter(-1);
                            $aResponse['counter_update'] = true;
                        }
                        $aResponse['res'] = $res;
                        $this->ajaxResponse($aResponse);
                    }
                }
                break;
                case 'view':
                {
                    $nClaimID = $this->input->post('id', TYPE_UINT);
                    if ($nClaimID) {
                        $res = $this->db->update(TABLE_ITEMS_CLAIMS, array('viewed' => 1), array('id' => $nClaimID));
                        if ($res) {
                            $this->itemsClaimsCounter(-1);
                        }
                        $this->ajaxResponse(Errors::SUCCESS);
                    }
                }
                break;
            }
            $this->ajaxResponse(Errors::IMPOSSIBLE);
        }

        $aData = $this->input->getm(array(
                'item'    => TYPE_UINT,
                'user'    => TYPE_UINT,
                'page'    => TYPE_UINT,
                'perpage' => TYPE_UINT,
            )
        );

        $sqlFilter = array();
        if ($aData['item']) {
            $sqlFilter['item_id'] = $aData['item'];
        }
        if ($aData['user']) {
            $sqlFilter['user_id'] = $aData['user'];
        }

        $nCount = $this->model->claimsListing($sqlFilter, true);

        $aPerpage = $this->preparePerpage($aData['perpage'], array(20, 40, 60));

        $sFilter = http_build_query($aData);
        unset($aData['page']);
        $aData['pgn'] = $this->generatePagenation($nCount, $aData['perpage'], $this->adminLink("claims&$sFilter&{pageId}"), $sqlLimit);
        $aData['f'] = $sFilter;

        if ($nCount > 0) {
            $aData['list'] = $this->model->claimsListing($sqlFilter, false, $sqlLimit);
            $aReasons = $this->getItemClaimReasons();
            if (!empty($aData['list']) && !empty($aReasons)) {
                foreach ($aData['list'] as &$v) {
                    $v['item_link'] = static::url('view', $v['link']);
                    $r = $v['reasons'];
                    if ($r == 0) {
                        continue;
                    }

                    $r_text = array();
                    foreach ($aReasons as $rk => $rv) {
                        if ($rk != 32 && $rk & $r) {
                            $r_text[] = $rv;
                        }
                    }
                    $v['reasons_text'] = join(', ', $r_text);
                    $v['other'] = $r & 32;
                }
                unset($v);
            }
        } else {
            $aData['list'] = array();
        }

        $aData['perpage'] = $aPerpage;
        if($aData['user']){
            $aUser = Users::model()->userData($aData['user'], array('login', 'email'));
            $aData['user_title'] = '#'.$aData['user'].' '.$aUser['login'].' ('.$aUser['email'].')';
        }

        return $this->viewPHP($aData, 'admin.claims.listing');
    }

    # ------------------------------------------------------------------------------------------
    # категории / подкатегории

    function categories_listing()
    {
        if (!$this->haveAccessTo('settings')) {
            return $this->showAccessDenied();
        }


        if (Request::isAJAX()) {
            switch ($this->input->get('act')) {
                case 'toggle':
                {
                    $nRecordID = $this->input->postget('rec', TYPE_UINT);
                    if (!$nRecordID) {
                        $this->ajaxResponse(Errors::IMPOSSIBLE);
                    }

                    $aData = $this->db->one_array('SELECT C.id,C.pid,C.enabled,P.enabled as pid_enabled
                                                    FROM ' . TABLE_ITEMS_CATEGORIES . ' C
                                                    LEFT JOIN ' . TABLE_ITEMS_CATEGORIES . ' P ON C.pid = P.id
                                                    WHERE C.id = :id', array(':id' => $nRecordID)
                    );
                    if (empty($aData)) {
                        $this->ajaxResponse(Errors::IMPOSSIBLE);
                    }

                    if ($aData['enabled']) {
                        # выключаем категорию -> выключаем все вложенные подкатегории
                        if ($aData['pid'] == 0) {
                            $this->db->update(TABLE_ITEMS_CATEGORIES, array('enabled' => 0), array('pid' => $nRecordID));
                        }
                    } else {
                        if ($aData['pid'] != 0 && !$aData['pid_enabled']) {
                            $this->ajaxResponse(Errors::IMPOSSIBLE);
                        }
                    }

                    $res = $this->db->exec('UPDATE ' . TABLE_ITEMS_CATEGORIES . ' SET enabled=(1-enabled) WHERE id=' . $nRecordID);
                    $this->ajaxResponse(($res ? Errors::SUCCESS : Errors::IMPOSSIBLE));
                }
                break;
                case 'rotate':
                {

                    $res = $this->db->rotateTablednd(TABLE_ITEMS_CATEGORIES, '', 'id', 'num', true, 'pid');
                    $this->ajaxResponse($res ? Errors::SUCCESS : Errors::IMPOSSIBLE);
                }
                break;
                case 'subs-list':
                {
                    $nCategoryID = $this->input->postget('category', TYPE_UINT);
                    if (!$nCategoryID) {
                        $this->ajaxResponse(Errors::UNKNOWNRECORD);
                    }

                    $aData = array();
                    $aData['subcats'] = $this->db->select('SELECT C.id, C.pid, C.icon, C.enabled, CL.title, COUNT(I.item_id) as items
                                               FROM ' . TABLE_ITEMS_CATEGORIES . ' C
                                                 LEFT JOIN ' . TABLE_ITEMS_IN_CATEGORIES . ' I ON I.category_id = C.id,
                                                 ' . TABLE_ITEMS_CATEGORIES_LANG . ' CL
                                               WHERE C.pid=:id' . $this->db->langAnd(true, 'C', 'CL') . '
                                               GROUP BY C.id
                                               ORDER BY C.num', array(':id' => $nCategoryID)
                    );
                    $aData['itemstotal'] = 0;
                    foreach ($aData['subcats'] as $v) {
                        if ($v['items']) {
                            $aData['itemstotal'] += $v['items'];
                        }
                    }

                    $this->ajaxResponse(array(
                            'list'  => $this->viewPHP($aData, 'admin.categories.listing.ajax'),
                            'total' => $aData['itemstotal'],
                        )
                    );
                }
                break;
            }
            $this->ajaxResponse(Errors::IMPOSSIBLE);
        }

        $aData = array();
        $sQueryWhere = '';
        $aOpenCatsID = explode('.', $this->input->cookie(config::sys('cookie.prefix') . 'items_categories_expand'));
        if (empty($aOpenCatsID)) {
            $aOpenCatsID = array();
        }
        $aOpenCatsID[] = 0;
        $sQueryWhere .= ' AND ' . $this->db->prepareIN('C.pid', $aOpenCatsID);

        # получаем категории
        $aData['cats'] = $this->db->select('SELECT C.id, C.pid, C.icon, C.enabled, CL.title, COUNT(I.item_id) as items
                   FROM ' . TABLE_ITEMS_CATEGORIES . ' C
                     LEFT JOIN ' . TABLE_ITEMS_IN_CATEGORIES . ' I ON I.category_id = C.id,
                     ' . TABLE_ITEMS_CATEGORIES_LANG . ' CL
                   WHERE C.id!=0 ' . $sQueryWhere . $this->db->langAnd(true, 'C', 'CL') . '
                   GROUP BY C.id
                   ORDER BY C.pid, C.num'
        );
        $aData['cats'] = $this->db->transformRowsToTree($aData['cats'], 'id', 'pid', 'subcats');

        foreach ($aData['cats'] as &$c) {
            if (!$c['items']) {
                foreach ($c['subcats'] as $c2) {
                    if ($c2['items']) {
                        $c['items'] += $c2['items'];
                    }
                }
            }
            if (!$c['items']) {
                $c['items'] = '-';
            }
        }
        unset($c);

        return $this->viewPHP($aData, 'admin.categories.listing');
    }

    function categories_add()
    {
        if (!$this->haveAccessTo('settings')) {
            return $this->showAccessDenied();
        }

        $aData = $this->input->postm(array(
            'keyword_edit' => TYPE_NOTAGS,
            'enabled'      => TYPE_BOOL,
            'mtemplate'    => TYPE_BOOL,
        ));
        $this->input->postm_lang($this->model->langCategories, $aData);

        if (Request::isPOST()) {
            $aData['pid'] = $this->input->post('pid', TYPE_UINT);
            if (empty($aData['title'])) {
                $this->errors->set(_t('items', 'Укажите название'));
            }

            $this->validateCategoryData(0, $aData);

            if ($this->errors->no()) {
                $nNum = (integer)$this->db->one_data('SELECT MAX(num) FROM ' . TABLE_ITEMS_CATEGORIES . ' WHERE pid = ' . $aData['pid']);
                $aData['num'] = $nNum + 1;
                $notLang = array_diff_key($aData, $this->model->langCategories);
                $notLang['title'] = $aData['title'][LNG];
                $nCategoryID = $this->db->insert(TABLE_ITEMS_CATEGORIES, $notLang);
                if ($nCategoryID) {
                    $this->db->langInsert($nCategoryID, $aData, $this->model->langCategories, TABLE_ITEMS_CATEGORIES_LANG);

                    $this->categoryIconUpdate($nCategoryID, false, true);
                }

                $this->adminRedirect(Errors::SUCCESS, 'categories_listing');
            }
        } else {
            $aData['pid'] = $this->input->get('pid', TYPE_UINT);
        }

        tpl::includeJS('tablednd', true);

        $aData['parent'] = $this->categoryOptions($aData['pid'], false, true); //основные категории
        $aData['categories_options'] = $this->categoryOptions(0, true, 'категория не выбрана', 0);
        $aData['edit'] = false;

        return $this->viewPHP($aData, 'admin.categories.form');
    }

    function categories_edit()
    {
        if (!$this->haveAccessTo('settings')) {
            return $this->showAccessDenied();
        }

        if (Request::isAJAX()) {
            switch ($this->input->get('act')) {
                case 'icon-delete':
                {

                    $nCategoryID = $this->input->postget('id', TYPE_UINT);
                    if (!$nCategoryID) {
                        $this->ajaxResponse(Errors::UNKNOWNRECORD);
                    }

                    $res = $this->categoryIconDelete($nCategoryID, true);
                    $this->ajaxResponse(($res ? Errors::SUCCESS : Errors::IMPOSSIBLE));
                }
                break;
            }
            $this->ajaxResponse(Errors::IMPOSSIBLE);
        }

        $nCategoryID = $this->input->get('id', TYPE_UINT);
        if (!$nCategoryID) {
            $this->adminRedirect(Errors::IMPOSSIBLE, 'categories_listing');
        }

        $aData = $this->db->one_array('SELECT IC.*, IC2.id as subcats
                   FROM ' . TABLE_ITEMS_CATEGORIES . ' IC
                      LEFT JOIN ' . TABLE_ITEMS_CATEGORIES . ' IC2 ON IC2.pid=IC.id
                   WHERE IC.id = :id', array(':id' => $nCategoryID)
        );
        if (!$aData) {
            $this->adminRedirect(Errors::IMPOSSIBLE, 'categories_listing');
        }

        if (Request::isPOST()) {
            $pid_prev = $aData['pid'];
            $this->input->postm_lang($this->model->langCategories, $aData);
            $this->input->postm(array(
                    'pid'          => TYPE_UINT,
                    'keyword_edit' => TYPE_NOTAGS,
                    'enabled'      => TYPE_BOOL,
                    'mtemplate'    => TYPE_BOOL,
                ), $aData
            );

            $this->validateCategoryData($nCategoryID, $aData);

            if ($pid_prev != $aData['pid']) {
                $nNum = (integer)$this->db->one_data('SELECT MAX(num) FROM ' . TABLE_ITEMS_CATEGORIES . ' WHERE pid = ' . $aData['pid']);
                $nNum++;
                $aData['num'] = $nNum;
            }

            if ($this->errors->no()) {
                unset($aData['subcats']);
                $sIconFilename = $this->categoryIconUpdate($nCategoryID, true, false);
                if ($sIconFilename !== false) {
                    $aData['icon'] = $sIconFilename;
                }

                $notLang = array_diff_key($aData, $this->model->langCategories);
                $notLang['title'] = $aData['title'][LNG];
                if ($this->db->update(TABLE_ITEMS_CATEGORIES, $notLang, array('id' => $nCategoryID))) {
                    $this->db->langUpdate($nCategoryID, $aData, $this->model->langCategories, TABLE_ITEMS_CATEGORIES_LANG);
                }

                $this->adminRedirect(Errors::SUCCESS, 'categories_listing');
            }
        } else {
            $this->db->langSelect($nCategoryID, $aData, $this->model->langCategories, TABLE_ITEMS_CATEGORIES_LANG);
        }

        if ($aData['pid']) {
            # если подкатегория, выводим список основных категорий, для возможности перемещения
            $aData['parent'] = $this->categoryOptions($aData['pid'], false, false, null);
        } else {
            if ($aData['subcats'] == 0) {
                # если основная без подкатегорий, даем возможность сделать ее подкатегорией
                $aData['parent'] = $this->categoryOptions(0, false, true, null, false, array($nCategoryID));
            }
        }
        $aData['edit'] = true;

        return $this->viewPHP($aData, 'admin.categories.form');
    }

    function categories_delete()
    {
        if (!$this->haveAccessTo('settings')) {
            return $this->showAccessDenied();
        }

        $nRecordID = $this->input->getpost('id', TYPE_UINT);
        if (!$nRecordID) {
            $this->adminRedirect(Errors::UNKNOWNRECORD, 'categories_listing');
        }

        $aData = $this->db->one_array('SELECT C.*, CL.*
            FROM ' . TABLE_ITEMS_CATEGORIES . ' C, ' . TABLE_ITEMS_CATEGORIES_LANG . ' CL
            WHERE C.id = :id'. $this->db->langAnd(true, 'C', 'CL'), array(':id'=>$nRecordID));
        if (empty($aData)) {
            $this->adminRedirect(Errors::IMPOSSIBLE, 'categories_listing');
        }
        if ($aData['pid'] == 0) {
            $aData['cnt_subcategories'] = (integer)$this->db->one_data('SELECT COUNT(id)
                                         FROM ' . TABLE_ITEMS_CATEGORIES . '
                                         WHERE pid = :id
                                         GROUP BY pid', array(':id' => $nRecordID)
            );
            if ($aData['cnt_subcategories'] > 0) {
                $aData['cnt_items'] = (integer)$this->db->one_data('SELECT COUNT(IC.item_id)
                                             FROM ' . TABLE_ITEMS_IN_CATEGORIES . ' IC, ' . TABLE_ITEMS_CATEGORIES . ' C
                                             WHERE C.pid = :id AND IC.category_id = C.id
                                             GROUP BY C.pid', array(':id' => $nRecordID)
                );
            } else {
                $aData['cnt_items'] = 0;
            }
        } else {
            $aData['cnt_subcategories'] = 0;
            $aData['cnt_items'] = (integer)$this->db->one_data('SELECT COUNT(item_id)
                                         FROM ' . TABLE_ITEMS_IN_CATEGORIES . '
                                         WHERE category_id = :id
                                         GROUP BY category_id', array(':id' => $nRecordID)
            );
        }

        if ($aData['cnt_items'] > 0) {
            $this->adminRedirect(Errors::IMPOSSIBLE, 'categories_listing');
        }

        if (Request::isPOST()) {

            if ($aData['pid'] > 0 || ($aData['pid'] == 0 && $aData['cnt_subcategories'] == 0)) {

                # удаляем пиктограмму категории
                $this->categoryIconDelete($nRecordID);
                # удаляем подкатегорию
                $this->db->delete(TABLE_ITEMS_CATEGORIES, array('id'=>$nRecordID));
                $this->db->delete(TABLE_ITEMS_CATEGORIES_LANG, array('id'=>$nRecordID));
            } else {

                $nNextCategoryID = $this->input->post('next', TYPE_UINT);
                if ($nNextCategoryID > 0) {
                    # проверяем: ID категории не равен ID удаляемой, категория не является подкатегорией
                    $nResultID = $this->db->one_data('SELECT id FROM ' . TABLE_ITEMS_CATEGORIES . ' WHERE id=' . $nNextCategoryID . ' AND pid=0');
                    if ($nResultID != $nNextCategoryID || $nNextCategoryID == $nRecordID) {
                        $this->adminRedirect(Errors::IMPOSSIBLE, 'categories_listing');
                    }

                    # перемещаем  подкатегории
                    $this->db->update(TABLE_ITEMS_CATEGORIES, array('pid'=>$nNextCategoryID), array('pid'=>$nRecordID));
                    # удаляем пиктограмму категории
                    $this->categoryIconDelete($nRecordID);
                    # удаляем категорию
                    $this->db->delete(TABLE_ITEMS_CATEGORIES, array('id'=>$nRecordID));
                    $this->db->delete(TABLE_ITEMS_CATEGORIES_LANG, array('id'=>$nRecordID));
                } else {
                    if ($aData['cnt_subcategories'] > 0) {
                        # получаем ID подкатегорий
                        $aSubcategoryID = $this->db->select_one_column('SELECT id FROM ' . TABLE_ITEMS_CATEGORIES . ' WHERE pid=' . $nRecordID);
                        $aSubcategoryID = array_merge($aSubcategoryID, array($nRecordID));
                        # удаляем пиктограммы подкатегорий
                        $this->categoryIconDelete($aSubcategoryID);
                        # удаляем категорию и подкатегории
                        $this->db->delete(TABLE_ITEMS_CATEGORIES, array('(id = :id OR pid = :id)'), array(':id'=>$nRecordID));
                        $this->db->delete(TABLE_ITEMS_CATEGORIES_LANG, array('id'=>$aSubcategoryID));
                    }
                }
            }

            $this->adminRedirect(Errors::SUCCESS, 'categories_listing');
        }

        $aData['categories'] = $this->db->select('SELECT C.id, CL.title
                                     FROM ' . TABLE_ITEMS_CATEGORIES . ' C
                                        LEFT JOIN ' . TABLE_ITEMS_IN_CATEGORIES . ' IC ON IC.category_id = C.id,
                                        ' . TABLE_ITEMS_CATEGORIES_LANG . ' CL
                                     WHERE C.id!=' . $nRecordID . ' AND C.pid=0 AND IC.item_id IS NULL ' . $this->db->langAnd(true, 'C', 'CL') . '
                                     ORDER BY CL.title ASC'
        );

        return $this->viewPHP($aData, 'admin.categories.delete');
    }

    protected function validateCategoryData($nCategoryID, & $aData = array())
    {
        foreach ($aData['mtitle'] as $lng => $v) {
            $aData['mtitle'][$lng] = strtr($v, array('\\' => '', "'" => '', '"' => '', "\r" => '', "\n" => ''));
        }
        if ($this->model->isCategoryKeywordUnique($aData['keyword_edit'], $aData['pid'], $nCategoryID)) {
            if ($aData['pid'] == 0) {
                $aParent = array('keyword' => '');
            } else {
                $aParent = $this->model->categoryData($aData['pid'], array('C.keyword'));
            }
            if (!empty($aParent)) {
                $aData['keyword'] = ( ! empty($aParent['keyword']) ? $aParent['keyword'] . '/' : '') .
                    $aData['keyword_edit'];
            } else {
                $this->errors->set(_t('items', 'Не найдена основная категория'));
            }
        } else {
            $this->errors->set(_t('items', 'Указанный keyword уже используется'));
        }
    }

    /**
     * Услуги
     */
    public function svc_services()
    {
        if (!$this->haveAccessTo('svc')) {
            return $this->showAccessDenied();
        }

        $svc = $this->svc()->model;

        if (Request::isAJAX()) {
            $aResponse = array();

            switch ($this->input->getpost('act')) {
                case 'update':
                {
                    $nSvcID = $this->input->post('id', TYPE_UINT);
                    if (!$nSvcID) {
                        $this->errors->unknownRecord();
                        break;
                    }

                    $aData = $svc->svcData($nSvcID, array('id', 'type', 'keyword'));
                    if (empty($aData) || $aData['type'] != Svc::TYPE_SERVICE) {
                        $this->errors->unknownRecord();
                        break;
                    }

                    $this->svcValidateData($nSvcID, Svc::TYPE_SERVICE, $aDataSave);
                    if ($this->errors->no()) {
                        $svc->svcSave($nSvcID, $aDataSave);
                        $aResponse['modified'] = tpl::date_format2(BFF_NOW, true) . ', <a class="ajax desc" href="#" onclick="return bff.userinfo(' . User::id() . ');">' . User::data('login') . '</a>';
                    }

                }
                break;
                default:
                {
                    $this->errors->impossible();
                }
                break;
            }

            $this->ajaxResponseForm($aResponse);
        }

        $aData = array(
            'svc' => $svc->svcListing(Svc::TYPE_SERVICE, $this->module_name),
        );

        tpl::includeJS('wysiwyg', true);

        return $this->viewPHP($aData, 'admin.services');
    }

    /**
     * Проверка данных услуги / пакета услуг
     * @param integer $nSvcID ID услуги / пакета услуг
     * @param integer $nType тип Svc::TYPE_
     * @param array $aData @ref проверенные данные
     */
    function svcValidateData($nSvcID, $nType, &$aData)
    {
        $aParams = array(
            'price' => TYPE_PRICE,
        );

        if ($nType == Svc::TYPE_SERVICE) {
            switch ($nSvcID) {
                case self::SERVICE_VIP:
                {

                }
                break;
            }

            $aSettings = array(
                'on' => TYPE_BOOL,
            );

            $aSettingsLang = array(
                'descr'         => TYPE_STR,
                'descr_listing' => TYPE_STR,
            );

            $aData = $this->input->postm($aParams);
            $aData['settings'] = $this->input->postm($aSettings);
            $this->input->postm_lang($aSettingsLang, $aData['settings']);
            if (Request::isPOST()) {
                //
            }
        }
    }

    function ajax()
    {
        if (!$this->security->haveAccessToAdminPanel()) {
            $this->ajaxResponse(Errors::ACCESSDENIED);
        }

        if (Request::isAJAX()) {
            switch ($this->input->postget('action')) {
                case 'item-delete':
                {
                    if (!$this->haveAccessTo('items-delete')) {
                        return $this->showAccessDenied();
                    }

                    $nRecordID = $this->input->postget('rec', TYPE_UINT);
                    if (!$nRecordID) {
                        $this->ajaxResponse(Errors::UNKNOWNRECORD);
                    }

                    $aData = $this->model->itemData($nRecordID, array('id','moderated'));
                    if (empty($aData)) {
                        $this->ajaxResponse(Errors::UNKNOWNRECORD);
                    }

                    $res = $this->itemDelete($nRecordID);
                    if ($res && !$aData['moderated']) {
                        $this->itemsModerationCounter(-1);
                    }
                    $this->ajaxResponse(Errors::SUCCESS);
                }
                break;
                case 'item-gen-keyword':
                {
                    if (!$this->haveAccessTo('items-edit')) {
                        return $this->showAccessDenied();
                    }

                    $sTitle = $this->input->post('title', TYPE_STR);

                    $this->ajaxResponse(array('res' => true, 'keyword' => mb_strtolower(func::translit($sTitle))));
                }
                break;
                case 'item-toggle':
                {
                    if (!$this->haveAccessTo('items-edit')) {
                        return $this->showAccessDenied();
                    }

                    $nItemID = $this->input->postget('rec', TYPE_UINT);
                    if (!$nItemID) {
                        $this->ajaxResponse(Errors::UNKNOWNRECORD);
                    }

                    $res = $this->db->exec('UPDATE ' . TABLE_ITEMS . ' SET enabled=(1-enabled) WHERE id = ' . $nItemID);
                    $this->ajaxResponse(($res ? Errors::SUCCESS : Errors::IMPOSSIBLE));
                }
                break;
                case 'item-schedule-data':
                {
                    $nItemID = $this->input->post('item', TYPE_UINT);
                    if (!$nItemID) {
                        $this->ajaxResponse(Errors::UNKNOWNRECORD);
                    }

                    $aResult = array();
                    $aResult['work'] = $this->db->select('SELECT * FROM ' . TABLE_ITEMS_SCHEDULE . ' WHERE item_id = ' . $nItemID . ' ORDER BY id');
                    $aResult['off'] = $this->db->select('SELECT * FROM ' . TABLE_ITEMS_SCHEDULE_OFF . ' WHERE item_id = ' . $nItemID . ' ORDER BY id');

                    if (!empty($aResult['work'])) {
                        foreach ($aResult['work'] as $k => $v) {
                            $aResult['work'][$k]['title'] = HTML::escape($aResult['work'][$k]['title']);
                        }
                    }

                    $this->ajaxResponse($aResult);
                }
                break;
                case 'item-agent-remove':
                {
                    if (!$this->haveAccessTo('agents')) {
                        return $this->showAccessDenied();
                    }

                    $nItemID = $this->input->post('item_id', TYPE_UINT);
                    if (!$nItemID) {
                        $this->ajaxResponse(Errors::UNKNOWNRECORD);
                    }

                    $aItemData = $this->db->one_array('SELECT id, agent_id FROM ' . TABLE_ITEMS . ' WHERE id = :id', array(':id' => $nItemID));
                    if (empty($aItemData) || !$aItemData['agent_id']) {
                        return $this->showImpossible();
                    }

                    $res = $this->db->exec('UPDATE ' . TABLE_ITEMS . ' SET agent_id = 0 WHERE id = :id', array(':id' => $nItemID));
                    if (!empty($res)) {
                        # откручиваем счетчик объектов пользователя (которые он представляет)
                        $this->security->userCounter('items', -1, $aItemData['agent_id']);
                    }
                    $this->ajaxResponse(($res ? Errors::SUCCESS : Errors::IMPOSSIBLE));
                }
                break;
                case 'item-users-autocomplete': # autocomplete
                {
                    if (!$this->haveAccessTo('items-listing')) {
                        $this->ajaxResponse(Errors::ACCESSDENIED);
                    }
                    $sQ = $this->input->post('q', TYPE_NOTAGS);
                    $aData = Users::model()->autocomplete($sQ);
                    $this->autocompleteResponse($aData, 'user_id', 'title');
                }
                    break;

            }

        }
        $this->ajaxResponse(Errors::IMPOSSIBLE);
    }

}