<?php
/**
 * @var $this Job
 */
tpl::includeJS('datepicker', true);
tplAdmin::adminPageSettings(array(
    'fordev' => array(
        array('title'=>'обновление ссылок всех записей', 'onclick'=>"return bff.confirm('sure', {r:'".$this->adminLink('vacancy_listing&act=items-links-rebuild')."'})", 'icon'=>'icon-check'),
    ),
));
?>

<div class="tabsBar" id="job-mod-tabs">
    <span class="tab <? if($f['status']==1) { ?>tab-active<? } ?>"><a href="#" onclick="return jobItems.onStatus(1, this);">Опубликованные</a></span>
    <span class="tab <? if($f['status']==3) { ?>tab-active<? } ?>"><a href="#" onclick="return jobItems.onStatus(3, this);">На модерацию</a></span>
    <span class="tab <? if($f['status']==2) { ?>tab-active<? } ?>"><a href="#" onclick="return jobItems.onStatus(2, this);">Заблокированные</a></span>
    <span class="tab <? if($f['status']==4) { ?>tab-active<? } ?>"><a href="#" onclick="return jobItems.onStatus(4, this);" class="disabled">Снятые с публикации</a></span>
    <div class="right"><div class="progress" style="display:none;" id="progress-job-items"></div></div>
    <div class="clear"></div>
 </div>

<form action="" method="get" name="filters" id="job-items-filters" onsubmit="return false;">
<input type="hidden" name="page" value="<?= $f['page'] ?>" />
<input type="hidden" name="order" value="<?= $f['order'] ?>" />
<input type="hidden" name="status" value="<?= $f['status'] ?>" />
<div class="actionBar">
    <div class="left" style="margin-right: 8px;">
        <? if( ! Geo::cityIsOne() ) { ?><select name="city" style="width:160px;" onchange="jobItems.onCity(this.value);"><?= Geo::cityOptions($f['city'], 'Все города') ?></select><? } ?>
        <select name="category" style="width:130px;" onchange="jobItems.onCategory(this.value);"><?= $this->categoriesOptions($f['category'], 'Все разделы', false); ?></select>
        <input style="width:100px;" type="text" maxlength="150" name="title" placeholder="Должность / ID"  value="<?= HTML::escape($f['title']) ?>" />
        <span style="margin-left: 5px;">Создано:&nbsp;<input type="text" name="p_from" value="<?= $f['p_from'] ?>" placeholder="от" style="width: 70px;" id="job-items-period-from" />&nbsp;<input type="text" name="p_to" value="<?= $f['p_to'] ?>" placeholder="до" style="width: 70px;" id="job-items-period-to" /></span>
        <? if($type == Job::TYPE_VACANCY): ?>
            <input style="width:90px;" type="text" maxlength="200" name="company" placeholder="ID организации"  value="<?= $f['company'] ? $f['company'] : '' ?>" />
        <? endif; ?>
     </div>
    <? if($type == Job::TYPE_RESUME): ?>
        <div class="left relative" style="margin-right: 8px;">
            <input type="hidden" name="user" id="items-listing-user-id" value="<?= $f['user'] ?>" />
            <input type="text" class="autocomplete" id="items-listing-user-title" style="width: 90px;" placeholder="<?= _t('', 'ID / login / email автора') ?>" value="<?= ($f['user']>0 ? $user_title : '') ?>" />
        </div>
    <? endif; ?>
    <div class="left">
        <input type="button" class="btn btn-small button cancel" onclick="jobItems.submit(true);" value="найти" />
        <a href="#" onclick="jobItems.resetFilter(); return false;"><i class="icon icon-refresh disabled"></i></a>
    </div>
</div>
</form>

<table class="table table-condensed table-hover admtbl tblhover">
<thead>
    <tr class="header">
        <th width="40">ID</th>
        <th class="left">Должность</th>
        <th width="135">
            <a href="javascript: jobItems.onOrder('created');" class="ajax">Создано</a>
            <div class="order-<?= $f['order_dir'] ?>" <? if($f['order_by']!='created') { ?>style="display:none;"<? } ?> id="job-order-created"></div>
        </th>
        <th width="110">Действие</th>
    </tr>
</thead>
<tbody id="job-items-list">
<?= $list ?>
</tbody>
</table>
<div id="job-items-pgn"><?= $pgn; ?></div>

<script type="text/javascript">
var jobItems = (function()
{
    var $progress, $list, $listPgn, filters;
    var url = '<?= $this->adminLink(bff::$event); ?>';
    var orders = <?= func::php2js($orders) ?>;
    var orderby = '<?= $f['order_by'] ?>';
    var status = <?= $f['status'] ?>;
    var _processing = false; 
    
    $(function(){
        $progress = $('#progress-job-items');
        $list     = $('#job-items-list');
        $listPgn  = $('#job-items-pgn');
        filters   = $('#job-items-filters').get(0);

        $list.on('click', 'a.item-del', function(){
            var id = intval($(this).attr('rel'));
            if(id>0) del( id, this );
            return false;
        });

        <? if($type == Job::TYPE_RESUME): ?>
        var urlAjax = '<?= $this->adminLink('ajax').'&act='; ?>';
        $('#items-listing-user-title').autocomplete( urlAjax+'item-users-autocomplete',
            {valueInput: '#items-listing-user-id', minChars: 2, width:250, params:{type:'resume'},
                onSelect: function(val, text){
                    setPage(1);
                    updateList();
                }});

        <? endif; ?>

        
        bff.datepicker('#job-items-period-from', {yearRange: '-3:+3'});
        bff.datepicker('#job-items-period-to', {yearRange: '-3:+3'});
              
    });
    
    function isProcessing()
    {
        return _processing;
    }
    
    function del(id, link)
    {
        bff.ajaxDelete('sure', id, url+'&act=delete&item_id='+id,
            link, {progress: $progress, repaint: false});
        return false;
    } 

    function updateList()
    {
        if(isProcessing()) return;
        _processing = true;
        $list.addClass('disabled');
        bff.ajax(url, $(filters).serializeArray(), function(data){
            if(data) {
                $list.html( data.list );
                $listPgn.html( data.pgn );
                
                var f = $(filters).serialize();
                if(bff.h) {
                    window.history.pushState({}, document.title, url + '&' + f);
                }
            }
            $list.removeClass('disabled');
            _processing = false;
        }, $progress);
    }
    
    function setPage(id)
    {
        filters.page.value = intval(id);
    }

    return {
        submit: function(resetPage)
        {
            if(isProcessing()) return false;
            if(resetPage === true) {
                setPage(1);
            }
            updateList();
        },
        resetFilter: function()
        {
            if(isProcessing()) return false;
            setPage(1);
            $(filters).find('[name="city"]').val(0);
            filters.category.value = 0;
            filters.title.value = '';
            filters.p_from.value = '';
            filters.p_to.value = '';
            updateList();
        },
        page: function (id)
        {
            if(isProcessing()) return false;
            setPage(id);
            updateList();
        }, 
        onCategory: function(id)
        {
            if(isProcessing()) return false;
            filters.category.value = intval(id);
            setPage(1);
            updateList();
            return false;
        },            
        onCity: function(id)
        {
            if(isProcessing()) return false;
            setPage(1);
            updateList();
            return false;
        }, 
        onOrder: function(by)
        {
            if(isProcessing() || !orders[by])
                return;
                
            orders[by] = (orders[by] == 'asc' ? 'desc' : 'asc');
            //hide prev order direction
            $('#job-order-'+orderby).hide();
            //show current order direction
            orderby = by;
            $('#job-order-'+orderby).removeClass('order-asc order-desc').addClass('order-'+orders[by]).show();
                
            filters.order.value = orderby+'-'+orders[by];
            setPage(1);
            
            updateList();
        }, 
        onStatus: function(statusNew, link) 
        {
            if(isProcessing() || status == statusNew) return false;
            status = statusNew;
            setPage(1);
            filters.status.value = statusNew;
            updateList();
            bff.onTab(link);
            return false;
        }
    };
}());
</script>