<?php
    $aData = HTML::escape($aData, 'html', array('title', 'company_title', 'company_post', 'fio', 'email'));

    $blocked = ($status == Job::STATUS_BLOCKED);
    
    if (empty($phones)){ $phones = array(0=>''); }
?>
<form method="post" action="" id="job-form" name="jobItemEditForm">
<input type="hidden" name="id" value="<?= $id; ?>" />
<input type="hidden" name="blocked" value="<?= ($blocked?1:0) ?>" />
<input type="hidden" name="type" value="resume" />
<table class="admtbl tbledit">
<tr>
    <td class="row1" width="90"><span class="field-title">Должность</span>: <span class="req">*</span></td>
    <td class="row2"><input type="text" name="title" class="stretch req" value="<?= $title; ?>" /></td>
</tr>
<tr>
    <td class="row1"><span class="field-title">Профессиональные навыки</span>: <span class="req">*</span></td>
    <td class="row2"><textarea name="description" style="height: 110px;" class="stretch req"><?= $description; ?></textarea></td>
</tr>
<tr>
    <td class="row1 field-title">Опыт работы <br />в данной должности<span class="req">*</span></td>
    <td class="row2"><select name="experience"><?= $this->getExperience($experience, 'options'); ?></select></td>
</tr>  
<tr>
    <td class="row1"><span class="field-title">Профессиональная сфера</span>: <span class="req">*</span></td>
    <td class="row2"><select name="cat_id" class="req"><?= $cats ?></select></td>
</tr> 
<tr>
    <td class="row1"><span class="field-title">Минимальная зарплата <br />(в месяц)</span>: <span class="req">*</span></td>
    <td class="row2">
        <input type="text" maxlength="9" name="price" class="req" value="<?= $price; ?>" style="width:120px;" pattern="[0-9]*" />
        <select name="price_curr" class="input-small"><?= $curr ?></select>
        <label class="checkbox inline f12"> <input type="checkbox" class="checkbox" name="price_torg" <? if($price_torg){ ?> checked="checked"<? } ?> /> по договоренности</label>
    </td>
</tr>
<tr>
    <td class="row1 field-title">График работы: <span class="req">*</span></td>
    <td class="row2"><?= $schedule_html ?></td>
</tr>
<tr>
    <td class="row1 field-title">Город, где я живу: <span class="req">*</span></td>
    <td class="row2">
        <?= Geo::cityOptionsSelect($city_id, true, 'city_id', array('class'=>'req')); ?>
        <label class="checkbox f12"><input class="checkbox" name="city_searchwork" <? if($city_searchwork){ ?> checked="checked"<? } ?> type="checkbox" /> Ищу работу в этом городе</label>
        <label class="checkbox f12"><input class="checkbox" type="checkbox" name="city_readytomove" <? if($city_readytomove){ ?> checked="checked"<? } ?> /> Готов к перезду</label>
    </td>
</tr>

<tr><td colspan="2"><hr class="cut" /><br /> <b>Образование и другие навыки:</b></td></tr> 

<tr>
    <td class="row1 field-title">Основное образование:</td>
    <td class="row2"><?= $this->getEducation($education, 'radio'); ?></td>
</tr>
<tr>
    <td class="row1 field-title">Знание ПК (уровень):</td>
    <td class="row2"><?= $this->getPCLevel($pclevel, 'radio'); ?></td>                    
</tr>

<tr><td colspan="2"><hr class="cut" /><br /> <b>Последнее место работы:</b></td></tr>    

<tr>
    <td class="row1 field-title">Название компании:</td>
    <td class="row2"><input type="text" name="company_title" value="<?= $company_title ?>" /></td>
</tr>                                  
<tr>
    <td class="row1 field-title">Должность:</td>
    <td class="row2"><input type="text" name="company_post" value="<?= $company_post ?>" /></td>
</tr>            
<tr>
    <td class="row1 field-title">Служебные обязанности:</td>
    <td class="row2"><textarea cols="25" rows="7" name="company_duty"><?= $company_duty ?></textarea></td>
</tr>   
<tr>
    <td class="row1 field-title">Период работы:</td>
    <td class="row2">
        <?
            $c_from = $this->getDateOptions( $company_from, 0, 1990  );
            $c_to = $this->getDateOptions( $company_to, 0, 1990  );
        ?>
        <p><span class="ss">с</span> <select style="margin-left: 8px;" name="company_from[day]" class="input-small"><?= $c_from['day'] ?></select> <select name="company_from[month]" class="input-small"><?= $c_from['month'] ?></select> <select name="company_from[year]" class="input-small"><?= $c_from['year'] ?></select></p>
        <p><span class="ss">по</span>  <select name="company_to[day]" class="input-small"><?= $c_to['day'] ?></select> <select name="company_to[month]" class="input-small"><?= $c_to['month'] ?></select> <select name="company_to[year]" class="input-small"><?= $c_to['year'] ?></select></p>
    </td>
</tr>

<tr><td colspan="2"><hr class="cut" /><br /> <b>Личные сведения:</b></td></tr>    

<tr>
    <td class="row1 field-title">ФИО: <span class="req">*</span></td>
    <td class="row2"><input name="fio" value="<?= $fio ?>" style="width:250px;" type="text" /></td>
</tr>
<tr>
    <td class="row1 field-title">Дата рождения: <span class="req">*</span></td>
    <? $birthdate = $this->getDateOptions( $birthdate, 10, 1940 ); ?>
    <td class="row2"><select name="birthdate[day]" class="input-small"><?= $birthdate['day'] ?></select> <select name="birthdate[month]" class="input-small"><?= $birthdate['month'] ?></select> <select name="birthdate[year]" class="input-small"><?= $birthdate['year'] ?></select></td>
</tr>
<tr>
    <td class="row1 field-title">Пол: <span class="req">*</span></td>
    <td class="row2">
        <label class="radio inline"><input type="radio" name="sex" value="<?= Users::SEX_MALE ?>" <? if($sex == Users::SEX_MALE){ ?> checked="checked"<? } ?> /> мужчина</label>
        <label class="radio inline"><input type="radio" name="sex" value="<?= Users::SEX_FEMALE ?>" <? if($sex == Users::SEX_FEMALE){ ?> checked="checked"<? } ?> /> женщина</label>
    </td>
</tr>
<tr>                   
    <td class="row1 field-title">Контактный телефон: <span class="req">*</span></td>
    <td class="row2">
        <div id="job-phones">
            <? foreach($phones as $k=>$v) { ?>
                <div class="phone-item"><input type="tel" maxlength="50" name="phones[<?= $k+1 ?>]" value="<?= HTML::escape($v) ?>" tabindex="5" />&nbsp;<? if(!$k){ ?><a href="#" class="ajax f12 phone-add">+ добавить</a><? } else { ?><a href="#" class="ajax phone-remove">- удалить</a><? } ?><div class="clear"></div></div>
            <? } ?>
        </div>    
    </td>
</tr>
<tr>
    <td class="row1 field-title">Email: </td>
    <td class="row2"><input type="text" name="email" value="<?= $email ?>" /></td>
</tr>   

<tr><td colspan="2"><hr class="cut" /></td></tr>  
  
<tr>
    <td class="row1 field-title">Пользователь:</td>
    <td class="row2"><a href="#" class="ajax<? if($user_blocked){ ?> block_s<? } ?>" onclick="return bff.userinfo(<?= $user_id ?>);"><?= $user_email ?></a></td>
</tr>
<tr><td colspan="2"><hr class="cut"></td></tr>
<tr class="row1">
    <td class="field-title">Статус:</td>
    <td><b><?
        switch ($status) {
            case Job::STATUS_NEW:           { echo 'Новое'; } break;
            case Job::STATUS_PUBLICATED:    { echo 'Публикуется'; } break;
            case Job::STATUS_PUBLICATED_OUT: { echo 'Период публикации завершился'; } break;
            case Job::STATUS_BLOCKED:       { echo ($moderated == 0?'Заблокировано (ожидает проверки)':'Заблокировано'); } break;
        }
    ?></b></td>
</tr>
<? if($status != Job::STATUS_NEW) { ?>
<tr>
    <td class="row1 field-title">Период публикации:</td>
    <td class="row2"><b><?= tpl::date_format2($publicated, true).' - '.tpl::date_format2($publicated_to, true); ?></b></td>
</tr>
<? } ?>
<tr>
    <td class="row1"></td>
    <td class="row2">
        <div class="warnblock<?= (!$blocked ? ' hidden':'') ?>" id="i_blocked_error" style="margin-bottom:10px;">
            <div class="warnblock-content">  
                <div><b>Причина блокировки</b>: <div class="right description" id="i_blocking_warn" style="display:none;"></div></div>
                <div class="clear"></div> 
                <div id="i_blocked">
                    <span id="i_blocked_text"><?= (!empty($blocked_reason) ? $blocked_reason :'?') ?></span> - <a href="#" onclick="jobEdit.changeBlocked(1,0); return false;" class="ajax description">изменить</a>
                </div>
                <div id="i_blocking" style="display: none;">
                    <textarea name="blocked_reason" id="i_blocking_text" class="autogrow" style="height:60px; min-height:60px;"
                        onkeyup="checkTextLength(300, this.value, $('#i_blocking_warn').get(0));"><?= $blocked_reason; ?></textarea>
                    <a onclick="return jobEdit.changeBlocked(3,1);" class="ajax" href="#"><?= (!$blocked ? 'продолжить':'изменить причину') ?></a>&nbsp;&nbsp;<a onclick="return jobEdit.changeBlocked(2);" class="ajax desc" href="#">отмена</a>
                </div> 
            </div>
        </div> 
        
        <div class="warnblock hidden" id="i_publicate2" style="margin-bottom:10px;">
            <div class="warnblock-content">                                 
                <table class="admtbl tbledit">
                <tr class="row1">
                    <td width="115" class="field-title">Период публикации:</td>
                    <td>
                    <script type="text/javascript"> 
                    <?  
                        $periods = $this->getPublicatePeriods();
                    ?>                        
                    var iPublicatePeriods = <?= func::php2js( $periods );  ?>;
                    </script>
                    <select class="inputText2" tabindex="1" name="period" onchange="$('#publicated2-till').html( iPublicatePeriods['dates'][this.value] );">
                        <?= $periods['options'] ?>
                    </select>
                    </td>
                </tr>
                <tr class="row1"><td class="field-title">Срок публикации:</td><td class="bold"><?= ($status == Job::STATUS_PUBLICATED_OUT ? 'с '.date('d.m.Y').' по ' : ' до ' ) ?><span id="publicated2-till"><?= $periods['dates'][1]; ?></span></td></tr>
                <tr class="row1"><td style="margin-bottom:10px;" colspan="2">
                    <a onclick="return jobEdit.publicate2(1);" class="ajax" href="#">опубликовать</a>&nbsp;&nbsp;<a onclick="return jobEdit.publicate2(2);" class="ajax desc" href="#">отмена</a>
                </td></tr>
                </table>   
            </div> 
        </div>           
    </td>
</tr>
<tr>
    <td class="row1" colspan="2">
        <input type="submit" class="btn btn-success button submit" value="сохранить" />
       <?
       if($moderated != 1 || $blocked) { ?>
            <input class="btn btn-success success button" type="button" onclick="jobEdit.approve();" value="<?= ($status == Job::STATUS_BLOCKED ? 'проверено, все впорядке' : 'проверено') ?>" />
       <? } else {
           if($status == Job::STATUS_PUBLICATED_OUT) {
                ?><input class="btn btn-success submit button" type="button" onclick="jobEdit.publicate2(0);" value="опубликовать" /><?
           } else if($status == Job::STATUS_PUBLICATED) {
                ?><input class="btn btn-success submit button" type="button" onclick="jobEdit.unpublicate();" value="снять с публикации" /><?
           }
       }
       if(!$blocked) { ?> 
           <input class="btn btn-danger delete button" onclick="jobEdit.changeBlocked(1,0,0); return false;" id="i_block_lnk" type="button" value="заблокировать" />
       <? } ?>
        <input type="button" class="btn button cancel" value="отмена" onclick="history.back();" />
        <div class="progress" style="margin: 8px 8px 0; display: none;" id="job-form-progress"></div>
    </td>
</tr>
</table>
</form>

<script type="text/javascript">
//<![CDATA[

    var jobEdit = (function()
    {
        var $form, $progress, id = 0, urlAjax = '<?= $this->adminLink('ajax&act=') ?>';

        $(function(){ init(); });

        function init()
        {
            id = <?= $id ?>;
            $form = $('#job-form');
            $progress = $('#job-form-progress', $form);

            $form.submit(function () {
                var error = false;
                $('input.req, select.req', this).each(function() {
                    var val = $(this).val();
                    if( $.trim(val) == '' || val == 0 || val === undefined || val == $(this).attr('placeholder')) {
                        error = true;
                    }
                });

                if(error) {
                    bff.error('Заполните все необходимые поля');
                } else {
                    bff.ajax(document.location, $form.serialize(), function(data, errors) {
                        if(data && data.res) {
                            history.back();
                        } else {
                            if(errors) {
                                bff.error( errors );
                            }
                        }
                    }, $progress);
                }
                return false;
            });

            initPhones( $('#job-phones', $form), 'phones', <?= sizeof($phones) ?>, 3);
        }

        function initPhones($block, fieldname, index, lmt)
        {
            var total = index;
            var $plus  = $('a.phone-add', $block.parent());

            $plus.click(function(){
                if(lmt>0 && total>=lmt) { return false; }
                index++; total++;
                $block.append('<div class="phone-item"><input type="text" maxlength="50" name="'+fieldname+'['+index+']" value="" />&nbsp;<a href="#" class="ajax f12 phone-remove">- удалить</a><div class="clear"></div></div>');
                return false;
            });

            $block.delegate('a.phone-remove', 'click', function(){
                $(this).parent().remove(); total--;
                return false;
            });
        }

        return {
            changeBlocked: function(step, block)
            {
                var form = $form.get(0);
                if(step==1){//заблокировать/изменить блокировку
                    $('#i_blocked', $form).hide();
                    $('#i_blocked_error, #i_blocking, #i_blocking_warn', $form).show(0, function(){
                        form['blocked_reason'].focus();
                    });
                } else if(step==2) {//отменить
                    if(form['blocked'].value == 1){
                        $('#i_blocking, #i_blocking_warn', $form).hide();
                        $('#i_blocked', $form).show();
                    } else {
                        $('#i_blocked_error, #i_blocking_warn', $form).hide();
                    }
                } else if(step==3) {//сохранить
                    bff.ajax(urlAjax+'item-block', $form.serialize(), function(data){
                        if(data)
                        {
                            if(!block){
                                $('#i_blocked_error, #i_blocking_warn', $form).hide();
                            } else {
                                $('#i_blocking_warn', $form).hide();
                                $('#i_blocked_text', $form).html(form['blocked_reason'].value);
                                $('#i_blocked_error', $form).show();
                                jobEdit.changeBlocked(2);
                            }
                            history.back();
                        }
                    }, $progress);
                }
                return false;
            },
            approve: function()
            {
                bff.ajax(urlAjax+'item-approve', $form.serialize(), function(data){
                    if(data) {
                       history.back();
                    }
                }, $progress);
            },
            unpublicate: function()
            {
                if( ! bff.confirm('sure')) return false;

                bff.ajax(urlAjax+'item-unpublicate', $form.serialize(), function(data){
                    if(data) {
                        history.back();
                    }
                }, $progress);
            },
            publicate2: function(step)
            {
                var $block = $('#i_publicate2', $form);
                if(step==0)
                {
                    $block.show();
                }
                else if(step==1) //сохранить
                {
                    bff.ajax(urlAjax+'item-publicate2', $form.serialize(), function(data){
                        if(data) {
                           history.back();
                        }
                    }, $progress);
                }
                else if(step==2) //отмена
                {
                    $block.hide();
                }
                return false;
            }
        };

    }());

//]]>
</script>