<?php
    $aData = HTML::escape($aData, 'html', array('title', 'company_title', 'company_addr', 'company_phone', 'company_email', 'company_contact'));

    $blocked = ($status == Job::STATUS_BLOCKED);
    $itemType = 'vacancy';
?>

<script type="text/javascript">                   
//<![CDATA[    

    var jobEdit = (function()
    {
        var $form, $progress, id = 0, urlAjax = '<?= $this->adminLink('ajax&act=') ?>';
                
        $(function(){ init(); });
        
        function init()
        {
            id = <?= $id ?>;
            $form = $('#job-form');
            $progress = $('#job-form-progress', $form);
            $form.submit(function () {
                var error = false;
                $('input.req, select.req', this).each(function() {
                    var val = $(this).val();
                    if( $.trim(val) == '' || val == 0 || val === undefined || val == $(this).attr('placeholder')) {
                        error = true;
                    }
                });            
                
                if(error) { 
                    bff.error('Заполните все необходимые поля');   
                } else {
                    bff.ajax(document.location, $form.serialize(), function(data, errors) {  
                        if(data && data.res) { 
                            history.back();
                        } else {
                            if(errors) {
                                bff.error( errors );
                            }
                        }
                    }, $progress); 
                }
                return false;
            }); 
        }    
        
        return {
            changeBlocked: function(step, block)
            {
                var form = $form.get(0);
                if(step==1){//заблокировать/изменить блокировку
                    $('#i_blocked', $form).hide();
                    $('#i_blocked_error, #i_blocking, #i_blocking_warn', $form).show(0, function(){
                        form['blocked_reason'].focus();    
                    }); 
                } else if(step==2) {//отменить
                    if(form['blocked'].value == 1){
                        $('#i_blocking, #i_blocking_warn', $form).hide();
                        $('#i_blocked', $form).show(); 
                    } else {
                        $('#i_blocked_error, #i_blocking_warn', $form).hide(); 
                    }
                } else if(step==3) {//сохранить
                    bff.ajax(urlAjax+'item-block', $form.serialize(), function(data){
                        if(data)
                        {
                            if(!block){                                                  
                                $('#i_blocked_error, #i_blocking_warn', $form).hide();
                            } else {
                                $('#i_blocking_warn', $form).hide();
                                $('#i_blocked_text', $form).html(form['blocked_reason'].value);
                                $('#i_blocked_error', $form).show();
                                jobEdit.changeBlocked(2);
                            }
                            history.back();
                        }
                    }, $progress);
                }
                return false;
            },
            approve: function()
            {
                bff.ajax(urlAjax+'item-approve', $form.serialize(), function(data){
                    if(data) { 
                       history.back();
                    }
                }, $progress);
            },
            unpublicate: function()
            {
                if( ! bff.confirm('sure')) return false;
                
                bff.ajax(urlAjax+'item-unpublicate', $form.serialize(), function(data){
                    if(data) {                               
                        history.back();
                    }
                }, $progress);
            },
            publicate2: function(step)
            {             
                var $block = $('#i_publicate2', $form);
                if(step==0)
                {
                    $block.show();
                }
                else if(step==1) //сохранить
                {
                    bff.ajax(urlAjax+'item-publicate2', $form.serialize(), function(data){
                        if(data) { 
                           history.back();
                        }
                    }, $progress);
                }
                else if(step==2) //отмена
                {
                    $block.hide();
                }
                return false;
            }
        };
                
    }()); 
    
//]]>       
</script>

<form method="post" action="" id="job-form" name="jobItemEditForm">
<input type="hidden" name="id" value="<?= $id; ?>" />
<input type="hidden" name="blocked" value="<?= ($blocked?1:0) ?>" />
<input type="hidden" name="type" value="vacancy" />
<table class="admtbl tbledit">
<tr>
    <td class="row1" width="90"><span class="field-title">Название должности</span><span class="required-mark">*</span>: </td>
    <td class="row2"><input type="text" name="title" class="stretch req" value="<?= $title; ?>" maxlength="200" /></td>
</tr>
<tr>
    <td class="row1"><span class="field-title">Описание вакансии</span><span class="required-mark">*</span>:</td>
    <td class="row2"><textarea name="description" style="height: 110px;" class="stretch req"><?= $description; ?></textarea></td>
</tr>
<tr>
    <td class="row1"><span class="field-title">Город</span><span class="required-mark">*</span>:</td>
    <td class="row2"><?= Geo::cityOptionsSelect($city_id, true, 'city_id', array('class'=>'req')); ?></td>
</tr>
<tr>
    <td class="row1"><span class="field-title">Сфера деятельности</span><span class="required-mark">*</span>:</td>
    <td class="row2"><select name="cat_id" class="req"><?= $cats ?></select></td>
</tr> 
<tr>
    <td class="row1"><span class="field-title">График работы</span><span class="required-mark">*</span>:</td>
    <td class="row2"><?= $schedule_html ?></td>
</tr>   
<tr>
    <td class="row1"><span class="field-title">Зарплата, от</span><span class="required-mark">*</span>:</td>
    <td class="row2">
        <input type="text" maxlength="9" name="price" class="req" value="<?= $price; ?>" style="width:120px;" pattern="[0-9]*" />
        <select name="price_curr" class="input-small"><?= $curr ?></select>
        <label class="f12 checkbox inline"> <input type="checkbox" class="checkbox" name="price_torg" <? if($price_torg){ ?> checked="checked"<? } ?> /> по договоренности</label>
    </td>
</tr>
<tr><td colspan="2"><hr class="cut"></td></tr>    
<tr>
    <td class="row1 field-title">Информация о работодателе:</td>
    <td>
        <input name="company_id" type="hidden" value="<?= $company_id ?>" />
        <? if(!empty($company_id)) { ?><a href="<?= Items::url('view', $item_link) ?>" class="but linkout" target="_blank"></a><a href="<?= $this->adminLink('items_edit&item_id='.$company_id, 'items') ?>"><?= $item_title ?></a><? } else { ?>
            <input type="text" class="stretch" name="company_title" value="<?= $company_title ?>" maxlength="200" /><? } ?>
        <br /><label class="checkbox inline"><input class="checkbox" type="checkbox" name="company_staffagency" <? if($company_staffagency){ ?> checked="checked"<? } ?> /> Кадровое агенство</label>
    </td>
</tr>
<tr>
    <td class="row1 field-title">Город<span class="required-mark">*</span>:</td>
    <td class="row2"><?= Geo::cityOptionsSelect($company_cityid, true, 'company_cityid'); ?></td>
</tr>       
<tr>
    <td class="row1 field-title">Адрес:</td>
    <td class="row2"><input type="text" name="company_addr" value="<?= $company_addr ?>" /></td>
</tr>     
<tr>
    <td class="row1 field-title">Телефон<span class="required-mark">*</span>:</td>
    <td class="row2"><input type="text" name="company_phone" class="req" value="<?= $company_phone ?>" /></td>
</tr> 
<tr>
    <td class="row1 field-title">Email<span class="required-mark">*</span>:</td>
    <td class="row2"><input type="text" name="company_email" class="req" value="<?= $company_email ?>" /></td>
</tr>    
<tr>
    <td class="row1 field-title">Контактное лицо<span class="required-mark">*</span>:</td>
    <td class="row2"><input type="text" name="company_contact" class="req" value="<?= $company_contact ?>" /></td>
</tr> 
<tr><td colspan="2"><hr class="cut"></td></tr>    
<tr>
    <td class="row1 field-title">Пользователь:</td>
    <td class="row2"><a href="#" class="ajax<? if($user_blocked){ ?> block_s<? } ?>" onclick="return bff.userinfo(<?= $user_id ?>);"><?= $user_email ?></a></td>
</tr>
<tr><td colspan="2"><hr class="cut"></td></tr>
<tr>
    <td class="row1 field-title">Статус:</td>
    <td class="row2"><b><?
        switch ($status) {
            case Job::STATUS_NEW:            { echo 'Новое'; } break;
            case Job::STATUS_PUBLICATED:     { echo 'Публикуется'; } break;
            case Job::STATUS_PUBLICATED_OUT: { echo 'Период публикации завершился'; } break;
            case Job::STATUS_BLOCKED:        { echo ($moderated == 0?'Заблокировано (ожидает проверки)':'Заблокировано'); } break;
        }
    ?></b></td>
</tr>
<? if($status != Job::STATUS_NEW) { ?>
<tr>
    <td class="row1 field-title">Период публикации:</td>
    <td class="row2"><b><?= tpl::date_format2($publicated, true).' - '.tpl::date_format2($publicated_to, true); ?></b></td>
</tr>
<? } ?>
<tr>
    <td class="row1"></td>
    <td class="row2">
        <div class="warnblock<?= (!$blocked ? ' hidden':'') ?>" id="i_blocked_error" style="margin-bottom:10px;">
            <div class="warnblock-content">  
                <div><b>Причина блокировки</b>: <div class="right description" id="i_blocking_warn" style="display:none;"></div></div>
                <div class="clear"></div> 
                <div id="i_blocked">
                    <span id="i_blocked_text"><?= (!empty($blocked_reason) ? $blocked_reason :'?') ?></span> - <a href="#" onclick="jobEdit.changeBlocked(1,0); return false;" class="ajax description">изменить</a>
                </div>
                <div id="i_blocking" style="display: none;">
                    <textarea name="blocked_reason" id="i_blocking_text" class="autogrow" style="height:60px; min-height:60px;"
                        onkeyup="checkTextLength(300, this.value, $('#i_blocking_warn').get(0));"><?= $blocked_reason; ?></textarea>
                    <a onclick="return jobEdit.changeBlocked(3,1);" class="ajax" href="#"><?= (!$blocked ? 'продолжить':'изменить причину') ?></a>&nbsp;&nbsp;<a onclick="return jobEdit.changeBlocked(2);" class="ajax desc" href="#">отмена</a>
                </div> 
            </div>
        </div> 
        
        <div class="warnblock hidden" id="i_publicate2" style="margin-bottom:10px;">
            <div class="warnblock-content">                                 
                <table class="admtbl tbledit">
                <tr class="row1">
                    <td width="115" class="field-title">Период публикации:</td>
                    <td>
                    <script type="text/javascript"> 
                    <?  
                        $periods = $this->getPublicatePeriods();
                    ?>                        
                    var iPublicatePeriods = <?= func::php2js( $periods );  ?>;
                    </script>
                    <select class="inputText2" tabindex="1" name="period" onchange="$('#publicated2-till').html( iPublicatePeriods['dates'][this.value] );">
                        <?= $periods['options'] ?>
                    </select>
                    </td>
                </tr>
                <tr class="row1"><td class="field-title">Срок публикации:</td><td class="bold"><?= ($status == Job::STATUS_PUBLICATED_OUT ? 'с '.date('d.m.Y').' по ' : ' до ' ) ?><span id="publicated2-till"><?= $periods['dates'][1]; ?></span></td></tr>
                <tr class="row1"><td style="margin-bottom:10px;" colspan="2">
                    <a onclick="return jobEdit.publicate2(1);" class="ajax" href="#">опубликовать</a>&nbsp;&nbsp;<a onclick="return jobEdit.publicate2(2);" class="ajax desc" href="#">отмена</a>
                </td></tr>
                </table>   
            </div> 
        </div>           
    </td>
</tr>
<tr>
    <td class="row1" colspan="2">
        <input type="submit" class="btn btn-success button submit" value="сохранить" />
       <?
       if($moderated != 1 || $blocked) { ?>
            <input class="btn btn-success success button" type="button" onclick="jobEdit.approve();" value="<?= ($status == Job::STATUS_BLOCKED ? 'проверено, все впорядке' : 'проверено') ?>" />
       <? } else {
           if($status == Job::STATUS_PUBLICATED_OUT) {
                ?><input class="btn btn-success submit button" type="button" onclick="jobEdit.publicate2(0);" value="опубликовать" /><?
           } else if($status == Job::STATUS_PUBLICATED) {
                ?><input class="btn btn-success submit button" type="button" onclick="jobEdit.unpublicate();" value="снять с публикации" /><?
           }
       }
       if(!$blocked) { ?> 
           <input class="btn btn-danger delete button" onclick="jobEdit.changeBlocked(1,0,0); return false;" id="i_block_lnk" type="button" value="заблокировать" />
       <? } ?>
        <input type="button" class="btn button cancel" value="отмена" onclick="history.back();" />
        <div class="progress" style="margin: 8px 8px 0; display: none;" id="job-form-progress"></div>
    </td>
</tr>
</table>

</form>