<?php
    
    $nType = Job::TYPE_RESUME;
            
    $aStatus = array (
        Job::STATUS_PUBLICATED => array('c'=>0, 't'=> _t('', 'Опубликованные'), 'i'=>array()),
        Job::STATUS_NEW        => array('c'=>0, 't'=> _t('', 'На модерации'), 'i'=>array()),
        Job::STATUS_BLOCKED    => array('c'=>0, 't'=>'<b>'._t('', 'Заблокированы').'</b>', 'i'=>array()),
    );
    foreach($items as $k=>$v) {
        $aStatus[$v['status']]['c']++;
        $aStatus[$v['status']]['i'][] = &$items[$k];
    }
    foreach($aStatus as $k=>$v)
    {
        if(!$v['c']) unset($aStatus[$k]);
    }
                                    
    function _profileList($aItems)
    {
        foreach($aItems as $v) 
        {
            $isBlocked = ($v['status'] == Job::STATUS_BLOCKED);
        ?>
        <tr class="item job<? if($v['marked']) { ?> svc-item-marked<? } elseif($v['fixed']) { ?> fixed<? } ?>">
            <td class="content">
                <a href="<?= Job::url('view', $v['link']) ?>"><?= $v['title'] ?></a>
                <div class="f12 mt5">
                    <span class="grey"><?= $v['cat_title'] ?></span><br/>
                    <span class="grey"><?= _t('', 'г.'); ?><?= $v['city_title'] ?></span><br/>
                    <span><?= tpl::date_format_spent($v['created'], false) ?></span>
                </div>
            </td>
            <td class="price">
                <div class="green"><b><?= ($v['price_torg'] ? _t('job','договорная') : _t('job','от').' '.tpl::formatPrice($v['price'], $v['price_curr'])) ?></b></div>
                <div class="f12 mt5 mb10 nowrap"><?= $v['fio']; ?>, <?= tpl::declension($v['years'], _t('','год;года;лет')) ?></div>
            </td>
            <td class="manage">
                <? if(bff::servicesEnabled() && $v['status'] == Job::STATUS_PUBLICATED){ ?><b><a href="#" onclick="jJobItemsPromote.promote(<?= $v['id'] ?>, $(this).closest('tr').find('td:first').html(), event); return false;" class="green"><i class="iconlink fa fa-arrow-up f14 green"></i><?= _t('', 'Продвинуть'); ?></a></b><br /><? } ?>
                <? if($v['status'] == Job::STATUS_NEW || ($isBlocked && !$v['moderated'])){ ?><i class="iconlink fa fa-lock f14 grey"></i><span class="grey"><?= _t('', 'Ожидает проверки'); ?></span><br />
                <? } else { ?><a href="<?= Job::url('resume.edit', array('id'=>$v['id'])) ?>"><i class="iconlink fa fa-edit f14 grey"></i><?= _t('', 'Редактировать'); ?></a><br /><? } ?>
                <a href="#" class="red" onclick="return profileJobResumeDel(<?= $v['id'] ?>, this)"><i class="iconlink fa fa-times f14 red"></i><?= _t('', 'Удалить'); ?></a><br />
                <span class="grey"><?= _t('', 'до'); ?> <?= tpl::date_format2($v['publicated_to'], false); ?></span>
            </td>
        </tr>                                                                                    
        <? 
        }   
    }
?>
<script type="text/javascript">
<? js::start(); ?>
function profileJobResumeFilter(type, link)
{
    $(link).parent().addClass('active').siblings().removeClass('active');
    $('#profile_job_resume_listing table').hide();
    $('#profile_job_resume_'+type).show();
    return false;
}
function profileJobResumeDel(id, link)
{
    if(!confirm('<?= _t('job', 'Вы действительно хотите удалить резюме?'); ?>')) return false;
    bff.ajax('<?= bff::urlAjax('job','item-del') ?>', {'id':id, type:<?= $nType ?>, hash:'<?= $this->security->getToken() ?>'}, function(data) {
        if(data) {
            $(link).parent().parent().slideUp(function(){
                $(this).remove();
            });
        }
    });
    return false;
}
<? js::stop(); ?>
</script>

<? if( sizeof($aStatus) > 1) { ?>
<ul class="val-sp u-sub-menu mb20">
    <? $i = false; 
    foreach($aStatus as $k=>$v) 
    { 
        if(!$v['c']) continue;
        echo '<li'.(!$i ?' class="active"':'').'><a href="#" onclick="return profileJobResumeFilter('.$k.', this);">'.$v['t'].'</a></li>';  
        $i = true;
    } ?>
</ul>
<? } ?>

<div id="profile_job_resume_listing" class="mb25" style="padding-left: 10px;">
<? 
$hide = false;
foreach($aStatus as $k=>$v) 
{
    if(!$v['c']) continue;
    ?>
    <div class="realty">
        <div class="realty-list">
            <table width="100%" id="profile_job_resume_<?= $k ?>"<? if($hide){ ?> style="display: none;"<? } ?>>
                <tbody>
                    <? _profileList($v['i']); ?>
                </tbody>
            </table>
        </div>
    </div>
    <? 
    $hide = true;
} ?>
</div>
<?
$aDataPromote = array('nTypeID' => Job::TYPE_RESUME);
echo $this->viewPHP($aDataPromote, 'promote.popup');
?>