<?php

use bff\db\Publicator;
use bff\utils\TextParser;

class Publications extends PublicationsBase
{
    protected $itemsTable = '';
    protected $typeTemplatesDir = '';

    /**
     * Главная: новости, фоторепортажи, статьи
     * bool $bForumPresent есть данные форума
     * @return array
     */
    public function indexBlock($bForumPresent = false)
    {
        $aTypes = $this->getTypes();

        $aData = array();
        $aData['cats'] = $this->categoriesGet($aTypes['news']);
        foreach ($aData['cats'] as &$v) {
            $v['url'] = static::url('category', array('type'=>self::TYPE_NEWS, 'keyword'=>$v['keyword']));
        } unset($v);

        # последние новости
        $nIndexNewsLimit = (int)config::sys('index.news.limit', 6); if ($nIndexNewsLimit<=0) $nIndexNewsLimit = 1;
        $aData['news'] = $this->db->select_key('SELECT I.id, I.img, I.comments, L.title, L.title_alt, L.content_short,
                    I.link, I.category_id as cat_id, I.content_type as ct, I.photos, I.publicated
                FROM '.$this->getItemsTable(self::TYPE_NEWS).' I, '.TABLE_PUB_ITEMS_LANG.' L
                WHERE I.enabled = 1 AND I.main = 1'.
                    ( $this->regionsFilterEnabled() ? ' AND I.city_id IN(0,'.Geo::cityID().')' : '' ).
                    $this->model->langAnd(self::TYPE_NEWS, true, 'I', 'L').'
            ORDER BY I.publicated DESC
            LIMIT '.$nIndexNewsLimit, 'id');
        if (!empty($aData['news'])) {
            foreach ($aData['news'] as &$v) {
                $v['img'] = $this->getImagesPath(true, array('id'=>$v['id'], 'publicated'=>$v['publicated'],
                            'filename'=>$v['img'], 'size'=>'i'), $aTypes['news']);
                $cat = &$aData['cats'][$v['cat_id']];
                $v['category'] = array('url'=>$cat['url'], 'title'=>$cat['title']);
                $v['url'] = static::url('view', $v['link']);
                $v['title'] = static::urlInTitle($v['title']);
                $v['content_short'] = tpl::truncate($v['content_short'], 150);
                $v['publicated'] = tpl::date_publicated($v['publicated']);
                $v['video'] = ($v['ct'] & self::contentTypeVideo) > 0;
                $v['last'] = false;
            } $v['last'] = true; unset($v, $cat); reset($aData['news']);
        }
        $aData['url_news_list'] = static::url('list', self::TYPE_NEWS);

        # фоторепортажи
        $nIndexReportsLimit = (int)config::sys('index.reports.limit', 8); if ($nIndexReportsLimit<=0) $nIndexReportsLimit = 1;
        $aData['reports'] = $this->db->select('SELECT I.id, I.img, I.comments, L.title, L.title_alt,
                    I.link, I.publicated, I.content_type as ct, I.photos
                FROM '.$this->getItemsTable(self::TYPE_REPORTS).' I, '.TABLE_PUB_ITEMS_LANG.' L
                WHERE I.enabled = 1 '.
                ( $this->regionsFilterEnabled() ? ' AND I.city_id IN(0,'.Geo::cityID().')' : '' ).
                $this->model->langAnd(self::TYPE_REPORTS, true, 'I', 'L').'
            ORDER BY I.publicated DESC
            LIMIT '.$nIndexReportsLimit);
        foreach ($aData['reports'] as &$v) {
            $v['img'] = $this->getImagesPath(true, array('id'=>$v['id'], 'publicated'=>$v['publicated'],
                    'filename'=>$v['img'], 'size'=>PublicationsImages::szNormal), $aTypes['reports']);
            $v['url'] = static::url('view', $v['link']);
            $v['title'] = static::urlInTitle($v['title']);
            $v['video'] = ($v['ct'] & self::contentTypeVideo) > 0;
            $v['publicated'] = tpl::date_publicated($v['publicated']);
        } unset($v);
        $reportCounter = sizeof($aData['reports']);
        $aData['reports_rotation'] = ($reportCounter > 3);
        $aData['reports_all'] = ($aData['reports_rotation'] || $reportCounter == 2);
        $aData['url_reports_list'] = static::url('list', self::TYPE_REPORTS);

        # статьи
        $articlesCats = $this->categoriesGet($aTypes['articles']);
        foreach ($articlesCats as &$v) {
            $v['url'] = static::url('category', array('type'=>self::TYPE_ARTICLES, 'keyword'=>$v['keyword']));
        } unset($v);
        $articles = $this->db->select('SELECT I.id, I.category_id as cat_id, L.title, L.title_alt, I.link, I.publicated
                FROM '.$this->getItemsTable(self::TYPE_ARTICLES).' I,
                     '.TABLE_PUB_ITEMS_LANG.' L
                WHERE I.enabled = 1 '.
                ( $this->regionsFilterEnabled() ? ' AND I.city_id IN(0,'.Geo::cityID().')' : '' ).
                $this->model->langAnd(self::TYPE_ARTICLES, true, 'I', 'L').'
            ORDER BY I.publicated DESC
            LIMIT '.($bForumPresent ? '6' : '12'));
        if (!empty($articles)) {
            $i = 1;
            foreach ($articles as &$v) {
                $v['url'] = static::url('view', $v['link']);
                $v['title'] = static::urlInTitle($v['title']);
                $v['publicated'] = tpl::date_publicated($v['publicated']);
                $v['cat'] = &$articlesCats[$v['cat_id']];
                if ($i == 3) { $v['last'] = true; $i = 1; } else { $v['last'] = false; $i++; }
            } $v['last'] = true; unset($v);
        }
        # 2 колонки по 3 записи
        $articles = array_chunk((!empty($articles) ? $articles : array()), 3);
        if (empty($articles)) { $articles = array(array(),array()); };
        if (sizeof($articles) == 1) { $articles[1] = array(); };
        $aData['articles'] = &$articles;
        $aData['url_articles_list'] = static::url('list', self::TYPE_ARTICLES);

        return $aData;
    }

    /**
     * Главная: новости компаний
     * @return mixed
     */
    public function indexCompanyNewsBlock()
    {
        $this->setCurrentType(self::TYPE_COMPANY);
        $aData['company'] = $this->model->itemsListCompany(0, false, 3);
        foreach($aData['company'] as &$v) {
            $v['link'] = static::url('view', $v['link']);
            $v['title'] = static::urlInTitle($v['title']);
        } unset($v);
        $aData['url_company_list'] = static::url('list', self::TYPE_COMPANY);

        return $this->viewPHP($aData, 'index.block', $this->typeTemplatesDir);
    }

    /**
     * Главная модуля(недвижимость): новости компаний
     * @return mixed
     */
    public function indexCompaniesInCatNewsBlock($nCatID)
    {
        $this->setCurrentType(self::TYPE_COMPANY);
        $aData['items'] = $this->model->itemsListCompanyCategory($nCatID, false, 5);
        if(empty($aData['items'])) return false;
        foreach($aData['items'] as &$v) {
            $v['link'] = static::url('view', $v['link']);
            $v['title'] = static::urlInTitle($v['title']);
            $v['img'] = $this->getImagesPath(true, array(
                'id'=>$v['id'], 'publicated'=>$v['publicated'],
                'filename'=>$v['img'], 'size'=>'n'));

        } unset($v);
        return $this->viewPHP($aData, 'listing.companies', $this->typeTemplatesDir);
    }

    /**
     * Главная: видео
     */
    public function indexBlockVideo()
    {
        $this->setCurrentType(self::TYPE_VIDEO);

        $aData = array('top'=>array());

        # категории
        $сatID = 0; # ID первой категории
        $aData['cats'] = $this->categoriesGet($this->type);
        foreach ($aData['cats'] as &$v) {
            if( ! $сatID) { $v['first'] = true; $сatID = $v['id']; }
            else { $v['first'] = false; }
            $v['url'] = static::url('category', array('type'=>self::TYPE_VIDEO, 'keyword'=>$v['keyword']));
            $v['last'] = false;
        } $v['last'] = true; unset($v);

        # видео дня
        $top = $this->db->one_array('
            SELECT I.id, I.category_id, L.title, L.title_alt, L.content_short, I.link,
                   I.comments, I.publicated, I.img, L.img_text
            FROM '.$this->getItemsTable(self::TYPE_VIDEO).' I, '.TABLE_PUB_ITEMS_LANG.' L
            WHERE I.enabled = 1 AND I.moderated = 1 '.
                ( $this->regionsFilterEnabled() ? ' AND I.city_id IN(0,'.Geo::cityID().')' : '' ).
                  $this->model->langAnd(self::TYPE_VIDEO, true, 'I', 'L').'
            ORDER BY I.extra_video_top DESC, I.publicated DESC
            LIMIT 1');
        if ( ! empty($top)) {
            $top['img'] = $this->getImagesPath(true, array(
                'id'=>$top['id'], 'publicated'=>$top['publicated'],
                'filename'=>$top['img'], 'size'=>'i'));
            $top['url'] = static::url('view', $top['link']);
            $top['title'] = static::urlInTitle($top['title']);
            $top['category'] = &$aData['cats'][$top['category_id']];
            $top['publicated'] = tpl::date_publicated($top['publicated']);
        }
        $aData['top'] = &$top;

        # видео из первой категории
        $aData['items'] = $this->indexBlockVideoItems($сatID, $top['id']);

        $aData['url_video_list'] = static::url('list', self::TYPE_VIDEO);

        return $this->viewPHP($aData, 'index', $this->typeTemplatesDir);
    }

    /**
     * Главная: видео записи в категории
     * @param int $catID ID категории
     * @param int $excludeItemID ID записи, которую следует пропустить
     * @return string HTML
     */
    protected function indexBlockVideoItems($catID = 0, $excludeItemID = 0)
    {
        $aData = array('catID' => $catID);
        $aData['items'] = $this->db->select('
            SELECT I.id, I.category_id, L.title, L.title_alt, L.content_short,
                   I.link, I.comments, I.publicated, I.img, L.img_text
            FROM '.$this->getItemsTable(self::TYPE_VIDEO).' I, '.TABLE_PUB_ITEMS_LANG.' L
            WHERE I.enabled = 1 AND I.moderated = 1 AND I.category_id = :cat AND I.id != :exclude '.
                ( $this->regionsFilterEnabled() ? ' AND I.city_id IN(0,'.Geo::cityID().')' : '' ).
                $this->model->langAnd(self::TYPE_VIDEO, true, 'I', 'L').'
            ORDER BY I.publicated DESC
            LIMIT 4', array(':cat' => $catID, ':exclude' => $excludeItemID));

        if ( ! empty($aData['items'])) {
            foreach ($aData['items'] as &$v) {
                $v['img'] = $this->getImagesPath(true, array(
                    'id'=>$v['id'], 'publicated'=>$v['publicated'],
                    'filename'=>$v['img'], 'size'=>PublicationsImages::szNormal));
                $v['url'] = static::url('view', $v['link']);
                $v['title'] = static::urlInTitle($v['title']);
                $v['publicated'] = tpl::date_publicated($v['publicated']);
            } unset($v);
        }

        return $this->viewPHP($aData, 'index.items', $this->typeTemplatesDir);
    }

    /**
     * Список всех записей выбранного типа публикаций
     * URL: /articles/, /reports/, ...
     */
    public function listing_all($typeID, $typeKey)
    {
        $nPerpage = 10;
        $bCompanyNews = false;
        $imgSize = PublicationsImages::szNormal;
        switch ($typeID) {
            case self::TYPE_NEWS: {
                return $this->news_all(); 
            } break;
            case self::TYPE_ARTICLES: {
            } break;
            case self::TYPE_REPORTS: {
                $nPerpage = 9;
            } break;
            case self::TYPE_NAROD: {
            } break;
            case self::TYPE_COMPANY: {
                $bCompanyNews = true;
            } break;
            case self::TYPE_VIDEO: {
                return $this->video_all();
            } break;
        }
        
        $nPage = $this->input->get('page', TYPE_UINT); if(!$nPage) $nPage = 1;

        $sql = array('I.enabled = 1');
        if ($this->regionsFilterEnabled()) $sql[] = 'I.city_id IN(0,'.Geo::cityID().')';
        if ($this->type->moderationPre()) $sql[] = 'I.moderated = 1';
        $sql = join(' AND ',$sql);

        $nTotal = $this->db->one_data('SELECT COUNT(*) FROM '.$this->itemsTable.' I WHERE '.$sql);
        $sPgn = $this->generatePagenationDots($nTotal, $nPerpage, 2, static::url('list', $this->type->id).'?page={page}', $sqlLimit);

        $aItems = $this->db->select('SELECT I.id, IL.title, IL.title_alt, I.link, I.publicated, I.img, IL.content_short, I.content_type,
                    CL.title as cat_title, C.keyword as cat_keyword, I.comments, I.photos'.($bCompanyNews ? ', I.company_id':'').'
                FROM '.$this->itemsTable.' I
                    LEFT JOIN '.TABLE_PUB_CATEGORIES.' C ON I.category_id = C.id
                    LEFT JOIN '.TABLE_PUB_CATEGORIES_LANG.' CL ON '.$this->db->langAnd(false, 'C', 'CL').',
                    '.TABLE_PUB_ITEMS_LANG.' IL
                WHERE '.$sql.' '.$this->model->langAnd($typeID, true, 'I', 'IL').'
                ORDER BY I.publicated DESC
                '.$sqlLimit);
        foreach($aItems as &$v)
        {
            $v['img'] = ($v['img'] ? $this->getImagesPath(true, array('id'=>$v['id'], 'publicated'=>$v['publicated'],
                        'filename'=>$v['img'], 'size'=>$imgSize)) : false);
            $v['link'] = static::url('view', $v['link']);
            $v['title'] = static::urlInTitle($v['title']);
            $v['cat_link'] = static::url('category', array('type'=>$typeID, 'keyword'=>$v['cat_keyword']));
            $v['video'] = ($v['content_type'] & self::contentTypeVideo) > 0;
            if ($bCompanyNews && $v['company_id']) {
                $v['company'] = Items::model()->companyData($v['company_id']);
            }
        } unset($v);

        $aData = array('items'=>&$aItems, 'page'=>$nPage, 'pgn'=>$sPgn, 'all'=>1);

        # SEO: Список (все разделы)
        $this->urlCorrection(static::url('list', array('type'=>$typeID)));
        $this->seo()->canonicalUrl(static::url('list', array('type'=>$typeID), true), array(
            'page' => $nPage
        ));
        $this->setMeta('list-'.$typeID, array(
            'region' => Geo::filter('title'),
            'page'   => $nPage,
        ), $aData);

        $this->setActiveMenu($typeID, $typeKey);
        $this->initRightblock(__FUNCTION__);
        return $this->viewPHP($aData, 'listing', $this->typeTemplatesDir);
    }

    /**
     * Список всех новостей: по Х записей из каждой категории
     * URL: /news/
     */
    protected function news_all()
    {
        $typeID = self::TYPE_NEWS;
        # по 4 новости из каждой категории
        $aCategories = $this->categoriesGet($this->type);
        $aItems = array();
        foreach($aCategories as $v){
            $aItems = array_merge($aItems, $this->db->select('
                 SELECT I.id, I.link, I.img, I.category_id, I.publicated, I.comments, I.content_type as ct, I.photos, L.title, L.title_alt
                 FROM '.$this->itemsTable.' I, '.TABLE_PUB_ITEMS_LANG.' L
                 WHERE I.enabled = 1 AND I.moderated = 1 AND I.category_id = :cat
                    '.( $this->regionsFilterEnabled() ? ' AND I.city_id IN(0,'.Geo::cityID().')' : '' ).
                    $this->model->langAnd($typeID, true, 'I', 'L').'
                 ORDER BY I.publicated DESC
                 LIMIT 4
            ', array(':cat' => $v['id'])));
        }

        if(!empty($aItems)) {
            $aItemsRes = array();
            $nCatID = 0;
            foreach($aItems as $v) {
                if($nCatID != $v['category_id']) {
                    $nCatID = $v['category_id'];
                    $v['img'] = $this->getImagesPath(true, array(
                        'id'=>$v['id'], 'publicated'=>$v['publicated'], 
                        'filename'=>$v['img'], 'size'=>PublicationsImages::szNormal)
                        );
                }
                $v['link'] = static::url('view', $v['link']);
                $v['title'] = static::urlInTitle($v['title']);
                $v['video'] = ($v['ct'] & self::contentTypeVideo) > 0;
                $aItemsRes[$v['category_id']][] = $v;
            } $aItems = $aItemsRes; unset($aItemsRes);
        } else $aItems = array();

        if( ! empty($aCategories) ) {
            foreach($aCategories as $k=>&$v) {
                if(!empty($aItems[$v['id']])) {
                    $v['items'] = $aItems[$v['id']];
                    $v['link'] = static::url('category', array('type'=>$typeID, 'keyword'=>$v['keyword']));
                } else {
                    unset($aCategories[$k]);
                }
            } unset($v);
        } unset($aItems);

        $aData = array(
            'categories' => &$aCategories,
        );

        # SEO: Список (все разделы)
        $this->urlCorrection(static::url('list', array('type'=>$typeID)));
        $this->seo()->canonicalUrl(static::url('list', array('type'=>$typeID), true));
        $this->setMeta('list-'.$typeID, array(
            'region' => Geo::filter('title'),
        ), $aData);

        $this->setActiveMenu($typeID, 'news');
        $this->initRightblock(__FUNCTION__);
        return $this->viewPHP($aData, 'listing.all', $this->typeTemplatesDir);
    }

    /**
     * Список всех видео: по X записей из каждой категории
     * URL: /video/
     */
    protected function video_all()
    {
        $typeID = self::TYPE_VIDEO;
        $aCategories = $this->categoriesGet($this->type);
        $aItems = array();
        foreach($aCategories as $v) {
            $aItems = array_merge($aItems, $this->db->select('
                SELECT I.id, L.title, L.title_alt, I.link, I.img, I.category_id, I.publicated, I.comments, L.content_short, I.content_type as ct, I.photos
                FROM '.$this->itemsTable.' I, '.TABLE_PUB_ITEMS_LANG.' L
                WHERE I.enabled = 1 AND I.moderated = 1 AND I.category_id = :cat
                     '.( $this->regionsFilterEnabled() ? ' AND I.city_id IN(0,'.Geo::cityID().')' : '' ).
                     $this->model->langAnd($typeID, true, 'I', 'L').'
                ORDER BY I.publicated DESC
                LIMIT 6
            ', array(':cat' => $v['id'])));
        }

        if( ! empty($aItems)) {
            $aItemsRes = array();
            foreach($aItems as $v) {
                $v['img'] = $this->getImagesPath(true, array(
                        'id'         => $v['id'],
                        'publicated' => $v['publicated'],
                        'filename'   => $v['img'],
                        'size'       => PublicationsImages::szNormal,
                ));
                $v['link'] = static::url('view', $v['link']);
                $v['title'] = static::urlInTitle($v['title']);
                $aItemsRes[$v['category_id']][] = $v;
            } $aItems = $aItemsRes; unset($aItemsRes);
        }

        if( ! empty($aCategories) ) {
            foreach($aCategories as $k => $v) {
                $v['link'] = static::url('category', array('type'=>$typeID, 'keyword'=>$v['keyword']));
                $aCategories[$k] = $v;
                if(!empty($aItems[$v['id']])) {
                    $aCategories[$k]['items'] = $aItems[$v['id']];
                } else {
                    unset($aCategories[$k]);
                }
            }
        } unset($aItems);
        $aData = array('categories' => &$aCategories);

        # SEO: Список (все разделы)
        $this->urlCorrection(static::url('list', array('type'=>$typeID)));
        $this->seo()->canonicalUrl(static::url('list', array('type'=>$typeID), true));
        $this->setMeta('list-'.$typeID, array(
            'region' => Geo::filter('title'),
        ), $aData);

        $this->setActiveMenu($typeID, $this->type->keyword);
        $this->initRightblock(__FUNCTION__);
        return $this->viewPHP($aData, 'listing.all', $this->typeTemplatesDir);
    }

    /**
     * Список публикаций раздела (категории)
     */
    public function listing_category($typeID, $typeKey)
    {
        $sCategory = $this->input->get('category', TYPE_NOTAGS);
        if ($sCategory == '') $this->redirect('/');
        $sCategory2 = '';
        if ($nPos = strpos($sCategory, '/')){
            $sCategory2 = substr($sCategory, $nPos + 1);
            $sCategory = substr($sCategory, 0, $nPos);
        }
        if ($sCategory2 && ! $this->type->subcategoriesEnabled()){
            $sCategory2 = '';
        }
        if ($this->type->categoriesCustomAndCommon()) # свои + общие
        {
            $aCategoryData = $this->db->one_array('SELECT C.*, CL.*
                                FROM '.TABLE_PUB_CATEGORIES.' C, '.TABLE_PUB_CATEGORIES_LANG.' CL, '.TABLE_PUB_CATEGORIES_IN.' CI
                                WHERE C.keyword = :cat AND C.enabled = 1
                                    AND C.id = CI.cat_id AND CI.type_id = :type AND CI.enabled = 1 '.$this->db->langAnd(true, 'C',  'CL'),
                                    array(':cat'=>$sCategory, ':type'=>$typeID));
        } else if( $this->type->categoriesCustomOnly() ) {
            $aCategoryData = $this->db->one_array('
                SELECT C.*, CL.*
                FROM '.TABLE_PUB_CATEGORIES.' C, '.TABLE_PUB_CATEGORIES_LANG.' CL
                WHERE C.keyword = :cat AND C.enabled = 1 AND C.type_id = :type '.
                $this->db->langAnd(true, 'C',  'CL'),
                    array(':cat'=>$sCategory, ':type'=>$typeID));
        } else {
            $aCategoryData = $this->db->one_array('
                SELECT C.*, CL.*
                FROM '.TABLE_PUB_CATEGORIES.' C, '.TABLE_PUB_CATEGORIES_LANG.' CL
                WHERE C.keyword = :cat AND C.enabled = 1 AND type_id = 0 '.
                $this->db->langAnd(true, 'C',  'CL'),
                    array(':cat'=>$sCategory));
        }

        if (empty($aCategoryData)) {
            $this->errors->error404();
        }

        if ($sCategory2) {
            $aCategory2Data = $this->db->one_array('
                SELECT C.id, C.keyword, CL.title, CL.titleh1, CL.mtitle, CL.mkeywords, CL.mdescription, C.mtemplate
                FROM '.TABLE_PUB_CATEGORIES.' C, '.TABLE_PUB_CATEGORIES_LANG.' CL
                WHERE C.keyword = :cat AND C.enabled = 1 AND pid = :pid '.
                $this->db->langAnd(true, 'C',  'CL'),
                array(':cat' => $sCategory2, ':pid' => $aCategoryData['id']));
            if( ! empty($aCategory2Data)){
                $aCategoryData['title'] .= ' / '. $aCategory2Data['title'];
                $aCategoryData['keyword'] .= '/'. $aCategory2Data['keyword'];
                foreach (array('titleh1', 'mtitle', 'mkeywords', 'mdescription', 'mtemplate') as $k) {
                    $aCategoryData[$k] = $aCategory2Data[$k];
                }
                # seo: не индексировать списки новостей в подкатегориях
                $this->seo()->robotsIndex(false);
            }
        }
        $nPerpage = 10;
        $imgSize = PublicationsImages::szNormal;
        $sTemplate = 'listing';
        switch ($typeID) {
            case self::TYPE_NEWS: {
                $sTemplate = 'listing.category';
            } break;
            case self::TYPE_ARTICLES: {
            } break;
            case self::TYPE_REPORTS: {
                $nPerpage = 9;
            } break;
            case self::TYPE_NAROD: {
            } break;
            case self::TYPE_VIDEO: {
                $nPerpage = 9;
            } break;
        }
                
        $nPage = $this->input->get('page', TYPE_UINT); if(!$nPage) $nPage = 1;

        $sql = array('I.enabled = 1', 'I.moderated = 1');
        if ( ! empty($aCategory2Data['id'])){
            $sql[] = 'I.category_id2 = '.$aCategory2Data['id'];
        } else {
            $sql[] = 'I.category_id = '.$aCategoryData['id'];
        }
        if ($this->regionsFilterEnabled()) $sql[] = 'I.city_id IN(0,'.Geo::cityID().')';
        $sql = join(' AND ',$sql);

        $nTotal = $this->db->one_data('SELECT COUNT(*) FROM '.$this->itemsTable.' I WHERE '.$sql);
        $sPgn = $this->generatePagenationDots($nTotal, $nPerpage, 2, static::url('category', array('type'=>$typeID, 'keyword'=>$sCategory)).'?page={page}', $sqlLimit);
        
        $aItems = $this->db->select('SELECT I.id, L.title, L.title_alt, I.link, I.publicated, I.img, L.content_short, I.content_type, I.comments, I.photos
                FROM '.$this->itemsTable.' I,
                     '.TABLE_PUB_ITEMS_LANG.' L
                WHERE '.$sql.$this->model->langAnd($typeID, true, 'I', 'L').'
                ORDER BY I.publicated DESC
                '.$sqlLimit);
        foreach($aItems as $k=>$v)
        {
            $v['img'] = ($v['img'] ? $this->getImagesPath(true, array('id'=>$v['id'], 'publicated'=>$v['publicated'],
                        'filename'=>$v['img'], 'size'=>$imgSize)) : false);
            $v['link'] = static::url('view', $v['link']);
            $v['title'] = static::urlInTitle($v['title']);
            $v['video'] = ($v['content_type'] & self::contentTypeVideo) > 0;
            $aItems[$k] = $v;
        }

        $aData = array('cat'=>&$aCategoryData, 'items'=>&$aItems, 'page'=>$nPage, 'all'=>0, 'pgn'=>$sPgn);

        # добавление публикации (народная новость, видео)
        $aData['addButt'] = User::id() && in_array($typeID, array(self::TYPE_NAROD, self::TYPE_VIDEO));

        # SEO: Список в разделе
        $this->urlCorrection(static::url('category', array('type'=>$typeID, 'keyword'=>$aCategoryData['keyword'])));
        $this->seo()->canonicalUrl(static::url('category', array('type'=>$typeID, 'keyword'=>$aCategoryData['keyword']), true), array(
            'page' => $nPage
        ));
        $this->setMeta('list-category', array(
            'region'   => Geo::filter('title'),
            'type'     => $this->type->title,
            'category' => $aCategoryData['title'],
            'page'     => $nPage,
        ), $aCategoryData);

        $this->initRightblock(__FUNCTION__, array('category'=> ! empty($aCategory2Data['id']) ? $aCategory2Data['id'] : $aCategoryData['id']) );
        if($typeID == self::TYPE_VIDEO){
            $this->setActiveMenu($typeID, $sCategory);
        }else{
            $this->setActiveMenu($typeID, $typeKey, true);
        }
        return $this->viewPHP($aData, $sTemplate, $this->typeTemplatesDir);
    }

    /**
     * Список всех типов публикаций, за указанную дату
     */
    public function listing_date()
    {
        $sDate = $this->input->get('date', TYPE_NOTAGS);
        $nDate = $this->_checkDate($sDate);
        if($nDate === false) $this->errors->error404();

        $aItems = array();
        foreach($this->getTypes() as $type)
        {
            $aItems[$type->id] = $this->db->select('
                SELECT I.id, IL.title, I.link, I.img, I.publicated, UNIX_TIMESTAMP(I.publicated) as publicated_n,
                    IL.content_short, I.content_type, CL.title as cat_title, C.keyword as cat_keyword
                FROM '.$type->table().' I,
                     '.TABLE_PUB_ITEMS_LANG.' IL,
                     '.TABLE_PUB_CATEGORIES.' C,
                     '.TABLE_PUB_CATEGORIES_LANG.' CL
                WHERE '.( $this->regionsFilterEnabled() ? ' city_id IN(0,'.Geo::cityID().') AND ' : '').
                      ' DATE(I.publicated) = :date AND I.enabled = 1 AND I.moderated = 1 AND I.category_id = C.id '.
                      $this->model->langAnd($type->id, true, 'I', 'IL').
                      $this->db->langAnd(true, 'C', 'CL').'
                ORDER BY I.publicated DESC
            ', array(':date'=>date('Y-m-d', $nDate)));
            foreach($aItems[$type->id] as &$v){
                $v['link'] = static::url('view', $v['link']);
                $v['title'] = static::urlInTitle($v['title']);
                $v['cat_link'] = static::url('category', array('type'=>$type->id, 'keyword'=>$v['cat_keyword']));
                $v['img'] = ($v['img'] ? $this->getImagesPath(true, array('id'=>$v['id'], 'publicated'=>$v['publicated'],
                            'filename'=>$v['img'], 'size'=>PublicationsImages::szNormal), $type) : false);
            } unset($v);
        }
        $aData = array('items'=>&$aItems, 'date'=>date('d.m.Y', $nDate));

        # SEO:
        $this->urlCorrection(static::url('date', array('type'=>self::TYPE_NEWS, 'date'=>$nDate)));
        $this->seo()->canonicalUrl(static::url('date', array('type'=>self::TYPE_NEWS, 'date'=>$nDate), true));
        $this->setMeta('list-date', array(
            'region' => Geo::filter('title'),
            'date'   => tpl::date_format2($nDate, false, false, ' ', ', ', true),
            'date2'  => tpl::date_format2($nDate, false, false),
            'date3'  => tpl::dateFormat($nDate),
        ), $aData);

        $this->initRightblock( __FUNCTION__, array('date'=>$nDate) );
        $this->setActiveMenu(self::TYPE_NEWS);
        return $this->viewPHP($aData, 'common.listing.date');
    }

    /**
     * Просмотр публикации
     */
    public function view($typeID, $typeKey)
    {
        $nItemID = $this->input->get('item', TYPE_UINT);
        if(Request::isAJAX())
        {
            $sAction = $this->input->get('act');
            if(!$nItemID) {
                $sAction = '?';
            }

            $aResponse = array();
            switch ($sAction)
            {
                case 'comment-add': # добавление комментария
                {
                    if ( ! $this->security->validateToken()) {
                        $this->errors->reloadPage(); break;
                    }

                    $nParentCommentID = $this->input->post('reply', TYPE_UINT);
                    $sMessage = $this->input->post('message', TYPE_STR);
                    $oTextParser = new TextParser();
                    $sMessage = $oTextParser->parseCommentPlain($sMessage, 3000);
                    if (strlen($sMessage) < 5) {
                        $this->errors->set(_t('pub', 'Минимальная длина текста комментария: 5 символов')); break;
                    }

                    $oComments = $this->itemComments($typeID);
                    $nCommentID = $oComments->commentInsert($nItemID, array('message' => $sMessage), $nParentCommentID);
                    $aResponse['comment_id'] = $nCommentID;
                    $aResponse['total'] = $oComments->commentsTotal($nItemID);
                } break;
                case 'comment-response':
                {
                    $nCommentLastID = $this->input->post('comment_id_last', TYPE_UINT);
                    $oComments = $this->itemComments($typeID);
                    $aResponse = $oComments->commentsDataFront($nItemID, $nCommentLastID);
                    $aResponse['aComments'] = tpl::commentsBlock($aResponse['aComments'], true, $oComments);
                } break;
                default: {
                    $this->errors->reloadPage();
                } break;
            }
            
            $this->ajaxResponseForm($aResponse);
        }
        
        if( ! $nItemID) $this->errors->error404();
        
        $bPrint = $this->input->get('print', TYPE_BOOL);
        $bCompanyNews = ($typeID == self::TYPE_COMPANY);
        
        $aData = $this->db->one_array('
            SELECT I.id, I.category_id, CL.title as cat_title, IL.title, IL.title_alt, I.link, IL.author, I.comments, I.views, I.publicated,
                        I.img, IL.img_text, I.content as content_publicator, IL.content, IL.content_short, I.content_type,
                        IL.mtitle, IL.mkeywords, IL.mdescription, I.mtemplate, IL.share_title, IL.share_description, IL.share_sitename,
                        I.extra_source_link'.($bCompanyNews ? ', I.company_id':'').'
            FROM '.$this->itemsTable.' I
                 LEFT JOIN '.TABLE_PUB_CATEGORIES.' C ON I.category_id = C.id
                 LEFT JOIN '.TABLE_PUB_CATEGORIES_LANG.' CL ON '.$this->db->langAnd(false, 'C', 'CL').',
                 '.TABLE_PUB_ITEMS_LANG.' IL
            WHERE I.id = :id AND I.enabled = 1'.($this->type->moderationPre() ? ' AND I.moderated = 1 ' : '').
                $this->model->langAnd($typeID, true, 'I', 'IL'),
            array(':id'=>$nItemID));
        if (empty($aData)) $this->errors->error404();
        $aData['title'] = static::urlInTitle($aData['title']);

        if( $this->type->authorUser() && ! empty($aData['user_id']) && $aData['user_id'] > 0 ) {
            $aUserData = $this->users()->model->userData($aData['user_id'], array('name','surname'));
            if( ! empty($aUserData) ) {
                $aData['author'] = $aUserData['name'].' '.$aUserData['surname'];
            }
        }

        # схожие публикации: получаем по пересекающимся тегам
        $aData['related'] = $this->db->select('SELECT I.id, IL.title, COUNT(*) AS cnt
            FROM '.$this->itemsTable.' AS I,
                 '.TABLE_PUB_ITEMS_LANG.' IL,
                 '.TABLE_PUB_TAGS_IN.' AS T
            WHERE I.id != :id AND I.enabled = 1 AND I.moderated = 1
              AND I.id = T.item_id
              AND T.tag_id IN (SELECT tag_id FROM '.TABLE_PUB_TAGS_IN.' WHERE item_id = :id AND type_id = :type)
              '.
              ( $this->regionsFilterEnabled() ? ' AND I.city_id IN(0,'.Geo::cityID().')' : '' ).
              $this->model->langAnd($typeID, true, 'I', 'IL').'
            GROUP BY I.id
            ORDER BY cnt DESC, I.publicated DESC
            LIMIT 4', array(':id'=>$nItemID,':type'=>$typeID));
        if (!empty($aData['related'])) {
            foreach ($aData['related'] as &$v) {
                $v['title'] = static::urlInTitle($v['title']);
            } unset($v);
        }

        # накручиваем счетчик просмотров
        $this->model->itemViewsUpdate($nItemID, $typeID);

        $imgSize = PublicationsImages::szNormal;
        switch ($typeID) {
            case self::TYPE_NAROD: {
                $imgSize = false; # нет изображения в народных новостях
            } break;
            case self::TYPE_VIDEO: {
                $aData['content_short'] = '';
                $aData['noPrint'] = 1;
            } break;
            case self::TYPE_COMPANY: {
                $aData['company_data'] = Items::model()->companyData($aData['company_id']);
            } break;
        }
        $aData['nTypeID'] = $typeID;
        if( ! empty($aData['img'])) {
            $aData['img_small'] = $this->getImagesPath(true, array('id'=>$nItemID, 'publicated'=>$aData['publicated'],
                    'filename'=>$aData['img'], 'size'=>$imgSize));
            $aData['img'] = $this->getImagesPath(true, array('id'=>$nItemID, 'publicated'=>$aData['publicated'],
                    'filename'=>$aData['img'], 'size'=>$imgSize));
        }
        
        $aData['extra_source_link'] = func::unserialize($aData['extra_source_link']);

        $aData['title'] = strip_tags($aData['title']);
        $aTags = $this->db->select_one_column('SELECT T.tag FROM '.TABLE_PUB_TAGS_IN.' TI, '.TABLE_PUB_TAGS.' T 
                    WHERE TI.item_id = :item AND TI.type_id = :type
                      AND TI.tag_id = T.id', array(':item'=>$nItemID, ':type'=>$typeID));

        # SEO: Просмотр публикации
        $this->urlCorrection(static::urlDynamic($aData['link']));
        $this->seo()->canonicalUrl($aData['link']);
        $aData['link'] = static::url('view', $aData['link']);
        $this->setMeta('view', array(
            'title'       => $aData['title'],
            'description' => tpl::truncate($aData['content_short'], 150),
            'tags'        => ( ! empty($aTags) ? join(', ', $aTags) : '' ),
            'type'        => $this->type->title,
            'region'      => Geo::filter('title'),
        ), $aData);
        $this->seo()->setSocialMetaOG($aData['share_title'], $aData['share_description'], array($aData['img']), $aData['link'], $aData['share_sitename']);
        
        if ($bPrint) {
            View::setLayout('print');
            return $this->viewPHP($aData, 'common.view.print');
        }

        if ($this->type->commentsEnabled()) {
            $oComments = $this->itemComments($typeID);
            $aData['comments'] = tpl::commentsBlock($oComments->commentsDataFront($nItemID), false, $oComments);
        } else {
            $aData['comments'] = '';
        }

        tpl::includeJS(array('publicator/gallery'), true);
        $this->setActiveMenu($typeID, $typeKey, true);
        $this->initRightblock(__FUNCTION__, array('category'=>$aData['category_id'], 'hover'=>true) );
        return $this->viewPHP($aData, 'common.view');
    }

    /**
     * Формируем закладку профиля "Народные новости"
     * @param integer $nUserID id пользователя
     * @param boolean $bOnlyCheck только проверяем есть у пользователя ($nUserID) добавленные и промодерированные новости
     */
    public function narod_profile($nUserID, $bOnlyCheck = false)
    {
        if( ! $nUserID) return false;
        
        $this->setCurrentType(self::TYPE_NAROD);
        
        $aData = array('form'=>false);
        
        $nPage = $this->input->get('page', TYPE_UINT); if(!$nPage) $nPage = 1;
        
        # считаем кол-во добавленных и промодерированных новостей
        $nTotal = $this->db->one_data('SELECT COUNT(*) FROM '.$this->itemsTable.' WHERE enabled = 1 AND moderated = 1 AND user_id = '.$nUserID);
        if ($bOnlyCheck) {
            # возвращаем факт их наличия
            return ( $nTotal > 0 );
        } else {
            if (!$nTotal) {
                # новостей нет - закладки тоже нет
                return false;
            }
        }

        $aData['pgn'] = $this->generatePagenationDots($nTotal, 10, 2, Users::url('my.profile.tab', array('tab'=>'narod')).'&page={page}', $sqlLimit);
        
        $aData['items'] = $this->db->select('
            SELECT I.id, IL.title, I.link, I.publicated, I.img, IL.content_short, I.content_type,
                    CL.title as cat_title, C.keyword as cat_keyword
            FROM '.$this->itemsTable.' I,
                 '.TABLE_PUB_ITEMS_LANG.' IL,
                 '.TABLE_PUB_CATEGORIES.' C,
                 '.TABLE_PUB_CATEGORIES_LANG.' CL
            WHERE  I.user_id = '.$nUserID.' AND I.enabled = 1 AND I.moderated = 1 AND I.category_id = C.id'.
                $this->model->langAnd(self::TYPE_NAROD, true, 'I', 'IL').
                $this->db->langAnd(true, 'C', 'CL').'
            ORDER BY I.publicated DESC
            '.$sqlLimit);

        foreach ($aData['items'] as &$v) {
            $v['img'] = ($v['img'] ? $this->getImagesPath(true, array('id'=>$v['id'], 'publicated'=>$v['publicated'],
                        'filename'=>$v['img'], 'size'=>PublicationsImages::szNormal)) : false);
            $v['link'] = static::url('view', $v['link']);
            $v['title'] = static::urlInTitle($v['title']);
        } unset($v);
        
        $aData['addButt'] = User::isCurrent($nUserID) && $nTotal>0;

        bff::setMeta(_t('pub', 'Мои новости - Кабинет'));
        return $this->viewPHP($aData, 'profile.listing', $this->typeTemplatesDir);
    }

    /**
     * Народные новости: публикация пользователем
     */
    public function narod_submit()
    {
        $this->setCurrentType(self::TYPE_NAROD);

        if (Request::isPOST()) {
            do {
                if (!User::id()) {
                    $this->errors->accessDenied();
                    break;
                }
                $act = $this->input->postget('act', TYPE_STR);
                switch($act){
                    case 'img-upload':
                        $nItemID = $this->input->postget('id', TYPE_UINT);
                        if ($nItemID > 0) {
                            # todo редактировать нельзя
                            break;
                        }
                        if ( ! $this->security->validateReferer()) {
                            $this->errors->set(_t('','Ошибка загрузки фотографии'));
                            break;
                        }
                        $oPublicator = $this->initPublicator(array('id' => $nItemID));
                        $aResult = $oPublicator->uploadImageQQ($nItemID);
                        $aResult['success'] = $this->errors->no();
                        $aResult['errors'] = $this->errors->get(true);
                        $this->ajaxResponse($aResult, true, false, true);
                        break;
                    case 'img-delete':
                        $nItemID = $this->input->post('id', TYPE_UINT);
                        $aPhotos = $this->input->post('filename', TYPE_ARRAY_STR);
                        if (!empty($aPhotos)) {
                            $oPublicator = $this->initPublicator(array('id' => $nItemID));
                            $oPublicator->imagesDelete($aPhotos, $nItemID);
                        }
                        $this->ajaxResponse($this->errors->no());
                        break;
                    case 'save':
                        $p = $this->input->postm(array(
                            'cat'      => TYPE_UINT,
                            'city_id'  => TYPE_UINT,
                            'title'    => array(TYPE_NOTAGS, 'len' => 150),
                            'content'  => array(TYPE_STR, 'len' => 30000),
                            'filename' => TYPE_ARRAY_STR,
                        ));
                        extract($p);

                        if (!$this->security->validateToken()) {
                            $this->errors->accessDenied();
                            break;
                        }

                        if (!$cat) {
                            $this->errors->set(_t('pub', 'Укажите рубрику'));
                        }

                        if (empty($title)) {
                            $this->errors->set(_t('pub', 'Укажите заголовок'), 'title');
                        }

                        $parser = new \bff\utils\TextParser();
                        $content = $parser->parseWysiwygTextFrontend($content);
                        if (mb_strlen(strip_tags($content)) <= 10) {
                            $this->errors->set(_t('pub', 'Укажите текст новости'));
                        }

                        if (!$this->errors->no()) break;

                        if (Site::i()->preventSpam('pub-submit-narod', 60)) {
                            break;
                        }

                        $aData = array(
                            'publicated' => $this->db->now(),
                            'moderated' => 0,
                            'enabled' => 0,
                            'user_id' => User::id(),
                            'title' => array(),
                            'link' => '',
                            'category_id' => $cat,
                            'country_id' => Geo::defaultCountry(),
                            'city_id' => $city_id,
                        );

                        foreach ($this->locale->getLanguages() as $lng) {
                            $aData['title'][$lng] = $title;
                        }

                        # обворачиваем текст новости и фотографии в публикатор
                        $oPublicator = $this->initPublicator(array('id' => 0));

                        # первый блок с текстом для Publicator
                        $aData['content'] = array('b' => array());
                        $aData['content']['b'][1] = array('text' => array(LNG => $content), 'type' => Publicator::blockTypeText);
                        foreach ($this->locale->getLanguages() as $lang) {
                            if (!isset($aData['content']['b'][1]['text'][$lang])) {
                                $aData['content']['b'][1]['text'][$lang] = '';
                            }
                        }

                        if( ! empty($filename)){
                            # второй блок с фотографиями для Publicator
                            $aData['content']['b'][2] = array('type' => Publicator::blockTypeGallery, 'p' => array());
                            $l = array();
                            foreach ($this->locale->getLanguages() as $lang) {
                                $l[$lang] = '';
                            }
                            foreach($filename as $k => $v){
                                $aData['content']['b'][2]['p'][$k+1]['photo'] = $v;
                                $aData['content']['b'][2]['p'][$k+1]['text'] = $l;
                            }
                        }
                        $aPublicatorData = $oPublicator->dataPrepare($aData['content'], 0);
                        $aData['content'] = $aPublicatorData['content'];
                        $aData['content_search'] = $aPublicatorData['content_search'];
                        $aData['content_type'] = $this->updateContentType($aPublicatorData);

                        unset($this->model->langItems['content']);

                        $nItemID = $this->model->itemSave(0, $aData);
                        if (!$nItemID) break;

                        if (!empty($filename)) {
                            # переносим фотографии публикатора из временной папки в постоянную
                            $sPath = $this->getImagesPath(false, array('id' => $nItemID, 'publicated' => $aData['publicated']));
                            $sPreviewFileName = $oPublicator->imagesUnTemp($filename, $nItemID, $sPath, true);

                            if (!empty($sPreviewFileName)) {
                                # загружаем изображение
                                $oImages = $this->initImages(array(
                                    'id' => $nItemID,
                                    'publicated' => $aData['publicated'],
                                ));
                                if ($oImages!==false) {
                                    $aResult = $oImages->uploadFromFile($sPreviewFileName);
                                    if($aResult){
                                        $oImages->update($aResult);
                                    }
                                }
                            }
                        }

                        if ($this->prepareItemTitle($nItemID, $aData)) {
                            $this->model->itemSave($nItemID, array(
                                'title' => $aData['title'],
                                'title_params' => $aData['title_params'],
                                'link' => $aData['link']));
                        }

                        $this->security->userCounter('narod', 1);
                        $this->itemsModerationCounter(self::TYPE_NAROD, 1);
                        break;
                }

            } while (false);

            $this->iframeResponseForm();
        }

        $aData = array();
        $oPublicator = $this->initPublicator(array('id' => 0));
        $aData['settings'] = $oPublicator->getSettings(false);
        $this->setActiveMenu($this->type->id, $this->type->keyword);
        $this->initRightblock('listing_all');
        return $this->viewPHP($aData, 'form', $this->typeTemplatesDir);
    }

    /**
     * Видео: публикация пользователем
     */
    public function video_submit()
    {
        $this->setCurrentType(self::TYPE_VIDEO);

        if(Request::isPOST()) {
            $response = array();

            do {
                if (!User::id()) {
                    $this->errors->reloadPage();
                    break;
                }


                $p = $this->input->postm(array(
                    'cat' => TYPE_UINT,
                    'title' => array(TYPE_NOTAGS, 'len' => 150),
                    'content' => array(TYPE_NOTAGS, 'len' => 5000),
                    'video' => TYPE_STR,
                ));
                extract($p);

                if (!$this->security->validateToken()) {
                    $this->errors->reloadPage();
                    break;
                }

                if (!$cat) {
                    $this->errors->set(_t('pub', 'Укажите рубрику'));
                }
                if (empty($title)) {
                    $this->errors->set(_t('pub', 'Укажите заголовок'), 'title');
                }
                if (empty($video)) {
                    $this->errors->set(_t('pub', 'Укажите код видео'));
                    break;
                }

                # не чаще чем раз в 60 секунд
                if (Site::i()->preventSpam('pub-submit-video', 60)) {
                    break;
                }

                $videoData = PublicationsVideo::validate($video);
                if (empty($videoData['embed_url'])) {
                    $this->errors->set(_t('pub', 'Укажите корректный код видео'));
                }

                if (!$this->errors->no()) break;

                $aData = array(
                    'publicated' => $this->db->now(),
                    'moderated' => 0,
                    'enabled' => 0,
                    'user_id' => User::id(),
                    'category_id' => $cat,
                    'title' => array(),
                    'link' => '',
                    'city_id' => 0,
                );
                foreach ($this->locale->getLanguages() as $lng) {
                    $aData['title'][$lng] = $title;
                }

                # обворачиваем видео и описание в публикатор
                $oPublicator = $this->initPublicator(array('id' => 0));
                $aData['content'] = array('b' => array(
                    1 => array(
                        # блок с видео:
                        'type' => Publicator::blockTypeVideo,
                        'source' => $videoData['provider_name'],
                        'video' => $videoData['flash_url'],
                    ),
                    2 => array(
                        # блок с описанием:
                        'type' => Publicator::blockTypeText,
                        'text' => array(),
                    ),
                ));

                # заполняем все языковые варианты:
                foreach ($this->locale->getLanguages() as $lng) {
                    $aData['content']['b'][2]['text'][$lng] = $content;
                }

                $aPublicatorData = $oPublicator->dataPrepare($aData['content'], 0);
                $aData['content'] = $aPublicatorData['content'];
                $aData['content_search'] = $aPublicatorData['content_search'];
                $aData['content_type'] = $this->updateContentType($aPublicatorData);

                unset($this->model->langItems['content']);

                $nItemID = $this->model->itemSave(0, $aData);
                if (!$nItemID) {
                    $this->errors->reloadPage();
                    break;
                }

                if (!empty($videoData['thumbnail_url'])) {
                    $oImages = $this->initImages(array('id' => $nItemID, 'publicated' => $aData['publicated']));
                    PublicationsVideo::downloadImage($videoData['thumbnail_url'], $oImages);
                }

                if ($this->prepareItemTitle($nItemID, $aData)) {
                    $this->model->itemSave($nItemID, array(
                        'title' => $aData['title'],
                        'title_params' => $aData['title_params'],
                        'link' => $aData['link'],
                    ));
                }

                User::counterSave('video', 1, true);
                $this->itemsModerationCounter(self::TYPE_VIDEO, 1);

            } while (false);

            $this->ajaxResponseForm($response);
        }

        $aData = array('cat' => array('id' => $this->input->get('cat', TYPE_UINT)));
        $this->setActiveMenu($this->type->id);
        $this->initRightblock('listing_all');
        return $this->viewPHP($aData, 'form', $this->typeTemplatesDir);
    }

    /**
     * Новости компаний: публикация пользователем
     */
    public function company_submit()
    {
        do {
            if ( ! ($userID = User::id())) {
                $this->errors->accessDenied();
                break;
            }

            $this->setCurrentType(self::TYPE_COMPANY);

            $p = $this->input->postm(array(
                'company_id' => TYPE_UINT,
                'title'      => array(TYPE_NOTAGS, 'len'=>150),
                'content'    => array(TYPE_STR, 'len'=>30000),
            )); extract($p);

            if ( ! $this->security->validateToken()) {
                $this->errors->accessDenied();
                break;
            }

            # данные о компании
            if ( ! $company_id) {
                $this->errors->reloadPage(); break;
            }
            $companyData = Items::model()->companyData($company_id);
            if (empty($companyData) || $companyData['agent_id'] != $userID) {
                $this->errors->reloadPage(); break;
            }

            if (empty($title)) {
                $this->errors->set(_t('pub', 'Укажите заголовок'), 'title');
            }

            $parser = new \bff\utils\TextParser();
            $content = $parser->parseWysiwygTextFrontend($content);
            if (mb_strlen(strip_tags($content)) <= 10) {
                $this->errors->set(_t('pub', 'Укажите текст новости'));
            }

            if ( ! $this->errors->no()) break;

            if (Site::i()->preventSpam('pub-submit-company', 60)) {
                break;
            }

            $aData = array(
                'publicated' => $this->db->now(),
                'moderated'  => 0,
                'enabled'    => 1,
                'user_id'    => $userID,
                'company_id' => $company_id,
                'title'      => array(),
                'content'    => array(),
                'link'       => '',
                'country_id' => $companyData['country_id'],
                'city_id'    => $companyData['city_id'],
            );

            foreach ($this->locale->getLanguages() as $lng) {
                $aData['title'][$lng] = $title;
                $aData['content'][$lng] = $content;
            }

            $nItemID = $this->model->itemSave(0, $aData);
            if( ! $nItemID) break;

            # подготавливаем заголовок + ссылку
            if ($this->prepareItemTitle($nItemID, $aData)) {
                $this->model->itemSave($nItemID, array(
                    'title' => $aData['title'],
                    'title_params' => $aData['title_params'],
                    'link' => $aData['link']));
            }

            # загружаем изображение
            $oImages = $this->initImages(array(
                'id' => $nItemID,
                'publicated' => $aData['publicated'],
            ));
            $oImages->upload('img');

            $this->itemsModerationCounter(self::TYPE_COMPANY, 1);

        } while (false);

        $this->iframeResponseForm();
    }

    /**
     * Список новостей компании
     * @param integer $companyID ID компании
     * @param array $companyData @ref данные о компании
     */
    public function company_news($companyID = 0, array &$companyData)
    {
        $perpage = config::sys('publications.company.perpage', 10);
        $this->setCurrentType(self::TYPE_COMPANY);
        $total = $this->model->itemsListCompany($companyID, true);
        $sqlLimit = '';
        $data['pgn'] = $this->generatePagenationDots($total, $perpage, 3,
            Items::url('view', array('link'=>$companyData['link'], 'tab'=>'news', 'q'=>'page={page}')),
            $sqlLimit);

        $data['items'] = $this->model->itemsListCompany($companyID, false, $sqlLimit);
        foreach($data['items'] as &$v)
        {
            $v['img'] = ($v['img'] ? $this->getImagesPath(true, array('id'=>$v['id'], 'publicated'=>$v['publicated'],
                        'filename'=>$v['img'], 'size'=>PublicationsImages::szNormal)) : false);
            $v['link'] = static::url('view', $v['link']);
            $v['title'] = static::urlInTitle($v['title']);
        } unset($v);

        if (User::isCurrent($companyData['agent_id'])) {
            $data['form'] = $this->viewPHP($companyData, 'form', $this->typeTemplatesDir);
        }

        return $this->viewPHP($data, 'listing.company', $this->typeTemplatesDir);
    }

    protected function initRightblock($sPage, $aExtra = array())
    {
        $aData = array('calendar'=>false, 'voting'=>false, 'top'=>false, 'categories'=>false, 'extra'=>$aExtra);
        
        if($sPage!='view') {
            # отображаем календарь на всех страницах кроме просмотра публикации
            $aData['calendar'] = true;
        } else {
            # получаем 4шт. news, самых просматриваемых, за последние 3 дня
            $aData['top'] = $this->db->select('
                  SELECT IL.title
                  FROM '.$this->getItemsTable(self::TYPE_NEWS).' I, '.TABLE_PUB_ITEMS_LANG.' IL
                  WHERE I.enabled = 1 '.$this->model->langAnd(self::TYPE_NEWS, true, 'I', 'IL').'
                     '.( $this->regionsFilterEnabled() ? ' AND I.city_id IN(0,'.Geo::cityID().') ' : '' ).'
                     AND DATE(publicated)>'.$this->db->str2sql(date('Y-m-d', strtotime('-3 days'))).'
                  ORDER BY I.views DESC
                  LIMIT 4');
            if (!empty($aData['top'])) {
                foreach ($aData['top'] as &$v) {
                    $v['title'] = static::urlInTitle($v['title']);
                } unset($v);
            }
        }
        switch ($sPage)
        {
            case 'news_all': # Список: по 4 публикации из каждой категории (type)
            {
                //$aData['voting'] = true;
            } break;
            case 'video_all':
            case 'listing_all': # Список всех публикаций определенного типа (type)
            case 'listing_category': # Список публикаций выбранного раздела (type)
            {
                $aData['categories'] = true;
                if(in_array($this->type->id, array(self::TYPE_ARTICLES, self::TYPE_VIDEO))) {
                    $aData['calendar'] = false;
                }
            } break;
            case 'view': # Просмотр публикации (type)
            {
                $aData['categories'] = true;
            } break;
            case 'listing_date': # Список всех публикаций всех типов за день
            {

            } break;
        }

        bff::setRightblock( $this->viewPHP($aData, 'common.rightblock'), true );
    }

    public function ajax()
    {
        if(!Request::isAJAX())
            $this->ajaxResponse(Errors::IMPOSSIBLE);

        switch ($this->input->getpost('act'))
        {
            case 'calendar': # получение активных дат на календаре
            {
                $aResult = array('res'=>false,'events'=>array());
                $sDate = $this->input->post('date', TYPE_NOTAGS);
                $nDate = $this->_checkDate($sDate);
                if ($nDate !== false) {
                    $aResult['events'] = $this->calendarGetActiveDates($nDate, false);
                    $aResult['res'] = true;
                }
                
                $this->ajaxResponse($aResult, 2, true);
            } break;
            case 'video-index-items': # главная: список видео публикаций в категории
            {
                $nCatID = $this->input->post('cat', TYPE_UINT);
                $this->setCurrentType(self::TYPE_VIDEO);
                $this->ajaxResponseForm(array(
                    'html' => $this->indexBlockVideoItems($nCatID),
                ));
            } break;
            case 'video-validate': # видео: проверка корректности видео ссылки / кода
            {
                if( ! User::id()) $this->ajaxResponse(Errors::IMPOSSIBLE);

                $sCode = $this->input->post('code', TYPE_STR);
                $this->ajaxResponse(PublicationsVideo::validate($sCode));
            } break;
        }
        
        $this->ajaxResponse(Errors::IMPOSSIBLE);
    }

    protected function _checkDate($sDate)
    {
        if (empty($sDate) || !preg_match('/[\d]{4}-[\d]{2}-[\d]{2}/', $sDate)) {
            return false; 
        }
        $nDate = strtotime($sDate);
        if($nDate === -1 || $nDate === false || $nDate < 342133200) # не удалось определить дату, либо дата ранее 1980 года :)
            return false;
        
        return $nDate;
    }

    public function rss($typeID, $typeKey)
    {
        header('Content-type: text/xml; charset=UTF-8');
        echo $this->buildRSS($typeID);
        exit;
    }

    // --------------------------------------------------------------------------------------------------
    // PDA

    public function pda_index()
    {
        $sqlLimit = $this->db->prepareLimit(0, 3);

        # получаем по 3 новости из:
        # -------------------------------
        # Новостей
        $aData['news'] = 
            array( 't' => _t('pub','Новости'),
                   'listLink' => static::url('list', self::TYPE_NEWS),
                   'last' => $this->db->select('
                        SELECT I.id, L.title
                        FROM '.$this->getItemsTable(self::TYPE_NEWS).' I, '.TABLE_PUB_ITEMS_LANG.' L
                        WHERE I.enabled = 1 AND I.moderated = 1 '.
                           $this->model->langAnd(self::TYPE_NEWS, true, 'I', 'L').
                           ( $this->regionsFilterEnabled() ? ' AND I.city_id IN(0,'.Geo::cityID().') ' : '' ).'
                        ORDER BY I.publicated DESC' . $sqlLimit) );

        # Фоторепортажей
        $aData['reports'] = 
            array( 't' => _t('pub','Фоторепортажи'),
                   'listLink' => static::url('list', self::TYPE_REPORTS),
                   'last' => $this->db->select('
                        SELECT I.id, L.title
                        FROM '.$this->getItemsTable(self::TYPE_REPORTS).' I, '.TABLE_PUB_ITEMS_LANG.' L
                        WHERE I.enabled = 1 AND I.moderated = 1 '.
                           $this->model->langAnd(self::TYPE_REPORTS, true, 'I', 'L').
                           ( $this->regionsFilterEnabled() ? ' AND I.city_id IN(0,'.Geo::cityID().') ' : '' ).'
                        ORDER BY I.publicated DESC' . $sqlLimit) );
                
        # Статей
        $aData['articles'] =
            array( 't' => _t('pub','Статьи'),
                   'listLink' => static::url('list', self::TYPE_ARTICLES),
                   'last' => $this->db->select('
                        SELECT I.id, L.title
                        FROM '.$this->getItemsTable(self::TYPE_ARTICLES).' I, '.TABLE_PUB_ITEMS_LANG.' L
                        WHERE I.enabled = 1 AND I.moderated = 1 '.
                           $this->model->langAnd(self::TYPE_ARTICLES, true, 'I', 'L').
                           ( $this->regionsFilterEnabled() ? ' AND I.city_id IN(0,'.Geo::cityID().') ' : '' ).'
                        ORDER BY I.publicated DESC' . $sqlLimit) );

        return $aData;
    }
    
    public function pda_list($typeID, $typeKey)
    {
        $nDate = $this->pda_prepareDate( $this->input->getpost('date', TYPE_NOTAGS), $bToday, true ); // => "YYYY-MM-DD"
        $sqlDate = $this->db->str2sql( date('Y-m-d', $nDate) );
        
        $aData['t'] = $this->type->title;
        $aData['list_url'] = static::url('list', $typeID);
        $aData['items'] = $this->db->select('
            SELECT I.id, L.title, I.publicated
            FROM '.$this->getItemsTable($typeKey).' I, '.TABLE_PUB_ITEMS_LANG.' L
            WHERE I.enabled = 1 AND I.moderated = 1 '.
                $this->model->langAnd($typeID, true, 'I', 'L').
                ( $this->regionsFilterEnabled() ? ' AND I.city_id IN(0,'.Geo::cityID().') ' : '' ).'
                AND DATE(I.publicated) = '.$sqlDate.'
            ORDER BY I.publicated DESC' . $this->db->prepareLimit(0,6) );
        if ( ! empty($aData['items'])) {
            foreach ($aData['items'] as &$v) {
                $v['title'] = static::urlInTitle($v['title']);
            } unset($v);
        }

        # SEO: Список (mobile)
        $this->urlCorrection(static::url('list', array('type'=>$typeID)));
        $this->seo()->canonicalUrl(static::url('list', array('type'=>$typeID), true), array('date'=>date('Y-m-d', $nDate)));
        $this->setMeta('list-mobile-'.$typeID, array(
            'date'   => tpl::date_format2($nDate, false, false, ' ', ', ', true),
            'date2'  => tpl::date_format2($nDate, false, false),
            'date3'  => tpl::dateFormat($nDate),
        ), $aData);

        $aData['days'] = $this->pda_daysRibbon($nDate, static::url('list', array('type'=>$typeID, 'date'=>'')));
        return $this->viewPHP($aData, 'pda.list');
    }
    
    public function pda_view($typeID, $typeKey)
    {
        $nItemID = $this->input->get('id', TYPE_UINT);

        $aData = $this->db->one_array('
            SELECT I.id, I.link, L.title, L.title_alt, I.publicated, I.img, L.content_short, I.content, L.author, I.extra_source_link,
                L.mtitle, L.mkeywords, L.mdescription, I.mtemplate, L.share_title, L.share_description, L.share_sitename
            FROM '.$this->itemsTable.' I, '.TABLE_PUB_ITEMS_LANG.' L
            WHERE I.id = :id AND I.enabled = 1 '.$this->model->langAnd($typeID, true, 'I', 'L'), array(
                ':id' => $nItemID
        ));
        if (empty($aData)) {
            $this->errors->error404();
        }

        $imgSize = PublicationsImages::szNormal;
        switch ($typeID) {
            case self::TYPE_NEWS: {
            } break;
            case self::TYPE_ARTICLES:
            case self::TYPE_REPORTS: {
            } break;
        }
        
        if (!empty($aData['img'])) {
            $aData['img_small'] = $this->getImagesPath(true, array('id'=>$nItemID, 'publicated'=>$aData['publicated'],
                    'filename'=>$aData['img'], 'size'=>'s'));
            $aData['img'] = $this->getImagesPath(true, array('id'=>$nItemID, 'publicated'=>$aData['publicated'],
                    'filename'=>$aData['img'], 'size'=>$imgSize));
        }
        $aData['title'] = strip_tags($aData['title']);
        $aData['extra_source_link'] = unserialize($aData['extra_source_link']);

        # соседние записи
        $aData['inDay'] = $this->db->select('SELECT id, link FROM '.$this->itemsTable.'
                WHERE enabled = 1 AND DATE(publicated) = DATE(:date)
                ORDER BY publicated DESC', array(':date'=>$aData['publicated']));
        $aData['inDayPos'] = 1;
        if (!empty($aData['inDay'])) {
            $aData['prev'] = $aData['next'] = false;
            foreach ($aData['inDay'] as $k=>$v) {
                $aData['inDay'][$k]['link'] = static::url('view', $v['link']);
            }
            foreach ($aData['inDay'] as $k=>$v) {
                if ($v['id'] == $nItemID) {
                    if (isset($aData['inDay'][$k-1])) {
                        $aData['prev'] = $aData['inDay'][$k-1]['link'];
                    }
                    $aData['inDayPos'] = $k+1;
                    if (isset($aData['inDay'][$k+1])) {
                        $aData['next'] = $aData['inDay'][$k+1]['link'];
                    }
                }
            }
        }

        # схожие публикации: получаем по пересекающимся тегам
        $aData['related'] = $this->db->select('
            SELECT I.id, L.title, COUNT(*) AS cnt
            FROM '.$this->itemsTable.' AS I,
                 '.TABLE_PUB_ITEMS_LANG.' L,
                 '.TABLE_PUB_TAGS_IN.' AS T
            WHERE I.id = T.item_id
              '.( $this->regionsFilterEnabled() ? ' AND I.city_id IN(0,'.Geo::cityID().') ' : '' ).
               $this->model->langAnd($typeID, true, 'I', 'L').'
              AND T.tag_id IN (SELECT tag_id FROM '.TABLE_PUB_TAGS_IN.' WHERE item_id = :item AND type_id = :type)
              AND I.id != :item
              AND I.enabled = 1 AND I.moderated = 1
            GROUP BY I.id
            ORDER BY cnt DESC, I.publicated DESC
            LIMIT 3', array(':item'=>$nItemID, ':type'=>$typeID));
        if ( ! empty($aData['related'])) {
            foreach ($aData['related'] as &$v) {
                $v['title'] = static::urlInTitle($v['title']);
            } unset($v);
        }

        # SEO: Просмотр публикации (mobile)
        $aData['link'] = static::url('view', $aData['link']);
        $this->urlCorrection($aData['link']);
        $this->setMeta('view-mobile', array(
            'title'       => $aData['title'],
            'description' => tpl::truncate($aData['content_short'], 150),
            'type'        => $this->type->title,
            'region'      => Geo::filter('title'),
        ), $aData);
        $this->seo()->setSocialMetaOG($aData['share_title'], $aData['share_description'], array($aData['img']), $aData['link'], $aData['share_sitename']);

        $aData['t'] = $this->type->title;
        $aData['list_url'] = static::url('list', $typeID);
        return $this->viewPHP($aData, 'pda.view');
    }

    protected function pda_daysRibbon($nDate, $sDateLink, $sLinkPostfix = '')
    {
        $aData = array(
            'date'      => $nDate, 
            'date_link' => $sDateLink,
            'date_link_postfix' => $sLinkPostfix,
        );
        return $this->viewPHP($aData, 'pda.days.ribbon');
    }

    protected function pda_prepareDate($sDate, &$bToday, $bNowIfEmpty = true)
    {
        $mResult = $bToday = false;
        
        do {
            if ($sDate=='' || strlen($sDate)<10 || !preg_match('/[\d]{4}-[\d]{2}-[\d]{2}/', $sDate)) {
                break;
            }
            $nDate = strtotime( $sDate );
            if ($nDate === -1 || $nDate === false || $nDate < 342133200) # не удалось определить дату, либо дата ранее 1980 года :)
                break;

            $mResult = $nDate;
        } while(false);
        
        if ($mResult === false)
        {
            if($bNowIfEmpty) {
                $mResult = mktime(0,0,0); # текущая дата без времени, Y-m-d 00:00:00
                $bToday = true;
            }
        } else {
            if( mktime(0,0,0) == strtotime( date('Y-m-d', $nDate) ) ) {
                $bToday = true;
            }
        }
        
        return $mResult;
    }

    protected function setActiveMenu($typeID, $typeKey = '', $bSubHoverOnly = false, $bUpdateMeta = true)
    {
        $aTypeToMenuPath = array(
            self::TYPE_NEWS     => '//news',
            self::TYPE_ARTICLES => '//articles',
            self::TYPE_REPORTS  => '//news',
            self::TYPE_NAROD    => '//news',
            self::TYPE_COMPANY  => '//news',
            self::TYPE_VIDEO    => '//video',
        );
        $sMenuPath = $aTypeToMenuPath[$typeID].( ! empty($typeKey) && $typeID != self::TYPE_ARTICLES ? '/'.$typeKey : '' );
        return bff::setActiveMenu($sMenuPath, $bSubHoverOnly, $bUpdateMeta);
    }

}